//
// Sawmill Source Code
// 
// This source code is the intellectual property of Flowerfire,
// and is protected by federal trade secret laws.  Do not
// redistribute, modify, or use this source code, except to compile
// it, without the express written consent of Flowerfire.
//
// For more information, see http://www.sawmill.net/trade_secret.html
//
// The trial and full commercial licenses for Sawmill allow you
// to use the program, and to compile it from this source code,
// but you are not permitted to look at this source code.  Please
// do not attempt to use this source code for any purpose other 
// than compilation!



















































 const char *S98d97f32b9130de5c8e0491fe8cd9ba4[] = { "##\n", "## Language Module -- Documentation\n", 
"##\n", "## This is the Documentation section of the default English language module\n", "##\n", "\n", 
"\n", "##\n", "## toc documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_toc \"Table of Contents\"\n", 
"DOCS_PAGE_CONTENTS_toc\n", "\"<b>Getting Started:</b><p>\n", "<ul>\n", "  <li> [docs-installation]\n", 
"  <li> [docs-iiscgi]\n", "  <li> [docs-troubleshooting]\n", "  <li> [docs-sdinfo]\n", "  <li> [docs-webservers]\n", 
"  <li> [docs-webstarv]\n", "  <li> [docs-adminmenu]\n", "  <li> [docs-using]\n", "  <li> [docs-statspages]\n", 
"  <li> [docs-poweruse]\n", "  <li> [docs-faq]\n", "</ul>\n", "<b>Configuration:</b><p>\n", "<ul>\n", 
"  <li> [docs-configpage]\n", "  <li> [docs-options]\n", "  <li> [docs-commandline]\n", "  <li> [docs-configfiles]\n", 
"  <li> [docs-multipleusers]\n", "  <li> [docs-handconfig]\n", "</ul>\n", "<b>Other Topics:</b><p>\n", 
"<ul>\n", "  <li> [docs-logfiles]\n", "  <li> [docs-database]\n", "  <li> [docs-dbdetail]\n", "  <li> [docs-filters]\n", 
"  <li> [docs-rewriterules]\n", "  <li> [docs-pathnames]\n", "  <li> [docs-hierarchies]\n", "  <li> [docs-xref]\n", 
"  <li> [docs-regexp]\n", "  <li> [docs-security]\n", "  <li> [docs-permissions]\n", "  <li> [docs-password]\n", 
"  <li> [docs-resources]\n", "  <li> [docs-customformats]\n", "  <li> [docs-scheduling]\n", "  <li> [docs-languagemodules]\n", 
"  <li> [docs-logformats]\n", "  <li> [docs-screeninfo]\n", "  <li> [docs-relabelling]\n", "  <li> [docs-credits]\n", 
"  <li> [docs-copyright]\n", "</ul><p>\n", 
#ifdef SAWMILL
 "If you want to print the {PRODUCT_NAME} documentation, please use the PDF version\n", "of the documentation, included in the {PRODUCT_NAME} installation.\n", 

#endif
 "\"\n", "\n", "\n", "##\n", "## installation documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_installation \"Installation\"\n", 
"DOCS_PAGE_CONTENTS_installation\n", "\"{PRODUCT_NAME} can run either in web server mode (stand-alone) \n", 
"or in CGI mode.  If you plan to run {PRODUCT_NAME} in web server mode, please see the section below \n", 
"called <b>Web Server Mode Installation</b>.  If you plan to \n", "run it as a CGI program, under an existing web server, please see the section \n", 
"below, called <b>CGI Mode Installation</b>.  If you don't know which way you want to install it, \n", 
"see the section below called <b>Web Server Mode or CGI Mode?</b>.<p> \n", "\n", "<h3>Web Server Mode or CGI Mode?</h3> \n", 
"\n", "This section helps you decide whether you want to run {PRODUCT_NAME} in %22web server mode,%22 \n", 
"or in %22CGI mode.%22  In web server mode, {PRODUCT_NAME} runs its own web server, and \n", "serves statistics using it.  In CGI mode, {PRODUCT_NAME} runs as a CGI program under another web server. \n", 
"In both modes, you access {PRODUCT_NAME} through a web browser on your desktop.<p>\n", "If you already know which mode you want, you can skip to the section below \n", 
"on installing in that mode.<p>\n", "In brief, web server mode is ideal if you want installation to be as easy as possible. \n", 
"CGI mode is better if your log files are on a remote web server that you have only limited access to, \n", 
"and/or if you want {PRODUCT_NAME} to be very robust (always be available).<p> \n", "<p>\n", "Here are the full details of the advantages and disadvantages of web server mode vs. CGI mode:<p>\n", 
"Advantages of Web Server Mode:<p>\n", "<ul> \n", "  <li> {PRODUCT_NAME} is <i>extremely</i> simple to install in web server mode. \n", 
"       You just run it, point your browser at it, choose a \n", "       password, and you're ready to start using it.  In CGI mode, the \n", 
"       startup process is considerably more involved.<p> \n", "  <li> The {PRODUCT_NAME} Scheduler is available.  In CGI mode, the Scheduler is not easily available; \n", 
"       an external scheduler must be used to schedule database builds/updates/etc.<p>\n", "  <li> {PRODUCT_NAME} shows progress better during long operations in web server mode, \n", 
"       especially if you're using Internet Explorer.<p>\n", "</ul> \n", "Advantages of CGI mode:<p> \n", 
"<ul> \n", "  <li> In CGI mode, {PRODUCT_NAME} only uses memory and other resources while it's actively in \n", 
"       use.  In web server mode, {PRODUCT_NAME} uses memory even \n", "       when it isn't being used.<p> \n", 
"  <li> There is no extra configuration required to start {PRODUCT_NAME} at system boot time-- it is always available.<p>\n", 
"  <li> In CGI mode, {PRODUCT_NAME} can use the services of the web server that's running it.\n", "       This makes it possible to use HTTPS, server authentication, and other powerful server\n", 
"       features with {PRODUCT_NAME}.<p>\n", "  <li> In some environments, web server mode may not be possible or \n", 
"       permissible, due to restrictions of the server, firewall \n", "       limitations, and other considerations.  For instance, if you \n", 
"       have only FTP access to your web server, and you want to run {PRODUCT_NAME} \n", "       on the server, you <i>must</i> use CGI mode.<p> \n", 
"  <li> Because CGI mode uses a separate process for each request, there is less chance of\n", "       server threads interfering with each other.  This makes CGI mode more stable, especially\n", 
"       if multiple actions are occurring at the same time.<p>\n", "</ul><p> \n", "\n", "After you decide which mode you want to use, please continue with either \n", 
"<b>Web Server Mode Installation</b> or <b>CGI Mode Installation</b> below, \n", "depending on your choice.<p>\n", 
"\n", "\n", "<h3>Web Server Mode Installation</h3>\n", "{PRODUCT_NAME} ships as a single file.  This file needs to be installed \n", 
"differently depending on the platform you intend to run it on: \n", "<ul> \n", "  <li> <b>Windows</b>: {PRODUCT_NAME} ships as a standard Windows installer.  Just \n", 
"       double-click the program to start the installer, and follow the \n", "       instructions.<p>\n", 
"       Once {PRODUCT_NAME} is installed, you can start using it \n", "       by running the {PRODUCT_NAME}6 program ({PRODUCT_NAME}6.exe), either from the Start menu,\n", 
"       or by double-clicking its icon.  Once it's running, click Use {PRODUCT_NAME} to start \n", "       using it.<p> \n", 
"\n", "  <li> <b>MacOS</b>: {PRODUCT_NAME} ships as a BinHexed self-extracting archive. \n", "       If the download process does not automatically un-BinHex the file, \n", 
"       then the name will end with .hqx, and it must be un-BinHexed using \n", "       a tool like Aladdin's free \n", 
"       <a href=http://www.aladdinsys.com/expander/>StuffIt Expander</a>.\n", "       Once it is un-BinHexed, \n", 
"       the filename will end with .sea, and it can be double-clicked to \n", "       extract itself into a folder (Expander will also extract it automatically).\n", 
"       If Expander complains that the file is corrupt, you probably have an old \n", "       version of Expander, and you will need to extract it manually by \n", 
"       double-clicking the .sea file.<p> \n", "       Once {PRODUCT_NAME} is installed, you can start using it by double-clicking the {PRODUCT_NAME} \n", 
"       application icon (in the installation folder).\n", "       Once it's running, click Use {PRODUCT_NAME} to start using it.<p> \n", 
"\n", "  <li> <b>UNIX</b>: {PRODUCT_NAME} ships as a gzipped tar archive file. \n", "       You need to transfer that to the UNIX machine where you'll be running {PRODUCT_NAME}, \n", 
"       if it's not already there.  Then you'll need to open a %22shell%22 prompt \n", "       using telnet, ssh, or some other way of getting to the UNIX command line. \n", 
"       Next, gunzip and untar the file using the following command:<p>\n", "       <pre>  gunzip -c ({PRODUCT_EXECUTABLE_DOCS}.tgz) | tar xf -</pre> \n", 
"       (you will need to change ({PRODUCT_EXECUTABLE_DOCS}.tgz) to match the name \n", "       of the file you downloaded).<p> \n", 
"       Once the archive is uncompressed and extracted, you can \n", "       run {PRODUCT_NAME} by changing to the installation directory, and \n", 
"       typing the name of the executable file from the command line:<p> \n", "       <pre>  cd (installation-directory)\n", 
"  ./{PRODUCT_EXECUTABLE_DOCS}</pre> \n", "       (you may need to change the filename to match the actual version you downloaded). \n", 
"       {PRODUCT_NAME} will start running, and it will start its own web server on \n", "       the UNIX machine (using port 8987, so it won't conflict with any web server \n", 
"       you may already be running there).  To start using {PRODUCT_NAME}, copy the URL \n", "       printed by {PRODUCT_NAME} in your window, and paste it into the URL field of your \n", 
"       web browser, and press return.  You should see {PRODUCT_NAME} appear in your web browser window.<p>\n", 
"       Note: You can add a single ampersand (&) to the end of the command line that starts {PRODUCT_NAME}, \n", 
"       to run {PRODUCT_NAME} %22in the background,%22 which allows you to close your terminal window \n", 
"       without killing {PRODUCT_NAME}.  On some systems, you may also need to add %22nohup%22 to the beginning \n", 
"       of the command line for this to work properly.<p>\n", "</ul> \n", "This is the end of the web server installation instructions.  If you have any problems \n", 
"installing {PRODUCT_NAME} in web server mode, please see <b>Troubleshooting Web Server Mode</b>, below.<p>\n", 
"<p>\n", "\n", "\n", "<h3>CGI Mode Installation</h3>\n", "\n", "To install {PRODUCT_NAME} in CGI mode, you will need to extract the {PRODUCT_NAME} program, \n", 
"and copy it to your web server's CGI directory.<p>\n", "\n", "IMPORTANT: There are different versions of {PRODUCT_NAME} for each platform (e.g. Windows, Macintosh, Linux, etc.),\n", 
"and a version designed for one platform will not work on another.\n", "In CGI mode, you must install the version of {PRODUCT_NAME} that matches your <b>server's</b> \n", 
"platform, <i>not</i> the version that matches your desktop computer.\n", "For instance, if you're running Windows at home, and you install {PRODUCT_NAME} \n", 
"on your ISP's web server, and the web server is running Linux, you need to install the \n", "Linux version of {PRODUCT_NAME} on the web server, not the Windows version. \n", 
"If you don't know what platform your web server is running, you can find out \n", "by asking your ISP or system administrator (if it's a UNIX system, you can also \n", 
"find out by logging in by telnet and typing %22uname -a%22).<p>\n", "\n", "Make sure you understand the previous paragraph!  And now download the correct version \n", 
"of {PRODUCT_NAME} (the one that matches your <i>web server</i> platforms).  Make sure you do\n", "the FTP download in BINARY mode, or {PRODUCT_NAME} will not work.<p>\n", 
"\n", "You install {PRODUCT_NAME} in CGI mode differently depending on the type of your web server. \n", 
"See [docs-webservers] if you need help finding your cgi-bin directory.<p>\n", "<ul>\n", "  <li> <b>UNIX with telnet access</b>.  If your server is UNIX or similar, and you have telnet access to your \n", 
"       server, then download the file to your server and gunzip/untar it according to the instructions \n", 
"       above (in the web server mode installation section).  Then move the executable file \n", "       (the large file whose name starts with %22{PRODUCT_EXECUTABLE_DOCS}%22)\n", 
"       from the installation directory to your cgi-bin directory, using this command:<p>\n", "       <pre>  cp (installation-directory)/{PRODUCT_EXECUTABLE_DOCS} (cgi-bin)/{PRODUCT_EXECUTABLE_DOCS}.cgi</pre> \n", 
"       You may need to change the name of {PRODUCT_EXECUTABLE_DOCS} to match the version you downloaded, \n", 
"       and you will definitely need to change the (cgi-bin) part to match your \n", "       web server's cgi-bin directory.<p>\n", 
"       You can access {PRODUCT_NAME} now using the URL http://(yourserver)/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi \n", 
"       replacing (yourserver) with the actual name of your server.  {PRODUCT_NAME} should \n", "       appear in the web browser window.\n", 
"       If it still doesn't work, see <b>Troubleshooting CGI Mode</b> below.<p>\n", "\n", "  <li> <b>UNIX with only FTP access</b>.  If your server is UNIX or similar, and you have only FTP access \n", 
"       to your server (you cannot log in and run commands by telnet, ssh, or in some other way), \n", 
"       then you need to do things a bit differently.  Here's how you do it:<p>\n", "       <ol>\n", 
"         <li> Download the file to your desktop system \n", "              (remember, you need the version that matches your <i>server</i>, not the version that matches your \n", 
"              desktop system).  Download in BINARY mode.<p>\n", "         <li> Use a gunzipping and untarring utility on your desktop system to decompress \n", 
"              the file (<a href=http://www.winzip.com/>WinZip</a> on Windows, \n", "              <a href=http://www.aladdinsys.com/expander/>StuffIt Expander</a> on Mac,\n", 
"              or gunzip/tar if your desktop is also UNIX).<p>\n", "         <li> Rename the {PRODUCT_EXECUTABLE_DOCS} file (the large files whose names begins with {PRODUCT_EXECUTABLE_DOCS})\n", 
"              to {PRODUCT_EXECUTABLE_DOCS}.cgi.<p>\n", "         <li> Upload {PRODUCT_EXECUTABLE_DOCS}.cgi to your server's cgi-bin directory.  Make sure you \n", 
"              use BINARY mode to do the transfer, or it won't work.<p>\n", "         <li> Make {PRODUCT_EXECUTABLE_DOCS}.cgi executable in your web server \n", 
"              using %22chmod 555 {PRODUCT_EXECUTABLE_DOCS}.cgi%22 if you're using a command-line FTP program, or using your \n", 
"              FTP program's permission-setting feature otherwise.<p>\n", "       </ol><p>\n", "       You can access {PRODUCT_NAME} now using the URL http://(yourserver)/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi \n", 
"       replacing (yourserver) with the actual name of your server.  {PRODUCT_NAME} should \n", "       appear in the web browser window.\n", 
"       If it still doesn't work, see <b>Troubleshooting CGI Mode</b> below.<p>\n", "\n", "  <li> <b>Windows</b>.  If your server is Windows, you need to upload the {PRODUCT_NAME}6CL.exe file \n", 
"       to your server's cgi-bin directory (Windows may hide the .exe part of the filename, but \n", 
"       that <i>is</i> its actual full filename).  The easiest way to get this file is to install \n", 
"       the Windows version of {PRODUCT_NAME} on a local Windows desktop machine, and then look in the {PRODUCT_NAME} \n", 
"       installation directory (C:\\Program Files\\{PRODUCT_NAME}\\ by default); the {PRODUCT_NAME}6CL.exe file \n", 
"       will be there.  If you don't have access to a Windows machine locally, please contact \n", "       <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a> and we will send you \n", 
"       the file.  Make sure you do the upload in BINARY mode, or {PRODUCT_NAME} will not work! \n", 
"       Once you've uploaded it to your cgi-bin directory, you can access it using \n", "       the URL http://(yourserver)/cgi-bin/{PRODUCT_NAME}6CL.exe (replace yourserver with the name of \n", 
"       your domain).  {PRODUCT_NAME} should appear in the web browser window.\n", "       If it still doesn't work, see <b>Troubleshooting CGI Mode</b> below.<p>\n", 
"\n", "  <li> <b>MacOS</b>.  If your server is a Macintosh, you need to rename the {PRODUCT_NAME} application file \n", 
"       to {PRODUCT_NAME}.acgi, and upload it to your server's cgi-bin directory. \n", "       The easiest way to get this file is to install \n", 
"       the MacOS version of {PRODUCT_NAME} on a local MacOS desktop machine, and then look in the {PRODUCT_NAME} \n", 
"       installation directory; the {PRODUCT_NAME} application file \n", "       will be there.  If you don't have access to a MacOS machine locally, please contact \n", 
"       <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a> and we will send you \n", "       the file.  Make sure you upload the file in MacBinary mode, or {PRODUCT_NAME} will not work! \n", 
"       Once you've uploaded it to your cgi-bin directory, you can access it using \n", "       the URL http://(yourserver)/cgi-bin/{PRODUCT_NAME}.acgi (replace yourserver with the name of \n", 
"       your domain).  {PRODUCT_NAME} should appear in the web browser window.\n", "       If it still doesn't work, see <b>Troubleshooting CGI Mode</b> below.<p>\n", 
"</ul><p>\n", "\n", "\n", "<h3>Troubleshooting Web Server Mode</h3>\n", "\n", "If {PRODUCT_NAME} is not working in web server mode (if you're not getting a page back \n", 
"when you enter the URL, or if you're getting an error page), try these suggestions:<p>\n", "<ol>\n", 
"  <li> Make sure you installed the version of {PRODUCT_NAME} that matches the computer you're running {PRODUCT_NAME} on\n", 
"       (for instance, you can't run the Solaris version of {PRODUCT_NAME} on Windows).\n", "       If there were several choices available for your platform (e.g. Old and New, static and dynamic), \n", 
"       try all of them.<p>\n", "  <li> Make sure you downloaded {PRODUCT_NAME} in BINARY mode.<p>\n", 
"  <li> In UNIX, make sure the {PRODUCT_NAME} program is executable.<p>\n", "  <li> Contact <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>.<p>\n", 
"</ol><p>\n", "There are more troubleshooting suggestions in [docs-troubleshooting].<p>\n", "\n", "\n", 
"<h3>Troubleshooting CGI Mode</h3>\n", "\n", "If {PRODUCT_NAME} is not working in CGI mode (if you're not getting a page back \n", 
"when you enter the URL), try these suggestions:<p>\n", "<ol>\n", "  <li> Make sure you installed the version of {PRODUCT_NAME} that matches your server, not your desktop system.\n", 
"       If there were several choices available for your platform (e.g. Old and New, static and dynamic), \n", 
"       try all of them.<p>\n", "  <li> Make sure you uploaded the {PRODUCT_NAME} program in BINARY mode (or on MacOS, MacBinary mode).<p>\n", 
"  <li> On UNIX, make your cgi-bin directory writable, using %22chmod a+w (cgi-bin)%22 if you have telnet access, \n", 
"       or using your FTP client's %22change permissions%22 feature if you have only FTP access.<p>\n", 
"  <li> Create a directory called LogAnalysisInfo in your cgi-bin directory, using \n", "       %22mkdir (cgi-bin)/LogAnalysisInfo%22 on UNIX with telnet access, or \n", 
"       using your FTP client's %22make directory%22 feature if you don't have telnet access.\n", "       If your server is UNIX, also make it writable using %22chmod a+rwx (cgi-bin)/LogAnalysisInfo%22 if you have telnet access,\n", 
"       or using your FTP client's %22change permissions%22 feature if you have only FTP access.<p>\n", 
"  <li> Contact <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>.  If you're having trouble, \n", 
"       we will install {PRODUCT_NAME} for you at no cost, even if it's just the trial version.<p>\n", 
"</ol><p>\n", "There are more troubleshooting suggestions in [docs-troubleshooting].<p>\n", "\n", "\"\n", 
"##\n", "## iiscgi documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_iiscgi \"Installing {PRODUCT_NAME} as a CGI program under IIS\"\n", 
"DOCS_PAGE_CONTENTS_iiscgi\n", "\"\n", "<p><i>This chapter was contributed by a customer.</i></p>\n", 
"<p>This describes how to install {PRODUCT_NAME} in CGI mode under IIS.\n", "It was done on IIS 4 (NT 4, SP6a) in this example, but the basic method should work for any IIS installation.</p>\n", 
"<p><b>CGI based or {PRODUCT_NAME} Web Server?</b><br>\n", "  There are two ways to install {PRODUCT_NAME}-- as a CGI program or as a web server.\n", 
"  this document deals only with CGI mode installation.  See [docs-installation] for\n", "  information about web server mode, and the advantages and disadvantages of each way.\n", 
"  Because of the security issues involved with installing {PRODUCT_NAME} under IIS,\n", "  web server mode may be a better solution for Windows installation-- in web server mode\n", 
"  none of the following configuration steps are necessary.</p>\n", "<p><b>Initial Installation</b><br>\n", 
"  Start following the CGI installation instructions ([docs-installation]).\n", "  on some installations of IIS, that's all that is needed.  If you're able to see\n", 
"  the Administrative Menu with images in your CGI installation, then you're done.  If \n", "  you have problems, continue on:</p>\n", 
"<p><b>URLScan</b><br>\n", "  One common source of problems is URLScan.  \n", "  Microsoft has a tool called &quot;IIS Lockdown&quot; to help block all those nasty \n", 
"  worms. By default, URLScan blocks are attempts \n", "  to run EXE (among many other things) files on the system.  Unfortunately, this also blocks \n", 
"  all accesses to {PRODUCT_NAME}, which is a EXE file.  By editing the \n", "  EXE blocking, and giving all the {PRODUCT_NAME} directories FULL permissions, you can \n", 
"  it to work.  This is a simple approach, but not very secure.  A more secure approach is\n", "  described below.</p>\n", 
"<p>&nbsp; </p>\n", "<p><font size=%225%22><b>Installation Procedures:</b></font></p>\n", "<p><b>{PRODUCT_NAME} Directories:</b><br>\n", 
"  {IMAGE:docs_wwwroot_directory.gif}<br>\n", "  You would need the following Directories:<br>\n", "  <br>\n", 
"  %7BBASE%7D\\inetpub\\wwwroot\\ ==&gt;<b> your website</b><br>\n", "  %7BBASE%7D\\inetpub\\sawmill<br>\n", 
"  %7BBASE%7D\\inetpub\\cgi-bin\\ <br>\n", "  %7BBASE%7D\\inetpub\\cgi-bin\\LogAnalysisInfo (sawmill creates this automatically)</p>\n", 
"<p>Initially give both cgi-bin and sawmill FULL permission.</p>\n", "<p><b>IIS Console setup:</b><br>\n", 
"  {IMAGE:docs_mmc1.gif}<br>\n", "  Created Virtual Directories (NT4 calls them web shares as well) for CGI-BIN \n", 
"  &amp; SAWMILL in IIS Management Console;</p>\n", "<p>{IMAGE:docs_cgibin_VD.gif}<br>\n", "  Both Virtual Directories are given Execution, and write, Rights (FULL permission)<br>\n", 
"  Make sure the &quot;Index this directory&quot; is checked <b>OFF</b><br>\n", "  (after the installation is completed we will come back and change this to a \n", 
"  more secure setting)<br>\n", "  Keep in mind the <b>\\cgi-bin</b> and and <b>\\sawmill</b> directories, are in \n", 
"  fact virtual directories under your website, and are not Physically under your \n", "  &quot;website&quot; directory.</p>\n", 
"<p><b>Execution and {PRODUCT_NAME} Installation:</b><br>\n", "  Once we have all the Subdirectories and Virtual directories in place then:<br>\n", 
"  <br>\n", "  - Copy &quot;sawmill6cl.exe&quot; to <b>%7BBASE%7D\\inetpub\\cgi-bin\\</b> directory.<br>\n", 
"  - Execute (run) &quot;sawmill6cl.exe&quot;<br>\n", "  - Following the {PRODUCT_NAME} Installation procedures from the manual <font color=%22#FF0000%22>&lt;link \n", 
"  to the {PRODUCT_NAME} documentation&gt;</font><br>\n", "  - Establish passwords and Temp Directory <b>%7BBASE%7D\\inetpub\\sawmill</b><br>\n", 
"  - Create your first &quot;configuration&quot;, and add the Log Files, and look \n", "  at the &quot;Statistics&quot;<br>\n", 
"  - <b>Enjoy your hard work ;-)</b></p>\n", "<p>&nbsp;</p>\n", "<p><b><font size=%225%22>Securing the Installation:</font></b><br>\n", 
"  {PRODUCT_NAME} needs access to many different subdirectories, which it automatically \n", "  creates when you execute the program, or try to view the statistics. Therefore, \n", 
"  it needs permissions to Write, Read , Create subdirectory, execute!!<br>\n", "  The reason we gave <b>FULL permission</b> rights to all the subdirectories was \n", 
"  the fact that {PRODUCT_NAME} creates many additional subdirectories during it's installation \n", 
"  routines. Therefore we need to give it the ability to create these subdirectories. \n", "  However, after the initial installation, we can take away permissions from <b>%7BBASE%7D\\inetpub\\cgi-bin\\</b> \n", 
"  and <b>%7BBASE%7D\\inetpub\\sawmill</b>, to run a more sure server.<br>\n", "  <br>\n", "  <b>%7BBASE%7D\\inetpub\\cgi-bin\\ : (File Manager)</b><br>\n", 
"  {IMAGE:docs_cgibin_permission.gif}<br>\n", "  I took away FULL permission from the <b>cgi-bin\\</b> directory, and gave it \n", 
"  <b>Read/Execute ONLY.</b><br>\n", "  Note: When you make the change here, make sure the &quot;Replace Permission \n", 
"  on Subdirectories&quot; is checked <b>OFF</b><br>\n", "  <br>\n", "  <b>%7BBASE%7D\\inetpub\\cgi-bin\\LogAnalysisInfo : (File Manager)</b><br>\n", 
"  Here, {PRODUCT_NAME} still needs to create directories for all additional websites, \n", "  or if there is any changes to the &quot;configuration&quot;. However, there \n", 
"  is no need to Execute and scripts here. So give <b>Read/Write/Delete</b> Permission<br>\n", "  Note: When you make the change here, make sure the &quot;Replace Permission \n", 
"  on Subdirectories&quot; is checked <b>ON</b></p>\n", "<p><b>%7BBASE%7D\\inetpub\\sawmill : (File Manager)</b><br>\n", 
"  {IMAGE:docs_sawmill_permission.gif}<br>\n", "  I took away FULL permission from the <b>sawmill\\</b> directory, and gave it \n", 
"  <b>Read/Write/Delete </b>permission, (no Execution)<br>\n", "  Note: When you make the change here, make sure the &quot;Replace Permission \n", 
"  on Subdirectories&quot; is checked <b>ON</b> </p>\n", "<p>&nbsp;</p>\n", "<p><b>\\cgi-bin : (IIS Console)<br>\n", 
"  {IMAGE:docs_cgibin_VD.gif}<br>\n", "  </b>I took away FULL permission from the cgi-bin\\ virtual directory, and gave \n", 
"  it <b>Read/Execute</b> permission.<br>\n", "  Note: Make sure the &quot;Index this directory&quot; is checked <b>OFF</b></p>\n", 
"<p><b>\\sawmill : (IIS Console)<br>\n", "  </b>{IMAGE:docs_sawmill_VD.gif}<br>\n", "  I took away FULL permission from the sawmill\\ virtual directory, and gave it \n", 
"  <b>Read/Write</b> permission. (No Execution)<br>\n", "  Note: Make sure the &quot;Index this directory&quot; is checked <b>OFF</b><br>\n", 
"</p>\n", "<p>&nbsp;</p>\n", "<p><b><font size=%225%22 color=%22#FF0000%22>NOW, your {PRODUCT_NAME} Installation on NT should \n", 
"  be complete !</font></b><br>\n", "  <br>\n", "  <br>\n", "  <br>\n", "  <font size=%225%22>Tips:</font></p>\n", 
"<p><b>1. cgi-bin Directory:</b><br>\n", "  By default there is a cgi-bin directory under the &quot;default web site&quot; \n", 
"  of the IIS. You could use this Virtual Directory under any Web Site. However, \n", "  if you try to delete the directory and create another one (IIS keeps the &quot;cgi-bin&quot; \n", 
"  in it's meta file !), it will show up as cgi-bin2 !!<br>\n", "  In order to fully delete the old cgi-bin, you will need to use <b>Microsoft \n", 
"  Meta Editor 2.2 </b>(mtaedt22.exe). PLEASE, do this with great care, you COULD \n", "  kill the whole IIS here!!!<br>\n", 
"  <br>\n", "  <b>2. {PRODUCT_NAME} Instances:</b><br>\n", "  During the installation / debugging, reduce to only one instance of {PRODUCT_NAME} \n", 
"  <br>\n", "  <br>\n", "  <b>3. DNS Lookup:</b><br>\n", "  I've also disabled &quot;DNS Lookup&quot;, in my {PRODUCT_NAME} Configurations. </p>\n", 
"<p><b>4. Open Files / IIS Index Server:</b><br>\n", "  In IIS, all Virtual Directories are Indexed by default. However, I think there \n", 
"  may be a conflict between {PRODUCT_NAME}, and the Index Server, due to Open Files. \n", "  My updates routinely crashed, and sometimes they even crashed the Server !<br>\n", 
"  after I disabled the Indexing on both sawmill\\ and cgi-bin\\ directories, I've \n", "  have very few issues with open files and {PRODUCT_NAME}.</p>\n", 
"<p><b>5. NT Server Scheduler:</b><br>\n", "  By default NT 4 does not have a Scheduler (Windows 200 server does). We used \n", 
"  the Schedule Wizard by <a href=%22http://www.authord.com%22 target=%22_blank%22>www.authord.com</a> \n", 
"  for periodical scheduling of events. You could even get a version which runs \n", "  as a service on NT.<br>\n", 
"  <br>\n", "  <b>6. URLScan.ini:</b><br>\n", "  I have blocked access to the following in the urlscan.ini file:<br>\n", 
"  cmd.exe<br>\n", "  root.exe<br>\n", "  shell.exe <br>\n", "  shtml.exe<br>\n", "  .bat<br>\n", "  .cmd<br>\n", 
"  .com<br>\n", "  .dll<br>\n", "  .pl<br>\n", "  .cgi<br>\n", "  .ini<br>\n", "  .dat<br>\n", "  .log </p>\n", 
"<p>&nbsp;</p>\n", "  Reference: <a href=%22http://www.microsoft.com/Downloads/Release.asp?ReleaseID=32571%22 target=%22_blank%22>Microsoft \n", 
"  URLScan Security Tool </a><br>\n", "  Reference: <a href=%22http://www.iisfaq.com/default.asp?View=A384&P=134%22 target=%22_blank%22>IISFAQ \n", 
"  - URLScan Setup</a></p>\n", "\"\n", "\n", "\n", "\n", "##\n", "## adminmenu documentation page text\n", 
"##\n", "\n", "DOCS_PAGE_TITLE_adminmenu \"The Administrative Menu\"\n", "DOCS_PAGE_CONTENTS_adminmenu\n", 
"\"There are two main menus for {PRODUCT_NAME}.  The Administrative Menu \n", "is designed for the {PRODUCT_NAME} administrator(s), and provides full access to\n", 
"{PRODUCT_NAME}'s features, including creating, editing, and deleting configurations, \n", "creating and updating databases, viewing statistics, and monitoring the built-in \n", 
"web server.  The User Menu is designed for {PRODUCT_NAME} users who are not \n", "administrators, and it provides only basic statistics browsing features.<p>\n", 
"\n", "You can get to the {PRODUCT_NAME} Administrative Main Menu by accessing the top-level \n", "page of the built-in web server (e.g. http://www.yourhost.com:8987/ for web server mode, or \n", 
"http://www.yourhostname.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi for CGI mode), or by \n", "explicitly specifying the menu using http://www.yourhost.com:8987/?admin for web server mode,\n", 
"or http://www.yourhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?admin for CGI mode.  You\n", "can get to the {PRODUCT_NAME} User Menu by accessing http://www.yourhost.com:8987/?user in web server mode,\n", 
"or http://www.yourhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?user in CGI mode. \n", "(if you add another parameter, http://www.yourhost.com:8987/?user+param or \n", 
"http://www.yourhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?user+param, then the menu\n", "will only contain configurations whose names start with param).\n", 
"When the [security_mode] is not browse_and_modify, the top-level page will point to \n", "User menu, rather than the Administrative menu.  If you don't want your users \n", 
"to see even the names of each others' configurations, you can also use \n", "http://www.yourhost.com:8987/?browse for web server, or\n", 
"http://www.yourhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?browse, which is similar to the User Menu, but \n", 
"requires users to type in their configuration name, rather than selecting it \n", "from a menu of choices.<p> \n", 
"\n", "The Administrative Menu contains several options:<p> \n", "<ol> \n", "  <li> <b>{VIEW_STATISTICS_FOR_BUTTON}</b>.  This appears if one or more configuration has been created.\n", 
"       Click this icon, and then choose the configuration to view on the next page to view the statistics.\n", 
"	This is the same as using {OPEN_CONFIGURATION_BUTTON}, \n", "	   and then clicking View Statistics, but it's faster.<p>\n", 
"\n", "  <li> <b>{QUICK_START_BUTTON}</b>.  This provides the very fastest route to seeing your statistics\n", 
"       if you have not yet created a configuration.\n", "       It asks you for the location of your log data and for the name of the configuration, \n", 
"       and then it creates the configuration, builds the database, and drops you right into the \n", 
"       statistics.  You can do the same with {CREATE_NEW_CONFIGURATION_BUTTON}, then Build Database, then \n", 
"       {VIEW_STATISTICS_BUTTON}, but this is faster.  However, {QUICK_START_BUTTON} uses all default values for \n", 
"       the configuration, and you won't have a chance to customize anything before it builds the \n", 
"       database.  If you need to customize any options, use {CREATE_NEW_CONFIGURATION_BUTTON} instead.<p>\n", 
"\n", "  <li> <b>{CREATE_NEW_CONFIGURATION_BUTTON}</b>.  This creates a new configuration.  A configuration is a set \n", 
"       of options which describe which log data you want to analyze, how you want to analyze it,\n", 
"       and a large number of other details.\n", "       You will be prompted for the log source, the log format (if {PRODUCT_NAME} can't figure it\n", 
"       out automatically), the amount of detail you want, and other options.\n", "       After you have created a configuration, you will see [docs-configpage], where you can \n", 
"       build the database and view the statistics.<p>\n", "\n", "  <li> <b>{CREATE_MANY_CONFIGURATIONS_BUTTON}</b>.  This creates a batch of new configurations \n", 
"       based on an existing one.  This is useful if you want to create many similar configurations, \n", 
"       for instance if you're an ISP and you want to create a configuration for each customer. \n", 
"       To use this feature, first create a %22template%22 configuration \n", "       like the ones you want to create.  Then click this button--you will then enter a list of \n", 
"       configuration names, and {PRODUCT_NAME} will copy the template configuration, and \n", "       search-and-replace all occurrences of the configuration name with \n", 
"       the new configuration names in all options of the new configuration.  For instance, if the \n", 
"       old configuration was called oldconfig and the new is called newconfig, it will change not \n", 
"       just the name, but also any occurrences of oldconfig in log source pathnames, hostnames, \n", 
"       headers, and so on.  By choosing your configuration names with care, you can use this \n", "       to fully automate the creation of complete new configurations.<p>\n", 
"\n", "  <li> <b>{OPEN_CONFIGURATION_BUTTON}</b>.  This appears if one or more configuration has been created.\n", 
"       This opens a configuration (you select which one on the next page), and takes you to \n", "       [docs-configpage].  From there, you can edit the configuration options, view the \n", 
"       statistics, build or rebuild the database, and more.<p>\n", "\n", "  <li> <b>{DELETE_CONFIGURATION_BUTTON}</b>.  This lets you permanently delete an existing configuration.\n", 
"       The configuration file will be deleted, as well as any associated database (your log data will not \n", 
"       be deleted). \n", "       A page will appear where you can select the configuration to delete.<p> \n", 
"\n", "  <li> <b>{MODIFY_PREFERENCES_BUTTON}</b>. This lets you modify {PRODUCT_NAME}'s global preferences. \n", 
"       The preferences control the overall behavior of {PRODUCT_NAME} (for instance, you can\n", "       specify the location of the temporary {DIRECTORY_WORD}, the IP number or port to run the web server on,\n", 
"       and much more).<p>\n", "\n", "  <li> <b>{DEFAULT_CONFIG_BUTTON}</b>. This lets you modify the default configuration. \n", 
"       The default configuration is a special configuration whose values \n", "       are used as defaults when creating a new configuration.  So you can change\n", 
"       the default values of any option (for instance, add a default header to all configurations\n", 
"       created in the future)\n", "       by adding it here.<p> \n", "\n", "  <li> <b>{SCHEDULING_BUTTON}</b>. This lets you manage the {PRODUCT_NAME} Scheduler, which can be \n", 
"       configured to automatically build databases, update databases, expire databases, generate HTML files, \n", 
"       or send views by email, at \n", "       pre-defined times.  See [docs-scheduling].<p>\n", "\n", 
"  <li> <b>{ADMINISTRATION_BUTTON}</b>. This lets you monitor the status of the {PRODUCT_NAME} program,\n", 
"       when it is running in web server mode, including monitoring the progress of any\n", "       active database builds or other memory-resident configurations,\n", 
"       and also lets you shut down the web server remotely.<p> \n", "\n", "  <li> <b>{VIEW_DOCUMENTATION_BUTTON}</b>. This lets you browse the online documentation for {PRODUCT_NAME}.<p> \n", 
"\n", "  <li> <b>{LICENSING_BUTTON}</b>.  This lets you manage the licensing of {PRODUCT_NAME}, by adding new licenses and deleting old ones.<p> \n", 
"  <li> <b>{LOGOUT_BUTTON}</b>.  This lets you %22log out%22 of {PRODUCT_NAME}.<p>\n", "\n", "</ol>\n", 
"\"\n", "\n", "##\n", "## confipage documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_configpage \"The Configuration Page\"\n", 
"DOCS_PAGE_CONTENTS_configpage\n", "\"The Configuration Page is a screen which appears when you first create \n", 
"a configuration, or when you open one from the Administrative Menu. \n", "This page lets you modify configuration options (for example, change the log \n", 
"data, the log filters, the database structure, and more), view the statistics, \n", "build/rebuild/update/expire the database, and more.<p>\n", 
"\n", "The main configuration page contains the following menu: \n", "<ul>\n", "  <li> <b>{VIEW_STATISTICS_BUTTON}:</b> This will show the statistics associated with the\n", 
"       configuration, reading them from log data or from a database, as appropriate.<p> \n", "\n", 
"  <li> <b>{EDIT_CONFIGURATION_OPTIONS_BUTTON}:</b> This takes you to the configuration options \n", 
"       page, where you can edit all options associated with the configuration.  \n", "       Options control every aspect of the configuration, including the location of the log data, \n", 
"       the log data format, the log filters, the database fields and structure, and much more. \n", 
"       The configuration options page has a set of tabs along the top; click any tab to \n", "       switch to the options for that category.  See [docs-options] for more information about the options.<p>\n", 
"\n", "  <li> <b>{UPDATE_DATABASE_BUTTON}:</b> This will add <i>new</i> log data in the log source to \n", 
"       the database.  It will ignore any data that has already been added to the database, and \n", 
"       only add new data.  If your log data collects forever without ever being deleted, \n", "       this will have the same final effect as <b>{REBUILD_DATABASE_BUTTON}</b>--the final \n", 
"       database will contain all of your log data.  But <b>{REBUILD_DATABASE_BUTTON}</b> takes much \n", 
"       longer, because it must re-process all the log data; while updating processes only the new data.<p>\n", 
"\n", "  <li> <b>{BUILD_DATABASE_BUTTON}</b> or <b>{REBUILD_DATABASE_BUTTON}:</b>\n", "       This will create or recreate the database as specified by \n", 
"       the configuration, using the options specified in the configuration, \n", "       overwriting the database that was originally created by that \n", 
"       configuration.  The name of the option will be {BUILD_DATABASE_BUTTON} if the \n", "       database has never been built, and from that time on it will be {REBUILD_DATABASE_BUTTON}.<p>\n", 
"\n", "  <li> <b>{ADD_LOG_DATA_BUTTON}:</b> This will add log data to the database.  You will \n", "       be asked to specify the log data to add, and it will be added to the data already in the database.<p>\n", 
"\n", "  <li> <b>{EXPIRE_DATABASE_BUTTON}:</b> This will permanently remove data from the database which is older \n", 
"       than the value specified by [edd].  This option will only be visible if [edd] has a value.<p>\n", 
"\n", "  <li> <b>{SEND_VIEW_BY_EMAIL_BUTTON}:</b> This will send a statistics view by email. \n", "       The email will use HTML formatting and embedded images, so it will look just like \n", 
"       a normal view in a web browser (you will need an email client which supports HTML email). \n", 
"       See [vtsbe], [vea], and [ssh].<p>\n", "\n", "  <li> <b>{GENERATE_HTML_BUTTON}:</b> This will generate a collection of HTML files which \n", 
"       look like {PRODUCT_NAME}'s normal dynamic statistics pages, but which are static files.  These files \n", 
"       are interlinked just like {PRODUCT_NAME}'s normal statistics pages, but since they are normal \n", 
"       HTML files, they can be browsed with a web browser or published with a web server without \n", 
"       requiring {PRODUCT_NAME} to be running or even installed.  They also load almost instantaneously, \n", 
"       since {PRODUCT_NAME} does all the processing required to generate the page in advance.  However, they \n", 
"       lack many of the dynamic controls found on dynamic statistics pages.  See [ghtd].<p> \n", "\n", 
"  <li> <b>{DATABASE_INFO_BUTTON}:</b> This shows information about the current database, if any.\n", 
"       It also includes an option to pre-scan the log data to collect information about its size and structure.<p>\n", 
"\n", "  <li> <b>{SAVE_CONFIGURATION_AS_BUTTON}:</b> This saves the current configuration using a new name. \n", 
"       This makes it possible to modify an existing configuration, and save the modifications \n", 
"       as a new configuration.<p>\n", "\n", "</ul><p>\n", "The button at the top of the page, called <b>{BACK_TO_ADMIN_MENU_BUTTON}</b>, returns you to the Administrative Menu. \n", 
"\"\n", "\n", "\n", "##\n", "## sdinfo documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_sdinfo \"The Temporary {CAPITALIZE:{DIRECTORY_WORD}}\"\n", 
"DOCS_PAGE_CONTENTS_sdinfo\n", "\"The most difficult part of the CGI-mode {PRODUCT_NAME} installation\n", 
"is choosing the correct\n", "Temporary {CAPITALIZE:{DIRECTORY_WORD}} and Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL.\n", 
"When you run {PRODUCT_NAME} in web server mode (with {PRODUCT_NAME} running its own internal web server,\n", 
"and serving its pages via HTTP), this step is not necessary, which is one of the\n", "advantages of web server mode.\n", 
"However, if you prefer to run {PRODUCT_NAME} in\n", "CGI mode, you will have to choose the Temporary {CAPITALIZE:{DIRECTORY_WORD}} and URL.<p>\n", 
"\n", "{PRODUCT_NAME} includes images as part of its output, including\n", "pie charts, line graphs, bar charts, and icons.\n", 
"To display these images, it first creates GIF image files in the Temporary {CAPITALIZE:{DIRECTORY_WORD}},\n", 
"and then embeds the URLs of those images in the HTML of the pages it generates,\n", "using the Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL as the basis for choosing the correct URL.<p>\n", 
"\n", "The Temporary {CAPITALIZE:{DIRECTORY_WORD}} and the Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL are two different ways\n", 
"of describing the <i>same</i> {DIRECTORY_WORD}.  They must point to the same\n", "{DIRECTORY_WORD} for {PRODUCT_NAME}'s output to look correct.  The temporary {DIRECTORY_WORD}:\n", 
"<ul> \n", "\n", "  <li> must be within the HTML pages {DIRECTORY_WORD} of the web server which is\n", 
"       serving {PRODUCT_NAME}.  Web servers serve all their pages from a particular\n", "       {DIRECTORY_WORD} on the hard drive; the Temporary {CAPITALIZE:{DIRECTORY_WORD}} must be somewhere\n", 
"       within this {DIRECTORY_WORD}.  This {DIRECTORY_WORD} is called different things by\n", "       different web servers, but some common names are %22htdocs%22, %22html%22,\n", 
"       %22data%22, %22wwwroot%22, and %22Web Pages.%22  If you do not know where this\n", "       {DIRECTORY_WORD} is for your web server, you can find out in your web server's\n", 
"       documentation.  See [docs-webservers] for a list of web servers,\n", "       and where the HTML pages {DIRECTORY_WORD} is for them.<p>\n", 
"\n", "  <li> must either exist and be writable by {PRODUCT_NAME} (running as a CGI program),\n", "       or it must be possible for {PRODUCT_NAME} to create it.  Under most circumstances,\n", 
"       MacOS and Windows users do not need to worry about this, since most {PLURALIZE:{DIRECTORY_WORD}} are\n", 
"       writable by default (exceptions include {PLURALIZE:{DIRECTORY_WORD}} on remotely mounted volumes, which\n", 
"       tend to have more access restrictions on MacOS and Windows systems).  UNIX users\n", "       may need to use the <code>chmod</code> command to set permissions correctly.<p>\n", 
"</ul>\n", "\n", "The Temporary {CAPITALIZE:{DIRECTORY_WORD}} should be described using\n", "your platform's standard pathname format (see [docs-pathnames]).\n", 
"The Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL should describe the same {DIRECTORY_WORD} as\n", "the Temporary {CAPITALIZE:{DIRECTORY_WORD}}, but as a URL (as it might be accessed using\n", 
"a web browser, by browsing the server {PRODUCT_NAME} is running under).  The\n", "following examples illustrate how it might be set for various platforms; see\n", 
"[docs-webservers] for more specific information.<p>\n", "\n", "As the hostname part of the URL, you will need to specify the machine\n", 
"{PRODUCT_NAME} is running on.  In the examples below, this is chosen to be www.mysys.com;\n", "you will need to replace this part of the URL with your machine's actual hostname.<p>\n", 
"\n", "<b>Example 1</b>: For <b>MacOS</b>,\n", "if the root of your web server's HTML pages is at MyDrive:Web&nbsp;Server:html:\n", 
"(i.e. the html {DIRECTORY_WORD}, which is in the Web&nbsp;Server {DIRECTORY_WORD}, which is on the MyDrive disk),\n", 
"and this is accessible from your web browser\n", "as http://www.mysys.com/, then you could enter MyDrive:Web&nbsp;Server:html:{PRODUCT_EXECUTABLE_DOCS}:\n", 
"as the Temporary {CAPITALIZE:{DIRECTORY_WORD}}\n", "and http://www.mysys.com/{PRODUCT_EXECUTABLE_DOCS}/ as the Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL.<p>\n", 
"\n", "<b>Example 2</b>: For <b>Windows 95/NT</b>,\n", "if the root of your web server is at C:\\inetpub\\wwwroot\\\n", 
"(i.e. the wwwroot {DIRECTORY_WORD}, which is in the inetpub {DIRECTORY_WORD}, which is on the C drive),\n", 
"and this is accessible from your web browser\n", "as http://www.mysys.com/, then you could enter\n", 
"C:\\inetpub\\wwwroot\\{PRODUCT_EXECUTABLE_DOCS}\\ as the Temporary {CAPITALIZE:{DIRECTORY_WORD}}\n", 
"and http://www.mysys.com/{PRODUCT_EXECUTABLE_DOCS}/ as the Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL.<p>\n", 
"\n", "<b>Example 3</b>: For <b>UNIX</b>,\n", "if the root of your web server is at /home/httpd/html/,\n", 
"and this is accessible from your web browser\n", "as http://www.mysys.com/, then you could enter /home/httpd/html/{PRODUCT_EXECUTABLE_DOCS}/\n", 
"as the Temporary {CAPITALIZE:{DIRECTORY_WORD}}\n", "and http://www.mysys.com/{PRODUCT_EXECUTABLE_DOCS}/ as the Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL.<p>\n", 
"\n", "See [docs-webservers] for more information.\"\n", "\n", "\n", "##\n", "## webservers documentation page text\n", 
"##\n", "\n", "DOCS_PAGE_TITLE_webservers \"Web Server Information\"\n", "DOCS_PAGE_CONTENTS_webservers\n", 
"\"{PRODUCT_NAME} can run as its own web server, serving its HTML pages to any web browser\n", "via HTTP.  This is often the best way to run {PRODUCT_NAME}, but if it's not possible or desirable to\n", 
"run it that way, you can also run it as a CGI program under another web server.<p>\n", "\n", "{PRODUCT_NAME} is designed to work with any web server which supports the (very common)\n", 
"CGI standard (on MacOS, the server must support WebSTAR 2.0 style ACGI).\n", "For ease of installation and configuration, however, the following list\n", 
"includes a number of known web servers which {PRODUCT_NAME} has been fully tested with,\n", "and information about how {PRODUCT_NAME} should be configured when using it with them.<p>\n", 
"Each entry assumes that the default installation options were used, and that the\n", "full hostname of the computer running the web server is www.myhost.com; you will need\n", 
"to replace %22www.myhost.com%22 by the actual hostname of your server.\n", "The CGI {DIRECTORY_WORD}\n", 
"is the {DIRECTORY_WORD} where the {PRODUCT_NAME} executable program (application) should be placed to\n", 
"begin using it.  The Web pages root is the root of all web pages for the server, and is\n", "used to compute the Temporary {CAPITALIZE:{DIRECTORY_WORD}}.  The Temporary {CAPITALIZE:{DIRECTORY_WORD}} and\n", 
"Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL are <i>suggested</i> values for the Temporary {CAPITALIZE:{DIRECTORY_WORD}}\n", 
"and the Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL (see [docs-sdinfo]).<p>\n", "\n", "<table border=1 cellpadding=3>\n", 
"<tr>\n", "  <td bgcolor=#c0c0c0>\n", "    <b>Web Server</b>\n", "  </td>\n", "  <td bgcolor=#c0c0c0>\n", 
"    <b>Information</b>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    Xitami (Windows)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>C:\\Program Files\\Xitami\\cgi-bin\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>C:\\Program Files\\Xitami\\webpages\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>C:\\Program&nbsp;Files\\Xitami\\webpages\\{PRODUCT_EXECUTABLE_DOCS}\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    OmniHTTP (Windows)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>C:\\httpd\\cgi-bin\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>C:\\httpd\\htdocs\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>C:\\httpd\\htdocs\\{PRODUCT_EXECUTABLE_DOCS}\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    Microsoft Peer Web Services (Windows)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>C:\\inetpub\\cgi-bin\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>C:\\inetpub\\wwwroot\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>C:\\inetpub\\wwwroot\\{PRODUCT_EXECUTABLE_DOCS}\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    Microsoft IIS 3 (Windows)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    {PRODUCT_NAME} and IIS version 3 do not get along!  Please upgrade to IIS 4, which works great.\n", 
"  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    Microsoft IIS 4/5 (Windows)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>C:\\inetpub\\cgi-bin\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>C:\\inetpub\\wwwroot\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>C:\\inetpub\\wwwroot\\{PRODUCT_EXECUTABLE_DOCS}\\</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Log File Location:</td><td valign=%22bottom%22>c:\\WINNT\\System32\\LogFiles\\W3svc1</td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    MacOS X Web Server (Apache-based MacOS X Standard Server)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>/Library/WebServer/CGI-Executables</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>/Library/Webserver/Documents</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>/Library/Webserver/Documents/{PRODUCT_EXECUTABLE_DOCS}</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Log File Location:</td><td valign=%22bottom%22></td></tr>\n", "      <tr><td valign=%22top%22>Notes:</td><td valign=%22bottom%22>\n", 
"                             </td></tr>\n", "    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", 
"    WebSTAR 3.0 (MacOS)\n", "  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebSTAR 3.0:cgi-bin:</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebSTAR 3.0:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebSTAR 3.0:{PRODUCT_EXECUTABLE_DOCS}:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Log File Location:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebSTAR 3.0:WebSTAR.log</td></tr>\n", 
"      <tr><td valign=%22top%22>Notes:</td><td valign=%22bottom%22>1. The above information assumes that WebSTAR 3.0 was installed\n", 
"                             onto a hard drive called MyHardDrive, into a {DIRECTORY_WORD} called Applications.<p>\n", 
"                             </td></tr>\n", "    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", 
"    Web Sharing (MacOS 9)\n", "  </td>\n", "  <td valign=%22top%22>\n", "    Web Sharing does not support the WebSTAR 2.0 CGI standard, so {PRODUCT_NAME} does not\n", 
"    work with it.  Please use Quid Pro Quo instead.\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", 
"    Microsoft Personal Web Server (MacOS)\n", "  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", 
"      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>MyHardDrive:My Personal Web Site:</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>MyHardDrive:My Personal Web Site:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>MyHardDrive:My Personal Web Site:{PRODUCT_EXECUTABLE_DOCS}:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Log File Location:</td><td valign=%22bottom%22>MyHardDrive:System Folder:PWS:MS Personal Web Server Log</td></tr>\n", 
"      <tr><td valign=%22top%22>Notes:</td><td valign=%22bottom%22>1. It doesn't really matter where you install the Personal Web\n", 
"Server; the important thing is where the Installer puts %22My Personal Web\n", "Site.%22  That's where the {PRODUCT_NAME} application and the Temporary {CAPITALIZE:{DIRECTORY_WORD}}\n", 
"should go.<p>\n", "2.  Unlike other MacOS web servers, Microsoft Personal Web Server\n", "launches CGI programs in the foreground.  This can mean better performance\n", 
"for {PRODUCT_NAME}, but can also be obtrusive.  The %22bring to foreground when\n", "launched%22 option doesn't do anything with Microsoft Personal Web Server,\n", 
"because {PRODUCT_NAME} is always in the foreground.\n", "                             </td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    WebTen 2.0 (MacOS 9)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebTen v2.0:</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebTen v2.0:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebTen v2.0:websites:www.myhost.com:{PRODUCT_EXECUTABLE_DOCS}:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Log File Location:</td><td valign=%22bottom%22>MyHardDrive:Applications:WebTen v2.0:WebTen.log</td></tr>\n", 
"      <tr><td valign=%22top%22>Notes:</td><td valign=%22bottom%22>1. The above information assumes that WebTen was installed\n", 
"                             onto a hard drive called MyHardDrive, into a {DIRECTORY_WORD} called Applications.<p>\n", 
"                             </td></tr>\n", "    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", 
"    AppleShare IP 6.0 (MacOS 9)\n", "  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>MyHardDrive:Web Folder:</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>MyHardDrive:Web Folder:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>MyHardDrive:Web Folder:{PRODUCT_EXECUTABLE_DOCS}:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    Quid Pro Quo (MacOS 9)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>MyHardDrive:Applications:Quid Pro Quo:cgi-bin:</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>MyHardDrive:Applications:Quid Pro Quo:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>MyHardDrive:Applications:Quid Pro Quo:html:{PRODUCT_EXECUTABLE_DOCS}:</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/html/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Notes:</td><td valign=%22bottom%22>1. The above information assumes that Quid Pro Quo was installed\n", 
"                             onto a hard drive called MyHardDrive, into a {DIRECTORY_WORD} called Applications.<p>\n", 
"                             2. If Quid Pro Quo installs into a {DIRECTORY_WORD} with a\n", "                             curly f as its last character, you will need to rename it to\n", 
"                             just Quid Pro Quo to get {PRODUCT_NAME} to work correctly.\n", "                             </td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", "    Web Sharing (MacOS)\n", 
"  </td>\n", "  <td valign=%22top%22>\n", "    Web Sharing does not support the WebSTAR 2.0 CGI standard, so {PRODUCT_NAME} does not\n", 
"    work with it.  Please use Quid Pro Quo instead.\n", "  </td>\n", "</tr>\n", "<tr>\n", "  <td valign=%22top%22>\n", 
"    apache (UNIX)\n", "  </td>\n", "  <td valign=%22top%22>\n", "    <table>\n", "      <tr><td valign=%22top%22>CGI {DIRECTORY_WORD}:</td><td valign=%22bottom%22>/home/httpd/cgi-bin/</td></tr>\n", 
"      <tr><td valign=%22top%22>Web pages root:</td><td valign=%22bottom%22>/home/httpd/html/</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}}:</td><td valign=%22bottom%22>/home/httpd/html/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Temporary {CAPITALIZE:{DIRECTORY_WORD}} URL:</td><td valign=%22bottom%22>http://www.myhost.com/{PRODUCT_EXECUTABLE_DOCS}/</td></tr>\n", 
"      <tr><td valign=%22top%22>Log File Location:</td><td valign=%22bottom%22>varies; try /var/log/httpd/access_log</td></tr>\n", 
"      <tr><td valign=%22top%22>Notes:</td><td valign=%22bottom%22>The Web pages root varies from installation to installation; it may\n", 
"                             be somewhere else.  Consult your apache configuration files\n", "                             (often in /etc/httpd/conf/, but this varies too) for the\n", 
"                             exact location (search for DocumentRoot).\n", "                             </td></tr>\n", 
"    </table>\n", "  </td>\n", "</tr>\n", "</table>\n", "<p>If you're running {PRODUCT_NAME} on some other server, and need help configuring it,\n", 
"please contact us at <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>.\n", "If you're using some other server, and have it working, we'd really appreciate it\n", 
"if you could forward the above information for your server to us, so we can add that\n", "server to the list, and save time for future users.\"\n", 
"\n", "\n", "##\n", "## scheduling documentation page text\n", "##\n", "DOCS_PAGE_TITLE_scheduling \"Using the {PRODUCT_NAME} Scheduler\"\n", 
"DOCS_PAGE_CONTENTS_scheduling\n", "\"{PRODUCT_NAME} includes a built-in scheduler which can be used to \n", 
"schedule regular database builds, database updates, database expirations, offline HTML page generation, \n", 
"or emailed views.\n", "For instance, you can use it to schedule a configuration's database to be updated \n", 
"every day at midnight, so the statistics are never more than a day old.  Or \n", "you could schedule {PRODUCT_NAME} to generate HTML pages from your statistics every week, \n", 
"so you have an offline-browseable HTML snapshot of your weekly statistics. \n", "Or you could have it update the database every day, and after that, send you the statistics \n", 
"by email.<p>\n", "\n", "Scheduled items can only be run when {PRODUCT_NAME} itself is running.  The easiest way to \n", 
"do this is to run {PRODUCT_NAME} in web server mode (or ACGI mode on MacOS).\n", "If you need to use {PRODUCT_NAME}'s scheduler features with CGI mode, you can do it by \n", 
"using an external scheduling program like cron or NT Scheduler to run {PRODUCT_NAME} every \n", "minute in scheduler mode, i.e. <code>{PRODUCT_EXECUTABLE_DOCS} -scheduler</code>.  {PRODUCT_NAME} can be called \n", 
"directly from cron or NT Scheduler as well, using a command line to describe the operation\n", "to be performed.  (Alternately, if you have only one scheduled item, you can set that item to\n", 
"run every minute, and only call {PRODUCT_NAME} with -scheduler at the time you really\n", "want the schedule to run; this is somewhat more resource-efficient than running {PRODUCT_NAME}\n", 
"every minute, and having it do nothing most minutes).<p>\n", "\n", "{PRODUCT_NAME}'s schedule can be configured from Scheduler page, which can be reached from \n", 
"the Administrative Menu (see [docs-adminmenu]), using the Scheduler button. \n", "The Scheduler page contains an Admin Menu button which returns to the Administrative menu, and the schedule \n", 
"itself.<p>\n", "\n", "The schedule consists of zero or more scheduled items.  You can add a new scheduled \n", 
"item by clicking any Add button; the new item will be a duplicate of the item next \n", "to the Add button.  You can delete an existing scheduled item by clicking the Delete \n", 
"button next to that item.  You can expand an item for editing by clicking on the blue \n", "arrow next to the item, or collapse it when you're done editing by clicking the blue arrow.<p>\n", 
"\n", "A scheduled item consists of a date and time, a configuration name (or matching pattern), an operation,\n", 
"and possibly extra options.\n", "{PRODUCT_NAME} will perform the operation on the configuration whenever the date and time match \n", 
"the current date and time.  For instance if you choose January, Monday, day 12 of the month, \n", "06:09 as your date and time, and Build Database as the operation, {PRODUCT_NAME} will build the database \n", 
"at 6:09 AM on any Monday which is the 12th of January.  The current date and time must match \n", "<i>all</i> the selections, so it won't run at 6:09 AM on Monday the 13th of January, or \n", 
"at 6:09 AM on Tuesday the 12th of January.  Usually, you will select %22any month,%22 %22any day,%22 \n", 
"or * (which means any hour or any minute) for some of the fields.  For instance, to update a database \n", 
"every hour, you might choose any month, any day, any day, *:00, Update Database.<p>\n", "\n", "{PRODUCT_NAME} calls itself from the command line to perform scheduled tasks.  \n", 
"The extra options, if specified, are added to the end of the command line.  This \n", "makes it possible to perform complex scheduled actions by overriding the default\n", 
"options on the command line.  For instance without any extra options, \n", "sending email will send the default view by email to the default address,\n", 
"without any filters.  But if the options are set to\n", "<code>-vea someone@somewhere.com -vtsbe 'Single-page summary' -f recentdays:30</code>,\n", 
"the Single-page summary of the past 30 days will be sent to someone@somewhere,com.<p>\n", "\n", "{PRODUCT_NAME} creates a file called TaskLog, in the LogAnalysisInfo directory, which contains a log\n", 
"of all scheduled tasks that have run, as well as logs of all other actions {PRODUCT_NAME} has taken \n", 
"(e.g. view statistics, build database from the web interface or command line, etc.).  This \n", "log can be very helpful if you're trying to debug a problem with the Scheduler.<p>\"\n", 
"\n", "\n", "\n", "##\n", "## languagemodules documentation page text\n", "##\n", "DOCS_PAGE_TITLE_languagemodules \"Language Modules--Localization and Text Customization\"\n", 
"DOCS_PAGE_CONTENTS_languagemodules\n", "\"All text displayed by {PRODUCT_NAME}, from the title of the Administrative menu, \n", 
"to the name of table headers in the statistics, to this documentation, \n", "can be modified, customized, or translated by modifying {PRODUCT_NAME}'s \n", 
"Language Module files.  Language modules are text files, \n", "located in the Languages sub{DIRECTORY_WORD} of the LogAnalysisInfo sub{DIRECTORY_WORD}, \n", 
"which contain all the text {PRODUCT_NAME} ever displays.  These can be duplicated, renamed, \n", "and modified to provide translations into any language. \n", 
"By modifying the language modules, or creating your own, you \n", "can translate {PRODUCT_NAME}'s interface into any language, \n", 
"or you can customize any text that {PRODUCT_NAME} generates.\n", "Some language translations already exist, including Spanish and Italian, and \n", 
"some are in progress, including German and Danish.  For other languages, \n", "you will need to do the translation yourself.<p>\n", 
"\n", "There are six language modules files which together define every \n", "bit of text {PRODUCT_NAME} ever generates.  These are: <p>\n", 
"<ul> \n", "  <li> <b>Stats</b>: The statistics.  This includes the \n", "       names of the views, the instructions, the names of the Options, the table headings, and more.\n", 
"       This small \n", "       language module is all that must be translated to translate {PRODUCT_NAME}'s \n", 
"       statistics into any language.<p>\n", "  <li> <b>Admin</b>: The administrative interface.  This includes \n", 
"       the text of the administrative menu, the configuration page, the Scheduler, \n", "       and more.<p>\n", 
"  <li> <b>Options</b>: The names and descriptions of all of {PRODUCT_NAME}'s options.<p>\n", "  <li> <b>Docs</b>: The online documentation pages, including this one.<p>\n", 
"  <li> <b>FAQ</b>: The Frequently Asked Questions and answers.<p>\n", "  <li> <b>Messages</b>: The error messages and debugging output.<p>\n", 
"</ul><p>\n", "\n", "The names of the language module files are in the following format: <p>\n", "<ul><i>language</i>-<i>type</i>-<i>version</i></ul><p>\n", 
"Where <i>language</i> is the language of the module (English for the default modules), \n", "<i>type</i> is one of the six types above, and <i>version</i> is the version number \n", 
"of the language module (language module version numbers are independent of the version numbers \n", 
"of {PRODUCT_NAME} itself).<p>\n", "\n", "If all you need is a translation of the statistics (i.e. if you can use the English \n", 
"administrative interface, but need to provide statistics in the native language of your clients),\n", 
"then you only need a translation of the Stats module.  If you need to be able to use the Administrative \n", 
"Menu, configuration page, Scheduler, etc. in a language other than English, you will need \n", "translations of the Admin, Options, and Messages modules.  If you need the documentation as well, \n", 
"you will need the Docs and FAQ module.<p>\n", "\n", "We have a standing offer of a free unlimited-use license with perpetual free upgrades \n", 
"for anyone willing to translate \n", "the Stats module into any language not already supported, and willing to update it \n", 
"as new versions are released.  For details, please contact \n", "<a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a>.<p>\n", 
"\n", "<h3>Installing a Language Module</h2>\n", "To install a language module, move the language module file into the Languages {DIRECTORY_WORD}, which is inside the\n" 
"LogAnalysisInfo {DIRECTORY_WORD}.  IMPORTANT: You must use the Languages {DIRECTORY_WORD} that is inside LogAnalysisInfo-- if\n", 
"you have another Languages {DIRECTORY_WORD} in your installation, it is not the location where you put language modules;\n", 
"it is just a {DIRECTORY_WORD} full of modules that you can move into place if you need them.  Only modules in the\n", 
"Languages {DIRECTORY_WORD} of LogAnalysisInfo will be used.<p>\n", "Once you have installed the module, you can use it by changing the %22Language Module%22 preference,\n", 
"in the Miscellaneous tab of the Preferences (available from the Administrative Menu), to the name\n", 
"of the language you'll be using.  For instance, change it to %22Italian%22 if you want {PRODUCT_NAME} to\n", 
"display Italian.<p>\n", "Finally, restart {PRODUCT_NAME}, and your interface, statistics, and other parts of {PRODUCT_NAME} will\n", 
"be in the new language, depending on\n", "which modules you have installed.<p>\n", "\n", "<h3>Creating a New Language Module</h2>\n", 
"Creating a new language module is simple.  Just duplicate an existing English \n", "module, and change English in the name to the name of the language you're using. \n", 
"For instance, you might duplicate English-Stats-50 and rename it to French-Stats-50. \n", "Modify French-Stats-50 as you wish (for instance, translate it to French)--see \n", 
"Language Module Syntax, below, for information about the syntax of language modules. \n", "Now start {PRODUCT_NAME}, go to the Miscellaneous tab of the Preferences, and enter \n", 
"French in the [lmp] field.  If you're using web server mode, restart {PRODUCT_NAME}, and it will use your new language module. \n", 
"(in CGI mode, it will start using it immediately, without having to restart anything). \n", "{PRODUCT_NAME} attempts to find each of the six language modules in the specified language, and failing that, \n", 
"it uses the built-in English one.  So you can translate just one or just a few of the modules, \n", 
"and {PRODUCT_NAME} will continue to work-- it will use the translated text when it is available, and \n", 
"it will fall back on English in other cases.<p>\n", "\n", "<h3>Language Module Syntax</h2>\n", "The basic syntax of language modules is very simple--it is \n", 
"a collection of name-value pairs, for instance \n", "<i>name1 value1 name2 value2 name3 value3...</i>. \n", 
"Names are separated from values by spaces, tabs, or \n", "line breaks, and there can be any amount of space between \n", 
"names and values.  If spaces or line breaks are needed inside \n", "variable names or values, the entire name or value must be quoted \n", 
"in single or double quotes.  Any line beginning with a # character \n", "is considered a comment, and is ignored.<p>\n", 
"\n", "When translating or customizing a language module, you should not change \n", "the names of variables--those must remain exactly as they are.  Only the \n", 
"values should be changed.<p>\n", "\n", "Most of a language module is just straightforward name-value pairs, but there are a few \n", 
"extended features that you will see and perhaps use.  These features are \n", "listed below:<p>\n", 
"<ul>\n", "  <li> {QUOTE:%7B<i>variable name</i>%7D}.  A language module variable \n", "       name surrounded by curly brackets will be replaced by the value \n", 
"       of that variable when the output is generated by {PRODUCT_NAME}.  This \n", "       is the fundamental way of using a variable.  For instance, \n", 
"       {QUOTE:%7BVIEW_DOCUMENTATION_BUTTON</i>%7D} will result in the following \n", "       text: {VIEW_DOCUMENTATION_BUTTON}.  (The VIEW_DOCUMENTATION_BUTTON variable \n", 
"       is defined in the Admin language module).<p>\n", "  <li> {QUOTE:%7B<i>option name</i>%7D}.  The shortcut or name of a configuration \n", 
"       option surrounded by curly brackets will be replaced by the value \n", "       of that option when the output is generated by {PRODUCT_NAME}.  For instance, \n", 
"       {QUOTE:%7Bconfig_name%7D} will appear as the name of the configuration \n", "       currently being viewed or edited.<p>\n", 
"  <li> {QUOTE:%5B<i>option name</i>%5D}.  The shortcut or name of a configuration \n", "       option surrounded by square brackets will be replaced by the full \n", 
"       name of the option (as defined in the Options module using OPTION_LABEL variables), and \n", 
"       a link to the documentation page describing that option.  For instance, \n", "       {QUOTE:%5Blanguage_module_pathname%5D} or\n", 
"       {QUOTE:%5Blmp%5D}\n", "       creates a link to the language_module_pathname option documentation, like this link: [lmp]. <p>\n", 
"  <li> {QUOTE:%5Bdocs-<i>documentation page name</i>%5D}.  The internal name of a documentation page \n", 
"       preceded by %22docs-%22 and surrounded by square brackets will be replaced by the full \n", 
"       title of the documentation page (as defined in the Docs module using DOCS_PAGE_TITLE variables), and \n", 
"       a link to that documentation page.  For instance, \n", "       {QUOTE:%5Bdocs-languagemodules%5D}\n", 
"       creates a link to the page you are reading now: [docs-languagemodules]. <p>\n", "  <li> {QUOTE:%5Bfaq-<i>documentation page name</i>%5D}.  The internal name of a FAQ entry \n", 
"       preceded by %22faq-%22 and surrounded by square brackets will be replaced by the full \n", "       title of the FAQ page (as defined in the FAQ module using FAQ_TITLE variables), linked \n", 
"       to that FAQ page.  For instance, \n", "       {QUOTE:%5Bfaq-languagemodules%5D}\n", "       creates a link to the FAQ entry discussing language modules: [faq-languagemodules]. <p>\n", 
"  <li> {QUOTE:%7BQUOTE:<i>value</i>%7D}.  The value will be inserted literally, even if \n", "       it includes special characters like curly or straight quotes.  If you look at \n", 
"       the description of this page in the Docs module, you will see that this has been used, in conjunction with \n", 
"       the %2525 syntax described below, to \n", "       show curly and square brackets throughout this page.<p>\n", 
"  <li> %2525<i>xx</i>.  This inserts the character represented by hexadecimal ASCII code <i>xx</i>. \n", 
"       This is useful for inserting characters which have special meanings, like square brackets.<p>\n", 
"  <li> {QUOTE:%7BIFEQUAL:<i>value1</i>:<i>value2</i>:THEN:<i>value3</i>:ELSE:<i>value4</i>%7D}.  This \n", 
"       complex and powerful construct implements the if/then/else expression available in many programming \n", 
"       languages.  If <i>value1</i> is equal to <i>value2</i>, then the value of this entire expression is <i>value3</i>;\n", 
"       otherwise, the value of the expression is <i>value4</i>.  Any of the values may be arbitrarily complex expressions, \n", 
"       so it is possible to compare the value of a variable or a configuration option to a constant, or to \n", 
"       another option, and it is possible to use complicated result constructs (for instance, <i>value3</i> can itself\n", 
"       be an IF:THEN:ELSE construct).<p> \n", "</ul><p>\n", "{PRODUCT_NAME} allows nested constructs in language modules, and it continues to expand \n", 
"variables and other constructs until all possible expansions are done.  For instance, \n", "if the variable FIELD is a value of %22page%22 then the \n", 
"variable {QUOTE:%7BVIEW_LABEL_FOR_FIELD_%7BFIELD%7D%7D} will appear as the following: \n", "%22{VIEW_LABEL_FOR_FIELD_page}%22. {PRODUCT_NAME} first expands {QUOTE:%7BFIELD%7D} to \n", 
"%22page%22, and then substitutes it in to make the value {QUOTE:%7BVIEW_LABEL_FOR_FIELD_page%7D}--then it \n", 
"substitutes the variable VIEW_LABEL_FOR_FIELD_page for its value (defined in the Stats module).<p>\n", 
"\n", "<h3>Debugging Language Modules</h2>\n", "Writing a language module can be tricky, because {PRODUCT_NAME}'s \n", 
"flexibility in allowing any formatting you like between \n", "names and values (provided it's whitespace) can easily lead \n", 
"to situations where a small error in quotation or bracketing \n", "throws the whole module off (names become values, and vice versa), \n", 
"or it can lead to a situation where a generated page is blank because \n", "the brackets don't match up properly.<p>\n", 
"This sort of a problem is difficult to track down, so \n", "a special feature of {PRODUCT_NAME} lets you debug language modules easily. \n", 
"It requires a command-line version of {PRODUCT_NAME}, and you must change \n", "the name of the {PRODUCT_NAME} executable so that is contains the characters \n", 
"%22lmd%22 (that stands for Language Module Debug)--for instance, you \n", "might change the name of the program to <code>{PRODUCT_EXECUTABLE_DOCS}_lmd</code>.  \n", 
"Once you've done that, run {PRODUCT_NAME}.  When it notices that its name \n", "contains %22lmd%22, it will start generating information about the \n", 
"language modules it's reading, included the tokens it's processing and \n", "the name/value pairs it's finding. \n", 
"It is usually a simple matter to examine the output and see where \n", "the erroneous quote or bracket is.<p>\n", 
"\n", "<h3>Special Language Module Variables</h2>\n", "In addition to the variables defined in the language module files,\n", 
"(and those defined implicitly by the configuration options), {PRODUCT_NAME} defines\n", "the following special variables:<p>\n", 
"<ul>\n", "  <li> TEMPORARY_CONFIG_FILE_PATHNAME: The pathname of the temporary configuration file used in the current\n", 
"       statistics page.  This can be used to create custom statistics links that keep all the current settings.</li>\n", 
"  <li> DB_DATA_MODIFICATION_DATETIME: The last modification date/time of the database data.  This\n", 
"       is useful for including modification information in headers and footers.</li>\n", "  <li> RUNNING_USERNAME: The name of user {PRODUCT_NAME} is running as.</li>\n", 
"  <li> PRODUCT_NAME: The name of {PRODUCT_NAME} (%22{PRODUCT_NAME}%22 by default, but different\n", 
"       if the product has been relabelled or white-labelled).</li>\n", "  <li> PRODUCT_EXECUTABLE: The name of the {PRODUCT_NAME} executable file (%22{PRODUCT_EXECUTABLE}%22 in this case).</li>\n", 
"  <li> PRODUCT_EXECUTABLE_DOCS: The name of the {PRODUCT_NAME} executable file,\n", "       as used in documentation where a generic executable name is more useful than the actual one\n", 
"       (%22{PRODUCT_EXECUTABLE_DOCS}%22 in this case).</li>\n", "  <li> SUPPORT_EMAIL: The support email address that appears in errors and elsewhere\n", 
"       (%22{SUPPORT_EMAIL}%22 in this case).\n", "       Unlike most of the special language module variables, this can be overridden by defining it\n", 
"       in any language module file.</li>\n", "  <li> PRODUCT_URL: A link to the {PRODUCT_NAME} home page (%22{PRODUCT_URL}%22 in this case).</li>\n", 
"  <li> COPYRIGHT_HOLDER: The holder of the {PRODUCT_NAME} copyright (%22{COPYRIGHT_HOLDER}%22 in this case).</li>\n", 
"</ul>\n", "\"\n", "\n", "\n", "\n", "##\n", "## using documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_using \"Using {PRODUCT_NAME}\"\n", 
"DOCS_PAGE_CONTENTS_using\n", "\"This page provides some instructions and guidelines for using \n", 
"{PRODUCT_NAME}.  It describes and discusses the most common uses, \n", "with examples.<p> \n", "\n", 
"<h4>Creating a configuration</h4> \n", "\n", "When you create a configuration, {PRODUCT_NAME} asks you for the log source.\n", 
"The log data can come from a file, a collection of files, or from the output of an arbitrary\n", "command (this last option is available only on UNIX and Windows).  The files can be local, or \n", 
"{PRODUCT_NAME} can download them from an FTP site (you can use a standard FTP URL to specify the \n", 
"location of the files; click Show Examples on the %22Where is the log data%22 page to \n", "see examples of FTP URLs).  {PRODUCT_NAME} supports and automatically detects a wide\n", 
"range of log formats.<p>\n", "\n", "Once you have told {PRODUCT_NAME} where your log data is, {PRODUCT_NAME} will create a configuration for you \n", 
"using reasonable values for all the options.  It will take you to [docs-configpage], \n", "where you can change any of {PRODUCT_NAME}'s many configuration options (see [docs-options]).  {PRODUCT_NAME}'s options can be \n", 
"confusing at first because there are so many of them, but you don't need to change <i>any</i> of \n", 
"them if you don't want to.  A good way to start is to leave them all alone, build your database, \n", 
"and view your statistics, using all the default settings.  Once you're familiar with your statistics \n", 
"using the default settings, you can go back and start changing them, if you wish.  Options \n", "you may eventually decide to change especially include the Filters, which let you include or exclude \n", 
"log data from your database (see [docs-filters]), and the Database Structure options, which let you \n", 
"include, exclude, and cross-reference different log fields in your database (see [docs-hierarchies] \n", 
"and [docs-xref]).<p>\n", "\n", "You can use the Log Filter Options to specify a complex set of filters to control \n", 
"exactly which log entries you are interested in, and which you are not (see [lf]).  Some common filters \n", 
"(for instance, those that filter the image files as hits) are built in, but you may want to enhance \n", 
"the built-in filter set with your own filters, or you may want to remove the built-in filters. \n", 
"See [docs-filters] for more information and examples.<p>\n", "\n", "<h4>Viewing Statistics</h4> \n", 
"\n", "Once you have created the database, you can view your statistics, using the View Statistics \n", 
"button on [docs-configpage] or on [docs-adminmenu].  For more information on using and navigating \n", 
"the statistics pages, see [docs-statspages].\n", "\n", "<h4>Creating and Updating Databases from the Command Line</h4>\n", 
"\n", "You may want to use the command line (AppleScript or drag-and-drop configuration files on MacOS)\n", 
"to create or update databases.\n", "Command line usage is useful, for instance, if you want to automatically and regularly update the database \n", 
"with the latest log entries (this can also be done from the scheduler; see [docs-scheduling]). \n", 
"For instance, it is possible to set up a cron job on a UNIX system to automatically update the \n", 
"database every day with the previous day's log.  The command line would look something like this: \n", 
"\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf configname -cm updatedatabase</pre> \n", "\n", "This command line updates the database for the configuration <code>configname</code>. \n", 
"See [docs-poweruse] for more examples of command line usage.<p>\n", "\n", "<h4>For More Information</h4> \n", 
"\n", "The Create Configuration process creates a configuration with default settings, \n", "which is generally a good starting point.  After that, it's up to you \n", 
"to fine-tune it if you want.  There is a wealth of options in [docs-configpage], \n", "letting you control everything from the speed of log file processing to the \n", 
"color of pie chart slices.  To get the most out of \n", "{PRODUCT_NAME}, you should spend some time looking over these options, or \n", 
"browsing the [cat-all] page.<p>\"\n", "\n", "\n", "##\n", "## poweruse documentation page text\n", 
"##\n", "\n", "DOCS_PAGE_TITLE_poweruse \"Power User Techniques\"\n", "DOCS_PAGE_CONTENTS_poweruse\n", 
"\"This page describes some of the faster, more powerful, and less intuitive ways \n", "of using {PRODUCT_NAME}.  Power users may find themselves using \n", 
"these techniques, rather than the friendlier but slower graphical interface. \n", "These techniques involve direct editing of {PRODUCT_NAME} \n", 
"text-based configuration options, and will be most easily \n", "mastered by users already comfortable with command line programs. \n", 
"You may want to familiarize yourself with the [docs-options] before reading \n", "this page.<p> \n", 
"\n", "<h4>Using {PRODUCT_NAME} from the Command Line or with AppleScript/Drag-and-Drop</h4> \n", "\n", 
"For UNIX or Windows users, {PRODUCT_NAME} can be directly invoked from \n", "the command line (see [docs-commandline]).<p>\n", 
"\n", "For MacOS users, the same \n", "power can be achieved by holding down the option key while {PRODUCT_NAME} is starting up;\n", 
"you can type any configuration commands in the resulting window, so it works just\n", "like the UNIX and Windows command lines.\n", 
"To use the command line examples on this page with MacOS,\n", "just remove the word %22{PRODUCT_EXECUTABLE_DOCS}%22 from the front of the line, and type them in the startup configuration window.\n", 
"With MacOS, you can also use AppleScript or Drag-and-Drop to send {PRODUCT_NAME} an %22Open Document%22\n", 
"message pointing to a configuration file.\n", "When a configuration file is dropped on the {PRODUCT_NAME} icon in the Finder,\n", 
"or when {PRODUCT_NAME} receives an AppleEvent instructing it to open a configuration file,\n", "{PRODUCT_NAME} reads the contents of the\n", 
"configuration file (a text file), and processes it exactly as it processes a command\n", "line on UNIX or Windows.\n", 
"Finally,\n", "you can run a configuration directly from AppleScript\n", "by sending {PRODUCT_NAME} a %22run config%22 AppleScript message; see {PRODUCT_NAME}'s AppleScript dictionary\n", 
"for more information.<p>\n", "\n", "For instance, you may prefer to build and update your configuration databases from the command line, \n", 
"avoiding the overhead of the web interface.  To rebuild a configuration database from the command line, \n", 
"do this:\n", "\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf {config-name} -cm cd</pre> \n", "\n", "(replacing {config-name} with the name of your configuration), or update it using \n", 
"\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf {config-name} -cm ud</pre> \n", "\n", "or expire old hits from the database (see [edd]) using \n", 
"\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf {config-name} -cm ed</pre> \n", "\n", "<code>rfcf</code> is short for <code>read_from_config_file</code>; see [rfcf].\n", 
"<code>cm</code> is short for <code>configuration_mode</code>; see [cm].\n", "You can then browse that database from the web browser interface.\n", 
"If you'd prefer to generate offline HTML for the configuration, you can do this: \n", "\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf {config-name} -cm ghf</pre> \n", 
"\n", "If you have 200 Meg of memory and 2 Gig of disk to spare and want your database built to go fast, \n", 
"you could use this:\n", "\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf {config-name} -cm cd -dwbs 200M</pre> \n", 
"\n", "That overrides the [dwbs] option for the configuration for the duration \n", "of the database build.  If you want the changes to be permanent, you can \n", 
"modify the original configuration file, either with a text editor \n", "(a configuration file is just a long command line), or from [docs-configpage].<p>\n", 
"\n", "You can add any options to the command line that you can add to a configuration file (and vice versa), \n", 
"so the {PRODUCT_NAME} command line provides a great deal of flexibility.  See \n", "[docs-options] for information on the available options.<p> \n", 
"\n", "<h4>Creating and Editing Configuration Files</h4>\n", "\n", "{PRODUCT_NAME} stores configurations in configuration files (see [docs-configfiles]), \n", 
"in the Configs {DIRECTORY_WORD} of the {PRODUCT_NAME} Information {DIRECTORY_WORD}\n", "(usually called LogAnalysisInfo).<p>\n", 
"\n", "Configuration files are just command lines in disguise; \n", "{PRODUCT_NAME} treats them just as if their contents \n", 
"were added to its command line.  They are simple text files, and you can edit them with any text editor. \n", 
"When you create a configuration from [docs-adminmenu], {PRODUCT_NAME} creates a configuration file \n", 
"with the name you chose, in the Configs sub{DIRECTORY_WORD} of the LogAnalysisInfo {DIRECTORY_WORD}.\n", 
"If you edit a configuration, the next time you open or use that configuration (for example, from [docs-adminmenu]), \n", 
"your modifications will change what the configuration causes {PRODUCT_NAME} to do.\n", "Some advanced users do most of their configuration editing with a text editor, \n", 
"rather than from [docs-configpage].<p> \n", "\n" "Of course, you can still use the %22Edit Configuration%22 button\n", 
"and [docs-configpage] \n", "whenever you want, even to make modifications to configurations you have changed \n", 
"with a text editor.  However, {PRODUCT_NAME}'s web browser interface will recreate the configuration \n", 
"file using its own formatting, so don't use it if you've added your own comments or \n", "changed the text formatting!<p>\n", 
"\n", "<h4>Using the {PRODUCT_NAME} URL Command Line</h4> \n", "\n", "There's one more place you can specify configuration options, in addition to \n", 
"the standard (console) command line and configuration files, and that's \n", "the URL command line.  The URL command line is embedded into the \n", 
"{PRODUCT_NAME} URL itself.  For instance, during normal \n", "browsing you may see that your browser is displaying \n", 
"\n", "<pre>  http://www.mycompany.com:8987/{PRODUCT_EXECUTABLE_DOCS}?rfcf+myconf+f+1,5,2+asv+1</pre> \n", 
"\n", "The first part of this (http://www.mycompany.com:8987/{PRODUCT_EXECUTABLE_DOCS}, which will be \n", 
"http://www.mycompany.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi if you're using CGI mode) \n", "is the location of {PRODUCT_NAME}, as accessed \n", 
"from your browser.  The rest of it (the part after the ?) is \n", "the URL command line (also known as the HTTP argument).  The URL command line is very similar to \n", 
"a normal command line, except that plusses (+) are used instead of spaces \n", "to separate pieces of the command line.<p> \n", 
"\n", "For instance, browsing the URL above is equivalent to running the command \n", "\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf myconf -f 1,5,2 -asv 1</pre> \n", 
"\n", "(as in normal command lines and configuration files, options on the URL \n", "command line may be preceded by a - to improve legibility, but it's optional). \n", 
"The <code>rfcf</code> part tells it which configuration to browse (if \n", "you've browsed a bit already, this may be a temporary configuration, with \n", 
"your browsing machine's hostname and the current time encoded in it), the \n", "<code>f</code> part tells what filters to use, and the <code>asv</code> part tells what view to show.<p>\n", 
"\n", "The very fastest way to make a temporary configuration change is to add it to the \n", "URL command line, and load that page.  For instance, if you want to change the \n", 
"width of pie charts, you can add <code>+pcw+500</code> to the URL in your browser window, \n", "and press return to load that page.  {PRODUCT_NAME} will be immediately redisplay the statistics \n", 
"with that option (the URL command line options override any other options), and you \n", "will be able to see your pie charts 500 pixels wide without having to make a trip \n", 
"to [docs-configpage] or your text editor.<p> \n", "\n", "The URL command line is a powerful way to try out new options quickly, but it has \n", 
"one major limitation--you cannot change any <i>secure</i> options from the URL \n", "command line.  Secure options are options which read or write, directly or indirectly, \n", 
"from or to the server file system.  They include options like [lsu], [dd], and [ph]. \n", "Secure options are not permitted on the URL command line because the URL command line \n", 
"is available to everyone, even those without a password.  Therefore, the URL command line \n", "options are limited to options which cannot do any damage.<p>\"\n", 
"\n", "\n", "##\n", "## statspages documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_statspages \"Statistics Pages\"\n", 
"DOCS_PAGE_CONTENTS_statspages\n", "\"Statistics pages present log file statistics in an attractive and easily navigable \n", 
"graphical format. \n", "\n", "Statistics pages are broken into several sections:<p> \n", "\n", "<h2>The View Sidebar</h2>\n", 
"The View Sidebar appears at the left of every statistics page.  \n", "It shows you which view you are looking at, and it lets you switch \n", 
"to a different view.  A view is a particular way of looking at a section of \n", "your data.  You choose <i>which</i> data you're looking at by using the Filters (see below), \n", 
"and you choose <i>how</i> you look at it using the View Menu.  For instance, \n", "if the filters are set to show data from January, 2000, you can switch to the \n", 
"%22{VIEW_LABEL_FOR_FIELD_page}%22 view to show which pages and directories were hit most \n", "during that period, or you could switch to the %22{VIEW_LABEL_FOR_FIELD_date/time}%22 view \n", 
"to show which days in January had the most hits, or you could switch to the \n", "%22Paths through the site%22 view to see which paths visitors followed \n", 
"through the site.  Views in the sidebar may be dimmed if they have been hidden \n", "(in the Stats Views tab of the Configuration Options), or they may be colored red \n", 
"if the data in that view is not available due to lack of database cross-references \n", "(in that case, switching to the view will explain why the data is not available).<p>\n", 
"\n", "There are many views available.  Exactly which views are available vary depending on your \n", 
"log format and database structure.  The views which <i>may</i> be available include:<p>\n", "\n", "<ul> \n", 
"  <li> <b>{SUBVIEW_TYPE_calendar}:</b>  This view is a calendar showing \n", "       the years, months, and days during which there was traffic.  Clicking \n", 
"       any day, week, month, or year shows the traffic during that time, \n", "       by setting a Filter to %22zoom in%22 on that time period.<p>\n", 
"\n", "  <li> <b>{SUBVIEW_TYPE_overview}:</b>  This view shows an overview of the traffic, \n", "       including number of hits, bytes transferred, and more.  It also provides some \n", 
"       basic instructions for using the Filters and the View menu, and includes \n", "       links to all available views.<p>\n", 
"\n", "  <li> <b>Top <i>fields</i>:</b>  There will be one of these views \n", "       for each field in the database.  These views show the \n", 
"       top items to the corresponding type.  For instance, the  \n", "       %22{VIEW_LABEL_FOR_FIELD_page}%22 view shows hits broken down by page, file, or directory.<p>\n", 
"\n", "  <li> <b>{SUBVIEW_TYPE_date_graph}:</b>  This graphs the traffic chronologically.<p> \n", "\n", 
"  <li> <b>{SUBVIEW_TYPE_average_days_of_week}:</b>  This shows the average \n", "       hits on each day of the week.  For instance, if there is just one Monday \n", 
"       in the log data, and it has 100 hits, it will show up as 100 (1).  \n", "       If there are two Tuesdays, and they have 100 and 200 hits, then Tuesday will show \n", 
"       up as 150 (2), because there were on average 150 hits on Tuesdays.\n", "       See the notes at the bottom of this list for more information.<p>\n", 
"\n", "  <li> <b>{SUBVIEW_TYPE_average_hours_of_day}:</b>  This shows the average \n", "       hits on each hour of the day.  For instance, if there is just one 1PM-2PM slot \n", 
"       in the log data, and it has 100 hits, it will show up as 100 (1).  \n", "       If there are two 2PM-3PM slots, and they have 100 and 200 hits, then 2PM-3PM will show \n", 
"       up as 150 (2), because there were on average 150 hits on 2PM-3PM slots.\n", "       See the notes at the bottom of this list for more information.<p>\n", 
"\n", "  <li> <b>{SUBVIEW_TYPE_search_terms_computed}:</b>  This view shows the individual search \n", 
"       terms (search words) which were used during searches to find the web site (i.e. the \n", "       words which were typed into search engines). \n", 
"       The terms are computed on the fly by examining the %22search phrase%22 field in the\n", "       database.  It is slower \n", 
"       to display than the search phrases view, but it shows individual terms searched for, \n", "       rather than complete phrases, so it may be useful in some cases.<p>\n", 
"\n", "  <li> <b>{SUBVIEW_TYPE_sessions_summary}:</b>  This view shows a summary of the %22sessions%22 associated with \n", 
"       the data.  A session is a series of page accesses by the same hostname in succession. \n", "       It roughly corresponds to someone arriving at a web site, visiting some pages, and \n", 
"       then leaving.  {PRODUCT_NAME} shows all the individual sessions in this view, as well as \n", 
"       some average session statistics (average number of pages accessed, visit duration, etc.).\n", 
"       {PRODUCT_NAME} assumes that  someone has left the site if they have \n", "       not loaded a page for an hour.  A delay of up to an hour is allowed; an access \n", 
"       after 50 minutes is considered a continuation of the current session.<p>\n", "\n", "  <li> <b>{SUBVIEW_TYPE_session_paths}:</b>  This view shows the paths visitors took through \n", 
"       the site.  You can collapse or expand sections of the paths by clicking the + or - icons.<p>\n", 
"\n", "  <li> <b>{SUBVIEW_TYPE_session_page_paths}:</b>  This view shows the paths visitors took through \n", 
"       a particular page of the site.  The view shows all pages that were visited just before \n", 
"       that particular page, and all pages that were visited just afterwards.<p>\n", "\n", "  <li> <b>{SUBVIEW_TYPE_entry_pages}:</b>  This view shows the first pages visitors hit \n", 
"       when they came to the site.<p>\n", "\n", "  <li> <b>{SUBVIEW_TYPE_exit_pages}:</b>  This view shows the last pages visitors hit \n", 
"       before they left the site.<p>\n", "\n", "  <li> <b>{SUBVIEW_TYPE_time_per_page}:</b>  This view shows the total and average time spent by visitors on each \n", 
"       page of the site.<p>\n", "\n", "  <li> <b>{SUBVIEW_TYPE_sessions}:</b>  This view shows all the sessions.<p>\n", 
"</ul>\n", "<p>\n", "Note: Any view with %22{COMPUTED_TAG}%22 in its name requires a large number of database accesses \n", 
"to display.  For very large databases, the amount of database access may be so great \n", "that the pages take minutes or hours to display.  Use caution when attempting to display these views \n", 
"of the data; often you can find useful information faster using the non-computed views.<p>\n", "\n", 
"Note: the {COMPUTED_TAG} days of week and hours of day views are computed \n", "dynamically from the date/time field, so they do not require a day of week or \n", 
"hour of day database field.  Furthermore, as long as the date/time field is cross-referenced \n", "with the appropriate fields, this report will work with other fields filtered.\n", 
"However, views based on a database field will generally be faster \n", "to display.  To use the {COMPUTED_TAG} days of week views, there must be \n", 
"day information in the date/time field; i.e. the %22suppress bottom%22 level must be 3 or more, \n", 
"or Include Bottom-level Items must be turned on.  To use the {COMPUTED_TAG} hours of day views, there must be \n", 
"hour information in the date/time field; i.e. the %22suppress bottom%22 level must be 4 or more, \n", 
"or Include Bottom-level Items must be turned on.  For best performance, use the \n", "appropriate %22suppress bottom%22 level (3 or more for days, 4 or more for hours) <i>even if</i> \n", 
"Include Bottom-level Items is turned on; generating these views from just the \n", "bottom-level items can be extremely slow.<p>\n", 
"\n", "<h2>The Filters</h2>\n", "The second factor that determines what statistics you see (besides the view you choose) \n", 
"is the set of Filters you choose.  The Filters (not to be confused with the Log Filters, which \n", 
"selectively discard parts of your log data as it is being processed) let you \n", "%22zoom in%22 on one part of your data.  You can use the Filters to get information \n", 
"about a particular day, or a particular {DIRECTORY_WORD}, or a particular domain, or more.<p>\n", "\n", 
"Filters control which portion of your data you are \n", "looking at.  If there are no filters in place (if the Filters \n", 
"display reads, %22Filters: This page shows hits for all the log data%22),\n", "that means you are looking at your complete \n", 
"data; your entire log file is represented by the graphs and tables shown.\n", "If the Filters display shows that there are filters active \n", 
"(for instance, if it reads %22This page shows hits during Jun/2000), \n", "then you are <i>not</i> seeing your \n", 
"entire data; you are seeing only a portion of it.  The portion you're looking at \n", "depends on the Filters.  If, for example, the only filter is a /dir1/ filter on the page field, \n", 
"then the data displayed below shows only \n", "those hits which were on /dir1/ or pages contained in /dir1/ (or in other {PLURALIZE:{DIRECTORY_WORD}} \n", 
"contained in /dir1/, or pages in them, etc.).  For instance, if you have 1000 hits on \n", "your site, and 500 of them were inside /dir1/, then if there are not filters active, you will see \n", 
"1000 hits in the tables and graphs, or all the hits on your site. \n", "But if there is a Filter /dir1/ on the page field, you will see \n", 
"500 hits, or only those hits in /dir1/.<p>\n", "\n", "The Filters are an extremely powerful way of getting detailed information \n", 
"about your site.  If you want to know what day you got the most hits on /dir1/, \n", "you can do that by adding /dir1/ as a filter, and then changing to the %22{VIEW_LABEL_FOR_FIELD_date/time}%22 \n", 
"view (see The View Menu, above).  With /dir1/ as a filter, you will see \n", "only those hits on /dir1/ (500 of them, in the example above), and you will see \n", 
"how those 500 hits break down by date and time.  You can add an additional filter \n", "to the date/time field if you want to examine just the hits on /dir1/ on a particular \n", 
"day.  This gives you almost infinite flexibility in how you want to examine your data.<p>\n", "\n", 
"The Filters Editor lets you add, change, and remove filters. \n", "You can edit the current filters by clicking the %22edit%22 link in the Filters bar.\n", 
"Another way to change filters is to click on something in the statistics. \n", "For instance, clicking on a {DIRECTORY_WORD} name in a page table will %22zoom in%22 \n", 
"on that {DIRECTORY_WORD} by adding it as the page field filter.  Clicking on a month \n", "in the calendar view will %22zoom in%22 on the month by adding it as the date/time field filter.\n", 
"If the %22{VIEW_ELEMENTS_FilterCheckboxes}%22 option is turned on (using the Show menu; see below), \n", 
"you can click the check box next to any item and choose a view from the menu below the table, \n", 
"to set that item as a filter, and then change the view to the view you select. \n", "For instance, clicking the checkbox next to a particular {DIRECTORY_WORD} name, \n", 
"and selecting %22Show checked data in 'Top days' view%22 will \n", "add the {DIRECTORY_WORD} as a page filter, and also change \n", 
"to the top days statistics view; this is a quick way of answering the question, \n", "%22what days did I get hits on this {DIRECTORY_WORD}?%22<p>\n", 
"\n", "<h2>The Statistics</h2>\n", "\n", "The statistics appear in the middle of the page, in the form of one or more \n", 
"graphs or tables.  The data shown in the graphs and tables depends on the Filters \n", "(see above), and the chosen View (see above).  The appearance of the statistics, \n", 
"including which columns are shown in tables, how the data is sorted, which graphs appear, \n", "and more, depends on the Options and Sort menus (see below).<p> \n", 
"\n", "<h2>The Options Menu</h2>\n", "The Options menu controls which elements of the statistics are visible. \n", 
"Most elements are optional, and you can turn them on or off by selecting them from the Options menu. \n", 
"Examples include the columns of tables\n", "(e.g. the hits and bandwidth rows), \n", "the special rows of tables (e.g. the total and averages rows), \n", 
"the pie charts, and more.  The list of available elements \n", "changes depending on the view, the database structure, and other \n", 
"configuration options.<p>\n", "\n", "Most of the elements are self-explanatory, but a few are not:<p>\n", 
"<ul>\n", "  <li><b>only bottom level items</b>.  When this special element is %22shown%22, it \n", 
"      changes the way the data is structured.  Instead of showing the number of hits on \n", "      a {DIRECTORY_WORD}, this shows all of the files in the {DIRECTORY_WORD} individually, with \n", 
"      the number of hits on each.  For instance, instead of showing 50 hits on /dir1/ and 30 hits on /dir2/, this \n", 
"      might show 20 hits on /dir1/file.html, 20 hits on /dir1/file2.html, 10 hits on /dir1/file3.html, \n", 
"      20 hits on /dir2/file4.html, and 10 hits on /dir2/file5.html.  In other words, if you're looking at \n", 
"      a %22pages and {PLURALIZE:{DIRECTORY_WORD}}%22 view, this pulls all the pages up into a single table, and does not \n", 
"      show any {PLURALIZE:{DIRECTORY_WORD}}.  Similarly, in a year/month/day view, this shows only the days, even if \n", 
"      they are in different months or years.  In general, showing this element causes all of the bottom-level \n", 
"      items (days, pages, domains, full URLs, etc.) to be shows in a single table, and does not show any of \n", 
"      the %22enclosing%22 items.<p>\n", "  <li><b>filter checkboxes and menu</b>.  When this is shown, checkboxes appear next to \n", 
"      every item in the table, and a menu appears at the bottom.  To use these checkboxes and menu, \n", 
"      check the items you are interested in, and select something from the menu; the checked items \n", 
"      will become Filters, and you will be switched to the view you selected from the menu.<p>\n", 
"</ul>\n", "\n", "<h2>The Sort Menu</h2>\n", "The Sort menu determines how statistics tables are sorted.  \n", 
"For instance, choosing %22by hits%22 will sort the table with the items with \n", "the most total hits at the top.  Choosing %22by bandwidth%22 will sort with \n", 
"the items at the top which contributed the most bandwidth.  The available \n", "options vary depending on the view and the database structure.<p>\n", 
"\n", "<h2>Miscellaneous</h2>\n", "\n", "A toolbar at the bottom of the table lets you control the number of rows displayed.\n", 
"For instance, if there are 100 possible items in the table, and 20 are displayed (with \n", "%2280 other items%22 as the last row), then clicking %22show more rows%22 will double \n", 
"the number of rows to 40, so the table will be twice as tall, with %2260 other rows%22 as \n", "the last row.  Clicking %22show fewer rows%22 will halve the number of rows to 10, so the \n", 
"table will be half as tall, with %2290 other rows%22 as the last row.  Clicking %22show all rows%22 \n", 
"will show all possible rows of the table, so the table will be 100 rows tall, and there will \n", "be no %22other rows%22 row.<p>\n", 
"\n", "Note: the statistics may contain information on the number of %22visitors.%22 \n", "For most log formats, visitors are computed by counting \n", 
"the number of unique hostnames \n", "in the log data associated with this item.  Though there is some correlation between unique \n", 
"hosts and the number of %22true%22 visitors, the correlation is far from exact.  \n", "Dynamically allocated IP numbers can make a single visitor appear as many different hostnames \n", 
"in the course of a single session, inflating this number, and firewalls can make all the visitors \n", 
"behind the firewall appear to be a single hostname, deflating the number.  Do not assume \n", "that this number accurately represents the number of people who visited the site!<p>\n", 
"\n", "For more information on the types of views and subviews available, and on \n", "the types of view elements available, see [vi].<p>\n", 
"\"\n", "\n", "\n", "##\n", "## commandline documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_commandline \"The Command Line\"\n", 
"DOCS_PAGE_CONTENTS_commandline\n", "\"The {PRODUCT_NAME} command line \n", "can accept any options which can be put in a \n", 
"configuration file.  See \n", "[cat-all] for a list of all options.<p> \n", "\n", "On UNIX and Windows systems, command line options can be\n", 
"specified by just typing them after the executable name on the command line\n", "as shown below.  On MacOS systems, %22command line%22 options\n", 
"(really just startup configuration options) can be specified\n", "by holding down the option key while launching {PRODUCT_NAME}, and\n", 
"typing the options in the window which appears.  On MacOS,\n", "you should not include the name of the {PRODUCT_NAME} application in this Startup Configuration window.<p>\n", 
" \n", "To improve ease of reading, a hyphen (<code>-</code>) can be added to the beginning \n", "of any configuration option.<p> \n", 
" \n", "Below is a sample command line which reads a log file and adds its contents to an existing \n", 
"database (see [docs-database]).<p> \n", " \n", "<pre>{PRODUCT_EXECUTABLE_DOCS} -read_from_config_file myconfig \n", 
"          -configuration_mode updatedatabase \n", "          -log_source_url /var/log/httpd/access_log \n", 
"</pre> \n", " \n", "This same command line could be also be written as:<p> \n", " \n", "<pre>{PRODUCT_EXECUTABLE_DOCS} -rfcf myconfig -cm ud -lsu /var/log/httpd/access_log \n", 
"</pre><p>\n", "\n", "See [docs-poweruse] for more command line examples.<p>\n", "\"\n", "\n", "\n", 
"##\n", "## troubleshooting documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_troubleshooting \"Troubleshooting\"\n", 
"DOCS_PAGE_CONTENTS_troubleshooting\n", "\"This page contains troubleshooting information.  You should consult \n", 
"this page when something goes wrong with the installation or use of {PRODUCT_NAME}.<p>\n", "\n", "For additional installation-related troubleshooting tips, see the end of the [docs-installation] chapter.<p>\n", 
"\n", "<h3>Problem: {PRODUCT_NAME} doesn't run properly when I try to run/launch it</h3>\n", "On Windows and MacOS, this should never happen; double-clicking {PRODUCT_NAME} (or running it from the Start menu)\n", 
"should bring up a window with the {PRODUCT_NAME} logo and some text.  If it doesn't, please contact\n", 
"us at <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>,\n", "so we can investigate.<p>\n", "\n", 
"On UNIX, this is the major obstacle to using {PRODUCT_NAME}.  There are dozens of types \n", "of UNIX out there, and often several variants of each type.  Since {PRODUCT_NAME} is a \n", 
"binary compiled program (rather than an interpreted program), \n", "it will only run on a system similar to the one it was built on. \n", 
"We have attempted to build {PRODUCT_NAME} on as many different systems as possible, \n", "to ensure that it runs on the vast majority of customers' machines, but it is a difficult \n", 
"task due to the great variety available.<p>\n", "\n", "To start, you need to find a version of {PRODUCT_NAME} \n", 
"with a hardware architecture and operating system which matches yours.  For instance, \n", "if you're running Linux on an x86/Pentium system, you need to download the version of {PRODUCT_NAME} \n", 
"for x86/Linux.  The x86/FreeBSD version won't work, and neither will the Alpha/Linux version.\n", "If there are several versions of {PRODUCT_NAME} which seem to approximately match your setup, \n", 
"try them <i>all</i>--keep running them until one of them works.\n", "Remember that you have to gunzip and untar them before you can use them--see [docs-installation].\n", 
"If possible, run them from the command line (e.g. using telnet) first, even if you intend to \n", "run them as CGI--there are a lot fewer things that can go wrong with a command-line run, so \n", 
"you'll know right away if it doesn't work.  If none of them work when run from the command line (via telnet), \n", 
"please contact us at <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>, so we can \n", "help you get {PRODUCT_NAME} running.<p>\n", 
"\n", "If you can't run {PRODUCT_NAME} from the command line (i.e. if you have only FTP access to your server), \n", 
"you can still use it.  You'll need to gunzip it and untar it somewhere else (gunzip and untar \n", 
"programs are available for all platforms), and then upload the <code>{PRODUCT_EXECUTABLE_DOCS}</code> binary program (the large \n", 
"file in the resulting {DIRECTORY_WORD}) in <i>binary</i> mode to your cgi-bin {DIRECTORY_WORD}.\n", 
"Change it to readable and executable by %22all%22 or %22world%22\n", "using your ftp client (using chmod or whatever your ftp client uses \n", 
"to change permissions).\n", "If possible, change your cgi-bin {DIRECTORY_WORD} to world writable temporarily during the {PRODUCT_NAME} install; \n", 
"it makes the install simpler.  Some servers won't allow that, so if you have problems, change it back \n", 
"to world read-only and try again.  In any event, you should change it back to read-only after installation.\n", 
"Once the binary is there and ready to run, try running it from a web browser, using the \n", "appropriate URL for your server (it's often something like http://www.myserver.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}).\n", 
"If you get an error, try looking in your web server's error log, if one is available, to see what \n", 
"went wrong.  If it simply didn't run, or crashed, and if there's another version available for \n", 
"your platform, try that version instead.  If none of the versions work, please contact us at \n", "<a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>.<p>\n", 
"\n", "You should use a %22dynamic%22 version of {PRODUCT_NAME} for your platform if you can; \n", "if it doesn't work properly, use the %22static%22 version instead.<p>\n", 
"\n", "<h3>Problem: I can't %22zoom in%22 past a certain level</h3>\n", "If you're finding that beyond a certain depth, {PRODUCT_NAME} won't let you \n", 
"zoom in any further (the items in the tables are no longer clickable), \n", "you probably have a limit on the depth of that field in the Database Structure \n", 
"Options.  Edit your configuration, go to the Database Structure Options, \n", "and increase the Suppress value for the field you want more detail on. \n", 
"Then rebuild your database and the items should become clickable.<p>\n", "\n", "<h3>Problem: The web browser crashes</h3>\n", 
"It is important to distinguish this problem from %22{PRODUCT_NAME} crashes,%22 listed below.\n", "If you are using {PRODUCT_NAME} through a web browser, and the web browser window \n", 
"(the one displaying the {PRODUCT_NAME} menu, configuration information or statistics) disappears,\n", 
"then it is your web browser that has crashed, not {PRODUCT_NAME}.\n", "This is usually caused by a bug in your web browser.  One common cause of this is \n", 
"if you are using a version of Netscape older than 4.5, and a single-threaded or CGI-based \n", "version of {PRODUCT_NAME}.  In that case, {PRODUCT_NAME} uses a technique to send progress pages \n", 
"which can crash Netscape (due to a bug in Netscape).  To eliminate this problem, \n", "upgrade to Netscape 4.5, or use a multithreaded version of {PRODUCT_NAME} in web server mode. \n", 
"If that's not an option, set the value of [ppi] high to minimize the number of progress pages sent.<p>\n", 
"\n", "<h3>Problem: {PRODUCT_NAME} crashes</h3>\n", "See above (<b>The web browser crashes</b>) to verify that it was really {PRODUCT_NAME}, \n", 
"and not your web browser, which crashed. \n", "The most common cause of crashes is when {PRODUCT_NAME} runs out of memory while building a database.  Try \n", 
"watching {PRODUCT_NAME}'s memory usage (using <code>top</code> on UNIX, or \n", "the Process Manager on Windows, or the About This Computer window on MacOS) \n", 
"while it is processing, to see if it is consuming all available memory. \n", "{PRODUCT_NAME} will often generate an error when it runs out of memory, but due to \n", 
"technical reasons, this is not always possible, and sometimes running out of \n", "memory can cause {PRODUCT_NAME} to crash.  See <b>{PRODUCT_NAME} runs out of memory</b>, below, \n", 
"for suggestions on limiting {PRODUCT_NAME}'s memory usage.<p> \n", "\n", "Barring out-of-memory problems, {PRODUCT_NAME} should never crash; if it does, \n", 
"it is a probably significant bug in {PRODUCT_NAME}.  We do our best to ensure that {PRODUCT_NAME} is bug-free, \n", 
"but all software has bugs, including {PRODUCT_NAME}.  If {PRODUCT_NAME} is crashing on your computer, \n", 
"we would like to hear about it--please send email to\n", "<a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>,\n", 
"describing the type of computer you are using and the circumstances surrounding the crash.\n", "We will track down the cause of the crash, fix it, and send you a fixed version of {PRODUCT_NAME}.<p>\n", 
"\n", "<h3>{PRODUCT_NAME} runs out of memory</h3>\n", "{PRODUCT_NAME} can use a lot of memory when it processes large amounts of data.\n", 
"If there is not enough memory available for {PRODUCT_NAME} to perform the task you have \n", "requested, it will generate an error message, reporting that it could not allocate \n", 
"as much memory as it needed, and it will stop doing whatever it was doing.<p>\n", "\n", "One way to fix this problem is to increase the amount of memory available to {PRODUCT_NAME}.\n", 
"On MacOS, {PRODUCT_NAME} starts with a partition of up to 30 Meg, if there is that much \n", "available; if {PRODUCT_NAME} is running out of memory, try increasing its partition size \n", 
"by clicking the {PRODUCT_NAME} icon in the Finder, and using Get Info from the File menu \n", "to increase the Preferred memory size.  On UNIX, you can increase the amount of memory \n", 
"available to individual processes; how this is done varies, but try the <code>limit</code> \n", "command.  On any platform, you can add more physical memory, or increase the amount of\n", 
"virtual memory, to let {PRODUCT_NAME} have more memory to work with.<p> \n", "\n", "You can reduce the amount of memory {PRODUCT_NAME} uses while it builds a database using the \n", 
"Database Options section of the documentation; \n", "turn [dwbs] down to lower value to limit {PRODUCT_NAME}'s memory usage.  \n", 
"You can reduce the amount of memory {PRODUCT_NAME} uses while it browses statistics \n", "using the [drcs] options.  See [docs-resources] for a discussion of memory \n", 
"usage, disk usage, processing time, and how they relate to each other.<p>\n", "\n", "\"\n", "\n", "\n", 
"##\n", "## configfiles documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_configfiles \"Configuration Files\"\n", 
"DOCS_PAGE_CONTENTS_configfiles\n", "\"\n", "Note: you can avoid ever dealing with configuration files by using \n", 
"{PRODUCT_NAME} through the web browser interface.  You only need to know \n", "about configuration files if you want to edit them directly (which is \n", 
"usually faster than using the web interface), or use them from the \n", "command line.<p>\n", "\n", 
"{PRODUCT_NAME} configuration files are text files \n", "containing a sequence of configuration commands (see [cat-all]) \n", 
"separated by whitespace.  Any whitespace is considered the same as any \n", "other whitespace, so configuration options can be separated by one or more \n", 
"spaces, tabs, or returns.  If whitespace needs to be preserved, it can \n", "be enclosed in either single or double quotes.<p> \n", 
"\n", "{PRODUCT_NAME} creates a configuration file in the Configs sub{DIRECTORY_WORD} of the \n", "{PRODUCT_NAME} {DIRECTORY_WORD} when you use the Create Configuration button on [docs-adminmenu].\n", 
"Temporary configuration files are also used internally by the \n", "web browser interface to transmit configurations from one page to another. \n", 
"Generally the web browser interface's use of configuration files is transparent, and can be ignored. \n", 
"Configuration files can also be created by hand using a text \n", "editor.  To read them from the web browser interface, you will need to put them in the \n", 
"Configs {DIRECTORY_WORD}; from [docs-commandline] they can be read from anywhere.<p> \n", " \n", "Comments can be added to configuration files using the # character. \n", 
"Any occurrence of a # at the beginning of a new option will be \n", "interpreted as a comment, and the remainder of the line containing the # \n", 
"will be ignored.  This is the only difference between \n", "configuration files and command line; command lines cannot contain comments.<p> \n", 
"\n", "Any configuration which can be specified in a configuration file can \n", "also be specified in [docs-commandline] \n", 
"by using the same configuration options.<p>\n", "\n", "To see a sample configuration file, use the web browser interface \n", 
"to create a configuration, and then examine the file in the Configs \n", "{DIRECTORY_WORD}.  {PRODUCT_NAME} includes extensive comments in configuration \n", 
"files to help you understand them.<p>\"\n", "\n", "\n", "##\n", "## multipleusers documentation page text\n", 
"##\n", "\n", "DOCS_PAGE_TITLE_multipleusers \"Setting up Multiple Users (ISP Setup)\"\n", "DOCS_PAGE_CONTENTS_multipleusers\n", 
"\"\n", "One of the most common ways of using {PRODUCT_NAME} is to publish \n", "statistics for many sites to the users who own them.  \n", 
"This is the standard mode of operation for an ISP--you want to \n", "provide all of your customers with statistics, with each customer \n", 
"seeing only statistics for their own site, and no other sites. \n", "Non-ISP users of {PRODUCT_NAME} may also need a similar setup, to provide \n", 
"statistics for different sites, or sections of the \n", "same site, to several different people. \n", 
"{PRODUCT_NAME} makes this easy.<p>\n", "In a nutshell, what you'll do is create a configuration for each \n", 
"user (possibly using the Create/Update Many Configurations option in the \n", "administrative menu), each with a different password if you want to \n", 
"prevent users from seeing each others' statistics. \n", "You'll set up each configuration to read only the relevant log data, \n", 
"and you'll choose a different password for each configuration, if you want to \n", "prevent users from seeing each others' statistics. \n", 
"Finally, you'll deliver the statistics to the users as a URL, pointing to \n", "an active copy of {PRODUCT_NAME}, and they'll use a browser to view their statistics.<p>\n", 
"<h3>Creating the First Configuration</h3>\n", "The first thing you'll need to do is create a configuration for each user. \n", 
"Start by creating one configuration and setting it up the way you like. \n", "From the Administrative Menu, click Create Configuration, and \n", 
"follow the instructions to create the configuration.  For now, use the name \n", "of the domain as the configuration name.  In this example, we'll \n", 
"assume that you're an ISP setting up a site for mysite.com, so you'll name the \n", "configuration mysite.com.<p>\n", 
"If each \n", "user has separate log files, point this configuration's Log Source to the appropriate \n", 
"log files; you can skip \n", "over all the information about filters below\n", "Otherwise, point the Log Source at the combined log data.<p>\n", 
"If all the users' log data is combined into a single file, you'll need to \n", "create a log filter to separate out the hits for just this user.  For instance, \n", 
"if you're logging 100 web sites to a single file, \n", "then you'll need to create a log filter to reject \n", 
"all hits except those from mysite.com.  Exactly how this is done depends on \n", "how your server indicates which site each hit was on, but usually it's logged in a \n", 
"%22server domain%22 field.  The filter in that case is<p>\n", "<ul>\n", "  if the server domain field is equal to mysite.com<br>\n", 
"  then continue to the next filter<br>\n", "  otherwise, reject this entry (and stop filtering)<br>\n", 
"</ul>\n", "You can create this filter like this:<p>\n", "<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", 
"  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Click the double square to the left of the first filter to duplicate it (the filters are in the yellow box).<p>\n", 
"  <li> Click the blue triangle to the left of the new first filter to edit it.<p>\n", "  <li> Choose %22If A is true, then do B; otherwise do C%22 from the top menu of the filter.<p>\n", 
"  <li> Choose %22value1 = value2%22 in the A:Type menu.<p>\n", "  <li> Choose %22server domain%22 in the A:value1 menu.<p>\n", 
"  <li> Choose %22this value:%22 in the A:value2 menu, and enter the domain name\n", "       (mysite.com in this example) to the right of the menu.<p>\n", 
"  <li> Choose %22goto next filter%22 in the B Action menu.<p>\n", "  <li> Choose %22reject%22 in the C Action menu.<p>\n", 
"  <li> Click the blue arrow to collapse the filter.<p>\n", "  <li> Verify that the filter's description looks like that above.<p>\n", 
"</ol><p>\n", "If your server logs the server domain information as part of the page field instead, \n", 
"you can use a similar filter:<p>\n", "<ul>\n", "  if the page field contains /mysite.com/<br>\n", "  then continue to the next filter<br>\n", 
"  otherwise, reject this entry (and stop filtering)<br>\n", "</ul>\n", "For more information about log filters, see [docs-filters].<p>\n", 
"If your server logs each domain to a separate log file, then you're in luck-- \n", "you don't need to do anything with filters.  Just point your configuration \n", 
"to the proper log files.  In addition to being simpler to set up, this is \n", "also more efficient, because {PRODUCT_NAME} will only have to read each log file once. \n", 
"Because of these advantages, \n", "it may be worth reconfiguring your web server to log each domain to a separate \n", 
"location.<p>\n", "At this point, you've done the most important steps in creating the first \n", "configuration.  All your other configurations will be based on this one, \n", 
"so if you have some options that you know you're going to use in every configuration \n", "(for instance, a custom header or footer), you can set them now.  You'll also be \n", 
"able to change options later, if you want.<p>\n", "<h3>Creating the Rest of the Configurations</h3>\n", 
"The first configuration you created is the template you will use\n", "to create the rest.  The easiest way to do this is to \n", 
"go to the Administrative Menu, click Create/Update Many Configurations, \n", "select your template configuration from the list, enter the names \n", 
"of all your other configurations, and click the button.  \n", "{PRODUCT_NAME} will create a configuration for each line you enter in the field. \n", 
"Any occurrences of the template configuration name in the template configuration \n", "(in the filters, headers, footers, or anywhere else) will be replaced \n", 
"in each created file with that configuration's name. \n", "If you choose your configuration names carefully, this can save you a lot of work. \n", 
"The filter you created above will be changed in each configuration, \n", "so instead of rejecting all entries except those from mysite.com, it \n", 
"will reject all entries except those from the current site. \n", "For instance, if you create a configuration named yoursite.com, \n", 
"{PRODUCT_NAME} will automatically convert the filter to reject all hits except those from yoursite.com. \n", 
"This means that you don't usually need to edit filters or most other options on a configuration-by-configuration \n", 
"basis.\n", "<p>\n", "If you have a separate location for each site's logs, then you don't have a filter, but \n", 
"{PRODUCT_NAME} will convert the log source the same way, so if you originally set up \n", "the log source to process all files in /logs/mysite.com, the new configuration will \n", 
"have its log source set up to process all files in /logs/yoursite.com. \n", "Similarly, if you set up custom header or footer containing the configuration name, \n", 
"it will be converted to contain the correct configuration name in each configuration.<p>\n", "If you need to set configuration options which are different from one configuration to another, \n", 
"and are not based on the name of the configuration, you can include them in \n", "the field where you enter the configuration names.  After each configuration name, \n", 
"add a vertical bar (|) and then include the %22command-line%22 style configuration options \n", "you want applied to that configuration.  For instance, \n", 
"if you want to prevent your users from seeing each others' statistics, \n", "you can give each configuration a separate password by adding %22|cvsp <i>password</i>%22 after each \n", 
"configuration name, with the correct <i>password</i> for that configuration.  %22cvsp%22 in this case \n", 
"is the command-line version of the [cvsp] option.  Every option has a command-line version; you can \n", 
"find what it is by clicking the blue %22info%22 icon next to that option's name in the Configuration \n", 
"Options, or by looking through the [docs-options] documentation.<p>\n", "Here's an example of what you might enter in the field, if you wanted to create \n", 
"five new configurations, each with a separate password:<p>\n", "<pre>  yoursite.com|cvsp 1gjs7A67\n", 
"  anothersite.com|cvsp hf8a4a9F\n", "  thirdsite.com|cvsp 277dag1F\n", "  hissite.com|cvsp LjS2F79z\n", 
"  hersite.com|cvsp 4h89GSj4\n", "</pre>\n", "You should save configuration names and options list from the %22Create/Update Many Configuration%22 \n", 
"field, so you can recreate the configurations in the future if you decide to change \n", "something.  The easiest way to do this is to select everything in the field, and copy/paste \n", 
"it into a document.  Later, you can copy from the document to the field to re-enter the information.<p>\n", 
"If you want more flexibility in creating multiple configurations than \n", "the Create/Update Many Configuration option provides, you can automatically generate your own configuration \n", 
"files using a script or program that you write yourself.  Configuration files are \n", "normal text files, so you can easily script their creation.  You'll probably want \n", 
"to do it the same way Create/Update Many Configurations does, by using a template configuration.  \n", 
"You can duplicate the template configuration file and add any options you want to the end\n", "of the file (for instance, %22cvsp password%22).<p>\n", 
"<h3>Sending the Statistics to your Users</h3>\n", "There are many ways of sending statistics to your users, but the main one\n", 
"is to send them a URL pointing to an active installation of {PRODUCT_NAME}. \n", "The URL will allow them to view their statistics, but will not allow them to \n", 
"do anything else--they will not have access to other configurations, or to the \n", "administrative menu. \n", 
"For instance, if the configuration name is mysite.com and {PRODUCT_NAME} is \n", "running in CGI mode on the server stats.isp.com, then you can send your \n", 
"user the following URL:<p>\n", "<ul>\n", "  http://stats.isp.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?view+mysite.com\n", 
"</ul>\n", "In web server mode, the URL would be http://stats.isp.com:8987/{PRODUCT_EXECUTABLE_DOCS}?view+mysite.com .\n", 
"There are also ways to let them select their configuration from a menu, or enter it in a field; \n", 
"see [docs-security] for complete details.<p>\n", "You can also send any view by email to your users.\n", 
"The single-page summary view is a good choice, but you can send any view, or create your own.\n", "The view will be sent as HTML with \n", 
"embedded images, viewable in any modern graphical mail client, and it can contain links \n", "to a live version of {PRODUCT_NAME} if you wish.  You can set {PRODUCT_NAME} to send views regularly \n", 
"using the Scheduler (see [docs-scheduling]).<p>\n", "{PRODUCT_NAME} can also generate %22static%22 HTML pages, which can then be uploaded \n", 
"to a web server, to provide statistics without a running copy of {PRODUCT_NAME}. \n", "However, these pages are much less powerful than {PRODUCT_NAME}'s normal dynamic statistics, \n", 
"take up more space, and require an extra upload step, so it is usually a better idea to \n", "use the dynamic statistics.  If you need static statistics, you can configuration \n", 
"{PRODUCT_NAME} to generate them regularly using the Scheduler.<p>\n", "<h3>Keeping the Statistics Up to Date</h3>\n", 
"{PRODUCT_NAME} will keep the databases up to date even if you never explicitly set it up.\n", "If someone views the statistics when the database \n", 
"hasn't been built yet, {PRODUCT_NAME} builds it; if they view the statistics when \n", "the database hasn't been updated for more than a day, {PRODUCT_NAME} updates it. \n", 
"But there are some advantages to updating the databases manually.  Most importantly, \n", "the build/update step can take a long time, especially for large sites, and that \n", 
"delay may not be acceptable every time a user wants to see their statistics. \n", "You can eliminate the delay by updating the database regularly (usually once \n", 
"daily, in the middle of the night) so that the statistics are never more than \n", "a day old.  You can do this with the Scheduler (see [docs-scheduling]); {PRODUCT_NAME} can be configured \n", 
"to automatically update all databases every night.  The Scheduler only works in \n", "web server mode, though; if you're using {PRODUCT_NAME} in CGI mode (often a good choice\n", 
"for multi-user environments), you'll need to use an external scheduler like \n", "cron or Windows Scheduler to do the updates.  You can update a database from \n", 
"the command line (or a scheduler) using a command line this:<p>\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf <i>config-name</i> -cm ud</pre>\n", 
"Or you can set up the schedules in the {PRODUCT_NAME} Scheduler, and \n", "call {PRODUCT_NAME} like this every minute to run any necessary schedules:<p>\n", 
"<pre>  {PRODUCT_EXECUTABLE_DOCS} -scheduler</pre>\n", "Or you can leave a copy of {PRODUCT_NAME} running in web server mode as well, just to handle\n", 
"the schedules.<p>\n", "<h3>Maintaining the Configuration</h3>\n", "Once you've set up the multi-user environment, it will run without \n", 
"any maintenance on your part.  However, if you want to change \n", "something about the configurations (change the header, add a new view, \n", 
"add new cross-references, etc.), you'll need to regenerate your configurations. \n", "The easiest way to do this is to continue to treat one of your configurations \n", 
"as a %22template%22 configuration-- make all your changes to that configuration, \n", "and never change any other configuration directly.  Then, you'll only have to make \n", 
"each change once, to the template.  Once your template is working the way you like, \n", "you can go back to the Create/Update Many Configurations field, paste in the \n", 
"configurations list you saved from the first time you used it, and \n", "click the button to recreate all the configurations from the template. \n", 
"Create/Update Many Configurations does not change or delete the databases for the configurations;\n", 
"it only changes the configuration options.  So you can safely Create/Update Many Configuration to create\n", 
"configurations even if the databases exist; the data will not be lost.<p>\n", "\n", "<p>\"\n", "\n", 
"\n", "##\n", "## options documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_options \"Options\"\n", 
"DOCS_PAGE_CONTENTS_options\n", "\"{PRODUCT_NAME} is highly configurable using a large option set.\n", 
"For a full list of available options, see [cat-all].\n", "Each configuration has its own set of options which controls what that configuration does.\n", 
"A configuration's options can be changed from the web browser interface using simple\n", "graphical forms and controls, from [docs-configpage].\n", 
"Global (program-wide) options are also available in the Preferences and the Default Configuration, \n", 
"available from [docs-adminmenu].\n", "Options can also be used on \n", "[docs-commandline], or in [docs-configfiles].\"\n", 
"\n", "\n", "##\n", "## pathnames documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_pathnames \"Pathnames\"\n", 
"DOCS_PAGE_CONTENTS_pathnames\n", "\"A pathname is a line of text which fully describes the location of \n", 
"a file or {DIRECTORY_WORD} on your computer.  Pathnames are\n", "used in {PRODUCT_NAME} to describe the locations of the\n", 
"log file (using [log_source_url]), the server {DIRECTORY_WORD},\n", "the [database_directory], and other files and {PLURALIZE:{DIRECTORY_WORD}}.<p>\n", 
"\n", "The leftmost part of\n", "a pathname generally describes which hard drive the file or {DIRECTORY_WORD} is on, and\n", 
"as you move from left to right along the pathname, each successive\n", "part narrows the location further by providing the name of an\n", 
"additional sub{DIRECTORY_WORD}.<p>\n", "\n", "It is not generally necessary to type pathnames if you are using the {PRODUCT_NAME}\n", 
"graphical web browser interface; the Browse button next to each pathname field provides a\n", "friendlier way to specify a pathname, using a familiar {DIRECTORY_WORD} browsing mechanism.\n", 
"This button is available everywhere except the Startup interview, where you must\n", "enter the pathname manually.<p>\n", 
"\n", "Pathnames use different formats on different platforms.  On Macintosh,\n", "the format is\n", 
"\n", "<pre>  <i>harddrive</i>:<i>{DIRECTORY_WORD}1</i>:<i>{DIRECTORY_WORD}2</i> ... <i>{DIRECTORY_WORD}n</i>:<i>filename</i></pre>\n", 
"\n", "for files, and the same for {DIRECTORY_WORD_PLURAL}, except that the final <code>filename</code>\n", 
"is omitted (but not the final <code>:</code>).  For instance, a file my.conf\n", "inside the {DIRECTORY_WORD} Configs, which is inside the {DIRECTORY_WORD} {PRODUCT_NAME}, which is on the disk\n", 
"WebDrive, is represented by WebDrive:{PRODUCT_NAME}:Configs:my.conf .  The {DIRECTORY_WORD}\n", "containing my.conf is represented by WebDrive:{PRODUCT_NAME}:Configs: .<p>\n", 
"\n", "On Windows 95 and NT systems, the format is\n", "\n", "<pre>  <i>driveletter</i>:\\<i>{DIRECTORY_WORD}1</i>\\<i>{DIRECTORY_WORD}2</i> ... <i>{DIRECTORY_WORD}n</i>\\<i>filename</i></pre>\n", 
"\n", "for files, and the same for {PLURALIZE:{DIRECTORY_WORD}}, except that the final <code>filename</code>\n", 
"is omitted (but not the final <code>\\</code>).  For instance, a file <code>my.conf</code>\n", "inside the {DIRECTORY_WORD} <code>configs</code>, which is inside the {DIRECTORY_WORD} <code>{PRODUCT_EXECUTABLE_DOCS}</code>, which is inside\n", 
"the {DIRECTORY_WORD} <code>web</code> on the C: drive,\n", "is represented by <code>C:\\web\\{PRODUCT_EXECUTABLE_DOCS}\\configs\\my.conf</code> .  The {DIRECTORY_WORD}\n", 
"containing <code>my.conf</code> is represented by <code>C:\\web\\{PRODUCT_EXECUTABLE_DOCS}\\configs\\</code> .<p>\n", 
"\n", "It is also permissible to use for forward slash (/) rather than the backward slash (\\)\n", "as the separator character.<p>\n", 
"\n", "On UNIX systems, the format is\n", "\n", "<pre>  /<i>{DIRECTORY_WORD}1</i>/<i>{DIRECTORY_WORD}2</i> ... <i>{DIRECTORY_WORD}n</i>/<i>filename</i></pre>\n", 
"\n", "for files, and the same for {PLURALIZE:{DIRECTORY_WORD}}, except that the final <code>filename</code>\n", 
"is omitted (but not the final <code>/</code>).  For instance, a file <code>my.conf</code>\n", "inside the {DIRECTORY_WORD} <code>configs</code>, which is inside the {DIRECTORY_WORD} <code>{PRODUCT_EXECUTABLE_DOCS}</code>, which is inside\n", 
"the {DIRECTORY_WORD} <code>web</code> (a sub{DIRECTORY_WORD} of the root <code>/</code> {DIRECTORY_WORD}),\n", 
"is represented by <code>/web/{PRODUCT_EXECUTABLE_DOCS}/configs/my.conf</code> .  The {DIRECTORY_WORD}\n", 
"containing <code>my.conf</code> is represented by <code>/web/{PRODUCT_EXECUTABLE_DOCS}/configs/</code> .<p>\"\n", 
"\n", "\n", "##\n", "## filters documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_filters \"Using Log Filters\"\n", 
"DOCS_PAGE_CONTENTS_filters\n", "\"{PRODUCT_NAME} offers a wide range of log filters, which let you selectively\n", 
"eliminate portions of your log data from the statistics (see [lf]). \n", "Log filters should not be confused with the Filters that appear in statistics pages; \n", 
"log filters affect how the log data is processed, and statistics Filters affect \n", "which parts of the database are displayed. \n", 
"There are many reasons you might want to filter the log data, including:<p>\n", "<ul>\n", "  <li> You may not be interested in seeing the hits on files of a particular\n", 
"       type (e.g. image files).<p>\n", "  <li> You may not be interested in seeing the hits from a particular host or\n", 
"       domain (e.g. hits from your own domain, or hits from robots).<p>\n", "  <li> You may not be interested in seeing hits which did not result\n", 
"       in separate page views, like 404 errors (file not found) or\n", "       redirects.<p>\n", "</ul>\n", 
"{PRODUCT_NAME}'s default filters automatically perform the most common filtering \n", "(they categorize image files as hits but not page views, strip off page parameters, and more) \n", 
"but you will probably end up adding or removing filters as you fine-tune\n", "your statistics.<p>\n", 
"\n", "<h3>How Filters Work</h3>\n", "\n", "Filters are arranged in a line, starting with the first filter\n", 
"and continuing up through the last filter.  Each time {PRODUCT_NAME} processes\n", "a log entry, it runs the filters in order, starting with the first one.\n", 
"{PRODUCT_NAME} applies that filter to the log entry.  The filter may\n", "accept the log entry (either as a hit or a page view), in which case it is immediately selected for\n", 
"inclusion in the statistics--the other filters are not run; once a filter\n", "accepts, the acceptance is final.  Alternately, the filter may reject\n", 
"the entry, in which case it is immediately discarded, without consulting\n", "any filters farther down the line.  Finally, the filter may neither accept\n", 
"nor reject, but instead pass the entry on to another filter; in this case, and <i>only</i>\n", "in this case, another filter is run.<p>\n", 
"\n", "In other words, every filter has complete power to pass or reject entries, provided the\n", "entries make their way to that filter.  The first filter that accepts or rejects\n", 
"the entry ends the process, and the filtering is done for that entry.  A filter\n", "gets to see an entry <i>only</i> when every filter before it in the sequence \n", 
"has neither accepted\n", "nor rejected that entry.  So the first filter in the sequence is the most powerful,\n", 
"in the sense that it can accept or reject without consulting the others; the second\n", "filter is used if the first has no opinion on whether the entry should be accepted or\n", 
"rejected, etc.  Since filters can control which filter is run after them using %22goto%22\n", "statements, they are not always run in the order of their numbers.  Each filter decides \n", 
"which filter will get the chance to filter next.<p>\n", "\n", "<h3>Hits vs. Page Views</h3>\n", "{PRODUCT_NAME} distinguishes between %22hits%22 and %22page views%22 for most types of logs.\n", 
"The distinction is more meaningful for web logs.\n", "A %22hit%22 is one access to the web server; i.e. one request for a file\n", 
"(it may not actually result in the transfer of a file, for instance if it's a redirect or an error).\n", 
"A %22page view%22 is an access to a page (rather than an image or a support file like a style sheet). \n", 
"For some web sites and some types of analysis, image files, .class files, .css file, and other files are not as important \n", 
"as HTML pages--the important number is how many pages were accessed, not how many images were \n", 
"downloaded.  For other sites and other types of analysis, all accesses are important. \n", "{PRODUCT_NAME} tracks both types of accesses.  When a filter accepts an entry, it decides whether \n", 
"it is a hit or a page view.  Hits are tallied separately, and the final statistics can show \n", "separate columns for hits and page views in tables, as well as separate pie charts and graphs.\n", 
"Both hits and page views contribute to bandwidth and visitor counts, but the page view count \n", "is not affected by hits on image files and other support files.<p>\n", 
"\n", "<h3>Examples</h3>\n", "This section includes some examples of how filters can be used, and how they are put together.<p>\n", 
"\n", "<h4>Example: Copying the hostname field to the visitor id field</h4>\n", "Most log formats which \n", 
"have a hostname field also have a default filter like this:<p>\n", "<pre>  copy the hostname field value to the visitor id field</pre>\n", 
"This filter is used to copy the value from the hostname field to the visitor id field, \n", "which is how {PRODUCT_NAME} calculates visitor information (visitors are considered to be unique \n", 
"if they have unique visitor id's).\n", "If your log format tracks visitor ID's using cookie information, you may want to edit this filter\n", 
"to extract the visitor ID from your cookie field.<p>\n", "\n", "<h4>Example: Filtering GIFs</h4>\n", 
"Most log formats which have a page field also have a default filter like this:<p>\n", "<pre>  if the page field ends with %22.gif%22\n", 
"  then accept this log entry as a hit (and stop filtering)\n", "  otherwise continue on to the next filter</pre>\n", 
"This filter examines the page field (which represents the page that was hit), \n", "to determine if it is a GIF image or not.  If the end of the field is %22.gif%22, then \n", 
"the filename must end with .gif, so this is a GIF image, and this filter categorizes it \n", "as a hit (which means it will not show up in the page views totals).<p>\n", 
"Since the structure of the GIF filter above is a \n", "very common structure for a filter, we will go into some more detail about how it is put together, \n", 
"parameter by parameter.  You can view or edit filter parameters by clicking the small blue arrow next \n", 
"to the filter description; for a complete description of all parameters and their possible values, \n", 
"see [lf].  It will be very useful to have a running copy of {PRODUCT_NAME} in a separate window as you \n", 
"read through this description; open a configuration, view the filters, and edit one of them \n", "to follow along with the parameters.<p>\n", 
"The filter type is %22If A is true, then do B, otherwise do C%22--that's a generic type \n", "you'll use for any filter that makes a decision (in this case, whether to call a hit a page view or not).\n", 
"For this filter type, the A part is the question the filter asks, the B part is what it does \n", "if the answer is true, and the C part is what it does if the answer is false.\n", 
"The question we're asking in this case is %22Is this a GIF image?%22 or in other words, \n", "%22Does the page field end with .gif?%22  The A section can be set up to ask that question by \n", 
"using the %22{FILTER_OP_ends_with}%22 operator, which is true if the one value ends with another \n", 
"(in this case, if the page field's value ends with a constant value, .gif). \n", "value1 in this case is the page field, which is selected from the web interface by \n", 
"choosing %22page%22 from the menu and leaving the field to the right of it blank.\n", "value2 is %22.gif%22 which is specified by choosing %22{FILTER_EXPRESSION_TYPE_value}%22 from \n", 
"the menu and entering the constant value (.gif) in the field to the right. \n", "Put all together, that becomes %22if the page field ends with .gif%22.<p>\n", 
"\n", "The B and C parts are much simpler than A in this case.  The A section decides if the \n", "page field ends with .gif, and if it does, the B action occurs; otherwise, the C action occurs. \n", 
"The B action is to accept this as a hit, which can be specified by choosing \n", "%22{FILTER_STATEMENT_accept_as_hit}%22 from the action menu in the B section, and leaving all other \n", 
"parameters in B blank.  If this isn't a GIF file, we want to keep going with the other filters, \n", 
"so in the C section action is %22{FILTER_STATEMENT_goto_next_filter}%22.<p>\n", "\n", "Putting all the pieces together, you end up with a filter that accepts log entries as hits \n", 
"if their page field ends with .gif, and otherwise lets the other filters work on the entry.<p>\n", 
"\n", "<h4>Example: Filtering out domains or hosts</h4>\n", "The GIF filter above can be modified slightly to create all kinds of useful filters. \n", 
"For instance, if want to ignore hits from your own domain, you can use a filter like this:<p>\n", "<pre>  if the hostname field ends with %22.mydomain.com%22\n", 
"  then reject this log entry (and stop filtering)\n", "  otherwise continue on to the next filter</pre>\n", 
"The structure of this is very similar to the GIF filter above; the difference is that \n", "the hostname field was selected from the value1 menu instead of the page, the value2 \n", 
"constant is different (.mydomain.com instead of .GIF), and \n", "matching entries are rejected instead of being accepted as hits \n", 
"(The B action was %22{FILTER_STATEMENT_reject}%22).  You can use \n", "a similar filter to filter out hits from a particular hostname:<p>\n", 
"<pre>  if the hostname field equals %22badhost.somedomain.com%22\n", "  then reject this log entry (and stop filtering)\n", 
"  otherwise continue on to the next filter</pre>\n", "This is the same as the domain filter above, except that the operator in the A section \n", 
"is %22{FILTER_OP_equals}%22 instead of %22{FILTER_OP_ends_with}%22, so only \n", "exact matches to the constant will cause rejections.<p>\n", 
"\n", "This type of filter can be used on any field, to accept and reject \n", "based on any criteria you wish.<p>\n", 
"\n", "<h4>Example: Filtering out pages or directories</h4>\n", "The host filter above can be modified slightly to filter out entries based on any field. \n", 
"One common example is if you want to filter out hits on particular pages, \n", "for instance to discard hits from worm attacks.  A filter like this:<p>\n", 
"<pre>  if the page field starts with %22/default.ida?%22\n", "  then reject this log entry (and stop filtering)\n", 
"  otherwise continue on to the next filter</pre>\n", "rejects all hits on /index.ida, which eliminates many of the hits from the \n", 
"Code Red worm.<p>\n", "A filter like this:<p>\n", "<pre>  if the page field starts with %22/directory1/%22\n", 
"  then continue on to the next filter</pre>\n", "  otherwise reject this log entry (and stop filtering)\n", 
"rejects all hits <i>except</i> those on /directory1/, which can be \n", "useful if you want to create a database which focuses on only \n", 
"one directory (sometimes useful for ISPs).<p>\n", "\n", "<h4>Advanced Example: Converting the page field to strip off parameters</h4>\n", 
"The parameters on the page field (the part after the ?) are \n", "often of little value, and increase the size of the database substantially.\n", 
"Because of that, {PRODUCT_NAME} includes a default filter that strips off everything after the \n", 
"? in a page field (hint: if you need the parameters, delete the filter).\n", "{PRODUCT_NAME} uses a special %22replace everything after%22 filter for this use, but \n", 
"for the purpose of this example, here's another filter that does the same thing \n", "(but slower, because pattern matching is a fairly slow operation):<p>\n", 
"<pre>  if the page field contains ?\n", "  then match the page field value to the regular expression %22^(.*\?).*$%22, and if it matches set the page field to %22$1(parameters)%22, replacing variables.\n", 
"  otherwise continue on to the next filter</pre>\n", "This actually has the same overall structure as the GIF filter above;\n", 
"it's an if/then/else filter.  The A part is similar to what we've seen before; \n", "it uses the %22{FILTER_OP_contains}%22 operator to check if the page field contains a ?.\n", 
"If it doesn't, the C part is invoked, and the filter does nothing.<p>\n", "\n", "If the page field does contain a ?, then a complicated B section is invoked to \n", 
"strip off everything after the ?.  The B section action is %22{FILTER_STATEMENT_convert_field_regexp}%22, \n", 
"an action which matches a field against a regular expression, including subexpressions \n", "(see [docs-regexp] for more information about regular expressions),\n", 
"and then plugs the result back into another (or the same) field using a second value with optional subexpression references.\n", 
"It's one of the most complicated types of filter actions, but it is very powerful; \n", "you can use it to do all sorts of conversions.\n", 
"The value1 parameter is a regular expression ^(.*\?).*$, which matches any value containing at least one ?, \n", 
"and puts everything from the beginning of the field up to the first ? is into subexpression 1. \n", 
"The value2 parameter specifies what should be put back into the field, \n", "and occurrences of $1, $2, etc. are replaced by subexpressions 1, 2, etc. from the regular expression \n", 
"match.  field2 and field1 are the source and destination field, respectively; in this case both are %22page%22, \n", 
"so the page field is converted and then overwritten.\n", "So this causes the page field to be set to %22$1(parameters)%22, which is \n", 
"to say everything up to the ? in the original field, followed by %22(parameters)%22.  \n", "For example, if the original value was /index.html?param1+param2, the result will be \n", 
"/index.html?(parameters).  That is of course exactly what we wanted--the parameters have been \n", 
"stripped off, so all hits on index.html with parameters will have the same value, regardless of the\n", 
"parameters--and that will reduce the size of the database.<p>\n", "\n", "For those who would like to edit filters directly in configuration files, \n", 
"the filter above looks like this:\n", "<pre>  if_a_then_b_else_c\n", "  page\n", "  %22%22\n", "  contains\n", 
"  value\n", "  ?\n", "  convert_field_regexp\n", "  ^(.*\?).*$\n", "  $1(parameters)\n", "  page\n", 
"  page\n", "  goto_next_filter\n", "  %22%22\n", "  %22%22\n", "  %22%22\n", "  %22%22\n", "  collapsed</pre>\n", 
"\"\n", "\n", "\n", "\n", "##\n", "## xref documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_xref \"Cross-Referencing and Simultaneous Filters\"\n", 
"DOCS_PAGE_CONTENTS_xref\n", "\"One of {PRODUCT_NAME}'s major features is the ability to \n", "cross-reference database fields (see [dfi]) against each other, \n", 
"for instance to break down the hits on any particular day by page \n", "(to see which pages were hit on that day), or to break down \n", 
"the hits on any page by day (to see which days the page was accessed). \n", "{PRODUCT_NAME} can be configured to allow this sort of cross-referencing \n", 
"between any or all fields in the database.<p>\n", "\n", "Another way of looking at this feature \n", 
"is in terms of filters; when two fields are cross-referenced against each other, \n", "{PRODUCT_NAME} is able to apply filters to both fields at the same time. \n", 
"If two fields are <i>not</i> cross-references against each other, \n", "{PRODUCT_NAME} can apply filters to one field or the other, but not both simultaneously. \n", 
"If the page field is not cross-referenced against the date/time field, for instance, \n", "{PRODUCT_NAME} can show the number of hits on a /myfile.html, or the number of hits on Jun/1999,\n", 
"but not the number of hits on /myfile.html which occurred during Jun/1999. \n", "This means not only that {PRODUCT_NAME} can't show a page with filters applied to both fields in the \n", 
"Filters section, but also that {PRODUCT_NAME} cannot show %22page statistics%22 view when \n", "there is a filter on the date/time field, or a %22date/time statistics%22 or %22date/time graph%22 \n", 
"view when there is a filter on the page field, since the individual items in these views \n", "effectively use simultaneous filters to compute the number of hits.<p>\n", 
"\n", "On the other hand, cross-referencing uses a <i>lot</i> of space in the database.  \n", "The more fields you cross-reference, the larger and slower your database gets. \n", 
"Restricting cross-referencing only to those fields that you really need cross-referenced \n", "is a good way to limit the size of your database, and speed browsing of the statistics.<p>\n", 
"\n", "When you create your configuration, you will be given several options in the amount of \n", "detail you want to track, and some of these options affect the default cross-references. \n", 
"Turning on day-by-day (calendar) tracking \n", "cross-references the date/time field to every other field, and turning on 404s \n", 
"cross-references the page field with the server response field. \n", "Other than that, no cross-references are set by default.<p>\n", 
"\n", "Generally, you should start out with few cross-references; a default analysis\n", "is a good starting point. If you \n", 
"need a type of information not available (for instance, if you want to know the browser \n", "versions that are accessing a particular page), try adding the necessary cross-references--{PRODUCT_NAME}\n", 
"will cue you in to the ones you need with a %22Data not available%22 error.  See [docs-resources] \n", 
"for more information on optimizing your memory, disk space, and processing time.<p>\"\n", "\n", "\n", 
"##\n", "## hierarchies documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_hierarchies \"Hierarchies and Fields\"\n", 
"DOCS_PAGE_CONTENTS_hierarchies\n", "\"{PRODUCT_NAME} can break down log information on several\n", 
"fields at the same time.  For instance, if it is processing a web server\n", "access log, it can break it down by page, date, and host.\n", 
"Each field type is organized hierarchically, in a tree-like structure\n", "of items and subitems.  For example, a section of a typical %22page%22 \n", 
"hierarchy might look like this:<p> \n", "<pre> \n", "                          / (the root) \n", "                       <b>/</b>                <b>\\</b> \n", 
"                 /dir1/                 /dir2/ \n", "                <b>/</b>      <b>\\</b>                     <b>\\</b> \n", 
"  /dir1/file1.html   /dir1/file2.html      /dir2/dir3/ \n", "                                          <b>/</b>          <b>\\</b> \n", 
"                         /dir2/dir3/file3.html   /dir2/dir3/file4.html \n", "</pre>\n", "This is hierarchical; some pages are <i>above</i> others because they <i>enclose</i>\n", 
"them.  For instance, a {DIRECTORY_WORD} is above all of its sub{PLURALIZE:{DIRECTORY_WORD}} and all of the \n", 
"files in it.<p>\n", "\n", "This hierarchical structure allows you to %22dive%22 into your log data one level at\n", 
"a time (to zoom in).  Every statistics page you see corresponds to one of the items \n", "above.  Initially, {PRODUCT_NAME} shows the page corresponding to /, which is the \n", 
"top-level {DIRECTORY_WORD} (the %22root%22 of the hierarchical %22tree%22).\n", "This page will show you all subpages of /; you will see /dir1/ and /dir2/.\n", 
"Clicking on either of those items (%22subitems%22 of the current page) will show you \n", "a new page corresponding to the subitem you clicked.  For instance, clicking on /dir2/ \n", 
"will show you a new page corresponding to  /dir2/; it will contain\n", "/dir2/dir3/, the single subitem of /dir2/.  Clicking on /dir2/dir3/\n", 
"will show a page corresponding to /dir2/dir3/, containing \n", "the subitems of /dir2/dir3/:  /dir2/dir3/file3.html and /dir2/dir3/file4.html.<p>\n", 
"\n", "{PRODUCT_NAME} shows the number of page views (and/or bytes transferred, and/or visitors) for each item \n", 
"it displays.  For instance, next to /dir2/ on a statistics page, you might see \n", "1500, indicating that there were 1500 page views on /dir2/ or its subitems.  That is, \n", 
"the sum of the number of page accesses on /dir2/, /dir2/dir3/, \n", "/dir2/dir3/file4.html, /dir2/dir3/file3.html is 1500.  That could be \n", 
"caused by 1500 page views on /dir2/dir3/file4.html and no page views anywhere else, or by \n", "1000 page views on /dir2/dir3/file3.html and 500 page views directly on /dir2/, \n", 
"or some other combination.  To see exactly which pages were hits to create those 1500 page views, \n", 
"you can zoom in by clicking /dir2/.<p>\n", "\n", "There are many other hierarchies besides the page hierarchy described above.  For instance,\n", 
"there is the date/time hierarchy, which might look like this:<p>\n", "<pre> \n", "                       (the root)\n", 
"                    /             \\ \n", "                1998               1999\n", "               /    \\              /   \\ \n", 
"        Nov/1998  Dec/1998   Jan/1999  Feb/1999\n", "</pre>\n", "The date/time hierarchy continues downward similarly, with days as subitems of months, \n", 
"hours of days, minutes of hours, and seconds of minutes.  Other hierarchies include \n", "the URL hierarchy (similar to the page hierarchy, with http:// below the root, \n", 
"http://www.flowerfire.com/ below http://, etc.), and the hostname hierarchy \n", "(.com below the root, flowerfire.com below .com, www.flowerfire.com below flowerfire.com, etc.).<p>\n", 
"\n", "Some terminology: the top very top of a hierarchy is called the %22root%22 \n", "(e.g. %22(the root)%22 in the date/time hierarchy above, or %22/%22 in the page hierarchy).  An item \n", 
"below another item in the hierarchy is called a %22subitem%22 of that item (e.g. \n", "1998 is a subitem of the root, and /dir2/dir3/file4.html is a subitem of /dir2/dir3/). \n", 
"Any item at the very bottom of a hierarchy (an item with no subitems) is called a %22leaf%22 \n", "or a %22bottom level item%22 (e.g. Jan/1999 and /dir1/file1.html are leaves in the above hierarchies). \n", 
"An item which has subitems, but is not the root, is called an %22interior node%22 \n", "(e.g. 1998 and /dir2/dir3/ are interior nodes in the above hierarchies).<p> \n", 
"\n", "Page and URL hierarchies are special in that they can have page views directly on the interior nodes,\n", 
"whereas most hierarchies cannot; for instance\n", "you can have a page view on /dir1/, but you cannot have a page view from .com (page views always come from hostnames).\n", 
"Put another way, zooming in on .com will never show you .com as one of the subitems, with page views \n", 
"directly on it, but zooming in on /dir1/ might show that some of the page views on /dir1/ were actually \n", 
"<i>directly</i> on /dir1/, rather than on some page below it.<p>\n", "\n", "To save database size, processing time, and browsing time, it is often useful to %22prune%22 \n", 
"the hierarchies.  This is done using the Suppress Levels Below and Suppress Levels Above parameters of the \n", 
"[database_field_info] options.  Levels are numbered from 0 (the root) downward; for instance \n", "1999 is at level 1 above, and /dir2/dir3/file4.html is at level 4.  {PRODUCT_NAME} omits all items \n", 
"from the database hierarchy whose level number is greater than the Suppress value.  For \n", "instance, with a Suppress value of 1 for the date/time hierarchy above, {PRODUCT_NAME} would \n", 
"omit all items at levels 2 and below, resulting in this simplified hierarchy in the database:<p>\n", 
"<pre> \n", "                    (the root)\n", "                    /        \\ \n", "                1998          1999\n", 
"</pre>\n", "Using this hierarchy instead of the original saves space and time, but makes it \n", "impossible to get date/time information at the month level; you won't be able to \n", 
"click on 1998 to get month information.  {PRODUCT_NAME} also omits all items from the hierarchy \n", 
"whose level number is less than or equal to the Collapse value (except the root, which \n", "is always present).  For instance, with a Collapse value of 1 (and Suppress of 2), {PRODUCT_NAME} \n", 
"would omit all level 1 items, resulting in this hierarchy:<p>\n", "<pre> \n", "                       (the root)\n", 
"                 /       |    |        \\ \n", "        Nov/1998   Dec/1998  Jan/1999  Feb/1999\n", 
"</pre>\n", "All four of the level 2 items are now direct subitems of the root, so \n", "the statistics page for this hierarchy will show all four months.  \n", 
"This is useful not just because it saves time and space, but also because \n", "it combines information on a single page that otherwise would have taken \n", 
"several clicks to access.<p>\n", "\n", "Here's an example of %22Suppress Levels Above%22 and %22Suppress Levels Below,%22 based \n", 
"on the page field value /dir1/dir2/dir3/page.html. \n", "With above=0 and below=999999, this will be marked as a single hit on the following items:<p> \n", 
"<ul>\n", "  level 0: /<br>\n", "  level 1: /dir1/<br>\n", "  level 2: /dir1/dir2/<br>\n", "  level 3: /dir1/dir2/dir3/<br>\n", 
"  level 4: /dir1/dir2/dir3/page.html<br>\n", "</ul>\n", "With above=3, below=999999, all levels above 2 are omitted (the root level, 0, is always included):<p>\n", 
"<ul>\n", "  level 0: /<br>\n", "  level 2: /dir1/dir2/<br>\n", "  level 4: /dir1/dir2/dir3/page.html<br>\n", 
"</ul>\n", "With above=0, below=2, all levels below 2 are omitted:<p>\n", "<ul>\n", "  level 0: /<br>\n", 
"  level 1: /dir1/<br>\n", "  level 2: /dir1/dir2/<br>\n", "</ul>\n", "above=2, below=3: all levels above 2 are omitted (except 0), and all levels below 3 are omitted:<p>\n", 
"<ul>\n", "  level 0:  /<br>\n", "  level 2: /dir1/dir2/<br>\n", "  level 3: /dir1/dir2/dir3/<br>\n", 
"</ul>\n", "In the last example, zooming in on / will show you /dir1/dir2/ (you will never see \n", 
"/dir1/ in the statistics, because level 1 has been omitted); zooming in on that will show you \n", 
"/dir1/dir2/dir3/, and you will not be able to zoom any further, because level 4 has been omitted.<p>\n", 
"\n", "On a side note, the %22{VIEW_ELEMENTS_OnlyBottomLevelItems}%22 \n", "option in the Options menu provides \n", 
"a dynamic way of doing roughly the same thing as using a high value of Collapse.\n", "Using the Show menu to show %22{VIEW_ELEMENTS_OnlyBottomLevelItems}%22 \n", 
"will dynamically restructure the hierarchy \n", "to omit <i>all</i> interior nodes.  In the case of the page hierarchy above, \n", 
"that would result in the following hierarchy:\n", "<pre> \n", "                               / (the root) \n", 
"                <b>/</b>               <b>|</b>        <b>|</b>                  <b>\\</b> \n", "  /dir1/file1.html  dir1/file2.html  /dir2/dir3/file3.html  /dir2/dir3/file4.html \n", 
"</pre>\n", "This hierarchy has all leaf items as direct subitems of the root, \n", "so the statistics page for this hierarchy will show all four pages.  This is much \n", 
"faster than using Suppress because after Suppress has been modified, the entire database \n", "must be rebuilt to reflect the change.<p>\n", 
"\n", "The Database Structure Options provide a couple other ways of pruning your hierarchies. \n", 
"The %22Always include bottom-level items%22 option, \n", "forces {PRODUCT_NAME} to include the bottom-level items in the hierarchy, regardless of the \n", 
"setting of the Suppress value.  It is useful to include the bottom-level items \n", "if you need them for some feature of {PRODUCT_NAME} (for instance, visitor information \n", 
"requires that all the bottom-level hosts be present, and session information is \n", "most meaningful if all the bottom-level date/times are present), but you want \n", 
"to prune some of the interior of the hierarchy to save space.<p>\n", "\n", "Hierarchies can be either left-to-right (with the left part of the item \n", 
"%22enclosing%22 the right part, as in /dir1/dir2/file.html, where /dir1/ \n", "encloses /dir1/dir2/, which encloses /dir1/dir2/file.html), or right-to-left \n", 
"(with the right part of the item enclosing the left part, as in \n", "www.flowerfire.com, where .com encloses flowerfire.com, which encloses\n", 
"www.flowerfire.com).  Hierarchies use one or more special characters \n", "to divide levels (e.g. / in the page hierarchy or . in the host hierarchy).\n", 
"These options and more can be set in the [log_field_index] options.<p>\n", "<p>\n", "Some log fields are not hierarchical, for instance the operation field \n", 
"of a web log (which can be GET, POST, or others), or integer fields like \n", "the size or response fields.  These fields are specified in the [log_field_index] option \n", 
"as non-hierarchical, or %22flat%22, and all items in those hierarchies \n", "appear directly below the root.\"\n", 
"\n", "\n", "##\n", "## databases documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_database \"Databases\"\n", 
"DOCS_PAGE_CONTENTS_database\n", "\"{PRODUCT_NAME} uses a database on the disk to store information about log data.\n", 
"The database is essentially a collection of entries each of which is something like this:\n", "%22There are 1597 page views, for 1556754 bytes, on the page /dir1/myfile.html, from the domain .com, in the date /1998.%22\n", 
"(The actual internal format is much more compact than this, and uses numbers rather than words).\n", 
"Every time a new log entry is read, the information contained in that entry is added to the database.\n", 
"Every time a statistics page is generated, the information needed is read from the database.<p>\n", 
"\n", "The database can break down log information on one or more fields.  In the example given above,\n", 
"the database has three fields: a page field, a host field, and a date field.\n", "The number and type of the fields are specified in the Database Structure options on \n", 
"[docs-configpage].\n", "The Database Structure options also control how much, \n", "if any, of each of the field [docs-hierarchies] is suppressed.  Suppressing\n", 
"parts of the hierarchies can save space and time. \n", "Fields can be cross-referenced against each other to allow sophisticated zooming \n", 
"and data slicing; see [docs-xref].<p>\n", "\n", "The [database_directory] option specifies the\n", 
"location of the database on disk; if the option is blank, {PRODUCT_NAME} stores the\n", "database in the Databases {DIRECTORY_WORD}, in the LogAnalysisInfo {DIRECTORY_WORD}, using\n", 
"the name of the configuration as the name of the database {DIRECTORY_WORD}.<p>\n", "\n", "New log data can be added to\n", 
"the database at any time.  This allows a database to be quickly and incrementally updated, for instance,\n", 
"every day with that day's new log entries.  This can be done from the web browser interface by\n", 
"using the Update Database option in [docs-configpage].\n", "A command line (see [docs-commandline]) which would accomplish the same thing is\n", 
"<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf config-file -cm update_database</pre>\n", "<p>\n", "\n", "If your log files are very large, or if your database is extensively cross-referenced, \n", 
"building a database can take a long time, and use a lot of memory and disk space. \n", "See [docs-resources] for information on limiting your memory and disk usage, and \n", 
"increasing the database build speed.<p>\n", "\n", "A number of advanced options exist to fine-tune database performance.  To get the most\n", 
"out of the database feature, you may want to adjust the values of the\n", "[cat-database].<p>\"\n", 
"\n", "\n", "##\n", "## dbdetail documentation page text \n", "##\n", "DOCS_PAGE_TITLE_dbdetail \"Database Detail\"\n", 
"DOCS_PAGE_CONTENTS_dbdetail\n", "\"When you first create a configuration, {PRODUCT_NAME} will ask you what kind of information you want to track\n", 
"in your configuration.  The values you choose determine what your initial configuration settings are, \n", 
"including the database cross-references and the available views.<p>\n", "\n", "There are several options you can choose:<p>\n", 
"<ul>\n", "  <li><b>{XREF_DATETIME_TO_ALL_FIELDS}</b>.  Turning this option on lets you use the Calendar view\n", 
"      to select any year, month, or day, and see statistics in any view for that time period.  \n", 
"      This is done by cross-referencing the date/time field to all other database fields.<p>\n", "  <li><b>{TRACK_INDIVIDUAL_HOSTS}</b>.  Turning this option on structures the \n", 
"      %22host,%22 %22browsing host,%22 or %22source IP%22 field so that all IPs are tracked. \n", "      If you leave this off, {PRODUCT_NAME} will track only the top level domains (e.g. yahoo.com) \n", 
"      and subnets (e.g. 127.128) of the IP's, and you will not be able to get information about the \n", 
"      activities of a particular IP.  If you turn this on, every IP address in the log data will be \n", 
"      tracked separately, so information will be available about individual IP addresses and hostnames.\n", 
"      Turning this on can significantly increase the size and memory usage of this database.<p>\n", 
"  <li><b>{INCLUDE_BROKEN_LINKS_VIEW}</b>.  Turning this option on lets you see the broken links (404s) \n", 
"      in your log data.  This adds a cross-reference between the page and server response database fields, \n", 
"      so it will make your database a bit larger.  This also creates a broken links view in your statistics.<p>\n", 
"  <li><b>{TRACK_SESSION_INFO}</b>.  Turning this option on lets you see the paths through the site \n", 
"      (click streams), entry pages, exit pages, session summaries, sessions, and time spent per page. \n", 
"      Session information is tracked separately from the rest of the database, so this does not affect \n", 
"      database fields or cross-references.  Turning this on will slightly decrease log processing speed, \n", 
"      and will slightly increase database size.<p>\n", "</ul><p>\n", "The [ch], [cb], [cpv], and [cv] options can all be modified from the detail page.<p> \n", 
"Turning on [cv] will result in the visitor id information being tracked for all database items, \n", 
"which will significantly slow log processing and increase database size, but it is necessary if \n", 
"you need visitor information.  Turning the other options on will each slightly increase the database size.\n", 
"Turning off all options except [cpv] will greatly speed processing (as much as four times), and \n", 
"will greatly reduce the size of the database.<p>\n", "\n", "The detail level is used when the configuration is created to choose the initial Database Structure settings \n", 
"and cross-references \n", "(see [cat-structure]).  You can \n", "change those settings at any point in the future if you choose, to include more or less information in your \n", 
"database.\"\n", "\n", "\n", "\n", "##\n", "## logfiles documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_logfiles \"Log Files\"\n", 
"DOCS_PAGE_CONTENTS_logfiles\n", "\"{PRODUCT_NAME} is a log file analysis tool.  It reads one or more log files,\n", 
"and generates a graphical statistical report of some aspect of the contents\n", "of the log data.<p>\n", 
"\n", "{PRODUCT_NAME} can handle a wide range of log formats.  Dozens of formats are built in (see [faq-logformats]), \n", 
"and others can be supported by creating a new log format description file (see [docs-customformats]).\n", 
"If the format of the log data you wish to analyze is not supported, and the\n", "log format is a common one, please send mail to\n", 
"<a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>\n", "and we will create the log format description file for you.\"\n", 
"\n", "\n", "##\n", "## regexp documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_regexp \"Regular Expressions\"\n", 
"DOCS_PAGE_CONTENTS_regexp\n", "\"Regular expressions are a powerful method for defining a class of strings \n", 
"(strings are sequences of characters; for instance, a filename is a string, and \n", "so is a log entry).\n", 
"{PRODUCT_NAME} uses regular expressions in many places, including: \n", "<ul>\n", "  <li> You can specify the log files to process using [urefls].<p>\n", 
"  <li> You can specify the log file format using [lffre].<p>\n", "  <li> You can filter log entries based on a regular expression using [lf].<p>\n", 
"</ul>\n", "You can also use wildcard expressions in these cases, using \n", "* to match any string of characters, or ? to match any single character \n", 
"(for instance, *.gif to match anything ending with .gif, or Jan/??/2000 to match \n", "any date in January, 2000). \n", 
"Wildcard expressions are easier to use than regular expressions, but are not nearly as powerful.<p>\n", 
"\n", "Regular expressions can be extremely complex, and it is beyond the scope of this\n", "manual to describe them in full detail (see\n", 
"<a href=http://www.yahoo.com/Social_Science/Linguistics_and_Human_Languages/Computational_Linguistics/Regular_Expressions/>Yahoo's Regular Expression Category</a>\n", 
"for more in-depth information; note that this link leads to Yahoo's web pages, and so requires\n", 
"a live internet connection).<p>\n", "\n", "In brief, a regular expression is a pattern, which is essentially\n", 
"the string to match, plus special characters which match classes of string,\n", "plus operators to combine them.  Here are the simplest rules: <p>\n", 
"<ul>\n", "  <li> A letter or digit matches itself (most other characters do as well).<p>\n", "  <li> The . character (a period) matches any character.<p>\n", 
"  <li> The * character matches zero or more repetitions of the\n", "       expression before it.<p>\n", 
"  <li> The + character matches one or more repetitions of the\n", "       expression before it.<p>\n", 
"  <li> The ^ character matches the beginning of the string.<p>\n", "  <li> The $ character matches the ending of the string.<p>\n", 
"  <li> A square-bracketed series of characters matches any of those characters.\n", "       Adding a ^ after the opening bracket\n", 
"       matches any character <i>except</i> those in the brackets.<p>\n", "  <li> Two regular expressions in a row match any combination where the\n", 
"       first half matches the first expression, and the second half matches the\n", "       second expression.<p>\n", 
"  <li> The \\ character followed by any other character matches that character. \n", "       For example, \\* matches the * character.<p>\n", 
"  <li> A regular expression matches if it matches any part of the string; \n", "       i.e. unless you explicitly include ^ and/or $, the regular expression \n", 
"       will match if it matches something in the middle of the string.  For \n", "       example, %22access\\.log%22 matches not only <code>access.log</code> but \n", 
"       also <code>old_access.log</code> and <code>access.logs</code>.<p> \n", "  <li> A parenthesized regular expression matches the same thing as it does without\n", 
"       parentheses, but is considered a single expression (for instance by a trailing *).\n", "       Parentheses can be used to group consecutive expressions into a single expression. \n", 
"       Each field should be parenthesized when using [urefls]; that's how {PRODUCT_NAME} knows \n", 
"       where each field is.<p>\n", "  <li> An expression of the form (A|B) matches either expression A or expression B.  There \n", 
"       can also be more than two expressions in the list.<p>\n", "</ul>\n", "\n", "The list goes on, but is too large to include here in complete form.  See the Yahoo link\n", 
"above.  Some examples:<p>\n", "<ul>\n", "  <li> <b>a</b> matches any value containing the letter a.<p>\n", 
"  <li> <b>ac</b> matches any value containing the letter a followed by the letter c.<p>\n", "  <li> <b>word</b> matches any value containing the sequence %22word%22.<p>\n", 
"  <li> <b>worda*</b> matches any value containing the sequence %22word%22 followed by zero or more a's.<p>\n", 
"  <li> <b>(word)*a</b> matches any value containing zero or more consecutive repetitions\n", "       of %22word%22, where the last repetition followed by an a.<p>\n", 
"  <li> <b>\\.log$</b> matches any value ending with .log (good for matching all files in \n", "       a directory ending with .log).<p>\n", 
"  <li> <b>^ex.*\\.log$</b> matches any value starting with ex and ending with .log.<p>\n", "  <li> <b>^access_log.*1</b> matches any value starting with %22access_log%22,\n", 
"       and containing a 1 somewhere after the leading %22access_log%22 (note that \n", "       the 1 does <i>not</i> have to be at the end of the string for this to match; if \n", 
"       you want to require that the 1 be at the end, add a $ to the end of the expression). <p>\n", 
"  <li> <b>^access_log_jan....1998$</b> matches any value starting with\n", "       %22access_log_jan%22, followed by four characters (any four characters), followed by\n", 
"       %221998%22, followed immediately by the end of the value. <p>\n", "</ul>\n", "As you can see, regular expressions are extremely powerful; a pattern can be devised\n", 
"to match almost any conceivable need.<p>\n", "\n", "NOTE ABOUT FILTERS:\n", "Both regular expression pattern filters and DOS-style pattern filters are necessary in some cases, \n", 
"but they should be avoided when possible because pattern filters can be considerably \n", "slower than the simpler filter types like %22ends with%22 or %22contains%22.  If \n", 
"you can create a filter without patterns, do--your log processing will be faster.<p>\n", "\"\n", "\n", 
"\n", "##\n", "## security documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_security \"Security\"\n", 
"DOCS_PAGE_CONTENTS_security\n", "\"Since {PRODUCT_NAME} runs as a CGI program or as a web browser, it publishes its interface to any web browser\n", 
"which can reach its server.  This is a powerful feature, but also introduces security\n", "issues.  {PRODUCT_NAME} has a number of features which address these issues:<p>\n", 
"\n", "<ol>\n", "  <li> Non-administrative users can access {PRODUCT_NAME} through the User Menu.\n", 
"       The User Menu only allows users to browse the statistics of configurations;\n", "       they cannot create, edit, or delete configurations, and they cannot build, update, or\n", 
"       modify the database of any configuration.  The User Menu is available at:\n", "\n", "         <pre>  http://www.myhost.com:8987/?user</pre>\n", 
"       <p>\n", "       in web server mode, or\n", "\n", "         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}?user</pre>\n", 
"       <p>\n", "       in CGI mode.  You may also include an optional parameter:\n", "\n", "         <pre>  http://www.myhost.com:8987/?user+param</pre>\n", 
"       <p>\n", "       in web server mode or\n", "\n", "         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}?user+param</pre>\n", 
"       <p>\n", "       in CGI mode.  If the parameter is present, only configurations whose names begin with the \n", 
"       parameter, followed by a dash, will be shown.  For example, http://www.yourhost.com:8987/?user+tom in web server mode,\n", 
"       or http://www.yourhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?user+tom in CGI mode,\n", "       will show only configurations whose names begin with %22tom-%22.<p>\n", 
"\n", "  <li> The [hium] option can be set on a configuration-by-configuration basis, and \n", "       can be used to omit certain configurations from the User Menu, if users \n", 
"       should not be browsing those statistics.  These configurations can still be \n", "       accessed by the administrator, and by non-administrative users\n", 
"       who know their names, through the Browse page (see below).<p>\n", "\n", "  <li> If you wish to take it a step further, and not even present the User Menu\n", 
"       to users, you can refer users to the Browse page:\n", "\n", "         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?browse</pre>\n", 
"\n", "       This page contains only a single field where users can type the name of a \n", "       configuration.  When they enter a configuration name in the field and click the \n", 
"       button, it will show them the statistics for that configuration. \n", "       Configurations can also be accessed directly by URL; \n", 
"       to view the statistics for a configuration called <code>my_config</code>, use:\n", "\n", "         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?view+my_config</pre>\n", 
"\n", "       This instructs {PRODUCT_NAME} to show statistics for the configuration named <code>my_config</code>.\n", 
"       You can also provide a single filter parameter; for instance\n", "         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?view+my_config+/dir1/</pre>\n", 
"         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?view+my_config+Jan/2000</pre>\n", 
"       show the contents of /dir1/ in a page statistics view or the hits on Jan/2000, \n", "       in a date/time statistics view.  Your URL will be slightly different if you're running \n", 
"       in web server mode (and you'll have a different hostname); see above \n", "       for some examples of this kind of URLs (http://www.myhost.com:8987/...).\n", 
"       Note that users familiar with {PRODUCT_NAME} can always get to the User Menu if\n", "       they want to by specifying it by URL, unless {PRODUCT_NAME} is running in one of its\n", 
"       secure modes (see below).<p>\n", "       (It is also possible to open a configuration using a URL, for example:\n", 
"         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?open+my_config</pre>\n", 
"         <pre>  http://www.myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS}.cgi?open</pre>\n", "       The first opens the configuration directly; the second lets you type the name in a field, \n", 
"       and then opens the configuration whose name you typed.)\n", "       <p>\n", "\n", "  <li> Any configuration can be password-protected using the [cvsp] option, so that only authorized users\n", 
"       can view the statistics of that configuration.  This can be used to prevent\n", "       unauthorized users from accessing a configuration, even if the configuration\n", 
"       appears in the User Menu, or the unauthorized user knows the name of the\n", "       configuration.  This option is often used in multi-user environments to \n", 
"       allow each user to view their own statistics, while preventing them from viewing anyone else's-- \n", 
"       in many situations, it's all the security you need.<p>\n", "\n", "  <li> Only authorized users (users who know the {PRODUCT_NAME} Administrative password, specified at install time)\n", 
"       may create new configurations,\n", "       and only authorized users may open or modify configurations.\n", 
"       For instance, without the password, a user cannot\n", "       create a new configuration, modify an existing configuration in any way, or do any other of\n", 
"       other tasks available on the Administrative menu.<p>\n", "\n", "  <li> In the Security Options section of the Options section of the Preference (which you\n", 
"       can reach from [docs-adminmenu]), you can choose one of two Security Modes (see [sm]).\n", "       In <i>Browse Only Mode</i>, the Administrative Menu is never available, and only the User Menu\n", 
"       appears; this means that even authorized users cannot create or edit configurations, so\n", 
"       configurations must be created and modified in this case\n", "       by editing the configuration text files on the server, rather than by using\n", 
"       the powerful graphical configuration features available in other modes.\n", "       (It is also possible to create configurations with another copy of {PRODUCT_NAME} on another server in\n", 
"       <i>Browse And Modify Mode</i>, and then copy them to the original server). \n", "       In <i>Browse And Modify Mode</i>, the default,\n", 
"       users may create and modify configurations if they have the administrative password,\n", "       and otherwise may only view statistics.  Browse and Modify Mode, because of\n", 
"       its use of password protection, is completely secure; the other modes exist\n", "       primarily to simplify the interface and to provide additional peace of mind.<p>\n", 
"\n", "</ol><p>\n", "{PRODUCT_NAME} also provides detailed control over the file and {DIRECTORY_WORD} permissions of\n", 
"the files and {PLURALIZE:{DIRECTORY_WORD}} it creates; see [docs-permissions].\"\n", "\n", "\n", "##\n", 
"## resources documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_resources \"Memory, Disk, and Time Usage\"\n", 
"DOCS_PAGE_CONTENTS_resources\n", "\"{PRODUCT_NAME} processes a huge amount of data while building a database or \n", 
"displaying statistics.  Because of this, it uses a lot of resources: \n", "disk space, memory, and processing time. \n", 
"(If you are considering running {PRODUCT_NAME} on a public or shared server, \n", "you may want to investigate their resource policy to see if they allow \n", 
"high-CPU programs to be run there).\n", "However, you can customize {PRODUCT_NAME} \n", "to use less of some of these resources, by using more of others.  You can also \n", 
"customize {PRODUCT_NAME} to use less of <i>all</i> resources by reducing the amount \n", "of data in your database.  This section describes the options that let you \n", 
"manage your memory, disk, and time resources.<p>\n", "\n", "<h3>Building the database faster</h3>\n", 
"{PRODUCT_NAME}'s default settings assume that you don't have a lot of memory to spare. \n", "With these default options, {PRODUCT_NAME} uses only about 10 Meg of memory to build \n", 
"a database of almost any size.  It does this by keeping the entire database on your\n", "hard drive, using a write buffer to collect data as it processes your logs, and only \n", 
"updating the disk version when the write buffer is full.\n", "You can \n", "speed things up a bit by increasing the value of [dwbs]; higher values will use more \n", 
"memory for the write buffer, which results in less access to the disk database and faster builds.<p>\n", 
"\n", "If you've configured {PRODUCT_NAME} to look up your IP numbers (using [luin]), the database building \n", 
"process will be slower than usual, as {PRODUCT_NAME} looks up all the IP numbers in your\n", "log file.  You can speed things up by not using [luin], \n", 
"by decreasing the [dt], by increasing the [leps], \n", "and/or by improving {PRODUCT_NAME}'s bandwidth to the DNS server.<p>\n", 
"\n", "For very large database builds, the [df] option can sometimes become a problem. \n", "That option forces the database to consolidate regularly during builds to \n", 
"that recent statistics are always available.  However, with very large databases, \n", "the consolidate stage can last several minutes, so running it every few minutes \n", 
"can have a serious impact on performance.  You can increase this option to \n", "a very high value to eliminate this problem (though you won't have up-to-the-minute \n", 
"statistics during database builds if you do).<p>\n", "\n", "<h3>Using less memory during database builds</h3>\n", 
"There are three major sources of memory usage during the database builds: \n", "the database write buffer, the database segments, and the indices.  The memory \n", 
"usage can be reduced by reducing the size of any of these three, or several at once.<p> \n", "\n", 
"The database write buffer is controlled by the [dwbs] option.\n", "It is set to 10 Meg by default, and you can reduce that value to reduce memory usage during builds.\n", 
"However, it should be left at least at 5 Meg unless memory is very tight; \n", "much lower will significantly reduce database build performance and require more disk access.<p> \n", 
"\n", "The database segments themselves hold all the data in the database, and \n", "can become arbitrarily large.  Fortunately, only one segment needs to be in memory at a time, \n", 
"and you can control how many segments there are using the [nds] option, \n", "so you can make the size of each segment as small as you wish. \n", 
"For instance, if your database is 1 Gig on disk, and there are 10 database segments, \n", "then each segment will be roughly 100 Meg, and you will need 100 Meg free during the database \n", 
"consolidation stage in order to build the database successfully \n", "(in addition to the memory you need for the write buffer, the indices, and \n", 
"{PRODUCT_NAME}'s basic operation).  You can reduce the memory usage in \n", "this case by using 100 segments instead; then each segment will be 10 Meg, and you will need \n", 
"only 10 Meg of memory free for the segments.  Or you can use 1000 segments, to \n", "reduce the size of each segment to only 1 Meg.  However, having more segments makes the database \n", 
"slower to build because of the greater number of files to be accessed, \n", "and because the same amount of write buffer must be spread among more segments.<p>\n", 
"\n", "The database indices must be kept in memory during all database operations, \n", "and for a very large and complicated database, the database field indices can get very large, \n", 
"especially the page and visitor id fields, since they track every page in the site and \n", "every hostname who visited it.  You can get an idea of how large your database indices are \n", 
"by watching the detailed progress information during a web-based database build, or \n", "by looking at the sizes of the files in the database directory\n", 
"whose names begin with %22hierarchies%22 or %22items.%22\n", "You can reduce the size of the page index (or any other hierarchical field) \n", 
"by suppressing the bottom of the page hierarchy using %22suppress bottom levels%22\n", "in the Database Fields tab of the options.\n", 
"You can reduce the size of the visitor id field only by eliminating the field entirely, \n", "and not tracking visitor information.<p>\n", 
"\n", "<h3>Browsing the statistics faster</h3>\n", "One important option that can affect statistics browsing performance is the \n", 
"[o] option.  This option automatically restructures the hierarchy to make \n", "the information on the statistics page as useful as possible, by pulling \n", 
"items up from lower in the hierarchy when zooming in would show a table with just \n", "one item.  This is handy, but it requires numerous database accesses, which can slow\n", 
"statistics browsing on very large tables.  If you're seeing performance problems, \n", "make sure this option is off.<p>\n", 
"\n", "You can also speed up statistics browsing by telling {PRODUCT_NAME} to remember \n", "database entries that have already been read, so that future accesses to the same data \n", 
"will be much faster; to do this, use a high value for [drcs].<p>\n", "\n", "Certain statistics views require large numbers of database accesses, especially with a large \n", 
"database.  These views appear with (computed) in their names in the view menu (see [docs-statspages]). \n", 
"You may want to avoid using those views if you find they are too slow.  If you want the views to \n", 
"be disabled entirely, you can disable or remove them in the Stats View tab of the \n", "configuration options.<p>\n", 
"\n", "<h3>Reducing memory, disk space, and time usage by reducing database size</h3>\n", "Though {PRODUCT_NAME} is highly optimized in its disk space and memory usage, a database can still \n", 
"be extremely large.  The reason the database uses a lot\n", "of disk space is that the database contains a <i>lot</i> of information.  Going far beyond\n", 
"what most log analysis tools do, {PRODUCT_NAME}'s database can store multiple full field hierarchies\n", 
"(the page, date, host, and other hierarchies), and complete information about which specific\n", "combinations of items received page views.  This provides exceptional flexibility in navigating\n", 
"the statistics, but at a cost in disk space and time.<p>\n", "\n", "You can make the database as small and as fast as you want, but only by discarding information.\n", 
"However, {PRODUCT_NAME} provides a large collection of options to let you discard information \n", 
"that is of less value to you, while keeping the most important information.<p>\n", "\n", "One way to reduce disk usage is to use a smaller dataset.  The [sle]\n", 
"option is a good way to reduce the dataset;\n", "another way to do it is to use the filters, for instance to discard all page views\n", 
"except those during February, 1998, or all page views except those from .com.<p>\n", "\n", "Another major way to reduce disk usage is to eliminate cross-referencing between database fields.\n", 
"The default %22full detail%22 database structure for an extended format log has 12 or more database fields, \n", 
"but many of them are not cross-referenced to anything else.  It takes very little time and memory \n", 
"to keep track of a single non-cross-referenced field, or even a pair of fields cross-referenced \n", 
"to each other.  However, three or more fields all cross-referenced to each other can require \n", "a <i>lot</i> of disk space, memory, and time, especially if the fields are large or heavily hierarchical, \n", 
"like the page, date/time, host, and referrer fields.  In the default %22full detail%22\n", "database, the date/time, page, host, \n", 
"and referrer fields are all cross-referenced against each other, and those fields form by <i>far</i> \n", 
"the greatest portion of the database data (roughly 99% in most cases).  Eliminating all cross-referencing \n", 
"by using the %22Summary%22 detail level \n", "can reduce your data size by a factor of 100, and reduce the memory and time similarly.  \n", 
"However, the filtering (cross-referencing) feature is extremely powerful, and \n", "eliminating it removes most of the possible views of your data.  Try different combinations of \n", 
"cross-referencing until you find a good compromise between resource usage and data completeness. \n", 
"See [docs-xref] for more information.<p>\n", "\n", "Another way of reducing disk usage is to %22trim%22\n", 
"each field, perhaps to show only the top two levels, or only the bottom two. \n", "The can yield significant space savings.  For instance, you may not care\n", 
"about the page field beyond the first two levels (you care that there were hits on \n", "/shop/department1/ but you don't care which pages were hit there); trimming the \n", 
"bottom of the page field \n", "greatly reduces the number of page items indexed,\n", "and therefore reduces the size of the database.<p>\n", 
"\n", "Finally, if your need for less disk space usage is due to a disk usage quota on\n", "your web server, you may be able to get around this problem by \n", 
"running {PRODUCT_NAME} on a local machine, where <i>you</i> dictate disk space\n", "constraints, and setting it to fetch the log data by FTP.\"\n", 
"\n", "\n", "\n", "##\n", "## screeninfo documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_screeninfo \"Getting Screen Dimensions and Depth Information\"\n", 
"DOCS_PAGE_CONTENTS_screeninfo\n", "\"When analyzing web site traffic, it is often useful to know the screen dimensions \n", 
"(width and height in pixels) and screen depth (depth in bits; i.e. number of available colors) \n", 
"of your visitors, so you can design the width and height of the pages to fit on the monitors \n", "of your visitors, and so you can decide what colors to use in your images.  This information is \n", 
"not generally available in web server log data, but you can add it by including the following small \n", 
"JavaScript program in one or more of your HTML pages:<p>\n", "<pre>\n", "&lt;script language=%22JavaScript%22&gt;\n", 
"document.write('&lt;img width=%221%22 height=%221%22 src=%22/log_analysis_screen_info.gif?' +\n", " 'width=' + screen.width + '&height=' + screen.height + '&depth=' + screen.colorDepth + '%22&gt;\\n');\n", 
"&lt;/script&gt;\n", "</pre>\n", "Just copy the script, paste it at the bottom of one of your web pages, and you're done.\n", 
"This script causes an extra entry to be included in the log data for each line processed. \n", "The entry, which appears as a hit on the file /log_analysis_screen_info.gif,\n", 
"is used automatically by {PRODUCT_NAME} when analyzing web logs to compute the values of the \n", "derived %22screen dimensions%22 and %22screen depth%22 log fields, which are displayed \n", 
"in the statistics in the %22Top screen dimensions%22 and %22Top screen depths%22 views.<p>\n", "\n", 
"The image /log_analysis_screen_info.gif does not need to exist, but if it doesn't, \n", "you will see 404 errors (broken links) in your statistics for the file, and in some browsers\n", 
"you may see a small dot on your page where the JavaScript code appears.  If you don't \n", "want to see these, you need to create an image file at the root of your site called \n", 
"/log_analysis_screen_info.gif.  A blank or transparent image is a good choice.  \n", "You can also put the image somewhere else on your site, and change the JavaScript to match,\n", 
"but the name of the image and its parameters must remain the same.", "However, it will actually slow your page down slightly if the image exists-- ", 
"it is usually best to <i>not</i> create the image file.<p>\n", "\"\n", "\n", "\n", "##\n", "## relabelling documentation page text\n", 
"##\n", "\n", "DOCS_PAGE_TITLE_relabelling \"Relabelling {PRODUCT_NAME}\"\n", "DOCS_PAGE_CONTENTS_relabelling\n", 
"\"{PRODUCT_NAME} contains a number of options that can be used to relabel it; by\n", "modifying these options you can change the name of the product, change its logo, \n", 
"and more.  These options are provided for ease of relabelling by our licensed\n", "partners, but <b>a standard license does not permit you to relabel</b>\n", 
"If you need to change the name or logo of {PRODUCT_NAME}, or to hide its logo or credit\n", "information, please contact us at {SUPPORT_EMAIL} and we can discuss the licensing\n", 
"you will need to do that.  If you have not purcahsed separate licensing, please do\n", "not relabel {PRODUCT_NAME}, hide/modify its logos, or hide the credit on the statistics page.\n", 
"\"\n", "\n", "\n", "##\n", "## customformats documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_customformats \"Custom Log Formats\"\n", 
"DOCS_PAGE_CONTENTS_customformats\n", "\"{PRODUCT_NAME} ships with support for most common log formats, but \n", 
"if your log is in a format which {PRODUCT_NAME} does not support directly, \n", "you can still use {PRODUCT_NAME} to process it, by creating your own custom log format description file.<p> \n", 
"\n", "The log formats supported by {PRODUCT_NAME} are described in small text files found in \n", "the LogFormats sub{DIRECTORY_WORD} of the LogAnalysisInfo {DIRECTORY_WORD}. \n", 
"The default format files are created when you first create a configuration, \n", "right after you select the log files.  Each file in the LogFormats {DIRECTORY_WORD} \n", 
"defines a separate log format.  To add a new log format to the list of formats supported \n", "by {PRODUCT_NAME}, all you need to do is create your own format file, and put in the LogFormats \n", 
"{DIRECTORY_WORD}.<p>\n", "\n", "Creating a log format file can be tricky, but you can make it a lot easier by using \n", 
"the existing format files as templates.  Look over a few of the built-in formats before \n", "you start creating your own.  Most format files look similar, and you'll probably want \n", 
"to copy one of them and modify it to create your own format.<p>\n", "\n", "The basic steps you'll need to take to create a new log format are: <p>\n", 
"<ol>\n", "  <li> Choose a format similar to yours.  For instance, if you're creating a new \n", "       web log format, start with ApacheCombined.  If you're creating a new \n", 
"       proxy log format, start with CommonProxy.  Duplicate the file and choose your own name.<p>\n", 
"  <li> Change the log_file_format option to the name of your log file format.<p>\n", "  <li> Change the log_file_format_autodetect_regular_expression option to a regular expression \n", 
"       which matches your log format.  See [docs-regexp] for information on regular expressions. \n", 
"       The regular expression to provide here will be used to auto-detect your log format. \n", "       It is not used during log processing, so if you have a lot of trouble with this step, \n", 
"       you can leave the option blank, and choose your format manually when {PRODUCT_NAME} asks.<p>\n", 
"  <li> Set the log date and time formats.  See [ldf] and [ltf].  If your log uses a different \n", 
"       date or time format, please contact {SUPPORT_EMAIL}, so we can add it.<p>\n", "  <li> Describe the log fields.  If you're familiar with regular expressions, the easiest way \n", 
"       to do this is to use the [lffre] option; you can describe the entire log line as a regular \n", 
"       expression, with individual fields parenthesized, and then list the fields in log order in \n", 
"       the log_field_info section of the log format file.  See the WUFTP log format description for an example of this.<p> \n", 
"       If you're not comfortable with regular expressions, or if you need maximum log processing speed, \n", 
"       you can also describe the log format using the index/subindex of each field; see ApacheCombined \n", 
"       for an example of this.  Some log format, however, cannot be described without regular expressions.<p> \n", 
"       If your log format is really ugly (especially if log entries are spread out across multiple lines), \n", 
"       you will need to use log parsing filters to collect log entries from multiple lines and accept them. \n", 
"       See Raptor for an example of this type of log format.<p>\n", "  <li> Describe the database fields.  This is usually a pretty simple step; just create a database fields \n", 
"       for each log field you're interested in.  See any of the built-in log formats for examples.<p>\n", 
"  <li> Add any log filters.  If you want to reject some log entries, or if you want to categorize some \n", 
"       entries as hits and others as page views, or if you need to do specialized \n", "       conversions on or between fields, you will need to create log filters (see [lf]). \n", 
"       Most of the built-in formats have some filters; see them for examples.<p>\n", "  <li> Set the cross-referencing groups.  These groups correspond to the checkboxes in the \n", 
"       cross-referencing table.  If you want a particular field to be cross-referenced to another \n", 
"       field, just put them both in some group (any group).  If you don't want any cross-referencing, \n", 
"       put each database field in its own group.<p>\n", "</ol>\n", "If you have any problems creating a custom format, please contact \n", 
"<a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>--we've created a lot of formats, \n", "and we can help you create yours.  If you create a log format file for a popular format, \n", 
"we would appreciate it if you could email it to us, for inclusion in a later version of {PRODUCT_NAME}.\n", 
"\"\n", "\n", "\n", "\n", "##\n", "## logformats documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_logformats \"Supported Log Formats\"\n", 
"DOCS_PAGE_CONTENTS_logformats\n", "\"{PRODUCT_NAME} supports many different log formats using an extensible plug-in architecture.\n", 
"This version of {PRODUCT_NAME} supports the following formats:<p>\n", "{LOGFORMATS}\n", "{PRODUCT_NAME} automatically detects all of these formats, and arranges \n", 
"your configuration options intelligently based on your log format.\n", "If your format is a public one (if it is generated by a publicly available program),\n", 
"and is not on the list, we will add it for free--just send a sample of your log data\n", "(1 Meg is ideal, but anything more than ten lines will do) to\n", 
"<a href=%22{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a> and we will create \n", "a format description file, usually within a few days.  If your format is a private one, \n", 
"you can still process it with {PRODUCT_NAME} by creating a custom log format description file \n", 
"(see [docs-customformats]).<p>\n", "\"\n", "\n", "\n", "##\n", "## handconfig documentation page text\n", 
"##\n", "\n", "DOCS_PAGE_TITLE_handconfig \"Creating and Editing Configurations by Hand\"\n", "DOCS_PAGE_CONTENTS_handconfig\n", 
"\"If you use {PRODUCT_NAME} to manage a large number of configurations, you may\n", "find the CGI interview process inadequate to your needs.  For instance, you may\n", 
"want to be able to create multiple configurations from the command line\n", "(or with AppleScript on MacOS) with a single command, without having to run\n", 
"a web browser or manually enter the information.  In cases like these, you can\n", "create configurations %22by hand,%22 by creating your own configuration files.<p>\n", 
"\n", "Several other documentation sections discuss the use of configuration files; see\n", "[docs-configfiles], [docs-options], and [docs-poweruse].  In general, you will want to\n", 
"create configurations using a text file editor or a script, and %22run%22 them with {PRODUCT_NAME}\n", 
"using the [rfcf] option.<p>\n", "\n", "It's often most convenient to create a %22template%22 configuration using the web browser\n", 
"interface.  That configuration can then be duplicated and modified by hand\n", "when a new, similar one is needed.<p>\n", 
"\n", "If you want the configuration to appear in the Main Menu (so it's\n", "usable by CGI users), the file needs to be in the Configs sub{DIRECTORY_WORD} of \n", 
"the LogAnalysisInfo {DIRECTORY_WORD}.<p>\n", "\n", "Configurations can run in one of five modes:\n", 
"create the database, update the database, expire the database, generate offline HTML files, \n", "or view the statistics (%22view the statistics%22 mode is not useful from the command line).\n", 
"When running from the command line, you will usually want to choose which mode to use\n", "with the [cm] command.<p>\n", 
"\n", "If you want to customize the first statistics page which appears\n", "(to make it something other than the no-filters page, as it is by default), you can change the setting\n", 
"of [f] and [asv].\"\n", "\n", "\n", "##\n", "## password documentation page text\n", "##\n", "\n", 
"DOCS_PAGE_TITLE_password \"The {PRODUCT_NAME} Password\"\n", "DOCS_PAGE_CONTENTS_password\n", "\"The first time you run {PRODUCT_NAME} through a web browser, it will\n", 
"prompt you for a password.  This password will be used in all cases where security is\n", "an issue (for instance, when specifying which log data to process, or when creating a configuration).\n", 
"If you forget your password, you can reset it by removing the AdminPassword file, found in the \n", 
"LogAnalysisInfo {DIRECTORY_WORD}.<p> \n", "If you wish, you can check the box called %22{AUTOLOGON_CHECKBOX}%22 when you enter the \n", 
"password.  If you do that, {PRODUCT_NAME} will save your password on the machine running the web browser, \n", 
"and will not ask you for the password if you are using that machine.  Be careful,\n", "though--anyone else using that machine will also be able to get into {PRODUCT_NAME} without a password.<p>\n", 
"For more information on security in {PRODUCT_NAME}, see [docs-security].\"\n", "\n", "\n", "##\n", 
"## permissions documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_permissions \"File/{CAPITALIZE:{DIRECTORY_WORD}} Permissions\"\n", 
"DOCS_PAGE_CONTENTS_permissions\n", "\"{PRODUCT_NAME} lets you control very precisely the permissions on the files\n", 
"and {PLURALIZE:{DIRECTORY_WORD}} it creates.  This is particularly useful on multi-user\n", "UNIX and Windows environments, where file permissions are a fundamental part\n", 
"of file system security.<p>\n", "You can set permissions independently for a number of categories of\n", 
"files and {PLURALIZE:{DIRECTORY_WORD}} {PRODUCT_NAME} creates.\n", "See [cat-security] for a list of the specific options which control\n", 
"permissions for each category.<p>\n", "For each category, you can specify\n", "the value of the permissions number.  The permissions number is a three-digit\n", 
"octal (base-8) number, as accepted by the UNIX chmod command.\n", "The first digit controls the permissions for the user running {PRODUCT_NAME}, the second digit controls\n", 
"the permissions for the group of the user running {PRODUCT_NAME}, and\n", "the third digit controls the permissions for all other users.\n", 
"Each digit is the sum of: 4, if read permission should be granted; 2, for write permissions; and\n", 
"1, for execute or {DIRECTORY_WORD} search permission.\n", "These values can be added in any combination to provide any combination of permissions.\n", 
"For example, to grant only read permission, use a 4.  To grant both read and write permission,\n", 
"use the sum of 4 and 2, or 6.  To grant read and execute permission, use the sum of 4 and 1, or 5.\n", 
"You should give execute permissions for {PLURALIZE:{DIRECTORY_WORD}} if you want users to be able to\n", 
"view their contents.<p>\n", "A complete example of a permissions option value:\n", "754 gives the {PRODUCT_NAME} user read, write, and execute permission,\n", 
"gives the group read and execute permission, and gives all other users read permission.<p>\n", "See [docs-security] for more information on {PRODUCT_NAME}'s security features.\"\n", 
"\n", "\n", "##\n", "## rewrite rules documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_rewriterules \"Filtering Rewrite Rules\"\n", 
"DOCS_PAGE_CONTENTS_rewriterules\n", "\"{PRODUCT_NAME} includes a feature, based on Apache's rewrite module \n", 
"(but much more limited), which lets you filter your log files \n", "based on a set of rules listed in a text file.  You can use \n", 
"a rewrite rules file by adding a rewriting log filter to \n", "your Log Filters set, in the Log Filters tab of the Configuration Options.\n", 
"Rewrite rules let you easily add and maintain a large number of translations \n", "in one easily-edited text file.<p>\n", 
"\n", "Each line of the rule file contains a different directive.  At this time, \n", "only the <b>RewriteRule</b> directive is supported.  The syntax of \n", 
"<b>RewriteRule</b> is:\n", "<pre>  RewriteRule <i>regexp</i> <i>replacement</i> {QUOTE:%5B<i>flags</i>%5D}</pre>\n", 
"<i>regexp</i> is a regular expression (see [docs-regexp]).  If the value \n", "matches this regular expression, the replacement occurs; otherwise, the rule does nothing. \n", 
"If <i>regexp</i> matches, the value of the field is replaced by <i>replacement</i>; \n", "otherwise, the rule does nothing.  Variables (e.g. $1) in <i>replacement</i> are \n", 
"resolved by replacing them by the value of the corresponding parenthesized subexpression \n", "(for instance, if the field value is %22/dir1/dir2/file.html%22 and the pattern is \n", 
"%22^/dir1/dir2/(.*)$%22, then it will match, and the value $1 will be replaced with \n", "%22file.html%22 wherever it appears in <i>replacement</i>).  <i>flags</i> can be empty, \n", 
"or it can be %22L%22; %22L%22 means to stop running the rules if the filter matches. \n", "Otherwise, {PRODUCT_NAME} will continue running the rules in order until it reaches the end \n", 
"of the rules.<p>\n", "\n", "For instance, a rule which replaces %22john%22 with %22John Q. Public%22 would be:<p>\n", 
"<pre>  RewriteRule ^john$ %22John Q. Public%22 {QUOTE:[L]}</pre>\n", "Though {PRODUCT_NAME}'s feature is based on Apache's rewrite module, \n", 
"most of Apache's features are not supported.  If you have a need for \n", "one of Apache's features that is not present in {PRODUCT_NAME}, please email \n", 
"<a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a> \n", "and we will add it if possible.<p>\n", 
"\"\n", "\n", "\n", "\n", "##\n", "## credits documentation page text\n", "##\n", "\n", "DOCS_PAGE_TITLE_credits \"Credits\"\n", 
"DOCS_PAGE_CONTENTS_credits\n", "\"{PRODUCT_NAME}\n", " was created by <a href=mailto:ferrar@flowerfire.com>Greg Ferrar</a>.<p>\n", 
"\n", "Inspiration for {PRODUCT_NAME} came from <a href=%22http://www.kai.com/%22>Kuck &amp; Associates, Inc</a>,\n", 
"and from <a href=%22http://www.flowerfire.com/seized/><i>Seized by the Tale</i></a>,\n", "two sites which needed such a tool.<p>\n", 
"\n", "This product includes GeoIP data created by MaxMind, available from <a href=%22http://maxmind.com/%22>http://maxmind.com/</a><p>\n", 
"Thanks to the makers of <a href=http://www.boutell.com/gd/><b>gd</b></a>, an\n", "excellent GIF creation library which is used to create all images displayed by {PRODUCT_NAME},\n", 
"including the pie charts, line graphs, table bars, legend boxes, and icons.\n", "gd was written by Thomas Boutell and is currently distributed by boutell.com, Inc.\n", 
"gd 1.2 is copyright 1994, 1995, Quest Protein Database Center, Cold Spring Harbor Labs.<p>\n", "\n", 
"Thanks to the makers of zlib, which {PRODUCT_NAME} uses to process gzip and ZIP log data.<p>\n", "\n", 
"Thanks to Ken Brownfield for installing the latest compilers, assemblers and debuggers\n", "on every type of machine, whenever I expressed a whim to see {PRODUCT_NAME} running\n", 
"on platform <i>x</i>.<p>\n", "\n", "Thanks to Jason Simpson, Ken Brownfield, and Wayne Schroll for important feedback on the 1.0 alpha\n", 
"versions.<p>\n", "\n", "Thanks to Stephen Turner for his experienced input on the early 1.0 versions.<p>\n", 
"\n", "Thanks to the 1.0 beta testers for help on the beta versions, especially to\n", "Gary Parker, Glenn Little, and Phil Abercrombie.<p>\n", 
"\n", "Thanks to the 2.0 beta testers for help on the beta versions, especially to\n", "Gary Parker, Vincent Nonnenmach, and Glenn Little.<p>\n", 
"\n", "Thanks to all the 3.0 beta testers, especially Vincent Nonnenmach.<p>\n", "\n", "Thanks to all the 4.0 beta testers, especially (yet again) Vincent Nonnenmach,\n", 
"and many others.<p>\n", "\n", "Thanks to all the 5.0 beta testers, especially Fred Hicinbothem, \n", 
"Yuichiro Sugiura, and Peter Strunk.<p>\n", "\n", "Thanks to all the 6.0 beta testers, especially Ed Kellerman, \n", 
"Noah Webster, Johnny Gisler, Morgan Small, Charlie Reitsma, James K. Hardy, \n", "Alexander Chang, Richard Keller, Glenn Little, Eric Luhrs, and Yann Debonne.<p>\n", 
"\n", "{PRODUCT_NAME} is a much better product thanks to the help of these and other \n", "beta testers.<p>\n", 
"\n", "\"\n", "\n", "\n", "##\n", "## all documentation page info\n", "##\n", "\n", "DOCS_PAGE_TITLE_all \"All Documentation\"\n", 
"DOCS_PAGE_CONTENTS_all \"All Documentation is handled specially\"\n", "\n", "\n", "##\n", "## copyright documentation page text\n", 
"##\n", "\n", "DOCS_PAGE_TITLE_copyright \"Copyright\"\n", "DOCS_PAGE_CONTENTS_copyright\n", "\"{PRODUCT_NAME}\n", 
" is copyrighted &copy; 1997-2003 by {COPYRIGHT_HOLDER}.  This is a commercial product.\n", " Any use of this product without a license is a violation of copyright law.\n", 
" Please don't use an illegal or pirated copy of {PRODUCT_NAME}!\"\n", "\n", "\n", "# Miscellaneous documentation-related variables\n", 
"SEE_ALL_CATEGORIES \"See [cat-all]\"\n", "FULL_DESCRIPTION \"Full Description\"\n", "ADVANCED_DETAILS \"Advanced Details and Command Line Usage\"\n", 
"OPTION_TAB_LABEL \"(on the {CATEGORY_NAME_SHORT_{CATEGORY}} tab of the Configuration Options)\"\n", 
"PREFS_OPTION_TAB_LABEL \"(on the {CATEGORY_NAME_SHORT_{CATEGORY}} tab of the Preferences)\"\n", "INTERNAL_OPTION_TAB_LABEL \"(internal option)\"\n", 
"COMMAND_LINE_OPTION_TAB_LABEL \"(command line option-- cannot be edited in the Configuration Options)\"\n", 
"LOG_FORMAT_OPTION_TAB_LABEL \"(log format option-- cannot be edited in the Configuration Options)\"\n", 
"OPTION_LABEL \"Option\"\n", "COMMAND_LABEL \"Command label\"\n", "COMMAND_LINE_SHORTCUT \"command&nbsp;line&nbsp;option (shortcut)\"\n", 
"COMMAND_DESCRIPTION \"Command Description\"\n", "COMMAND_LINE_USAGE \"Command line usage\"\n", "OPTION_CATEGORY \"Option Category\"\n", 
"PRODUCT_WEB_SITE \"{PRODUCT_NAME} Web Site\"\n", "ADMINISTRATIVE_MENU \"Administrative Menu\"\n", "SEARCH_BUTTON \"Search\"\n", 
"PAGE_TYPE \"Page Type\"\n", "PAGE_NAME \"Page Name\"\n", "SEARCH_PHRASE_NOT_FOUND \"(The phrase %22{SEARCH_TEXT}%22 was not found anywhere in the documentation)\"\n", 
"SEARCH_PHRASE_NOT_FOUND_ESCAPES \"(The phrase you searched for was not found anywhere in the documentation)\"\n", 
"SEARCH_RESULTS \"Search results for %22{SEARCH_TEXT}%22\"\n", "SEARCH_RESULTS_ESCAPES \"Search results\"\n", 
"SEARCH_FOUND \"Found {SEARCH_MATCHES} occurrences of %22{SEARCH_TEXT}%22\"\n", "DOCUMENTATION_PAGE \"Documentation Page\"\n", 
"FAQ_ENTRY_LABEL \"FAQ Entry\"\n", "FAQ_LABEL \"FAQ\"\n", "TOC_LABEL \"User's Guide\"\n", "DOCUMENTATION_TITLE \"DOCUMENTATION\"\n", 
"\n", "\n", "\n", "##\n", "## copyright documentation page text\n", "##\n", "DOCS_PAGE_TITLE_webstarv \"Using {PRODUCT_NAME} with WebSTAR V on MacOS X\"\n", 
"DOCS_PAGE_CONTENTS_webstarv\n", "\"<p>This chapter was contributed by David Wrubel.</p>\n", "<p>If you choose to run {PRODUCT_NAME} in web server mode,\n", 
"it run as a separate webserver application with its own default port number 8987 on the same Mac as WebStar V.</p>\n", 
"<h3>Installation</h3>\n", "Because of the way WebStar V is installed on MacOS X,\n", "the installation process of {PRODUCT_NAME} is a little tricky.\n", 
"Part of the {PRODUCT_NAME} (for WebStar V) installation process involves\n", "command line work in the OS X UNIX &quot;Terminal&quot;. This work is done,\n", 
"using the root user privileges and should be done with extreme caution since\n", "the root user has write access to all files, including system files.</p>\n", 
"\n", "Because of security reasons, 4D instructs WebStar users only to install the WebStar application when logged in MacOS X as the admin user. 4D advises WebStar V users to create a MacOS X user that does NOT have admin privileges. The user is normally called &quot;webstar&quot; and is used when WebStar V is running. This setup protects system files and the WebStar V application against some types of unauthorized intrusions. At the same time there is full access to all website files that users upload and download.<br>\n", 
"\n", "<br>\n", "\n", "The above imposes a problem for {PRODUCT_NAME}, since {PRODUCT_NAME} must be installed in MacOS X when the user is logged in as the admin user. When {PRODUCT_NAME} is installed and you log out and then log in as the &quot;WebStar&quot; user, to run WebStar V, you will not have access to run {PRODUCT_NAME}, since {PRODUCT_NAME} only will run when logged in as the MacOS X admin user.<br>\n", 
"<br>\n", "\n", "You have to change the ownership ID (or valid user name) of all {PRODUCT_NAME} files from the admin user (typically the user that installed Mac OS X) to the &quot;webstar&quot; user, to be sure that {PRODUCT_NAME} will run when logged in as the webstar user.<br>\n", 
"<br>\n", "\n", "To do this, follow these steps (again: be careful, as you will be logged in as the root user as long as you are working in the Terminal):\n", 
"\n", "<ol>\n", "<li> Webstar V and the &quot;webstar&quot; user must already be installed and configured.<br>\n", 
"<br>\n", "\n", "<li> If you haven't done it already, please be logged in as the admin MacOS X user and install {PRODUCT_NAME} via {PRODUCT_NAME}.pkg. The default installation process will create a %22{PRODUCT_NAME}%22 folder in the MacOS X %22Applications%22 folder. All {PRODUCT_NAME} files and folders will be installed in the {PRODUCT_NAME} folder. Do not start {PRODUCT_NAME} after the installation.<br>\n", 
"<br>\n", "\n", "<li> In the /Applications/Utilities folder, start the %22Terminal%22 application.<br>\n", 
"\n", "At the command prompt key the following commands and use your admin user password when asked (in this example the admin user is %22davidw%22). Also be sure that the Terminal gives you the same returns. If you experience any differences, you can always type %22Exit%22 to log out from the root user and thereby (hopefully) protect against damage:</p>\n", 
"<table border=%220%22 cellpadding=%220%22 cellspacing=%2210%22 width=%22922%22>\n", "<tr>\n", "<td width=%22515%22 bgcolor=%22#ffffff%22><b><font face=%22Courier New,Courier,Monaco%22 size=%22+1%22>Commandline (bold type = your input)</font></b></td>\n", 
"<td bgcolor=%22#ffffff%22><b><font size=%22+1%22>Comments</font></b></td>\n", "</tr>\n", "<tr>\n", 
"<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>Welcome to Darwin!<br>\n", 
"\n", "{QUOTE:%5Blocalhost:~%5D} davidw%</font></td>\n", "<td valign=%22top%22 bgcolor=%22#ffffff%22>When you start the Terminal and choose %22New%22 in the %22Shell%22 menu, you will see this in a new terminal window.</td>\n", 
"</tr>\n", "<tr>\n", "<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:~%5D} davidw% <b>sudo su</b><br>\n", 
"\n", "Password:</font></td>\n", "<td valign=%22top%22 bgcolor=%22#ffffff%22>SUDO SU gives you root access. Type your admin password and hit the return key.</td>\n", 
"</tr>\n", "<tr>\n", "<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:/Users/davidw%5D} root#<b> cd /applications/sawmill/</b></font></td>\n", 
"<td valign=%22top%22 bgcolor=%22#ffffff%22>Navigates you to the %22sawmill%22 folder. Note that the commandline says you are now %22root#%22.</td>\n", 
"</tr>\n", "<tr>\n", "<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:/applications/sawmill%5D}<b> root# ls -ls<br>\n", 
"</b>total 9104<br>\n", "\n", "0 drwxrwxr-x  3 davidw  admin       58 Apr 21 09:43 Extras<br>\n", "\n", 
"24 -rwxr-xr-x  1 davidw  admin     9348 Apr 21 09:43 License.txt<br>\n", "\n", "8 -rwxrwxr-x  1 davidw  admin     3113 Apr 21 09:43 ReadMe.txt<br>\n", 
"\n", "0 drwxrwxr-x  3 davidw  admin       58 Apr 21 09:43 {PRODUCT_NAME}.app<br>\n", "\n", "0 drwxrwxr-x  6 davidw  admin      160 Apr 21 09:43 Startup<br>\n", 
"\n", "9072 -rwxr-xr-x 1 davidw admin 4641768 Apr 21 09:43 sawmill</font></td>\n", "</tr>\n", "<tr>\n", 
"<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:/applications/sawmill%5D} root# <b>cd..</b></font></td>\n", 
"<td valign=%22top%22 bgcolor=%22#ffffff%22>Navigate back to the Applications folder.</td>\n", "</tr>\n", 
"<tr>\n", "<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:/applications%5D} root# <b>chown -R webstar sawmill</b></font></td>\n", 
"<td valign=%22top%22 bgcolor=%22#ffffff%22>Now be careful: key the command exactly as shown. This changes the ownership of all files in the sawmill folder including the sawmill folder itself.</td>\n", 
"</tr>\n", "<tr>\n", "<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:/applications%5D} root#<b> cd sawmill</b></font></td>\n", 
"<td valign=%22top%22 bgcolor=%22#ffffff%22>Navigate into the sawmill folder</td>\n", "</tr>\n", "<tr>\n", 
"<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:/applications/sawmill%5D} root# <b>ls -ls<br>\n", 
"</b>total 9104<br>\n", "\n", "0 drwxrwxr-x  3 webstar  admin       58 Apr 21 09:43 Extras<br>\n", "\n", 
"24 -rwxr-xr-x  1 webstar  admin     9348 Apr 21 09:43 License.txt<br>\n", "\n", "8 -rwxrwxr-x  1 webstar  admin     3113 Apr 21 09:43 ReadMe.txt<br>\n", 
"\n", "0 drwxrwxr-x  3 webstar  admin       58 Apr 21 09:43 {PRODUCT_NAME}.app<br>\n", "\n", "0 drwxrwxr-x  6 webstar  admin      160 Apr 21 09:43 Startup<br>\n", 
"\n", "9072 -rwxr-xr-x 1 webstar admin 4641768 Apr 21 09:43 sawmill</font></td>\n", "<td valign=%22top%22 bgcolor=%22#ffffff%22>Let's list the files and folders in the sawmill folder to check that the ownerships have really been changed. Note that the owner is now %22webstar%22 instead of %22davidw%22.</td>\n", 
"</tr>\n", "<tr>\n", "<td width=%22515%22 valign=%22top%22 bgcolor=%22#ffffff%22><font face=%22Courier New,Courier,Monaco%22 size=%222%22>{QUOTE:%5Blocalhost:/applications/sawmill%5D} root#<b> exit<br>\n", 
"</b>exit<br>\n", "\n", "{QUOTE:%5Blocalhost:~%5D} davidw%</font></td>\n", "<td valign=%22top%22 bgcolor=%22#ffffff%22>Log out the root user by typing %22exit%22 and hit the return key. Note that the admin user is returned.</td>\n", 
"</tr>\n", "</table>\n", "<br>\n", "<li> Be sure that you have typed %22exit%22 and you are now the admin user. Close Terminal.<br>\n", 
"<br>\n", "\n", "<li> Log out of Mac OS X (not shut down, only log out).<br>\n", "<br>\n", "\n", "<li> Log in as the %22webstar%22 user.<br>\n", 
"</ol>\n", "\n", "You can now use {PRODUCT_NAME} at the same time as running Webstar V.<br>\n", "<br>\n", 
"<h3>Log formats</h3>\n", "</font>When choosing log formats in WebStar V's %22Admin Client%22 for a specific website, use %22WebSTAR Log Format%22. Select all tokens and schedule WebStar V to archive log files once every day.<br>\n", 
"<br>\n", "In {PRODUCT_NAME}'s %22Quick Start%22 you will be asked where the log files are located. WebStar V always creates log files for each defined website in the %22logs%22 folder that is in the %22WS_Admin%22 folder for each website.<br>\n", 
"<br>\n", "\n", "{PRODUCT_NAME} will automatically choose %22WebSTAR Log format%22 and ONLY that format, if, and only if, the log is written correctly. If you experience that {PRODUCT_NAME} gives you other logfile formats to choose from (including the correct format), then there is an error. {PRODUCT_NAME} will only choose the correct logformat when the first line in the log file, in the first log file that you want to be processed by {PRODUCT_NAME}, has the correct log file header.<br>\n", 
"<br>\n", "<b>Solution<br>\n", "</b>If you experience this error do the following:<br>\n", "\n", "1. Open the first log file that is supposed to be processed by {PRODUCT_NAME}, in your favorite text editor on a MacOS X machine (this is important, since WebStar V log files now have file names that can be longer then 32 characters).<br>\n", 
"<br>\n", "\n", "2. Find the first instance of the following text and move your cursor  just before the text (with your date and time):<br>\n", 
"\n", "!!WebSTARSTARTUP 25/May/02 01:19:40<br>\n", "\n", "!!LOG_FORMAT BYTES_RECEIVED BYTES_SENT C-DNS.....<br>\n", 
"<br>\n", "\n", "3. Mark all text from before the text and to the top of the file and delete the marked text. The above text should  now be the very first text in the log. Save the file. Run %22Quick Start%22 again.<br>\n", 
"\"\n", 0 };

