//
// Sawmill Source Code
// 
// This source code is the intellectual property of Flowerfire,
// and is protected by federal trade secret laws.  Do not
// redistribute, modify, or use this source code, except to compile
// it, without the express written consent of Flowerfire.
//
// For more information, see http://www.sawmill.net/trade_secret.html
//
// The trial and full commercial licenses for Sawmill allow you
// to use the program, and to compile it from this source code,
// but you are not permitted to look at this source code.  Please
// do not attempt to use this source code for any purpose other 
// than compilation!



















































 
#include "sconfig.h"
 const char *S0f307a08ca796b18e17c7aaedf74d938[] = { "##\n", "## Language Module -- FAQ\n", "##\n", 
"## This is the FAQ section of the default English language module\n", "##\n", "\n", "DOCS_PAGE_TITLE_FAQ \"Frequently Asked Questions (FAQ)\"\n", 
"DOCS_PAGE_CONTENTS_FAQ \n", "\"\n", "<h3>Sections of the FAQ</h3>\n", "<ul>\n", "<li><a href=%22#LUTV%22> Licensing, Upgrading, and the Trial Version</a></li>\n", 
"<li><a href=%22#MF%22> Major Features</a></li>\n", "<li><a href=%22#IS%22> Installation and Setup</a></li>\n", 
"<li><a href=%22#LF%22> Log Filters</a></li>\n", "<li><a href=%22#ST%22> Statistics</a></li>\n", "<li><a href=%22#TS%22> Troubleshooting</a></li>\n", 
"<li><a href=%22#TS%22> Miscellaneous</a></li>\n", "</ul>\n", "<h3><a name=%22LUTV%22>Licensing, Upgrading, and the Trial Version</a></h3>\n", 
"<ul>\n", "  {FAQ:pricing}\n", 
#ifdef SAWMILL
 "  {FAQ:upgradepricing}\n", 
#endif
 "  {FAQ:largerlicenseupgrade}\n", "  {FAQ:trialdifference}\n", "  {FAQ:unlocktrial}\n", "  {FAQ:resettrial}\n", 
"  {FAQ:upgradingpreserving}\n", "</ul>\n", "\n", "<h3><a name=%22MF%22>Major Features</a></h3>\n", 
"<ul>\n", "  {FAQ:platforms}\n", "  {FAQ:systemrequirements}\n", "  {FAQ:logformats}\n", "  {FAQ:competitivecomparison}\n", 
"  {FAQ:typicalsetup}\n", "  {FAQ:largelogs}\n", "  {FAQ:logentryorder}\n", "</ul>\n", "\n", "<h3><a name=%22IS%22>Installation and Setup</h3></a>\n", 
"<ul>\n", "  {FAQ:logfiles}\n", "  {FAQ:scheduling}\n", "  {FAQ:differentip}\n", "  {FAQ:nodialup}\n", 
"  {FAQ:nonaccesslogs}\n", "  {FAQ:languagemodules}\n", "  {FAQ:runatstartup}\n", "  {FAQ:runinbackground}\n", 
"  {FAQ:schedulercgi}\n", "  {FAQ:ftplogsource}\n", "  {FAQ:commandlinelogsource}\n", "  {FAQ:windowsservice}\n", 
"  {FAQ:remoteadmin}\n", "  {FAQ:multiplesites}\n", "  {FAQ:gzippeddata}\n", "  {FAQ:clusteredservers}\n", 
"  {FAQ:clientsecurity}\n", "  {FAQ:relabeling}\n", "  {FAQ:regularexpressions}\n", "  {FAQ:regexpcase}\n", 
"  {FAQ:debuggingoutput}\n", "</ul>\n", "\n", "<h3><a name=%22LF%22>Log Filters</h3></a>\n", "<ul>\n", 
"  {FAQ:excludeip}\n", "  {FAQ:rejectspiders}\n", "  {FAQ:filteringdomain}\n", "  {FAQ:filteringdirectory}\n", 
"  {FAQ:contentgroups}\n", "  {FAQ:internalreferrers}\n", "  {FAQ:pageparameters}\n", "  {FAQ:recentstats}\n", 
"  {FAQ:combinereferrers}\n", "  {FAQ:commandlinefilter}\n", "  {FAQ:debuggingoutput}\n", "  {FAQ:dnslookup}\n", 
"  {FAQ:addingsearchengines}\n", "  {FAQ:changingtimezone}\n", "</ul>\n", "\n", "<h3><a name=%22ST%22>Statistics</a></h3>\n", 
"<ul>\n", "  {FAQ:datatypes}\n", "  {FAQ:dynamicurls}\n", "  {FAQ:parenthesizedomitted}\n", "  {FAQ:zoomfarther}\n", 
"  {FAQ:weeklystatistics}\n", "  {FAQ:uniquevisitors}\n", "  {FAQ:visitorcookies}\n", "  {FAQ:clickstream}\n", 
"  {FAQ:conversions}\n", "  {FAQ:topfieldsforfield}\n", "  {FAQ:sessionsforpage}\n", "  {FAQ:sessionsforusername}\n", 
"  {FAQ:enginesbyphrases}\n", "  {FAQ:sessionsforsearchengine}\n", "  {FAQ:daterange}\n", "  {FAQ:recentstats}\n", 
"  {FAQ:viewsbyemail}\n", "  {FAQ:exporttable}\n", "  {FAQ:accuracy}\n", "  {FAQ:apparentroot}\n", "  {FAQ:sessioncomputation}\n", 
"  {FAQ:visitorsvssessionhosts}\n", "  {FAQ:peakperiods}\n", "  {FAQ:timeofday}\n", "  {FAQ:exiturls}\n", 
"  {FAQ:hitfiles}\n", "  {FAQ:referrer404s}\n", "  {FAQ:robotstxt}\n", "  {FAQ:favicon}\n", "  {FAQ:statview}\n", 
"</ul>\n", "\n", "<h3><a name=%22TS%22>Troubleshooting</a></h3>\n", "<ul>\n", "  {FAQ:cantaccessserver}\n", 
"  {FAQ:mappeddrivewithservice}\n", "  {FAQ:memoryusage}\n", "  {FAQ:serverdown}\n", "  {FAQ:printingcolorslost}\n", 
"  {FAQ:winsock2}\n", "  {FAQ:oleaccdll}\n", "  {FAQ:urlmondll}\n", "  {FAQ:dynamiccasterror}\n", "  {FAQ:dnsproblems}\n", 
"  {FAQ:noimagescgi}\n", "  {FAQ:oldexpander}\n", "  {FAQ:iiscgitimeout}\n", "  {FAQ:resetpassword}\n", 
"  {FAQ:cgiuserpermissions}\n", "  {FAQ:resources}\n", "  {FAQ:periodicslowdowns}\n", "  {FAQ:macportlinger}\n", 
"  {FAQ:visitorsums}\n", "  {FAQ:missingdays}\n", "  {FAQ:netscapecrash}\n", "  {FAQ:hundredpercentcpu}\n", 
"  {FAQ:y2k}\n", "</ul>\n", "<h3><a name=%22MS%22>Miscellaneous</a></h3>\n", "<ul>\n", 
#ifdef SAWMILL
 "  {FAQ:sawmillname}\n", 
#endif
 "  {FAQ:frequentnewversions}\n", "</ul>\n", "\"\n", "\n", "\n", "FAQ_TITLE_parenthesizedomitted \"Parenthesized Items Omitted\"\n", 
"FAQ_QUESTION_parenthesizedomitted \n", "  \"There's a line above some of the tables in the statistics that says, \n", 
"  %22parenthesized items omitted.%22  What does that mean?\"\n", "FAQ_SHORT_ANSWER_parenthesizedomitted \n", 
"  \"It means that some items (probably useless ones) have been omitted from the table \n", "  to make the information more useful--you can show them by choosing \n", 
"  %22show parenthesized items%22 from the Options menu.\"\n", "FAQ_LONG_ANSWER_parenthesizedomitted \n", 
"\"{PRODUCT_NAME} omits parenthesized items (i.e. any item that starts with \n", "%22(%22 and ends with %22)%22 from some tables to make the information more \n", 
"useful.  For instance, most hits on a web site do not come directly from a search engine, \n", "(some come from links in other pages on the site, and others come from links on\n", 
"web sites that are not search engines), so usually the largest item in the search engines \n", "table would be on the item called %22(no search engine).%22  Because hits from non-search-engines \n", 
"are not important in the search engines table, and because they dominate the numbers, making \n", "it difficult to compare %22real%22 search engines, this item is omitted by default from the \n", 
"table.  The way {PRODUCT_NAME} omits it is by omitting all parenthesized items.  Other examples of \n", 
"parenthesized items include the %22(no search terms)%22 item in the search terms table, \n", "and the %22(internal referrer)%22 item in the referrers table.<p>\n", 
"If you want to see all the hits in these tables, choose %22show parenthesized items%22 \n", "from the Options menu.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_internalreferrers \"Eliminating Internal Referrers\"\n", "FAQ_QUESTION_internalreferrers \n", 
"  \"Most of the referrers listed in the %22Top referrers%22 view are from my own site.\n", "  Why is that, and how can I eliminate referrers from my own site from the statistics?\"\n", 
"FAQ_SHORT_ANSWER_internalreferrers \n", "  \"These are %22internal referrers%22; they represent visitors going from one page of your site \n", 
"  to another page of your site.  You can eliminate them by modifying the default %22(internal referrer)%22\n", 
"  log filter, changing http://www.mydomain.com/ in that filter to your web site URL.\"\n", "FAQ_LONG_ANSWER_internalreferrers \n", 
"\"Referrers show which page a hit came <i>from</i>--i.e. they show what page \n", "a visitor was on when they clicked the link that took them to your page.  \n", 
"For most web sites, visitors arrive and then click through several pages before \n", "leaving, so most web log data has a lot of referrers that are pages on the \n", 
"site being analyzed.  For instance, if someone visits http://www.yoursite.com/index.html, \n", "and then clicks on a link pointing to http://www.yoursite.com/page2.html, \n", 
"it will show up in the log data (and in the statistics) as a referrer \n", "http://www.yoursite.com/index.html.  These referrers are called an %22internal referrer,%22 \n", 
"and under normal circumstances, you don't really care about them-- what you really want \n", "to know is which referrers brought traffic to your site, not what the referrers were \n", 
"once they got there.<p>\n", "{PRODUCT_NAME} can't distinguish internal referrers from external referrers because it doesn't know \n", 
"your site's URL.  So it doesn't know if a referral from http://www.yoursite.com/index.html \n", "is internal (which it is if your site is yoursite.com), or external (which it is if your site \n", 
"is anything else).  To help {PRODUCT_NAME} identify and hide internal referrers, you need to \n", "modify a log filter that {PRODUCT_NAME} creates for you.  Here's how:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Find and edit (by clicking the blue triangle)\n", 
"       the log filter that replaces referrers starting with http://www.mydomain.com/ \n", "       with %22(internal referrer)%22.<p>\n", 
"  <li> Change http://www.mydomain.com/ so it matches your actual site.  For example, change it to \n", 
"       http://www.yoursite.com/ if that's the URL of your site.<p>\n", "  <li> Click the %22Back to Configuration Menu%22 button.<p>\n", 
"  <li> Click the %22Rebuild Database From Log Source%22 button.<p>\n", "</ol>\n", "Once you've done that, the internal referrers will be suppressed in the %22Top referrers%22\n", 
"view (or they will appear as %22(internal referrer)%22 if you've turned on parenthesized items).\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_trialdifference \"Difference Between Trial and Full\"\n", "FAQ_QUESTION_trialdifference\n", 
"  \"What's the difference between the full version of {PRODUCT_NAME} and the Trial version?\"\n", "FAQ_SHORT_ANSWER_trialdifference\n", 
"  \"The Trial version is identical to the full version, except that it shows red %22TRIAL VERSION%22 banners on \n", 
"  the statistics pages, and expires in 30 days.\"\n", "FAQ_LONG_ANSWER_trialdifference\n", "\"{PRODUCT_NAME} Trial is a free trial version, intended to let you evaluate the program without\n", 
"having to buy it.  It is identical to the full version, except that\n", "statistics generated with it include red %22TRIAL VERSION%22 banners at the top and bottom of the pages,\n", 
"and it expires\n", "30 days after it is downloaded.\n", "After the trial period is over, the trial version will no\n", 
"longer run.<p>\"\n", "\n", "\n", "\n", "FAQ_TITLE_largerlicenseupgrade \"Upgrading to a larger license\"\n", 
"FAQ_QUESTION_largerlicenseupgrade\n", "  \"How much does it cost to upgrade to a larger license, e.g. from a $99 Individual license\n", 
"  to a $399 Small Organization license?\"\n", "FAQ_SHORT_ANSWER_largerlicenseupgrade\n", "  \"It costs the difference; e.g. to upgrade from a $99 license to a $399 license costs $300.\"\n", 
"FAQ_LONG_ANSWER_largerlicenseupgrade\n", "\"If you've already purchased a license for {PRODUCT_NAME}, but now you need \n", 
"a larger license (for instance, if you purchased an Individual License, \n", "but now several people need to use it), you can upgrade for the difference in prices. \n", 
"So if you purchased an Individual License for $99, you can upgrade at any time to \n", "a Small Organization license (full price is $399) for $300, the difference in prices, \n", 
"$399 - $99.  Similarly, you can upgrade from a 200-customer ISP license ($399) \n", "to a 1000-customer ISP license ($999) for $600, which is $999 - $399.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_unlocktrial \"Unlocking a Trial Installation\"\n", "FAQ_QUESTION_unlocktrial\n", 
"  \"When I purchase, do I have to download a new version of {PRODUCT_NAME}, or can I %22unlock%22\n", 
"  my existing trial installation?\"\n", "FAQ_SHORT_ANSWER_unlocktrial\n", "  \"You can unlock your trial installation by entering your license key in the Licensing page.\"\n", 
"FAQ_LONG_ANSWER_unlocktrial\n", "  \"You don't have to download again. When you purchase, you get a license\n", 
"  key by email.  You can enter that key into the Licensing page (which you can get\n", "  to by clicking Licensing on the Administrative menu) to unlock a trial installation,\n", 
"  converting it into a full licensed installation.\"\n", "\n", "\n", "\n", "FAQ_TITLE_logfiles \"What is a Log File?\"\n", 
"FAQ_QUESTION_logfiles\n", "  \"What is a log file?\"\n", "FAQ_SHORT_ANSWER_logfiles\n", "  \"Log files are text files created by your server, recording each hit on your site. \n", 
"  {PRODUCT_NAME} generates its statistics by analyzing log files.\"\n", "FAQ_LONG_ANSWER_logfiles\n", 
"\"Log files are large, ugly text files generated by web servers, proxy server, ftp servers, \n", "and just about every other kind of server.  Every time something happens on the server \n", 
"(it serves a file, or someone logs in, or something else), the server logs that information \n", "to the file, which continues to grow as new events occur.  Log files are not particularly \n", 
"human-readable, and do not generally contain summarizing information, which is why {PRODUCT_NAME} exists-- \n", 
"{PRODUCT_NAME} processes your log files, summarizes them and analyzes them in many ways, and \n", "reports it back to you in a much friendlier format-- graphs, tables, etc.<p>\n", 
"You need to have access to your log files to use {PRODUCT_NAME}.  If you don't have log files, \n", 
"{PRODUCT_NAME} can't do anything for you.  If you don't know where your log files are, \n", "ask your server administrator (hint: they are often stored in a directory called %22logs%22).\n", 
"In some cases, servers are configured so they do not \n", "keep log files, or the logs are hidden from users; in these situations, you will not \n", 
"be able to use {PRODUCT_NAME}.  Again, your server administrator can help you find your log files, \n", 
"or they can tell you why they're not available.  If you're trying to analyze a web site, and your \n", 
"ISP does not provide logs for you, you may want to consider switching to one that does.<p>\n", "\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_platforms \"Available Platforms\"\n", "FAQ_QUESTION_platforms\n", "  \"What platforms does {PRODUCT_NAME} run on?\"\n", 
"FAQ_SHORT_ANSWER_platforms\n", "  \"Windows 95/98/ME/NT/2000/XP, MacOS, most versions of UNIX, OS/2, and BeOS.\"\n", 
"FAQ_LONG_ANSWER_platforms\n", "\"{PRODUCT_NAME} runs on Windows 95/98/ME/NT/2000/XP, MacOS 9 and X, and most popular flavors of UNIX\n", 
"(Linux for x86/Pentium, Linux for Alpha, Linux for PowerMac, Linux for MIPS, FreeBSD/OpenBSD/NetBSD,\n", 
"BSD/OS,\n", "SPARC Solaris,\n", "x86/Pentium Solaris,\n", "Compaq Tru64 UNIX (Digital UNIX), IRIX, HP/UX, AIX, OS/2, and BeOS).  And that's just\n", 
"the server; once you have the server running, you can configure {PRODUCT_NAME},\n", "generate statistics, and browse statistics from <b>any</b> computer,\n", 
"using a normal web browser.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_systemrequirements \"System Requirements\"\n", 
"FAQ_QUESTION_systemrequirements\n", "  \"How much memory, CPU power, and disk space do I need to run {PRODUCT_NAME}?\"\n", 
"FAQ_SHORT_ANSWER_systemrequirements\n", "  \"At least 64 Meg RAM, 128 Meg preferred; 200 Meg disk space for an average database; and as much CPU power as you can get.\"\n", 
"FAQ_LONG_ANSWER_systemrequirements\n", "\"{PRODUCT_NAME} is a heavy-duty number crunching program, and can use large amounts of \n", 
"memory, CPU, and disk.  You have some control over how much it uses of each, but \n", "it still requires a reasonably powerful computer to operate properly.<p>\n", 
"\n", "{PRODUCT_NAME} uses around 30 Meg of memory when it processes a small to medium size log file, \n", 
"and it can use considerably more for very large log files.  You have some control over its \n", "memory usage through the use of the configuration options, where you control how much memory \n", 
"{PRODUCT_NAME} is allowed to use for different tasks.  Even with minimum memory settings, it will use \n", 
"30 Meg; if you increase its memory allowances, log processing will speed up, but only to a point. \n", 
"Beyond 200 Meg, {PRODUCT_NAME} does not get much benefit from extra memory.<p>\n", "\n", "The {PRODUCT_NAME} installation itself takes less than 5 Meg of disk space, but the database it creates \n", 
"can take much more.  A small database may be only a couple megabytes, but if you turn on a lot of \n", 
"cross-references and ask for a lot of detail, there's no limit to how large the database can get. \n", 
"With the default settings, however, the database will not usually exceed 200 Meg, so if you budget yourself \n", 
"200 Meg for the database, you will almost certainly have enough disk space.  If you're planning to \n", 
"track multiple configurations (e.g. if you're an ISP), you'll need disk space for <i>each</i> database, \n", 
"one per customer, but don't worry--only very heavy use sites will use 200 Meg.  Most small sites will \n", 
"use just a few megabytes for the database.<p>\n", "\n", "Disk speed is something else to consider also when designing a system to run {PRODUCT_NAME}. \n", 
"During log processing, {PRODUCT_NAME} makes frequent use of the disk, and during statistics viewing \n", 
"it uses it even more.  A fast disk will increase {PRODUCT_NAME}'s log processing speed, and the responsiveness \n", 
"of the statistics.  SCSI is better than IDE, and SCSI RAID is best of all.<p>\n", "\n", "During log processing, the CPU is usually the bottleneck--{PRODUCT_NAME}'s number crunching takes\n", 
"more time than any other aspect of log processing, so the rest of the system ends up waiting on \n", 
"the CPU most of the time.  This means that any improvement in CPU speed will result in a <i>direct</i> \n", 
"improvement in log processing speed.  {PRODUCT_NAME} can run on any system, but the more CPU power you can give it, \n", 
"the better.  Large caches also significantly boost {PRODUCT_NAME}'s performance.<p>\n", "\"\n", "\n", 
"\n", "\n", "FAQ_TITLE_winsock2 \"Winsock 2\"\n", "FAQ_QUESTION_winsock2\n", "  \"When I run {PRODUCT_NAME} on Windows, I get an error: %22A required DLL is missing: WS2_32.DLL.%22\n", 
"  What's going on?\"\n", "FAQ_SHORT_ANSWER_winsock2\n", "  \"You need \n", "  <a href=http://www.microsoft.com/windows95/downloads/contents/WUAdminTools/S_WUNetworkingTools/W95Sockets2/Default.asp>Winsock 2</a>.\"\n", 
"FAQ_LONG_ANSWER_winsock2\n", "\"To run on Windows 95, and some early versions of Windows 98,\n", "{PRODUCT_NAME} requires Winsock2, a networking component available for free from Microsoft.\n", 
"You can download Winsock2 from \n", "<a href=http://www.microsoft.com/windows95/downloads/contents/WUAdminTools/S_WUNetworkingTools/W95Sockets2/Default.asp>here</a>.<p>\n", 
"Winsock2 is already part of Windows 98 (newer versions), Windows NT 4.0, and Windows 2000, so you do not\n", 
"need to download this component unless you are using Windows 95 or an old version of Windows 98.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_oleaccdll \"Missing DLL: OLEACC.DLL\"\n", "FAQ_QUESTION_oleaccdll\n", "  \"When I run {PRODUCT_NAME} on Windows 98, I get an error: %22A required DLL is missing: OLEACC.DLL.%22\n", 
"  What's going on?\"\n", "FAQ_SHORT_ANSWER_oleaccdll\n", "  \"You need to download an install the latest <a href=%22http://www.microsoft.com/windows98/downloads/%22>Service Pack</a> for Windows 98.\"\n", 
"FAQ_LONG_ANSWER_oleaccdll\n", "\"{PRODUCT_NAME} requires a DLL called OLEACC.DLL.  This DLL is part of recent versions of Windows 98,\n", 
"but it is not part of older versions of Windows 98.  If you're running an older Windows 98,\n", "you'll need to install the latest <a href=%22http://www.microsoft.com/windows98/downloads/%22>Service Pack</a>\n", 
"before you can run {PRODUCT_NAME}.  The service pack is a free download from Microsoft.<p>\n\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_dynamiccasterror \"Relocation error: __dynamic_cast_2\"\n", "FAQ_QUESTION_dynamiccasterror\n", 
"  \"When I try to run {PRODUCT_NAME}, I get an error %22relocation error: sawmill: undefined symbol: __dynamic_cast_2%22.  How can I fix this?\"\n", 
"FAQ_SHORT_ANSWER_dynamiccasterror\n", "  \"This is a GNU library incompatibility; build {PRODUCT_NAME} from source instead of using the binary distribution.\"\n", 
"FAQ_LONG_ANSWER_dynamiccasterror\n", "\"This occurs on UNIX systems, and is due to {PRODUCT_NAME} being build expecting a different version\n", 
"of the GNU libraries than the one you have on your system (libstdc++).  In other words, this is an\n", 
"operating system incompatibility-- we're building on a different version than you're running on.<p>\n", 
"The best solution is to use the %22encrypted source%22 version of {PRODUCT_NAME}, rather than\n", "the binary distribution for your platform; i.e. choose %22encrypted source%22 as the %22operating system%22\n", 
"when you're downloading {PRODUCT_NAME}.  This version requires that you have a C/C++ compiler installed\n", 
"on your system.  Follow the instructions to build {PRODUCT_NAME} from source-- it's easy.  The resulting\n", 
"binary will run properly on your system<p>\n", "If you don't have a compiler installed, please contact {SUPPORT_EMAIL}.\n" 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_urlmondll \"Missing DLL: URLMON.DLL\"\n", "FAQ_QUESTION_urlmondll\n", 
"  \"When I run {PRODUCT_NAME} on Windows, I get an error: %22A required DLL is missing: URLMON.DLL.%22\n", 
"  What's going on?\"\n", "FAQ_SHORT_ANSWER_urlmondll\n", "  \"Install the latest Internet Explorer, and the problem should go away.\"\n", 
"FAQ_LONG_ANSWER_urlmondll\n", "\"This DLL is part of Microsoft Internet Explorer.  It is also included in many recent versions of\n", 
"Windows.  If you see this error, download and install the latest\n", "<a href=%22http://www.microsoft.com/ie/%22>Internet Explorer</a>, and the problem should go away.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_dnsproblems \"Problems With DNS Lookup\"\n", "FAQ_QUESTION_dnsproblems\n", 
"  \"{PRODUCT_NAME} only shows me the IP addresses of my visitors, even when \n", "  I turn on DNS lookup.  Why?\"\n", 
"FAQ_SHORT_ANSWER_dnsproblems\n", "  \"Try deleting the IPNumbersCache file in the LogAnalysisInfo {DIRECTORY_WORD}-- see the long answer for other solutions.\"\n", 
"FAQ_LONG_ANSWER_dnsproblems\n", "\"(See [faq-dnslookup] for information about reverse DNS lookup).<p>\n", 
"\n", "There are several reasons that {PRODUCT_NAME} may not resolve IP addresses even when \n", "DNS lookup is turned on:<p>\n", 
"<ul>\n", "<li> <b>DNS server can't resolve the IPs</b>.  The DNS server you're using\n", "needs to know about the IPs you're resolving.  For instance, you can't use \n", 
"an external DNS server to resolve internal IP addresses, unless the external \n", "DNS server knows about them.  Try using an internal DNS server, or another DNS server, \n", 
"if the first DNS server you try can't seem to resolve the IPs. \n", "It's useful to manually query the DNS server to see if it can resolve a particular IP; \n", 
"on most operating systems, this can be done with the %22nslookup%22 command. \n", "Make sure you clear the cache every time you change DNS servers; see \n", 
"<b>Cached failed lookups</b>, below.<p></li>\n", "\n", "<li> <b>Cached failed lookups.</b></n>\n", 
"One possibility is that {PRODUCT_NAME} may have cached the failed DNS lookups.\n", "{PRODUCT_NAME} caches DNS lookups to improve performance. When it sees an IP\n", 
"address in the log data, and DNS lookup is turned on, it first checks\n", "the cache to see if it has looked this up before. If it finds it in\n", 
"the cache, it uses the cached value. If it does not find it in the\n", "cache, it looks it up using the specified DNS server, and stores the\n", 
"result in the cache. If the DNS server cannot resolve the IP address,\n", "{PRODUCT_NAME} stores that information in the cache, too, and does not\n", 
"attempt to resolve that IP address in the future.<p>\n", "\n", "In some cases, the problem is that the DNS server they originally\n", 
"tried to use could not resolve the IP addresses, or maybe it could be\n", "only when contacted via UPD. {PRODUCT_NAME} uses only TCP, and does not\n", 
"currently support UDP-only nameservers. So when the original build\n", "occurs, {PRODUCT_NAME} tries to look up all IP addresses, fails, and caches\n", 
"the failure. From then on, even after you began to use a TCP\n", "nameserver that can resolve the addresses, {PRODUCT_NAME} will look in the\n", 
"cache, and will not attempt the lookup with the actual nameserver, so\n", "no addresses will be resolved.<p>\n", 
"\n", "The solution is to clear the cache. This can be done by deleting the\n", "file IPNumbersCache, which is found in the LogAnalysisInfo {DIRECTORY_WORD},\n", 
"in your {PRODUCT_NAME} installation {DIRECTORY_WORD}. Once this cache file has been removed, the next build will\n", 
"look up all IP addresses using the DNS server.<p>\n", "</li>\n", "\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_noimagescgi \"No Images in CGI Mode\"\n", 
"FAQ_QUESTION_noimagescgi\n", "  \"I run {PRODUCT_NAME} in CGI mode, and all the images in the menus and the reports are missing or broken.  Why?\"\n", 
"FAQ_SHORT_ANSWER_noimagescgi\n", "  \"You may have set the %22temporary {DIRECTORY_WORD}%22 incorrectly during installation.  Try \n", 
"  deleting the DefaultConfig file in LogAnalysisInfo, and access {PRODUCT_NAME} to try again.\"\n", 
"FAQ_LONG_ANSWER_noimagescgi\n", "\"When {PRODUCT_NAME} runs as a CGI program, it includes images in its pages by creating them in a temporary \n", 
"{DIRECTORY_WORD} in the web server {DIRECTORY_WORD}, and then embedding links in the HTML so that \n", 
"the images it created are served by the web server.  This is done by selecting \n", "a %22temporary {DIRECTORY_WORD}%22 and %22temporary {DIRECTORY_WORD} URL%22 which point to a \n", 
"{DIRECTORY_WORD} inside the web server's root {DIRECTORY_WORD}.  They both point at the same \n", "{DIRECTORY_WORD}, but one of them is the pathname of the {DIRECTORY_WORD}, and one of them is \n", 
"the URL of the {DIRECTORY_WORD}.  These two must point at the same {DIRECTORY_WORD} for images \n", 
"to appear in the pages generated by {PRODUCT_NAME} in CGI mode.  If images are not appearing, \n", 
"it is usually because this is set incorrectly.<p>\n", "\n", "To correct the temporary {DIRECTORY_WORD}, delete the DefaultConfig file in the LogAnalysisInfo\n", 
"folder, and access {PRODUCT_NAME}.  You will be prompted to enter the pathname and URL of the \n", 
"temporary {DIRECTORY_WORD}.  Make sure you see the logo on the page after you enter the \n", "temporary {DIRECTORY_WORD}-- if the logo does not appear, click your browser's Back button and \n", 
"try again until you see the logo.  If the logo does not appear,\n", "no other images in the {PRODUCT_NAME} interface will either.<p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_cantaccessserver \"Can't Access the Server\"\n", "FAQ_QUESTION_cantaccessserver\n", 
"  \"When I run {PRODUCT_NAME}, it tells me that the server is started (it shows me the URL), \n", "  but when I try to access that URL, the browser says it's not available.  How can I fix this?\"\n", 
"FAQ_SHORT_ANSWER_cantaccessserver\n", "  \"You may be using a proxy server which prevents you from accessing a server \n", 
"  running on your own machine.  Try reconfiguring the proxy to allow it, \n", "  or try running {PRODUCT_NAME} on IP 127.0.0.1 (the loopback interface).\"\n", 
"FAQ_LONG_ANSWER_cantaccessserver\n", "\"When you first start {PRODUCT_NAME} in web server mode, it tries to start a web server, \n", 
"running on the local machine, using port 8987.  If this fails, it should give you \n", "an error message; if it succeed, it should give you a URL.  If you're seeing a URL \n", 
"when you start {PRODUCT_NAME}, it generally means that the {PRODUCT_NAME} server started successfully, \n", 
"and is ready to answer web browser requests.<p>\n", "Sometimes, though, when you actually try to access that URL, you may find that \n", 
"the server doesn't answer. Your browser may tell you that there's a DNS error, \n", "or that it couldn't contact the server, or that there's some other kind of error. \n", 
"If {PRODUCT_NAME} displayed a URL, the server itself is probably working fine-- the problem \n", "is not with the server, but with the network connection to the server.  \n", 
"This can happen, for instance, if you're using a web server proxy or cache server, \n", "and it doesn't know about the IP address of your own machine.  When you contact \n", 
"the cache and ask to connect to your own machine, it gets confused, because normal \n", "web requests come from inside machines contacting <i>outside</i> machines, and this one is \n", 
"an inside machine contacting another inside machine (itself).  A well-configured proxy server \n", 
"can handle this, but one that is not configured to handle internal requests may \n", "attempt to get the URL from the outside, and may give an error when it doesn't find it there. \n", 
"Some proxies/caches/firewalls will also refuse to let through traffic on port 8987 ({PRODUCT_NAME}'s \n", 
"default port), regardless of other settings.<p>\n", "There are several solutions.  One choice is to reconfigure the proxy or cache server to \n", 
"allow HTTP connections from internal machines to other internal machines, on port 8987. \n", "Then {PRODUCT_NAME} will be able to operate in its preferred mode, on port 8987 of the machine's \n", 
"first IP address.<p>\n", "If that's not an option, you may be able to get {PRODUCT_NAME} to work by running it on \n", 
"the loopback interface (IP 127.0.0.1), or on port 80 (the standard web server port). \n", "The easiest way to find a working solution is to use the command-line interface to {PRODUCT_NAME}, \n", 
"at least until you have it working; you can go back to using the graphical version later.\n", "From the command line, run {PRODUCT_NAME} like this:<p>\n", 
"<pre>  {PRODUCT_EXECUTABLE_DOCS} -ws t -sh 127.0.0.1 -wsp 80</pre>\n", "This will attempt to start {PRODUCT_NAME}'s web server on IP 127.0.01 (the loopback interface), \n", 
"using port 80.  This will only work if there is not a web server already running on the system-- \n", 
"only one server can use port 80 at a time.  If you already have a web server running, \n", "use port 8987 instead.  Try the command above with different IP addresses (127.0.0.1, and \n", 
"any IP addresses you know belong to your computer), and different ports (try 8987 first, \n", "then 80).  With a little luck one of the choices will start a server that you can connect to.\n", 
"Once you've got the {PRODUCT_NAME} interface working in your web browser, you can set it \n", "to use that IP and port permanently in the Preferences, from the Administrative Menu.  \n", 
"Once you've set the IP and port in the Preferences, you can quit the command-line {PRODUCT_NAME}, and start using the \n", 
"graphical version, if you prefer.<p>\n", "If that still doesn't work, check if there is a firewall on your system or on your network, \n", 
"which is blocking traffic from your machine to itself, on port 8987.  If there is, \n", "try disabling the firewall temporarily (or reconfigure it to allow the traffic), \n", 
"and see if it works then.  If it works with the \n", "firewall disabled, and doesn't work with the firewall enabled, then the firewall is \n", 
"probably blocking the necessary traffic.  You'll probably want to reconfigure the firewall \n", "to let the network traffic through on 8987.<p>\n", 
"If none of these work, and you have a web server running on your system \n", "there is always CGI mode.  {PRODUCT_NAME} can run under any running web server in CGI mode; \n", 
"if you can connect to the web server itself, you'll be able to use {PRODUCT_NAME} by running \n", "{PRODUCT_NAME} under your local server as a CGI program.<p>\n", 
"Finally, if you can't get {PRODUCT_NAME} to work to your satisfaction, please contact\n", "<a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a>.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_mappeddrivewithservice \"Can't See Network Drives with {PRODUCT_NAME} as Service\"\n", 
"FAQ_QUESTION_mappeddrivewithservice\n", "  \"Why can't {PRODUCT_NAME} see my mapped drive, share, directory, or mount points when I run it as a Windows Service?\"\n", 
"FAQ_SHORT_ANSWER_mappeddrivewithservice\n", "  \"The Service must run with the same privileged user account that has the mapped drive,\n", 
"  share, directory, or mount point privilege.\"\n", "FAQ_LONG_ANSWER_mappeddrivewithservice\n", "\"</p>The mapped drive, share, directory, or mount point is a permission\n", 
"issue that involves security.  It is therefore necessary to have the\n", "service run using that same privileged account that the drive\n", 
"was originally mapped from, or an account which has permissions to access the share, etc.\n", "If the service cannot connect as the same user that has the privilege,\n", 
"the network resource will not be available.</p>\n", "\n", "<p>Here is a step-by-step walkthrough on how to change the service logon permission:</p>\n", 
"<ol>\n", "<li><p> Go to Control Panel</p></li>\n", "<li><p> Open up Services (location varies slightly with particular OS version)</p></li>\n", 
"<li><p> Find the FireDaemon Service entry (or the entry for the service running which is being used to run {PRODUCT_NAME}\n", 
"     and right mouse click it.</p></li>\n", "<li><p> Select Properties</p></li>\n", "<li><p> Under the 'Log On' tab deselect the 'Local System Account' radio button by selecting\n", 
"     'This account' and hit the browse button</p></li>\n", "<li><p> In the 'Select User' dialog box, you may type in the privileged user's UserID or you may also browse for it.\n", 
"     Once you have selected the correct user, click the OK button and the 'This account'\n", "     field will be populated by a period, then a back slash (\\) then the users' ID</p></li>\n", 
"<li><p> Enter the privileged user's password twice. This will show up as asterisks.\n" "     This is for security reasons and by design</p></li>\n", 
"<li><p> Back at the Control Panel properties for the FireDaemon Service entry,\n", "     right mouse click and select the 'restart' option.</p></li> \n", 
"<li><p> When you next run {PRODUCT_NAME}, access to the mapped drive, share, directory, or mount point will be available</p></li>.\n", 
"</ol>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_memoryusage \"{PRODUCT_NAME} uses too much memory for builds/updates, and is slow to view\"\n", 
"FAQ_QUESTION_memoryusage\n", "  \"When I build or update my database with {PRODUCT_NAME}, it uses a huge amount of memory.\n", 
"  Then, when I view statistics, it's very slow.  What can I do about that?\"\n", "FAQ_SHORT_ANSWER_memoryusage\n", 
"  \"Increase the number of database segments, or decrease the complexity of the database.\"\n", "FAQ_LONG_ANSWER_memoryusage\n", 
"\"There are two major parts of the database that can use a lot of memory: the indices and\n", "the data itself.  The first thing to do is to determine which one is the culprit in your\n", 
"case.  You can do this by looking at the files and folders in your database {DIRECTORY_WORD}.\n", "The database {DIRECTORY_WORD} is in the Databases {DIRECTORY_WORD} of the LogAnalysisInfo\n", 
"{DIRECTORY_WORD}, in your {PRODUCT_NAME} installation.  The name of the {DIRECTORY_WORD}\n", "is the same as the name of your configuration.  In that {DIRECTORY_WORD}, there are several\n", 
"files called <code>items_dbfield<i>N</i></code> and <code>hierarchy_dbfield<i>N</i></code>,\n", "which are the index files.  There are also {PLURALIZE:{DIRECTORY_WORD}} called\n", 
"<code>hits_xrefgroup<i>N</i></code>, which contain the database data.<p>\n", "\n", "First, check if the database data is using the memory, by looking in the <code>hits_xrefgroup<i>N</i></code>\n", 
"folders to find the largest file.  During database builds and updates, {PRODUCT_NAME} loads the entire contents of\n", 
"these files into memory, so if one of them is 800 Meg, {PRODUCT_NAME} will need at least 800 Meg of memory to\n", 
"update that database.  If your database segments are too large for your available memory, increase the\n", 
"number of database segments, in the Database Params tab of the Configuration Options, and rebuild your\n", 
"database.  That will distribute the data across more segments, so each will be smaller and won't require\n", 
"as much memory.<p>\n", "\n", "Secondly, check if the database indices are using too much memory, by looking at the sizes of the\n", 
"<code>items_dbfield<i>N</i></code> and <code>hierarchy_dbfield<i>N</i></code> files.  Whenever\n", 
"{PRODUCT_NAME} uses this database (even for viewing), it needs to load <i>all</i> of these files\n", 
"into memory.  For very large databases, that can be a problem, because these files can become several\n", 
"hundred megabytes in size.  Solving a memory usage problem caused by large indices isn't as easy as solving\n", 
"one caused by data (above)-- the only solutions are to get more memory, or track less information.\n", 
"getting more memory solves it by letting {PRODUCT_NAME} hold the large indices in memory.<p>\n", "\n", 
"If increasing your memory isn't\n", "not an option, or if the performance of the database is more of a concern than the memory usage\n", 
"(even if you have plenty of memory, it takes a long time to load in 2 Gig of indices), you'll need\n", 
"to simplify your database fields.  First, find which fields are using the most memory, by finding the\n", 
"largest index files and looking at the numbers at the end of the filename.  These numbers are the \n", 
"database field number, starting with 0, so file 0 is the first database field, 1 is the second, and\n", 
"so on.  The order of database fields can be seen in the Database Fields tab of the Configuration \n", 
"Options, or in the configuration file.  For instance, if <code>items_dbfield5</code> is the largest\n", 
"file, at 500 Meg, then you know that the sixth database field is responsible for the largest part\n", 
"of the memory usage.<p>\n", "\n", "When you've found the culprit, you need to reduce its memory usage.  This is where you'll have to\n", 
"make compromises and cuts.  The simplest solution is to delete the database field, and stop tracking\n", 
"and reporting on it.  If that's not an option, you'll need to simplify the field in some way.\n", "The key point here is that you are trying to reduce the number of unique field values that {PRODUCT_NAME}\n", 
"sees and tracks.  The <code>items</code> file, which is usually the largest one, contains a back-to-back\n", 
"list of all field values that are used in the database,\n", "and very little else; if you can reduce the number of possible field values\n", 
"used by {PRODUCT_NAME}, you will reduce the size of the file.<p>\n", "\n", "If the field is a hierarchical (like a pathname, hostname, date/time,\n", 
"or URL), you can simplify it by tracking fewer levels, by adjusting the %22suppress top%22 and\n", 
"%22suppress bottom%22 values in the Database Fields tab of the Configuration Options.  For instance,\n", 
"the page field of web logs is tracked nine directories deep by default; you can simplify it by \n", 
"tracking only the top three levels directories.  If your date/time field is set to track information\n", 
"to the level of minutes, you can change it back to tracking hours or days only.  Usually, you will want\n", 
"to turn off bottom-level items checkbox for the field, since it's usually the bottom level that has\n", 
"all the detail.<p>\n", "\n", "Another possibility is to use a Log Filter to simplify the field.  The default filter for web logs\n", 
"which replaces everything after ? with %22(parameters)%22 is an example of this.  By replacing all\n", 
"the various parameterized versions of a URL with a single version, this filter dramatically decreases\n", 
"the number of different page field values that {PRODUCT_NAME} sees, therefore dramatically decreasing\n", 
"the memory usage of the %22page%22 field.  Similarly, if you have a very complex section of your\n", 
"directory structure, but you don't really need to know all the details, you can use a Log Filter\n", 
"to delete the details from your field, collapsing the entire structure into a few items.<p>\n", "\n", 
"A common source of high memory usage is a fully-tracked hostname/IP field.  By default, {PRODUCT_NAME}\n", 
"tracks only the first two levels of hostnames for web and proxy logs; i.e. it will tell you that a\n", 
"hit came from .sawmill.net, but not that it came from some.machine.sawmill.net.  Because of the \n", 
"tremendous number of IP addresses that appear in large log files, this field can be a problem if\n", 
"it's set to track individual IPs (there's a checkmark that lets you do this when you create the\n", 
"configuration).  If this is happening, consider tracking only a few levels of the hostname hierarchy,\n", 
"instead of the full IP address.<p>\n", "\n", "Of course, sometimes you really need the full detail you're tracking in a very large field.\n" 
"If you can't reduce the detail, and you can't reduce the amount of log data, then the only solution\n", 
"is to get enough memory and processing power to efficiently handle the data you're asking \n", "{PRODUCT_NAME} to track.<p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_oldexpander \"Corrupt Mac Download\"\n", "FAQ_QUESTION_oldexpander\n", 
"  \"I downloaded the Mac version of {PRODUCT_NAME}, but I got a message\n", "  saying that the download is corrupt.  What's going on?\"\n", 
"FAQ_SHORT_ANSWER_oldexpander\n", "  \"You need a new version of <a href=http://www.aladdinsys.com/expander/>Aladdin StuffIt Expander</a>,\n", 
"  or you need to run the .sea file yourself.\"\n", "FAQ_LONG_ANSWER_oldexpander\n", "\"The download is not corrupt, but it was compressed using a recent version of\n", 
"<a href=http://www.aladdinsys.com/expander/>Aladdin StuffIt Expander</a>.\n", "If you have an old version of Expander, it will not understand the format used\n", 
"by the new version, and it will claim (incorrectly) that the archive is corrupt.<p>\n", "You may want to consider upgrading to the latest version of Expander.  It's free,\n", 
"and once you've upgraded, you'll be able to decode {PRODUCT_NAME} and other downloads\n", "without getting this error.  You can upgrade <a href=http://www.aladdinsys.com/expander/>here</a>.<p>\n", 
"A quicker solution is to let your current Expander decode the first step (decode the .hqx\n", "encoding), and then do the second step yourself (uncompress and install {PRODUCT_NAME}) by double-clicking the .sea file.\n", 
"The .sea file is a self-extracting archive, so it does not need a recent version of\n", "Expander to install itself.\"\n", 
"\n", "\n", "\n", "\n", "FAQ_TITLE_iiscgitimeout \"IIS CGI Timeout\"\n", "FAQ_QUESTION_iiscgitimeout\n", 
"  \"When I run {PRODUCT_NAME} as a CGI program under IIS, I get an error message %22CGI Timeout: \n", 
"  The specified CGI application exceeded the allowed time for processing. The server has deleted the process.%22\n", 
"  What can I do about that?\"\n", "FAQ_SHORT_ANSWER_iiscgitimeout\n", "  \"Set the IIS CGI timeout to a high value, like 999999.\"\n", 
"FAQ_LONG_ANSWER_iiscgitimeout\n", "\"Microsoft Internet Information Server (IIS) automatically terminates CGI programs that\n", 
"run for more than five minutes.  Unfortunately, {PRODUCT_NAME} can easily use that much\n", "when building a database, and if IIS terminates it, it may leave the database partly built and unusable.\n", 
"The solution is to reconfigure the IIS server to\n", "increase the CGI timeout to a much larger value.  Here's how (instructions are for Windows 2000 Server;\n", 
"other Windows variants may be slightly different):<p>\n", "<ol>\n", "  <li> In the Start Menu, go the Settings menu, and choose Control Panels.<p>\n", 
"  <li> Open the Administrative Tools control panel.<p>\n", "  <li> Open the Internet Services Manager item.<p>\n", 
"  <li> Right-click on the computer icon in the left panel and choose Properties from the menu that appears.<p>\n", 
"  <li> Click %22Edit...%22 next to %22WWW Services%22.<p>\n", "  <li> Click the %22Home Directory%22 tab.<p>\n", 
"  <li> Click the %22Configuration...%22 button.<p>\n", "  <li> Click the %22Process Options%22 tab.<p>\n", 
"  <li> Enter a large value in the CGI script timeout field, perhaps 999999.<p>\n", "</ol>\"\n", "\n", 
"\n", "\n", "\n", "FAQ_TITLE_differentip \"Running on a Different IP\"\n", "FAQ_QUESTION_differentip\n", 
"  \"I'm running {PRODUCT_NAME} on Windows, and it automatically starts itself up\n", "  on IP 127.0.0.1 and port 8987.  How can I tell it to use another IP address and port?\"\n", 
"FAQ_SHORT_ANSWER_differentip\n", "  \"Click Advanced Options in the {PRODUCT_NAME} window and choose the IP address from the menu,\n", 
"  or set the Server Hostname option and the Web Server Port option\n", "  in the Network section of the Preferences.\"\n", 
"FAQ_LONG_ANSWER_differentip\n", "\"If you just need to change the IP address for the current run of {PRODUCT_NAME},\n", 
"you can click the Advanced Options checkbox in the {PRODUCT_NAME} window\n", "(not the browser window), and then choose the IP address you want from the IP Address menu.<p>\n", 
"\n", "If you want the change to be permanent, so it always runs on that IP,\n", "open the Preferences, clicking on the Network button,\n", 
"changing the %22Server hostname%22 option to the IP address you want to use,\n", "and changing the %22Web server port%22 option to the port number you want to use.\n", 
"The next time you start {PRODUCT_NAME}, it will automatically start on the IP\n", "address you specified.<p>\n", 
"\n", "If you're using the command-line version of {PRODUCT_NAME} ({PRODUCT_NAME}6CL.exe),\n", "you can either do the same as above, or you can give {PRODUCT_NAME} command\n", 
"line options to tell it which IP number and port to use:<p>\n", "<pre>  {PRODUCT_NAME}6CL.exe -sh 128.129.130.131 -wsp 8888</pre>\n", 
"When you use these options, {PRODUCT_NAME} will immediately\n", "start up its web server on the port you specify.\"\n", 
"\n", "FAQ_TITLE_windowsservice \"Running {PRODUCT_NAME} as a Service\"\n", "FAQ_QUESTION_windowsservice\n", 
"  \"Can I run {PRODUCT_NAME} as a Service on Windows?  Can I run {PRODUCT_NAME} while I'm logged out?\"\n", 
"FAQ_SHORT_ANSWER_windowsservice\n", "  \"Yes, with third-party software like <a href=%22http://www.firedaemon.com/%22>FireRunner</a> (freeware)\n", 
"  or Microsoft's \n", "  <a href=%22http://www.microsoft.com/technet/prodtechnol/winntas/reskit/reskit.asp%22>Windows Resource Kit</a>.\"\n", 
"FAQ_LONG_ANSWER_windowsservice\n", "\"You can run {PRODUCT_NAME} as a Service by using a third-party utility that\n", 
"lets you run <i>any</i> program as a service.\n", "One good option is <a href=%22http://www.firedaemon.com/%22>FireRunner</a> (it's free!).<p>\n", 
"Another option is Microsoft's commercial\n", "<a href=%22http://www.microsoft.com/technet/prodtechnol/winntas/reskit/reskit.asp%22>Windows Resource Kit</a>.\n", 
"Use the <code>srvany.exe</code> component to run {PRODUCT_NAME} as a service.<p>\n", "A third option is NTRunner, but the link we used to have to that doesn't seem to work anymore--\n", 
"NTRunner may have been discontinued.<p>\n", "When running {PRODUCT_NAME} as a service, it is best (and sometimes required, as with srvany.exe) to \n", 
"run the {PRODUCT_NAME}6CL.exe program, rather than the {PRODUCT_NAME}6.exe one.<p>\"\n", "\n", "\n", 
"\n", "FAQ_TITLE_remoteadmin \"Remote Administration\"\n", "FAQ_QUESTION_remoteadmin\n", "  \"My web site is hosted in another state. Does {PRODUCT_NAME} provide browser\n", 
"  based admin tools I can use to configure it and retrieve reports?\"\n", "FAQ_SHORT_ANSWER_remoteadmin\n", 
"  \"Yes, {PRODUCT_NAME}'s interface is entirely browser based.\"\n", "FAQ_LONG_ANSWER_remoteadmin\n", 
"\"{PRODUCT_NAME}'s interface is entirely web browser based.\n", "{PRODUCT_NAME} runs either as a stand-alone program (in which case it uses its own built-in web server\n", 
"to serve its interface), or as a CGI program (in which case it uses the normal web server on the\n", 
"machine).  In either case, {PRODUCT_NAME} is configured by running a web browser on any machine you choose,\n", 
"and accessing {PRODUCT_NAME} as though it were a web site.  Statistics are also served \n", "through a web browser interface.\n", 
"You do not need to be physically present\n", "at the server to configure it or to view statistics; all you need is a web browser.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_resettrial \"Resetting the Trial Period\"\n", "FAQ_QUESTION_resettrial\n", 
"  \"My 30-day trial has expired, and I haven't finished evaluating {PRODUCT_NAME} yet.  How can I get a new trial?\"\n", 
"FAQ_SHORT_ANSWER_resettrial\n", "  \"Go to the Licensing page, delete your expired license, and click %22Try {PRODUCT_NAME} For 30 Days.%22\"\n", 
"FAQ_LONG_ANSWER_resettrial\n", "\"{PRODUCT_NAME}'s trial license allows you to use it for evaluation purposes only.\n", 
"However, if after 30 days you still have not had a chance to fully evaluate {PRODUCT_NAME}, \n", "you can extend your trial for another 30 days by doing the following:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Click the Licensing button.<p>\n", "  <li> Click the Delete button next to your current trial license.<p>\n", 
"  <li> Click the %22Try {PRODUCT_NAME} for 30 Days%22 button.<p>\n", "</ol>\"\n", "\n", "\n", "\n", 
"FAQ_TITLE_resetpassword \"Resetting the Administrative Password\"\n", "FAQ_QUESTION_resetpassword\n", 
"  \"I've forgotten the password I chose for {PRODUCT_NAME} when I first installed; how can I reset it?\"\n", 
"FAQ_SHORT_ANSWER_resetpassword\n", "  \"Delete the AdminPassword file in the LogAnalysisInfo folder/directory of your installation.\"\n", 
"FAQ_LONG_ANSWER_resetpassword\n", "\"For security reasons, {PRODUCT_NAME} requires a password whenever you use it\n", 
"(otherwise, anyone could use it to access your computer, since it is normally\n", "accessible by anyone on your network).\n", 
"You choose this password when you first run {PRODUCT_NAME}, and it asks you for it whenever you\n", 
"run it again.\n", "If you forget the password you originally chose, you can reset your password by deleting\n", 
"the AdminPassword file, which you will find in the LogAnalysisInfo directory/folder of your\n", "{PRODUCT_NAME} installation directory/folder.  Once you have deleted AdminPassword, access\n", 
"{PRODUCT_NAME} again through a web browser, and you will be prompted to choose a new password.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_y2k \"Year 2000 Compatibility\"\n", "FAQ_QUESTION_y2k\n", "  \"Is {PRODUCT_NAME} Year 2000 Compatible?\"\n", 
"FAQ_SHORT_ANSWER_y2k\n", "  \"Yes.\"\n", "FAQ_LONG_ANSWER_y2k\n", "\"{PRODUCT_NAME} uses an internal date/time format that will continue to work properly well beyond the\n", 
"year 2000, so for all of its normal operations, there will be no problem.\n", "{PRODUCT_NAME} supports some log formats that use two-digit dates; in these\n", 
"cases, {PRODUCT_NAME} assumes years 70-99 to be 1970-1999, and years\n", "00-69 to be 2000-2069.  So even with Y2K-incompatible log formats,\n", 
"{PRODUCT_NAME} will work properly as long as your log data does not extend\n", "before 1970, or beyond 2069.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_typicalsetup \"Typical Usage Patterns\"\n", "FAQ_QUESTION_typicalsetup\n", 
"  \"How does a typical company use {PRODUCT_NAME}; what does a typical {PRODUCT_NAME} setup look like?\"\n", 
"FAQ_SHORT_ANSWER_typicalsetup\n", "  \"Installations vary from customer to customer--{PRODUCT_NAME} provides\n", 
"  enough flexibility to let you choose the model that works best for you.\"\n", "FAQ_LONG_ANSWER_typicalsetup\n", 
"\"There are quite a lot of different %22models%22 that\n", "different customers use.  It is common to have {PRODUCT_NAME} running on the active web server,\n", 
"either stand-alone or in web server mode, accessing the growing log files directly.\n", "However, some customers have dedicated {PRODUCT_NAME} machines, which pull the logs over the network\n", 
"from the server(s).  Databases are generally rebuilt or updated regularly; it's common\n", "to have them updated in the middle of the night, every night, using the {PRODUCT_NAME} Scheduler\n", 
"or an external scheduler like cron.  Sometimes {PRODUCT_NAME}'s auto-update feature is used to\n", 
"update the databases when they are accessed, eliminating the need for regular updates.<p>\n", "In terms of the database layout, some common models include:\n", 
"<ul>\n", "  <li> <b>A single database</b>.  Most customers use a single large database that contains\n", 
"       all their data.  This works well if you have a lot of disk space and a\n", "       fast computer to process your logs with.  You can use {PRODUCT_NAME}'s normal\n", 
"       field limit features to zoom in on particular parts of the data, but it's\n", "       all stored in a single database.  {PRODUCT_NAME} has other features that can be\n", 
"       used to limit certain users to certain parts of the database; this is particularly\n", "       useful for ISPs who want to store all their customers' statistics in a single\n", 
"       large database, but only let each customer access their own statistics.<p>\n", " \n", "  <li> <b>A %22recent%22 database and a long-term database</b>.\n", 
"       In cases where log data is fairly large (say, more than 1 Gigabyte), or where disk space and/or\n", 
"       processing power is limited, some customers use two databases,\n", "       one in detail for the recent data (updated and expired regularly to keep a moving 30-day data set, for instance),\n", 
"       and the other less detailed for the long-term data (updated regularly but never expired).\n", 
"       That provides less overall information (so it takes less time to process the logs,\n", "       and to browse the database, and the two databases combined are much smaller than a single one would be),\n", 
"       but often is acceptable because fine detail is needed only for recent data.<p>\n", "\n", "  <li> <b>A collection of specialized databases</b>. Some customers use a\n", 
"       collection of databases, one for each section of their statistics.\n", "       This is particularly useful for multi-gigabyte log data; a tightly-focused database\n", 
"       (for instance, showing only hits on the past seven days on a particular directory of\n", "       the site) is <i>much</i> smaller and faster than a large all-encompassing database.\n", 
"       This is also useful if several log files of different types are being analyzed\n", "       (for instance, an ISP might have one database to track bandwidth usage by its customers,\n", 
"       another to track internal network traffic, another to track usage on its FTP site,\n", "       and another to track hits on its own web site).<p>\n", 
"</ul>\n", "There are a lot\n", "of options, and there's no single best solution.  You can try out\n", 
"different methods, and change them if they're not working for you.  \n", "{PRODUCT_NAME} provides you the flexibility to choose whatever's best for you.\"\n", 
"\n", "\n", "\n", "\n", "FAQ_TITLE_competitivecomparison \"{PRODUCT_NAME} vs. The Competition\"\n", 
"FAQ_QUESTION_competitivecomparison\n", "  \"How is {PRODUCT_NAME} different from other log analysis tools?\"\n", 
"FAQ_SHORT_ANSWER_competitivecomparison\n", "  \"Among other things, {PRODUCT_NAME} does not generate static %22reports%22--it\n", 
"  generates dynamic interlinked statistics pages.\"\n", "FAQ_LONG_ANSWER_competitivecomparison\n", 
"\"There are many areas in which {PRODUCT_NAME} beats the competition, but one \n", "major one is that {PRODUCT_NAME}'s statistics are <b>dynamic</b>, and its statistics pages are <b>interlinked</b>.\n", 
"Most other log analysis programs\n", "are report-based--you specify certain criteria (like, %22give me all hits on\n", 
"my web site on January 14, broken down by page%22) and it generates a single report,\n", "and it's done.\n", 
"{PRODUCT_NAME} generates an HTML page where many of the items are links.\n", "Clicking any link will take you to another similar page, but with a slightly different\n", 
"view of the statistics.  You might click on a certain directory,\n", "for instance, to see the same information broken down by the files in that directory.\n", 
"Or you might click a certain subnet (%22.com%22) to see a breakdown by subnets of that\n", "subnet (like %22.flowerfire.com%22).  {PRODUCT_NAME} lets you navigate naturally\n", 
"and quickly through interlinked hierarchies like pages/directories, day/month/years,\n", "machine/subnets, URLs, and others.\n", 
"Of course, there are many other features that set {PRODUCT_NAME} apart from the competition-- see \n", 
"our web site for a complete list.<p>\"\n", "\n", "\n", "\n", "\n", "FAQ_TITLE_multiplesites \"Statistics for Multiple Sites\"\n", 
"FAQ_QUESTION_multiplesites\n", "  \"Can {PRODUCT_NAME} generate separate analyses for all the web sites hosted on my server?\"\n", 
"FAQ_SHORT_ANSWER_multiplesites\n", "  \"Yes, {PRODUCT_NAME} includes a number of features for just this purpose.\"\n", 
"FAQ_LONG_ANSWER_multiplesites\n", "\"Absolutely.  This is one of our core design goals--to make {PRODUCT_NAME} a good choice\n", 
"for Internet Service Providers and others who serve multiple sites from a single\n", "server.  {PRODUCT_NAME}'s configurations provide an excellent mechanism for generating\n", 
"different statistics for each customer or web site.\n", "If each site has its own log file(s), this is trivial; you can just make a configuration\n", 
"that analyzes the appropriate log file.  If all sites share a single log file, it's\n", "not much harder--{PRODUCT_NAME}'s advanced filtering mechanism lets you easily ignore all\n", 
"log entries except those of interest to a particular web site.<p>\n", "\n", "Which technique you use depends on your situation.  In general, you will need to have a \n", 
"separate configuration for each user (you can quickly create all of your configurations \n", "using the Create/Update Many Configurations option in the Administrative menu).\n", 
"For maximum flexibility, each configuration can have its own database, and each \n", "configuration can be password-protected or secured in some other way, to prevent \n", 
"unauthorized users from accessing it.  See [docs-security] for a discussion of \n", "some of the ways configurations can be secured.  If each configuration has its own \n", 
"database, then the log filters can be used to filter out all statistics except those \n", "belonging to the user.<p>\n", 
"\n", "In some cases, it may be preferable to share a single large database among many users. \n", "This makes database updates faster, because only a single database has to be updated. \n", 
"The [asr] option can be used to limit each user to their own section of the statistics.\n", "If you don't even care if users can access each others' statistics, you can use a single \n", 
"configuration with a single database, and give each user a bookmark URL pointing to \n", "their statistics in the database; this is the simplest approach, but it makes it possible for \n", 
"one user to see another's statistics, which is usually undesirable.  See [faq-apparentroot]\n", "for more details on how to do this.<p>\n", 
"Advantages of using a single database:<p>\n", "<ul>\n", "  <li> Faster log processing-- log data is read only once.  This is particular important \n", 
"       when using an FTP log source, because the log data will be fetched once per configuration, \n", 
"       so if you have 1000 configurations, this will use 1000 times more bandwidth. \n", "       For local log files, this is not much of an issue, because {PRODUCT_NAME} skips quickly over \n", 
"       log entries it doesn't need, so it will only be spending real time on each log entry once.<p>\n", 
"</ul>\n", "Advantages of using multiple databases:<p>\n", "<ul>\n", "  <li> Session information available.  Because session views (paths through the site, \n", 
"       entry pages, exit pages, time per page, session overview) only permit filters on \n", "       the page or date/time fields, you cannot show per-site session statistics in a \n", 
"       single database if you're using a %22server domain%22 filter in the apparent root. \n", "       This generally means that you can't provide session statistics in a shared database. \n", 
"       It is possible to work around this by adding the domain name as a suffix on the page field, \n", 
"       and then using a page field filter to split the database.<p>\n", "  <li> Smaller databases.  Though {PRODUCT_NAME} has to create many databases instead of one, \n", 
"       generally the total disk usage will be smaller, because each database is tightly \n", "       focused on its site, and does not need to keep around information that applies \n", 
"       only to other sites.  We saw one example where the total database size shrunk by \n", "       a factor of 200 when the customer switched from one database to many.<p>\n", 
"  <li> Faster statistics browsing.  A small database is generally faster to browse than a large \n", 
"       databases, so using multiple small databases will make the statistics faster.<p>\n", "  <li> More flexibility.  Each configuration can be configured separately, so \n", 
"       you can have different cross-references, filters, database fields, etc.\n", "       for different configurations.  Using a single database locks you into a single \n", 
"       database structure for all configurations.<p>\n", "</ul>\n", "In summary, you'll usually want to use multiple databases. \n", 
"The main situation you'd want to use a single database is if you're using FTP \n", "over a metered line to fetch the data; a single database will fetch it just once. \n", 
"Even then, though, you could set up an external script to fetch the log data to the local disk once, \n", 
"and then process it locally with {PRODUCT_NAME}.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_filteringdomain \"Filtering All but One Domain\"\n", 
"FAQ_QUESTION_filteringdomain\n", "  \"Can {PRODUCT_NAME} generate statistics on just one domain, from a log file containing log data from many domains?\"\n", 
"FAQ_SHORT_ANSWER_filteringdomain\n", "  \"Yes.  Add a log filter that rejects hits from all other domains.\"\n", 
"FAQ_LONG_ANSWER_filteringdomain\n", "\"Yes.  This can be done easily using a log filter.  Here's how:<p> \n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Click the %22duplicate%22 (double-square) icon next to the GIF filter \n", 
"       to copy it.  We're doing this because the GIF filter already has most \n", "       of what we need, so it's faster to copy and modify it than to create the filter from scratch.\n", 
"       Some log formats may not include a GIF filter by default; in that case, you'll need to create \n", 
"       a new filter from scratch.<p>\n", "  <li> Click the blue triangle next to the new filter to expand it.<p>\n", 
"  <li> In the A section, choose %22value1 != value2%22 from the Operation menu.<p>\n", "  <li> In the A section, choose %22server domain%22 from the value1 menu. \n", 
"       If there is no %22server domain%22 field, then your log data does not \n", "       include domain information--you need to use a different log format.<p>\n", 
"  <li> In the A section, replace %22.gif%22 in the value2 field with the name of your domain,\n", "       as it appears in the server domain field of the log data (e.g. %22mydomain.com%22).<p>\n", 
"  <li> In the B section, choose %22reject%22 from the Action menu.<p>\n", "  <li> Click the blue triangle to the left of the filter to collapse it.<p>\n", 
"  <li> Click the blue arrows of the filters above the new filter until it is the first filter.<p>\n", 
"</ol><p>\n", "You're done!  The next time you rebuild the database (open your configuration from the Administrative menu, \n", 
"and click %22Rebuild Database from Log Source%22), all log entries from \n", "domains other than the one you entered will be rejected, leaving only statistics from the one \n", 
"domain.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_filteringdirectory \"Excluding a File or {CAPITALIZE:{DIRECTORY_WORD}}\"\n", 
"FAQ_QUESTION_filteringdirectory\n", "  \"How can I remove a particular file or directory from the statistics?\"\n", 
"FAQ_SHORT_ANSWER_filteringdirectory\n", "  \"Use a Log Filter to reject all hits on that file or directory.\"\n", 
"FAQ_LONG_ANSWER_filteringdirectory\n", "\"Create a new Log Filter to reject all hits on that file or directory.  Here's how:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Click the %22duplicate%22 (double-square) icon next to the GIF filter \n", 
"       to copy it.  We're doing this because the GIF filter already has most \n", "       of what we need, so it's faster to copy and modify it than to create the filter from scratch.\n", 
"       Some log formats may not include a GIF filter by default; in that case, you'll need to create \n", 
"       a new filter from scratch.<p>\n", "  <li> Click the blue triangle next to the new filter to expand it.<p>\n", 
"  <li> In the A section, choose %22value1 starts with value2%22 from the Operation menu.<p>\n", "  <li> In the A section, choose %22page%22 from the value1 menu.<p> \n", 
"  <li> In the A section, replace %22.gif%22 in the value2 field with the full pathname of the page\n", 
"       or directory, as it appears in the log data.  For instance, to filter out hits on the file \n", 
"       robots.txt at the top of your web site, enter %22/robots.txt%22.  To filter out hits on \n", 
"       the directory %22picts%22 ad the top of your web site, enter %22/picts/%22.<p>\n", "  <li> In the B section, choose %22reject%22 from the Action menu.<p>\n", 
"  <li> Click the blue triangle to the left of the filter to collapse it.<p>\n", "  <li> Click the blue arrows of the filters above the new filter until it is the first filter.<p>\n", 
"</ol><p>\n", "You're done!  The next time you rebuild the database (open your configuration from the Administrative menu, \n", 
"and click %22Rebuild Database from Log Source%22), all hits on that page or directory \n", "will be rejected, so they will not appear in the statistics.<p>\n", 
"By the way, the same technique can be use to filter hits based on any field, \n", "for instance all hits from a particular host or domain, or all hits from a particular \n", 
"referrer, or all hits from a particular authenticated user.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_rejectspiders \"Discarding hits from spiders\"\n", 
"FAQ_QUESTION_rejectspiders\n", "  \"How can I throw away all the spider hits, so I only see statistics on non-spider hits?\"\n", 
"FAQ_SHORT_ANSWER_rejectspiders\n", "  \"Use a Log Filter to reject all hits from spiders (and worms).\"\n", 
"FAQ_LONG_ANSWER_rejectspiders\n", "\"Create a new Log Filter to reject all hits from spiders.  Here's how:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Click the %22duplicate%22 (double-square) icon next to the top filter, to create a new filter and expand it.<p>\n", 
"  <li> For A:Operation, choose %22value1 equals value2%22.<p>\n", "  <li> For A:value1, choose %22spider%22 from the menu, and leave the field blank.  (If you don't see a \n", 
"       spider field, your log data probably does not have a %22user-agent%22 field, which is required for\n", 
"       spider analysis-- change your server to log in %22extended%22 or %22combined%22 format instead).<p> \n", 
"  <li> For A:value2, choose %22this value:%22 from the menu, and enter %22(not a spider)%22 in the field.<p>\n", 
"  <li> For B:Action, choose %22goto next filter%22.<p>\n", "  <li> For C:Action, choose %22reject%22.<p>\n", 
"  <li> Rebuild your database by clicking %22Back To Configuration Menu%22 at the top of the screen, and then \n", 
"       clicking %22Rebuild Database From Log Source%22.<p>\n", "</ol><p>\n", "You're done!  The next time you rebuild the database (you can do it now by\n", 
"clicking %22Back To Configuration Menu%22 at the top of the screen, and then \n", "clicking %22Rebuild Database From Log Source%22), all the spider hits will be rejected,\n", 
"so they will not appear in the statistics.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_gzippeddata \"Processing zipped, gzipped, or bzipped Log Data\"\n", 
"FAQ_QUESTION_gzippeddata\n", "  \"Can {PRODUCT_NAME} process ZIPped, gzipped, or bzipped log data?\"\n", 
"FAQ_SHORT_ANSWER_gzippeddata\n", "  \"Yes, to all three.\"\n", "FAQ_LONG_ANSWER_gzippeddata\n", "\"Yes.  Any files that end with a .gz, .zip, .bz, or .bz2 will be\n", 
"treated as compressed files by {PRODUCT_NAME}.  It will uncompress them %22on the fly%22\n", "(not modifying the original file and not creating any new files),\n", 
"and process their uncompressed data the same way it reads normal log files.\"\n", "\n", "\n", "\n", 
"\n", "FAQ_TITLE_upgradingpreserving \"Upgrading Without Losing Data\"\n", "FAQ_QUESTION_upgradingpreserving\n", 
"  \"How can I upgrade to a new version of {PRODUCT_NAME} without losing my configurations, databases,\n", 
"  and other data?\"\n", "FAQ_SHORT_ANSWER_upgradingpreserving\n", "  \"Copy the LogAnalysisInfo folder/directory from the old installation to the new.\"\n", 
"FAQ_LONG_ANSWER_upgradingpreserving\n", "\"{PRODUCT_NAME} stores all of its data, including configurations and databases,\n", 
"in the LogAnalysisInfo folder/directory in the installation folder/directory.\n", "As long as your new installation has the same LogAnalysisInfo as the old installation did,\n", 
"all of your preferences, settings, configurations, and databases will be preserved.\n", "There are several ways of arranging this, including installing over the old installation, \n", 
"or moving LogAnalysisInfo from the old to the new installation, or moving the program files from \n", 
"the new to the old installation.  Here are the recommended ways:<p>\n", "<h4>Windows and MacOS X</h4>\n", 
"Just install {PRODUCT_NAME}, using the default installer choices.\n", "The new {PRODUCT_NAME} will go in the same location as the old one, \n", 
"(C:\\Program Files\\{PRODUCT_NAME} on Windows, or /Applications/{PRODUCT_NAME} on MacOS X),\n", "and LogAnalysisInfo will not be changed.  There is no need \n", 
"to do anything other than run the installer and accept the default settings.<p>\n", "<h4>MacOS 9, UNIX, Linux, and others</h4>\n", 
"Unpack the installation.  Then copy LogAnalysisInfo from your old installation to the new.\n", "Finally, delete the old installation.<p>\n", 
"<h3>Troubleshooting</h3>\n", "Don't run the new version \n", "until <i>after</i> you have copied LogAnalysisInfo, or it will create its own LogAnalysisInfo.\n", 
"Also, make sure you're running the new version afterwards; you may want to delete the old installation \n", 
"to be sure you're running the right one.<p>\n", "If you're upgrading from an older version of {PRODUCT_NAME}, the folder may be called \n", 
"{PRODUCT_NAME}Info, rather than LogAnalysisInfo.  {PRODUCT_NAME} will rename this the first time it runs.\n", 
"If you move {PRODUCT_NAME}Info aside, and then install and run {PRODUCT_NAME} before moving it back, \n", 
"however, {PRODUCT_NAME} will create a new LogAnalysisInfo folder, and you won't see any of your \n", 
"configuration or databases.  If this happens, delete the new LogAnalysisInfo, and restart {PRODUCT_NAME} \n", 
"(or rename {PRODUCT_NAME}Info to LogAnalysisInfo), to get your data back.<p>\n", "\"\n", "\n", "\n", 
"\n", "FAQ_TITLE_exiturls \"Tracking Exit URLs\"\n", "FAQ_QUESTION_exiturls\n", "  \"How can I tell where visitors went when they left the site?\"\n", 
"FAQ_SHORT_ANSWER_exiturls\n", "  \"Normally, you can't.  However, you can set up %22reflector%22 pages if you need this information.\"\n", 
"FAQ_LONG_ANSWER_exiturls\n", "\"{PRODUCT_NAME} can show you the last page visitors hit before they exited the site, \n", 
"but it cannot usually show you where they went.  The reason is that \n", "when they click a link on your site leading to another site, \n", 
"their web browser contacts the other site (not your site) for the new page--your\n", "web server is not contacted at all when someone clicks a link to leave your site. \n", 
"So the hit appears in the remote site's log files, not yours, and {PRODUCT_NAME} cannot \n", "report on it because it's not in your log files.<p>\n", 
"Nevertheless, you can track exits from your site if you're willing to \n", "set up %22reflector%22 pages.  A reflector page is a page whose sole \n", 
"purpose is to reflect a visitor to another page.  This can be done with \n", "a trivial HTML page containing only a META RELOAD tag in the HEAD section. \n", 
"For instance, the following simple HTML page will cause a visitor to be immediately redirected \n", 
"to http://www.flowerfire.com:<p>\n", "<pre>  &lt;html&gt;\n", "  &lt;head&gt;\n", "  &lt;meta http-equiv=%22Refresh%22 content=%220; URL=http://www.flowerfire.com/%22&gt;\n", 
"  &lt;/head&gt;\n", "  &lt;/html&gt;</pre>\n", "By creating a page like this for every exit link on your site, and changing your links to \n", 
"point to the reflector page rather than the actual destination page, you can \n", "track exit link usage.  When a visitor clicks the exit link, they will be\n", 
"taken to the reflector page, and then immediately reflected to the actual \n", "destination.  This will happen quickly enough that they will not notice the reflection happening--it\n", 
"will seem to them that they went straight to the destination page.\n", "But your log data will include a hit on the reflector page, so you will be able to \n", 
"see which exit links are being taken.  In the %22exit pages%22 view, the \n", "reflector links will show which links were taken when leaving the site.<p>\n", 
"A more sophisticated way of doing this is to create a CGI script \n", "(or other type of script) which generates \n", 
"the reflector page on the fly, given a URL parameter.  If you do it that way, \n", "you won't need to create a separate reflector page for each link; you can just use \n", 
"the same script for all your external links.<p>\n", "These approaches can annoy the sites you link to, however, because\n", 
"they fool the %22link popularity%22 checkers in the search engines,\n", "since your exit URL links to your own site rather than theirs.\n", 
"This can result in their sites being listed lower in some search engines\n", "that they would have been with direct links.  One solution to the problem\n", 
"is to use a URL like this instead:<p>\n" "&lt;a href=%22http://www.partnersite.com/partnerpage.html%22 onclick=%22window.open('/links/out-partnersite.html','','location=0'); window.blur(); window.focus()%22&gt<p>\n", 
"Because this links directly to the partner site, it works for link popularity;\n", "since it also connects simultaneously to your own site, it lets you track the\n", 
"number of clicks you're getting for partnersite by looking at the number of\n", "clicks on /links/out-partnersite.html.\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_hitfiles \"Showing All Files\"\n", "FAQ_QUESTION_hitfiles\n", "  \"How can I see <i>all</i> files that were hit on my web site, not just the pages?\"\n", 
"FAQ_SHORT_ANSWER_hitfiles\n", "  \"Turn of %22Tally hits on directories%22 only, in the Database Struct tab of the Configuratio Options; then rebuild the database and %22Top pages%22 will show all files.\"\n", 
"FAQ_LONG_ANSWER_hitfiles\n", "\"By default, {PRODUCT_NAME} does not track the hits on individual image files and other\n", 
"non-page files, to save space in the database and reduce clutter in the %22Top pages%22 view.\n", "If you need this information, you need to tell {PRODUCT_NAME} to tally hits on all files, \n", 
"not just page files.  Here's how:<p>\n", "<ol>\n", "<li> Open your configuration from the Administrative Menu.</li>\n", 
"<li> Click Configuration Options.</li>\n", "<li> Click the Database Params tab.</li>\n", "<li> Turn off the %22Tally hits on directories only%22 checkbox.</li>\n", 
"<li> Click %22Back To Configuration Menu%22.</li>\n", "<li> Click %22Rebuild Database From Log Source%22.</li>\n", 
"</ol>\n", "Now view the statistics, and <i>all</i> files (not just pages) will appear in the %22Top pages%22 and\n", 
"%22Top pages/directories%22 views.\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_visitorsums \"Visitor Totals Don't Add Up\"\n", 
"FAQ_QUESTION_visitorsums\n", "  \"When I add up the number of visitors on each day in the month, \n", 
"  and I compare it to the total visitors for the month, they're not equal.  Why not? \n", "  Also, why doesn't the sum of visitors on subpages/subdirectories add up to the total for the directory, and \n", 
"  why don't the sum of visitors on subdomains add up to the total for the domain, etc.?\n", "  And why are visitors sometimes shown as a dash (-)?\"\n", 
"FAQ_SHORT_ANSWER_visitorsums\n", "  \"Because %22visitors%22 is the number of <i>unique</i> visitors, \n", 
"  a visitor who visits every day will show up as a single visitor in each day's visitors count, \n", 
"  but also as a single visitor for the whole month--not 30 visitors!  Because a simple sum won't do, \n", 
"  {PRODUCT_NAME} cannot compute the visitors when the filters are complicated, and it shows them as a dash.\"\n", 
"FAQ_LONG_ANSWER_visitorsums\n", "\"We get this a lot as a bug report, but {PRODUCT_NAME} is <i>not</i> counting visitors wrong.\n", 
"%22Visitors%22 in {PRODUCT_NAME}'s terminology refers to unique visitors (see [faq-datatypes]).  So:<p>\n", 
"<ul>\n", "  <li> The total hits on a month is equal to the sum of the hits on the days of the month<p>\n", 
"<i>and</i><p>\n", "  <li> and the total bandwidth for a month is equal to the sum of the bandwidth on the days of the month<p>\n", 
"<i>and</i><p>\n", "  <li> and the total page views for a month is equal to the sum of the page views for each day of the month<p>\n", 
"<b><i>BUT</i></b><p>\n", "  <li> The total number of visitors in a month is <i>not</i> usually equal to the sum of the visitors on the days of the month.<p>\n", 
"</ul><p>\n", "Here's why.  Suppose you have a web site where only one person ever visits it, but that person\n", 
"visits it every day.  For every day of the month, you will have a single visitor.  For the entire month, too, \n", 
"you will have a single visitor, because visitors are <i>unique</i> visitors, and there was only one visitor \n", 
"in the entire month, even though that visitor came back again and again.  But in a 30-day month, the sum \n", 
"of the visitors per day will be 30, or one visitor per day.  So though {PRODUCT_NAME} will correctly report \n", 
"one visitor that month, it will also correctly report one visitor per day.<p>\n", "\n", "Because of this, {PRODUCT_NAME} cannot compute visitors for complex filters (like a single-week filter, which \n", 
"is computed as the sum of seven days) the way it does with hits, page views, or bytes, where it just adds \n", 
"them.  For complex filters, {PRODUCT_NAME} cannot sum the visitors to compute the visitor count, \n", 
"so it shows it as a single dash (-).<p>\n", "\n", "If what you're really looking for is %22visits%22 rather than %22visitors%22 (so each visit will count \n", 
"once, even if it's the same visitor coming back over and over), then that's what {PRODUCT_NAME} calls %22sessions,%22 \n", 
"and you can get information about them in the Sessions Summary and other session-related views\n", 
"(paths through the site, entry pages, exit pages, time spent per page).\"\n", "\n", "\n", "\n", "FAQ_TITLE_dnslookup \"Resolving IP Numbers\"\n", 
"FAQ_QUESTION_dnslookup\n", "  \"When I look at the top hosts and top domains, all I see are numbers (IP addresses).\n", 
"  How do I get the domain information?\"\n", "FAQ_SHORT_ANSWER_dnslookup\n", "  \"Turn on reverse DNS lookup in the Network options (or in your web server),\n", 
"  or use {PRODUCT_NAME}'s %22look up IP numbers%22 feature.\"\n", "FAQ_LONG_ANSWER_dnslookup\n", "\"Your web server is tracking the IP numbers of visitors, but not\n", 
"their hostnames or domains.\n", "If you need hostname or domain information, you need to tell {PRODUCT_NAME}\n", 
"(or your web server) to look up the IP addresses using DNS (domain name service).\n", "One way to do this is to turn on DNS lookup in your web server; that will slow down\n", 
"your server, but then {PRODUCT_NAME} will report hostnames and domains without any performance penalty during\n", 
"log data processing.<p>\n", "If you're not willing to take the performance hit on your server,\n", 
"or if you want to analyze log data that has already been generated with IP addresses,\n", "you can turn on {PRODUCT_NAME}'s reverse DNS feature like this:\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Network tab.<p>\n", "  <li> Check the box labeled %22Look up IP numbers using domain nameserver (DNS).%22<p>\n", 
"  <li> Enter the hostnames or IP addresses of one or two DNS servers in the DNS server fields.\n", 
"       You can get this information from your network administrator, or your ISP\n", "       (there are no %22public%22 DNS servers available-- you need to use the servers from your own network).<p>\n", 
"  <li> Rebuild the database (click Back to Configuration Page, then click Rebuild Database from Log Source).<p>\n", 
"</ol>\n", "Processing log data will be slower with reverse DNS turned on,\n", "but you will get full hostname and domain information.<p>\n", 
"\n", "If you have problems getting the DNS feature to resolve IP addresses, see \n", "[faq-dnsproblems].<p>\n", 
"A third option is to use a separate DNS resolving program to compute your \n", "log files after the server is done writing them, and before {PRODUCT_NAME} analyzes them.\n", 
"Examples include <code>logresolve</code>, which is included with the popular Apache web server,\n", 
"<a http://summary.net/soft/dnstran.html>DNSTran</a>, which runs on several platforms including \n", 
"Macintosh, Linux, Solaris, and IRIX.<p>\n", "If you're using UNIX or MacOS X,\n", "another good option is <a href=%22http://www.chiark.greenend.org.uk/~ian/adns/%22>adns</a>,\n", 
"an asynchronous DNS lookup library that includes some command-line tools for\n", "looking up IP addresses, including <code>adnslogres</code> (for Common Access format\n", 
"and Apache Combined format files) and <code>adnsresfilter</code> (for other\n", "types of log files).  For instance, you can use the command %22adnsresfilter &lt; /path/to/my/log.file%22\n", 
"as your log source command to use adns.  adns is faster than logresolve, but\n", "more difficult to configure initially.<p>\n", 
"You can plug any command-line DNS resolver\n", "directly into {PRODUCT_NAME} by using a command log source type, \n", 
"and entering a command line that\n", "resolves the IPs in the log file and dumps the resolved log data \n", 
"to the standard output stream, in this case<p>\n", "<pre>  logresolve &lt; /path/to/my/log.file</pre>\n", 
"Once you've done that,\n", "{PRODUCT_NAME} will automatically run logresolve when you process your log data, and\n", 
"it will resolve the data before feeding it to {PRODUCT_NAME}.<p>\"\n", "\n", "\n", "\n", "FAQ_TITLE_pageparameters \"Page Parameters\"\n", 
"FAQ_QUESTION_pageparameters\n", "  \"I use parameters on my pages (e.g. index.html?param1+param2),\n", 
"  but {PRODUCT_NAME} just shows %22index.html?(parameters).%22  How can I see my page parameters?\"\n", 
"FAQ_SHORT_ANSWER_pageparameters\n", "  \"Delete the Log Filter that converts the parameters to %22(parameters).%22\"\n", 
"FAQ_LONG_ANSWER_pageparameters\n", "\"By default, {PRODUCT_NAME} creates a log filter to convert everything after\n", 
"the ? in the page field to %22(parameters)%22. In most cases that's best, because it reduces\n", "the size of the database significantly. But if you need the parameter\n", 
"information, it's easy to get it back--just delete that filter. You can do that like this:<p>\n", "<ol>\n", 
"  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Click the red x next to the filter whose description is \n", 
"       %22replace everything after the first occurrence of '?' with\n", "       '(parameters)', in the page field.%22<p>\n", 
"  <li> Click the %22Back to the Configuration Menu%22 button at the top of the page.<p>\n", "  <li> Click %22Rebuild Database From Log Source%22, and click Next when it asks you if you're sure.<p>\n", 
"  <li> Click View Statistics.<p>\n", "</ol>\n", "%22(parameters)%22 should be replaced by actual parameters now.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_clusteredservers \"Clustered Servers\"\n", "FAQ_QUESTION_clusteredservers\n", 
"  \"Can {PRODUCT_NAME} combine the logs from multiple clustered or load balanced web servers,\n", "    so that the user has one view of the data?  Can it report separately on the different servers?\"\n", 
"FAQ_SHORT_ANSWER_clusteredservers\n", "  \"Yes.\"\n", "FAQ_LONG_ANSWER_clusteredservers\n", "\"{PRODUCT_NAME} can read any number of log files, from any number of servers,\n", 
"into a single database to show a single view of all the data. If the logs also contain\n", "information about which server handled each request (or if each server\n", 
"has a separate log file, or a set of separate log files),\n", "then {PRODUCT_NAME} can also show per-server statistics, if desired.\n", 
"Unlike many log analysis tools, {PRODUCT_NAME} does not care if the files are in order,\n", "or if their date ranges overlap--any combinations of any number of files with data in any order are possible.<p>\n", 
"To see per-server statistics, you need to have a field in your log data that \n", "identifies the server for each hit.  Here's how:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Database Fields tab.<p>\n", 
"  <li> Click on the double box icon next to any database field to duplicate that field.<p>\n", "  <li> Open either of the duplicated fields.<p>\n", 
"  <li> Choose the name of the log field which shows the server from the %22Based on log field%22 menu.<p>\n", 
"  <li> Enter 0 for the %22Suppress levels above%22 and 2 for %22Suppress levels below.%22  If \n", 
"       you're creating a hierarchical field, you may want to use a higher %22Suppress levels below%22 value.<p>\n", 
"  <li> Click the Database Xrefs tab.<p>\n", "  <li> Click the %22Back To Configuration Menu%22 button.<p>\n", 
"  <li> Click %22Rebuild Database From Log Source,%22 click %22Next%22 if it asks you if you really want to rebuild, \n", 
"       and wait for the rebuild to finish.<p>\n", "       Note: this step is necessary if you intend to create a view, \n", 
"       because the Stats View tab menus are based on the data in the database.  You can skip the rebuild, \n", 
"       and the rest of this list, if you don't need a view.  A view will let you see per-server statistics \n", 
"       in its own table, but if you don't need that, \n", "       you don't need a separate view--you can use the Filters to zoom in on any server or collection of categories.<p>\n", 
"       Note: you'll be rebuilding again at the end of this process, so if your log data is huge\n", 
"       and a database build will take a very long time, you may want to consider temporarily changing your log source \n", 
"       to point to a single small file, doing a quick rebuild and then setting\n", "       the log source back to what it was for the final rebuild.<p>\n", 
"  <li> Click Configuration Options.<p>\n", "  <li> Click the Stats Views tab.<p>\n", "  <li> Choose where you want your view to go in the list, and duplicate the view (by clicking the double box)\n", 
"       at the location you want your view to be.  The order shown here is the same order \n", "       as the buttons down the left of the statistics.  So if you want your new view to be at the \n", 
"       top of the list, duplicate the first view.  For simplicity, you should <i>not</i> use the %22single page summary%22\n", 
"       as the view to duplicate; duplicate one above or below it instead if you want your view to go there.  If you \n", 
"       duplicate the %22single-page summary%22 you will have to delete all but one of the subviews before you can use it,\n", 
"       which will take a long time.<p>\n", "  <li> Open your new view by clicking the light blue triangle next to it.<p>\n", 
"  <li> Name the view %22Top servers%22 or whatever you like.<p>\n", "  <li> Click the blue triangle next to the first subview to open it.<p>\n", 
"  <li> Change the subview Type to %22Top items for the server page.%22<p>\n", "</ol><p>\n", "If you don't have a field that tracks the server, you may still be able to get per-server \n", 
"statistics, by using the %22log filename%22 field to detect which server each hit came from. \n", "You'll need to create a %22content group%22 in that case, with a log field to track the server, \n", 
"a filter to compute the field from the log filename, and a database field and view as described above. \n", 
"For information on creating content groups, see [faq-contentgroups].\"\n", "\n", "\n", "\n", "FAQ_TITLE_logentryorder \"Log Entry Ordering\"\n", 
"FAQ_QUESTION_logentryorder\n", "  \"Does the log data I feed to {PRODUCT_NAME} need to be in chronological order?\"\n", 
"FAQ_SHORT_ANSWER_logentryorder\n", "  \"No; your log entries can be in any order.\"\n", "FAQ_LONG_ANSWER_logentryorder\n", 
"\"Unlike many other log analysis tools, {PRODUCT_NAME} doesn't care what order your log data is it.\n", 
"It can be in any order you like.  That means that if you have several log files\n", "from several servers in a cluster, you can dump the data from all of them into the same\n", 
"database, without worrying that their date ranges overlap.\"\n", "\n", "\n", "\n", "FAQ_TITLE_ftplogsource \"Downloading Log Data by FTP\"\n", 
"FAQ_QUESTION_ftplogsource\n", "  \"Can {PRODUCT_NAME} be configured to download files automatically, using FTP, from multiple servers, and \n", 
"  add them daily to a database?\"\n", "FAQ_SHORT_ANSWER_ftplogsource\n", "  \"Yes.\"\n", "FAQ_LONG_ANSWER_ftplogsource\n", 
"\"Yes; just select one of the FTP log sources when {PRODUCT_NAME} asks you where your data is.\n", 
"{PRODUCT_NAME} can FTP one or more log files from any FTP server, anonymously or with a username/password.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_clientsecurity \"Protecting Clients' Statistics\"\n", "FAQ_QUESTION_clientsecurity\n", 
"  \"Can {PRODUCT_NAME} be configured to limit access to statistics, so that\n", "  a customer can only see the statistics associated with their\n", 
"  section of my web site?\"\n", "FAQ_SHORT_ANSWER_clientsecurity\n", "  \"Yes, you can password protect statistics in several ways.\"\n", 
"FAQ_LONG_ANSWER_clientsecurity\n", "\"Yes.  {PRODUCT_NAME} provides several ways to do this.  In general, you will create\n", 
"a separate configuration for each user.  Each configuration can have\n", "two separate passwords associated with it, so nobody but that user can view the statistics.\n", 
"Each user can have a separate database, or all users' statistics\n", "can be combined in a single database.  htaccess-style authentication\n", 
"is also supported, and can be used to automatically route the user to\n", "the appropriate statistics.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_scheduling \"Scheduling\"\n", "FAQ_QUESTION_scheduling\n", "  \"Can {PRODUCT_NAME} be configured to automatically analyze the access log for my\n", 
"  site on a shared server once a day at a given time?\"\n", "FAQ_SHORT_ANSWER_scheduling\n", "  \"Yes, if you run it stand-alone, or if your server has a scheduling program.\"\n", 
"FAQ_LONG_ANSWER_scheduling\n", "\"It depends on your web server. If you run {PRODUCT_NAME} as a stand-alone\n", 
"program (rather than as a CGI program) on your server, then you can\n", "use {PRODUCT_NAME}'s built-in Scheduler to do this. If you can't run it\n", 
"stand-alone or don't want to, then you can still set up automatic\n", "database builds if your server has its own scheduling program (like\n", 
"cron or Windows Scheduler).\"\n", "\n", "\n", "\n", "FAQ_TITLE_daterange \"Showing a Date Range\"\n", 
"FAQ_QUESTION_daterange\n", "  \"How can I specify date ranges for the output?  For example, I wish to see activity from 01/Feb/2000 through\n", 
"  04/Feb/2000.  How would I tell {PRODUCT_NAME} to limit the output to these dates?\" \n", "FAQ_SHORT_ANSWER_daterange\n", 
"  \"Using the Filters Editor, add the four days as limits to the date/time field.\"\n", "FAQ_LONG_ANSWER_daterange\n", 
"\"Click the %22edit%22 link in the filters bar at the top of the statistics page.\n", "Then click %22edit%22 next to the date/time field.\n", 
"Then expand the date/time\n", "hierarchy using the blue arrows until the days you want are showing.\n", 
"Click the check boxes next to the four days, and click\n", "Apply Filter and then Apply Filters.  Once the filters are in place, the data you\n", 
"see will be only for hits on the 1st, 2nd, 3rd, and 4th of February, 2000.\n", "If you checked %22day-by-day statistics%22 when you created the configuration,\n", 
"you can also switch to any other view to see that information for the 1st through the 4th\n", "(for instance, which pages were hit on those four days).<p>\n", 
"If you know you're never going to want information outside a particular range, \n", "you can also do the filtering as the log data is read, using the Log Filters \n", 
"tab of the Configuration Options.<p>\"\n", "\n", "\n", "\n", "\n", "FAQ_TITLE_excludeip \"Excluding an IP Address or Domain\"\n", 
"FAQ_QUESTION_excludeip\n", "  \"How can I exclude hits from my own IP address, or from my organization's domain?\"\n", 
"FAQ_SHORT_ANSWER_excludeip\n", "  \"Add a Log Filter to exclude those hits.\"\n", "FAQ_LONG_ANSWER_excludeip\n", 
"\"One way to do this is to Select All in the statistics Filters and then unselect your\n", "IP address or domain, and this is often the first thing people try, but it's not the best choice.\n", 
"The speed of a statistics filter depends on the number of items checked, so if there are\n", "100,000 IP addresses in your log file, and you check all 100,000, then {PRODUCT_NAME} will take\n", 
"100,000 times longer to generate each page.  Which is probably not what you had in mind.\n", "A much better option is to use the Log Filters.<p>\n", 
"Log filters are used to filter out or modify log data as it is being read\n", "(rather than filtering database data as it is being browsed, like the statistics filters).\n", 
"You can get to the Log Filters by opening your configuration, clicking Configuration Options,\n", "and clicking the Log Filters tab.<p>\n", 
"You want to create a filter that will reject any log entries whose hostname field is your IP\n", "address.  If your IP address is 128.128.128.128, the filter you want is this:<p>\n", 
"<ul>\n", "  if the hostname field is equal to %22128.128.128.128%22<br>\n", "  then reject this log entry (and stop filtering)<br>\n", 
"  otherwise continue to the next filter\n", "</ul>\n", "You can create this filter like this:<p>\n", 
"<ol>\n", "  <li> <p>Go to the Log Filters tab of the Configuration Options.</p>\n", "  <li> <p>Click the double-box icon to the left of the first Log Filter, to dulicate it.</p>\n", 
"  <li> <p>Set the filter type to %22If A is true, then do B; otherwise do C%22.</p>\n", "  <li> <p>Set A:operation to %22value1 = value2%22</p>\n", 
"  <li> <p>Set A:value1 to %22hostname%22 (or whatever field you want to reject on; the\n", "       field name varies depending on log format, and may be %22source IP%22, %22source host%22,\n", 
"       or something else.</p>\n", "  <li> <p>Set A:value2 to %22this value:%22 and enter the IP address in the value2 field.</p>\n", 
"  <li> <p>Set B:Action to %22reject%22.</p>\n", "  <li> <p>Set C:Action to %22goto next filter%22.</p>\n", 
"</ol>\n", "The next time you rebuild the database, hits from your IP address will\n", "be rejected, and will not appear in the statistics.<p>\n", 
"Rejecting all hits from a particular domain is very similar; if your domain is mydomain.com, \n", "and your server is set to look up IP addresses, then you can use this filter:<p>\n", 
"<ul>\n", "  if the hostname field ends with %22.mydomain.com%22<br>\n", "  then reject this log entry (and stop filtering)<br>\n", 
"  otherwise continue to the next filter\n", "</ul>\n", "If your server logs hostnames as IP addresses (and does not resolve them to hostnames \n", 
"with DNS), you can use the subnet for your domain instead; for instance, if all hits from \n", "mydomain.com will come from the subnet 128.128.128, then you can use this filter:<p>\n", 
"<ul>\n", "  if the hostname field starts with %22128.128.128.%22<br>\n", "  then reject this log entry (and stop filtering)<br>\n", 
"  otherwise continue to the next filter\n", "</ul>\n", "<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_excludespiders \"Excluding Spiders\"\n", 
"FAQ_QUESTION_excludespiders\n", "  \"How can I exclude spider/robots hits from my statistics?\"\n", 
"FAQ_SHORT_ANSWER_excludespiders\n", "  \"Add a Log Filter to exclude those hits.\"\n", "FAQ_LONG_ANSWER_excludespiders\n", 
"\"Create a Log Filter (in the Log Filters tab of the Configuration Options)\n", "to reject any log entries which are from spiders.\n", 
"Log entries which are <i>not</i> from spiders will have %22(not a spider)%22 as\n", "the spider field value, so you can reject all spiders using the following Log Filter:<p>\n", 
"<ul>\n", "  if the spider field = %22(not a spider)%22<br>\n", "  then continue to the next filter<br>\n", 
"  otherwise reject this log entry (and stop filtering)<br>\n", "</ul>\n", "You can create this filter by going to the Log Filters tab of the\n", 
"Configuration Options, clicking the double-box next to the first filter\n", "to duplicate it (or if there are no filters at all, creating one),\n", 
"and using the following values in the filter fields:<p>\n", "<ul>\n", "type: <i>If A is true then do B; otherwise do C</i><br />\n", 
"A:Operation: <i>value1 = value2</i><br />\n", "A:value1: choose <i>spider</i> from the menu; leave the field blank.<br />\n", 
"A:value2: choose <i>this value:</i> from the menu; enter <i>(not a spider)</i> in the field.<br />\n", 
"B:Action: <i>goto next filter</i><br />\n", "C:Action: <i>reject</i><br />\n", "</ul>\n", "</p>\n", 
"Then rebuild the database (Click %22Back to Configuration Menu%22 and %22Rebuild Database From Log Source%22)\n", 
"and the statistics will no long show the spider hits.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_clickstream \"Clickstreams (Paths Through the Site)\"\n", 
"FAQ_QUESTION_clickstream\n", "  \"Can {PRODUCT_NAME} show me the paths visitors took through my web site?\"\n", 
"FAQ_SHORT_ANSWER_clickstream\n", "  \"Yes; its %22paths through the site%22 view is very powerful.\"\n", 
"FAQ_LONG_ANSWER_clickstream\n", "\"Yes, very well.  Where most statistics packages will only show you\n", 
"the %22top paths%22 or maybe the entry and exit pages, {PRODUCT_NAME} shows\n", "you <i>all</i> the paths visitors took through the sites,\n", 
"in an easily navigated hierarchical view.\n", "You get complete data about every path that every visitor took through your site, click-by-click.\"\n", 
"\n", "\n", "\n", "\n", "FAQ_TITLE_resources \"Resource Usage\"\n", "FAQ_QUESTION_resources\n", "  \"How much memory/disk space/time does {PRODUCT_NAME} use?\"\n", 
"FAQ_SHORT_ANSWER_resources\n", "  \"It depends on how much detail you ask for in the database.\n", 
"  It uses very little if you use the default detail levels.\"\n", "FAQ_LONG_ANSWER_resources\n", "\"It depends on how much detail you ask for when you create the configuration.\n", 
"If you leave the detail settings at their default values (Summary, and tracking only page views),\n", 
"{PRODUCT_NAME} will use very little memory, very little disk space, and will run very quickly\n", "(10,000 lines per second on a fast machine).  If you set the detail level to the maximum,\n", 
"it will use <i>much</i> more disk space, and will run much slower (1000-2000 lines per second \n", 
"on a fast machine).  Even at the highest detail level, it will usually use less than 30 Meg\n", "of memory, but the disk space usage will be very high (as much as twice the size of your\n", 
"uncompressed log data).<p>\n", "The disk usage goes up gradually as you increase the detail, and the processing speed goes down.\n", 
"Using the %22Full Detail%22 option will particularly make a big difference,\n", "and tracking visitor information or day-to-day statistics will make a significant but not huge difference.\n", 
"The other detail options will slow processing, but will not have much affect on disk space.<p>\n", 
"If you need that full detail, {PRODUCT_NAME} can give it to you--it will just take a little longer,\n", 
"and you'll need more disk space.<p>\"\n", "\n", "\n", "\n", "\n", "\n", "\n", "\n", "FAQ_TITLE_nodialup \"Using {PRODUCT_NAME} Without Dialing In\"\n", 
"FAQ_QUESTION_nodialup\n", "  \"Can I use {PRODUCT_NAME} with a computer that is not connected to the Internet,\n", 
"  or can I use it with a computer that is connected by dial-up access without\n", "  having to dial up?\"\n", 
"FAQ_SHORT_ANSWER_nodialup\n", "  \"Yes; see long answer for instructions.\"\n", "FAQ_LONG_ANSWER_nodialup\n", 
"\"You can use {PRODUCT_NAME} on a stand-alone (not networked) system, and you can\n", "use it on a dial-up system without having to be connected.  Instructions\n", 
"are different for different platforms:<p>\n", "<ul>\n", "  <li> <b>Windows</b>.  {PRODUCT_NAME} should automatically use 127.0.0.1 (the %22loopback interface%22)\n", 
"       for its web server.  This means that it won't need to use the network at all by default.\n", 
"       So you shouldn't have to do anything to use it disconnected.  If it's trying to dial in,\n", 
"       it's probably trying to access the DNS server; try turning on %22Never look up IP numbers using domain nameserver%22\n", 
"       in the Miscellaneous tab of the Preferences.  If problems persist, please contact\n", "       <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>.<p>\n", 
"  <li> <b>MacOS</b>.  To get {PRODUCT_NAME} to work disconnected, you need to temporarily turn off\n", 
"       any Internet networking you have, and tell MacOS to use only the local network.  You\n", "       can do this as follows:<p>\n", 
"    <ol>\n", "      <li> Open the TCP/IP control panel.\n", "      <li> Choose %22AppleTalk (MacIP)%22 from the %22Connect via:%22 menu at the top of the window.\n", 
"      <li> Choose %22Using MacIP Manually%22 from the Configure menu at the top of the window.\n", 
"      <li> Choose %22Current Appletalk Zone%22 for the zone, if it isn't already selected.\n", "      <li> Type any IP address you like in the IP Address box (say, 123.123.123.123).\n", 
"    </ol>\n", "       <p>\n", "       Once you've done that, you can run {PRODUCT_NAME}, it will run its web server locally on\n", 
"       123.123.123.123, and you can browse it using a web browser on the same machine.\n", "       If you expect to be switching between disconnected and connected mode a lot, you\n", 
"       may want to create a TCP/IP configuration for it; see the File menu of the TCP/IP\n", "       control panel.<p>\n", 
"  <li> <b>UNIX and others</b>.  You can bind to the loopback interface (127.0.0.1) by\n", "       running {PRODUCT_NAME} with the command line %22{PRODUCT_EXECUTABLE_DOCS} -ws t -sh 127.0.0.1%22; it will not need\n", 
"       the network.<p>\n", "</ul>\"\n", "\n", "\n", "\n", "\n", "FAQ_TITLE_largelogs \"Processing Large Log Files\"\n", 
"FAQ_QUESTION_largelogs\n", "  \"How large of a log file can {PRODUCT_NAME} process?\"\n", "FAQ_SHORT_ANSWER_largelogs\n", 
"  \"There are no limits, except those imposed by the limitations of your server.\"\n", "FAQ_LONG_ANSWER_largelogs\n", 
"\"There is no fundamental limit--given enough memory, disk space, and time, you can process\n", "the world.\n", 
"We've processed log files tens of gigabytes in size, hundreds of millions of lines long,\n", "and been able to browse\n", 
"their statistics at <b>full</b> complexity in real time,\n", "with no troubles.<p>\"\n", "\n", "\n", 
"\n", "\n", "FAQ_TITLE_logformats \"Supported Log Formats\"\n", "FAQ_QUESTION_logformats\n", "  \"What sorts of log files can {PRODUCT_NAME} process?\"\n", 
"FAQ_SHORT_ANSWER_logformats\n", "  \"{PRODUCT_NAME} can handle all major log formats and many minor formats, and you can create your own custom formats.\"\n", 
"FAQ_LONG_ANSWER_logformats\n", "\"{PRODUCT_NAME} is not just for web server logs, though it's well suited to that task.\n", 
"{PRODUCT_NAME} directly supports the following log formats:<p>\n", "\n", "{LOGFORMATS}\n", "\n", "It automatically detects all the formats it supports, and chooses appropriate settings\n", 
"for the format.<p>\n", "\n", "We're continually adding new log formats, so the list above will keep growing.<p>\n", 
"\n", "If you want to analyze a log in a different format,\n", "{PRODUCT_NAME} also lets you create your own format description file;\n", 
"once you've done that, your format becomes one of the supported ones--{PRODUCT_NAME}\n", "will autodetect it and choose good options for it, just like any built-in format.<p>\n", 
"\n", "{PRODUCT_NAME}'s format description files are <i>very</i> powerful; almost any\n", "possible format can be described.\n", 
"If you have an unsupported format and you'd like help writing a format file, please contact \n", "<a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a>,\n", 
"and we'll write a format file for you, at no charge.<p>\"\n", "\n", "\n", "\n", "\n", "FAQ_TITLE_peakperiods \"Peak Period Reports\"\n", 
"FAQ_QUESTION_peakperiods\n", "  \"Does {PRODUCT_NAME} do %22peak period%22 reports (by weekday, or hour)?\"\n", 
"FAQ_SHORT_ANSWER_peakperiods\n", "  \"Yes.\"\n", "FAQ_LONG_ANSWER_peakperiods\n", "\"Yes.  {PRODUCT_NAME} lets you break your statistics down by any of a large number of criteria,\n", 
"and by more than one at a time.  Among these criteria are %22day of week%22 and %22hour of day,%22\n", 
"so you can see weekday or hour information just by adding the appropriate field to your\n", "database.<p>\"\n", 
"\n", "\n", "\n", "\n", "FAQ_TITLE_weeklystatistics \"Weekly Statistics\"\n", "FAQ_QUESTION_weeklystatistics\n", 
"  \"Can I see the number of hits per week?  Can I see a %22top weeks%22 report?\"\n", "FAQ_SHORT_ANSWER_weeklystatistics\n", 
"  \"Yes, by using the Calendar, and/or creating a database field, and a view tracking %22weeks of the year.%22\"\n", 
"FAQ_LONG_ANSWER_weeklystatistics\n", "\"The date/time field in {PRODUCT_NAME} tracks years, months, days, hours, minutes, and seconds. \n", 
"Each of these units fits evenly into the larger unit (24 hours in a day, 12 months in a year, etc.). \n", 
"Because weeks do not fit evenly into months, {PRODUCT_NAME} cannot easily fit weeks into the date/time \n", 
"hierarchy.  Still, there are several ways to see weekly statistics.<p>\n", "One way is to use the Calendar. In the Calendar, each week is represented as a link called %22week%22--\n", 
"clicking the link applies a filter to the date/time field that shows the hits on those seven days. \n", 
"This lets you zoom in on a particular week, so you can see the hits, bandwidth, and page views for that \n", 
"week, or you can switch to other views to learn more about the activity for that week. \n", "However, if you do it that way, you cannot see visitors for a week (see [faq-visitorsums]), and you can't see \n", 
"a list or graph of weeks, with the hits for each week, the way you can for days in the %22Top days%22 view.<p>\n", 
"If you need weekly visitors, or a weekly graph, you need to track the %22week of the year%22 log field. \n", 
"The week of the year is a number between 1 and 52 that represents the week of the year (e.g. \n", "1 means January 1 through January 8, etc.).  You can track the week of the year field like this:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Database Fields tab.<p>\n", 
"  <li> Click the double square next to the first database field, to duplicate it.<p>\n", "  <li> Click the light blue triangle next to the first database field, to edit it.<p>\n", 
"  <li> Choose %22week of year%22 from the %22Based on log field%22 menu; enter 0 for collapse, and 2 for suppress.<p>\n", 
"  <li> Click the Database Xrefs tab, but don't change anything there (clicking updates the xrefs to include the new field).<p>\n", 
"  <li> Click the %22Back to Configuration Menu%22 button at the top of the page.<p>\n", "  <li> Click Rebuild Database From Log Source.<p>\n", 
"  <li> If it asks you whether to erase the current database, click Next.<p>\n", "  <li> Click the Configuration Options button.<p>\n", 
"  <li> Click the Stats Views tab.<p>\n", "  <li> Click the double square next to the %22Top days%22 view, to copy it.<p>\n", 
"  <li> Click the light blue triangle next to the new view, to edit it.<p>\n", "  <li> Change the view name to %22Top week of years%22.<p>\n", 
"  <li> Click the light blue triangle next to the subview of the new view, to edit it.<p>\n", "  <li> Choose the %22Top week of years%22 as the view type.<p>\n", 
"  <li> Click the %22Back to Configuration Menu%22 button at the top of the page.<p>\n", "  <li> Click View Statistics.<p>\n", 
"</ol>\n", "The new view will appear as a %22Top week of the years%22 button at the left \n", "of the statistics; clicking it will show the number of hits on each week of the year.<p>\"\n", 
"\n", "\n", "\n", "\n", "FAQ_TITLE_timeofday \"Time of Day Statistics\"\n", "FAQ_QUESTION_timeofday\n", 
"  \"Does {PRODUCT_NAME} do time of day?\"\n", "FAQ_SHORT_ANSWER_timeofday\n", "  \"Yes.\"\n", "FAQ_LONG_ANSWER_timeofday\n", 
"\"Yes, {PRODUCT_NAME} can pinpoint your hits to the second.  By default, the hour/minute/second\n", 
"information is omitted from databases to save space, but it can easily be enabled\n", "if you're interested in knowing exactly when hits occurred\n", 
"(for instance, if you need to track bandwidth second-by-second,\n", "or find the average number of hits or bandwidth per second using a 95% rule).\n", 
"To track hits to the hour level, increase the %22suppress below%22 value to 4 for the date/time \n", 
"field in the Database Fields tab of the Configuration Options. \n", "For minute information, increase the value to 5; for seconds, increase it to 6.\n", 
"You can dive into an hour to see when hits occurred by\n", "minute, and dive into a minute to see the exact second hits occurred.\n", 
"You can also generate a complete list of all hours, minutes, or seconds in the log data, with the \n", 
"number of hits/bytes/etc on each.<p>\"\n", "\n", "\n", "\n", "\n", "FAQ_TITLE_uniquevisitors \"Unique Visitors\"\n", 
"FAQ_QUESTION_uniquevisitors\n", "  \"Can {PRODUCT_NAME} count unique visitors?\"\n", "FAQ_SHORT_ANSWER_uniquevisitors\n", 
"  \"Yes, using unique hostname or using cookies.\"\n", "FAQ_LONG_ANSWER_uniquevisitors\n", "\"Yes; {PRODUCT_NAME} can tell you the number of unique visitors for any\n", 
"item in the database, including the number of visitors for a particular day,\n", "the number of visitors from a particular domain, the number of visitors\n", 
"who hit any particular page or directory, or any other type of data {PRODUCT_NAME} can display.<p>\n", 
"\n", "By default, {PRODUCT_NAME} uses the hostname field of your log data\n", "to compute visitors based on unique hosts.  That works for all log files,\n", 
"but it's a somewhat inaccurate count due to the effect of proxies and caches.\n", "If your log data tracks visitors using cookies, you can easily configure {PRODUCT_NAME}\n", 
"to use the cookie information instead, by changing the Log Filter that \n", "copies the hostname field to the visitor id field so that it copies the cookie \n", 
"field instead (in the Log Filters tab of the Configuration Options).\n", "See also [faq-visitorcookies].\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_visitorcookies \"Counting Visitors With Cookies\"\n", "FAQ_QUESTION_visitorcookies\n", 
"  \"Can {PRODUCT_NAME} count visitors using cookies, rather than unique hostnames?\"\n", "FAQ_SHORT_ANSWER_visitorcookies\n", 
"  \"Yes--it includes a built-in log format to do this for Apache, and other servers can be set up manually.\"\n", 
"FAQ_LONG_ANSWER_visitorcookies\n", "\"Yes.  The reason you'd want to do this is that using unique browsing hostnames\n", 
"(or IPs) to count visitors is an imprecise method, since the same actual visitor may \n", "appear to come from several hostnames--the same person may dial up and receive \n", 
"random IP addresses, or in some extreme cases, their ISP may be set up so that they \n", "have a different IP address for each hit, or several actual visitors may \n", 
"appear as one hostname if they're all using the same proxy.  The solution to this \n", "problem is to set your web server to use cookies to keep track of visitors.\n", 
"Apache and IIS can be configured to do this, and in both cases, {PRODUCT_NAME} can \n", "be configured to use the cookie visitor, instead of the hostname, as its %22visitor id%22. \n", 
"The {PRODUCT_NAME} configuration is generally quite simple--you create a new filter that copies \n", 
"the visitor cookie to the %22visitor id%22 field, and {PRODUCT_NAME} handles the rest (see below for an example).<p>\n", 
"<h4>Using Cookie-based Visitors IDs in Apache</h4>\n", "In the case of Apache, it's even easier, because {PRODUCT_NAME} includes a log format descriptor \n", 
"for a special %22combined format plus visitor cookie%22 log format.  The format is just \n", "normal combined format, with the visitor ID stuck at the front of each log entry.  You can log in this format \n", 
"by adding the following lines to your httpd.conf file:<p>\n", "<pre>  CookieTracking on\n", "  CookieExpires %222 weeks%22\n", 
"  CustomLog /var/log/httpd/cookie.log %22%{QUOTE:%7Bcookie}n} %h %l %u %t \\%22%r\\%22 %>s %b \\%22%{QUOTE:%7BReferer}i}\\%22 \\%22%{QUOTE:%7BUser-Agent}i}\\%22%22</pre>\n", 
"(replace /var/log/httpd/cookie.log above with the pathname of the log you want to create).\n", "When you point {PRODUCT_NAME} at this log file, it will recognize it as an %22Apache Combined With Visitor Cookies%22\n", 
"log, and it will set up the log filter described above for you, so you don't have to do any \n", "manual configuration at all.<p>\n", 
"<h4>Using Cookie-based Visitors IDs in IIS</h4>\n", "IIS has built-in support for visitor cookies-- just turn on logging of the Cookie\n", 
"field (extended property), or tell IIS to use %22W3C Extended Log File Format%22 for logging, and you'll\n", 
"get cookies in your log data.  Once you've done, that, set up a filter to extract\n", "visitor cookies into the visitor ID field (below), and you're done.<p>\n", 
"<h4>An Example Filter For Extracting Cookies</h4>\n", "If your cookie field contains more than just a visitor ID, you'll need to extract \n", 
"the visitor ID part of the field, and put it in {PRODUCT_NAME}'s %22visitor id%22 log field. \n", "This can be done using a regular expression filter with variable replacement.  For \n", 
"example, suppose that the cookie field value looks like this:<p>\n", "<pre>  var1=value1&var2=value2&userid=123456789&var3=value3</pre>\n", 
"The userid cookie (the visitor id, 123456789 in this case) is buried inside the field, surrounded\n", 
"by other cookie names and values.  To extract it you need a filter that grabs the part after userid= \n", 
"and before &.  This can be done most easily with the following filter:<p>\n", "<ol>\n", "  match the cookie field value to the regular expression %22&userid=({QUOTE:[^&]}*)&%22, and if it matches set the visitor id field to %22$1%22, replacing variables\n", 
"</ol>\n", "(for IIS, the value in quotes will be {QUOTE:ASPSESSIONID[A-Z]*=([^&]*)}.\n", "This filter finds a section of the field starting with &userid=,\n", 
"followed by a series of non-& characters, followed by a &,\n", "and it sets the visitor id to the sequence of non-& characters it found (123456789, in this case).\n", 
"Here's how you can add this filter to your configuration:<p>\n", "<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", 
"  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> If the first Log Filter is one that copies the hostname field to the visitor id field,\n", 
"       click the light blue triangle to edit it-- you will be replacing this filter with a different one.\n", 
"       Otherwise, click the double-square icon next to the first filter to duplicate it-- you will be\n", 
"       creating a new filter (make sure there are no other filters which set the visitor id field).<p>\n", 
"  <li> Click the blue triangle next to the first filter to edit it.<p>\n", "  <li> Choose %22Do B%22 from the menu at the top of the filter.<p>\n", 
"  <li> Choose %22match field2 with regular expression value1, and set field1 to value2 using variables%22 from the B:Action menu.<p>\n", 
"  <li> Enter %22userid=({QUOTE:[^&]}*)%22 in the B:value1 field.  For IIS logs, use %22{QUOTE:ASPSESSIONID[A-Z]*=([^&]*)}%22.<p>\n", 
"  <li> Enter $1 in the B:value2 field.<p>\n", "  <li> Choose %22visitor id%22 from the B:field1 menu.<p>\n", 
"  <li> Choose %22cookie%22 from the B:field2 menu.<p>\n", "  <li> Click the blue triangle to collapse the filter, and make sure the English description of the filter looks like the one above.<p>\n", 
"  <li> Click the %22Back To Configuration Menu%22 button.<P>\n", "  <li> Click the %22Rebuild Database From Log Source%22 button.<p>\n", 
"</ol>\n", "That's it--{PRODUCT_NAME} is now using the userid value from your cookie field as \n", "your visitor id, which should make your visitors counts more accurate.<p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_netscapecrash \"Netscape Crash Bug\"\n", "FAQ_QUESTION_netscapecrash\n", 
"  \"When I run {PRODUCT_NAME} via Netscape Navigator in CGI mode,\n", "  Netscape crashes after showing twenty or so %22progress pages.%22\n", 
"  What's going on?\"\n", "FAQ_SHORT_ANSWER_netscapecrash\n", "  \"This is a bug in Netscape.  Turn off progress pages, turn up the interval between them,\n", 
"  or use Internet Explorer or Netscape 6.\"\n", "FAQ_LONG_ANSWER_netscapecrash\n", "\"In CGI mode, {PRODUCT_NAME} uses a browser/server feature called\n", 
"%22server push%22 to provide progress indication pages.\n", "(When {PRODUCT_NAME} is running its own web server, it uses %22client pull%22 instead,\n", 
"and this discussion does not apply).\n", "This feature is supported by Netscape Navigator, but is not supported by\n", 
"Internet Explorer, so {PRODUCT_NAME} only uses it when it detects Netscape.\n", "Unfortunately, Netscape has a bug that causes it to crash after receiving\n", 
"about twenty %22server push%22 pages.\n", "Though most configurations will not generate this many pages,\n", 
"if you have a large amount of log data or a slow server, you\n", "may find Netscape crashing as {PRODUCT_NAME} processes your configuration.\n", 
"This is <b>not</b> a bug in {PRODUCT_NAME}; it is your browser (Netscape)\n", "that is crashing, not {PRODUCT_NAME} ({PRODUCT_NAME} will continue to run after the browser crashes).\n", 
"There are several workarounds for this problem:<p>\n", "<ul>\n", "  <li> Turn off progress pages.  The option to do this is available in\n", 
"       any interview except the Quick Browse Log interview.<p>\n", "  <li> Turn up the interval between progress pages until the total number of pages\n", 
"       is small enough that Netscape does not crash.  The option to do this is available in\n", "       any interview except the Quick Browse Log interview.<p>\n", 
"  <li> Use Mozilla Navigator (<a href=%22http://www.mozilla.org/%22>http://www.mozilla.org/</a>),\n", 
"       if you can get it running on your system.  Our tests show that the problem is fixed\n", "       in the latest version.<p>\n", 
"  <li> Use Internet Explorer (but you'll lose the option to have progress pages in CGI mode).<p>\n", 
"  <li> Use the command line or AppleScript to run lengthy configurations.<p>\n", "</ul>\"\n", "\n", 
"\n", "\n", "\n", "FAQ_TITLE_robotstxt \"robots.txt\"\n", "FAQ_QUESTION_robotstxt\n", "  \"Why do I see hits on a file called %22robots.txt%22 in my statistics?\"\n", 
"FAQ_SHORT_ANSWER_robotstxt\n", "  \"robots.txt is a file that tells search engine spiders and robots what they can do, so a hit on robots.txt means that a spider visited your site.\"\n", 
"FAQ_LONG_ANSWER_robotstxt\n", "\"robots.txt is a %22standard%22 file that appears at the root level of many web sites to tell\n", 
"search engine robots what to do on the site.\n", "Robots, also known as spiders, are computer programs that\n", 
"attempt to systematically visit and catalog all the\n", "pages on the Web.\n", "robots.txt tells the robots what they can or can't do on the site (whether they can index the site,\n", 
"which pages they may not index, etc.).  Any correctly written robot will hit\n", "that page first, and follow the instructions it finds there.\n", 
"So the hits you're seeing are from robots.<p>\n", "\n", "If you don't have a robots.txt file on your site, the robots don't actually get\n", 
"any information--they get a %22404 File Not Found%22 error instead, which they generally\n", "interpret as %22index whatever you want.%22\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_favicon \"favicon.ico\"\n", "FAQ_QUESTION_favicon\n", "  \"Why do I see a hits on a file called %22favicon.ico%22 in my statistics?\"\n", 
"FAQ_SHORT_ANSWER_favicon\n", "  \"favicon.ico is a special icon file that Internet Explorer looks for when it first visits the site.\"\n", 
"FAQ_LONG_ANSWER_favicon\n", "\"Recent versions of Microsoft Internet Explorer have a feature that lets\n", 
"web site owners define their own icons in Internet Explorer's Favorites menu. \n", "If you create an icon file called favicon.ico in a directory of your web site, \n", 
"then any page in that directory that is bookmarked will appear in the Favorites menu \n", "with your custom icon.  Internet Explorer checks for this file whenever a bookmark is \n", 
"created, so if you don't have the file, it will show up as a 404 (file not found) link. \n", "As a side note, this is a good way to see who is bookmarking your site.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_statview \"Statistics Users\"\n", "FAQ_QUESTION_statview\n", "  \"How do I provide users access to {PRODUCT_NAME} statistics output?\"\n", 
"FAQ_SHORT_ANSWER_statview\n", "  \"Qualify the the {PRODUCT_NAME} URL with \'?view+configname\', where configname is the name of the configuration that provides their statistics\"\n", 
"FAQ_LONG_ANSWER_statview\n", "\"For example if the {PRODUCT_NAME} Administrative URL is http://adminaddr ,\n", 
"users of the statistics can type http://admitaddr?view+configname can go straight the statistics views. \n", 
"For additional information on this item see 'Sending the Statistics to your Users' section\n", "of the [docs-multipleusers] of the documentation. You will also want to see [docs-security] of the documentation.\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_shortlongterm \"Short- and Long-term Databases\"\n", "FAQ_QUESTION_shortlongterm\n", 
"  \"How do I get high detail for recent hits, and also long-term statistics, without using too much disk space?\"\n", 
"FAQ_SHORT_ANSWER_shortlongterm\n", "  \"Use two databases, one for high-detail short-term data, and one for low-detail long-term data.\"\n", 
"FAQ_LONG_ANSWER_shortlongterm\n", "\"A common problem encountered by {PRODUCT_NAME} users is the conflict between wanting to \n", 
"see all possible statistics, and wanting to be able to generate the database in \n", "a reasonable amount of time, memory, and disk space.  With large web sites, \n", 
"it is often impossible to have both of these things--you probably don't have the \n", "computing power to fully analyze your multi-gigabyte logs and still have full detail \n", 
"on ten database fields.  One easy solution to this problem is to have two databases \n", "(two configurations).<p>\n", 
"\n", "The first, the %22all data%22 configuration, \n", "represents your entire log but with significant limitations \n", 
"on the fields (perhaps only the top two levels of the hostname field, the top two levels \n", "of the referrer, date/time to the day level only, etc.).<p> \n", 
"\n", "The second, the %22recent data%22 configuration, includes a filter to discard all \n", "log entries older than a day, or a week, or a month, depending on how recent you want it \n", 
"and how much data you get in a day.  The %22recent data%22 configuration, since it \n", "has fewer log entries in it, can have much more detailed information; the date/time \n", 
"can go to the second level, all the hostnames can be there (for full visitor information), \n", "etc.<p>\n", 
"\n", "Using this technique, you'll end up with two views of your log data.  For long-term trends, \n", 
"you can use the %22all data%22 configuration.  For recent access information, in detail, \n", "you can use the %22recent data%22 configuration.  The combined size and processing time \n", 
"of the two configurations will be much lower than if they were combined into one with the \n", "duration of %22all data%22 and the depth of %22recent data.%22\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_zoomfarther \"Zooming Farther\"\n", "FAQ_QUESTION_zoomfarther\n", "  \"How do I see more levels of statistics (i.e. how can I zoom in further)?\"\n", 
"FAQ_SHORT_ANSWER_zoomfarther\n", "  \"Increase the %22suppress below%22 level for this field in the {CATEGORY_NAME_database_fields} tab of the Configuration options.\"\n", 
"FAQ_LONG_ANSWER_zoomfarther\n", "\"{PRODUCT_NAME} limits the number of levels you see by default\n", 
"to save memory, disk space, and time.  You can increase the levels \n", "on any database field like this:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the {CATEGORY_NAME_database_fields} tab.<p>\n", 
"  <li> Increase the %22Suppress levels below%22 value for the field.<p>\n", "  <li> Click the %22Back To Configuration Menu%22 button at the top of the page.<p>\n", 
"  <li> Click the %22Rebuild Database From Log Source%22, and click Next when it asks you if you're sure.<p>\n", 
"</ol>\n", "Then you'll be able to see as many levels \n", "as you chose.  See also [docs-resources].<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_datatypes \"Hits, Visitors, etc.\"\n", "FAQ_QUESTION_datatypes\n", "  \"What are %22hits%22?  What are %22page views%22?  What is %22bandwidth%22?  What are %22visitors%22?  What are %22sessions%22?\"\n", 
"FAQ_SHORT_ANSWER_datatypes\n", "  \"Hits are accesses to the server; page views are accesses to HTML pages; visitors are unique \n", 
"  visitors to the site, and sessions are visits to the site.\"\n", "FAQ_LONG_ANSWER_datatypes\n", "\"{PRODUCT_NAME} can count traffic in several ways.  Each way is counted independently of \n", 
"the others, and each has its own advantages in analyzing your traffic.  The \n", "different types are:<p>\n", 
"<ul>\n", "  <li> <b>Hits</b>.  Hits are accepted log entries.  So if there are 5000 entries \n", "       in your log file, and there are no log filters, and all the entries are valid \n", 
"       (i.e. none of them have corrupt dates), then {PRODUCT_NAME} will report 5000 hits for the file. \n", 
"       If there are log filters that reject certain log entries, then those will \n", "       not appear as hits.  Log entries that are accepted, either using %22accept as hits%22 \n", 
"       or using %22accept as page view%22 will count toward the hits totals. \n", "       Because there are no default filters that reject, you will generally have nearly \n", 
"       as many reported hits as you have log entries.  You can view and edit the log filters \n", "       by Opening your configuration from the Administrative Menu, clicking Configuration Options, \n", 
"       and then clicking the Log Filters tab.  See also [docs-filters].<p>\n", "  <li> <b>Page views</b>.  Page views correspond to hits on pages.  For instance, \n", 
"       if you're analyzing a web log, and a hit on index.html is followed by 100 hits \n", "       on 100 images, style sheets, and JavaScript files, that appear in that page, \n", 
"       then it will count as a single page view--the secondary files do not add to the total. \n", 
"       This is implemented in the log filters--page views are defined as log entries \n", "       that are accepted by a log filter %22as page views.%22  Log entries that are \n", 
"       accepted by the filters, but are accepted %22as hits%22 rather than %22as page views%22 \n", 
"       do not contribute to the page views total.  Therefore, you have complete control over \n", "       which files are %22real%22 page views and which are not--if {PRODUCT_NAME}'s default filters \n", 
"       do not capture your preferred definition of page views, you can edit them until they do. \n", 
"       By default, page views are all hits that are not GIFs, JPEGs, PNGs, CCSs, ICOs, SWFs, JSs, or .class files.\n", 
"       See Hits, above, for more information on log filters.<p>\n", "  <li> <b>Visitors</b>.  Visitors correspond roughly to the total number of people who \n", 
"       visited the site.  If a single person visits the site and looks at 100 pages, \n", "       that will count as 100 page views, but only one visitor.  By default, {PRODUCT_NAME} defines visitors \n", 
"       to be %22unique hosts%22--a hit is assumed to come from a different visitor if it comes \n", 
"       from a different hostname.  This can be inaccurate due to the effects of web caches \n", "       and proxies.  Some servers can track visitors using cookies, and if your web logs contain \n", 
"       this information, {PRODUCT_NAME} can use it instead of hostnames--just change the log filter \n", 
"       that copies the hostname field to the visitor id field, so it copies the cookie field instead.<p>\n", 
"  <li> <b>Bandwidth</b>.  Bandwidth is the total number of bytes transferred.  \n", "       It is available only in log formats that track bytes transferred.  Bandwidth \n", 
"       is tracked for every log entry that is accepted, whether it is accepted %22as a hit%22 \n", 
"       or %22as a page view%22.<p>\n", "  <li> <b>Sessions</b>.  Several of {PRODUCT_NAME}'s views deal with %22session%22 information, including \n", 
"       the %22sessions overview%22 and the %22paths through the site%22 view.  Sessions are similar \n", 
"       to visitors, except that they can %22time out.%22  When a visitor visits the site, and \n", 
"       then leaves, and comes back later, it will count as two sessions, even though it's only \n", 
"       one visitor.  To reduce the effect of caches that look like very long sessions, \n", "       {PRODUCT_NAME} also discards sessions longer than a specified time.  The timeout interval is \n", 
"       also customizable.<p>\n", "</ul>\"\n", "\n", "\n", "\n", "FAQ_TITLE_nonaccesslogs \"Referrer, Agent, and Error Logs\"\n", 
"FAQ_QUESTION_nonaccesslogs\n", "  \"How do I see referrer (referring URL, search engines, and search terms), agent (browser and OS), or error statistics?\"\n", 
"FAQ_SHORT_ANSWER_nonaccesslogs\n", "  \"Use %22extended%22 or %22combined%22 log format to see referrer and agent information, or analyze the log files with a separate configuration.  For error logs, analyze them with a separate configuration.\"\n", 
"FAQ_LONG_ANSWER_nonaccesslogs\n", "\"Different log formats contain different types of information.\n", 
"All major web log formats include page, date/time, and browsing host information, \n", "but not all contain referrer and agent information.  If your log format does not \n", 
"include referrer or agent information, {PRODUCT_NAME} will not include that information in its database. \n", 
"The easiest way to get referrer or agent information \n", "is to change your web server's log format to an %22extended,%22 or %22combined%22 \n", 
"format, which includes referrer and agent information; then {PRODUCT_NAME} will automatically include \n", 
"referrer and agent information in the database and in the statistics.<p>\n", "\n", "If it's not possible to change your log format, and you have a separate referrer log \n", 
"(often called <code>referer_log</code>), then you can analyze that log directly with \n", "{PRODUCT_NAME}.  Just point {PRODUCT_NAME} at the log, and {PRODUCT_NAME} should recognize it as a referrer log.\n", 
"{PRODUCT_NAME} will show statistics with referrer and page information.\n", "Host and date/time information are not available in a standard referrer log, so \n", 
"referrer and page is all {PRODUCT_NAME} can extract.  By using an extended or combined log format, you \n", 
"will be able to do more powerful queries, for instance to determine the referrers in \n", "the most recent week.<p>\n", 
"\n", "Similarly, if you can't configure your server to use extended or combined, \n", "but you have a separate agent log, you can analyze it with {PRODUCT_NAME} by \n", 
"creating a separate configuration that analyzes the agent (web browser and \n", "operating system) information only. \n", 
"Since an agent log \n", "contains only agent information, you won't be able to cross-reference the agent \n", 
"information with page, date/time, host, referrer, or anything else; to do that, \n", "you'll need an extended or combined format log.<p>\n", 
"\n", "To analyze error information, you'll need an error log (often called <code>error_log</code>). \n", 
"Just point {PRODUCT_NAME} at your error log when you create the configuration.  Since the \n", "error log contains only error messages, you won't be able to cross-reference the errors \n", 
"against page, date/time, or any other fields; if you need cross-referencing of errors, \n", "you may be able to get what you need by cross-referencing the %22server response%22 field of your \n", 
"normal web log to the fields you need cross-referenced; then apply %22404%22\n", "as a filter on the server response field \n", 
"and you'll see only those web site hits that generated \n", "404 (file not found) errors.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_enginesbyphrases \"Search Engines by Search Phrases\"\n", "FAQ_QUESTION_enginesbyphrases\n", 
"  \"How can I get top search terms by search engines?  I would like to know what keywords people\n", 
"  are entering when they using yahoo, goto etc.\"\n", "FAQ_SHORT_ANSWER_enginesbyphrases\n", "  \"Yes, cross-reference search engines by search phrases and use the Filters.\"\n", 
"FAQ_LONG_ANSWER_enginesbyphrases\n", "\"Yes, {PRODUCT_NAME} can do this; just cross-reference the search engines field by the \n", 
"search phrases field, and then use a filter on the search engines field in the \n", "search phrases view.  Here's how:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Database Xrefs tab.<p>\n", 
"  <li> Check the box that lines up with %22search engine%22 and %22search phrase.%22<p>\n", "  <li> Click the %22Back to Configuration Menu%22 button at the top of the page.<p>\n", 
"  <li> Click %22Rebuild Database From Log Source%22 to rebuild your database with the new cross-referencing.<p>\n", 
"  <li> Click View Statistics.<p>\n", "  <li> Click the %22top search engines%22 button to go to the top search engines view.<p>\n", 
"  <li> Choose %22show filters checkboxes and menu%22 from the Options menu at the bottom of the page.<p>\n", 
"  <li> Check the box next to Yahoo (or whichever search engine you're interested in).<p>\n", "  <li> Choose %22show checked items in the 'top search phrases'%22 view from the Filters menu under the table.<p>\n", 
"</ol>\n", "That will show you a table of search phrases, with a search engines filter so \n", "only Yahoo search phrases are visible.<p>\n", 
"You can do a similar trick with any other database fields.<p>\"\n", "\n", "\n", "\n", "FAQ_TITLE_topfieldsforfield \"Finding the Top (field) for a Particular (field)\"\n", 
"FAQ_QUESTION_topfieldsforfield\n", "  \"How can I see the top (insert field here) for each (insert field here)? \n", 
"  For instance, how can I see the pages hit by particular visitor?  Or the top \n", "  visitors who hit a particular page?  Or the top referrers for a particular day, \n", 
"  or the top days for a particular referrer?  Or the top search phrases for a search engine, \n", "  the top authenticated users for a directory, the top directories accessed by an authenticated user, etc.?\"\n", 
"FAQ_SHORT_ANSWER_topfieldsforfield\n", "  \"Cross-reference the two fields to each other, add a filter for the item you're interested, and switch to the view you want.\"\n", 
"FAQ_LONG_ANSWER_topfieldsforfield\n", "\"{PRODUCT_NAME} can answer this sort of questions for any combination of fields.  What you \n", 
"need to do is cross-reference the two fields you're interested in, then use the statistics Filters \n", 
"to zoom in on the item you want specific information for, and finally switch to the view that \n", 
"shows the data you want.  Here's exactly how you do it:<p>\n", "<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", 
"  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Database Xrefs tab.<p>\n", 
"  <li> Check the box that lines up the two fields you're interested in.\n", "       For instance, if you want to see the top search phrases for a particular search engine,\n", 
"       check the box that lines up with %22search phrase%22 and also lines up with %22search engine.%22\n", 
"       It will line up vertically with one of them, and horizontally with the other.<p>\n", "  <li> Click the %22Back to Configuration Menu%22 button at the top of the page.<p>\n", 
"  <li> Click %22Rebuild Database From Log Source%22 to rebuild your database with the new cross-referencing.<p>\n", 
"  <li> Click View Statistics.<p>\n", "  <li> Click the view for the field you want to select a single item from.  For instance, if you want to see \n", 
"       the top search phrases for a particular search engine, go to the %22Top search engines%22 view.<p>\n", 
"  <li> Click the item you're interested in (this applies a filter, so you'll only see hits on that item).<p>\n", 
"  <li> Switch to the view corresponding to the type of information you're looking for.  For instance, if you want to see the \n", 
"       top search phrases for a particular search engine, click %22Top search phrases.%22<p>\n", "</ol>\n", 
"That will show you the top items you're looking for, but with the filter in place \n", "(as you can see in the Filters bar at the top of the page) so you only see the items corresponding to\n", 
"the particular item you checked.  For instance, if you're looking for the top search phrases for a particular search engine, \n", 
"the Filters bar will show you that the hits you're seeing are only those from that search engine, \n", 
"and the table will show you the top search phrases for those hits.<p>\n", "You can do more than this--if you wish, you can apply multiple filters from multiple fields, \n", 
"for instance to see the top search phrases for a particular search engine in the year 2000. \n", "In that case, you will need to cross-reference the date/time field with the search phrases and search engine \n", 
"field as well.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_sessionsforpage \"Sessions For A Particular Page\"\n", 
"FAQ_QUESTION_sessionsforpage\n", "  \"How can I see only the visitors that entered at a particular page, or\n", 
"  only the visitors that hit a particular page at some point in their session?\"\n", "FAQ_SHORT_ANSWER_sessionsforpage\n", 
"  \"Add that page as a Session Filter; then the session-related views will only show sessions including that page.\"\n", 
"FAQ_LONG_ANSWER_sessionsforpage\n", "\"Edit the Session Filters, which appear in a bar at the top of the session-related\n", 
"views (sessions summary, paths through the site, entry/exit pages, time per page, and individual sessions).\n", 
"Click on %22{SESSION_FILTERS_CONTAINS_LABEL}%22, and then select the page you're interested in\n", 
"from the menu there.  Apply the filters.  Now the session statistics will only show \n", "sessions which went through that page at some point (it could be the entry page, the exit page, or\n", 
"a page they went through in the middle of their session).  This can be useful for determining, for instance, \n", 
"the behavior of visitors who eventually visited your %22thank you for ordering%22 page (i.e. paying customers).<p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_sessionsforusername \"Sessions For A Particular Username\"\n", 
"FAQ_QUESTION_sessionsforusername\n", "  \"My session information (paths through the site, entry/exit pages, etc.) shows the IP addresses\n", 
"  and hostnames of users.  How can I show their usernames instead?\"\n", "FAQ_SHORT_ANSWER_sessionsforusername\n", 
"  \"Edit the Log Filter that sets the visitor id field, so it sets it to the username instead of the IP/hostname.\"\n", 
"FAQ_LONG_ANSWER_sessionsforusername\n", "\"<p>Session information is based on the %22visitor id%22 field-- each session comes from\n", 
"a particular visitor, and visitors are distinguished using the visitor id.\n", "By default, {PRODUCT_NAME} generally uses the source IP or hostname field to set the\n", 
"visitor id, so session information shows source IP or hostname information.  If you\n", "want it to show username information instead, and if you have username information\n", 
"in your log data, you need to change the Log Filter that sets the visitor id,\n", "so it uses the username field to set it.  Here's how:</p>\n", 
"<ol>\n", "<li><p>Open your configuration from the Administrative Menu.</p></li>\n", "<li><p>Click %22Configuration Options%22.</p></li>\n", 
"<li><p>Click the Log Filters tab.</p></li>\n", "<li><p>Find the Log Filter that is setting the visitor id field; it will look something like %22copy the hostname field value to the visitor id field%22, and it is often the first Log Filter in the list.  Expand that Log Filter by clicking the blue triangle to the left of it.</p></li>\n", 
"<li><p>Choose the field you want to use as your visitor id field, from the B:field2 menu.  For instance, if you want the %22authenticated user%22 values to appear in the session statistics, choose %22authenticated user%22 from that menu.</p></li>\n", 
"<li><p>Click the %22Back To Configuration Menu%22 button at the top of the page.</p></li>\n", "<li><p>Click %22Rebuild Database From Log Source%22 to erase your database and rebuild it from the log data, using the new field as the visitor id.</p></li>\n", 
"</ol>\n", "<p>Now view the statistics.  All session information should show usernames instead of hostnames.</p>\n", 
"<p>If you now want to see session information for a single user, do this:</p>\n", "<ol>\n", "<li><p>In the statistics, click %22Individual Session(s)%22.</p></li>\n", 
"<li><p>Click %22edit%22 in the Sessions Filters bar at the top of the page.</p></li>\n", "<li><p>Check the %22Session comes from visitor id%22 box, and choose the username you're interested in from the menu below that box.</p></li>\n", 
"<li><p>Click %22Apply Filter%22.</p></li>\n", "</ol>\n", "Now you're zoomed in on that user, so all the session information shows you only the sessions for\n", 
"that user.  The Individual Sessions view will show you all sessions from that user, and if you\n", 
"click a particular session, you can see every page that user hit in that session,\n", "and when they hit it, click-by-click.</p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_sessionsforsearchengine \"Sessions For A Particular Search Engine\"\n", 
"FAQ_QUESTION_sessionsforsearchengine\n", "  \"How can I see only the visitors that came from a particular search engine?\"\n", 
"FAQ_SHORT_ANSWER_sessionsforsearchengine\n", "  \"Direct that search engine to a particular entry page, and then use Session Filters to see sessions for that page.\"\n", 
"FAQ_LONG_ANSWER_sessionsforsearchengine\n", "\"Some information of this type is available in the %22Top search engines%22 view-- you can\n", 
"zoom in on a particular search engine by clicking its name there, and then switch to the top \n", "hosts view to see which hosts came from that search engine, and other information about the traffic\n", 
"from that search engine.  But that only works for the first click, because after that, the log data no\n", 
"longer lists the originating search engine (the referrers are internal from that point on).  So you can\n", 
"see how much traffic search engines brought, but what if you want to see what the visitors from a\n", 
"particular search engine did after they came to the site?<p>\n", "You can do that by using custom entrance pages and Session Filters.  Start by \n", 
"pointing each search engine to its own URL, where possible.  For instance, instead of\n", "pointing Overture to http://www.mysite.com/index.html, you can point it to http://www.mysite.com/index.html?source=overture\n", 
"Once you've done that, then all traffic from Overture will initially arrive at the /index.html?source=overture\n", 
"page.  By showing only sessions containing that page (see [faq-sessionsforpage]), you can\n", "show the session activity of Overture visitors, including what paths they took, how long they stayed, and more.<p>\n", 
"You can do the same thing for any search engine, advertising campaign, or link exchange that allows\n", 
"you to choose your URL.  It won't work for broad search engines like Google, which let people enter\n", 
"your site at any point.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_conversions \"Tracking Conversions\"\n", 
"FAQ_QUESTION_conversions\n", "  \"I want to track conversions-- i.e. I want to know which of my ads are actually resulting\n", 
"  in sales.  Can {PRODUCT_NAME} do that?\"\n", "FAQ_SHORT_ANSWER_conversions\n", "  \"Yes-- encode source information in your URLs and use Session Filters to show the top entry pages for your %22success%22 page.\"\n", 
"FAQ_LONG_ANSWER_conversions\n", "  \"If you advertise your web site, one of the most useful pieces of information you can get from\n", 
"{PRODUCT_NAME} is information on %22conversions%22; i.e. how effective your ads are at actually\n", 
"generating sales, sign-ups, or whatever it is that makes your site a success.  {PRODUCT_NAME} can \n", 
"provide highly detailed conversion information with a little effort.  Here's how you do it:<p>\n", 
"<ol>\n", "<li><p> Make sure that every entry page in your statistics is tagged with\n", "information that tells you which search engine and search phrase was used.\n", 
"This can be done manually, by using separate URLs for each search engine and\n", "keywords (e.g. for Overture keywords %22red umbrellas%22 use\n", 
"http://www.mysite.com/?source=overture&keywords=red+umbrellas), but it is usually\n", "easier to do it automatically by creating special Log Filters that add the search\n", 
"engine and keywords to the end of your page field.  This can be done in the Log Filters\n", "tab of the Configuration Options, and first filter will look liks this:<br>\n", 
"<p><i>if the search engine field starts with %22(%22<br />\n", "then continue on to the next filter<br />\n", 
"otherwise concatenate %22%22, the value of the page field, %22?se=%22, and the value of the search engine field, and put the result in the page field</i></p>\n", 
"<p>The specific values for the filter are:<br /><br />\n", "type: <i>If A is true then do B; otherwise do C</i><br />\n", 
"A:Operation: <i>value1 starts with values</i><br />\n", "A:value1: choose <i>search engine</i> from the menu; leave the field blank.<br />\n", 
"A:value2: choose </i>this value:</i> from the menu; enter <i>(</i> in the field.<br />\n", "B:Action: <i>goto next filter</i><br />\n", 
"C:Action: <i>concatentate value1, field1, value2, and field2 into field1</i><br />\n", "C:value1: leave this blank<br />\n", 
"C:value2: <i>?source=</i><br />\n", "C:field1: <i>page</i><br />\n", "C:field2: <i>search engine</i><br /></p>\n", 
"<p>Now create a second filter, identical to this one but using %22<i>search phrase</i>%22<br />\n", 
"instead of %22<i>search engine</i>%22 and using <i>+keywords=</i> for C:value2 instead of <i>?source=</i>.\n", 
"<p><font color=%22#ff0000%22>These filters must be <i>after</i> the %22(parameters)%22 filter\n", "or the %22(parameters)%22 filter will strip off the values just added.</p>\n", 
"<p>These filters will use the search engine and search phrase values detected\n", "by {PRODUCT_NAME}, which means you need to have a referrer field in your log data\n", 
"for these filters to work.</p>\n", "</li>\n", "\n", "<li><p> Create a configuration from your log data, making sure you check the\n", 
"%22Track sessions information%22 box.</p></li>\n", "\n", "<li><p> View the statistics.</p></li>\n", 
"\n", "<li><p> Go to the %22Entry pages%22 view in your statistics.  You should see all\n", "your full URLs there, with percentages if you want, which will tell\n", 
"you how much traffic each ad brought to your site.  For instance, if\n", "you see that you got 1000 entries to the\n", 
"http://www.mysite.com/?source=overture&keywords=red+umbrellas page,\n", "then you know that your Overture ad for %22red umbrellas%22 brought 1000\n", 
"hits.  That's useful information, but not conversion information-- the\n", "cames next.</p></li>\n", 
"\n", "<li><p> Edit the Session Filters at the top of the page, and set the Session\n", "Filters to show only sessions that went through your %22success%22 page.\n", 
"This is the page that people see after they've done whatever you\n", "wanted them to do.  For instance, if success for you means a sale,\n", 
"then this would be the %22thank you for your order%22 page.  If success\n", "means that they sign up, this is the %22you have signed up%22 page.  If\n", 
"success means that they submitted a feedback form, this is the %22thanks\n", "for your feedback page.%22</p></li>\n", 
"\n", "<li><p> Now you're looking at the %22Entry pages%22 view, but it's been filtered\n", "to show only those sessions which eventually %22converted.%22  This is\n", 
"exactly what you want to know-- if you see 100 entrances at\n", "http://www.mysite.com/?source=overture&keywords=red+umbrellas , when\n", 
"you know that 100 visitors found your site from your %22red umbrellas%22\n", "ad on Overture, and eventually hit your success page later in the same\n", 
"session.  This is pure marketing gold-- by comparing the total cost of\n", "the ad (e.g. if each click is $0.10, and there were 1000 total clicks,\n", 
"then you spent $100 on that keyword), with the total payout of the ad\n", "(e.g. if each %22success%22 is worth $5, then you know you made $500 from\n", 
"the 100 successful %22red umbrellas%22 clicks), you can tell whether the\n", "ad is worth it.  In this example, you paid $100 for the ad and get\n", 
"$500 in sales from it-- keep that one running!</p></li>\n", "\n", "</ol>\n", "\"\n", "\n", "\n", "\n", 
"FAQ_TITLE_dynamicurls \"Dynamic URLs\"\n", "FAQ_QUESTION_dynamicurls\n", "  \"My web site uses dynamic URLs instead of static pages; i.e. I have lots of machine-generated URLs\n", 
"  that look like /file?param1=value1&param2=value2....  Can {PRODUCT_NAME} report on those?\"\n", "FAQ_SHORT_ANSWER_dynamicurls\n", 
"  \"Yes, but you need to delete the %22(parameters)%22 log filter first.\"\n", "FAQ_LONG_ANSWER_dynamicurls\n", 
"\"{PRODUCT_NAME} can handle URLs/pages in any format, but by default it strips\n", "off the parameters (the part after the question mark) to save space in the database.\n", 
"most people don't need the parameters, but if you have a dynamic web site, you do.\n", "to see the parameters, do this:<p>\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration.<p>\n", "  <li> Click Configuration Options.<p>\n", 
"  <li> Click the Log Filters tab.<p>\n", "  <li> Click the red x next to the filter that refers to %22(parameters)%22 to delete that filter.<p>\n", 
"  <li> Click the %22Back To Configuration Menu%22 button at the top of the page.<p>\n", "  <li> Click Rebuild Database From Log Source, and click the button on the next page to erase and rebuild your database.<p>\n", 
"<ol>\n", "Now, when you look at the %22Top pages%22 or %22Top pages/directories%22 view, you should see\n", 
"your complete URLs, along with the parameters.<p>\n", "If you want to take it a step further, you can also set up log filters to extract certain\n", 
"sections of your URLs, and put them in custom fields, to make your statistics more\n", "readable.  For instance, if you have a store with several items in it, you can create an %22items%22\n", 
"field, with an associated %22Top items%22 view, and you can set up a log filter to extract the item\n", 
"number (or name) from the URL and put it in the %22items%22 field.  Or you can even set up a filter, \n", 
"perhaps using a rewrite rule (see [docs-rewriterules]) to extract the item numbers from your URLs,\n", 
"convert them to the actual name of the item, stick it in the %22item%22 field, and report it in the\n", 
"%22top items%22 view.  This is an example of a Content Group-- see [faq-contentgroups] for information\n", 
"on how to create one.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_languagemodules \"Language Modules--Localization and Customization\"\n", 
"FAQ_QUESTION_languagemodules\n", "  \"Is {PRODUCT_NAME} available in languages other than English?  How can I \n", 
"  change the output of {PRODUCT_NAME} to be in a different language, or to use \n", "  different wording?\"\n", 
"FAQ_SHORT_ANSWER_languagemodules\n", "  \"{PRODUCT_NAME} is currently available in English, Spanish, and Italian, and can be translated \n", 
"  into any language easily.  Customization of output text is also easy.\"\n", "FAQ_LONG_ANSWER_languagemodules\n", 
"\"{PRODUCT_NAME} has a feature designed for just this purpose, called Language Modules.\n", "Language modules are text files which contain all of the text that {PRODUCT_NAME} ever generates. \n", 
"You can translate part or all of {PRODUCT_NAME} into any language by modifying the language modules. \n", 
"Spanish and Italian translations already exists, and German and Danish translations are underway. \n", 
"Language modules can also be used to customize the output of {PRODUCT_NAME} in almost any conceivable way.\n", 
"For full details, see [docs-languagemodules] in the online manual.<p>\"\n", "\n", "\n", "\n", "FAQ_TITLE_runatstartup \"Running {PRODUCT_NAME} at System Startup\"\n", 
"FAQ_QUESTION_runatstartup\n", "  \"Can I set up {PRODUCT_NAME} to start automatically when the computer starts up?\"\n", 
"FAQ_SHORT_ANSWER_runatstartup\n", "  \"Yes; use Scheduled Tasks on Windows, Startup Items on MacOS 9, StartupItems under MacOS X, or the /etc/rc.d mechanism on UNIX systems that support it.\"\n", 
"FAQ_LONG_ANSWER_runatstartup\n", "\"{PRODUCT_NAME} can be configured to run at startup in the same way any other program can, \n", 
"and the exact method depends on your operating system.  Here's how:<p>\n", "<b>On Windows</b>:<p>\n", 
"<ol>\n", "  <li> From the Start menu, go to the Settings submenu and choose Control Panels.<p>\n", 
"  <li> Open the Scheduled Tasks control panel.<p>\n", "  <li> Double-click Add Scheduled Task.<p>\n", 
"  <li> Click the Next button.<p>\n", "  <li> Choose {PRODUCT_NAME} 6 from the list of programs (or browse for it if it doesn't appear), and click Next.<p>\n", 
"  <li> Click %22When my computer starts%22 and click Next.<p>\n", "  <li> Enter your username and password, and click Next.<p>\n", 
"  <li> Click Finish.<p>\n", "</ol><p>\n", "\n", "<b>On MacOS 9</b>:<p>\n", "<ol>\n", "  <li> Make an alias to the {PRODUCT_NAME} application (select the application Icon in the Finder, and choose Make Alias from the File menu).<p>\n", 
"  <li> Move the alias to the Startup Items folder of the System folder.<p>\n", "</ol>\n", "\n", "<b>On MacOS X</b>:<p>\n", 
"<ol>\n", "  <li> Install {PRODUCT_NAME} in its default location at /Applications/{PRODUCT_NAME}.<p>\n", 
"  <li> If the folder /Library/StartupItems does not exist, create it.<p>\n", "  <li> Copy the {PRODUCT_NAME} folder from /Applications/{PRODUCT_NAME}/Startup to /Library/StartupItems.\n", 
"</ol>\n", "\n", "<b>On a UNIX-type operating system</b>:<p>\n", "\n", "<ol>\n", "  <li> Install a script to start {PRODUCT_NAME} in /etc/rc.d (or /etc/init.d, or however your \n", 
"       UNIX variant does it).  A sample script, based on the Apache script, is available\n", "       <a href=http://www.flowerfire.com/sawmill/sawmill_etc_rcd.sh>here</a>.  The method varies \n", 
"       from UNIX to UNIX, but to give one specific example, in RedHat Linux 7.0 you should \n", "       call the script {PRODUCT_EXECUTABLE_DOCS}d and put it in /etc/rc.d/init.d, and then make symbolic links to \n", 
"       it from the rc0.d - rc6.d directories, encoding into the name of the link whether to Start \n", 
"       {PRODUCT_EXECUTABLE_DOCS} at that runlevel, or to Kill it.  A good sequence of links is the following:<p>\n", 
"<pre>  ln -s /etc/rc.d/init.d/{PRODUCT_EXECUTABLE_DOCS}d /etc/rc.d/rc0.d/K15{PRODUCT_EXECUTABLE_DOCS}d\n", 
"  ln -s /etc/rc.d/init.d/{PRODUCT_EXECUTABLE_DOCS}d /etc/rc.d/rc1.d/K15{PRODUCT_EXECUTABLE_DOCS}d\n", 
"  ln -s /etc/rc.d/init.d/{PRODUCT_EXECUTABLE_DOCS}d /etc/rc.d/rc2.d/K15{PRODUCT_EXECUTABLE_DOCS}d\n", 
"  ln -s /etc/rc.d/init.d/{PRODUCT_EXECUTABLE_DOCS}d /etc/rc.d/rc3.d/S85{PRODUCT_EXECUTABLE_DOCS}d\n", 
"  ln -s /etc/rc.d/init.d/{PRODUCT_EXECUTABLE_DOCS}d /etc/rc.d/rc4.d/S85{PRODUCT_EXECUTABLE_DOCS}d\n", 
"  ln -s /etc/rc.d/init.d/{PRODUCT_EXECUTABLE_DOCS}d /etc/rc.d/rc5.d/S85{PRODUCT_EXECUTABLE_DOCS}d\n", 
"  ln -s /etc/rc.d/init.d/{PRODUCT_EXECUTABLE_DOCS}d /etc/rc.d/rc6.d/K15{PRODUCT_EXECUTABLE_DOCS}d\n", 
"</pre>\n", "       If you're not sure where to put the {PRODUCT_NAME} links or what to call them, and you have \n", 
"       Apache installed on your system, look for files shows names contain <code>httpd</code>\n", "       in /etc/rc.d or /etc/init.d, and use the same names and locations for {PRODUCT_NAME}, replacing \n", 
"       <code>httpd</code> with <code>{PRODUCT_EXECUTABLE_DOCS}d</code>.<p>\n", "  <li> Rename the {PRODUCT_NAME} executable to <code>{PRODUCT_EXECUTABLE_DOCS}d</code> (or change the name \n", 
"       of the executable in the script) and put it in /bin or somewhere else in your \n", "       default path.<p>\n", 
"  <li> Put a symbolic link to LogAnalysisInfo in /etc/{PRODUCT_EXECUTABLE_DOCS}/LogAnalysisInfo \n", 
"       (or you can put the actual directory there), using the <code>ln -s</code> command, \n", "       e.g. <code>ln -s /usr/home/{PRODUCT_EXECUTABLE_DOCS}/LogAnalysisInfo /etc/{PRODUCT_EXECUTABLE_DOCS}/LogAnalysisInfo</code>\n", 
"       (you'll need to create the directory /etc/{PRODUCT_EXECUTABLE_DOCS} first).\n", "</ol>\n", "\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_runinbackground \"Running {PRODUCT_NAME} in the Background\"\n", "FAQ_QUESTION_runinbackground\n", 
"  \"When I run {PRODUCT_NAME} in a UNIX terminal window, and then close the window, {PRODUCT_NAME} \n", 
"  stops working.  What can I do about that?\"\n", "FAQ_SHORT_ANSWER_runinbackground\n", "  \"Add an ampersand (&) to the end of the command line to run it in the background.\"\n", 
"FAQ_LONG_ANSWER_runinbackground\n", "\"When you run {PRODUCT_NAME} from the command line in UNIX by just typing \n", 
"the name of the program, it runs in the foreground.  That means that \n", "you don't get your prompt back until {PRODUCT_NAME} exits, and it also means \n", 
"that if you close your terminal window, the {PRODUCT_NAME} server will terminate \n", "and you will not be able to use it anymore until you open another terminal window\n", 
"and restart {PRODUCT_NAME}.  Often, that's not what you want--you want {PRODUCT_NAME} to \n", "keep running after you close the window.  You can do that by running \n", 
"{PRODUCT_NAME} in the background.<p>\n", "To run {PRODUCT_NAME} (or any other UNIX program) in the background, \n", 
"add an ampersand (a & character) to the end of the command line; for instance, \n", "you might use the following command line:<p>\n", 
"<pre>  ./{PRODUCT_EXECUTABLE_DOCS} &</pre>\n", "if the name of your {PRODUCT_NAME} program is <code>{PRODUCT_EXECUTABLE_DOCS}</code>.\n", 
"When you type this, you will see one line of output as {PRODUCT_NAME} is backgrounded, \n", "and a few lines from {PRODUCT_NAME} describing the running web server, \n", 
"and then you will have your shell prompt back, so you can type more commands. \n", "At this point, {PRODUCT_NAME} is running in the background.  You can type <code>exit</code>\n", 
"at the prompt to close the shell, or you can just close the window, and {PRODUCT_NAME} \n", "will continue to run in the background.<p>\n", 
"On some rare occasions, {PRODUCT_NAME} may generate output to the shell console. \n", "This is not usually a problem, but on some systems, background programs that generate \n", 
"output may be suspended, and that can make {PRODUCT_NAME} inaccessible.  You prevent \n", "this from happening, you may want to use this command line instead:<p>\n", 
"<pre>  nohup ./{PRODUCT_EXECUTABLE_DOCS} &</pre>\n", "The %22nohup%22 part of the command line stands for %22no hang-up%22 and \n", 
"prevents this sort of output-related suspension problems. \n", "Unfortunately <code>nohup</code> doesn't exist on all systems.\n", 
"If you don't know if your system supports <code>nohup</code>, \n", "try including <code>nohup</code> on the command line--if it doesn't run that way, don't use it.<p>\n", 
"You can see current background jobs started from the current terminal using the <code>jobs</code> \n", 
"command (with most shells).  You can terminate a background job by bringing it to the front using the <code>fg</code>\n", 
"command and then using control-C, or using the <code>kill</code> command together with its process ID. \n", 
"You can find the process ID (pid) of any background process (including ones started in other windows) \n", 
"using the <code>ps</code> command.  For more information about any of these commands, use the <code>man</code> \n", 
"command (e.g. type <code>man ps</code>), or consult your UNIX documentation.<p>\n", "\"\n", "\n", "\n", 
"\n", "FAQ_TITLE_apparentroot \"Sharing a Single Database\"\n", "FAQ_QUESTION_apparentroot\n", "  \"All my domains are logged into one log file, and I don't want to have to \n", 
"  process the whole file for each customer.  Can I process it once, create \n", "  a single database, and still have customers limited to viewing their own statistics?\"\n", 
"FAQ_SHORT_ANSWER_apparentroot\n", "  \"Yes; create a single database from your log file, and use the [asr] option\n", 
"  to keep clients out of each others' statistics.\"\n", "FAQ_LONG_ANSWER_apparentroot\n", "\"It is fairly common for several domains to be logged into a single log file. \n", 
"If you want to provide separate statistics for each domain, without letting \n", "the domain owner of each domain see other domains' statistics, \n", 
"one easy way is to create a separate configuration for each \n", "domain, point them all at the same log, and use a log filter in each configuration \n", 
"to reject hits that come from all other domains.  That's the easiest way, but that's an inefficient use of \n", 
"CPU time, because each domain has to process the entire log file.  Another option \n", "is to create a single database containing all the domains, create a configuration per domain, \n", 
"point them all to the single database, and use the [asr] option to keep the statistics separate.\n", 
"One downside of the single-database approach, however, is that session information (session overview, \n", 
"entry pages, exit pages, paths through the site) cannot be shown per-domain, so it will not be available \n", 
"in the statistics (or if you do make it available, it will show session information for all sites combined).<p> \n", 
"Here's how to set it up:<p> \n", "<ol>\n", "  <li> Create new configuration, point it at all your log data, and set up everything the way you \n", 
"       want.  This is the %22master%22 configuration, and you may want to call it %22master.%22 \n", 
"       You will be able to view the statistics for this configuration to see all the domains, \n", 
"       but nobody else will.<p>\n", "  <li> Go to the Database Xrefs tab of the Configuration options, and cross-reference \n", 
"       the %22server domain%22 field to every other field, by checking every box in the \n", "       %22server domain%22 row, and every box in the %22server domain%22 column.\n", 
"       If there is no %22server domain%22 listed, then your log format does not log the \n", "       server domain information; you may want to switch to a format that does.  If you can't, \n", 
"       and each site is in its own sub{DIRECTORY_WORD}, and the sub{DIRECTORY_WORD} appears \n", "       as part of the %22page%22 field value in the statistics, then you can use the %22page%22\n", 
"       field instead of the %22server domain%22 to separate domains from each other; check the %22page%22 \n", 
"       field boxes for this step.<p>\n", "  <li> Use Save As from the configuration menu to duplicate the master configuration, \n", 
"       and choose one of your domains as the new name.  For instance, if your \n", "       domain is mydomain.com; save the master configuration as %22mydomain.com%22\n", 
"       (if you're using the page field instead of the server domain field, use the name of the \n", 
"       sub{DIRECTORY_WORD} instead).<p>\n", "  <li> Go to the Database Params tab of Configuration Options for mydomain.com, and \n", 
"       change the [dd] option to point at the database for %22master%22.  By default, \n", "       the database for %22master%22 is stored in a sub{DIRECTORY_WORD} called \n", 
"       %22master%22, in the sub{DIRECTORY_WORD} called Databases of the LogAnalysisInfo {DIRECTORY_WORD}. \n", 
"       Browse to that folder.  This tells the mydomain.com configuration to look for statistics data \n", 
"       in that database.<p>\n", "  <li> Now go to the Security tab, and change the [asr] option to point to the mydomain.com data only. \n", 
"       This is the tricky part.  You need to enter a text filter string here, which is something {PRODUCT_NAME} \n", 
"       normally does for you.  The exact string depends on which log contains the domain information.  \n", 
"       If the field is the %22server domain%22 field, then you can use<p>\n", "<pre>  singlefilter:server domain:mydomain.com</pre>\n", 
"       as the value.  If the domain appear as the first part of the page field, then you need to use<p>\n", 
"<pre>  singlefilter:page:/mydomain.com/</pre>\n", "       as the value.<p>\n", "  <li> You've finished with mydomain.com--you should now be able to view statistics for mydomain.com, \n", 
"       and it will not be possible to see any information except the hits on mydomain.com.<p>\n", "  <li> You can now easily create as many more similar configurations as you like using the \n", 
"       Create/Update Many Configurations from the Administrative menu.  Choose mydomain.com from \n", 
"       the menu at the top of the Create/Update Many Configurations page, enter the other domain names \n", 
"       in the large text area (one per line), and click Next to create all your configurations.<p> \n", 
"</ol><p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_macportlinger \"MacOS Port Lingering Issue\"\n", 
"FAQ_QUESTION_macportlinger\n", "  \"{PRODUCT_NAME} crashed/quit on MacOS and now I can't restart it.  When I try, it says \n", 
"  %22Unable to bind TCP/IP network endpoint to interface 123.123.123.123, port 8987--cannot start built-in web server.%22 \n", 
"  Why is this happening?\"\n", "FAQ_SHORT_ANSWER_macportlinger\n", "  \"MacOS did not clean up properly after {PRODUCT_NAME} quit--reboot MacOS to fix this.\"\n", 
"FAQ_LONG_ANSWER_macportlinger\n", "\"When the Classic or Carbon version of {PRODUCT_NAME} crashes or is force quit on MacOS, \n", 
"it does not have the chance to clean up and shut down its network usage, \n", "and MacOS does not properly detect that the network resources are no longer in use. \n", 
"As a result, when you try to run {PRODUCT_NAME} again, it can't start the web server on port 8987, \n", 
"because MacOS says the port is still in use.  If you wait a few minutes, MacOS may realize \n", "that the port isn't really in use, and may free it.  But that doesn't always work, especially \n", 
"on MacOS 9.  The best solution, if practical, is to reboot MacOS.<p>\n", "This problem does not occur if you use the Command-line version of {PRODUCT_NAME} for MacOS--if\n", 
"it crashes (and it doesn't crash as often as the Carbon or Classic versions, due in part to \n", "better memory management in the native MacOS X), MacOS X will clean up for it quickly and properly, \n", 
"and you will be able to start it again almost immediately (in fact, it will automatically restart itself).<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_combinereferrers \"Combining Referring Domains\"\n", "FAQ_QUESTION_combinereferrers\n", 
"  \"How can I combine referrers, so hits from http://search.yahoo.com, http://dir.yahoo.com, and http://google.yahoo.com \n", 
"  are combined into a single entry?\"\n", "FAQ_SHORT_ANSWER_combinereferrers\n", "  \"Create a log filter converting all the hostnames to the same hostname\"\n", 
"FAQ_LONG_ANSWER_combinereferrers\n", "\"You can do this by converting all of the hostnames to a single hostname, \n", 
"so for instance they all appear as http://yahoo.com referrers.  To do this, \n", "you need to convert all occurrences of /search.yahoo.com/, /dir.yahoo.com/, or \n", 
"/google.yahoo.com/ into /yahoo.com/, in the referrer field.  The easiest way is to make three filters:<p>\n", 
"<pre>  replace the first occurrence of %22/search.yahoo.com/%22 with %22/yahoo.com/%22, in the referrer field\n", 
"\n", "  replace the first occurrence of %22/dir.yahoo.com/%22 with %22/yahoo.com/%22, in the referrer field\n", 
"\n", "  replace the first occurrence of %22/google.yahoo.com/%22 with %22/yahoo.com/%22, in the referrer field\n", 
"</pre>\n", "You can create these filters like this:<p>\n", "<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", 
"  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Click the double square to the left of the first filter to duplicate it (the filters are in the yellow box).<p>\n", 
"  <li> Click the blue triangle to the left of the new first filter to edit it.<p>\n", "  <li> Choose %22Do B%22 from the top menu of the filter.<p>\n", 
"  <li> Choose %22replace first occurrence of value1 in field1 with value2%22 in the B Action menu.<p>\n", 
"  <li> Type /search.yahoo.com/ in the B value1 field.<p>\n", "  <li> Type /yahoo.com/ in the B value2 field.<p>\n", 
"  <li> Choose referrer from the B field1 menu.<p>\n", "  <li> Click the blue arrow to collapse the filter.<p>\n", 
"  <li> Verify that the filter's description looks like that above.<p>\n", "  <li> Duplicate the filter twice (using the double square), and edit the two duplicates, \n", 
"       replacing /search.yahoo.com/ with /dir.yahoo.com/ in one and with /google.yahoo.com/ in the other.<p>\n", 
"  <li> Rebuild the database (click Back to Configuration Page, then click Rebuild Database from Log Source).<p>\n", 
"</ol><p>\n", "The resulting statistics will combine all three referrers in a single /yahoo.com/ referrer.<p>\n", 
"\n", "A more sophisticated filter is necessary if you need to preserve some parts of \n", "the URL while converting others.  In that case, you can use a\n", 
"%22match field2 with regular expression value1, and set field1 to value2, replacing variables%22 \n", 
"filter.  This is an extremely powerful filter that lets you match any field to an arbitrary \n", "regular expression, include parentheses in the regular expression to extract certain parts of \n", 
"the matched field value, and finally substitute those parts back into the result value.\n", "For instance, if you want to convert all URLs of the format http://us.f<i>N</i>.mail.yahoo.com/ym/ \n", 
"(where <i>N</i> is any number) to http://us.f*.mail.yahoo/com/ym/, so they all appear as a single \n", 
"item in the statistics, you can do it by using the following filter:<p>\n", "<pre>  match the referrer field value to the regular expression %22^http://us\\.f{QUOTE:[0-9]*}\\.mail\\.yahoo\\.com/ym/(.*)$%22, and if it matches set the referrer field to http://us.f*.mail.yahoo.com/$1, replacing variables</pre>\n", 
"\n", "The way this works is it matches any referrer starting with\n", "http://us.f<i>N</i>.mail.yahoo.com/ym/ (where <i>N</i> is any integer), and while\n", 
"it's matching, it extracts everything after the /ym/ into the variable\n", "$1.  The leading ^ ensures that the referrer starts with http://, \n", 
"the trailing $ ensures that the parenthesized .* section contains all of the \n", "remainder after /ym/, {QUOTE:[0-9]*} matches any integer, and \\. matches a single period\n", 
"(see [docs-regexp] for more information about regular expressions).\n", "If it matches, it sets the referrer field to\n", 
"http://us.f*.mail.yahoo.com/$1, where $1 is the value extracted from\n", "the original URL. This allows you to collapse all\n", 
"http://us.f<i>N</i>.mail.yahoo.com/ URLs into a single one without losing the\n", "extra data beyond /ym/. If you don't care about the data beyond /ym/,\n", 
"you can use somewhat simpler (or at least easier-to-understand)\n", "filter:<p>\n", "<pre>  if the protocol field matches %22http://us.f*.mail.yahoo.com/ym/*%22\n", 
"  then set the protocol field to %22http://us.f*.mail.yahoo.com/ym/%22\n", "  otherwise continue on to the next filter</pre>\n", 
"\n", "This one uses a wildcard comparison (if matches wildcard\n", "expression) rather than a regular expression, which allows the\n", 
"use of * in the expression in its more generally understood\n", "meaning. Note also that in the first line, * appears twice and each\n", 
"time matches anything, but in the second line it appears only once,\n", "and is a literal *, not a %22match-anything%22 character.\n", 
"<p>\"\n", "\n", "\n", "\n", "FAQ_TITLE_commandlinefilter \"Using Command-line Log Filters\"\n", "FAQ_QUESTION_commandlinefilter\n", 
"  \"How can I query an external database to set the value of one of my log fields\n", "  while {PRODUCT_NAME} is processing the log data?\"\n", 
"FAQ_SHORT_ANSWER_commandlinefilter\n", "  \"Use a command line filter (use a Do B filter with action %22run command value1, and set value of field field1 to the result%22)\"\n", 
"FAQ_LONG_ANSWER_commandlinefilter\n", "\"If {PRODUCT_NAME}'s built-in log filters are not sufficient, \n", 
"you can use a command-line log filter to call a script to do any kind of filtering you need.\n", "For instance,\n", 
"if you want to track the names of customers who access the site, \n", "and all you have in the log is their usernames, you can add a log field called %22full name,%22 \n", 
"write a script to convert the username to the full name (the script may do this using an external database query), \n", 
"and then tell {PRODUCT_NAME} to call this script for every log entry to set the %22full name%22 field.<p>\n", 
"\n", "Here's how:<p>\n", "<ol>\n", "  <li> Create a script that accepts on the command line all of the log field values, and prints \n", 
"       the value of the field you want to modify.  For instance, \n", "       if the third log field (as ordered in the Log Fields tab of the Configuration Option) \n", 
"       is the username field, your script should look for the username in the third command-line argument, \n", 
"       and if you're modifying the %22full name%22 field, the script should print the full name \n", 
"       to the standard output stream.<p>\n", "  <li> Open your configuration from the Administrative menu.<p>\n", 
"  <li> Click the Log Filters tab.<p>\n", "  <li> Click the double square next to the first filter to duplicate it.<p>\n", 
"  <li> Click the blue triangle next to the first filter to edit it.<p>\n", "  <li> Choose %22Do B%22 from the top menu of the filter.<p>\n", 
"  <li> Choose %22run command value1, and set value of field field1 to the result%22 from the B:Action menu.<p>\n", 
"  <li> Enter the full pathname of your script in the B:value1 field.<p>\n", "  <li> Choose the field you want the result to go in (%22full name%22 in the example above) from the B:field1 menu.<p>\n", 
"  <li> Click the blue triangle to close the filter.<p>\n", "  <li> Click %22Back to Configuration Menu%22 at the top.<p>\n", 
"  <li> Click %22Rebuild Database from Log Source%22 to rebuild your database using the new command-line filter.<p>\n", 
"</ol>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_commandlinelogsource \"Using a Command-line Log Source\"\n", 
"FAQ_QUESTION_commandlinelogsource\n", "  \"Can {PRODUCT_NAME} use scp, or sftp, or ssh, or https, to download log data?  Can it uncompress\n", 
"  tar, or arc, or sea, or hqx, etc.?\"", "FAQ_SHORT_ANSWER_commandlinelogsource\n", "  \"Not directly, but you can do it by using a command-line log source to run a command line, script, or program\n", 
"  that does whatever is necessary to fetch the data, and prints it to {PRODUCT_NAME}\"\n", "FAQ_LONG_ANSWER_commandlinelogsource\n", 
"\"{PRODUCT_NAME} supports many different methods of acquiring log data, and including \n", "direct access to local files, and FTP or HTTP access to remote files; it can also \n", 
"decompress the major compression formats on the fly, including zip, gzip, and bzip2.\n", "If you need to use a different method to fetch the log data, like scp, sftp, or ssh,\n", 
"or if you need to read the log data from a database, or if you need to uncompress, decode, or \n", 
"decrypt a format that is not directly supported by {PRODUCT_NAME}, you can do it using a command-line\n", 
"log source.<p>\n", "Command-line log sources are very simple in concept.  You give {PRODUCT_NAME} a command line; it runs\n", 
"the command line whenever it needs to get the log data; the command, script or program you specify\n", 
"%22prints%22 the log data (i.e. generates it to stdout, the standard command line output stream), and\n", 
"{PRODUCT_NAME} reads the output of the command to get the log data.  The provides you with \n", "unlimited flexibility in how you feed your data to {PRODUCT_NAME}.<p>\n", 
"For instance, support {PRODUCT_NAME} didn't support gzip for at (it does).  Then you could\n", "use the following (UNIX) command log source: <code>/bin/gunzip -c /logs/mylog.gz</code>.  Since the -c\n", 
"flag tells gunzip to dump the output to stdout, {PRODUCT_NAME} will read the log data directly from this\n", 
"command, without needing to use its built-in gunzipper.  More usefully, any decompression utility with\n", 
"a similar flag can be used to allow {PRODUCT_NAME} to read any compressed, archived, or encrypted log directly, even if it\n", 
"doesn't know anything about the format.<p>\n", "Even if you don't have a program that will dump the data to stdout, you can still\n", 
"use this approach by writing a tiny script.  Consider the following (UNIX) shell script\n", "which scp'd files from a remote server and feeds them to {PRODUCT_NAME}:\n", 
"<pre>  scp user@host:/logs/mylog.txt /tmp/templog\n", "  cat /tmp/templog\n", "  rm /tmp/templog</pre>\n", 
"This script copies a log file from a remote machine (securely, using scp), \n", "prints it to stdout using %22cat%22, and deletes it when it's done.  The same script\n", 
"with slightly modifications, could copy multiple files, or use a different method than\n", "scp to fetch the files (like sftp).\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_referrer404s \"Finding External Broken Links\"\n", "FAQ_QUESTION_referrer404s\n", 
"  \"How can I see the referrers for 404 responses, so I can tell them their links are broken?\"\n", 
"FAQ_SHORT_ANSWER_referrer404s\n", "  \"Cross-reference %22server response%22 to referrer, include all bottom-level referrers, rebuild the database, and go to the %22Top referrers%22 view with a 404 filter on %22server response.%22\"\n", 
"FAQ_LONG_ANSWER_referrer404s\n", "\"To do this, you need two things that aren't turned on by default: \n", 
"you need full detail in the referrer field (complete referring URLs, \n", "not just the top couple levels), and you need to be able to cross-reference \n", 
"the referrer field with the server response field.  Once you've got that, \n", "you can view the top referrers with a 404 filter to see which referrers \n", 
"are broken links.  Here's how:<p>\n", "<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Database Xrefs tab.<p>\n", 
"  <li> Add a checkbox in the row and column that lines up %22server response%22 with %22referrer%22.<p>\n", 
"  <li> Click the Database Fields tab.<p>\n", "  <li> Edit the referrer field by clicking the blue triangle to the left of it.<p>\n", 
"  <li> Check the box %22Include bottom-level items%22.<p>\n", "  <li> Click the %22Back To Configuration Menu%22 button.<p>\n", 
"  <li> Click the %22Rebuild Database From Log Source%22 button.<p>\n", "  <li> Click the %22View Statistics%22 button.<p>\n", 
"  <li> Click the %22Top server responses%22 button at the left.<p>\n", "  <li> From the Options menu at the bottom of the page, choose %22Show filters checkboxes and menu.%22<p>\n", 
"  <li> Check the box next to 404.<p>\n", "  <li> From the Filters menu at the bottom of the table, choose %22Show checked data in the 'Top referrers' view.%22<p>\n", 
"</ol>\n", "The resulting view will show you the top referring URLs that resulted in 404s. \n", "If you want a list of URLs rather than having to zoom in, you can chose \n", 
"%22Show only bottom-level items%22 from the Options menu.<p>\n", "If you've set up {PRODUCT_NAME} to ignore internal referrers as described in [faq-internalreferrers], \n", 
"you won't see any broken links from you own site.  You'll need to disable the internal referrer filter, \n", 
"and rebuild the database, before you can see internal referrer information.<p>\n", "\"\n", "\n", "\n", 
"\n", "FAQ_TITLE_unicode \"Unicode in Statistics\"\n", "FAQ_QUESTION_unicode\n", "  \"I have non-English characters in my log data.  When I view statistics, they appear\n", 
"  as gibberish.  How can I show them correctly?\"\n", "FAQ_SHORT_ANSWER_unicode\n", "  \"Set your charset to Unicode by setting the Page Header variable to\n", 
"  <code>&lt;META http-equiv=Content-Type content=%22text/html; charset=UTF-8%22&gt;</code>.\"\n", "FAQ_LONG_ANSWER_unicode\n", 
"\"The gibberish you're seeing is probably incorrectly-rendered Unicode\n", "(Unicode is a standard system for encoding characters of any language).\n", 
"Some browsers will display the characters automatically, but if yours doesn't,\n", "you can help it out by setting the charset for {PRODUCT_NAME}'s HTML pages to UTF-8,\n", 
"the standard 8-bit Unicode charset.  Do this by adding the following\n", "line to your Page Header (in the Headers/Footers tab of the Configuration Options):<p>\n", 
"<pre>  &lt;META http-equiv=Content-Type content=%22text/html; charset=UTF-8%22&gt;</pre>\n", "Now start over viewing your statistics, and the characters should appear correctly.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_regularexpressions \"Regular Expression Features\"\n", "FAQ_QUESTION_regularexpressions\n", 
"  \"What features can I use in {PRODUCT_NAME}'s regular expressions?\"\n", "FAQ_SHORT_ANSWER_regularexpressions\n", 
"  \"You can use whatever's documented ([docs-regexp]), and possibly more.  How much more \n", "  you can use depends on your platform.\"\n", 
"FAQ_LONG_ANSWER_regularexpressions\n", "\"Regular expressions are not standardized--different programs that support \n", 
"%22regular expression%22 may support slightly different features.  For instance, \n", "some will let you use {QUOTE:%7BN%7D} to repeat the preceding expression N times, and some will not\n", 
"(they will require you to write the expression N times yourself). \n", "Some will let you use {QUOTE:\\d} to match any digit, and others will not (they will require you to \n", 
"use {QUOTE:[0-9]}.  So the point of this questions is, which of these %22non-standard%22 features \n", 
"does {PRODUCT_NAME} support?  The answer depends on the platform you're running {PRODUCT_NAME} on.<p>\n", 
"{PRODUCT_NAME}'s regular expressions vary depending on platform--it uses the built-in\n", "regular expression library on some platforms, the GNU library on other platforms, \n", 
"and the Boost library on others.  Anything that is documented in [docs-regexp] is available \n", "on all platforms.  Anything that is not documented there may not be available. \n", 
"The easiest way to find out if something is available is to try it--add a \n", "regular-expression filter to your Log Filters and see if it works. \n", 
"But if you want to make sure your configuration is portable, and will work on other \n", "platforms, you should stick to the documented choices.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_regexpcase \"Regular Expression Case-sensitivity\"\n", "FAQ_QUESTION_regexpcase\n", 
"  \"Are {PRODUCT_NAME}'s regular expressions case-sensitive?\"\n", "FAQ_SHORT_ANSWER_regexpcase\n", 
"  \"Yes.\"\n", "FAQ_LONG_ANSWER_regexpcase\n", "\"Yes--the regular expression <code>Dog</code> matches <code>Dog</code>, \n", 
"but not <code>dog</code> or <code>DOG</code>.  If you need to match \n", "case-insensitively in a log filter, you can convert the field to lowercase first \n", 
"(copy it to another temporary field if you don't want to modify the original).<p>\"\n", "\n", "\n", 
"\n", "FAQ_TITLE_debuggingoutput \"Using Debugging Output\"\n", "FAQ_QUESTION_debuggingoutput\n", "  \"How can I debug my custom log format, or my log filters?\"\n", 
"FAQ_SHORT_ANSWER_debuggingoutput\n", "  \"Build the database from the command line with the -v option: <code>{PRODUCT_EXECUTABLE_DOCS} -rfcf <i>configname</i> -cm cd -v egblpfd</code>.\"\n", 
"FAQ_LONG_ANSWER_debuggingoutput\n", "\"Custom log formats and log filters can be difficult to debug from the graphical interface, \n", 
"because there is little feedback about what {PRODUCT_NAME} is doing as it processes the log. \n", "Fortunately, {PRODUCT_NAME} has a powerful feature called %22debugging output%22 that \n", 
"makes debugging custom log formats and filters much easier.<p>\n", "To see the debugging output, you need to use a command-line version of {PRODUCT_NAME}. \n", 
"On Windows, that means using the {PRODUCT_NAME}6CL.exe program, and running it from the \n", "command prompt.  On Unix, you can use the normal {PRODUCT_NAME} executable, since it works \n", 
"on the command line.  On MacOS, you need to use the MacOS X command-line version of {PRODUCT_NAME} \n", 
"(there is no command line option of you're running MacOS 9 or earlier).<p>\n", "Using the command shell, go to the {PRODUCT_NAME} installation directory \n", 
"(using the %22cd%22 command).  Then rebuild the database like this if you're using Windows: \n", "<pre>  {PRODUCT_NAME}6CL.exe -rfcf <i>configname</i> -cm cd -v egblpfd | more</pre>\n", 
"or like this if you're using Unix:<p>\n", "<pre>  ./{PRODUCT_EXECUTABLE_DOCS} -rfcf <i>configname</i> -cm cd -v egblpfd | more</pre>\n", 
"or like this if you're using MacOS X:<p>\n", "<pre>  ./{PRODUCT_NAME}CommandLine -rfcf <i>configname</i> -cm cd -v egblpfd | more</pre>\n", 
"This command rebuilds the database for the <i>configname</i> configuration, \n", "and <code>-v egblpfd</code> tells {PRODUCT_NAME} to report as much information as possible \n", 
"about what it's doing.  The results are piped through the %22more%22 program, \n", "so you can page through the output using the space bar.  Lines starting with \n", 
"%22Processing line%22 show when {PRODUCT_NAME} is processing a new log line.  \n", "Lines starting with %22Marking hits%22 show the end results that are being \n", 
"put into the database.  Other lines provide information about log parsing and \n", "filtering that can be very useful when you're trying to debug a problem in the \n", 
"parsing of your custom format, or in your custom log filter.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_schedulercgi \"Using the Scheduler with CGI Mode\"\n", 
"FAQ_QUESTION_schedulercgi\n", "  \"How can I run {PRODUCT_NAME} in CGI mode, and still use the {PRODUCT_NAME} Scheduler?\"\n", 
"FAQ_SHORT_ANSWER_schedulercgi\n", "  \"Use an external Scheduler to run jobs or to call the {PRODUCT_NAME} Scheduler, or run {PRODUCT_NAME} in both CGI and web server modes.\"\n", 
"FAQ_LONG_ANSWER_schedulercgi\n", "\"{PRODUCT_NAME}'s built-in scheduler can only run scheduled jobs if {PRODUCT_NAME} is actually \n", 
"running when the job's time comes.  That's fine if you're running {PRODUCT_NAME} in web server \n", 
"mode, where it runs all the time.  But in CGI mode, {PRODUCT_NAME} only runs when someone is \n", "actively using it, so scheduled jobs will not run.  There are three main solutions to this \n", 
"problem: use an external scheduler to call {PRODUCT_NAME}'s scheduler, use an external scheduler \n", 
"to run the jobs directly, or run {PRODUCT_NAME} on <i>both</i> CGI and web server modes, with \n", 
"the CGI mode doing everything but the scheduled jobs, and web server mode handling those.<p>\n", "\n", 
"<h3>UNIX</h3>\n", "On UNIX, the most common scheduler is cron.  You can set up cron to call {PRODUCT_NAME}'s scheduler \n", 
"by running the command\n", "<pre>  crontab -e</pre>\n", "from the UNIX command line, and then adding \n", 
"<pre>  * * * * * /full/path/to/{PRODUCT_EXECUTABLE_DOCS} -scheduler</pre>\n", "to the resulting file.  You will need to replace <code>/full/path/to/{PRODUCT_EXECUTABLE_DOCS}</code>\n", 
"with the full pathname of your {PRODUCT_NAME} executable.  This tells cron tab to run {PRODUCT_NAME} \n", 
"every minute, with the <code>-scheduler</code> option (which tells {PRODUCT_NAME} to run any \n", "scheduled jobs, and exit).<p>\n", 
"Another option is to run your {PRODUCT_NAME} database builds and other jobs directly with cron; \n", 
"for instance you could add a line like this:\n", "<pre>  0 0 * * * /full/path/to/{PRODUCT_EXECUTABLE_DOCS} -rfcf {configname} -cm ud</pre>\n", 
"to update the configuration specified by {configname} every night at midnight\n", "(the first number is the minute of the hour when the job should be run; the second number \n", 
"is the hour when the job should be run, and * * * means to run it every day).<p>\n", "Yet another option is to run {PRODUCT_NAME} in web server mode as well as CGI mode, with \n", 
"the web server mode instance running only for the purpose of running jobs. \n", "The two will not interfere with each other; just start {PRODUCT_NAME} from the command line using \n", 
"<pre>  /full/path/to/{PRODUCT_EXECUTABLE_DOCS} &</pre>\n", "and it will continue to run until the next reboot.  If you want {PRODUCT_NAME} to automatically \n", 
"restart itself at system startup, see [faq-runatstartup].<p>\n", "\n", "<h3>Windows</h3>\n", "Unfortunately, Windows Scheduler does not let you run jobs every minute (like UNIX cron does), \n", 
"so you cannot use it to call the {PRODUCT_NAME} Scheduler directly.  However, other options are available.\n", 
"You can use the Windows Scheduler to run your {PRODUCT_NAME} jobs directly.  For instance, to set {PRODUCT_NAME} \n", 
"to update the database for a particular configuration every night, do this:<p>\n", "<ul>\n", "  <li> Open the Scheduled Tasks control panel.<p>\n", 
"  <li> Double-click Add Scheduled Task, and click Next.<p>\n", "  <li> Choose %22{PRODUCT_NAME} 6 (CGI)%22 from the list, and click Next.<p>\n", 
"  <li> Click Daily and click Next.<p>\n", "  <li> Choose a time to run the build; sometime in the middle of the night (like midnight) is a good choice, and click Next.<p>\n", 
"  <li> Enter your username and password, and click Next.<p>\n", "  <li> Click %22Open advanced properties for this task when I click Finish,%22 and click Next.<p>\n", 
"  <li> Add %22-rfcf {configname} -cm ud%22 to the end of the Run field, and click OK.<p>\n", "</ul>\n", 
"Now Windows Scheduler is configured to update your database automatically every day.<p>\n", "Another option is to run {PRODUCT_NAME} in web server mode as well as CGI mode, with \n", 
"the web server mode instance running only for the purpose of running jobs. \n", "The two will not interfere with each other; just start {PRODUCT_NAME} by double-clicking its icon \n", 
"(you can also configure it to start whenever your computer restarts, using Windows Scheduler),\n", 
"and scheduled jobs will run as long as {PRODUCT_NAME} is running.  If you need {PRODUCT_NAME} to be running \n", 
"while you are logged out, see [faq-windowsservice].<p>\n", "\n", "<h3>MacOS 9</h3>\n", "On MacOS 9, this is not an issue, because ACGI mode is similar to web server mode, in that \n", 
"{PRODUCT_NAME} runs all the time.  Because of that, scheduled jobs will run on MacOS, even if \n", 
"{PRODUCT_NAME} is running in ACGI mode.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_hundredpercentcpu \"{PRODUCT_NAME} Uses Too High a Percentage of CPU\"\n", 
"FAQ_QUESTION_hundredpercentcpu\n", "  \"When I process log data with {PRODUCT_NAME}, it uses most or all of my processor; \n", 
"  it says it's using 90%, or even 100% of the CPU.  Should it be doing that?  Is that a problem?\"\n", 
"FAQ_SHORT_ANSWER_hundredpercentcpu\n", "  \"Yes, it should do that, and it's not usually a problem.  Any CPU-intensive program will do the same.  However, you can throttle it back if you need to with [mcup].\"\n", 
"FAQ_LONG_ANSWER_hundredpercentcpu\n", "\"{PRODUCT_NAME} is a %22CPU-bound%22 program while it's processing logs, which means that \n", 
"the microprocessor (a.k.a. CPU) is the bottleneck; the disk feeds data to {PRODUCT_NAME} \n", "as fast as the processor can handle it.  Most programs you use daily (web browsers, \n", 
"mail programs, word processors, etc.) are probably not \n", "CPU-bound, but any number-crunching or data-crunching program is.  Other examples of \n", 
"programs that are typically CPU-bound include \n", "compression/decompression programs like ZIP, 3D rendering programs, and encryption programs \n", 
"(or encryption breakers).<p> \n", "\n", "Any well-behaved operating system will give a CPU-bound process as much CPU as it has available, \n", 
"provided that the processing needs of all other processes are met as well.  Because most systems \n", 
"use only a small fraction of their processing power, there is usually more than 90% free CPU available \n", 
"at any time.  This CPU is wasted unless it is used, so if there's a program like {PRODUCT_NAME} that's \n", 
"continually asking for more CPU, the operating system should and will give it as much CPU as possible.  If nothing else \n", 
"is running on the system, {PRODUCT_NAME} will use 100% of the CPU.  Since nothing else needs the CPU, \n", 
"that's as it should be--if the operating system only gave {PRODUCT_NAME} 50% of the CPU, it would take \n", 
"twice as long to process the log data, and during the other 50% of the time, the CPU would be sitting \n", 
"idle, wasting time.  So don't worry if {PRODUCT_NAME} is using nearly 100% of your CPU--that's \n", 
"the way it's supposed to be, and it will generally have no negative effects.<p>\n", "\n", "The one time you may see negative effects of {PRODUCT_NAME}'s CPU usage is if there are other \n", 
"CPU-bound or CPU-intensive programs running on the system.  In this case, because all the \n", "programs want as much CPU as possible, the operating system will split the CPU evenly between them. \n", 
"For instance if there are three CPU-intensive processes running, each of them will get 33% of the CPU, \n", 
"and each will run 1/3 as fast as it would on a lightly loaded machine.  If you have an important \n", 
"CPU-intensive process running on your server (for instance, a very busy web server), you \n", "may want to give {PRODUCT_NAME} a lower priority than the other processes.  You can do this \n", 
"on UNIX systems using the %22nice%22 command, and on Windows systems using the Process Manager. \n", 
"When you set {PRODUCT_NAME}'s priority to lower than the rest, it will get less than its share of CPU time, \n", 
"and the other processes will run faster.  {PRODUCT_NAME}, of course, will run slower.  Similarly, if \n", 
"other processes are interfering with {PRODUCT_NAME}'s performance and you don't care about the performance \n", 
"of the other processes, you can increase {PRODUCT_NAME}'s priority to make it run faster, at the expense \n", 
"of the other processes.<p>\n", "\n", "Even programs that are not normally CPU-bound will have moments when they become briefly CPU-bound. \n", 
"For instance, a web browser sits idle most of the time, using almost no CPU, but when you load a complex \n", 
"page, it briefly uses as much CPU as it can get to compute and display the page.  During that period, \n", 
"if {PRODUCT_NAME} is running, each program will get 50% of the CPU.  So the layout will take twice as long as \n", 
"it does when {PRODUCT_NAME} is not running, which will make the web browser feel more sluggish than usual.\n", 
"Other programs, and the operating system itself, will similarly feel more sluggish while {PRODUCT_NAME} is \n", 
"processing the log data. \n", "This is an side effect of having a CPU-bound program \n", "running on the system--everything else will slow down.  Setting {PRODUCT_NAME} to a lower priority will help \n", 
"in this situation, because the web browser will get nearly 100% of the CPU (while {PRODUCT_NAME} is temporarily halted) \n", 
"while it's rendering.<p>\n", "\n", "If you're in an environment where you are not permitted to use more than \n", 
"a certain percentage of CPU, you can force {PRODUCT_NAME} to throttle itself back by setting the \n", 
"[mcup] option to 50 or lower.  This will cause {PRODUCT_NAME}'s long-term CPU usage to be lower, \n", 
"though it will continue to spike at 100% for as much as 1 second at a time. \n", "If operating-system-level priority settings are not available, this may be a reasonable option \n", 
"to keep {PRODUCT_NAME} from dominating the CPU.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_contentgroups \"Creating Content Groups\"\n", 
"FAQ_QUESTION_contentgroups\n", "  \"How can I create %22content groups%22, so I can group my hits in broad categories \n", 
"  (like %22internal%22 vs. %22external%22 or %22monitoring%22 vs. %22actual%22), \n", "  and see the hits on each category separately, or see them combined?\"\n", 
"FAQ_SHORT_ANSWER_contentgroups\n", "  \"Create a new log field, database field, and view to track and show the category, and then \n", 
"  the log filters to set the log field appropriately for each entry.\"\n", "FAQ_LONG_ANSWER_contentgroups\n", 
"\"It is often useful to be able to see hits in categories other than those \n", "which naturally fall out of the data.  Natural categories include page directories (the page field), \n", 
"months (the date/time field), or visitor domains (the hostname field). \n", "{PRODUCT_NAME} treats every value of every field as a category, \n", 
"so you can categorize by any field in your log data.  You can take advantage of this feature \n", "to make your own categories, even if those categories are not immediately clear in the log data. \n", 
"Categories like these are called %22content groups.%22  One common use of content groups is \n", "to separate internal hits (hits from you) from external hits (hits from other people).  Another \n", 
"use is to separate monitoring hits (hits from programs you use to monitor your own site) \n", "from actual hits (hits by browsing people).  Another similar categorization is spider hits \n", 
"(hits from search engine robots and other robots) vs. human hits (hits by browsing people). \n", "{PRODUCT_NAME} lets you track your data along these or any other axis; you can do it by defining your own log field, \n", 
"and using log filters to categorize the hits.<p>\n", "\n", "This is a complicated process, and there is an easier way that has some advantages (and some disadvantages). \n", 
"The easy way is to create a separate configuration for each category (and perhaps another configuration \n", 
"for all the categories combined), and \n", "use log filters, similar to the ones below, in each configuration to reject any hits not in the appropriate category. \n", 
"This solution tends to make the databases smaller, and eliminates the need for cross-referencing \n", 
"between the category field and other fields, but it does require managing separate configurations, \n", 
"and it requires that the log data be reprocessed several times (once for each configuration). \n", 
"Also, the category statistics are not integrated as well as they are with a single configuration. \n", 
"However, use of separate configurations is the <i>only</i> way to get per-category session information \n", 
"(paths through the site, entry/exit pages, session summary, and time per page)--session \n", "information cannot be filtered the way other information can be, so you won't be able to zoom in \n", 
"on a category and then see those views with data from just that category, unless you create separate databases.<p>\n", 
"\n", "Here's how you do it with a single configuration:<p>\n", "<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", 
"  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click Log Fields tab.<p>\n", "  <li> Click on the double box icon next to the last non-derived (boldface) log field to duplicate that field.<p>\n", 
"  <li> Open the second of the duplicates by clicking the light blue triangle next to it.<p>\n", "  <li> Change the name to %22category%22 or whatever you choose.<p>\n", 
"  <li> Change the type to %22generic non-hierarchical%22.  This tells {PRODUCT_NAME} that there is no particular\n", 
"       structure to this field--all categories are at the same level.  If you want to make the field \n", 
"       hierarchical, you can, but make sure you set the divider, hierarchy direction properly, and make sure \n", 
"       you set the field values to hierarchical values in the log filters, below.  Usually, \n", "       there is no need to make a field hierarchical.<p>\n", 
"  <li> Change the index/subindex to 0 if they aren't already.  This tells {PRODUCT_NAME} that this field\n", 
"       isn't really in the log data--it's a %22dummy%22 field.<p>\n", "  <li> Click the Database Fields tab.<p>\n", 
"  <li> Click on the double box icon next to any database field to duplicate that field.<p>\n", "  <li> Open either of the duplicated fields.<p>\n", 
"  <li> Choose the name of your new log field from the %22Based on log field%22 menu.<p>\n", "  <li> Enter 0 for the %22Suppress levels above%22 and 2 for %22Suppress levels below.%22  If \n", 
"       you're creating a hierarchical field, you may want to use a higher %22Suppress levels below%22 value.<p>\n", 
"  <li> Click the Database Xrefs tab.  You don't need to do anything here unless you know \n", "       in advance which cross-references you'll be needing, but you do need to click here so the \n", 
"       cross-references information can be updated to include the new field.<p>\n", "  <li> Click the %22Back To Configuration Menu%22 button.<p>\n", 
"  <li> Click %22Rebuild Database From Log Source,%22 click %22Next%22 if it asks you if you really want to rebuild, \n", 
"       and wait for the rebuild to finish.<p>\n", "       Note: this step is necessary if you intend to create a view, \n", 
"       because the Stats View tab menus are based on the data in the database.  You can skip the rebuild, \n", 
"       and the rest of this list, if you don't need a view.  A view will let you see your category \n", 
"       in its own table (e.g. how many internal hits, how many external hits, etc.), but if you don't need that, \n", 
"       you don't need a separate view--you can use the Filters to zoom in on any category or collection of categories.<p>\n", 
"       Note: you'll be rebuilding again at the end of this process, so if your log data is huge\n", 
"       and a database build will take a very long time, you may want to consider temporarily changing your log source \n", 
"       to point to a single small file, doing a quick rebuild and then setting\n", "       the log source back to what it was for the final rebuild.<p>\n", 
"  <li> Click Configuration Options.<p>\n", "  <li> Click the Stats Views tab.<p>\n", "  <li> Choose where you want your view to go in the list, and duplicate the view (by clicking the double box)\n", 
"       at the location you want your view to be.  The order shown here is the same order \n", "       as the buttons down the left of the statistics.  So if you want your new view to be at the \n", 
"       top of the list, duplicate the first view.  For simplicity, you should <i>not</i> use the %22single page summary%22\n", 
"       as the view to duplicate; duplicate one above or below it instead if you want your view to go there.  If you \n", 
"       duplicate the %22single-page summary%22 you will have to delete all but one of the subviews before you can use it,\n", 
"       which will take a long time.<p>\n", "  <li> Open your new view by clicking the light blue triangle next to it.<p>\n", 
"  <li> Name the view %22Top categories%22 or whatever you like.<p>\n", "  <li> Click the blue triangle next to the first subview to open it.<p>\n", 
"  <li> Change the subview Type to %22Top items for the category page.%22<p>\n", "</ol>\n", "Now you've set up a log field to hold the category value, a database field to track it, \n", 
"and a view/subview to display it.  Next, you need to create the log filters to categorize hits. \n", 
"Exactly how you will do this depends on your categories and how you tell them apart, but for this \n", 
"example, we'll assume that the categories are %22internal%22 and %22external%22 and that they \n", 
"are categorized by host IP--if the hostname field is in the .100.100 subnet\n", "(i.e. if the hostname field ends with %22.100.100%22), the hits are considered \n", 
"internal; otherwise they are considered external.  Here's how you set up the filters, in that case:\n", 
"<ol>\n", "  <li> Go to the Administrative Menu.<p>\n", "  <li> Open your configuration by clicking Open Configuration, selecting your configuration, and clicking Open.<p>\n", 
"  <li> Click the Configuration Options button.<p>\n", "  <li> Click the Log Filters tab.<p>\n", "  <li> Duplicate the first filter by clicking on the double box next to it.<p>\n", 
"  <li> Open the first filter by clicking the light blue triangle next to it.<p>\n", "  <li> Choose %22If A then B, else C%22 from the menu at the top of the filter.<p>\n", 
"  <li> Choose %22value1 ends with value2%22 from the A:Operation menu.<p>\n", "  <li> Choose %22hostname%22 from the A:value1 menu.<p>\n", 
"  <li> Choose %22this value:%22 from the A:value2 menu.<p>\n", "  <li> Type %22.100.100%22 (without quotes) in the field next to the A:value2 menu.<p>\n", 
"  <li> Choose %22set the value of field1 to value1%22 from the B:Action menu.<p>\n", "  <li> Type %22internal%22 (without quotes) in the B:value1 field.<p>\n", 
"  <li> Choose %22category%22 from the B:field1 menu.<p>\n", "  <li> Choose %22set the value of field1 to value1%22 from the C:Action menu.<p>\n", 
"  <li> Type %22external%22 (without quotes) in the C:value1 field.<p>\n", "  <li> Choose %22category%22 from the B:field1 menu.<p>\n", 
"</ol>\n", "When you collapse the filter (by clicking the blue triangle next to it), you should see\n", 
"<ul>\n", "if the hostname field ends with %22.100.100%22<br>\n", "then set the category field to %22internal%22<br>\n", 
"otherwise set the category field to %22external%22\n", "</ul>\n", "In other words, this filter sets the category field to %22internal%22 for hits from *.100.100, \n", 
"or %22external%22 from any other place.  Now rebuild the database again, and you should \n", "be able to see the hits for each category in the %22Top categories%22 view.  You can use \n", 
"the %22filters checkboxes and menus%22 item in the Options menu to zoom in on any particular \n", "category and see statistics for that category, or you can do the same using the Filters editor.<p>\n", 
"\n", "If you didn't add any cross-references to the category field, \n", "you'll find that if you zoom in on a category and then look at some other view, \n", 
"you'll get a %22Data not available%22 error.  Cross-references increase the size of \n", "the database and slow it down, so you should use them sparingly.  However, if you need \n", 
"a kind of report that requires cross-references, you can add them in the Database Xrefs tab, \n", "and rebuild the database, and the %22Data not available%22 error will go away.\n", 
"If you have no cross-references at all, the only information you will be able to \n", "get about categories is the number of hits (or page views, or visitors, or bandwidth) for each \n", 
"category.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_addingsearchengines \"Adding Search Engines\"\n", 
"FAQ_QUESTION_addingsearchengines\n", "  \"Can I configure {PRODUCT_NAME} to recognize search engines other than the ones it knows already?\"\n", 
"FAQ_SHORT_ANSWER_addingsearchengines\n", "  \"Yes--just edit the SearchEngines file in the LogAnalysisInfo {DIRECTORY_WORD} with a text editor.\"\n", 
"FAQ_LONG_ANSWER_addingsearchengines\n", "\"Yes; {PRODUCT_NAME}'s search engine recognition mechanism is easily extensible. \n", 
"All the search engines {PRODUCT_NAME} knows are described in a text file \n", "called SearchEngines, which is found in the LogAnalysisInfo {DIRECTORY_WORD} of \n", 
"your {PRODUCT_NAME} installation.  {PRODUCT_NAME} puts about twenty search engines in there \n", "to begin with (the big, well-known ones), but you can add as many more as you like, \n", 
"by editing the file with a text editor.  Just add a new line for each new search engine, \n", "and the next time {PRODUCT_NAME} processes log data, it will recognize those search engines, \n", 
"and it will include them in the database.<p>\n", "\n", "The first column of each line is the name of the search engine; \n", 
"put whatever you want the search engine to be called there.  That's \n", "what will appear in the statistics.  The second column is a %22quick check%22 \n", 
"that {PRODUCT_NAME} uses to check if a URL <i>might</i> be a URL from that search engine. \n", "If the URL contains the %22quick check%22 string, {PRODUCT_NAME} then does a slower check \n", 
"using the third column, which is a regular expression.  If the regular expression matches, \n", "{PRODUCT_NAME} uses the parenthesized section of the regular expression as the search terms \n", 
"(it should be a series of search terms, separated by plusses (+)). \n", "The parenthesized section is used to compute the search terms and search phrases statistics.<p>\n", 
"\n", "You might notice that the second column is redundant--{PRODUCT_NAME} doesn't really need it at all, \n", 
"since it could just check every URL with the regular expression.  The reason that second \n", "column is there is that regular expressions are relatively slow--{PRODUCT_NAME} can process \n", 
"log data much faster if it doesn't have to check every URL in the log data against \n", "twenty or more regular expressions.  This way, it only has to use the regular expressions \n", 
"on a tiny proportion of the URLs that it sees.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_changingtimezone \"Changing the Time Zone in Statistics\"\n", 
"FAQ_QUESTION_changingtimezone\n", "  \"My server logs times in GMT, but I'm in a different time zone.  How can I get the statistics in my own time zone?\"\n", 
"FAQ_SHORT_ANSWER_changingtimezone\n", "  \"Set the %22Date offset (hours + or -)%22 option, in the Log Filters tab of the Configuration Options\"\n", 
"FAQ_LONG_ANSWER_changingtimezone\n", "\"{PRODUCT_NAME} reports times exactly as they appear in the log data-- if the time shows\n", 
"up as 8:00 AM in the log data, that hit will appear as 8:00 AM in the statistics.\n", "Since servers sometimes log in GMT, or some other time zone from where {PRODUCT_NAME} is running,\n", 
"you may want to offset the times in your statistics to match your own time zone, rather than\n", "the server's time zone or GMT.  This is easily done using the %22Date offset (hours + or -)%22\n", 
"option, in the Log Filters tab of the Configuration Options.  The number of hours specified in that field is added\n", 
"to the date/time, so if it's a negative number, it moves times backwards, and if it's positive, \n", 
"it moves them forwards.  For instance, if you're 8 hours behind GMT (GMT-0800), and \n", "your server logs in GMT, you can set this value to -8 to get statistics in your own time zone.\n", 
"This option affects log entries are they are processed, so you'll need to rebuild the database after setting this option,\n", 
"to see the changes in the statistics.\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_recentstats \"Recent Statistics\"\n", 
"FAQ_QUESTION_recentstats\n", "  \"How can I see just the most recent day/week/month of statistics?\"\n", 
"FAQ_SHORT_ANSWER_recentstats\n", "  \"Use the Calendar, or the Filters, or use a %22reject if older than%22 log filter, or a <code>recentdays</code> filter on the command line.\"\n", 
"FAQ_LONG_ANSWER_recentstats\n", "\"If you've checked day-by-day information when you chose the level of detail \n", 
"when you created the configuration, you can go to the Calendar view and click\n", "on a recent day, week, or month to see the statistics for that time period.\n", 
"You can also edit the Filters to zoom in on any collection of months or days,\n", "including the most recent ones.<p>\n", 
"However, filters made in that manner will not move forward as the date changes. \n", "If you want a statistics filter that will always show the most recent seven days, automatically, \n", 
"then you will need to use the command line (AppleScript on MacOS), or edit the configuration file manually.\n", 
"{PRODUCT_NAME}'s command-line filtering options are slightly more powerful than the filtering \n", 
"options available from the web interface.  Though it's not possible in the web interface to \n", "create a filter which always shows the last seven days, \n", 
"it <i>is</i> possible to do this \n", "from the command line, using a <code>recentdays:N</code> filter on the date/time field. \n", 
"For instance, to send email showing the past seven days of data, use a command line this:<p>\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf {config} -cm svbe -f %22recentdays:7%22</pre>\n", 
"This will work if the date/time field is the first database field; if it's not, you'll need \n", "to add an additional <code>nofilter</code> parameter for each field before it.  For instance, if the \n", 
"date/time field is the third database field, you can use this command line to send the past thirty \n", 
"days of data:<p>\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf {config} -cm svbe -f %22nofilter,nofilter,recentdays:30%22</pre>\n", 
"It is also possible to use this kind of a filter in a configuration file, by editing \n", "the file manually.  So for instance, if you want to use a <code>recentdays</code> filter \n", 
"on a custom subview so that subview always shows the most recent seven days of data,\n", "you can create the subview in the Stats Views tab, and then edit \n", 
"the configuration file (in the Configs {DIRECTORY} of LogAnalysisInfo) to change the filter \n", "parameter to <code>recentdays:7</code> (with any necessary leading <code>nofilter</code> values).<p>\n", 
"Finally, it is possible to use log filters to accomplish the same thing, if you're willing to \n", 
"have a database devoted to the recent days data only.\n", "Just add the following\n", "filter to your filter list:<p>\n", 
"\n", "<pre>  if date/time field is older than 7\n", "  then reject\n", "  otherwise go to next filter\n", 
"</pre>\n", "This rejects all log entries whose date/time field is older than 7 days,\n", "from the moment when {PRODUCT_NAME} opens the log file.\n", 
"You will then either need to rebuild the database as necessary, or expire it \n", "to show only the most recent 7 days. \n", 
"You can use this together with the Expire Database feature to automatically expire hits\n", "older than a number of days, to make a %22rolling%22 database that always contains the\n", 
"last 7 days. \n", "This allows you to have %22recent days%22 statistics in \n", "offline pages and live statistics, as well as email messages.<p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_periodicslowdowns \"Period Slowdowns During Log Processing\"\n", 
"FAQ_QUESTION_periodicslowdowns\n", "  \"When I process a large log file with {PRODUCT_NAME}, the entries per second drops off \n", 
"  now and then, and then recovers to full speed later.  Why?\"\n", "FAQ_SHORT_ANSWER_periodicslowdowns\n", 
"  \"{PRODUCT_NAME} is performing regular database maintenance.  You can defer this to the end of processing by setting the [ddwbs] option to a very high value.\"\n", 
"FAQ_LONG_ANSWER_periodicslowdowns\n", "\"As {PRODUCT_NAME} processes log data, it stores the processed data in the memory write buffer \n", 
"(see [dwbs]) until it's full.  When the memory write buffer fills up, {PRODUCT_NAME} write is to \n", 
"disk, into the disk write buffer (see [ddwbs]).  When that fills up, {PRODUCT_NAME} consolidates \n", 
"the disk write buffer into the main database in a resource-intensive consolidation stage. \n", "The slowdown you're seeing is due to the consolidation, which uses most of the processing \n", 
"resources while it occurs, leaving only a little for log processing.<p>\n", "Consolidation need to happen eventually, or the information won't be written to the \n", 
"database.  But it doesn't have to happen before the end of log processing, and \n", "if you have enough disk space, you can defer it until then.  Just set the \n", 
"disk write buffer to a very high number (the size of your hard drive is a good choice), \n", "and {PRODUCT_NAME} will not consolidate unless you full up the entire hard drive with buffered data, which is unlikely \n", 
"if your hard drive is large.  With a large disk write buffer, you should see consistent \n", "performance through the entire log data, with no slowdowns.<p>\n", 
"This is particularly important for very large datasets, because the consolidation stage \n", "takes longer and longer as the database gets larger.  If you're processing hundreds of millions \n", 
"of log entries in a single shot, the consolidations will slow the average processing \n", "speed more and more as the processing continues, potentially resulting in log processing \n", 
"times several times slower than they would be without consolidations.<p>\n", "If you're using a version of {PRODUCT_NAME} which supports extended progress information \n", 
"during database builds, then {PRODUCT_NAME} will report the amount of time it's spent \n", "consolidating in the Details section of the progress report.  This can help you determine \n", 
"if consolidation is a performance issue.\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_viewsbyemail \"Sending Multiple Views by Email\"\n", 
"FAQ_QUESTION_viewsbyemail\n", "  \"Can I configure {PRODUCT_NAME} to send several different views by email to a single person?\n", 
"  Can I send different views to different people?\"\n", "FAQ_SHORT_ANSWER_viewsbyemail\n", "  \"Yes; if you're sending to one person, you can create a custom view in the %22Stats Views%22 tab \n", 
"  containing any subviews you like, and send that by email.  If you need to send different views \n", 
"  to different people, you can use the %22extra option%22 in the Scheduler, or the command line, to send them.\"\n", 
"FAQ_LONG_ANSWER_viewsbyemail\n", "\"{PRODUCT_NAME}'s %22Send View By Email%22 feature lets you send any single view to any number \n", 
"of people, by selecting the view to send, and entering the email addresses. \n", "However, it is sometimes useful to send several views to a person, or several views \n", 
"to several people, and {PRODUCT_NAME}'s email feature does not allow this directly.  Fortunately, \n", 
"there are several indirect ways of accomplishing the same thing.<p>\n", "If you want to send several views\n", 
"in a single email message, you can create a custom view, in the Stats\n", "Views tab, which shows all the subviews you want, and then you can\n", 
"send that view by email.  For instance, you can create a new view called \n", "%22Bob View%22 which is sent to Bob, and you can add any subviews you want to that view \n", 
"(e.g. graph of traffic over time, top entry page, and top exit pages).  Then you can select \n", "that view as the view to send, enter Bob's email address, and Bob will receive those three \n", 
"subviews in a single message.  You can set the view so it doesn't appear in the normal statistics \n", 
"if you like, in the Stats Views tab.<p>\n", "If you need to send different views to different people, or if you don't want to create a \n", 
"new view, you can use {PRODUCT_NAME}'s command-line interface (AppleScript, on MacOS 9), \n", "or the %22extra options%22 field in the Scheduler,\n", 
"to send whatever you want.  Just use the following command line:<p>\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf <i>configname</i> -cm svbe -vtsbe %22<i>viewname</i>%22 -vea <i>to-emails</i></pre>\n", 
"For instance, you might use this command line:<p>\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf %22Bob's Config%22 -cm svbe -vtsbe %22Single-page summary%22 -vea bob@bob.com</pre>\n", 
"to send the Single-page summary view to bob@bob.com.\n", "The part after svbe can also be used in the %22extra options%22 of the Scheduler, with a %22send view by email%22\n", 
"scheduled item, to achieve the same effect without direct use of the command line.\n", "You'll also need to set the SMTP server and the \n", 
"return address in the Network tab of the Configuration options.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_exporttable \"Exporting Data From Statistics\"\n", 
"FAQ_QUESTION_exporttable\n", "  \"Can I export the data from {PRODUCT_NAME} reports to Excel or other programs?\"\n", 
"FAQ_SHORT_ANSWER_exporttable\n", "  \"Yes; click the %22export%22 link at the bottom of any table to export the data from \n", 
"  that table in CSV format.  Many programs, including Excel, can import CSV format files.\"\n", "FAQ_LONG_ANSWER_exporttable\n", 
"\"{PRODUCT_NAME} supports CSV export of any table.  Just \n", "view the statistics, find the table you want, and click the %22export%22 link \n", 
"at the bottom of the table.  Save the resulting file from your browser, and \n", "import it into Excel or any other program that supports CSV.<p>\n", 
"You can also generate CSV from the command line, like this: \n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf <i>config-name</i> -cm evt -asv %22view-name%22</pre>\n", 
"for instance,<p>\n", "<pre>  {PRODUCT_EXECUTABLE_DOCS} -rfcf MyConfig -cm evt -asv %22Top pages%22</pre>\n", 
"You can also use the -f option ([docs-filters]) on the command line to use filters \n", "on the table data.<p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_accuracy \"Are the Statistics Accurate?\"\n", "FAQ_QUESTION_accuracy\n", 
"  \"I've heard that statistics like visitors, %22sessions,%22 and %22paths through the site%22\n", 
"  can't be computed accurately.  Is that true?  Are the statistics reported by \n", "  {PRODUCT_NAME} an accurate description of the actual traffic on my site?\"\n", 
"FAQ_SHORT_ANSWER_accuracy\n", "  \"{PRODUCT_NAME} accurately reports the data <i>as it appears in the log file</i>. \n", 
"  However, many factors skew the data in the log file.  The statistics are still useful, \n", "  and the skew can be minimized through server configuration.\"\n", 
"FAQ_LONG_ANSWER_accuracy\n", "\"{PRODUCT_NAME} (and all other log analysis tools) reports statistics based on the\n", 
"contents of the log files.  With many types of servers, the log files \n", "accurately describe the traffic on the server (i.e. each file or page viewed \n", 
"by a visitor is shown in the log data), but web log files are trickier, \n", "due to the effects of caches, proxies, and dynamic IP addresses.<p> \n", 
"\n", "Caches are locations outside of the web server where previously-viewed \n", "pages or files are stored, to be accessed quickly in the future. \n", 
"Most web browsers have caches, so if you view a page and then return in the \n", "future, your browser will display the page <i>without contacting the web server</i>, \n", 
"so you'll see the page but the server will not log your access.  \n", "Other types of caches save data for entire organizations or networks. \n", 
"These caches make it difficult to track traffic, because many views of \n", "pages are not logged and cannot be reported by log analysis tools.<p>\n", 
"\n", "Caches interfere with all statistics, so unless you've defeated the cache \n", "in some way (see below), your web server statistics will not represent \n", 
"the actual viewings of the site.\n", "The logs are, however, the best information available in this case,\n", 
"and the statistics are far from useless.\n", "Caching means that none of the numbers you see are accurate \n", 
"representations of the number of pages actually views, bytes \n", "transferred, etc.  However, you can be reasonably sure that if your\n", 
"traffic doubles, your web stats will double too.  Put another way, web\n", "log analysis is a very good way of determining the <i>relative</i>\n", 
"performance of your web site, both to other web sites and to itself\n", "over time.  This is usually the most important thing, anyway-- since\n", 
"nobody can really measure true %22hits,%22 when you're comparing your hits\n", "to someone else hits, both are affected by the caching issues, so in\n", 
"general you can compare them successfully.\n", "\n", "If you really need completely accurate statistics, there are ways of\n", 
"defeating caches.  There are headers you can send which tell the cache\n", "not to cache your pages, which usually work, but are ignore by some\n", 
"caches.  A better solution is to add a random tag to every page, so\n", "instead of loading /index.html, they load /index.html?XASFKHAFIAJHDFS.\n", 
"That will prevent the page from getting cached anywhere down the line,\n", "which will give you complete accurate page counts (and paths through\n", 
"the site).  For instance, if someone goes back to a page earlier in\n", "their path, it will have a different tag the second time, and will be\n", 
"reloaded from the server, relogged, and your path statistics will be\n", "accurate.  However, by disabling caching, you're also defeating the\n", 
"point of caching, which is performance optimization-- so your web site\n", "will be slower if you do this.  Many choose to do it anyway, at least\n", 
"for brief intervals, in order to get %22true%22 statistics.\n", "\n", "The other half of the problem is dynamic IP addresses, and proxies. \n", 
"This affects the %22visitor%22 counts, in those cases where visitors \n", "are computed based on the unique hosts.  Normally, {PRODUCT_NAME} \n", 
"assumes that each unique originating hostname or IP is a unique visitor, \n", "but this is not generally true.  A single visitor can show up as multiple \n", 
"IP addresses if they are routed through several proxy servers, or \n", "if they disconnect and dial back in, and are assigned a new IP address. \n", 
"Multiple visitors can also show up as a single IP address if they \n", "all use the same proxy server.  Because of these factors, the visitor \n", 
"numbers (and the session numbers, which depend on them) are not \n", "particularly accurate unless visitor cookies are used (see below). \n", 
"Again, however, it's a reasonable number to throw around as the %22best\n", "available approximate%22 of the visitors, \n", 
"and these numbers tend to go up when your traffic goes up, \n", "so they can be used as effective <i>comparative</i> numbers.<p>\n", 
"\n", "As with caching, the unique hosts issue can be solved through web\n", "server configuration.  Many people use visitor cookies (a browser cookie \n", 
"assigned to each unique visitor, and unique to them forever) to track \n", "visitors and sessions accurately.  {PRODUCT_NAME} can be configured to \n", 
"use these visitor cookie as the visitor ID, by extracting the cookie \n", "using a log filter, and putting it in the %22visitor id%22 field. \n", 
"This isn't as foolproof as the cache-fooling method\n", "above, because some people have cookies disabled, but most have them\n", 
"enabled, so visitor cookies usually provide a very good approximation\n", "of the true visitors.  If you get really tricky you can configure\n", 
"{PRODUCT_NAME} and/or your server to use the cookie when it's available, and\n", "the IP address when it's not (or even the true originating IP address,\n", 
"if the proxy passes it).  Better yet, you can use the concatenation of the \n", "IP address and the user-agent field to get even closer to a unique visitor \n", 
"id even in cases where cookies are not available.\n", "So you can get pretty close to accurate visitor information if you really \n", 
"want to.<p>\n", "\n", "To summarize, with a default setup (caching allowed, no visitor\n", "cookies), {PRODUCT_NAME} will report hits and page views based on the log data, \n", 
"which will not precisely represent the actual traffic to the site, and so\n", "will and any other log analysis tool.  {PRODUCT_NAME} goes further\n", 
"into the speculative realm than some tools by reporting visitors, sessions, and paths\n", "through the site.  With some effort, your server can be configured to\n", 
"make these numbers fairly accurate.  Even if you don't, however, you\n", "can still use this as valuable comparative statistics, to compare the\n", 
"growth of your site over time, or to compare one of your sites to\n", "another.\n", "\"\n", "\n", "\n", 
"\n", "FAQ_TITLE_cgiuserpermissions \"CGI User Permissions\"\n", "FAQ_QUESTION_cgiuserpermissions\n", 
"  \"When I run {PRODUCT_NAME} as a CGI, it runs as a special user (nobody, web, apache, etc.).  Then \n", 
"  when I want to use {PRODUCT_NAME} from the command line or in web server mode, the permissions \n", 
"  don't allow it.  What can I do about this?\"\n", "FAQ_SHORT_ANSWER_cgiuserpermissions\n", "  \"Loosen the permissions in the Preferences, or run your CGI programs as a different user, \n", 
"  or run your command line programs as the CGI user.\"\n", "FAQ_LONG_ANSWER_cgiuserpermissions\n", 
"\"For security reasons, UNIX web servers often run CGI programs as a special\n", "user, often user nobody, or user web, or use cgi, or use apache. \n", 
"When you run {PRODUCT_NAME} in CGI mode, it runs as this user, and any files it creates \n", "are owned by that user.  This can cause problems if you later need to \n", 
"run {PRODUCT_NAME} as a different user, for instance to run a command-line database update-- \n", "the files which were created as the CGI user will not be accessible to the \n", 
"non-CGI user, and you will get errors about {PRODUCT_NAME} not being able to read or write \n", "certain files.<p>\n", 
"There are several possible solutions to this problem:<p>\n", "<ol>\n", "  <li> You can run your command lines as the CGI user.  This is often the easiest \n", 
"       solution.  Of your CGI user is user nobody, then use %22su nobody%22 to change \n", "       to user nobody, and then run your commands as that user.  Since both the CGI \n", 
"       version and the command-line version will be running as the same user, there \n", "       will be no permissions issues.  You may need to configure a password, shell, and home directory \n", 
"       for user nobody before you can log in as that user, which will require root access. \n", "       This option is slightly insecure because giving user %22nobody%22 a home directory and \n", 
"       a shell makes it a slightly more powerful user; if the purpose of using %22nobody%22 \n", "       as the CGI user was to run CGI programs with a powerless user, this circumvents that security \n", 
"       somewhat.<p>\n", "\n", "  <li> You can run your CGI program as the command-line user.  If your username \n", 
"       is %22myself%22, then you can reconfigure your web server to run CGI programs \n", "       as that user, rather than the user it's using now.  You may even be able to configure \n", 
"       the server to run only {PRODUCT_NAME} as that user, while continuing to run other programs \n", 
"       with the usual CGI user.  Because both the CGI version of {PRODUCT_NAME} and the command line \n", 
"       version will be running as user %22myself%22, there will be no permissions issues. \n", "       This may be difficult to configure, however; see your web server documentation for \n", 
"       instructions on how to configure your server to run CGI programs as a different user. \n", "       On some servers, this may not be possible.<p>\n", 
"\n", "  <li> You can change the permissions of the files that {PRODUCT_NAME} creates, \n", "       by editing the permissions options in the Preferences.  This is \n", 
"       usually an insecure solution, however, since you'll need to loosen \n", "       many of the permissions to 777 (everyone can read, write, execute/search), \n", 
"       which makes your files vulnerable to modification by unauthorized users on \n", "       the machine.  This option may be acceptable, however, if access to the machine \n", 
"       is limited to authorized users; i.e. if the only ones who can log in by telnet, \n", "       SSH, FTP, etc. are those who are trusted {PRODUCT_NAME} administrators.<p>\n", 
"</ol>\n", "Any one of these solutions will work; you do not need to do more than one of these.\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_frequentnewversions \"Frequent New Versions of {PRODUCT_NAME}\"\n", 
"FAQ_QUESTION_frequentnewversions\n", "  \"Why are new versions of {PRODUCT_NAME} released so often?  Is it buggy?  Do I need to download every new version?\"\n", 
"FAQ_SHORT_ANSWER_frequentnewversions\n", "  \"We ship new versions to provide our customers with the latest minor features and bug fixes quickly.\n", 
"    {PRODUCT_NAME} is no buggier than any other software (better than most!), and you don't need to download a new release unless\n", 
"    you're having problems with the current one.\"\n", "FAQ_LONG_ANSWER_frequentnewversions\n", "\"We've had a few people ask us why we ship new versions of {PRODUCT_NAME} so often. \n", 
"The reason is that we want to provide our customers with access to the latest \n", "minor features (e.g. new log formats) and bug fixes.  Our shipping process is \n", 
"highly automated, so it is relatively easy for us to ship a new version, so \n", "we do it frequently.  We generally ship a new version every two to four weeks,\n", 
"or sooner if we find a significant bug in the production version.<p>\n", "There are bugs in {PRODUCT_NAME}, just like there are bugs in <i>all</i> computer \n", 
"programs.  Of course, we strive to keep the bugs to a minimum, but {PRODUCT_NAME} is \n", "very complex software, and we get reports of a few new bugs every week.  We \n", 
"roll these into new releases every couple weeks, and ship them so that new \n", "downloaders won't be troubled by these bugs, and people who are experiencing them \n", 
"will be able to get a fixed version.  Other computer programs have similar numbers \n", "of bugs, but they package more bug fixes in each release, and release versions \n", 
"less frequently.<p>\n", "Unless you're having problems with the version of {PRODUCT_NAME} you're currently running, \n", 
"or you need a new feature we've added (like support for a new log format), there is \n", "no need to upgrade.  You can upgrade at whatever pace you like, and skip any upgrades \n", 
"in the middle; each new release of {PRODUCT_NAME} is a full release, so you don't have to have \n", 
"any previous version installed to use it.<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_relabeling \"Relabeling/White-labeling {PRODUCT_NAME}\"\n", 
"FAQ_QUESTION_relabeling\n", "  \"I want to deploy {PRODUCT_NAME} to my customers, but I want it to look like part of my \n", 
"  site.  I don't want the name {PRODUCT_NAME} to appear-- I want my own name to appear.  Can I re-label \n", 
"  or white-label {PRODUCT_NAME}?\"\n", "FAQ_SHORT_ANSWER_relabeling\n", "  \"Under the standard licensing, you may add custom headers and footers, and you may change the %22look and feel%22\n", 
"  of the statistics, but you may not change the name of the product.  It is possible to purchase a license to do relabel--\n", 
"  please contact {SUPPORT_EMAIL} if you are interested.\"\n", "FAQ_LONG_ANSWER_relabeling\n", "\"<p>You can easily add custom headers and footers, and change fonts and other attributes for the statistics.\n", 
"This can be done without any extra licensing.  It is also possible to relabel or white-label, but that requires\n", 
"special licensing-- the standard licensing does not permit it.  Please contact {SUPPORT_EMAIL} for information\n", 
"about relabeling.</p>\n", "\n", "<p>To add your own logo to every statistics page, etc. you can use custom HTML headers\n", 
"and footers, or write a script to generate the whole page on the fly, and have \n", "{PRODUCT_NAME} plug in its statistics at the appropriate place.  You can set these options in the Headers/Footers \n", 
"tab of the Configuration Options.</p>\n", "\n", "<p>You can remove the bar at the bottom of the statistics page (which includes the {PRODUCT_NAME} name, \n", 
"as well as the Flowerfire copyright), by hiding the %22information bar%22 in the Stats Views \n", "tab of the Configuration Options.  Since you'll need to remove the information bar from all \n", 
"subviews, it can get tedious to use the web interface-- it may be easiest to just search-and-replace \n", 
"in your configuration file (which is LogAnalysisInfo/Configs), replacing %22,InfoBar%22 \n", "with %22%22 (don't enter the quotes-- you're replacing ,InfoBar with nothing) to remove all the info bars.\n", 
"Or you can keep the info bar, and remove just \n", "the {PRODUCT_NAME} blurb from the left of the bar, by turning off the %22Show {PRODUCT_NAME} credit in information banner%22 \n", 
"link in the Stats Show/Hide tab of the Configuration Options.</p>\n", "\n", "<p>If you're really serious about removing all references to {PRODUCT_NAME}, from the documentation and \n", 
"administrative interface, error messages, and elsewhere, you'll need to edit the language modules, \n", 
"which are text files found in LogAnalysisInfo/Languages.  You can replace all occurrences of %22{PRODUCT_NAME}%22 \n", 
"there with %22Joe's Traffic Analyzer%22 if you like, which should prevent {PRODUCT_NAME}'s name from \n", 
"appearing in your statistics or in any other page generated by {PRODUCT_NAME}.  Again, this\n", "is not permitted under standard licensing-- please contact {SUPPORT_EMAIL} to arrange for \n", 
"a relabelling license.</p>\n", "\n", "<p>Regardless, you must leave the Flowerfire copyright intact.</p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_serverdown \"{PRODUCT_NAME} Server is Down\"\n", "FAQ_QUESTION_serverdown\n", 
"  \"I can't access {PRODUCT_NAME} where I usually do (http://<i>www.xxx.yyy.zzz</i>:8987/)-- is your (Flowerfire's) \n", 
"  server down?\"\n", "FAQ_SHORT_ANSWER_serverdown\n", "  \"No-- <i>your</i> server is down.  {PRODUCT_NAME} runs on your computer, not on ours-- contact \n", 
"  your network administrator if you're having problems accessing it.\"\n", "FAQ_LONG_ANSWER_serverdown\n", 
"\"{PRODUCT_NAME} runs as a web server on the computer where it was installed, which is \n", "a client computer, not one of our servers.  So if you're having trouble accessing {PRODUCT_NAME} \n", 
"through your web browser, it means that your installation of {PRODUCT_NAME} is messed up in some way \n", 
"({PRODUCT_NAME} may not be running where you expected it to be).  If you installed {PRODUCT_NAME} yourself, \n", 
"you may need to restart it.  If someone else installed {PRODUCT_NAME}, please contact them \n", "(it may be your network administrator) for assistance in getting {PRODUCT_NAME} up and running again.<p>\n", 
"\n", "On a related note, {PRODUCT_NAME} never contacts Flowerfire, or any of Flowerfire's computers.\n", 
"It does not transmit log data to \n", "Flowerfire, it does not transmit statistics to Flowerfire, it does not receive any information \n", 
"or data from Flowerfire, and in all other ways it is a complete self-contained program that does \n", 
"not rely on Flowerfire's servers.  Because {PRODUCT_NAME} runs as a web server, people often assume that \n", 
"{PRODUCT_NAME} is actually running on the Internet, on one of our servers, but it isn't-- it runs on your \n", 
"computers, and does not use the Internet or the network except where you specifically ask for it \n", 
"(i.e. to download files by FTP when you've requested that it do so, or to send mail when you've asked it to,\n", 
"or to look up IP numbers using DNS when you've asked it to).<p>\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_printingcolorslost \"Printing From IE\"\n", 
"FAQ_QUESTION_printingcolorslost\n", "  \"When I print the statistics from IE, the don't look much like they do on the screen-- a lot of the color\n", 
"  and formatting seems to be gone.  How can I fix this?\"\n", "FAQ_SHORT_ANSWER_printingcolorslost\n", 
"  \"In the Tools menu, choose Internet Options.  Click the Advanced tab, and click %22Print background colors and images%22 in the Printing category.\"\n", 
"FAQ_LONG_ANSWER_printingcolorslost\n", "\"Internet Explorer does not print colored backgrounds and images by default.  Since {PRODUCT_NAME} uses these\n", 
"(especially colored backgrounds) for much of its formatting, the statistics will look poor when printed\n", 
"with the default settings.  To turn this option on, do this:<p>\n", "<ol>\n", "<li> Open Internet Explorer\n", 
"<li> Choose Internet Options from the Tools menu\n", "<li> Click the Advanced tab\n", "<li> In the section called Printing, click %22Pring background colors and images%22\n", 
"<li> Click OK at the bottom of the window\n", "</ol>\n", "Now, try printing again-- it should look just like it does on the screen.<P>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_missingdays \"Days Are Missing from the Log Data\"\n", "FAQ_QUESTION_missingdays\n", 
"  \"When I look at my statistics, I see that some days are missing.  I know I had traffic on those days.  Why \n", 
"  aren't they shown?\"\n", "FAQ_SHORT_ANSWER_missingdays\n", "  \"Your ISP may be regularly deleting or rotating your log data.\n", 
"  Ask them to leave all your log data, or rotate it over a longer interval.\n", "  It's also possible that your log data does not contain those days for another reason.\"\n", 
"FAQ_LONG_ANSWER_missingdays\n", "\"To save disk space, many ISPs delete, or %22rotate%22 (rename and/or compress) the server log\n", 
"data regularly.  For instance, instead of letting the log file grow forever, they may\n", "rename it every day, start a new one, and compress the old one; then, every week, they may\n", 
"delete the logs older than seven day.  In other, more dramatic cases, they may simply\n", "delete the log file every month or week, and restart a new one.<p>\n", 
"\n", "Though this does save disk space on the server, it presents serious problems for \n", "log analysis.  When you rebuild the database with {PRODUCT_NAME}, it processes all\n", 
"the existing log data, and creates a new database from it.  If some of the old log\n", "data has been deleted, that data will no longer be available in the statistics.\n", 
"So if the ISP deletes the logs every month, and you rebuild your database, your\n", "statistics will go back one month at the most.<p>\n", 
"\n", "Similarly, when you update the database, {PRODUCT_NAME} adds any new data in the \n", "existing log data to the database.  So if the ISP deletes log files every month,\n", 
"and you only update your database every month on the 15th, then all the data from\n", "the 15th to the end of each month will be missing, because it was not added through\n", 
"an update, and it was deleted on the 1st of the month.<p>\n", "\n", "The best solution is to convince your ISP to keep all of your log data, and never\n", 
"delete any of it.  If you can do that, then there will be no problem-- you'll\n", "always be able to rebuild or update your database and get all of the statistics.\n", 
"Since this will require more of your ISPs disk space, however, they may not be\n", "willing to do this, especially if you have a very large site, or they may\n", 
"charge extra for the service.  Of course, if you own and manage your own server,\n", "you can do this yourself.<p>\n", 
"\n", "The second best solution, if you can't convince the ISP to keep all log data, is\n", "to store your back log files on your own system.  If your ISP rotates the data\n", 
"through several logs before deleting the oldest one, this is easy-- just download\n", "the logs you don't have regularly (you may be able to automate this using an FTP\n", 
"client).  If they only keep one copy, and delete it and restart it regularly,\n", "then you'll need to download that file as close to the reset time as possible,\n", 
"to get as much data as possible before it is deleted.  This is not a reasonable\n", "way for ISPs to rotate logs, and you should try to convince them to rotate\n", 
"through several files before deleting the oldest one, but some of them do it\n", "this way anyway.  You'll never get <i>all</i> of your log data if they use\n", 
"this technique-- the very last entries before deletion will always be lost--\n", "but if you time it right you can get pretty close.<p>\n", 
"\n", "Once you have the logs on your system, you can analyze that at your leisure,\n", "without worrying about them being deleted.  In this situation, you'll\n", 
"probably want to run {PRODUCT_NAME} on the system where you keep the back logs.\n", "\n", "If your log rotation is not the issue, then it may be that your log data does\n", 
"not contain the data for another reason.  Maybe the server was down for a period,\n", "or the log data was lost in a disk outage, or it was corrupted.  Look at the log\n", 
"data yourself, using a text editor, to make sure that it really does contain the\n", "days that you expected it to contain.  If the data isn't in your logs,\n", 
"{PRODUCT_NAME} cannot report statistics on it.\n", "\"\n", "\n", "\n", "\n", "FAQ_TITLE_sessioncomputation \"Session Computation\"\n", 
"FAQ_QUESTION_sessioncomputation\n", "  \"How does {PRODUCT_NAME} compute session information, like total sessions, repeat visitors, \n", 
"  paths through the site, entry pages, exit pages, time spent per page, etc.?\"\n", "FAQ_SHORT_ANSWER_sessioncomputation\n", 
"  \"{PRODUCT_NAME} uses the visitor id field to identify unique visitors.  It decides that \n", "  a new session has begun if a visitor has been idle for 30 minutes. \n", 
"  It rejects sessions longer than 2 hours.\"\n", "FAQ_LONG_ANSWER_sessioncomputation\n", "\"{PRODUCT_NAME} computes session information by tracking the page, date/time, and visitor id \n", 
"(which is usually the originating hostname) for each page view in the log data.  When a session \n", 
"view is requested, it processes all of these page views at the time of the request, \n", "ignoring those that are filtered out by filters on the page or date/time fields.\n", 
"All other hits are included-- filters on other fields are ignored in session information.<p>\n", "{PRODUCT_NAME} groups the hits into initial sessions based on the visitor id-- it start by \n", 
"assuming that each visitor contributed one session.  It sorts the hits by date so it has \n", "a click-by-click record of the movement of each visitor.<p>\n", 
"Then it splits the sessions, using the customizable session timeout interval (30 minutes by default). \n", 
"Since there is no real %22log out%22 operation in HTTP, there is no way for {PRODUCT_NAME} to know the \n", 
"<i>real</i> time that a user leaves the site; it can only guess by assuming that if they \n", "didn't click anything for 30 minutes, they must have left and come back. \n", 
"The split step, then, increases the number of sessions, resulting in possibly more than \n", "one session per visitor.<p>\n", 
"Next, {PRODUCT_NAME} discards sessions over 2 hours long (this is configurable).  The idea behind this is that \n", 
"most web sessions are considerably shorter than that, so there's a good chance that any really \n", 
"long session is actually caused by multiple visitors using the same proxy server to visit the site. \n", 
"That looks like one long session because all of the hits seem to come from the proxy server.\n", "{PRODUCT_NAME} rejects these because there is no way to tell which hits were from a particular visitor.\n", 
"If you're using visitor cookies to track unique visitors, this will not be a problem, so you can \n", 
"turn this option to a high value to see all your sessions, even those over 2 hours.<p>\n", "Finally, {PRODUCT_NAME} discards sessions based on the Session Filters (which you can set \n", 
"in the Session Filters bar at the top of the statistics).  The session filters can be set to \n", "discard all sessions except those from a particular visitor, or they can be set to discard \n", 
"all sessions except those which go through a particular page.<p>\n", "After that, {PRODUCT_NAME} is ready to generate the statistics reports.  \n", 
"The %22Sessions Overview%22 view is generated by examining the sessions in various ways\n", "(for instance, the repeat visitors number is the number of visitors which have more than \n", 
"one session; i.e. those whose sessions were %22split%22 by the timeout interval). \n", "The %22entry pages%22 and %22exit pages%22 view is generated by tabulating the first and \n", 
"last pages of every session.  The %22time spent per page%22 view is generated by finding \n", "every occurrence of each page in any session, computing how long it was from then until the next \n", 
"page in that session (exit pages are considered to have zero time spent per page), and tabulating \n", 
"the results for all pages.  The %22paths through the site%22 view shows all the sessions \n", "in a single expandable view.<p>\n", 
"\"\n", "\n", "\n", "\n", "FAQ_TITLE_visitorsvssessionhosts \"Visitors vs. Session Hosts\"\n", "FAQ_QUESTION_visitorsvssessionhosts\n", 
"  \"Why doesn't the number of visitors in the Overview match the number of unique hosts in the\n", 
"  %22Session (summary)%22 view?\"\n", "FAQ_SHORT_ANSWER_visitorsvssessionhosts\n", "  \"Session information only shows hosts contributing page views, and other views\n", 
"  show all visitors.  Also, long sessions are discarded from the session information.\"\n", "FAQ_LONG_ANSWER_visitorsvssessionhosts\n", 
"\"<p>The configuration database is split into two major sections: the main statistics, and \n", "the session information.  The main statistics contains information on all hits; the \n", 
"session information shows the %22sessions%22-- i.e. it tracks the sequence of page views\n", "of each person who visits the site.  Most views show the main statistics; only the session-related\n", 
"views (Sessions (summary), Sessions, Paths through the site, Entry pages, Exit pages, Paths through\n", 
"a page, and Time spent per page) show the session information.  Because these two types of data are\n", 
"computed differently, the numbers may vary between the two.</p>\n", "<p>There are two major factors that affect the unique hosts in session reports, but do not\n", 
"affect the visitors.  First, session information is based on page views only, while visitor\n", "information is computed based on all hits in the database.  So for instance, if the web site\n", 
"is accessed by a browser that fetches only a single image file, and never hits a page, that hit\n", 
"(and that host) will appear in the main statistics, but not in the session statistics.\n", "To put it another way, the visitors are the number of unique hosts who contributed hits;\n", 
"the session unique hosts are the number of unique hosts contributing page views.\n", "If your database is set up to track hits or bandwidth, these numbers may be significantly different.\n", 
"if your database tracks only page views, then visitor information will also be based on page views,\n", 
"and visitors and session unique hosts will be closer.</p>\n", "<p>The second factor is that long sessions are discarded from the session information.\n", 
"By default, sessions longer than 2 hours are assumed to be %22fake%22 sessions, resulting\n", "from the use of a large cache server by multiple users.  {PRODUCT_NAME} discards these\n", 
"sessions from the statistics, because these sessions are not accurate representations\n", "of the way any single user moves through the site-- they are semi-random juxtapositions\n", 
"of multiple true sessions, and are not very useful.  The default\n", "maximum session duration is 2 hours; this can be customized in the Stats Misc tab of the\n", 
"Configuration Options.  Setting this to 0 will cause all sessions to be included,\n", "eliminating this difference between visitors and session unique hosts.</p>\n" 
"<p>Incidentally, using %22visitor cookies%22 or %22session cookies%22 in your log data\n", "and configuring {PRODUCT_NAME} to use those as visitor ids (see [faq-visitorcookies] will eliminate\n", 
"the need for this 2-hour maximum.</p>\n" "\"\n", "\n", "\n", "\n", 
#ifdef BCREPORT
 "FAQ_TITLE_pricing \"{PRODUCT_NAME} Pricing and Licensing\"\n", "FAQ_QUESTION_pricing\n", "  \"How much does {PRODUCT_NAME} cost?\"\n", 
"FAQ_SHORT_ANSWER_pricing\n", "  \"See <a href=%22http://www.bluecoat.com/%22>http://www.bluecoat.com</a>.\"\n", 
"FAQ_LONG_ANSWER_pricing\n", "  \"See <a href=%22http://www.bluecoat.com/%22>http://www.bluecoat.com</a> for\n", 
"  information on pricing and licensing of {PRODUCT_NAME}.\"\n", 
#else
 
#ifdef SAWMILL
 "FAQ_TITLE_pricing \"{PRODUCT_NAME} Pricing and Licensing\"\n", "FAQ_QUESTION_pricing\n", "  \"How much does {PRODUCT_NAME} cost?\"\n", 
"FAQ_SHORT_ANSWER_pricing\n", "  \"$99 for an individual, $399 for a small organization,\n", "  and between $1 and $8 per client for an multi-client (ISP) license, depending on volume.\n", 
"  Large organization (enterprise) pricing is available upon request.\n", "  Students receive a 75% discount; educational institutions receive a 20% discount.\"\n", 
"FAQ_LONG_ANSWER_pricing\n", "\"{PRODUCT_NAME}'s price structure is as follows (see notes below):<p>\n", 
"\n", "<table border=%221%22 cellspacing=0 cellpadding=5>\n", " <tr>\n", "  <td align=%22center%22>\n", 
"   <b>License</b>\n", "  </td>\n", "  <td align=%22center%22>\n", "   <b>Price</b>\n", "  </td>\n", 
" </tr>\n", " <tr>\n", "  <td align=%22center%22>\n", "   <b>Individual</b><br>\n", "   (one user; not for organizations)\n", 
"  </td>\n", "  <td align=%22center%22>\n", "   US$ 99\n", "  </td>\n", " </tr>\n", " <tr>\n", "  <td align=%22center%22>\n", 
"   <b>Small company, department, or organization</b><br>\n", "   (used to view your own statistics;<br>\n" 
"   a %22user%22 is someone who views statistics; see Notes, below)\n", "  </td>\n", "  <td align=%22center%22>\n", 
"   US$ 199 for a 5-user license<br>\n" "   US$ 399 for a 50-user license\n", "  </td>    \n", " </tr>\n", 
" <tr>\n", "  <td align=%22center%22>\n", "   <b>Multi-client (ISP)</b><br>\n", "   (used to provide statistics to your clients;<br>\n", 
"   if you also need to analyze your own servers or network yourself,<br>\n", "   you need an additional %22organization%22 license)\n", 
"  </td>\n", "  <td align=%22center%22>\n", "   US$ 199 for a 25-client license<br>\n", "   US$ 399 for a 200-client license<br>\n", 
"   US$ 999 for a 1000-client license<br>\n", "   <br>\n", "   %22turnkey%22 services are also available for<br> expert-assisted integration with your environment.\n", 
"  </td>    \n", " </tr>\n", " <tr>\n", "  <td align=%22center%22>\n", "   <b>Large company or organization site license</b>\n", 
"  </td>\n", "  <td align=%22center%22>\n", "   price available on request<br>\n", "   email <a href=%22mailto:support@sawmill.net%22>support@sawmill.net</a>\n", 
"  </td>    \n", " </tr>\n", " <tr>\n", "  <td align=%22center%22>\n", "   <b>Premium Support (including free updates)</b>\n", 
"  </td>\n", "  <td align=%22center%22>\n", "   20% of license price ($100 minimum), annually<br>\n", 
"  </td>    \n", " </tr>\n", "</table>\n", "\n", "<br>\n", "Notes:<p>\n", "\n", "<ul>\n", "  <li> A <i>user</i> is a person who either administrates {PRODUCT_NAME} or views the \n", 
"       statistics.  <i>User</i> refers to total, not simultaneous, users. \n", "       For example, if your company has three network analysts who \n", 
"       will install and configure {PRODUCT_NAME}, and fifteen managers who will look at the \n", "       statistics (through the web, or email, or on paper, or on an overhead projector, etc.),\n", 
"       then you have eighteen {PRODUCT_NAME} users, \n", "       even if only one of them is using it at a time, \n", 
"       and you need the Small Organization license.<p>\n", "\n", "  <li> The Individual and Organization licenses are for a single installation of {PRODUCT_NAME}--to run {PRODUCT_NAME} simultaneously on\n", 
"       multiple computers, you must purchase multiple licenses.  A single ISP license may be used to run {PRODUCT_NAME}\n", 
"       on any number of computers.<p>\n", "\n", "  <li> When you purchase {PRODUCT_NAME}, you get it for all supported platforms\n", 
"       at no additional charge.  This means that you can move it from one server\n", "       to another of a different platform without purchasing a new license.\n", 
"       However, as mentioned in the previous point, you cannot use the same\n", "       license <i>simultaneously</i> on multiple computers (except ISPs--see below).<p>\n", 
"\n", "  <li> You can use a single license to analyze any amount of log data, from any number of servers.<p>\n", 
"\n", "  <li> Students can purchase {PRODUCT_NAME} at a 75% discount\n", "       (i.e. for 25% of the organization price, or US$99.75).\n", 
"       Educational institutions like schools can purchase it at a 20% discount.\n", "       To place an online student order with the discount, please order at\n", 
"       <a href=%22http://www.sawmill.net/ordering.html%22>{PRODUCT_NAME} the Ordering Page</a>,\n", 
"       and choose an educational-discount item from the store list.  To place an institutionally-discounted\n", 
"       order, use a purchase order or send the discounted amount to sawmill@flowerfire.com using PayPal (paypal.com).<p>\n", 
"\n", "  <li> If you're using {PRODUCT_NAME} to serve statistics to multiple clients (for instance, \n", 
"       if you're a web hosting provider, or ISP, you can purchase one of the multi-client licenses. \n", 
"       These licenses provide all of the features of the other licenses, but \n", "       at a discount.  These licenses can only be used if you are serving statistics to multiple clients.\n", 
"       A multi-client license cannot be used to analyze your own statistics-- it can only be used to \n", 
"       serve statistics to clients.  If you need to serve statistics <i>and</i> analyze your own\n", 
"       statistics, you need two licenses: a multi-client license and a multi-user license.<p> \n", 
"\n", "  <li> Multi-client licenses are priced according to the number of clients you will be serving \n", 
"       statistisc to.  The number of clients of a web hosting provider generally corresponds to \n", 
"       the number of web sites or domains served by the provider, but in some cases (for instance, \n", 
"       where a single domain serves many customers) the number of customers may be more. \n", "       In some cases (for instance, there a single customer owns several domains), the number of \n", 
"       customers may be <i>less</i> than the number of domains.  In both these cases, the \n", "       licensing is determined by the number of customers, not the number of domains. \n", 
"       With multi-client licenses, there is no limit to the number of people who can use {PRODUCT_NAME}, or \n", 
"       view the statistics; any number of people can use {PRODUCT_NAME}, as long as the maximum \n", 
"       number of clients is not exceeded.<p> \n", "\n", "  <li> All licenses are perpetual--there are no fees beyond the initial purchase.\n", 
"       Minor bug-fix upgrades are free.  We reserve the right to charge for major updates;\n", "       typically we charge 25% of the list price for major updates.<p>\n", 
"\n", "  <li> All license include Basic Support.  Basic Support provides email or phone support, with 24-hour expected \n", 
"       response time.  Premium Support provides email or phone support through\n", "       dedicated channels (special phone and email addresses), with top priority for responses.  Premium\n", 
"       Support requests are handled and as soon as possible in all cases, and have priority over Basic Support requests.\n", 
"       Premium Support also includes free updates, including major versions, so as long as you continue paying for\n", 
"       Premium Support, there will be no additional licensing fees to move up to the latest major versions.<p>\n", 
"\n", "  <li> If you need to upgrade your license to a larger one (for instance, upgrade a 25-customer ISP \n", 
"       license to a 200-customer ISP license), you can upgrade for the difference in prices.  For instance, \n", 
"       you can upgrade from a 25-customer ($199) license to a 200-customer ($399) license for $200.<p>\n", 
"\n", "</ul>\n", "\n", "If you have questions about the licensing scheme, or if you feel that the scheme\n", 
"or the prices are inappropriate in your case, please contact us at\n", "<a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>; we're flexible.<p>\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_sawmillname \"The Name %22{PRODUCT_NAME}%22\"\n", "FAQ_QUESTION_sawmillname\n", 
"  \"Where did the name %22{PRODUCT_NAME}%22 come from?\"\n", "FAQ_SHORT_ANSWER_sawmillname\n", "  \"A sawmill is a tool that processes logs, and so is {PRODUCT_NAME}.\"\n", 
"FAQ_LONG_ANSWER_sawmillname\n", "  \"A sawmill is a tool that processes logs (the kind made from trees), and so is {PRODUCT_NAME} (it processes web server logs).\"\n", 
"\n", "\n", "\n", "FAQ_TITLE_upgradepricing \"Upgrade Pricing\"\n", "FAQ_QUESTION_upgradepricing\n", 
"  \"How much will I have to pay to upgrade to the next version of {PRODUCT_NAME}?\"\n", "FAQ_SHORT_ANSWER_upgradepricing\n", 
"  \"Minor upgrades are free; major upgrades are discounted.  Currently the major upgrade discount is 75%.\"\n", 
"FAQ_LONG_ANSWER_upgradepricing\n", "\"Minor upgrades, like the upgrade from 6.0 to 6.0.1 or from any 6.x version to any other 6.x version, \n", 
"are free-- you can just download them from the web site, and they will work with your existing \n", 
"license key.<p>\n", "Major upgrades, like the upgrade from version 5 to version 6, are sold at a discount. \n", 
"The current discount is 75%, though this may change for later versions. \n", "For instance, if you purchased a {PRODUCT_NAME} 5 license for $99, and you want \n", 
"to upgrade that license to {PRODUCT_NAME} 6, you will need to pay $24.75 (25% of $99).<p>\"\n", "\n", 
"\n", "\n", 
#else
 
#error Unknown product

#endif
 
#endif
 0 };

