//
// Sawmill Source Code
// 
// This source code is the intellectual property of Flowerfire,
// and is protected by federal trade secret laws.  Do not
// redistribute, modify, or use this source code, except to compile
// it, without the express written consent of Flowerfire.
//
// For more information, see http://www.sawmill.net/trade_secret.html
//
// The trial and full commercial licenses for Sawmill allow you
// to use the program, and to compile it from this source code,
// but you are not permitted to look at this source code.  Please
// do not attempt to use this source code for any purpose other 
// then compilation!



















































 
#include "sconfig.h"
 const char *Sb3e27640ada2aa9d1f0cd5e66ee53318[] = { "##\n", "## Language Module -- Options\n", "##\n", 
"## This is the Options section of the default English language module\n", "##\n", "\n", "\n", "DIRECTORY_WORD directory\n", 
"\n", "COLOR_COMPONENTS_INFO\n", "\"The color is specified using additive red, green, and blue components.\n", 
"The red component is listed first, then the green, then the blue.\n", "Color components vary from 0 to 255, where 0 is represents none of that color\n", 
"and 255 represents the maximum amount of that color\"\n", "\n", "##\n", "## FILTER OPTION CATEGORY\n", 
"##\n", "\n", "# date_offset info\n", "OPTION_LABEL_do              \"Date offset (hours + or -)\"\n", 
"OPTION_SHORT_DESCRIPTION_do  \"The number of hours to add to each date in the log file\"\n", "OPTION_LONG_DESCRIPTION_do\n", 
"\"This specifies the number of hours to add to the dates in the log file.\n", "A positive value causes that many hours to be added to every date in the log\n", 
"as it is read, and a negative value causes hours to be subtracted. \n", "for instance, if your log data is in GMT (as some format are, including some \n", 
"W3C-based formats), but your time zone is GMT-8 \n", "(i.e. Pacific Standard Time), then you should enter -8 here.\n", 
"A value of zero leaves the dates unchanged.\n", "Fractional hours are allowed; e.g. 9.5.\n", "\"\n", 
"\n", "# skip_log_entry option info\n", "OPTION_LABEL_sle              \"Log entries skipped for each processed\"\n", 
"OPTION_SHORT_DESCRIPTION_sle  \"Number of log entries skipped for each log entry processed\"\n", "OPTION_LONG_DESCRIPTION_sle\n", 
"\"This controls the number of log entries which will be skipped for every one processed.\n", "A value of 10, for instance, means that ten entries will be ignored after each entry is processed.\n", 
"This essentially reduces the log data size, which greatly speeds processing.\n", "However, since the data is discarded, it will not appear in the statistics.\n", 
"The hits and bandwidth numbers displayed in a statistics page will be\n", "adjusted to be statistical estimates of what they would have been if the\n", 
"entire file had been processed.\n", "This can be used to approximate the statistics quickly.  See also [sfle].\"\n", 
"\n", "# skip_log_entry option info\n", "OPTION_LABEL_fbs              \"Filter log entries before skipping\"\n", 
"OPTION_SHORT_DESCRIPTION_fbs  \"Whether to apply the filters before applying the skipping rule, or vice versa\"\n", 
"OPTION_LONG_DESCRIPTION_fbs\n", "\"This specifies whether the filters should be applied to a log entry before \n", 
"the skipping rules, or whether the skipping rule should be applied first. \n", "If this option is checked (true), the filters (see [lf]) are applied to every \n", 
"log entry, and only those that are accepted by the filters are subject to the \n", "entry skipping rule (see [sle]).  If this option is unchecked (false), \n", 
"the skipping rule is applied first, and only those that are not skipped \n", "are passed through to the filters.  Applying the filters first is \n", 
"considerably slower, because {PRODUCT_NAME} has to process, parse, and filter every line \n", "in the log data.  However, applying the skipping rule first can result in incorrect \n", 
"estimate of the log data, especially if the structure of the log data is such that \n", "the lines which are likely to be filtered are also like to be skipped.\"\n", 
"\n", "# skip_first_log_entry option info\n", "OPTION_LABEL_sfle               \"Log entries skipped at start of log data\"\n", 
"OPTION_SHORT_DESCRIPTION_sfle   \"Number of log entries skipped at the start of the log data\"\n", 
"OPTION_LONG_DESCRIPTION_sfle\n", "\"This controls the number of log entries which will be skipped at the start of the\n", 
"log data.  This number of entries will be ignored, and then the rest will be\n", "processed as usual.  This provides a simple way to speed the processing of a log\n", 
"when you know a chunk of entries at the beginning will be rejected by the filters\n", "(for instance, an %22all hits in the past week%22 configuration on a long-term log).\n", 
"See also [sle].\"\n", "\n", "# skip_processed_filenames_on_update option info\n", "OPTION_LABEL_spfou              \"Skip processed files on update\"\n", 
"OPTION_SHORT_DESCRIPTION_spfou  \"Skip files which have already been processed (judging by their filenames) during a database update or add operation\"\n", 
"OPTION_LONG_DESCRIPTION_spfou\n", "\"This controls whether {PRODUCT_NAME} uses the filenames of log files \n", 
"to determine if the files have already been added to the database. \n", "If this option is checked (true), then {PRODUCT_NAME} will skip over any log files \n", 
"in the log source if it has already added a file with that name to the database. \n", "This can speed processing, especially when using FTP, because {PRODUCT_NAME} does not \n", 
"have to download or process the file data and use its more sophisticated checking mechanism \n", "to see if the data has been processed.  However, it will not work properly if \n", 
"you have log files in your log source which are growing from update to update, \n", "or if you have log files with the same name which contain different data. \n", 
"If this option is off, {PRODUCT_NAME} will handle those situations correctly, but \n", "it will have to download and examine the log data of all files to do it.\"\n", 
"\n", "# reject_entries_before info\n", "OPTION_LABEL_reb              \"Reject entries before (dd/mmm/yyyy hh:mm:ss)\"\n", 
"OPTION_SHORT_DESCRIPTION_reb  \"Date/time before which all log entries should be rejected\"\n", "OPTION_LONG_DESCRIPTION_reb\n", 
"\"This specifies the earliest date/time to appear in the database.\n", "Log entries with a date/time field earlier than this will be immediately rejected; \n", 
"the rest will be passed on to the filters to be accepted or rejected.  See [rea].\"\n", "\n", "# reject_entries_after info\n", 
"OPTION_LABEL_rea              \"Reject entries after (dd/mmm/yyyy hh:mm:ss)\"\n", "OPTION_SHORT_DESCRIPTION_rea  \"Date/time after which all log entries should be rejected\"\n", 
"OPTION_LONG_DESCRIPTION_rea\n", "\"This specifies the latest date/time to appear in the database.\n", 
"Log entries with a date/time field later than this will be immediately rejected; \n", "the rest will be passed on to the filters to be accepted or rejected.  See [reb].\"\n", 
"\n", "\n", "# log_parsing_filter option info\n", "OPTION_LABEL_lpf              \"Log parsing filters\"     \n", 
"OPTION_SHORT_DESCRIPTION_lpf  \"Specifies the filters used to parse the log file\"\n", "OPTION_LONG_DESCRIPTION_lpf\n", 
"\"Log parsing filters are similar to normal log filters (see [lf] and [docs-filters]),\n", "but they are executed before the normal filters.  Log parsing filters are generally used \n", 
"to <i>parse</i> (process/interpret) \n", "the log data into fields; normal log filters are used to accept or rejects data based on the fields.\n", 
"Log entries which are accepted by the parsing filters are passed on to the normal filters for final \n", 
"filtering.  Log entries which are rejected by the parsing filters are not run through the normal filters, \n", 
"and do not make it into the database.\n", "Some log formats automatically include log parsing filters as part of the format description \n", 
"(e.g. WebSTAR, which uses a single parsing filter to convert : to / in pathnames, and Serv-U FTP Log Format,\n", 
"which uses a much more complicated series of filters to collect log entries from multiple lines). \n", 
"Unless you define a custom log format, you do not need to modify the log parsing filters.<p>\"\n", 
"\n", "# log_filter option info\n", "OPTION_LABEL_lf              \"Log filters\"     \n", "OPTION_SHORT_DESCRIPTION_lf  \"Specifies one filter to accept or reject log entries\"\n", 
"OPTION_LONG_DESCRIPTION_lf\n", "\"{PRODUCT_NAME} accepts or rejects entries in the log data based on \n", 
"a collection of filters.  These filters can be used to display \n", "only part of the log data, for instance if you're interested only in \n", 
"the hits on a particular {DIRECTORY_WORD}, or on a particular day.  The \n", "filters are very powerful; you can use them to prune the data in almost \n", 
"any imaginable way.  See [docs-filters] for more information.<p>\n", "<h4>The filter type</h4>\n", 
"{PRODUCT_NAME} supports four major types of filters:\n", "<ul>\n", "  <li> <b>{FILTER_TYPE_if_a_then_b_else_c}</b> (<code>if_a_then_b_else_c</code>).\n", 
"       The filter checks the value of the A section, and performs the\n", "       action specified in the B section if A is true, or in the C\n", 
"       section if A is false.<p>\n", "  <li> <b>{FILTER_TYPE_if_a_then_b_c}</b> (<code>if_a_then_b_c</code>).\n", 
"       The filter checks the value of the A section, and if A is true, it performs the\n", "       action specified in the B section, and then performs the action specified in the C section.\n", 
"       If A is false, it goes to the next filter, ignoring both the B and C sections.<p>\n", "  <li> <b>{FILTER_TYPE_do_b_then_c}</b> (<code>do_b_then_c</code>).\n", 
"       The filter performs the action in the B section, and then\n", "       performs the action in the C section.<p>\n", 
"  <li> <b>{FILTER_TYPE_do_b}</b> (<code>do_b</code>).\n", "       The filter performs the action in the B section.<p>\n", 
"</ul>\n", "<h4>The filter expression type</h4>\n", "In order to handle if/then/else constructs (the first option above), {PRODUCT_NAME}\n", 
"supports the following types of true/false expressions:<p>\n", "<ul>\n", "  <li> <b>{FILTER_OP_equals}</b> (<code>equals</code>).\n", 
"       This compares the left and right operands.  It is true if the operands\n", "       are equal, and false if they are not equal.<p>\n", 
"  <li> <b>{FILTER_OP_not_equals}</b> (<code>not_equals</code>).\n", "       This compares the left and right operands.  It is true if the operands\n", 
"       are not equal, and false if they are equal.<p>\n", "  <li> <b>{FILTER_OP_contains}</b> (<code>contains</code>).\n", 
"       This checks if the left operand is contained in the right operand.\n", "       It is true if it is (e.g. if the left is %22cat%22 and the right is\n", 
"       %22scatter,%22 %22cattle,%22 or %22scat%22), and false if it is not.<p>\n", "  <li> <b>{FILTER_OP_starts_with}</b> (<code>starts_with</code>).\n", 
"       This checks if the beginning of the right operand is equal to the left operand.\n", "       It is true if it is (i.e. if the left operand is a prefix of the right),\n", 
"       and false if it is not.<p>\n", "  <li> <b>{FILTER_OP_ends_with}</b> (<code>ends_with</code>).\n", 
"       This checks if the end of the right operand is equal to the left operand.\n", "       It is true if it is (i.e. if the left operand is a suffix of the right),\n", 
"       and false if it is not.<p>\n", "  <li> <b>{FILTER_OP_less_than}</b> (<code>less_than</code>).\n", 
"       This checks if the left operand is less than the right operand.\n", "       Comparisons are numerical for numerical fields, chronological for date/time\n", 
"       fields, and lexical (alphabetical) for other fields.\n", "       It is true if the left operand is less than the right, and false if it is not.<p>\n", 
"  <li> <b>{FILTER_OP_greater_than}</b> (<code>greater_than</code>).\n", "       This checks if the left operand is greater than the right operand.\n", 
"       Comparisons are numerical for numerical fields, chronological for date/time\n", "       fields, and lexical (alphabetical) for other fields.\n", 
"       It is true if the left operand is greater than the right, and false if it is not.<p>\n", "  <li> <b>{FILTER_OP_less_than_or_equal}</b> (<code>less_than_or_equal</code>).\n", 
"       This checks if the left operand is less than or equal to the right operand.\n", "       Comparisons are numerical for numerical fields, chronological for date/time\n", 
"       fields, and lexical (alphabetical) for other fields.\n", "       It is true if the left operand is less than or equal to the right, and false if it is not.<p>\n", 
"  <li> <b>{FILTER_OP_greater_than_or_equal}</b> (<code>greater_than_or_equal</code>).\n", "       This checks if the left operand is greater than or equal to the right operand.\n", 
"       Comparisons are numerical for numerical fields, chronological for date/time\n", "       fields, and lexical (alphabetical) for other fields.\n", 
"       It is true if the left operand is greater than or equal to the right, and false if it is not.<p>\n", 
"  <li> <b>{FILTER_OP_older_than}</b> (<code>older_than</code>).\n", "       This checks if the left operand is older than the number of days specified by the right operand.\n", 
"       The left operand must be a date/time field.\n", "       This is true if the left operand date is older than the number of days specified by the right,\n", 
"       and false if it is more recent than that.<p>\n", "  <li> <b>{FILTER_OP_and}</b> (<code>and</code>).\n", 
"       This is true if both the left and right operands are true.  It is false if either operand is false. \n", 
"       The operands must be true/false operands, like %22the following filter number accepts:%22 or \n", 
"       %22the following filter number rejects%22.  This is used to form complex boolean expressions \n", 
"       by combining several filters in an %22and%22.<p>\n", "  <li> <b>{FILTER_OP_or}</b> (<code>or</code>).\n", 
"       This is true if either the left and right operands are true, or if both are.\n", "       It is false if both operands are false.\n", 
"       The operands must be true/false operands, like %22the following filter number accepts:%22 or \n", 
"       %22the following filter number rejects%22.  This is used to form complex boolean expressions \n", 
"       by combining several filters in an %22and%22.<p>\n", "  <li> <b>{FILTER_OP_matches_using_wildcards}</b> (<code>matches_using_wildcards</code>).\n", 
"       This is true if the left operand matches the wildcard expression (DOS-style wildcards * and ? are allowed) specified by\n", 
"       the right operand.  It is false if the left operand does not match.  See [docs-regexp] for a little more information \n", 
"       on wildcard expressions.<p>\n", "  <li> <b>{FILTER_OP_matches_using_regexp}</b> (<code>matches_using_regexp</code>).\n", 
"       This is true if the left operand matches the regular expression specified by\n", "       the right operand.  It is false if the left operand does not match.  See [docs-regexp].<p>\n", 
"</ul>\n", "<h4>Operand value types</h4>\n", "The following value types are available for the left and right operands:\n", 
"<ul>\n", "  <li> Any log field name may be specified here (e.g. {FIELD_NAME_date/time} or {FIELD_NAME_hostname}.\n", 
"       The value of that log field will be used as the operand.<p>\n", "  <li> <b>{FILTER_EXPRESSION_TYPE_entire_line}</b> (<code>entire_line</code>).\n", 
"       The entire log entry line is used as the operand.<p>\n", "  <li> <b>{FILTER_EXPRESSION_TYPE_value}</b> (<code>value</code>).\n", 
"       The value specified in the operand field is used directly as the operand value.<p>\n", "  <li> <b>{FILTER_EXPRESSION_TYPE_regular_expression}</b> (<code>regular_expression</code>).\n", 
"       The value specified in the operand field is treated as a regular expression.<p>\n", "  <li> <b>{FILTER_EXPRESSION_TYPE_filter_number_result}</b> (<code>filter_number_result</code>).\n", 
"       This value is the result of running the filter whose number is specified in the operand field.\n", 
"       The value will be %22accept,%22 %22reject,%22 %22goto_next_filter,%22 or the number of\n", "       the goto filter if the filter does a goto.<p>\n", 
"  <li> <b>{FILTER_EXPRESSION_TYPE_filter_number_accepts}</b> (<code>filter_number_accepts</code>).\n", 
"       This value is true if the filter whose number is specified in the operand field accepts.\n", 
"       If is false if the filter does not accept.<p>\n", "  <li> <b>{FILTER_EXPRESSION_TYPE_filter_number_rejects}</b> (<code>filter_number_rejects</code>).\n", 
"       This value is true if the filter whose number is specified in the operand field rejects.\n", 
"       If is false if the filter does not reject.<p>\n", "</ul>\n", "<h4>Statement types</h4>\n", "The following statement types are available for the B (then) and C (else) sections:\n", 
"<ul>\n", "  <li> <b>{FILTER_STATEMENT_accept_as_page_view}</b> (<code>accept_as_page_view</code>).\n", 
"       This accepts this log entry as a page view.  No further filtering will be done;\n", "       an acceptance by any filter means that the log entry <i>will</i> appear in the statistics.\n", 
"       Because it is accepted as a page view (rather than as a hit), it will contribute \n", "       to all counts: hits, page views, bandwidth, and visitors. \n", 
"       All statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_accept_as_hit}</b> (<code>accept_as_hit</code>).\n", 
"       This accepts this log entry as a hit.  No further filtering will be done;\n", "       an acceptance by any filter means that the log entry <i>will</i> appear in the statistics.\n", 
"       Because it is accepted as a hit (rather than as a page view), it will contribute \n", "       only to the hits, bandwidth, and visitors counts; it will not contribute to the page views count. \n", 
"       All statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_reject}</b> (<code>reject</code>).\n", 
"       This rejects this log entry.  No further filtering will be done;\n", "       a rejection by any filter means that the log entry <i>will not</i> appear in the statistics.\n", 
"       All statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_replace_first}</b> (<code>replace_first</code>).\n", 
"       This replaces the first (leftmost) occurrence of the first statement parameter, in the field specified\n", 
"       by the third statement parameters, with the second statement parameter.<p>\n", "  <li> <b>{FILTER_STATEMENT_replace_last}</b> (<code>replace_last</code>).\n", 
"       This replaces the last (rightmost) occurrence of the first statement parameter, in the field specified\n", 
"       by the third statement parameters, with the second statement parameter.<p>\n", "  <li> <b>{FILTER_STATEMENT_replace_all}</b> (<code>replace_all</code>).\n", 
"       This replaces the all occurrences of the first statement parameter, in the field specified\n", 
"       by the third statement parameters, with the second statement parameter.<p>\n", "  <li> <b>{FILTER_STATEMENT_set_field}</b> (<code>set_field</code>).\n", 
"       This sets the value of the field specified in the third statement parameter to \n", "       the value of the first statement parameter.\n", 
"       The second statement parameter is ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_replace_after}</b> (<code>replace_after</code>).\n", 
"       This replaces everything after the first occurrence of the first statement parameter, in the field specified\n", 
"       by the third statement parameters, with the second statement parameter.  For example, if the first\n", 
"       parameter is %22?%22, and the second parameters is %22(parameters)%22 and the field is the page field,\n", 
"       and the value of the page field is %22/dir1/dir2/cgi-bin/script?param1+param2+param3%22,\n", 
"       the after this filter runs the value of the page field will be\n", "       %22/dir1/dir2/cgi-bin/script?(parameters)%22--everything after the ? will have been replace by\n", 
"       %22(parameters)%22.<p>\n", "  <li> <b>{FILTER_STATEMENT_copy_field}</b> (<code>copy_field</code>).\n", 
"       This copies the value of the field specified in the fourth statement parameter to \n", "       the value of the field specified in the third statement parameter.\n", 
"       The first and second statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_copy_field_regexp}</b> (<code>copy_field_regexp</code>).\n", 
"       This matches the regular expression specified by <i>value1</i> to the field specified by <i>field2</i>.\n", 
"       <i>field1</i> is set to the value of \n", "       the portion of <i>field2</i> which matches the parenthesized part of the regular expression.\n", 
"       <i>value2</i> is ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_convert_field_regexp}</b> (<code>convert_field_regexp</code>).\n", 
"       This matches the regular expression specified by <i>value1</i> to the field specified by <i>field2</i>.\n", 
"       If it matches, it sets <i>field1</i> is set to the <i>value2</i>, after replacing each variable $<i>n</i> \n", 
"       with the <i>n</i>th parenthesized section of the match.  For instance, each occurrence of $1 will \n", 
"       be replaced by what matched the first (from the left) parenthesized section of the regular expression, \n", 
"       and each occurrence of $2 will be replace by what matched the second parenthesized section of the regular \n", 
"       expression.  For example, if <i>value1</i> is (.*)ABC(.*), <i>value2</i> is $2FGH$1, and the value of \n", 
"       <i>field1</i> is XYZABC123, then <i>field1</i> will be set to 123FGHXYZ ($1 is 123 and $2 is XYZ).<p>\n", 
"  <li> <b>{FILTER_STATEMENT_rewrite_field_using_rules}</b> (<code>rewrite_field_using_rules</code>).\n", 
"       This reads the file whose pathname is in <i>value1</i>, and reads a set of rules from it. \n", 
"       <i>value1</i> can be a full pathname, or the name of a file in the RewriteRules sub{DIRECTORY_WORD} \n", 
"       of the LogAnalysisInfo {DIRECTORY_WORD}. \n", "       These rules are a small subset of the rewrite_mod rules available in the apache web server. \n", 
"       {PRODUCT_NAME} applies the rules to convert <i>field2</i>, and puts the result in <i>field1</i>. \n", 
"       See [docs-rewriterules] for full information on rewrite rules.<p>\n", "  <li> <b>{FILTER_STATEMENT_add_suffix_to_field}</b> (<code>add_suffix_to_field</code>).\n", 
"       This adds the value specified by the first statement parameter to the end of \n", "       the value of the field specified by the third statement parameter.\n", 
"       That is, it appends, or concatenates, the first parameter to the end of the field.\n", "       The second statement parameter is ignored.<p>\n", 
"  <li> <b>{FILTER_STATEMENT_add_prefix_to_field}</b> (<code>add_prefix_to_field</code>).\n", "       This adds the value specified by the first statement parameter to the beginning of \n", 
"       the value of the field specified by the third statement parameter.\n", "       That is, it prepends the first parameter at the beginning of the field value.\n", 
"       The second statement parameter is ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_concatenate}</b> (<code>concatenate</code>).\n", 
"       This concatenates (adds end-to-end) the first statement parameter, the value of the field specified in the \n", 
"       third statement parameter, the second statement parameter, and the value of the field specified in the \n", 
"       fourth statement parameter, and put the result in the field specified in the third statement parameter. \n", 
"       For instance, if the first parameter is %22/(domain-%22, the second parameters is %22)%22, \n", 
"       the third parameters is the server domain field (which had value %22widgets.com%22, \n", "       and the fourth parameter is the page field (which has value %22/dir1/page.html%22), \n", 
"       then the result will be %22/(domain-widgets.com)/dir1/page.html%22, and the result will be put in \n", 
"       the server domain field.<p>\n", "  <li> <b>{FILTER_STATEMENT_set_variable}</b> (<code>set_variable</code>).\n", 
"       This sets the variable specified by the second parameter to the value of the first parameter.<p>\n", 
"       the variable specified by the second parameter.<p>\n", "  <li> <b>{FILTER_STATEMENT_add_numerically_to_variable}</b> (<code>add_numerically_to_variable</code>).\n", 
"       This adds the numerical value specified by the first statement parameter to \n", "       the variable specified by the second parameter.<p>\n", 
"  <li> <b>{FILTER_STATEMENT_convert_to_lowercase}</b> (<code>convert_to_lowercase</code>).\n", "       This converts any uppercase letters in the field specified by the third statement parameter to lowercase.\n", 
"       The first and second statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_convert_to_uppercase}</b> (<code>convert_to_uppercase</code>).\n", 
"       This converts any lowercase letters in the field specified by the third statement parameter to uppercase.\n", 
"       The first and second statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_dns_lookup}</b> (<code>dns_lookup</code>).\n", 
"       This looks up the IP number in the field specified by the third statement parameter.\n", "       The value of that field is replaced by the resolved hostname.  If the field is\n", 
"       not an IP number, this does nothing.<p>\n", "  <li> <b>{FILTER_STATEMENT_goto_next_filter}</b> (<code>goto_next_filter</code>).\n", 
"       This continues on to the next filter, without accepting, rejecting, or doing anything else.\n", 
"       All statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_goto_filter_number}</b> (<code>goto</code>).\n", 
"       This continues on to the filter whose number is specified in the first statement parameter,\n", 
"       without accepting, rejecting, or doing anything else.\n", "       The first filter is filter 1, the second is filter 2, etc.\n", 
"       The second and third statement parameters are ignored.<p>\n", "  <li> <b>{FILTER_STATEMENT_collect_field_regexp}</b> (<code>collect_field_regexp</code>).\n", 
"       This matches the regular expression specified by <i>value1</i> to the field specified by <i>field2</i>.\n", 
"       It then sets the <i>field1</i> field of the collected log entry specified by the second parenthesized \n", 
"       part of the regular expression to the value specified by the first parenthesized part.\n", "       This is used when a log entry is spread across several lines, with a session identifier on each line\n", 
"       to indicate that they go together.  By matching the first parenthesized part to the session identifier, \n", 
"       and the second parenthesized part to a particular field, this can be used to extract a single field of \n", 
"       a log entry associated with the session, which can then be built over several lines.  When it's completely \n", 
"       built, you can use <b>{FILTER_STATEMENT_accept_collected_entry}</b> or\n", "       <b>{FILTER_STATEMENT_accept_collected_entry_regexp}</b> to accept the final collected log entry.<p>\n", 
"  <li> <b>{FILTER_STATEMENT_collect_field_regexp2}</b> (<code>collect_field_regexp2</code>).\n", "       This matches the regular expression specified by <i>value1</i> to the field specified by <i>field2</i>.\n", 
"       It then sets the <i>field1</i> field of the collected log entry specified by the first parenthesized \n", 
"       part of the regular expression to the value specified by the second parenthesized part.\n", 
"       This is the same as <b>{FILTER_STATEMENT_collect_field_regexp}</b>, except that it is used when the\n", 
"       session identifier comes <i>after</i> the field to be extracted in the log entry.\n", "       <p>\n", 
"  <li> <b>{FILTER_STATEMENT_collect_multiple_fields_regexp}</b> (<code>collect_multiple_fields_regexp</code>).\n", 
"       This matches the regular expression specified by <i>value1</i> to the whole log entry line.\n", 
"       It then sets the fields specified by <i>value2</i> (comma-separated) to the values of the parenthesized sections, \n", 
"       in the order that they appear.  The parenthesized section associated with the KEY field \n", 
"       is used as the key for the collected entry (and can be used to key the entry when it is accepted by \n", 
"       one of the collected entry accepting filters.<p>\n", "  <li> <b>{FILTER_STATEMENT_collect_multiple_fields_regexp_listed}</b> (<code>collect_multiple_fields_regexp_listed</code>).\n", 
"       This matches the regular expression specified by <i>value1</i> to the whole log entry line.\n", 
"       The first parenthesized section is used as the key for the entry we're collecting.  The \n", 
"       second parenthesized sections is processed for name=value pairs, and for each pair, the \n", 
"       log field specified by then name is set to the value.  <i>value2</i> determines how the name/value \n", 
"       pairs are extracted.  It is in two parts, separated by ////; the first part is the divider which separates \n", 
"       each pair, and the second part is the divider which separated name from value.  For instance, if <i>value2</i> \n", 
"       is %22, ////=%22, then the name/value pairs are separated by commas and equal signs, \n", "       ex. %22name1=value1, name2=value2, name3=value3%22.\n", 
"       A collected entry can be accepted using one of the collected entry accepting filters below.\n", 
"       <p>\n", "  <li> <b>{FILTER_STATEMENT_accept_collected_entry}</b> (<code>accept_collected_entry</code>).\n", 
"       This accepts the collected log entry with the identifier specified by <i>value1</i>. \n", "       See <b>{FILTER_STATEMENT_collect_field_regexp}</b> for details of how a collected log entry \n", 
"       is collected.  This variant is used when there is not actually a session identifier in the log \n", 
"       entry, but entries are spread over multiple lines.  By using an empty or constant session identifier \n", 
"       in the collection filters, and specifying that here, you can collect multi-line log entries into a \n", 
"       single entry.<p>\n", "  <li> <b>{FILTER_STATEMENT_accept_collected_entry_regexp}</b> (<code>accept_collected_entry_regexp</code>).\n", 
"       This accepts the collected log entry with the identifier specified by the parenthesized section. \n", 
"       The collected log entry values are then cleared, so later collections will start with a fresh log entry.\n", 
"       See <b>{FILTER_STATEMENT_collect_field_regexp}</b> for details of how a collected log entry \n", 
"       is collected.<p>\n", "  <li> <b>{FILTER_STATEMENT_accept_collected_entry_regexp_carryover}</b> (<code>accept_collected_entry_regexp_carryover</code>).\n", 
"       This accepts the collected log entry with the identifier specified by the parenthesized section. \n", 
"       The collected log entry values are carried over (not cleared), so later collections will continue to build on this one.\n", 
"       See <b>{FILTER_STATEMENT_collect_field_regexp}</b> for details of how a collected log entry \n", 
"       is collected.<p>\n", "  <li> <b>{FILTER_STATEMENT_accept_multiple_fields_regexp}</b> (<code>accept_multiple_fields_regexp</code>).\n", 
"       This matches the regular expression specified by <i>value1</i> to the whole log entry line.\n", 
"       It then sets the fields specified by <i>value2</i> (comma-separated) to the values of the parenthesized sections, \n", 
"       in the order that they appear.  The parenthesized section associated with the KEY field \n", 
"       is used as the key for the collected entry (and can be used to key the entry when it is accepted by \n", 
"       one of the collected entry accepting filters.  After all fields are set, this immediately accepts the log entry.<p>\n", 
"  <li> <b>{FILTER_STATEMENT_set_field_from_command}</b> (<code>set_field_from_command</code>).\n", 
"       This sets the value of the field specified in the third statement parameter to \n", "       the output of the command-line command specified by the first statement parameter.\n", 
"       The command is run from the command line, with the first command-line option being \n", "       a comma-separated list of fields, the second command-line option being the value of \n", 
"       the first field, the third command-line option being the value of the second field, etc. \n", 
"       The command should write its result to its standard output stream.  The first line of output of the \n", 
"       command will be put in the specified field; the rest will be ignored.\n.<p>\n", "  <li> <b>{FILTER_STATEMENT_set_fields_from_tcpip_server}</b> (<code>set_fields_from_tcpip_server</code>).\n", 
"       This sets the values of all the fields using a TCP/IP filter. \n", "       In order to use this filter, you must run a special TCP/IP-based server on \n", 
"       a machine accessible from the {PRODUCT_NAME} machine, on the server and port specified by \n", 
"       <i>value1</i> (<i>value1</i> is of the format <i>hostname</i>:<i>port</i>). \n", "       {PRODUCT_NAME} will make a TCP/IP connection to the server the first time it runs the filter, \n", 
"       and it will send it a single line of text, ending in a line feed, containing the names \n", 
"       of the fields, in order.  For instance, the first line might be:<p>\n", "         <pre>  date/time|page|hostname|referrer|hour of day|day of week|log filename|...|server response</pre>\n", 
"       For every log entry that {PRODUCT_NAME} processes, it will send a single additional line of text \n", 
"       to the server, with the same format as above, except that the field </i>value</i> for that \n", 
"       line will be sent instead of the field names.  For instance, the second line might look like this:<p>\n", 
"         <pre>  12/Jan/2001 12:01:01|/index.html|some.host.com|http://www.yahoo.com/page.html|midnight - 1:00 AM|Friday|...|200</pre>\n", 
"       In response, the server should send an identically-formatted line back to {PRODUCT_NAME}, \n", 
"       with any desired field modifications.  For instance, if the filter is designed to reverse \n", 
"       the capitalization of all field values, it could send back the following:\n", "         <pre>  12/jAN/2001 12:01:01|/INDEX.HTML|SOME.HOST.COM|HTTP://WWW.YAHOO.COM/PAGE.HTML|MIDNIGHT - 1:00 AM|fRIDAY|...|200</pre>\n", 
"       {PRODUCT_NAME} will leave the TCP/IP connection open as it processes the log data.  When it is done\n", 
"       processing the log data, it will send one final line of text containing only <code>***END***</code>, \n", 
"       and it will close the TCP/IP connection.  This filter is extremely powerful, since any language can \n", 
"       be used to write the filter server, and the filter server can reside on any convenient machine, \n", 
"       and it can access any external sources of information \n", "       it desires (for instance, it could look up names in an external database, based on the username), and \n", 
"       it can set any log fields.  Because the connection remains open, this is also relatively fast, \n", 
"       whereas the previous filter (command-line-based) is generally much, much slower.  For examples of\n", 
"       TCP/IP filter servers written in Java and Perl, contact <a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a>.<p>\n", 
"</ul>\n", "<h4>Filters in configuration files</h4>\n", "Filters appear in a text format in configuration files; \n", 
"if you prefer to edit them as text by directly editing the configuration file, \n", "you can do that.  The filter section of the configuration file starts with \n", 
"%22log_filters%22, or %22lf%22, followed by the filter layout type (usually %22standard%22). \n", "Next each of the filters appear, and after all the filters, %22filter_end%22. \n", 
"Each filter has the following format:<p>\n", "<ol>\n", "  <li> filter type\n", "  <li> left expression type\n", 
"  <li> left expression value\n", "  <li> operator\n", "  <li> right expression type\n", "  <li> right expression value\n", 
"  <li> then statement type\n", "  <li> then statement parameter 1\n", "  <li> then statement parameter 2\n", 
"  <li> then statement parameter 3\n", "  <li> then statement parameter 4\n", "  <li> else statement type\n", 
"  <li> else statement parameter 1\n", "  <li> else statement parameter 2\n", "  <li> else statement parameter 3\n", 
"  <li> else statement parameter 4\n", "  <li> <b>collapsed</b> or <b>expanded</b>\n", "</ol>\n", "\"\n", 
"\n", "\n", "##\n", "## GLOBAL OPTION CATEGORY\n", "##\n", "\n", "# log_analysis_info_directory option info\n", 
"OPTION_LABEL_laid              \"{PRODUCT_NAME} Info {CAPITALIZE:{DIRECTORY_WORD}}\"\n", "OPTION_SHORT_DESCRIPTION_laid  \"A {DIRECTORY_WORD} where {PRODUCT_NAME} can store configurations and other information\"\n", 
"OPTION_LONG_DESCRIPTION_laid\n", "\"This specifies a local {DIRECTORY_WORD} where {PRODUCT_NAME} can store configurations \n", 
"and other information.  This {DIRECTORY_WORD} must exist and be writable by {PRODUCT_NAME}, \n", "or must be in a {DIRECTORY_WORD} \n", 
"which is writable by {PRODUCT_NAME} (so {PRODUCT_NAME} can create it).\n", "If this option is empty, {PRODUCT_NAME} assumes that the {DIRECTORY_WORD} is named LogAnalysisInfo, \n", 
"and is found in the same {DIRECTORY_WORD} as {PRODUCT_NAME}.\n", "If the environment variable LOGANALYSISINFODIR is set, its value will be used instead,\n", 
"and this variable will be ignored.\"\n", "\n", "# statistics_server_directory option info\n", "OPTION_LABEL_ssd              \"Temporary {CAPITALIZE:{DIRECTORY_WORD}}\"\n", 
"OPTION_SHORT_DESCRIPTION_ssd  \"A {DIRECTORY_WORD} on the web server running {PRODUCT_NAME} as a CGI program, from which images can be served\"\n", 
"OPTION_LONG_DESCRIPTION_ssd\n", "\"This specifies a {DIRECTORY_WORD} on the web server which is \n", 
"running {PRODUCT_NAME} as a CGI program. \n", "This {DIRECTORY_WORD} will be used to \n", "serve the images which will be embedded in {PRODUCT_NAME}'s HTML pages. \n", 
"This {DIRECTORY_WORD} must be accessible to {PRODUCT_NAME} as a local {DIRECTORY_WORD} on the machine running {PRODUCT_NAME}, \n", 
"and must also be accessible through a web browser by connecting to the web server running {PRODUCT_NAME}. \n", 
"Therefore, it must be inside the root {DIRECTORY_WORD} of the web server running {PRODUCT_NAME}. \n", 
"The {DIRECTORY_WORD} specified by this option must match the URL specified by [ssu]. \n", "In other words, the value specified here, which is a pathname local to the machine running {PRODUCT_NAME} (see [docs-pathnames]), \n", 
"must refer to the same {DIRECTORY_WORD} which is specified by URL in [ssu].\n", "It may be specified either as a full pathname, or as a pathname relative to \n", 
"the {DIRECTORY_WORD} containing {PRODUCT_NAME} (e.g. ../html/{PRODUCT_EXECUTABLE_DOCS}, if your server is UNIX \n", 
"and your site's root directory is called html and is next to cgi-bin).\n", "See [docs-sdinfo].\"\n", 
"\n", "# statistics_server_url option info\n", "OPTION_LABEL_ssu              \"Temporary {DIRECTORY_WORD} URL\"\n", 
"OPTION_SHORT_DESCRIPTION_ssu  \"The URL of a {DIRECTORY_WORD} on the web server running {PRODUCT_NAME} as a CGI program, from which images can be served\"\n", 
"OPTION_LONG_DESCRIPTION_ssu\n", "\"This specifies the URL of a {DIRECTORY_WORD} on the web server which is \n", 
"running {PRODUCT_NAME} as a CGI program.  This {DIRECTORY_WORD} will be used to \n", "serve the images which will be embedded in {PRODUCT_NAME}'s HTML pages. \n", 
"This {DIRECTORY_WORD} must be accessible to {PRODUCT_NAME} as a local {DIRECTORY_WORD} on the machine running {PRODUCT_NAME}, \n", 
"and must also be accessible through a web browser by connecting to the web server running {PRODUCT_NAME}. \n", 
"Therefore, it must be inside the root {DIRECTORY_WORD} of the web server running {PRODUCT_NAME}. \n", 
"The URL specified by this option must match the {DIRECTORY_WORD} specified by [ssd]. \n", "In other words, the value specified here, which is specified by URL, \n", 
"must refer to the same {DIRECTORY_WORD} which is specified by local pathname in [ssd]. \n", "See [docs-sdinfo].\"\n", 
"\n", "# security_mode option info\n", "OPTION_LABEL_sm              \"Security Mode\"\n", "OPTION_SHORT_DESCRIPTION_sm  \"The level of security to use\"\n", 
"OPTION_LONG_DESCRIPTION_sm\n", "\"{PRODUCT_NAME} provides a number of security features to prevent unauthorized access \n", 
"to your configurations, or to your system.  The Security Mode is one of these; \n", "see also [docs-password] and [docs-security].<p> \n", 
"The security mode cannot be set from the web GUI-- it can only be set by modifying \n", "the {PRODUCT_NAME}DefaultConfig file with a text editor.\n", 
"The security mode may be one of the following:<p> \n", "<ul> \n", "  <li> <b><code>browse_and_modify</code></b>.  This is the default.  This mode \n", 
"       allows CGI users to create new configurations, and modify existing configurations. \n", "       It provides the full power of the {PRODUCT_NAME} CGI interface from any web \n", 
"       browser.  It relies on the {PRODUCT_NAME} password for security; users who have \n", "       the password can create configurations, and modify existing configurations. \n", 
"       Users who do not have the password can make temporary modifications, during browsing, \n", "       to existing configurations, but they cannot modify the secure options.  Secure \n", 
"       options are those which cause files on the server to be read or written in any way; \n", "       examples include [log_source_url] and [page_header_file].  Secure options are indicated \n", 
"       with a small padlock icon.<p> \n", "  <li> <b><code>browse_only</code></b>.\n", "       This mode adds an additional layer of \n", 
"       security beyond what is provided by the password, by preventing users from creating \n", "       or modifying configurations, even if they know the password.  It allows the user to \n", 
"       browse existing configurations, and nothing more. \n", "       In this mode, configuration options can be modified by directly modifying \n", 
"       the [docs-configfiles], or by running {PRODUCT_NAME} \n", "       on a system in Browse and Modify mode, and copying the configuration.<p> \n", 
"</ul> \n", "Either of the options are secure enough to protect your system from malicious users, \n", 
"because all require the password before any configurations may be created or modified, \n", "and before any secure options may be changed (changes to the non-secure options \n", 
"cannot harm your system).  If you are highly concerned about security, you may want to set \n", "the security mode to Browse Only, to prevent even password-equipped \n", 
"users from doing any damage.<p>\"\n", "\n", "# web_server option info\n", "OPTION_LABEL_ws              \"Use built-in web server (web server mode)\"\n", 
"OPTION_SHORT_DESCRIPTION_ws  \"This option controls whether {PRODUCT_NAME} starts its built-in web server when it starts (whether it runs in web server mode)\"\n", 
"OPTION_LONG_DESCRIPTION_ws\n", "\"This controls whether {PRODUCT_NAME} starts its built-in web server. \n", 
"When this option is checked (true), {PRODUCT_NAME} starts a web server on the IP address specified by [sh],\n", 
"and port specified by [wsp], <i>unless</i> it detects that it is running as a CGI program \n", "under another web server, in which case it runs in CGI mode instead, and does not start the server. \n", 
"When this option is unchecked (false), {PRODUCT_NAME} never starts the web server,\n", "<i>unless</i> it is run from the command line with no parameters, or it is run as a GUI \n", 
"program under MacOS or Windows.\"\n", "\n", "# web_server_port option info\n", "OPTION_LABEL_wsp              \"Web server port\"\n", 
"OPTION_SHORT_DESCRIPTION_wsp  \"The port to listen on as a web server\"\n", "OPTION_LONG_DESCRIPTION_wsp\n", 
"\"This specifies the port {PRODUCT_NAME} should listen on when\n", "it runs as a web server.\"\n", 
"\n", "# max_resident_configurations option info\n", "OPTION_LABEL_mrc              \"Max resident configurations\"\n", 
"OPTION_SHORT_DESCRIPTION_mrc  \"Maximum number of configurations which are kept in memory at a time\"\n", 
"OPTION_LONG_DESCRIPTION_mrc\n", "\"This specifies the maximum number of configurations \n", "which are kept in memory at the same time.  When a configuration is first accessed \n", 
"from the Main Menu, it (and possibly its associated database) is read into memory. \n", "If the number of currently memory-resident configurations is less than the value of \n", 
"this option, then the configuration and its database will be kept in memory after the \n", "operation completes.  If the configuration is accessed again later, {PRODUCT_NAME} will not \n", 
"have to reload the configuration or its database from memory, and access will be much \n", "faster.<p> \n", 
"Note that configurations and databases can only be held in memory if {PRODUCT_NAME} itself \n", "remains in memory, which occurs only in web server mode and in MacOS ACGI mode.  For \n", 
"normal CGI mode, configurations cannot remain resident.<p>\n", "If a configuration is read when the number of resident configurations is already \n", 
"the value of this option, then the least recently used configuration will be \n", "removed from memory before the new one is read.<p> \n", 
"Every time a configuration is accessed, {PRODUCT_NAME} checks the modification date of \n", "the configuration file.  If the file has been modified since the last time the \n", 
"configuration was read, {PRODUCT_NAME} will reread the configuration regardless of the \n", "setting of this option.<p>\"\n", 
"\n", "# maximum_number_of_threads option info\n", "OPTION_LABEL_mnot              \"Maximum simultaneous tasks\"\n", 
"OPTION_SHORT_DESCRIPTION_mnot  \"Maximum number of simultaneous tasks (threads of execution) that {PRODUCT_NAME} will perform\"\n", 
"OPTION_LONG_DESCRIPTION_mnot\n", "\"This specifies the maximum number of simultaneous tasks (threads of execution) \n", 
"that {PRODUCT_NAME} will perform at a time, in web server mode.  When a user attempts to use \n", "the built-in web server, {PRODUCT_NAME} will check if there are already this many threads or \n", 
"connections actively in use.  If there are, {PRODUCT_NAME} will respond with a %22too busy%22 \n", 
"page.  Otherwise, the connection will be allowed. \n", "This prevents {PRODUCT_NAME} from becoming overloaded if too many people try to use it at \n", 
"the same time, or if one user works it too hard (for instance, by rapidly and repeatedly clicking on \n", 
"a view button in the statistics).\"\n", "\n", "# automatically_update_when_older_than option info\n", 
"OPTION_LABEL_auwot             \"Update when older than (seconds; 0 for never)\"\n", "OPTION_SHORT_DESCRIPTION_auwot \"Automatically update the database when the statistics are viewed and the database has not been updated in this many seconds\"\n", 
"OPTION_LONG_DESCRIPTION_auwot\n", "\"This controls whether {PRODUCT_NAME} automatically updates \n", 
"the database when the statistics are viewed.  When this option is 0, \n", "{PRODUCT_NAME} never updates or creates the database unless you manually tell it to. \n", 
"When this option is non-zero, it specifies the number of seconds old a database can be \n", "before it is automatically updates when the statistics are viewed.  For instance, if \n", 
"the value is 3600, {PRODUCT_NAME} will automatically update the database when the statistics \n", "are viewed if it has not updated the database in the past hour.  If this value is \n", 
"86400, {PRODUCT_NAME} will only update if the database has not been updated in the past day. \n", "Regardless of the setting of this option, {PRODUCT_NAME} will build the database from scratch \n", 
"when the statistics are viewed if the database has never been built before.<p>\"\n", "\n", "# safe_update option info\n", 
"OPTION_LABEL_su             \"Safe database updates\"\n", "OPTION_SHORT_DESCRIPTION_su \"Do database updates safely, by backing up the database before updating\"\n", 
"OPTION_LONG_DESCRIPTION_su\n", "\"This controls whether database updates are done %22safely.%22  Non-safe updates (%22fast%22 updates)\n", 
"are done in place, modifying the existing database during the update.  This saves disk space\n", "and time, but if the update fails, the database may be left in a corrupted state, and not\n", 
"be viewable until it is rebuilt.  Safe updates copy the entire database, perform the\n", "update on a copy, and copy it back after the update successfully completes.  This ensures\n", 
"that the database will not be corrupted by the update, but it requires extra time to\n", "copy the database, and enough disk space to hold two copies of the database.\n", 
"As a side benefit, safe updates allow the database to be viewed while it is being updated;\n", "%22fast%22 (non-safe) updates do not allow that.\"", 
"\n", "# trusted_hosts option info\n", "OPTION_LABEL_th              \"Trusted hosts\"\n", "OPTION_SHORT_DESCRIPTION_th  \"The hostnames of computers which are %22trusted,%22 and do not need to enter passwords\"\n", 
"OPTION_LONG_DESCRIPTION_th\n", "\"This is a list of the hostnames of computers which are <i>trusted</i>. \n", 
"Hostnames should be separated from each other by spaces. \n", "Any browsing host which contains any of the listed hostnames as \n", 
"part of its hostname will be trusted, so entire subdomains can be trusted by \n", "entering the domain.  Example: \n", 
"<ul> \n", "  trusted.host.com 206.221.233.20 .trusteddomain.edu \n", "</ul> \n", "Browsers from these hosts will not be required to enter any passwords-- they\n", 
"will be automatically validated.  Use this option with caution--it\n", "simplifies the use of {PRODUCT_NAME} by eliminating all password screens for \n", 
"the administrative host, but can potentially be a security hole, if someone \n", "uses or spoofs the administrative machine without permission.<p>\n", 
"If you are connecting from a trusted host, it may be difficult \n", "to remove that trusted host using the web interface, because {PRODUCT_NAME} will \n", 
"refuse to allow you administrative access to change the trusted host, because \n", "your host will no longer be trusted.  One solution to this is to modify the \n", 
"{PRODUCT_NAME}DefaultConfig file manually, with a text editor, to remove the trusted host.\n", "Another solution is to connect from another system, log in normally, and remove \n", 
"the trusted host that way.\n", "\"\n", "\n", "# show_full_operating_system_details_in_errors option info\n", 
"OPTION_LABEL_sfosdie              \"Show full operating system details in errors\"\n", "OPTION_SHORT_DESCRIPTION_sfosdie  \"Show full operating system version details in the text of error messages\"\n", 
"OPTION_LONG_DESCRIPTION_sfosdie\n", "\"This controls whether {PRODUCT_NAME} displays the full operating system version \n", 
"details in error message.  It is useful for {PRODUCT_NAME} to do this because \n", "this helps us to debug problems when they are reported. \n", 
"However, full operating system details could be of use to someone \n", "attempting to gain unauthorized access to your server, \n", 
"since it would allow them to determine if you are running a vulnerable version \n", "of the operating system.  This should not be an issue if you keep your operating \n", 
"system up to date, but if you'd rather that this information not be public, \n", "you should turn this option off.\n", 
"\"\n", "\n", "# show_logo_in_administrative_header option info\n", "OPTION_LABEL_sliah              \"Show {PRODUCT_NAME} logo in administrative headers\"\n", 
"OPTION_SHORT_DESCRIPTION_sliah  \"Show the {PRODUCT_NAME} logo in the headers of administrative pages\"\n", 
"OPTION_LONG_DESCRIPTION_sliah\n", "\"This controls whether {PRODUCT_NAME} displays a logo in the header of administration pages. \n", 
"When this option is checked (true), the logo is displayed.  When it is unchecked (false), \n", "the logo is not displayed.\n", 
"\"\n", "\n", "# authentication_command_line option info\n", "OPTION_LABEL_acl              \"Authentication command line\"\n", 
"OPTION_SHORT_DESCRIPTION_acl  \"The command line to run to authenticate users\"\n", "OPTION_LONG_DESCRIPTION_acl\n", 
"\"This specifies a command line that {PRODUCT_NAME} will run when it authenticates users.\n", "The command line program must accept two parameters: the username and the entered password. \n", 
"The command line must print the names of the configurations that the user is permitted to \n", "access, one name per line.  A printed value of *ADMIN* means that the user is an administrator, and may access \n", 
"any configuration, as well as accessing the administrative interface\n", "(any other response, and the administrative interface will not be available). \n", 
"A printed value of *FAILED* means that the username/password authentication failed.<p>\n", "If this option is blank, username/password authentication will not be performed; \n", 
"{PRODUCT_NAME} will assume that all users are administrative, and will prompt them all for the \n", 
"default administrative password, and refuse access if they don't know it. \n", "When this option is blank, access through the User menu (?user) will provide access to all configurations except those \n", 
"hidden by [hium].\n", "\"\n", "\n", "# administrative_bar_color option info\n", "OPTION_LABEL_abc              \"Administrative bar color\"\n", 
"OPTION_SHORT_DESCRIPTION_abc  \"The color of the header and footer bars in the administrative interface\"\n", 
"OPTION_LONG_DESCRIPTION_abc\n", "\"This controls the color of the header and footer bars in the administrative interface, \n", 
"i.e. the color of the background of the Administrative Menu title bar, the color \n", "of the bar containing the Next/Back buttons, etc.\n", 
"{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# cgi_directory option info\n", "OPTION_LABEL_cd              \"CGI {CAPITALIZE:{DIRECTORY_WORD}}\"\n", 
"OPTION_SHORT_DESCRIPTION_cd  \"The {DIRECTORY_WORD} containing {PRODUCT_NAME}, relative to the server root\"\n", 
"OPTION_LONG_DESCRIPTION_cd\n", "\"This is the {DIRECTORY_WORD} containing the {PRODUCT_NAME} CGI program, \n", 
"relative to the root of the web server.  This should be as it appears \n", "in a URL; forward slashes (/) should separate sub{PLURALIZE:{DIRECTORY_WORD}}. \n", 
"It should begin and end with a forward slash (/), \n", "unless it is empty (i.e. {PRODUCT_NAME} is in the root {DIRECTORY_WORD}). \n", 
"For instance, if the {PRODUCT_NAME} CGI program is inside the %22{PRODUCT_EXECUTABLE_DOCS}%22 {DIRECTORY_WORD}, \n", 
"which is inside the %22scripts%22 {DIRECTORY_WORD} of your web server, then \n", "this should be /scripts/{PRODUCT_EXECUTABLE_DOCS}/. \n", 
"This is used in the rare cases when {PRODUCT_NAME} needs to build a full (non-relative) URL for itself, ex.<p>\n", 
"<ul> \n", "http://myhost.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS} \n", "</ul><p> \n", "{PRODUCT_NAME} can automatically compute all parts of the \n", 
"URL except the CGI {DIRECTORY_WORD} part (%22/cgi-bin/%22 above); this option \n", "specifies that part.\"\n", 
"\n", "# use_multithreading option info\n", "OPTION_LABEL_um              \"Use multithreading\"\n", 
"OPTION_SHORT_DESCRIPTION_um  \"True if {PRODUCT_NAME} should use multithreading to perform multiple tasks simultaneously\"\n", 
"OPTION_LONG_DESCRIPTION_um\n", "\"This controls whether {PRODUCT_NAME} uses multithreading to perform multiple tasks \n", 
"simultaneously.  When this is true, {PRODUCT_NAME} will create a separate thread of \n", "execution for each configuration.  This makes it possible, in web server mode \n", 
"or on MacOS, to process multiple configurations simultaneously.  This \n", "feature is not available on all platforms, but is generally available on \n", 
"modern operating systems.\"\n", "\n", "# max_cpu_usage_percent option info\n", "OPTION_LABEL_mcup              \"Maximum CPU usage percent\"\n", 
"OPTION_SHORT_DESCRIPTION_mcup  \"Percent of CPU time to use while processing\"\n", "OPTION_LONG_DESCRIPTION_mcup\n", 
"\"This controls how much CPU (processor) time {PRODUCT_NAME} uses while it is processing \n", "log data, view statistics, or performing some other action. \n", 
"If this is set to 100, {PRODUCT_NAME} will use as much CPU time as possible, \n", "resulting in highest performance.  If this is set to 50, {PRODUCT_NAME} will \n", 
"pause for one second every second of processing, \n", "resulting in an average CPU usage of 50%; all tasks will take twice as long to complete.\n", 
"Any value from 1 to 100 is allowed, \n", "and on most platforms {PRODUCT_NAME} will use the requested percentage of the CPU, \n", 
"but on some platforms (especially older platforms), \n", "any value other than 100% will cause {PRODUCT_NAME} to use 50% \n", 
"of the CPU.<p>\n", "Lower values may be useful in environments where other users or processes \n", 
"need higher priority than {PRODUCT_NAME}, and where the operating system's own \n", "priority mechanisms are not enough to provide that.  In general, you should \n", 
"leave this at 100 unless {PRODUCT_NAME}'s CPU usage is causing problems.\"\n", "\n", "# never_look_up_ip_numbers option info\n", 
"OPTION_LABEL_nluin              \"Never look up IP numbers using domain nameserver\"\n", "OPTION_SHORT_DESCRIPTION_nluin  \"Whether to ever try to look up hostnames of IP-numbered hosts\"\n", 
"OPTION_LONG_DESCRIPTION_nluin\n", "\"When this is true (checked), {PRODUCT_NAME} will never attempt to look up hostnames \n", 
"from IP numbers; it will use IP numbers for everything. \n", "When this is false (unchecked), it will attempt to look up the \n", 
"local hostname when it starts a web server, and it will attempt to look up \n", "the hostname of any host which accesses it by HTTP, and it will look up the \n", 
"hostname of any host it encounters in the logs (if [luin] is true). \n", "This option is useful if there is no local Domain Name Server (for instance, \n", 
"if the computer running {PRODUCT_NAME} is not connected to a network and is not itself \n", "running a DNS).\"\n", 
"\n", "# only_look_up_log_ip_numbers option info\n", "OPTION_LABEL_olulin              \"Only look up IP numbers for log entries\"\n", 
"OPTION_SHORT_DESCRIPTION_olulin  \"Look up IP numbers only when they appear in logs, not for local server or remote browsing computer\"\n", 
"OPTION_LONG_DESCRIPTION_olulin\n", "\"When this is true (checked), {PRODUCT_NAME} will look up the hostnames of IP numbers using DNS only \n", 
"when they appear in a log file and [luin] is on. \n", "When this is false (unchecked), {PRODUCT_NAME} will still look up numbers in log \n", 
"files, but will also look up the hostname of the computer {PRODUCT_NAME} is running on, \n", "and the hostnames of computers using {PRODUCT_NAME} through web browsers. \n", 
"This option is useful because when it is true, {PRODUCT_NAME} will never do any \n", "network access, so it can be run on a computer with a dial-up connection without \n", 
"having to be dialed in.  When this option is false, {PRODUCT_NAME} will perform a DNS \n", "lookup when it firsts starts and when other computers access it, so it will have \n", 
"to be permanently connected to the Internet (or using a DNS server on your local network).<p>\"\n", 
"\n", "# default_permissions option info\n", "OPTION_LABEL_dp              \"Default permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_dp  \"The permissions {PRODUCT_NAME} uses when creating a file or {DIRECTORY_WORD} (chmod-style)\"\n", 
"OPTION_LONG_DESCRIPTION_dp\n", "\"This specifies the file permissions to use when creating files and\n", 
"{PLURALIZE:{DIRECTORY_WORD}} which do not fall into any other permissions category.\n", "This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", 
"\n", "# database_file_permissions option info\n", "OPTION_LABEL_dfp              \"Database file permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_dfp  \"The permissions {PRODUCT_NAME} uses when creating a file as part of a database\"\n", 
"OPTION_LONG_DESCRIPTION_dfp\n", "\"This specifies the file permissions to use when creating files as part of a database.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# database_directory_permissions option info\n", "OPTION_LABEL_ddp              \"Database {DIRECTORY_WORD} permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_ddp  \"The permissions {PRODUCT_NAME} uses when creating a {DIRECTORY_WORD} as part of a database\"\n", 
"OPTION_LONG_DESCRIPTION_ddp\n", "\"This specifies the file permissions to use when creating a {DIRECTORY_WORD} as part of a database.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# configuration_file_permissions option info\n", "OPTION_LABEL_cfp              \"Configuration file permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_cfp  \"The permissions {PRODUCT_NAME} uses when creating a configuration file\"\n", 
"OPTION_LONG_DESCRIPTION_cfp\n", "\"This specifies the file permissions to use when creating a configuration file.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# configuration_directory_permissions option info\n", "OPTION_LABEL_cdp              \"Configuration {DIRECTORY_WORD} permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_cdp  \"The permissions {PRODUCT_NAME} uses when creating a {DIRECTORY_WORD} containing configuration files\"\n", 
"OPTION_LONG_DESCRIPTION_cdp\n", "\"This specifies the file permissions to use when creating a {DIRECTORY_WORD} containing configuration files.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# temporary_config_file_permissions option info\n", "OPTION_LABEL_tcfp              \"Temporary configuration file permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_tcfp  \"The permissions {PRODUCT_NAME} uses when creating a temporary configuration file\"\n", 
"OPTION_LONG_DESCRIPTION_tcfp\n", "\"This specifies the file permissions to use when creating a temporary configuration file.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# default_config_file_permissions option info\n", "OPTION_LABEL_dcfp              \"Default configuration file permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_dcfp  \"The permissions {PRODUCT_NAME} uses when creating the default configuration file\"\n", 
"OPTION_LONG_DESCRIPTION_dcfp\n", "\"This specifies the file permissions to use when creating the default configuration file.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# password_file_permissions option info\n", "OPTION_LABEL_pfp              \"Password file permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_pfp  \"The permissions {PRODUCT_NAME} uses when creating the password file\"\n", 
"OPTION_LONG_DESCRIPTION_pfp\n", "\"This specifies the file permissions to use when creating the password file.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# image_file_permissions option info\n", "OPTION_LABEL_ifp              \"Image file permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_ifp  \"The permissions {PRODUCT_NAME} uses when creating an image file\"\n", 
"OPTION_LONG_DESCRIPTION_ifp\n", "\"This specifies the file permissions to use when creating an image file.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# image_directory_permissions option info\n", "OPTION_LABEL_idp              \"Image {DIRECTORY_WORD} permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_idp  \"The permissions {PRODUCT_NAME} uses when creating a {DIRECTORY_WORD} containing image files\"\n", 
"OPTION_LONG_DESCRIPTION_idp\n", "\"This specifies the file permissions to use when creating a {DIRECTORY_WORD} containing image files.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# server_directory_permissions option info\n", "OPTION_LABEL_sdp              \"Server {DIRECTORY_WORD} permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_sdp  \"The permissions {PRODUCT_NAME} uses when creating the server {DIRECTORY_WORD}\"\n", 
"OPTION_LONG_DESCRIPTION_sdp\n", "\"This specifies the file permissions to use when creating the server {DIRECTORY_WORD}.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# log_analysis_info_directory_permissions option info\n", "OPTION_LABEL_laidp              \"LogAnalysisInfo {DIRECTORY_WORD} permissions\"\n", 
"OPTION_SHORT_DESCRIPTION_laidp  \"The permissions {PRODUCT_NAME} uses when creating the LogAnalysisInfo {DIRECTORY_WORD}\"\n", 
"OPTION_LONG_DESCRIPTION_laidp\n", "\"This specifies the file permissions to use when creating the LogAnalysisInfo {DIRECTORY_WORD}.\n", 
"This is a UNIX-style chmod value, a 3- or 4-digit octal number (see [docs-permissions]).\"\n", "\n", 
"# server_hostname option info\n", "OPTION_LABEL_sh              \"Web server IP address\"\n", "OPTION_SHORT_DESCRIPTION_sh  \"The IP address to run {PRODUCT_NAME}'s web server on\"\n", 
"OPTION_LONG_DESCRIPTION_sh\n", "\"This specifies the IP address {PRODUCT_NAME} should run its web server on\n", 
"(this option is ignored in CGI mode).\n", "{PRODUCT_NAME} can figure this out in most cases, but if you want to \n", 
"have {PRODUCT_NAME}'s web server bind to a different IP than the \n", "one it finds by default, you can set this option.\n", 
"{PRODUCT_NAME} uses the IP address you specify here \n", "as the IP address the server runs on.\"\n", 
"\n", "##\n", "## GRAPH OPTIONS CATEGORY\n", "##\n", "\n", "# ignore_last_points_for_equation option info\n", 
"OPTION_LABEL_ilpfe              \"Ignore last points for equation\"\n", "OPTION_SHORT_DESCRIPTION_ilpfe  \"The number of final data points to ignore when computing the equations\"\n", 
"OPTION_LONG_DESCRIPTION_ilpfe\n", "\"This specifies the number of data points to ignore at the end of the data \n", 
"when computing the date line graph equations. \n", "When this is 0, the equations are computed to fit the full data set. \n", 
"When this is 1, the last (most recent, chronologically) data point is dropped, and the remainder \n", 
"are used to compute the equations.  Higher values drop more data points. \n", "Dropping data points is useful when the most recent data point is \n", 
"partial (i.e. a month which has not yet collected all its hits), and \n", "does not represent the eventual value of that point.\"	\n", 
"\n", "# pie_chart_slice_minimum_degrees option info\n", "OPTION_LABEL_pcsmd              \"Minimum pie chart slice degrees\"\n", 
"OPTION_SHORT_DESCRIPTION_pcsmd  \"The minimum size of a pie chart slice, in degrees\"\n", "OPTION_LONG_DESCRIPTION_pcsmd\n", 
"\"This controls the minimum number of degrees a slice of the pie chart must be\n", "in order to appear in the chart.  Slices smaller than this number of degrees\n", 
"will be collapsed into a single slice.  See also [max_pie_chart_slices].\"\n", "\n", "# max_pie_chart_slices option info\n", 
"OPTION_LABEL_mpcs              \"Max number of pie chart slices\"\n", "OPTION_SHORT_DESCRIPTION_mpcs  \"The maximum number of slices in a pie chart\"\n", 
"OPTION_LONG_DESCRIPTION_mpcs\n", "\"This controls the maximum number of slices which may appear in a pie chart.\n", 
"Slices beyond this limit will be collapsed into a single slice.\n", "See also [pie_chart_slice_minimum_degrees].\"\n", 
"\n", "# pie_chart_height option info\n", "OPTION_LABEL_pch              \"Height of pie chart\"\n", 
"OPTION_SHORT_DESCRIPTION_pch  \"The height of pie charts\"\n", "OPTION_LONG_DESCRIPTION_pch\n", "\"This controls the height in pixels of pie charts.\"\n", 
"\n", "# pie_chart_width option info\n", "OPTION_LABEL_pcw              \"Width of pie chart\"\n", "OPTION_SHORT_DESCRIPTION_pcw  \"The width of pie charts\"\n", 
"OPTION_LONG_DESCRIPTION_pcw\n", "\"This controls the width in pixels of pie charts.\"\n", "\n", "# pie_chart_depth option info\n", 
"OPTION_LABEL_pcd              \"Depth (3D) of pie chart\"\n", "OPTION_SHORT_DESCRIPTION_pcd  \"The three-dimensional depth of pie charts\"\n", 
"OPTION_LONG_DESCRIPTION_pcd\n", "\"This controls the three-dimensional depth (thickness) in pixels of pie charts.\"\n", 
"\n", "# light_direction_vector option info\n", "OPTION_LABEL_ldv              \"Light direction\"\n", 
"OPTION_SHORT_DESCRIPTION_ldv  \"The direction of the incoming light source for 3D graphs\"\n", "OPTION_LONG_DESCRIPTION_ldv\n", 
"\"This specifies the direction of the incoming light source which\n", "illuminates 3D graphs.  The three integers are (x, y, z); they specify the\n", 
"vector of the incoming light ray.\"\n", "\n", "# use_3d_graphs option info\n", "OPTION_LABEL_u3g              \"Use 3D graphs\"\n", 
"OPTION_SHORT_DESCRIPTION_u3g  \"True if graphs should be shaded to appear three-dimensional\"\n", "OPTION_LONG_DESCRIPTION_u3g\n", 
"\"This controls whether graphs should look three-dimensional. \n", "When this is true, pie charts look like tilted three-dimensional platters, \n", 
"and the date graphs are shaded to give have a three-dimensional look. \n", "When this is false, pie charts look two-dimensional (circles or ovals), \n", 
"and date graphs are not shaded.\"\n", "\n", "\n", "##\n", "## MISCELLANEOUS OPTIONS CATEGORY\n", "##\n", 
"\n", "# server_root option info\n", "OPTION_LABEL_sr              \"Root URL of log data server\"\n", 
"OPTION_SHORT_DESCRIPTION_sr  \"The root URL of the server being analyzed\"\n", "OPTION_LONG_DESCRIPTION_sr\n", 
"\"This specifies the root URL (e.g. http://www.myserver.com/) of the web server which generated the log data.\n", 
"If a server root is specified, {PRODUCT_NAME} will generate links, where possible,\n", "back to the server; these links will appear as red arrows next to page items\n", 
"in the tables and pie charts of [docs-statspages].\n", "If the server root is not specified, these linked icons will not appear.\"\n", 
"\n", "\n", "##\n", "## DATABASE OPTIONS CATEGORY\n", "##\n", "\n", "# database_directory option info\n", 
"OPTION_LABEL_dd              \"Database location\"\n", "OPTION_SHORT_DESCRIPTION_dd  \"The location of the database\"\n", 
"OPTION_LONG_DESCRIPTION_dd\n", "\"This is the pathname of a database on disk.  If this option is blank, \n", 
"{PRODUCT_NAME} will store the database in a {DIRECTORY_WORD} with the same name as the configuration \n", 
"(see [cn]), in the Databases {DIRECTORY_WORD} in the LogAnalysisInfo {DIRECTORY_WORD}.<p> \n", "Hits information (used to generate statistics pages)\n", 
"will be read from this database, and logs read in the future will be added to this\n", "database.  If [configuration_mode] is create_database (Create Database mode),\n", 
"the database will be erased before data is added.  See [docs-database].\"\n", "\n", "# prompt_before_erasing_database option info\n", 
"OPTION_LABEL_pbed              \"Prompt before erasing database\"\n", "OPTION_SHORT_DESCRIPTION_pbed  \"True if {PRODUCT_NAME} should prompt before erasing a non-empty database\"\n", 
"OPTION_LONG_DESCRIPTION_pbed\n", "\"This controls whether {PRODUCT_NAME} will prompt for verification before \n", 
"erasing an existing disk-based database.  This will happen if a configuration \n", "is run in <b>createdatabase</b> mode (see [cm]), and the database already exists. \n", 
"If this option is true, {PRODUCT_NAME} will ask if you really want to destroy all data in the \n", 
"database.  If this option is false, {PRODUCT_NAME} will erase the database without asking.\"\n", "\n", 
"# multithread_log_reading info\n", "OPTION_LABEL_mlr              \"Multithread log reading (BROKEN--DO NOT USE THIS)\"\n", 
"OPTION_SHORT_DESCRIPTION_mlr  \"True if {PRODUCT_NAME} should use multithreading while reading the log data\"\n", 
"OPTION_LONG_DESCRIPTION_mlr\n", "\"DO NOT USE THIS FEATURE--IT DOES NOT WORK.\n", "We may fix it in the future, but for now, you're guaranteed to be disappointed if you try.<p>\n", 
"This controls whether {PRODUCT_NAME} uses multiple threads to read log data and build/update/expire the database. \n", 
"When this option is checked (true), {PRODUCT_NAME} uses simultaneous threads \n", "of execution during log reading.\n", 
"When this is unchecked (false), {PRODUCT_NAME} uses a single thread to do all tasks. \n", "On some systems, especially multiprocessor systems, multithreaded log reading may \n", 
"be faster.  Multithreaded log reading is available only if [um] is true, and \n", "if a multithreaded version of {PRODUCT_NAME} is being used.<p> \n", 
"When this option is on, {PRODUCT_NAME} breaks log reading into four distinct tasks, \n", "and runs at least one thread per tasks.  You can control the number of threads \n", 
"allocated to each task using the options listed in parentheses below.  The tasks are:<p>\n", "<ul>\n", 
"  <li> <b>Log reading and line separation</b> (always done with a single thread).  This \n", "       involves reading the data from the log source and splitting it into separate lines. \n", 
"       It is generally a very fast operation, so there is no need to multithread it.<p>\n", "  <li> <b>Log parsing</b> ([lpt]).  This involves separating the line into log fields. \n", 
"       It is usually fairly quick, but can be slower if complicated regular expressions or \n", "       parsing filters are used to parse.  If parsing filters are used, only one thread may \n", 
"       be used here, because parsing filters generally require that the lines be processed \n", "       sequentially.<p>\n", 
"  <li> <b>Log filtering</b> ([lft]).  This involves looking up IP numbers if [luin] is turned on, \n", 
"       and running the parsed log entry through the log filters to see if it is accepted. \n", "       Because DNS lookup requires a network access which may leave the thread waiting for a long time, \n", 
"       it is generally a good idea to set this to a high value (perhaps 10) when using DNS lookup.<p>\n", 
"  <li> <b>Database feeding</b> ([dft]).  This involves taking accepted log entries and \n", "       feeding them into the database.  This is generally the most computationally-intensive task.<p>\n", 
"  <li> <b>Database consolidating</b> ([dct]).  This is done after the log data is completely processed.<p>\n", 
"       It performs final database consolidation on the database segments, making them available for \n", 
"       log browsing.<p> \n", "</ul>\n", "The first four tasks are done simultaneously, and the last task is done separately after all the \n", 
"log data has been read and added to the database.  In general, a good value for all of these \n", "options is the number of processors on the processing machine; for instance, on a two-processor \n", 
"machine you should try a setting of 2 for each option.  However, if you're using DNS lookup, \n", "you will probably want to use a large number of log filtering threads (perhaps 10).<p>\n", 
"On a single-processor machine, you will \n", "probably get better performance by not using multithreading at all (turning this option off), \n", 
"though it won't hurt anything but your performance if you leave it on.  However, if you're using DNS lookup, \n", 
"processing will be much faster with this option <i>on</i>, as long as you use a large number of \n", 
"log filter threads (perhaps 10).<p>\n", "\"\n", "# log_parsing_threads info\n", "OPTION_LABEL_lpt              \"Number of threads to use for log parsing\"\n", 
"OPTION_SHORT_DESCRIPTION_lpt  \"The number of simultaneous threads of execution to use for log parsing\"\n", 
"OPTION_LONG_DESCRIPTION_lpt\n", "\"This controls the number of log parsing threads.  See [mlr] for more information.\"\n", 
"\n", "# log_filtering_threads info\n", "OPTION_LABEL_lft              \"Number of threads to use for log filtering\"\n", 
"OPTION_SHORT_DESCRIPTION_lft  \"The number of simultaneous threads of execution to use for log filtering\"\n", 
"OPTION_LONG_DESCRIPTION_lft\n", "\"This controls the number of log filtering threads.  See [mlr] for more information.\"\n", 
"\n", "# database_feeding_threads info\n", "OPTION_LABEL_dft              \"Number of threads to use for database feeding\"\n", 
"OPTION_SHORT_DESCRIPTION_dft  \"The number of simultaneous threads of execution to use for database feeding\"\n", 
"OPTION_LONG_DESCRIPTION_dft\n", "\"This controls the number of database feeding threads.  See [mlr] for more information.\"\n", 
"\n", "# database_consolidating_threads info\n", "OPTION_LABEL_dct              \"Number of threads to use for database consolidating\"\n", 
"OPTION_SHORT_DESCRIPTION_dct  \"The number of simultaneous threads of execution to use for database consolidating\"\n", 
"OPTION_LONG_DESCRIPTION_dct\n", "\"This controls the number of database consolidation threads.  See [mlr] for more information.\"\n", 
"\n", "# force_database_reload option info\n", "OPTION_LABEL_fdr              \"Force reload of database\"\n", 
"OPTION_SHORT_DESCRIPTION_fdr  \"True if the database should be reloaded, even if it is resident\"\n", 
"OPTION_LONG_DESCRIPTION_fdr\n", "\"This option is used automatically by the \n", "CGI interface, and does not usually have to be modified manually. \n", 
"This controls whether the database should be reloaded. \n", "When this is false, and the database is already resident in memory \n", 
"(see [max_resident_configurations]), the resident database is used, rather \n", "than reloading the database.  When this is true, the database is reloaded, \n", 
"with the reloaded database replacing the resident database, if there is one. \n", "The database is loaded from a disk-based database if one exists; \n", 
"otherwise, it is recomputed by re-reading the log source (see [log_source_type]).\n", "This option can be used to discard an out-of-date resident database, and to \n", 
"load the new one.\"\n", "\n", "# allow_empty_log_source option info\n", "OPTION_LABEL_aels              \"Allow empty log source\"\n", 
"OPTION_SHORT_DESCRIPTION_aels  \"True if {PRODUCT_NAME} should allow databases to be created from log sources which contain no data\"\n", 
"OPTION_LONG_DESCRIPTION_aels\n", "\"This option controls whether {PRODUCT_NAME} complains if the \n", 
"log source is empty when the database is build or rebuild. \n", "If this option is false, {PRODUCT_NAME} will generate an error if \n", 
"there is no data in the log source during a (re)build. \n", "If this is true, {PRODUCT_NAME} will not complain, but will \n", 
"just create a database containing no data.\n", "An empty log source is often a sign of an error in the log source, \n", 
"so it is usually best to leave this option off. \n", "But in a multi-user environment, some sites may have no log data at all, \n", 
"and in that case, this can be turned on to allow for error-free rebuilds of all databases.\n", "{PRODUCT_NAME} never generates an error if there is no (new) log data during a database update; \n", 
"this affects only %22from scratch%22 (re)builds.\"\n", "\n", "# force_database_steal option info\n", 
"OPTION_LABEL_fds              \"(Obsolete Option)\"\n", "OPTION_SHORT_DESCRIPTION_fds  \"(Obsolete Option)\"\n", 
"OPTION_LONG_DESCRIPTION_fds   \"(Obsolete Option)\"\n", "\n", "# database_write_buffer_size option info\n", 
"OPTION_LABEL_dwbs              \"Size of memory write buffer\"\n", "OPTION_SHORT_DESCRIPTION_dwbs  \"Size in bytes of the database's memory write buffer\"\n", 
"OPTION_LONG_DESCRIPTION_dwbs\n", "\"This controls the size\n", "of the database's memory write buffer.\n", 
"Data is collected in the write buffer in memory until it fills up; \n", "then the data is written to the disk write buffer (see [ddwbs]); \n", 
"finally, the data is consolidated into the disk database.\n", "Increasing this value increases the amount\n", 
"of data which can be added to the database without requiring disk access, greatly increasing processing speed.\n", 
"However, increasing this number also increases memory usage.  For best performance, it is generally a good idea to\n", 
"make this setting as large as you can without exceeding your available memory.\n", "{PRODUCT_NAME} will use up to the amount of memory specified here for the buffer, \n", 
"and as processing continues, the buffer will generally drop towards about one half \n", "this value.  For long database builds, most of the time {PRODUCT_NAME} will use \n", 
"only about half of the maximum. \n", "You can specify the size in bytes (by ending it with %22bytes%22 or %22b%22, \n", 
"in kilobytes (%22kb%22 or %22k%22), or megabytes (%22M%22, %22Meg%22, or %22Mb%22).\n", "\"\n", "\n", 
"# maximum_session_memory_usage option info\n", "OPTION_LABEL_msmu              \"Maximum memory used by sessions\"\n", 
"OPTION_SHORT_DESCRIPTION_msmu  \"Maximum amount of memory that can be used while browsing session information\"\n", 
"OPTION_LONG_DESCRIPTION_msmu\n", "\"This controls the amount of memory {PRODUCT_NAME} can use while\n", 
"generating session-related views and subviews \n", "(like the %22paths through the site,%22 %22entry pages,%22 %22exit pages,%22\n", 
"%22sessions summary,%22 and %22time per page%22 views). \n", "This limit exists to prevent {PRODUCT_NAME} to consuming all available memory \n", 
"when generating statistics for databases with very large amounts of session information.\n", "If {PRODUCT_NAME} would require more than this amount of memory to generate the statistics, \n", 
"it generates an error message saying that it has exceeded the limit,\n", "in the location where the statistics would have been. \n", 
"If it requires less than this amount, it will just generate the session statistics.<p>\n", "Note: unlike many of {PRODUCT_NAME}'s memory options, which refer to log processing memory usage \n", 
"(e.g. [dwbs]) this refers to memory usage during <i>statistics browsing</i>.  Session information \n", 
"requires very little memory or processing time during log processing, but \n", "it can require a lot of memory and CPU time during statistics browsing.\"\n", 
"\n", "# maximum_visitor_memory_usage option info\n", "OPTION_LABEL_mvmu              \"Maximum memory used by visitors\"\n", 
"OPTION_SHORT_DESCRIPTION_mvmu  \"Maximum amount of memory that can be used by visitor information while processing log data\"\n", 
"OPTION_LONG_DESCRIPTION_mvmu\n", "\"This controls the amount of memory {PRODUCT_NAME} can use to store the visitor information\n", 
"while processing log data.\n", "{PRODUCT_NAME} will use up to this amount of memory for visitor information, \n", 
"and when the memory is exceeded, it will write database buffers to disk to \n", "free up memory.\n", 
"Low values reduce performance because {PRODUCT_NAME} has to write buffer frequently.\"\n", "\n", "# database_disk_write_buffer_size info\n", 
"OPTION_LABEL_ddwbs              \"Size of disk write buffer\"\n", "OPTION_SHORT_DESCRIPTION_ddwbs  \"Size of the disk portion of the database write buffer\"\n", 
"OPTION_LONG_DESCRIPTION_ddwbs\n", "\"This controls the size\n", "of the database's disk-based write buffer.\n", 
"Data is collected in the write buffer in memory (see [dwbs]) until it fills up; \n", "then the data is written to the disk write buffer; \n", 
"finally, the data is consolidated into the disk database.\n", "Increasing this value increases the amount of data which can be added to the database \n", 
"without requiring consolidation (consolidation is very time-consuming), increasing processing speed.\n", 
"However, increasing this number also increases disk during log processing.\n", "The disk write buffer will be used only during log processing-- it will be freed when log processing \n", 
"is complete.\n", "For best performance, it is generally a good idea to\n", "make this setting as large as you can without exceeding your available disk space.\n", 
"You can specify the size in bytes (by ending it with %22bytes%22 or %22b%22, \n", "in kilobytes (%22kb%22 or %22k%22), or megabytes (%22M%22, %22Meg%22, or %22Mb%22).\n", 
"\"\n", "\n", "# database_read_cache_size option info\n", "OPTION_LABEL_drcs              \"Size of read cache\"\n", 
"OPTION_SHORT_DESCRIPTION_drcs  \"Size in entries of the read cache for the database\"\n", "OPTION_LONG_DESCRIPTION_drcs\n", 
"\"This controls the size, in database entries,\n", "of the read cache for the database. \n", "Each entry occupies around 20 bytes of memory; it may use more or less depending on\n", 
"the number of database fields and the amount of log data.\n", "The read cache is a collection of database \n", 
"entries which resides in memory and provides quick access to any database entries \n", "it contains.<p> \n", 
"Every time a database entry is requested, {PRODUCT_NAME} first searches the \n", "read cache; if the entry is there, it accesses it directly from the cache.  \n", 
"If the entry is not there, {PRODUCT_NAME} accesses it from the database, which is slower \n", "if the database is on disk (but probably as fast as the cache or faster if the database \n", 
"is in memory).  After each access, {PRODUCT_NAME} puts the accessed item in the cache, so future \n", 
"accesses can be fast.  As the cache fills up, {PRODUCT_NAME} discards the less-recently-accessed \n", 
"entries.  Setting this to 0 turns off the read cache entirely, which is a good idea for \n", "memory-resident databases.<p>\n", 
"For best performance of disk-based databases, you should \n", "set this to a fairly high value.\"\n", 
"\n", "# database_access_chunk_size option info\n", "OPTION_LABEL_dacs              \"Database access chunk size\"\n", 
"OPTION_SHORT_DESCRIPTION_dacs  \"Number of database entries read from disk or written to disk at a time\"\n", 
"OPTION_LONG_DESCRIPTION_dacs\n", "\"This specifies the number of database entries which are read from or written to\n", 
"a disk-based database segment at a time.  {PRODUCT_NAME} reads\n", "only that portion of a database segment that it needs immediately.  This option\n", 
"controls how many entries it reads at a time.  Higher values will reduce the number of\n", "disk accesses required to find a database entry, but each disk access will take longer.\"\n", 
"\n", "# database_freshness option info\n", "OPTION_LABEL_df              \"Database freshness (seconds)\"\n", 
"OPTION_SHORT_DESCRIPTION_df  \"The number of second old data can get during log processing before it is updated in the disk database\"\n", 
"OPTION_LONG_DESCRIPTION_df\n", "\"This specifies how often {PRODUCT_NAME} refreshes the data in the disk database \n", 
"while it is building or updating the database. \n", "As {PRODUCT_NAME} processes the log data, it updates the database in memory but \n", 
"only writes the updated data to the disk occasionally (to save time) \n", "That means that if you're browsing a database which is being created or \n", 
"updated, the data you see will be slightly behind the data {PRODUCT_NAME} has read. \n", "You can minimize this delay by setting this to a low value; \n", 
"for instance if you set it to 10, the data will never be more than ten seconds \n", "out of date. \n", 
"However, lower values make {PRODUCT_NAME} work harder during builds and updates, \n", "and require more disk accesses, \n", 
"which hurts the performance of log processing.\n", "A setting of 0 tells {PRODUCT_NAME} not to consolidate at all during a database build.\"\n", 
"\n", "# hash_table_starting_size option info\n", "OPTION_LABEL_htss              \"Initial size of database table\"\n", 
"OPTION_SHORT_DESCRIPTION_htss  \"Initial size of a database hash table\"\n", "OPTION_LONG_DESCRIPTION_htss\n", 
"\"This controls the initial size of the database hash table, an internal table\n", "used to store database hits.  Setting this to a higher value will eliminate the need\n", 
"for some internal data shuffling, and will speed processing a bit; however, it will also\n", "use a bit more memory.\"\n", 
"\n", "# hash_table_surplus_factor option info\n", "OPTION_LABEL_htsf              \"Surplus factor for database table\"\n", 
"OPTION_SHORT_DESCRIPTION_htsf  \"Number of times larger a hash table is than its contents\"\n", "OPTION_LONG_DESCRIPTION_htsf\n", 
"\"This controls the amount of surplus space maintained in the database hash table, an internal table\n", 
"used to store database hits.  Setting this to a higher value will increase database access speed,\n", 
"but will use more memory.  This value represents the proportion of space in the table that should remain \n", 
"free; when that space fills up, the table is expanded by [htef]. \n", "A value of 1 means that at least 10% of the table will always be free, a value of 2 means \n", 
"that at least 20% is free, and so on, up to a value of 9, where at least 90% of the table is kept free at all times. \n", 
"With a value of 1, the same table size will hold 9 times more data than with a value of 9, \n", "so the data section of your database (which is often the largest part) will be one-ninth the size \n", 
"with a value of 1 than it would be with a value of 9.  However, lower values slow down database building \n", 
"and accessing slightly.\"\n", "\n", "# hash_table_expansion_factor option info\n", "OPTION_LABEL_htef              \"Expansion factor for database table\"\n", 
"OPTION_SHORT_DESCRIPTION_htef  \"Factor by which a hash table expands when necessary\"\n", "OPTION_LONG_DESCRIPTION_htef\n", 
"\"This controls the factor by which the database hash table, an internal table used to store database hits,\n", 
"expands when necessary.  A factor of 2 means that the database table will double in size when it needs more space,\n", 
"while 10 means that the database table size will increase by a factor of 10.\n", "Setting this to a higher value will eliminate the need\n", 
"for some internal data shuffling, and will speed processing a bit; however, it will also\n", "use more memory and disk space.\"\n", 
"\n", "# num_database_segments option info\n", "OPTION_LABEL_nds              \"Number of segments of database\"\n", 
"OPTION_SHORT_DESCRIPTION_nds  \"Number of segments to break database into\"\n", "OPTION_LONG_DESCRIPTION_nds\n", 
"\"This controls the number of segments the database is broken into on disk.\n", "Larger numbers of segments take more time to create on disk,\n", 
"but allow the total database to be larger ({PRODUCT_NAME} only deals with databases one \n", "segment at a time, so only a single segment has to fit into memory).\"\n", 
"\n", "# cross_reference_groups option info\n", "OPTION_LABEL_crg              \"Cross-reference groups\"\n", 
"OPTION_SHORT_DESCRIPTION_crg  \"Cross-referencing group information\"\n", "OPTION_LONG_DESCRIPTION_crg\n", 
"\"This option specifies the cross-referencing groups used in the database. \n", "It controls which fields can be cross-referenced against each other, \n", 
"or in another way of looking at it, it controls which fields can \n", "be simultaneously filtered.  For an overview of cross-referencing and \n", 
"simultaneous filters, see [docs-xref].<p>\n", "The cross-references can be managed either through the web GUI, \n", 
"or by editing them directly in the configuration file (for advanced user only).\n", "In the web GUI, you can add a cross-reference between two fields by checking \n", 
"the box that lines up with both of them; for instance, to add a cross-reference \n", "between the page field and the hostname field, check the box in the page row and the \n", 
"hostname column, or if there's no box there, check the box in the hostname row and the page column.<p>\n", 
"If you want to edit cross-reference groups directly in the configuration file, \n", "the format is: %22cross_references_groups%22 (or crg), followed by the cross reference groups, followed by \n", 
"%22xref_groups_end%22.  Each group is a list of database field names followed by %22xref_group_end%22. \n", 
"For example:<p>\n", "<pre>\n", "cross_reference_groups\n", "  page %22visitor id%22 date/time xref_group_end\n", 
"  date/time %22visitor id%22 xref_group_end\n", "  hostname %22visitor id%22 date/time xref_group_end\n", 
"  referrer %22visitor id%22 date/time xref_group_end\n", "  %22web browser%22 %22visitor id%22 date/time xref_group_end\n", 
"  %22operating system%22 %22visitor id%22 date/time xref_group_end\n", "  %22domain description%22 %22visitor id%22 date/time xref_group_end\n", 
"  %22referrer description%22 %22visitor id%22 date/time xref_group_end\n", "  user %22visitor id%22 date/time xref_group_end\n", 
"  %22search phrase%22 %22visitor id%22 date/time xref_group_end\n", "  %22search engine%22 %22visitor id%22 date/time xref_group_end\n", 
"  %22server response%22 %22visitor id%22 date/time xref_group_end\n", "  %22day of week%22 %22visitor id%22 date/time xref_group_end\n", 
"  %22hour of day%22 %22visitor id%22 date/time xref_group_end\n", "xref_groups_end\n", "</pre><p>\n", 
"Each database field is cross-referenced against all other fields that appear in any group with it;\n", 
"for instance, above, the page, visitor id, and date/time fields are all cross-referenced against each other, \n", 
"and date/time and visitor id are cross-referenced to all other fields.\"\n", "\n", "# count_hits option info\n", 
"OPTION_LABEL_ch              \"Include hit information in database\"\n", "OPTION_SHORT_DESCRIPTION_ch  \"True if hits should be counted while reading log data\"\n", 
"OPTION_LONG_DESCRIPTION_ch\n", "\"This controls whether hits should be counted while reading log data.\n", 
"If this is checked (true), hits will be tallied.  Otherwise, they will not be.\n", "You might turn this off if all you are interested in is bandwidth data and/or visitor data.\n", 
"See also [count_page_views], [count_bandwidth], [count_visitors], and [tally_hits_on_directories_only].\"\n", 
"\n", "# count_page_views option info\n", "OPTION_LABEL_cpv              \"Include page views information in database\"\n", 
"OPTION_SHORT_DESCRIPTION_cpv  \"True if page views should be counted while reading log data\"\n", "OPTION_LONG_DESCRIPTION_cpv\n", 
"\"This controls whether page views should be counted while reading log data.\n", "If this is checked (true), page views will be tallied.  Otherwise, they will not be.\n", 
"Page views show the number of times an HTML page was hit; they are different from \n", "hits in that they do not count all hits; they only count hits on HTML pages.  In \n", 
"particular, page view numbers do not include hits on image files. \n", "See also [count_hits], [count_bandwidth] [count_visitors], and [tally_hits_on_directories_only].\"\n", 
"\n", "# count_bandwidth option info\n", "OPTION_LABEL_cb              \"Include bandwidth information in database\"\n", 
"OPTION_SHORT_DESCRIPTION_cb  \"True if bandwidth should be counted while reading log data\"\n", "OPTION_LONG_DESCRIPTION_cb\n", 
"\"This controls whether bandwidth (bytes transferred) should be counted while reading log data.\n", 
"If this is checked (true), bandwidth will be tallied.  Otherwise, it will not be.\n", "You might turn this off if all you are interested in is hits data and/or visitor data.\n", 
"See also [count_hits], [count_page_views], [count_visitors], and [tally_hits_on_directories_only].\"\n", 
"\n", "# count_visitors option info\n", "OPTION_LABEL_cv              \"Include visitor information in database\"\n", 
"OPTION_SHORT_DESCRIPTION_cv  \"True if visitor should be counted while reading log data\"\n", "OPTION_LONG_DESCRIPTION_cv\n", 
"\"This controls whether visitors (unique hosts) should be counted while reading log data.\n", "If this is checked (true), visitor information will be tallied.  Otherwise, it will not be.\n", 
"You might turn this off if all you are interested in is hits data and/or bandwidth data.\n", "See also [count_hits], [count_page_views], [count_bandwidth], and [tally_hits_on_directories_only].\"\n", 
"\n", "# track_session_information option info\n", "OPTION_LABEL_tsi              \"Include session information in database\"\n", 
"OPTION_SHORT_DESCRIPTION_tsi  \"True if sessions should be tracked while reading log data\"\n", "OPTION_LONG_DESCRIPTION_tsi\n", 
"\"This controls whether session information should be included in the database.\n", "Session information is used to generate the session-related views, including \n", 
"the paths through the site, the entry/exit pages, the session summary, and the time spent per page views.\n", 
"If this is checked (true), session information will be tracked.  Otherwise, it will not be.\n", "You might turn this off if you don't need session information; it will make log processing slightly \n", 
"faster, and the database slightly smaller.\"\n", "\n", "# tally_hits_on_directories_only option info\n", 
"OPTION_LABEL_thodo              \"Tally hits on {PLURALIZE:{DIRECTORY_WORD}} only\"\n", "OPTION_SHORT_DESCRIPTION_thodo  \"True if hits should be tallied only on the {PLURALIZE:{DIRECTORY_WORD}} containing the hit files, and not on the files themselves\"\n", 
"OPTION_LONG_DESCRIPTION_thodo\n", "\"This controls whether hits are tallied for individual files, or for {PLURALIZE:{DIRECTORY_WORD}} only. \n", 
"{PRODUCT_NAME} always tallies page views for individual files, and if this option is unchecked (false), \n", 
"it also tallies all hits on individual files.  But if this option is checked (true), \n", "it tallies hits only on the {PLURALIZE:{DIRECTORY_WORD}} containing the files.  This means that if this option is checked, \n", 
"you will not see your image files in the statistics, but you will see the hits and bandwidth they contributed \n", 
"to the {PLURALIZE:{DIRECTORY_WORD}} that contain them.  For instance, if there is a hit on /dir1/images/image.gif, \n", 
"and this option is checked, you won't see image.gif inside the images {DIRECTORY_WORD}, but hits on image.gif \n", 
"will contribute to the total hits and bandwidth on the images {DIRECTORY_WORD}.  If this option is unchecked \n", 
"image.gif will appear inside the images {DIRECTORY_WORD} (and the hits and \n", "bandwidth will be tracked the same as if the option were checked).<p>\n", 
"Uncheck this option if you need specific information about image files and other non-page-view files. \n", 
"If you don't need that information, you should leave this checked; it will reduce the size of the database.<p>\n", 
"See also [count_hits], [count_page_views], [count_bandwidth], and [count_visitors].\"\n", "\n", "# omit_ip_numbers_from_host_hierarchy option info\n", 
"OPTION_LABEL_oinfhh              \"Omit IP numbers from host hierarchy\"\n", "OPTION_SHORT_DESCRIPTION_oinfhh  \"Whether to omit IP numbers from the host hierarchy to reduce database size\"\n", 
"OPTION_LONG_DESCRIPTION_oinfhh\n", "\"This controls whether IP numbers (like 206.221.233.20) should be omitted from the host field hierarchy. \n", 
"When this option is checked (true), IP numbers will not appear in the hierarchy; \n", "instead all hits on IP-numbered hosts will all be lumped together under a bottom-level IPNumbers \n", 
"host item.  When this option is unchecked (false), all individual IP numbers will appear in the hierarchy beneath \n", 
"the IPNumbers item.<p> \n", "Omitting the IP numbers can significantly decrease the database size, and can speed \n", 
"processing, but if you need visitor information, you need to leave this option off; \n", "visitor information counts unique hostnames in the database, and it needs to be able to \n", 
"count unique IP numbers too.\"\n", "\n", "# session_timeout option info\n", "OPTION_LABEL_st              \"Session timeout (seconds)\"\n", 
"OPTION_SHORT_DESCRIPTION_st  \"The interval after which hits from the same visitor are considered to be part of a new session\"\n", 
"OPTION_LONG_DESCRIPTION_st\n", "\"This controls the amount of time a session can be idle before it is considered complete. \n", 
"This affects the display of session-based statistics views like the paths through the site view, \n", 
"the entry/exit page views, the %22time per page%22 view, and the session overview view.\n", "Sessions are considered ended when hits from a visitor have not hit the site in this number \n", 
"of second specified here.  For instance, if this interval is 3600 (one hour), if a visitor does \n", 
"not hit the site for an hour, the previous hits are considered to be a single session, and any \n", 
"subsequent hits are considered to be a new session.\"\n", "\n", "# max_session_duration option info\n", 
"OPTION_LABEL_msd             \"Maximum session duration (seconds)\"\n", "OPTION_SHORT_DESCRIPTION_msd \"The maximum duration of a session; longer sessions are discarded from the session information\"\n", 
"OPTION_LONG_DESCRIPTION_msd\n", "\"This controls the maximum length of a session in the session information \n", 
"(for instance, in the paths-through-the-site view). \n", "Sessions longer than the value specified will be ignored, and will not appear in the session information.\n", 
"This option is useful because some large ISPs (e.g. AOL) and other large companies use \n", "web caches that effectively make all hits from their customers to appear to be coming from \n", 
"one or just a few computers.  When many people are using these caches at the same time, \n", "this can result in the intermixing of several true sessions in a single \n", 
"apparent session, resulting in incorrect session information.  \n", "By discarding long sessions, which are probably the result of these caches, \n", 
"this problem is reduced.  It can be eliminated entirely by configuring your web server \n", "to track %22true%22 sessions using cookies, and then configuring {PRODUCT_NAME} to use the \n", 
"cookie value (rather than the hostname field) as the visitor id.\"\n", "\n", "# apparent_statistics_root\n", 
"OPTION_LABEL_asr              \"Apparent root of statistics data\"\n", "OPTION_SHORT_DESCRIPTION_asr  \"Specifies the top level in each hierarchy that a user may browse\"\n", 
"OPTION_LONG_DESCRIPTION_asr\n", "\"This limits browsing of the statistics to a particular filtered section. \n", 
"It can be used to limit browsing to only a certain branch of a larger \n", "database, which is useful for hiding customers' statistics from each other \n", 
"in ISP environments.<p>\n", "The value of this option is a filter set (see [f]); any valid filter value is \n", 
"permitted here. \n", "For instance, to limit browsing for this configuration to a particular directory /mydir/, \n", 
"you could use a value of singlefilter:page:/mydir/ for this option. \"\n", "\n", "# database_field_info option info\n", 
"OPTION_LABEL_dfi              \"Database field info\"\n", "OPTION_SHORT_DESCRIPTION_dfi  \"The type and structure of the fields of the database\"\n", 
"OPTION_LONG_DESCRIPTION_dfi\n", "\"This specifies the type and structure of the fields of the database.\n", 
"See [docs-hierarchies] for information on the different fields.<p>\n", "Each field in the database represents one way that the log data is broken down.\n", 
"For instance, if the database has two fields, a page field and a host field, then\n", "it will be possible to view the log data broken down by page, or by host, or\n", 
"in combinations of page and host.<p>\n", "In the web interface, you can create new fields by duplicating existing ones, \n", 
"delete them by clicking the red x, and edit them by clicking the blue triangle.<p>\n", "There are four options which can be set for each field:<p>\n", 
"<ol>\n", " <li><b>{BASED_ON_LOG_FIELD}</b>.  This is the name of the log field on which this database field is \n", 
"      based.  For instance, if there is a log field called %22page%22 then there can \n", "      be a database field called %22page%22 which tracks the value of that log field. \n", 
"      For information about log fields, see [lfi].<p>\n", "  <li><b>{SUPPRESS_ABOVE_LABEL}</b>.  This controls the number of levels to suppress at the top of the \n", 
"      hierarchy for this field.  If this is set to 0, no levels will be suppressed at the top. \n", 
"      For instance, for a page field, a value of 0 will show top-level directories and files \n", "      (e.g. /mydir/, /index.html) in the top view; a value of 1 will show second-level directories \n", 
"      and files (e.g. /mydir/mysubdir/, /mydir/index.html) as well as top-level directories. \n", "      This option is usually best left at 0, but it can be useful in some cases if you want to \n", 
"      see several levels at once in a single view.  See also [docs-hierarchies].<p>\n", "  <li><b>{SUPPRESS_BELOW_LABEL}</b>.  This controls the number of levels to suppress at the bottom of the \n", 
"      hierarchy for this field.  If this is set to 0, no levels will be suppressed at the bottom. \n", 
"      For other values, all items more than that number of levels deep will be suppressed.  For instance, \n", 
"      if it is set to 2 for the page field, the first-level items (/mydir/, /index.html) and second-level items \n", 
"      (/mydir/mysubdir/, /mydir/index.html) will be included, but third-level items like /mydir/mysubdir/dir2/ \n", 
"      will not be included in the statistics (their hits will still be shown on the higher-level directories, \n", 
"      but they themselves will not be available for zooming in).  This can be useful if you have a very large \n", 
"      hierarchy and you don't need all the information at the bottom; setting this to a low value will reduce \n", 
"      the size and increase the speed of your database.<p>\n", "  <li><b>{INCLUDE_LEAVES_LABEL}</b>.  This controls whether the bottom-level %22leaf%22 subitems should always be included in \n", 
"      the database, regardless of the suppress/collapse settings.  When this value is true, \n", "      the bottom-most level is always included in the database, even if it would normally be \n", 
"      suppressed.  For instance, in a page field, all pages (but not all directories) would be \n", 
"      included in the database, regardless of how far down they are. \n", "      In a host field, the machine name would be included even if the domains containing it have been suppressed.\n", 
"      When this value is false, the suppress option determines whether bottom-level\n", "      items are included in the database.<p>\n", 
"</ol>\n", "Power users may want to edit the database fields in the configuration file directly; \n", 
"the format is %22database_field_info%22 (or dfi), followed by %22standard%22, \n", "followed by a list of fields, followed by %22field_end%22.  Each field contains the four \n", 
"items above, followed by %22collapsed%22 or %22expanded%22, depending on whether the field \n", "should appear collapsed or expanded in the web interface.<p>\n", 
"\"\n", "\n", "\n", "##\n", "## GRAPHING OPTIONS\n", "##\n", "\n", "# date_line_graph_height option info\n", 
"OPTION_LABEL_dlgh              \"Height of date line graph\"\n", "OPTION_SHORT_DESCRIPTION_dlgh  \"The height of a date line graph\"\n", 
"OPTION_LONG_DESCRIPTION_dlgh\n", "\"This controls the height in pixels of the date line graph.\"\n", 
"\n", "# date_bar_graph_height option info\n", "OPTION_LABEL_dbgh              \"Height of date bar graph\"\n", 
"OPTION_SHORT_DESCRIPTION_dbgh  \"The height of the bar graph section of a date graph\"\n", "OPTION_LONG_DESCRIPTION_dbgh\n", 
"\"This controls the height in pixels of the bar graph section of a date graph.\"\n", "\n", "# date_line_graph_width option info\n", 
"OPTION_LABEL_dlgw              \"Width of date line graph\"\n", "OPTION_SHORT_DESCRIPTION_dlgw  \"The width of the date line graph\"\n", 
"OPTION_LONG_DESCRIPTION_dlgw\n", "\"This controls the width in pixels of a date line graph.\"\n", "\n", 
"# date_line_graph_background_color option info\n", "OPTION_LABEL_dlgbc              \"Background color of date/time graphs\"\n", 
"OPTION_SHORT_DESCRIPTION_dlgbc  \"The color of the background in the date line graph\"\n", "OPTION_LONG_DESCRIPTION_dlgbc\n", 
"\"This controls the color of the background in a date line graph.\n", "{COLOR_COMPONENTS_INFO}.\"\n", 
"\n", "# date_line_graph_equation_line_color option info\n", "OPTION_LABEL_dlgelc              \"Equation line color in date/time graphs\"\n", 
"OPTION_SHORT_DESCRIPTION_dlgelc  \"The color of the fitted equation line in the date line graph\"\n", 
"OPTION_LONG_DESCRIPTION_dlgelc\n", "\"This controls the color of the dotted equation line in a date line graph.\n", 
"{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# date_line_graph_outline_color option info\n", "OPTION_LABEL_dlgoc              \"Outline color\"\n", 
"OPTION_SHORT_DESCRIPTION_dlgoc  \"The color of the outline in the date line graph\"\n", "OPTION_LONG_DESCRIPTION_dlgoc\n", 
"\"This controls the color of the outline box surrounding a date line graph\n", "{COLOR_COMPONENTS_INFO}.\"\n", 
"\n", "# date_line_graph_text_color option info\n", "OPTION_LABEL_dlgtc              \"Text color in date/time graphs\"\n", 
"OPTION_SHORT_DESCRIPTION_dlgtc  \"The color of text in the date line graph\"\n", "OPTION_LONG_DESCRIPTION_dlgtc\n", 
"\"This controls the color of the text and the tick marks in a date line graph.\n", "{COLOR_COMPONENTS_INFO}.\"\n", 
"\n", "# use_tables_for_legend_squares option info\n", "OPTION_LABEL_utfls              \"Use HTML tables to generate legend squares\"\n", 
"OPTION_SHORT_DESCRIPTION_utfls  \"True if pie chart legend squares should be generated with HTML tables\"\n", 
"OPTION_LONG_DESCRIPTION_utfls\n", "\"This controls whether pie chart legend squares\n", "(the colored boxes in a pie chart) are generated using HTML tables, \n", 
"or using GIF images.  When this is true (checked), legend squares are \n", "generated using HTML tables, resulting in fast-loading but unclickable squares. \n", 
"When this is false (unchecked), legend squares are generated using images, \n", "resulting in slower-loading but clickable legend squares.\"\n", 
"\n", "# make_graph_bars_clickable option info\n", "OPTION_LABEL_mgbc              \"Make graph bars clickable\"\n", 
"OPTION_SHORT_DESCRIPTION_mgbc  \"Make bars in the date/time graphs clickable\"\n", "OPTION_LONG_DESCRIPTION_mgbc\n", 
"\"This controls whether or not the bars in the %22bar graphs%22 of the date/time graphs\n", "in the statistics clickable.  When this option is checked (true), the bars will be\n", 
"clickable, and linked to pages displaying data for just that time period.  When this\n", "option is unchecked (false), the bars will not be clickable.  You might want to turn off\n", 
"this option if you're generating very complex pages, where the extra overhead of\n", "the per-bar links may make the pages too slow or resource-intensive.\"\n", 
"\n", "# pie_chart_slice_color option info\n", "OPTION_LABEL_pcsc              \"Pie chart slice (number) color\"\n", 
"OPTION_SHORT_DESCRIPTION_pcsc  \"The color of one of the slices of a pie chart\"\n", "OPTION_LONG_DESCRIPTION_pcsc\n", 
"\"This specifies the color of one slice of a pie chart.  The first field\n", "(filled in if you are using {PRODUCT_NAME} from a web browser)\n", 
"is the slice number; slice number 1 is the largest slice, 2 is the second largest, etc.\n", "Slices numbers up to the value specified by [max_pie_chart_slices] may be used.\n", 
"{COLOR_COMPONENTS_INFO}.\"\n", "\n", "\n", "##\n", "## HEADER/FOOTER OPTION CATEGORY\n", "##\n", "\n", 
"# page_footer option info\n", "OPTION_LABEL_pf              \"Footer text\"\n", "OPTION_SHORT_DESCRIPTION_pf  \"HTML code to place at the bottom of statistics pages\"\n", 
"OPTION_LONG_DESCRIPTION_pf\n", "\"This specifies the HTML text to appear at the bottom of statistics pages.\n", 
"If both this and [pff] are specified, both will appear, and this will appear second.\n", "See also [pff], [ph], [phf], [pfc], and [phaf].\"\n", 
"\n", "# page_footer_file option info\n", "OPTION_LABEL_pff              \"Footer file\"\n", "OPTION_SHORT_DESCRIPTION_pff  \"An HTML file whose contents go at the bottom of statistics pages\"\n", 
"OPTION_LONG_DESCRIPTION_pff\n", "\"This specifies a file containing HTML text to appear at the bottom of statistics pages.\n", 
"If both this and [pf] are specified, both will appear, and this will appear first.\n", "See also [pf], [ph], [phf], [pfc], and [phaf].\"\n", 
"\n", "# page_header option info\n", "OPTION_LABEL_ph              \"Header text\"\n", "OPTION_SHORT_DESCRIPTION_ph  \"HTML code to place at the top of statistics pages\"\n", 
"OPTION_LONG_DESCRIPTION_ph\n", "\"This specifies the HTML text to appear at the top of statistics pages.\n", 
"If both this and [phf] are specified, both will appear, and this will appear first.\n", "See also [phf], [pf], [pff], [pfc], and [phaf].\"\n", 
"\n", "# page_header_file option info\n", "OPTION_LABEL_phf              \"Header file\"\n", "OPTION_SHORT_DESCRIPTION_phf  \"An HTML file whose contents go at the top of statistics pages\"\n", 
"OPTION_LONG_DESCRIPTION_phf\n", "\"This specifies a file containing HTML text to appear at the top of statistics pages.\n", 
"If both this and [ph] are specified, both will appear, and this will appear second.\n", "See also [ph], [pf], [pff], [pfc], and [phaf].\"\n", 
"\n", "# page_frame_command option info\n", "OPTION_LABEL_pfc              \"Page frame command\"\n", 
"OPTION_SHORT_DESCRIPTION_pfc  \"A command which is executed to generate HTML to frame {PRODUCT_NAME}'s statistics in\"\n", 
"OPTION_LONG_DESCRIPTION_pfc\n", "\"This option specifies a command-line program to run (UNIX and Windows only) \n", 
"to generate an HTML %22frame%22 into which {PRODUCT_NAME}'s statistics page output should be inserted. \n", 
"This is useful for integrating {PRODUCT_NAME}'s output with the look and feel of a web site. \n", "The program should generate this HTML to its standard output stream. \n", 
"The frame should be a complete HTML document, starting with &lt;HTML&gt; and ending with \n", "&lt;/HTML&gt;.  Somewhere in the document, the text %22%255B%255B%255BSTATISTICS%255D%255D%255D%22 should appear \n", 
"(without the quotes). \n", "{PRODUCT_NAME} will generate statistics pages by replacing that text with the statistics information, and leaving the rest of \n", 
"the page unchanged. \n", "See also [pf], [ph], [pff], [phf], and [phaf].<p>\"\n", "\n", "# preprocess_headers_and_footers option info\n", 
"OPTION_LABEL_phaf              \"Preprocess headers and footers file\"\n", "OPTION_SHORT_DESCRIPTION_phaf  \"This determine whether {PRODUCT_NAME} puts header and footer text through the preprocessor before displaying it.\"\n", 
"OPTION_LONG_DESCRIPTION_phaf\n", "\"This determines whether {PRODUCT_NAME} sends the headers and footers through\n", 
"the preprocessor before it displays them.  If this option is true, the HTML text of \n", "headers and footers is preprocessed, replacing curly-enclosed variables and directives, \n", 
"before it is displayed.  This allows you to use variables like {QUOTE:<code>{CONFIG_NAME}</code>} \n", 
"in the headers and footers.  If this option is false, the text will not be preprocessed. \n", "Preprocessing can mangle text that contains curly brackets, like JavaScript or CSS, so \n", 
"unless you need variables, you should leave this off.  If you need variables <i>and</i> \n", "CSS, you'll need to %22escape%22 the CSS by enclosing it in a <code>QUOTE</code> directive; i.e.\n", 
"<code>{QUOTE:{QUOTE:<i>css code</i>}}</code>.\n", "This directive effects [ph], [pf], [phf], [pff], and [pfc].\"\n", 
"\n", "\n", "##\n", "## LOG OPTIONS CATEGORY\n", "##\n", "\n", "\n", "# log_source_url option info\n", 
"OPTION_LABEL_lsu              \"Log source(s)\"\n", "OPTION_SHORT_DESCRIPTION_lsu  \"The location(s) of the log data to analyze\"\n", 
"OPTION_LONG_DESCRIPTION_lsu\n", "\"This specifies the log data to analyze.  Several different types of log sources are \n", 
"supported, including:<p>\n", "<ul>\n", "  <li> The pathname of a log file, possibly including wildcards in the filename portion of the path, \n", 
"       using appropriate pathname syntax for the server where {PRODUCT_NAME} is running (see [docs-pathnames]).\n", 
"       Examples: /var/log/httpd/access.log or /var/log/httpd/*.log (UNIX);\n", "       %22My Hard Drive:Logs:Log File%22 or %22My Hard Drive:Logs:*%22 (Mac); \n", 
"       c:%5Csystem32%5Clogs%5CW3CSVC1%5Cex010101.log or c:%5Csystem32%5CW3CSVC1%5Cex*.log (Windows).<p>\n", 
"  <li> An FTP URL, possibly including wildcards in the filename portion of the URL. \n", "       Examples: ftp://ftp.myserver.com/dir/access.log (anonymous FTP), \n", 
"       ftp://me:mypass@ftp.myserver.com/dir/*.log (log in as user %22me%22 with password %22mypass%22), \n", 
"       ftp://you:yourpass@ftp.yourserver.com:9999/mysite/logs/ex*.log (user %22you%22, password %22yourpass%22, port 9999).<p>\n", 
"  <li> An HTTP URL, specifying one file to analyze.\n", "       Example: http://www.myserver.com/dir/access.log.<p>\n", 
"  <li> The pathname of a command-line program, enclosed in backticks (`).  {PRODUCT_NAME} will read the log \n", 
"       data from the output of the command (the standard output stream).  Examples: \n", "       `/bin/bunzip2 -c /logs/*.bz2` (UNIX; to bunzip the log files on the fly; assumes installation of bunzip2 in /bin), \n", 
"       `/bin/lynx -d http://mysite.com/my.log` (UNIX; to fetch my.log by http; assumes installation of lynx in /bin) \n", 
"       `type /server1/logs/* /server2/logs/* /server3/logs/*` (Windows; combines log files from three folders).<p>\n", 
"  <li> The word %22stdin%22 alone, which causes {PRODUCT_NAME} to read the log data from its standard input stream \n", 
"       (useful only when running {PRODUCT_NAME} from the command line).<p>\n", "</ul>\n", "Sub{PLURALIZE:{DIRECTORY_WORD}} will be processed if the %22process sub{PLURALIZE:{DIRECTORY_WORD}} option is checked\n", 
"(or, if editing a configuration file directory or using the command line, if the\n", "log source line ends with %22,recurse%22).\n", 
"Patterns will be treated as regular expressions if the %22regular expression%22 option is checked\n", 
"(or, if editing a configuration file directory or using the command line, if the\n", "log source line ends with %22,regexp%22).\n", 
"Patterns are allowed only in the filename portion of the pathname or URL, not in the \n", "{DIRECTORY_WORD} portion.<p>\n", 
"You can specify multiple log sources by listing one log source (for instance, \n", "one pathname, or URL, or one of the other types of log sources listed above) on each line.\n", 
"If you do that, {PRODUCT_NAME} will process the log sources in the order you specify.<p>\n", "If the log source is local (on the local disk), {PRODUCT_NAME}\n", 
"also examines the log source to see if\n", "any files in it have names starting with .current*.  If there are any,\n", 
"{PRODUCT_NAME} reads the first line of their contents, and treats it as a filename.\n", "Any file with that name in the log source is not processed.\n", 
"The purpose of this feature is to allow an automated file uploading system\n", "to tell {PRODUCT_NAME} which file it is currently uploading, so {PRODUCT_NAME} won't \n", 
"try to process partially uploaded files (which could cause some log entries to\n", "appear corrupt if the file is uncompressed, and could cause the whole file to\n", 
"appear corrupt if it's compressed).<p>\n", "\"\n", "\n", "# use_regular_expressions_for_log_source option info\n", 
"OPTION_LABEL_urefls              \"Pattern is a regular expression\"\n", "OPTION_SHORT_DESCRIPTION_urefls  \"The pattern specified to choose files for the log source is a regular expression\"\n", 
"OPTION_LONG_DESCRIPTION_urefls\n", "\"This option controls whether the pattern specified in the filename section of the [lsu] option \n", 
"is a regular expression or a wildcard pattern. \n", "When this option is true, the pattern is treated as a full regular expression, \n", 
"and any regular expression constructions can be used (see [docs-regexp]). \n", "When this is false, the pattern is treated as a wildcard expression, \n", 
"only the * and ? wildcards may be used.\n", "Only log files which are in the {DIRECTORY_WORD} specified by the [lsu],\n", 
"or in a sub{DIRECTORY_WORD} of it, \n", "and whose names match this regular expression, will be processed.\"\n", 
"\n", "# process_log_source_subdirectories option info\n", "OPTION_LABEL_plss              \"Process sub{PLURALIZE:{DIRECTORY_WORD}} (local {PLURALIZE:{DIRECTORY_WORD}} only)\"\n", 
"OPTION_SHORT_DESCRIPTION_plss  \"Whether to process log files in sub{PLURALIZE:{DIRECTORY_WORD}} of the specified log source {DIRECTORY_WORD}\"\n", 
"OPTION_LONG_DESCRIPTION_plss\n", "\"This controls whether {PRODUCT_NAME} scans local sub{PLURALIZE:{DIRECTORY_WORD}} while processing a log source. \n", 
"If this option is false, only files directly inside the specified {DIRECTORY_WORD} will be processed; \n", 
"files in sub{PLURALIZE:{DIRECTORY_WORD}} will not be processed.  If this option is true, all files in the {DIRECTORY_WORD} \n", 
"will be processed, even if they are contained in {PLURALIZE:{DIRECTORY_WORD}} of the specified {DIRECTORY_WORD}, or in \n", 
"{PLURALIZE:{DIRECTORY_WORD}} of those, etc.<p>\n", "IMPORTANT: This option only works with local {PLURALIZE:{DIRECTORY_WORD}}-- it does not work with FTP URLs. \n", 
"If you need to process several {PLURALIZE:{DIRECTORY_WORD}} on an FTP server, \n", "you need to enter each {DIRECTORY_WORD} separately, as a separate URL.\"\n", 
"\n", "# write_accepted_entries_to_log option info\n", "OPTION_LABEL_waetl              \"Write accepted entries to log\"\n", 
"OPTION_SHORT_DESCRIPTION_waetl  \"The pathname of a log file to generate from the accepted log entries\"\n", 
"OPTION_LONG_DESCRIPTION_waetl\n", "\"This option specifies a log file which {PRODUCT_NAME} <i>creates</i>. \n", 
"This log file is overwritten whenever {PRODUCT_NAME} processes log data. \n", "{PRODUCT_NAME} writes those log entries which pass the filters (see [docs-filters]) \n", 
"to this file, in Apache Extended Log Format. \n", "This provides an easy way to use {PRODUCT_NAME} as a log filtering tool. \n", 
"If this option is empty, {PRODUCT_NAME} does not write the log entries.\"\n", "\n", "# log_entry_pool_size info\n", 
"OPTION_LABEL_leps              \"Log entry pool size\"\n", "OPTION_SHORT_DESCRIPTION_leps  \"The number of log entries {PRODUCT_NAME} can work on simultaneously\"\n", 
"OPTION_LONG_DESCRIPTION_leps\n", "\"This controls the number of log entries {PRODUCT_NAME} can work on at a time. \n", 
"Increasing this value may improve performance of DNS lookup, and may \n", "improve processing performance in multithreaded mode (see [mlr]). \n", 
"However, it will also use more memory.\"\n", "\n", "# log_command option info\n", "OPTION_LABEL_lc              \"Log command\"\n", 
"OPTION_SHORT_DESCRIPTION_lc  \"The command to execute to generate the log data\"\n", "OPTION_LONG_DESCRIPTION_lc\n", 
"\"This option is ignored unless the [log_source_type] option is set to Command.\n", "This option is available only on Windows and UNIX systems.\n", 
"This specifies the command to execute to generate the log data;\n", "the output (stdout) of the command is processed as the log data.\"\n", 
"\n", "# log_file_format option info\n", "OPTION_LABEL_lff              \"Log data format\"\n", "OPTION_SHORT_DESCRIPTION_lff  \"The format of the log data\"\n", 
"OPTION_LONG_DESCRIPTION_lff\n", "\"This specifies the name of the log format of the log data (from the log source; see [lsu]). \n", 
"When this appears in a log format description file, it defines the name of the format \n", "being described.\n", 
"When this appears in a configuration, it must be the name of a known log format; i.e. \n", "there must be a log format description file in the LogFormats sub{DIRECTORY_WORD} of \n", 
"the LogAnalysisInfo {DIRECTORY_WORD} with the same value for this option as the configuration. \n", 
"For instance, if this option's value is %22Apache Combined Log Format%22, then there must \n", "be a file in LogFormats which defines %22Apache Combined Log Format%22.\n", 
"{PRODUCT_NAME} generally handles this for you by auto-detecting the format and setting it for you \n", 
"when you create the configuration.\"\n", "\n", "# log_data_type option info\n", "OPTION_LABEL_ldt              \"Log data category\"\n", 
"OPTION_SHORT_DESCRIPTION_ldt  \"The general category of the log data\"\n", "OPTION_LONG_DESCRIPTION_ldt\n", 
"\"This specifies the category of log data.  Possible categories include:<p>\n", "<ul>\n", "  <li> <code>http_access</code>: Web server access, extended, or combined log data\n", 
"  <li> <code>http_referrer</code>: Web server referrer log data\n", "  <li> <code>http_agent</code>: Web server agent log data\n", 
"  <li> <code>http_error</code>: Web server error log data\n", "  <li> <code>network</code>: Network appliance log data\n", 
"  <li> <code>firewall</code>: Firewall, proxy, or cache server log data\n", "  <li> <code>ftp</code>: FTP server log data\n", 
"  <li> <code>switch</code>: Switch or network component log data\n", "  <li> <code>mail_server</code>: Mail/SMTP server log data\n", 
"  <li> <code>mail_pop</code>: POP or IMAP mail server log data\n", "  <li> <code>generic</code>: Generic log data\n", 
"</ul><p>\n", "This option is used in log format plug-ins, and should generally not be changed\n", "from the value specified by the plug-in.  {PRODUCT_NAME} uses the value of this\n", 
"option to decide how to set up some views, how to name some views, and fields,\n", "what to use as the instructions for some views, and more.\"\n", 
"\n", "# detail_level option info\n", "OPTION_LABEL_dl               \"Database detail level\"\n", "OPTION_SHORT_DESCRIPTION_dl   \"The level of detail for the database\"\n", 
"OPTION_LONG_DESCRIPTION_dl\n", "\"This option controls the level of detail for the database.\n", "More detail uses more memory, disk space, and time. \n", 
"This option is used in log format description files to \n", "provide multiple detail level options (using $if).\"\n", 
"\n", "# log_file_format_regular_expression option info\n", "OPTION_LABEL_lffre              \"Log data format regular expression\"\n", 
"OPTION_SHORT_DESCRIPTION_lffre  \"A regular expression describing the log format\"\n", "OPTION_LONG_DESCRIPTION_lffre\n", 
"\"This is a regular expression which specifies the log format. \n", "You only need to change this option if you are creating your own log file format.\n", 
"It is a regular expression (see [docs-regexp]) which matches \n", "an entire log entry (one line of the log), and contains a \n", 
"parenthesized substring for each log field.  For each line that \n", "matches the regular expressions, the part of the line which matches the \n", 
"first substring will become log field 1, the part of the line matching the \n", "second substring will be log field 2, etc. (see [lfi]). \n", 
"Log lines which do not match this expression will be rejected<p>\n", "\n", "For example, consider the following regular expression: <p>\n", 
"  ^(\\[^ ]*) (\\[^ ]*) (\\[^ ]*) (\\[^ ]*)$\n", "Each parenthesized part matches any sequence not containing a space, \n", 
"and the four parts must be separated by spaces.  The leading ^ and trailing $ \n", "ensure that the whole line must be matched.  This expression matches a line \n", 
"which contains four fields, separated by spaces, where the fields do not contain spaces. \n", "The first field will be put into the first log field, the second into the second log field, the third into \n", 
"the third log field, and the fourth into the fourth log field.<p>\n", "Some log formats cannot be processed using a single regular expression, \n", 
"either because they have peculiar field layout, or because their fields span several lines, \n", "or for some other reason.  Usually it is still possible to process the log files with {PRODUCT_NAME}, \n", 
"but the log format description file will need to include log parsing filters with more complicated \n", 
"parsing logic.  For one example of that, see the Raptor file in the LogFormats\n", "sub{DIRECTORY_WORD} of the LogAnalysisInfo {DIRECTORY_WORD}.\" \n", 
"\n", "# log_format_autodetect_regular_expression option info\n", "OPTION_LABEL_lfare              \"Log file format regular expression used to auto-detect format\"\n", 
"OPTION_SHORT_DESCRIPTION_lfare  \"A regular expression used to auto-detect the log format\"\n", "OPTION_LONG_DESCRIPTION_lfare\n", 
"\"This is a regular expression which is used to auto-detect the log format. \n", "This option appears in the log format descriptor file for a log format \n", 
"(which is in the LogFormats sub{DIRECTORY_WORD} of LogAnalysisInfo). \n", "A log file matches the format if any of the first five lines of the log file \n", 
"match this regular expression.  See also [lffre], which is a similar option serving a different purpose. \n", 
"[lffre] is used during log reading to separate out log fields, and does not affect auto-detection; [lfare] is \n", 
"used <i>only</i> during format auto-detection, and does not affect log reading.\"\n", "\n", "# log_format_description_string option info\n", 
"OPTION_LABEL_lfds              \"Blue Coat log format description string\"\n", "OPTION_SHORT_DESCRIPTION_lfds  \"A string which describes the log format, Blue Coat style\"\n", 
"OPTION_LONG_DESCRIPTION_lfds\n", "\"This option describes the log format, in Blue Coat custom log format description string style.\n", 
"This is intended for use as a quick way of using a custom Blue Coat format-- \n", "you can copy the format string from the Blue Coat configuration interface, \n", 
"and {PRODUCT_NAME} will set up the log fields and \n", "format regular expressions for you.\n", "This option overrides [lffre].\"\n", 
"\n", "# apache_log_format_description_string option info\n", "OPTION_LABEL_alfds              \"Apache log format description string\"\n", 
"OPTION_SHORT_DESCRIPTION_alfds  \"A string which describes the log format, Apache-style\"\n", "OPTION_LONG_DESCRIPTION_alfds\n", 
"\"This option describes the log format, in Apache log format description string style.\n", "This is intended for use as a quick way of using a custom Apache format-- \n", 
"you can copy the format string from an Apache configuration file (or another file \n", "that uses Apache style format strings), and {PRODUCT_NAME} will set up the log fields and \n", 
"format regular expressions for you.\n", "This option overrides [lffre].\"\n", "\n", "# global_date_regular_expression option info\n", 
"OPTION_LABEL_gdre               \"Global date regular expression\"\n", "OPTION_SHORT_DESCRIPTION_gdre   \"A regular expression which, if matched in the log data, determines the date for all subsequent entries\"\n", 
"OPTION_LONG_DESCRIPTION_gdre\n", "\"This option is a regular expression (see [docs-regexp]) \n", "which is used to extract a %22global date%22 from log data. \n", 
"A global date is a date that appears in log data, usually in the header, \n", "and specifies the date for all subsequent log entries.  Usually, this \n", 
"is used when the log entries do not contain date information at all, \n", "but if they do, this overrides them.  When this option is not empty, \n", 
"every line of the log file is checked against this regular expression, \n", "and if it matches, the parenthesized section is remembered as the %22global date%22. \n", 
"From then on, or until another global date line is found, the date field of any \n", "accepted log entry is replaced by the global date value.\n", 
"If this option is empty, it is not used.\"\n", "\n", "# global_date_filename_regular_expression option info\n", 
"OPTION_LABEL_gdfre               \"Global date filename regular expression\"\n", "OPTION_SHORT_DESCRIPTION_gdfre   \"A regular expression which, if matched in the log filename, determines the date for all entries in that log file\"\n", 
"OPTION_LONG_DESCRIPTION_gdfre\n", "\"This option is a regular expression (see [docs-regexp]) \n", "which is used to extract a %22global date%22 from the name of the log file. \n", 
"A global date is a date that applies to all log appears in a file. \n", "Usually, this \n", "is used when the log entries do not contain date information at all, \n", 
"but if they do, this overrides them.  When this option is not empty, \n", "the filename of every log processed is checked against this regular expression, \n", 
"and if it matches, the parenthesized section is remembered as the %22global date%22. \n", "From then on, or until another global date filename is found, the date field of any \n", 
"accepted log entry is replaced by the global date value.\n", "If this option is empty, it is not used.\"\n", 
"\n", "# default_log_date_year info\n", "OPTION_LABEL_dldy               \"Default log date year\"\n", 
"OPTION_SHORT_DESCRIPTION_dldy   \"The year to use (e.g. 2001) if the date format in the log data has no year information\"\n", 
"OPTION_LONG_DESCRIPTION_dldy\n", "\"This option is used if the log date format ([ldf]) is one of the \n", 
"few formats which does not include year information.  {PRODUCT_NAME} \n", "will use this option's value as the year.  For instance, if \n", 
"the date in the log is %22May 7%22 and this option's value is 2002, \n", "then {PRODUCT_NAME} will assume that the log entry is for May 7, 2002.  \n", 
"The value of this entry should be a four-digit integer between 1970 and 2030.\"\n", "\n", "# log_field_index option info\n", 
"OPTION_LABEL_lfi              \"Log field information\"\n", "OPTION_SHORT_DESCRIPTION_lfi  \"Information about a particular field in the log\"\n", 
"OPTION_LONG_DESCRIPTION_lfi\n", "\"This describes a single field in the log data. \n", "You will generally not need to use this option unless you are creating your own log format description file.<p>\n", 
"A log field may be either an actual field which is present in \n", "each log entry of the file (for instance, the %22page%22 field, \n", 
"or the %22hostname%22 field),\n", " or a <i>derived</i> field which is \n", "not present in log entries, but is derived from the entries which are \n", 
"present, and from other information.  Derived fields include fields \n", "like %22domain description,%22 which is a textual description of the \n", 
"host domain (e.g. %22France%22 for .fr), and is derived from the hostname field, \n", "or the %22day of week%22 field, which is derived from the date/time field, \n", 
"or the %22operating system%22 field, which is derived from the agent field.\n", "Derived fields cannot be deleted \n", 
"or edited, though they will disappear if the field they are derived from \n", "is deleted.  See below for more information about specific derived fields.<p>\n", 
"\n", "For fields which are not derived, you can specify a number of parameters.\n", "The values of the parameters are as follows:<p>\n", 
"<ol>\n", "<li> <b>Field name</b>: The name of this field.<p> \n", "<li> <b>Field type</b>: The type of the log field.  The type describes\n", 
"     the format of the field, and sometimes also describes the purpose of the field. \n", "     Allowable field types are:<p> \n", 
"     <ul> \n", "     <li><b>{LOG_FIELD_TYPE_page}</b> (<code>page</code>): \n", "         The %22page hit%22 field of a web log, or any field in a /-divided pathname format; e.g. /mypages/dir/file.html.\n", 
"         This also acts like a %22{LOG_FIELD_TYPE_hierarchical}%22 field.<p> \n", "     <li><b>{LOG_FIELD_TYPE_host}</b> (<code>host</code>): \n", 
"         The browsing hostname, or any field in hostname format; e.g. my.host.com. \n", "         This field will be used to derive the domain description field. \n", 
"         This also acts like a %22{LOG_FIELD_TYPE_hierarchical}%22 field.\n", "         The domain description field is derived from this field.<p> \n", 
"     <li><b>{LOG_FIELD_TYPE_URL}</b> (<code>url</code>): \n", "         Any field in URL format (e.g. http://hostname/page.html). \n", 
"         The search phrase field is derived from this field.<p> \n", "     <li><b>{LOG_FIELD_TYPE_date/time}</b> (<code>date/time</code>): \n", 
"         A combined date/time field.  The format of \n", "         this field depends on the setting of [ldf] and [ltf]. \n", 
"         If this field is not present in the log, but <b>date</b> and <b>time</b> are, \n", "         this field will be derived from those fields.  The day of week, hour of day, week of year, and day of year\n", 
"         fields are derived from this field.<p> \n", "     <li><b>{LOG_FIELD_TYPE_date}</b> (<code>date</code>): \n", 
"         A date; year, month, and day.  The format of this field depends on the setting of [ldf].<P> \n", 
"     <li><b>{LOG_FIELD_TYPE_time}</b> (<code>time</code>): \n", "         A time of day; hour, minute, and second.  The format of this field depends on the setting of [ltf].<P> \n", 
"     <li><b>{LOG_FIELD_TYPE_agent}</b> (<code>agent</code>): \n", "         An agent, or browser, field.  The browser OS, browser type, and browser version fields are derived from this field.\n", 
"         This also acts like a %22{LOG_FIELD_TYPE_flat})%22 field.<p> \n", "     <li><b>{LOG_FIELD_TYPE_size}</b> (<code>size</code>): \n", 
"         The size (bytes transferred) field.  This field will be used \n", "         to compute bandwidth information.  This also acts like a %22{LOG_FIELD_TYPE_integer})%22 field.\n", 
"         The size range field is derived from this field.<p> \n", "     <li><b>{LOG_FIELD_TYPE_integer}</b> (<code>integer</code>): \n", 
"         Any field whose value is an integer (e.g. 67).  This also acts like a %22{LOG_FIELD_TYPE_flat})%22 field.<p> \n", 
"     <li><b>{LOG_FIELD_TYPE_response}</b> (<code>response</code>): \n", "         The %22server response%22 field, containing the numeric HTTP server response code (e.g. 200, 404).<p>\n", 
"     <li><b>{LOG_FIELD_TYPE_hierarchical}</b> (<code>hierarchical</code>): \n", "         Any field which is multi-level hierarchical.  The hierarchy divider  \n", 
"         and other parameters can be specified below.  See [docs-hierarchies].<p> \n", "     <li><b>{LOG_FIELD_TYPE_flat}</b> (<code>flat</code>): \n", 
"         Any field which is hierarchical flat; all fields are directly below the root of the hierarchy.  See [docs-hierarchies].<p> \n", 
"   </ul> \n", "<li> <b>Index</b>: This specifies the index of \n", "     this log field in the log data.  For instance, if this is the first log field in the entry, \n", 
"     this should be 1.  If this is the fifth log field in the line, it should be 5.\n", "     This can be left 0 \n", 
"     if the log field is being filled in by [lffre] or by parsing filters.<p> \n", "<li> <b>Subindex</b>: This specifies the subindex \n", 
"     of this log field in the log data.  This can usually be left at 0.  A subindex is required \n", 
"     only when the log field is contained inside another quoted field.  In that case, the position of the quoted field \n", 
"     is specified using the index, and the subindex indicates the position within the \n", "     quoted field, by space-separated subfield. \n", 
"     This can be left 0 \n", "     if the log field is being filled in by [lffre] or by parsing filters.<p> \n", 
"<li> <b>Hierarchy dividers</b>: This specifies the character(s) which divide hierarchy levels \n", 
"     in this field (if this field is hierarchical).  Up to three characters may be specified.\n", "     For instance, in a standard %22page%22\n", 
"     field (e.g. /one/sample/page.html), the divider would be / or /?, or /?& \n", "     (include the ? if you want the page field to be split on the URL parameters divider; \n", 
"     include the & if you want it split between parameters).  See [docs-hierarchies].<p> \n", "<li> <b>Left-to-right hierarchy</b>: This specified whether the hierarchy is left-to-right \n", 
"     (i.e. with the higher hierarchy levels at the left, like /one/sample/page.html), or  \n", "     right-to-left (i.e. with the higher hierarchy level at the right, like some.hostname.com). \n", 
"     See [docs-hierarchies].<p> \n", "<li> <b>Leading hierarchy divider</b>: This specifies whether the field has a hierarchy divider\n", 
"     at its highest end (e.g. /one/sample/page.html, which starts with /), or not \n", "     (e.g. one/sample/page.html or some.hostname.com, which have hierarchy dividers only inside the field).<p> \n", 
"<li> <b>Case sensitive</b>: This controls whether the field is case-sensitive. \n", "     When this is false, {PRODUCT_NAME} treats items as the same if they differ only in the case (uppercase/lowercase); \n", 
"     for instance, index.html and Index.html are treated as the same page.  The case of the \n", "     item as it appears in statistics is determined by the case of the first item {PRODUCT_NAME} sees while processing the log data, \n", 
"     so if the first hit is on index.html and the second is on Index.html, it will appear in the statistics as \n", 
"     two hits on index.html.  When this option is true, {PRODUCT_NAME} treats differently-cased items \n", 
"     as different items, so in the example above, the statistics would list one hit on index.html, \n", 
"     and one hit on Index.html.<p>\n", "</ol>\n", "<h3>Derived Fields</h3>\n", "Derived fields are %22fake%22 log fields, in the sense that they aren't \n", 
"really in the log data.  Instead, they are derived in some way from the \n", "real fields in the log, or from something else.  Derived fields can be used \n", 
"as database fields, even if the field(s) they are derived from are not used in the database. \n", "Possible derived fields are:\n", 
"<ul>\n", "<li> <b>domain description</b>.  This field is derived from the hostname field.  It \n", 
"     is a textual description of the top-level domain of the hostname.  For instance, \n", "     the host myhost.fr has a domain description of %22France (.fr),%22 and myhost.edu has a \n", 
"     domain description of %22Educational (.edu).%22<p>\n", "<li> <b>referrer domain</b>.  This field is derived from the referrer field.  It \n", 
"     is a textual description of top-level domain of the referrer.    For instance, \n", "     the referrer http://www.myhost.fr/index.html has a domain description of %22France (.fr),%22 and http://myhost.edu/ has a \n", 
"     domain description of %22Educational (.edu).%22<p>\n", "<li> <b>size range</b>.  This field is derived from the size field.  It is the \n", 
"     power-of-ten range into which the size of the transferred object falls.  For instance \n", "     if an HTML page is transferred which is 6k in size, this field will be %221k - 10k.%22 \n", 
"     If a 17k page is transferred, this will be %2210k - 100k.%22<p>\n", "<li> <b>operating system</b>.  This field is derived from the agent field.\n", 
"     This is the operating system used by the browsing user, e.g. %22Windows ME.%22<p>\n", "<li> <b>web browser</b>.  This field is derived from the agent field.\n", 
"     This is the web browser type and version used by the visitor.\n", "     For instance, \n", "     if the visitor browsed your web site with Netscape 5.0, this will be %22Netscape 5.0.%22  This field \n", 
"     is hierarchical, so the top level will show just %22Netscape%22, and clicking it will show the version and \n", 
"     minor version numbers.<p>\n", "<li> <b>search engine</b>.  This field is derived from the referrer field. \n", 
"     It shows the search engine used by the visitor to find your site. \n", "     For instance, if the user searched in AltaVista for %22noodle recipes,%22 and found your site, \n", 
"     the value of this field will be %22AltaVista.%22  Most hits are not the direct result of \n", 
"     clicking in a web search engine's list page, so for most hits, this field will be empty.<p>\n", 
"     {PRODUCT_NAME} determines which search engine contributes which hit by comparing the referrer\n", 
"     field with the values listed in the LogAnalysisInfo/SearchEngines file, so you can modify that\n", 
"     file if you want to add support for new search engines.\n", "<li> <b>search phrase</b>.  This field is derived from the referrer field. \n", 
"     It shows the search phrase used in web search engines by the visitor who contributed to this hit. \n", 
"     For instance, if the user searched in AltaVista for %22noodle recipes,%22 and found your site, \n", 
"     the value of this field will be %22noodle recipes.%22  Most hits are not the direct result of \n", 
"     clicking in a web search engine's list page, so for most hits, this field will be empty.<p>\n", 
"<li> <b>log filename</b>.  This field is unique in that it is not derived from any other \n", "     field.  Instead, it is derived from the name of the log file which contains the current \n", 
"     log entry.  For instance, all entries in the log file %22/var/logs/httpd/access_log%22 \n", "     will have %22/var/logs/httpd/access_log%22 as the value of this field (pathname format \n", 
"     may be different for your platform; see [docs-pathnames]).<p>\n", "<li> <b>date/time</b>.  This is the only field which may be either a <i>real</i> (non-derived) \n", 
"     log field or a derived log field.  In some log formats, the date and time \n", "     are specified together in a single field (see [ldf] and [ltf]); in those \n", 
"     log formats, the date/time field is a single non-derived log field.  In other \n", "     log formats, the date and time fields are separate; in those formats, the date/time \n", 
"     field is derived from the date and time fields.  In a database, you should use \n", "     the date/time field, rather than the separate date or time fields, to take full \n", 
"     advantage of the date/time hierarchy.<p>\n", "<li> <b>day of week</b>.  This field is derived from the date/time field\n", 
"     (which may in turn be derived from the date and time fields).  It is \n", "     the day of week corresponding to the date/time.  For instance, a date/time of \n", 
"     %2203/Mar/1999 09:34:56%22 would have a day of week of %22Monday.%22<p>\n", "<li> <b>hour of day</b>.  This field is derived from the date/time field\n", 
"     (which may in turn be derived from the date and time fields).  It is \n", "     the hour of day corresponding to the date/time.  For instance, a date/time of \n", 
"     %2203/Mar/1999 09:34:56%22 would have a day of week of %229:00 AM - 10:00 AM.%22<p>\n", "<li> <b>day of year</b>.  This field is derived from the date/time field\n", 
"     (which may in turn be derived from the date and time fields).  It is \n", "     the number of the day of the year.  For instance, January 1 is %221%22, \n", 
"     January 20 is %2220%22, and February 10 is %2241%22.<p>\n", "<li> <b>week of year</b>.  This field is derived from the date/time field\n", 
"     (which may in turn be derived from the date and time fields).  It is \n", "     the number of the week of the year.  For instance, for hits on the first seven days \n", 
"     of the year (January 1 - 7, inclusive) this field will be %221%22.  For \n", "     hits one the second week of the year (January 8 - 14) this field will be %222%22, and so on.<p>\n", 
"<li> <b>worm</b>.  This field is derived from the page field.\n", "     It shows the name of the worm for each hit, or %22(not a worm)%22 if the hit was not\n", 
"     a worm hit (worms are programs that attempt to infect other computer, usually through exploiting\n", 
"     vulnerable versions of servers like web servers).\n", "     Worms are detected using the LogAnalysisInfo/Worms file, so you can edit this\n", 
"     file if you want to add detection of additional worms.<p>\n", "<li> <b>spider</b>.  This field is derived from the agent field.\n", 
"     It shows the name of the spider for each hit, or %22(not a spider)%22 if the hit was not\n", "     a spider hit.  Spiders are programs that %22walk%22 from page to page on the Internet,\n", 
"     reading each page and doing something with it; for instance, search engines use spiders\n", "     to build their databases of Internet pages.\n", 
"     Spiders are detected using the LogAnalysisInfo/Spiders file, so you can edit this\n", "     file if you want to add detection of additional spiders.<p>\n", 
"</ul><p>\n", "<h3>Editing the configuration file directly</h3>\n", "Most users will edit the log fields from the web GUI, but power users may wish to edit \n", 
"them by editing the configuration file using a text editor. \n", "In the configuration file, the format is %22log_field_info%22, followed by \n", 
"%22standard%22, followed by a list of log fields, followed by %22field_end%22. \n", "Each field in the list contains the options in the order listed above, i.e. \n", 
"field name, field type, index, subindex, dividers, left-to-right, leading divider, case sensitive, \n", 
"followed by an extra unused option which should be left blank.  See any \n", "log format description file for a good example of this format.<p>\n", 
"\"\n", "\n", "# log_date_format option info\n", "OPTION_LABEL_ldf              \"Log file date format\"\n", 
"OPTION_SHORT_DESCRIPTION_ldf  \"Format of dates in the log\"\n", "OPTION_LONG_DESCRIPTION_ldf\n", "\"This controls the expected format of date fields in the log data.  Possible formats are:<p>\n", 
"<ul>\n", "  <li> <b>mm/dd/yy</b>; example: 04/21/00.<p>\n", "  <li> <b>mm/dd/yyyy</b>; example: 04/21/2000<p>\n", 
"  <li> <b>dd/mm/yyyy</b>; example: 21/04/2000<p>\n", "  <li> <b>dd/mm/yy</b>; example: 21/04/00.<p>\n", 
"  <li> <b>ddmmmyy</b>; example: 21Apr00.<p>\n", "  <li> <b>dd/mmm/yy</b>; example: 21/Apr/00.<p>\n", 
"  <li> <b>dmmmyyyy</b>; example: 21Apr2000, 4Dec1998.<p>\n", "  <li> <b>dd/mmm/yyyy</b>; example: 21/Apr/2000.<p>\n", 
"  <li> <b>mmm/dd/yyyy</b>; example: Apr/21/2000.<p>\n", "  <li> <b>mmmmm/dd/yyyy</b>; example: April/21/2000, %22December 21, 2002%22, %22January 5 2001%22 (any dividers allowed).<p>\n", 
"  <li> <b>yyyy/mmm/dd</b>; example: 2000/Apr/21.<p>\n", "  <li> <b>m/d/yy</b>; same as mm/dd/yy, but leading zeros in month and day\n", 
"       may be omitted; examples: 4/21/00, 12/4/98, 11/23/02.<p>\n", "  <li> <b>m/d/y</b>; same as mm/dd/yy, but leading zeros in month, day, and year\n", 
"       may be omitted; examples: 4/21/0, 12/4/98, 11/23/2.<p>\n", "  <li> <b>d/m/y</b>; same as dd/mm/yy, but leading zeros in month, day, and year\n", 
"       may be omitted; examples: 21/4/0, 4/12/98, 23/11/2.<p>\n", "  <li> <b>m/d/yyyy</b>; same as mm/dd/yyyy, but leading zeros in month and day\n", 
"       may be omitted; examples: 4/21/2000, 12/4/1998, 11/23/2002.<p>\n", "  <li> <b>d/m/yyyy</b>; same as dd/mm/yyyy, but leading zeros in month and day\n", 
"       may be omitted; examples: 21/4/2000, 4/12/1998, 23/11/2002.<p>\n", "  <li> <b>d/m/yy</b>; same as dd/mm/yy, but leading zeros in month and day\n", 
"       may be omitted; examples: 21/4/00, 4/12/98, 23/11/02.<p>\n", "  <li> <b>mmdd</b>; example: 0421; year is assumed to be 2002.<p>\n", 
"  <li> <b>mm/dd</b>; example: 04/21; year is assumed to be 2002.<p>\n", "  <li> <b>mmm dd</b>; example: Apr 21; year is assumed to be 2002.<p>\n", 
"  <li> <b>dd/mmm/yyyy:hh:mm:ss</b>; example: 21/Apr/1998:08:12:45; colon between date and time may be a space instead.<p>\n", 
"  <li> <b>mm/dd/yyyy hh:mm:ss</b>; example: 04/21/1998 08:12:45.<p>\n", "  <li> <b>mmm dd hh:mm:ss yyyy</b>; example: Apr 21 08:12:45 1998.  Optionally, a time zone can be specified before the year;\n", 
"       i.e. Apr 03 15:57:15 PST 2002.<p>\n", "  <li> <b>yyyy-mm-dd</b>; example: 1998-04-21.<p>\n", 
"  <li> <b>yyyy/mm/dd</b>; example: 1998/04/21.<p>\n", "  <li> <b>yyyy/m/d</b>; example: 1998/4/21.<p>\n", 
"  <li> <b>yyyymmdd</b>; example: 19980421.<p>\n", "  <li> <b>yyyymmddhhmmss</b>; example: 19980421081245.<p>\n", 
"  <li> <b>yymmdd-hhmmss</b>; example: 980421-081245.<p>\n", "  <li> <b>m/d/yy h:mm</b>; example: 4/21/98 8:12.<p>\n", 
"  <li> <b>seconds_since_jan1_1970</b>; the number of seconds since January 1, 1970, possibly\n", "       with a decimal point; example: 887395356.086578.<p>\n", 
"  <li> <b>TAI64N</b>; TAI64N format; example @400000003c675d4000fb2ebc.<p>\n", "</ul>\n", "The divider between items does not need to be a slash--it can be any single character; \n", 
"for instance if your log format uses 04-21-2000 as its date, you can choose mm/dd/yyyy and it will work.<p>\n", 
"\"\n", "\n", "# log_time_format option info\n", "OPTION_LABEL_ltf              \"Log file time format\"\n", 
"OPTION_SHORT_DESCRIPTION_ltf  \"Format of times in the log\"\n", "OPTION_LONG_DESCRIPTION_ltf\n", "\"This controls the expected format of time fields in the log data.  Possible formats are:<p>\n", 
"<ul>\n", "  <li> <b>hh:mm:ss</b>; example: 18:04:23.<p>\n", "  <li> <b>h:mm:ss</b>; same as hh:mm:ss except that the leading 0 on the hour may be omitted example: 8:12:45.<p>\n", 
"  <li> <b>h:m:s</b>; same as hh:mm:ss except that the leading 0 on the hour, minute, or second may be omitted example: 8:12:45, 12:8:15, 1:5:9.<p>\n", 
"  <li> <b>dd/mmm/yyyy:hh:mm:ss</b>; example: 21/Apr/1998:08:12:45.<p>\n", "  <li> <b>mmm dd hh:mm:ss yyyy</b>; example: Apr 21 08:12:45 1998.<p>\n", 
"  <li> <b>h:mm:ss AM/PM</b>; examples: 9:32:45 AM, 12:34:22 PM.<p>\n", "  <li> <b>h:mm:ss GMT</b>; examples: 9:32:45 GMT, 18:34:22 GMT.<p>\n", 
"  <li> <b>h:mm</b>; example: 18:04, 9:32.<p>\n", "  <li> <b>hhmm</b>; example: 1804.<p>\n", "  <li> <b>hhmmss</b>; example: 180423.<p>\n", 
"  <li> <b>yyyymmddhhmmss</b>; example: 19980421081245.<p>\n", "  <li> <b>yymmdd-hhmmss</b>; example: 980421-081245.<p>\n", 
"  <li> <b>m/d/yy h:mm</b>; example: 4/21/98 8:12.<p>\n", "  <li> <b>seconds_since_jan1_1970</b>; the number of seconds since January 1, 1970, possibly\n", 
"       with a decimal point; example: 887395356.086578.<p>\n", "  <li> <b>TAI64N</b>; TAI64N format; example @400000003c675d4000fb2ebc.<p>\n", 
"</ul>\n", "\"\n", "\n", "# treat_brackets_as_quotes option info\n", "OPTION_LABEL_tbaq              \"Treat square brackets as quotes\"\n", 
"OPTION_SHORT_DESCRIPTION_tbaq  \"Treat square brackets as quotes\"\n", "OPTION_LONG_DESCRIPTION_tbaq\n", 
"\"This controls whether square brackets should be treated the same as\n", "quotes (%22) when they are encountered in a log entry.  For some log formats\n", 
"(e.g. Common Access Log Format) it is convenient to think of square brackets as\n", "a special kind of quote; whatever they contain is treated as a single field.\"\n", 
"\n", "# allow_newlines_inside_quotes option info\n", "OPTION_LABEL_aniq              \"Allow newlines inside quotes\"\n", 
"OPTION_SHORT_DESCRIPTION_aniq  \"Allow newlines (return or line feed) inside quotes, in log lines\"\n", 
"OPTION_LONG_DESCRIPTION_aniq\n", "\"This controls whether newline characters (returns or line feeds) are permitted inside quotes\n", 
"in log data.  When this option is true, and a log line starts a quoted section but does not close it\n", 
"{PRODUCT_NAME} will continue with the next line, looking for the closing quote there (or on\n", "a later line.  The resulting %22line%22 of log data will be two or more line long, and some\n", 
"field values may have returns or linefeeds in them.  When this option is false (unchecked), \n", "{PRODUCT_NAME} will assume that unclosed quotes in a line are errors or formatting problems,\n", 
"and will treat the final (unclosed) quoted section as though there were a closing quote at the\n", 
"end of the line.  This option should generally be left off, since turning it makes it possible\n", 
"that a small log data corruption can render the entire rest of the file unprocessed.  But\n", "if your log data does contain entries with newlines inside quotes (as some CSV data does),\n", 
"then you will need to turn this option on.\"\n", "\n", "# common_log_format option info\n", "OPTION_LABEL_clf              \"Format is Common Log Format\"\n", 
"OPTION_SHORT_DESCRIPTION_clf  \"Log format is Common Log Format\"\n", "OPTION_LONG_DESCRIPTION_clf\n", 
"\"This option should be set when the log format is a Common Log Format (CLF), \n", "one of a collection of similar log formats which, among other attributes, \n", 
"have the date/time field in brackets, and the user field right before the bracketed \n", "date/time field.  This option turned on a special work-around which is necessary \n", 
"for certain CLF files where the usernames contain spaces.  Because CLF does not quote the \n", "username field, spaces in the username field can cause the rest of the fields to be offset, \n", 
"causing strange results.  This option causes the field before the date/time field to be \n", "combined with any apparently separate fields, until a left-square-bracket is found. \n", 
"This effectively allows the username field to contain spaces in CLF format. \n", "This option should be left off for any non-CLF log formats.\"\n", 
"\n", "# ignore_format_lines info\n", "OPTION_LABEL_ifl              \"Ignore format lines\"\n", "OPTION_SHORT_DESCRIPTION_ifl  \"Ignore format lines in the log data\"\n", 
"OPTION_LONG_DESCRIPTION_ifl\n", "\"This controls whether {PRODUCT_NAME} ignores format lines in the log data. \n", 
"Format lines are lines starting with #Format, format=, or !!LOG_FORMAT, \n", "which appear in the log data, usually in a header, and \n", 
"describe the format of the log data on the following lines. \n", "Generally, you want to leave this option off, so {PRODUCT_NAME} will \n", 
"understand log format changes if they occur in the middle of the log data. \n", "However, if you have defined custom log fields, you need to turn this on, \n", 
"or the fields will be lost when format lines are encountered.\"\n", "\n", "# parse_only_with_filters option info\n", 
"OPTION_LABEL_powf              \"Parse log only with parsing filters\"\n", "OPTION_SHORT_DESCRIPTION_powf  \"Use only the parsing filters to parse the log (and not the log format regexp, index/subindex, etc.)\"\n", 
"OPTION_LONG_DESCRIPTION_powf\n", "\"This controls whether the log format regular expression ([lffre]) option \n", 
"and the index/subindex settings of the log fields ([lfi]) have any effect.\n", "When this is false, both will be used to parse/process the log. \n", 
"When this is true, they will be ignored, and only the log parsing filters \n", "([lpf]) will be used to parse/process the log.  Turn this on for \n", 
"custom log formats which use only log parsing filters to parse the log, \n", "to improve performance.\"\n", 
"\n", "# log_field_separator option info\n", "OPTION_LABEL_lfs              \"Log field separator\"\n", 
"OPTION_SHORT_DESCRIPTION_lfs  \"The character or string that separates one log field from the next\"\n", 
"OPTION_LONG_DESCRIPTION_lfs\n", "\"This specifies the character or string which separates one log field from another \n", 
"in a log entry.  For instance, if this is %22,%22 then log fields are comma-separated; \n", "if it is %22==--==%22, then the fields are separate from each other by ==--==.\"\n", 
"\n", "# european_dates option info\n", "OPTION_LABEL_ed              \"(Obsolete Option)\"\n", "OPTION_SHORT_DESCRIPTION_ed  \"(Obsolete Option)\"\n", 
"OPTION_LONG_DESCRIPTION_ed   \"(Obsolete Option)\"\n", "\n", "##\n", "## NETWORK OPTIONS CATEGORY\n", 
"\n", "# look_up_ip_numbers option info\n", "OPTION_LABEL_luin              \"Look up IP numbers using domain nameserver (DNS)\"\n", 
"OPTION_SHORT_DESCRIPTION_luin  \"Whether to look up IP numbers using a domain nameserver (DNS), to try to compute their hostnames\"\n", 
"OPTION_LONG_DESCRIPTION_luin\n", "\"When this is true (checked), {PRODUCT_NAME} attempts to look up the full domain name\n", 
"of hosts which appear in the log as IP numbers (%22reverse DNS lookup%22),\n", "using the DNS server specified by the [ds] option (which must be specified if this is true).\n", 
"The lookup is performed as the log data is read, so if you change this option, you will \n", "need to rebuild the database to see the effects.\n", 
"Looking up the IP numbers provides a more human-readable format for the IP hosts,\n", "but requires a network access as frequently as once per line, \n", 
"so it can take much longer than leaving them as IP numbers.\n", "There are several ways to improve the performance of DNS lookup. \n", 
"The most important is to make sure {PRODUCT_NAME} has a fast network connection to your \n", "DNS server; you can usually do this by running {PRODUCT_NAME} on your web server \n", 
"(as a CGI program, if necessary), rather than on your desktop system. \n", "It may also be faster to configure the web server to perform the domain name lookups,\n", 
"rather than having {PRODUCT_NAME} do it.  See also [nluin] and [luinbf].\"\n", "\n", "# dns_server option info\n", 
"OPTION_LABEL_ds                \"DNS Server\"\n", "OPTION_SHORT_DESCRIPTION_ds    \"The hostname or IP address of the DNS server to use to look up IP addresses in the log data\"\n", 
"OPTION_LONG_DESCRIPTION_ds\n", "\"This specifies the DNS server to use when looking up \n", "IP addresses in the log data (when [luin] is true). \n", 
"This can be either a hostname or an IP address of the DNS server.\n", "If this option is empty, and {PRODUCT_NAME} is running on a UNIX-type operating system,\n", 
"it will use the system's default primary DNS server.\n", "On all other platforms (including Windows and MacOS 9), this option must be set when [luin] is true.\"\n", 
"\n", "# secondary_dns_server option info\n", "OPTION_LABEL_sds                \"Secondary DNS Server\"\n", 
"OPTION_SHORT_DESCRIPTION_sds    \"The hostname or IP address of the DNS server to use to look up IP addresses in the log data, if the primary DNS server fails\"\n", 
"OPTION_LONG_DESCRIPTION_sds\n", "\"This specifies a DNS server to use when looking up \n", "IP addresses in the log data (when [luin] is true). \n", 
"This can be either a hostname or an IP address of the DNS server.\n", "If this option is empty, and {PRODUCT_NAME} is running on a UNIX-type operating system,\n", 
"it will use the system's default secondary DNS server.\n", "On all other platforms (including Windows and MacOS 9), this option must be set when [luin] is true.\n", 
"This is used only if the primary DNS server ([ds]) does not respond.\"\n", "\n", "# use_tcp_for_dns info\n", 
"OPTION_LABEL_utfd                \"Use TCP to communicate with DNS servers\"\n", "OPTION_SHORT_DESCRIPTION_utfd    \"True if {PRODUCT_NAME} should use TCP (rather than the more standard UDP) to communicate with DNS servers\"\n", 
"OPTION_LONG_DESCRIPTION_utfd\n", "\"This specifies whether {PRODUCT_NAME} should use the TCP protocol when \n", 
"communicating with DNS servers.  DNS servers more commonly communicate using UDP, \n", "and UDP is generally faster,\n", 
"but in some cases it may be preferably to use TCP instead (for instance, if your \n", "DNS server is accessible only by TCP due to its configuration or network location).\"\n", 
"\n", "# maximum_simultaneous_dns_lookups option info\n", "OPTION_LABEL_msdl                \"Maximum Simultaneous DNS Lookups\"\n", 
"OPTION_SHORT_DESCRIPTION_msdl    \"The maximum number of IP addresses that {PRODUCT_NAME} will attempt to lookup at the same time\"\n", 
"OPTION_LONG_DESCRIPTION_msdl\n", "\"This specifies the maximum number of IP addresses that \n", "will be looked up simultaneously.  Setting this to a high value \n", 
"may increase DNS lookup performance, but if you set it too high, \n", "your may exceed operating system limitations, and the log processing \n", 
"may fail.\"\n", "\n", "# dns_timeout option info\n", "OPTION_LABEL_dt              \"DNS timeout (seconds)\"\n", 
"OPTION_SHORT_DESCRIPTION_dt  \"Amount of time to wait for DNS response before timing out\"\n", "OPTION_LONG_DESCRIPTION_dt\n", 
"\"This option controls the amount of time {PRODUCT_NAME} waits for a response \n", "from a DNS (domain nameserver) when attempting to look up an IP number (see [luin]) \n", 
"during log processing.  The value is in seconds; so a value of 30 means that \n", "{PRODUCT_NAME} will give up after waiting 30 seconds for a response. \n", 
"Setting this to a low value may speed up your log processing, \n", "but fewer of your IP numbers will be resolved successfully.\"\n", 
"\n", "# look_up_ip_numbers_before_filtering option info\n", "OPTION_LABEL_luinbf              \"Look up IP numbers before filtering\"\n", 
"OPTION_SHORT_DESCRIPTION_luinbf  \"Whether to look up IP numbers before filtering (rather than after).\"\n", 
"OPTION_LONG_DESCRIPTION_luinbf\n", "\"\n", "NOTE: As of {PRODUCT_NAME} 6.1 (which is when we added our fast asynchronous DNS lookup algorithm), \n", 
"this option has no effect.  In a later version, we may add it back.  Here's what it <i>used</i> to do:<p>\n", 
"When this is true (checked), {PRODUCT_NAME} performs IP number lookup (reverse DNS)\n", "before running the filters (see [log_filter] and [luin]).\n", 
"When this is false (unchecked), {PRODUCT_NAME} performs IP number lookup\n", "after running the filters.\n", 
"Note that this does not determine <i>whether</i> {PRODUCT_NAME} performs DNS\n", "([look_up_ip_numbers] does that); it determines <i>when</i>.\n", 
"Setting this to true allows filtering based on hostnames, even when\n", "the hosts are in IP number format in the log data.\n", 
"Setting this to false saves time, by looking up only\n", "those IP numbers which correspond to entries which are accepted\n", 
"by the filters.\"\n", "\n", "# ip_numbers_cache_file option info\n", "OPTION_LABEL_incf              \"IP Numbers Cache File\"\n", 
"OPTION_SHORT_DESCRIPTION_incf  \"The file in which to cache IP numbers after they're looked up\"\n", 
"OPTION_LONG_DESCRIPTION_incf\n", "\"This specifies a file where {PRODUCT_NAME} should\n", "store a database of IP numbers it has looked up in the past\n", 
"(see [look_up_ip_numbers]).  When {PRODUCT_NAME} looks up an IP number,\n", "it will look in this cache first, to see if it has already found the\n", 
"hostname for that IP number (or if it has already determined that the\n", "hostname cannot be found).  If it finds the IP number in the cache\n", 
"stored in this file, it will use that hostname, rather than performing\n", "the reverse DNS lookup again.  This can greatly improve the speed of\n", 
"converting IP numbers to hostnames, especially when the same log is\n", "analyzed again.<p>\n", "This option can be either a full pathname of a file, in which case that file\n", 
"will be used, or a single filename, in which case the file\n", "will be created inside the LogAnalysisInfo {DIRECTORY_WORD}.\"\n", 
"\n", "# smtp_server_hostname option info\n", "OPTION_LABEL_ssh              \"SMTP Server Hostname\"\n", 
"OPTION_SHORT_DESCRIPTION_ssh  \"The hostname of an SMTP (sendmail) server {PRODUCT_NAME} should use when sending email\"\n", 
"OPTION_LONG_DESCRIPTION_ssh\n", "\"This specifies the hostname of an SMTP server {PRODUCT_NAME} should use \n", 
"when sending email.  This can either be just the hostname, in which case \n", "the default SMTP port of 25 is used, or it can be %22<i>hostname</i>:<i>port</i>%22 \n", 
"(i.e. the hostname, followed by a colon, followed by the port number), \n", "in which case <i>hostname</i> is used as the SMTP hostname, and <i>port</i> is used\n", 
"as the SMTP port.\"\n", "\n", "# return_address option info\n", "OPTION_LABEL_ra              \"Return email address\"\n", 
"OPTION_SHORT_DESCRIPTION_ra  \"The return email address that {PRODUCT_NAME} should use when sending email\"\n", 
"OPTION_LONG_DESCRIPTION_ra\n", "\"This specifies the return address {PRODUCT_NAME} should specify when\n", 
"sending email.  Unless a valid address is specified here, \n", "replies to {PRODUCT_NAME}'s automatically generated emails will bounce.  See also [ssh].\"\n", 
"\n", "# actions_email_address option info\n", "OPTION_LABEL_aea              \"Actions email address(es)\"\n", 
"OPTION_SHORT_DESCRIPTION_aea  \"The address(es) that {PRODUCT_NAME} should send email to whenever an action completes (e.g. the database is built)\"\n", 
"OPTION_LONG_DESCRIPTION_aea\n", "\"This specifies the address or addresses {PRODUCT_NAME} should send email to \n", 
"whenever an action occurs, for instance when the database finishes rebuilding, updating, expiring,\n", 
"or when HTML files are done being generated. \n", "If this option is non-empty, {PRODUCT_NAME} will send a brief description \n", 
"of what it just finished doing, using the SMTP server specified by [ssh]. \n", "Multiple recipients may be specified with commas, e.g. %22user1@mydomain.com,user2@mydomain.com,user3@mydomain.com%22.\n", 
"If this option is empty, {PRODUCT_NAME} will not send email.\"\n", "\n", "# view_email_address option info\n", 
"OPTION_LABEL_vea              \"View email address(es)\"\n", "OPTION_SHORT_DESCRIPTION_vea  \"The address(es) that {PRODUCT_NAME} should send statistics views to\"\n", 
"OPTION_LONG_DESCRIPTION_vea\n", "\"This specifies the address(es) {PRODUCT_NAME} should send email statistics views to, \n", 
"when the Email Statistics View button is clicked, or the Scheduler sends a statistics view, \n", "or when a statistics view is sent using the command line. \n", 
"Multiple recipients may be specified with commas, e.g. %22user1@mydomain.com,user2@mydomain.com,user3@mydomain.com%22.\n", 
"One view of the statistics will be emailed, with HTML formatting and embedded images, \n", "to the specified address.\"\n", 
"\n", "# view_to_send_by_email option info\n", "OPTION_LABEL_vtsbe              \"View to send by email\"\n", 
"OPTION_SHORT_DESCRIPTION_vtsbe  \"The name of the view that {PRODUCT_NAME} should send by email\"\n", 
"OPTION_LONG_DESCRIPTION_vtsbe\n", "\"This specifies the name of the view {PRODUCT_NAME} should send \n", 
"when it sends a view by email.  See [vea].\"\n", "\n", "# view_email_subject option info\n", "OPTION_LABEL_ves              \"View email subject\"\n", 
"OPTION_SHORT_DESCRIPTION_ves  \"The subject of the view email that is sent\"\n", "OPTION_LONG_DESCRIPTION_ves\n", 
"\"This specifies the subject of the view email (see [vea]). \n", "This can contain {QUOTE:{CONFIG_NAME}} or {QUOTE:{VIEW_TO_SEND_BY_EMAIL}}, \n", 
"which will be replaced by the name of the configuration, and the name of \n", "the view, respectively.  Other language module variables and configuration options can also be used.\"\n", 
"\n", "# running_statistics_url option info\n", "OPTION_LABEL_rsu              \"Running {PRODUCT_NAME} URL\"\n", 
"OPTION_SHORT_DESCRIPTION_rsu  \"The URL of a running version of {PRODUCT_NAME}, used to insert live links into HTML email\"\n", 
"OPTION_LONG_DESCRIPTION_rsu\n", "\"This specifies the URL of a running copy of {PRODUCT_NAME}. \n", 
"The URL may be something like http://www.flowerfire.com:8987/ \n", "if {PRODUCT_NAME} is running in web server mode, or it may be \n", 
"http://www.domainname.com/cgi-bin/{PRODUCT_EXECUTABLE_DOCS} if {PRODUCT_NAME} is \n", "running in CGI mode.  The URL is used to embed %22live%22 links \n", 
"in HTML email; for instance, it allows your HTML email to include tables\n", "of items which, when clicked, open a web browser and display more information \n", 
"on that item (as they would if the table were in a normal live {PRODUCT_NAME} report). \n", "If this option is empty, links will not appear in HTML email.\n", 
"See also [vea].\"\n", "\n", "# logout_url option info\n", "OPTION_LABEL_lu              \"Logout URL\"\n", 
"OPTION_SHORT_DESCRIPTION_lu  \"The URL to go to on logout; if empty, goes to login screen\"\n", "OPTION_LONG_DESCRIPTION_lu\n", 
"\"This specifies the URL that {PRODUCT_NAME} sends you to when \n", "you log out of {PRODUCT_NAME}.  If this option is blank, \n", 
"it will send you to the {PRODUCT_NAME} login screen.\"\n", "\n", "##\n", "## OUTPUT OPTIONS CATEGORY\n", 
"##\n", "\n", "# temporary_files_lifespan option info\n", "OPTION_LABEL_tfl              \"Temporary files lifespan (seconds)\"\n", 
"OPTION_SHORT_DESCRIPTION_tfl   \"Amount of time to keep temporary files before deleting them (in seconds)\"\n", 
"OPTION_LONG_DESCRIPTION_tfl\n", "\"This option controls the amount of time, in seconds, {PRODUCT_NAME} keeps temporary files before \n", 
"deleting them.  Temporary files include temporary configurations (used to browse \n", "statistics) and temporary images (used to embed images in statistics pages). \n", 
"Setting this to a high number will ensure that temporary images are around as long \n", "as they are needed, but will use more disk space.\"\n", 
"\n", "# read_from_config_file option info\n", "OPTION_LABEL_rfcf              \"Configuration to read\"\n", 
"OPTION_SHORT_DESCRIPTION_rfcf  \"A configuration to read before doing anything else\"\n", "OPTION_LONG_DESCRIPTION_rfcf\n", 
"\"This specifies a configuration file which is read in before anything else occurs.\n", "Specifically, this is read before the\n", 
"CGI form values (if running from a web browser)\n", "or command line options (if running from the command line) are added to the current configuration.\n", 
"From the command line, this can be used to read any configuration file,\n", "including those created from the CGI interface.  This can be used in\n", 
"conjunction with [cm] and other options to build or update or expire databases\n", "from the command line, or to generate HTML files.\n", 
"In CGI or web server mode, this is used internally to manage configurations, and should\n", "generally not be changed.<p>\n", 
"If this option is a full pathname of an existing file, that file is read as a configuration file;\n", 
"otherwise, {PRODUCT_NAME} treats it as the name of a file in the Configs sub{DIRECTORY_WORD} \n", "of the LogAnalysisInfo {DIRECTORY_WORD}.  If that doesn't exist either, {PRODUCT_NAME} tries \n", 
"treating it as the name of a file in the Bookmarks sub{DIRECTORY_WORD} \n", "of the LogAnalysisInfo {DIRECTORY_WORD}.  If that also doesn't exist, {PRODUCT_NAME} generates an error.<p>\n", 
"See [write_to_config_file] and [docs-configfiles].\"\n", "\n", "# write_to_config_file option info\n", 
"OPTION_LABEL_wtcf              \"Configuration name\"\n", "OPTION_SHORT_DESCRIPTION_wtcf  \"A configuration to write to after everything else occurs\"\n", 
"OPTION_LONG_DESCRIPTION_wtcf\n", "\"This specifies a configuration file which is written after everything else occurs.\n", 
"Specifically, this is written after the internal configuration has been updated by\n", "CGI form values (if running from a web browser)\n", 
"or command line options (if running from the command line).\n", "In or web server mode, this is used internally to manage configurations, and should\n", 
"generally not be changed.  See [read_from_config_file] and [docs-configfiles].\"\n", "\n", "# config_name option info\n", 
"OPTION_LABEL_cn              \"Configuration name\"\n", "OPTION_SHORT_DESCRIPTION_cn  \"The name of the current configuration\"\n", 
"OPTION_LONG_DESCRIPTION_cn\n", "\"This is the name of the current configuration.\n", "This name will also be used as the filename of the configuration file, \n", 
"so you cannot use directory dividers in the name (e.g. \\ on Windows, / on UNIX, : on MacOS 9). \n", 
"You also cannot use quotes (%22) or square brackets ({QUOTE:[ or ]})\n", "in the name.  All other characters are allowed, including spaces.\n", 
"On MacOS 9, the length is limited to 25 characters; on other platforms, \n", "the limit is much higher (100+ characters). \n", 
"If you rename a configuration file, you should change this option to match the new name of the file.\"\n", 
"\n", "# help_on option info\n", "OPTION_LABEL_ho              \"Show help on one options\"\n", "OPTION_SHORT_DESCRIPTION_ho  \"Show information on a specific configuration command\"\n", 
"OPTION_LONG_DESCRIPTION_ho\n", "\"This prints information on a single configuration command.  This\n", 
"is used by the CGI interface to implement the online documentation.\n", "It should not generally be changed manually.\"\n", 
"\n", "# use_progress_bar option info\n", "OPTION_LABEL_upb              \"Show progress indicator during long operations\"\n", 
"OPTION_SHORT_DESCRIPTION_upb  \"True if a progress indicator should be used to show progress\"\n", 
"OPTION_LONG_DESCRIPTION_upb\n", "\"This controls whether a progress indicator will appear during long operations (like reading a large log file).\n", 
"When this is checked (true), {PRODUCT_NAME} will show a progress indicator during the operation.\n", 
"When possible, {PRODUCT_NAME} uses a META reload tag (%22client pull%22) in its HTML to implement progress; this \n", 
"is possible in multithreaded web server or ACGI mode.  If it can't use client pull,\n", "it uses server push if possible to push the progress pages; however, this works only \n", 
"with Netscape.  With other browsers such as Internet Explorer, in CGI or single-threaded \n", "web server mode, {PRODUCT_NAME} stacks tiny progress messages at the top of the page being generated \n", 
"to provide progress, and (more importantly) to prevent the web browser from timing out.\n", "When this is not checked (false), the progress indicator will not appear.\n", 
"Be careful turning this off--your browser may time out on long operations if you do.\n", "A better option usually is to set [ppi] to a high value like 100.<p>\n", 
"When {PRODUCT_NAME} is used from the command line, this option causes it to show a \n", "single-line text progress indicator.  There isn't enough room on a single 80-character \n", 
"line to show all the information that's shown on a graphical progress page, but {PRODUCT_NAME} \n", 
"shows the most important parts:<p>\n", "\n", "<pre>G{QUOTE:[##########          ]}47% 643779e E00:20:42 R00:20:01 25M/1976k</pre>\n", 
"The first character (G in this case) is the first letter of the full description of the \n", "current operation, as it would appear in the graphical view.  For instance, in this case\n", 
"the G stands for %22Getting data by FTP.%22  Other common operations are \n", "%22(R)eading data%22 (from a local file or command), %22(P)reparing to consolidate,%22\n", 
"and %22(C)onsolidating database.%22<p>\n", "The section in brackets is a progress meter, which gradually fills as the task progresses,\n", 
"and is completely full at the end.  The percentage after it is the percentage of \n", "to task that is now complete.  If {PRODUCT_NAME} cannot determine the length of the task \n", 
"(for instance, if it's processing gzipped log data, or bzipped log data, or log data from a command), \n", 
"then it will not show anything in the bar area, and it will show ??% as the percentage.<p>\n", "The next section (643779e above) is the number of log entries that {PRODUCT_NAME} has processed.<p>\n", 
"The next section (E00:20:42 above) is the time elapsed since processing began, \n", "in hours:minutes:seconds format.  That is followed by the estimated time remaining, (R00:20:01 above), \n", 
"in the same format.  If {PRODUCT_NAME} cannot determine the length of the task, the time remaining will \n", 
"be R??:??:??.<p>\n", "The last two numbers (25M/1976k above) are the memory used by the database buffers (25M in this case), \n", 
"and the disk space used by the database buffers (1976k in this case).  Usually, the memory \n", "buffers will grow until they fill up (see [dwbs]), and then they will be written to disk, \n", 
"increasing the disk usage.  In the Consolidation stage, all memory buffers will be written to disk, \n", 
"and all disk buffers consolidated into the final database, so the memory usage will drop until it reaches \n", 
"0, at the end.  Note that this is just the memory used by this database; {PRODUCT_NAME} itself will be using additional \n", 
"memory for other purposes, so the total {PRODUCT_NAME} memory usage will be higher than this number.<p>\n", 
"\"\n", "\n", "# show_advanced_progress_info option info\n", "OPTION_LABEL_sapi              \"Show advanced progress information\"\n", 
"OPTION_SHORT_DESCRIPTION_sapi  \"True if the progress display should contain advanced information\"\n", 
"OPTION_LONG_DESCRIPTION_sapi\n", "\"This controls whether the progress display (see [use_progress_bar]) should contain advanced \n", 
"statistical information like lines processed, processing speed, and memory usage. \n", "When this option is checked (true), the progress display contains a complex \n", 
"list of statistical data about the progress of the configuration. \n", "When this option is unchecked (false), the progress display is very simple, \n", 
"containing only a brief description of the progress and a progress bar.\"\n", "\n", "# progress_page_interval option info\n", 
"OPTION_LABEL_ppi              \"Number of seconds between progress pages\"\n", "OPTION_SHORT_DESCRIPTION_ppi  \"The number of seconds between progress pages\"\n", 
"OPTION_LONG_DESCRIPTION_ppi\n", "\"This controls the number of seconds which elapse between the progress pages \n", 
"which appear when [use_progress_bar] is checked (true).  Setting this to a low \n", "value (like 3) provides fairly continuous progress feedback, but \n", 
"in when using server push progress mode (see [upb]), \n", "versions of Netscape Navigator earlier than version 4.5 may <i>crash</i> after \n", 
"receiving about 50 update pages (sometimes less).  \n", "This will not occur if you are using a multithreaded version of {PRODUCT_NAME} in web server \n", 
"mode, or if you are using the MacOS version; in these cases, {PRODUCT_NAME} uses a different \n", "mechanism to send update pages, which eliminates cause the problem. \n", 
"The problem occurs with single-threaded versions of {PRODUCT_NAME}, or with \n", "UNIX/Windows CGI mode.  Even with these versions, upgrading to Netscape 4.5 or later \n", 
"eliminates the problem.  {PRODUCT_NAME} will add a warning to progress pages when you are \n", "vulnerable.  Increasing the value of this option will decrease the number of progress \n", 
"pages, reducing the chance of a crash and speeding up processing a bit.\"\n", "\n", "# verbose option info\n", 
"OPTION_LABEL_v              \"Command-line output types\"\n", "OPTION_SHORT_DESCRIPTION_v  \"The types of command-line output to generate\"\n", 
"OPTION_LONG_DESCRIPTION_v\n", "\"This controls the types of debugging output generated during a run.\n", 
"This option is a sequence of letters, each representing a particular \n", "type of command-line output.  If the letter corresponding to a type is \n", 
"present in the sequence, that type of output will be generated; if it \n", "is not present, that type of output will not be generated.  The types, \n", 
"and their correspinding letters, are:<p>\n", "<ul>\n", "  <li><b>e</b>: Error message output.<br>\n", 
"  <li><b>l</b>: {PRODUCT_NAME} logo (banner) output.<br>\n", "  <li><b>b</b>: Built-in web server basic output.<br>\n", 
"  <li><b>w</b>: Built-in web server debugging output.<br>\n", "  <li><b>f</b>: Filter debugging output.<br>\n", 
"  <li><b>p</b>: Log parsing debugging output.<br>\n", "  <li><b>i</b>: Database I/O debugging output.<br>\n", 
"  <li><b>d</b>: Database access debugging output.<br>\n", "  <li><b>D</b>: Detailed database access debugging output.<br>\n", 
"  <li><b>s</b>: Statistics generation debugging output.<br>\n", "  <li><b>l</b>: Log reading debugging output.<br>\n", 
"  <li><b>a</b>: Administrative debugging output.<br>\n", "  <li><b>m</b>: Language module debugging output.<br>\n", 
"  <li><b>n</b>: DNS debugging output.<br>\n", "  <li><b>N</b>: Detailed DNS debugging output.<br>\n", 
"  <li><b>t</b>: Network debugging output.<br>\n", "  <li><b>o</b>: Add a timestamp to every output line.<br>\n", 
"</ul><p>\n", "For instance, a value of <b><code>eW</code></b> will \n", "show only error messages and basic web server output.\n", 
"A value of <b><code>elbwfpidDslamnNto</code></b> will show \n", "All possible output.<p>\n", "In CGI mode, the output will be sent\n", 
"to a file in the Output {DIRECTORY_WORD} of the LogAnalysisInfo {DIRECTORY_WORD};\n", "the file will be named Output-configname, where configname is the name of\n", 
"the configuration.\n", "In command line mode (on UNIX and Windows), the output will be sent to\n", 
"the standard output stream.  Under MacOS and the Win32 GUI,\n", "the output will always be sent to the file in Output.\"\n", 
"\n", "# all_output_to_master_config option info\n", "OPTION_LABEL_aotmc              \"Send all debugging output through master configuration\"\n", 
"OPTION_SHORT_DESCRIPTION_aotmc  \"Whether to send all debugging output through the master configuration\"\n", 
"OPTION_LONG_DESCRIPTION_aotmc\n", "\"This controls whether all debugging output (see [v]) should be \n", 
"output as though it originated from the %22master%22 configuration. \n", "The master configuration is the one which runs all the time in web server \n", 
"or ACGI mode.  When this option is true (checked), output from \n", "other configurations (for instance, from database builds initiated from \n", 
"the Main Menu) will be generated as though it originated from the master; \n", "this is useful because it is possible to set the verbose level on the command \n", 
"line (or in the startup configuration), and see the output of non-master configurations \n", "on the console.  When this option is false (unchecked), each non-master configuration \n", 
"generates its own output, which is sent to a file in the Output sub{DIRECTORY_WORD} of the \n", "LogAnalysisInfo {DIRECTORY_WORD}.<p>\"\n", 
"\n", "# generate_html_to_directory option info\n", "OPTION_LABEL_ghtd              \"Generate HTML statistics files to {DIRECTORY_WORD}\"\n", 
"OPTION_SHORT_DESCRIPTION_ghtd  \"Generate HTML statistics pages into a {DIRECTORY_WORD}\"\n", "OPTION_LONG_DESCRIPTION_ghtd\n", 
"\"This option lets you generate HTML statistics pages off-line \n", "(from the command line).  When [cm] is <b>generate_html_files</b> \n", 
"{PRODUCT_NAME} generates statistics pages into this {DIRECTORY_WORD}.  The \n", "statistics pages generated are interlinked, and can be browsed \n", 
"using any web browser without having to run {PRODUCT_NAME}.  See [docs-adminmenu].\"\n", "\n", "# generate_html_click_depth option info\n", 
"OPTION_LABEL_ghcd              \"Obsolete option\"\n", "OPTION_SHORT_DESCRIPTION_ghcd  \"Obsolete option\"\n", 
"OPTION_LONG_DESCRIPTION_ghcd\n", "\"This option is obsolete, and should not be used.\"\n", "\n", "# page_hits_link_cutoff option info\n", 
"OPTION_LABEL_phlc              \"Minimum page views on a page to link\"\n", "OPTION_SHORT_DESCRIPTION_phlc  \"Minimum number of page views on a page, below which links will be omitted\"\n", 
"OPTION_LONG_DESCRIPTION_phlc\n", "\"This option controls how many page views a statistics page must have in order \n", 
"for links to that page to be generated.  If a statistics page has this number of page views or more, \n", 
"links to that page will appear and will be clickable.  If a page \n", "has fewer than this number of page views on it, links will be omitted \n", 
"and link icons will not appear.  This option is useful when using \n", "the Generate HTML Files button (when the value of [cm]\n", 
"is <b>generate_html_files</b>)--it can greatly reduce the number of HTML \n", "files generated, and in a way where most of the information discarded is \n", 
"unimportant.\"\n", "\n", "# show_configuration_status option info\n", "OPTION_LABEL_scs              \"Show configuration status\"\n", 
"OPTION_SHORT_DESCRIPTION_scs  \"Show the status of a particular configuration\"\n", "OPTION_LONG_DESCRIPTION_scs\n", 
"\"This shows the status of a memory-resident configuration.\n", "This is used internally by the CGI interface.\"\n", 
"\n", "\n", "##\n", "## SERVER SIDE INCLUDE OPTIONS CATEGORY\n", "##\n", "\n", "# server_side_include_mode option info\n", 
"OPTION_LABEL_ssim              \"Server side include mode\"\n", "OPTION_SHORT_DESCRIPTION_ssim  \"True if {PRODUCT_NAME} is running as a server side include CGI, to write a log entry\"\n", 
"OPTION_LONG_DESCRIPTION_ssim\n", "\"This specifies whether {PRODUCT_NAME} is running in Server Side Include (SSI) mode.\n", 
"When this is true, {PRODUCT_NAME} will run only very briefly, just long enough to\n", "examine the CGI environment and write a log entry to the file specified by\n", 
"[ltwp], registering a hit on the page specified by [wlefp].  The log entry is\n", "written in Apache Extended format (see [lff]).  By inserting appropriate server-side include code\n", 
"into an HTML document, you can use this mode to generate log files on a system\n", "where server logging is disabled or incomplete.\"\n", 
"\n", "# generate_image option info \n", "OPTION_LABEL_gi              \"Generate image\"\n", "OPTION_SHORT_DESCRIPTION_gi  \"True if {PRODUCT_NAME} should generate the date/time graph image, rather than a statistics page\"\n", 
"OPTION_LONG_DESCRIPTION_gi\n", "\"When this option is false, {PRODUCT_NAME} generates an HTML statistics page in \n", 
"CGI or web server mode.  When this option is true, {PRODUCT_NAME} generates only a \n", "date/time graph image.  This option is intended to be used in URL \n", 
"parameters for an IMG SRC tag, to generate a single image.\"\n", "\n", "# log_to_write_pathname option info\n", 
"OPTION_LABEL_ltwp              \"Pathname of log file to write\"\n", "OPTION_SHORT_DESCRIPTION_ltwp  \"The location of the log file to write an entry to\"\n", 
"OPTION_LONG_DESCRIPTION_ltwp\n", "\"This specifies the location of a log file to which {PRODUCT_NAME} should <i>write</i> a log\n", 
"entry.  This is useful when using {PRODUCT_NAME} in server side include (SSI) mode,\n", "where {PRODUCT_NAME} is run every time a page is accessed, to capture log data.  See [ssim].\"\n", 
"\n", "# write_log_entry_for_page option info\n", "OPTION_LABEL_wlefp              \"Write log entry for page\"\n", 
"OPTION_SHORT_DESCRIPTION_wlefp  \"The page to write a log entry for, in SSI mode\"\n", "OPTION_LONG_DESCRIPTION_wlefp\n", 
"\"This specifies the page to write a log entry for, when running in Server Side Include mode. \n", 
"See [ssim] for more information.\"\n", "\n", "\n", "##\n", "## STATISTICS VIEWS OPTIONS CATEGORY\n", 
"##\n", "\n", "# view_info option info\n", "OPTION_LABEL_vi             \"View Info\"\n", "OPTION_SHORT_DESCRIPTION_vi \"This option specified the views, subviews, and subview options.\"\n", 
"OPTION_LONG_DESCRIPTION_vi \n", "\"This option specifies the views, subviews, and subview options.\n", 
"Each view is a different page of the statistics; it shows up as a \n", "single item in the View sidebar, or the Views menu.\n", 
"Each subview is a different way of looking at the data; \n", "for instance, a subview can show the data broken down by page, or \n", 
"by day of the week.  Views may have any number of subviews, and subviews \n", "appear one above another in the statistics for that view.<p>\n", 
"\n", "Each view has a name and a set of filters.  The filters can be set to use the enclosing\n", "page's filters (selected by the user at browse time using the Filter Editor), or they can \n", 
"be specified for that view so they cannot be overridden by the user.  Click the (edit) \n", "link in the view editor to edit the filters.<p>\n", 
"\n", "Each subview has the following options:<p>\n", "<ol>\n", "<li><b>Name</b>:\n", "    The name of the subview.  If there is more than one subview for this view, this name \n", 
"    will appear in the statistics in a bar above the subview.<p>\n", "<li><b>{VIEW_OPTIONS_FILTERS}</b>:\n", 
"    The filters for this view.  The filters can be set to use the view's filter \n", "    (which can in turn be set to use the page's filter, so the user has full control over the filters \n", 
"    for this subview), or a specific filter set can be chosen for this subview, which the user cannot override.<p>\n", 
"<li><b>{VIEW_OPTIONS_TYPE}</b>: \n", "    This specifies the type of the subview.  There will be one option for each database field, \n", 
"    (e.g. %22Top pages and directories%22 for the page view), and a number of additional choices \n", 
"    which are computed indirectly from the data.  This determines what form the data will take; \n", 
"    for instance whether it will be a table with pie charts (and which database field it will show), \n", 
"    or a set of graphs, or something else.  The following view types are available (there may be others as well, \n", 
"    if there are unusual fields in the database):<p>\n", "    <ul> \n", "      <li><b>{VIEW_LABEL_FOR_FIELD_page}</b>.  This shows hits on pages and directories, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_hostname}</b>.  This shows hits from domains and machines, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_date/time}</b>.  This shows hits on years, months, and days, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_referrer}</b>.  This shows hits from referring domains and URLs, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_referrer description}</b>.  This shows hits from referring domains, in a table and/or pie charts, using domain descriptions.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_server response}</b>.  This shows hits by server response, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_search engine}</b>.  This shows hits by search engine, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_file type}</b>.  This shows the file type (e.g. GIF, JPEG) of the file hit.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_screen dimensions}</b>.  This shows the dimensions of a visitor's screen (width x height) in pixels.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_screen depth}</b>.  This shows the bit depth of a visitors screen.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_day of week}</b>.  This shows hits by day of the week, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_hour of day}</b>.  This shows hits by hour of the day, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_authenticated user}</b>.  This shows hits by authenticated user, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_domain description}</b>.  This shows hits by visitor domain, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_search phrase}</b>.  This shows hits by search engine search phrase, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_operating system}</b>.  This shows hits by operating system, in a table and/or pie charts.\n", 
"      <li><b>{VIEW_LABEL_FOR_FIELD_web browser}</b>.  This shows hits by web browser, in a table and/or pie charts.\n", 
"      <li><b>{SUBVIEW_TYPE_date_graph}</b>.  This shows hits by year, month, and day, using cumulative graphs, bar graphs, and equation graphs.\n", 
"      <li><b>{SUBVIEW_TYPE_days_of_week_computed}</b>.  This shows hits by day of week, using tables and pie charts.  It differs from the non-computed version in that it can be generated even if there isn't a %22day of the week%22 field in the database; all you need is a date/time field with day information in it.\n", 
"      <li><b>{SUBVIEW_TYPE_average_days_of_week}</b>.  This shows the average number of hits on each day of the week, using tables and pie charts.  It is similar to the %22{SUBVIEW_TYPE_days_of_week_computed}%22 view, except that it shows average rather than total numbers.\n", 
"      <li><b>{SUBVIEW_TYPE_hours_of_day_computed}</b>.  This shows hits by hours of the day, using tables and pie charts.  It differs from the non-computed version in that it can be generated even if there isn't an %22hour of the day%22 field in the database; all you need is a date/time field with hour information in it.\n", 
"      <li><b>{SUBVIEW_TYPE_average_hours_of_day}</b>.  This shows the average number of hits on each hour of the day, using tables and pie charts.  It is similar to the %22{SUBVIEW_TYPE_hours_of_day_computed}%22 view, except that it shows average rather than total numbers.\n", 
"      <li><b>{SUBVIEW_TYPE_search_terms_computed}</b>.  This shows the top search terms used to find the site from search engines.  It is computed by examining the search phrase field of the database.\n", 
"      <li><b>{SUBVIEW_TYPE_sessions_summary}</b>.  This shows a summary of the session information (number of sessions, average length, etc).\n", 
"      <li><b>{SUBVIEW_TYPE_entry_pages}</b>.  This shows the pages visitors entered the site at.\n", 
"      <li><b>{SUBVIEW_TYPE_exit_pages}</b>.  This shows the pages visitors exit the site from.\n", 
"      <li><b>{SUBVIEW_TYPE_session_paths}</b>.  This shows the paths (click-streams) visitors took as they went through the site.\n", 
"      <li><b>{SUBVIEW_TYPE_session_page_paths}</b>.  This shows the paths (click-streams) visitors took as they went through a particular page.\n", 
"      <li><b>{SUBVIEW_TYPE_time_per_page}</b>.  This shows the total amount of time each page was viewed by all visitors combined.\n", 
"      <li><b>{SUBVIEW_TYPE_sessions}</b>.  This shows all the sessions.\n", "      <li><b>{SUBVIEW_TYPE_overview}</b>.  This shows an overview of the traffic, including total hits, bandwidth, and more.\n", 
"      <li><b>{SUBVIEW_TYPE_calendar}</b>.  This shows a calendar containing links for each year, month, and day that had hits; clicking the link zooms in on that time period.\n", 
"    </ul><p>\n", "<li><b>{VIEW_OPTIONS_SORT_BY}</b>: \n", "    This controls how the data in the subview is sorted.  For instance, sorting by \n", 
"    bandwidth means that the items with the most bandwidth will go at the top of the table.<p>\n", 
"<li><b>{VIEW_OPTIONS_SHOW_HIDE}</b>: \n", "    This controls which elements are visible in the subview.  Elements in parentheses are \n", 
"    invisible; elements not in parentheses are visible.  Choosing an element from the menu \n", "    changes it from visible to invisible, or vice versa.  Different elements are available \n", 
"    in different types of subviews; for instance, table columns will only be available in \n", "    subviews which have tables.  The possible view elements are:<p>\n", 
"    <ul>\n", "      <li> <b>{VIEW_ELEMENTS_HitsColumn}</b>. A column showing hits in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_HitsPercentColumn}</b>. A column showing hits percentages in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_HitsPieChart}</b>. A pie chart showing hits.\n", "      <li> <b>{VIEW_ELEMENTS_HitsBarColumn}</b>. A bar showing hits in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_PageViewsColumn}</b>. A column showing page views in the table.\n", "      <li> <b>{VIEW_ELEMENTS_PageViewsPercentColumn}</b>. A column showing page views percentages in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_PageViewsPieChart}</b>. A pie chart showing page views.\n", "      <li> <b>{VIEW_ELEMENTS_PageViewsBarColumn}</b>. A bar showing page views in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_BytesColumn}</b>. A column showing bandwidth in the table.\n", "      <li> <b>{VIEW_ELEMENTS_BytesPercentColumn}</b>. A column showing bandwidth percentages in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_BytesPieChart}</b>. A pie chart showing bandwidth.\n", "      <li> <b>{VIEW_ELEMENTS_BytesBarColumn}</b>. A bar showing bandwidth in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_VisitorsColumn}</b>. A column showing visitors in the table.\n", "      <li> <b>{VIEW_ELEMENTS_VisitorsPercentColumn}</b>. A column showing visitors percentages in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_VisitorsPieChart}</b>. A pie chart showing visitors.\n", "      <li> <b>{VIEW_ELEMENTS_VisitorsBarColumn}</b>. A bar showing visitors in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_SessionsColumn}</b>. A column showing sessions in the table.\n", "      <li> <b>{VIEW_ELEMENTS_SessionsPercentColumn}</b>. A column showing sessions percentages in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_SessionsPieChart}</b>. A pie chart showing sessions.\n", "      <li> <b>{VIEW_ELEMENTS_SessionsBarColumn}</b>. A bar showing sessions in the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_RowNumbers}</b>. A column of line numbers at the left of the table.\n", 
"      <li> <b>{VIEW_ELEMENTS_FilterCheckboxes}</b>. A set of checkboxes down the left of the table, and menu at the bottom of the table, which provides an easy way to add one or more visible rows to the filters, and optionally switch to a different view; this is good for answering certain types of common questions, like %22Which pages were hit on these days?%22.\n", 
"      <li> <b>{VIEW_ELEMENTS_OnlyBottomLevelItems}</b>. A special element that changes the way the data is displayed.  When this is %22visible%22, it causes all the bottom-level items for the current view to be displayed in a single table and/or pie chart.  For instance, in the %22Top pages and directories%22 view, making this visible will cause all of the pages in the site to be displayed in a single table, regardless of what directories they are in.  in the %22Top hosts and domains%22 view, making this element visible will show a table of all hostnames, regardless of what domain they are in.\n", 
"      <li> <b>{VIEW_ELEMENTS_MoreFewerAllLinks}</b>. A set of links at the bottom of the table allowing you to increase or decrease the number of visible rows.\n", 
"      <li> <b>{VIEW_ELEMENTS_ParenthesizedItems}</b>. Any parenthesized items in tables or graphs.  When this is shows, all items appear in tables.  When this is hidden, items in parentheses are omitted from tables.  This is useful for omitting the large but generally useless parenthesized items that appear in some views, like %22(no referrer)%22, %22(no search terms)%22, %22(internal referrer)%22, and similar items.\n", 
"      <li> <b>{VIEW_ELEMENTS_RemainderRow}</b>. A row at the bottom of the table showing a summary of all the data that didn't fit in the available rows.\n", 
"      <li> <b>{VIEW_ELEMENTS_TotalsRow}</b>. A row at the bottom of the table showing the totals for each column.\n", 
"      <li> <b>{VIEW_ELEMENTS_AveragesRow}</b>. A row at the bottom of the table showing the averages for each column.\n", 
"      <li> <b>{VIEW_ELEMENTS_95thPercentileInfo}</b>. A line of text below the graphs showing the 95th percentile calculation for the bandwidth bar graph data (computed by sorting all the values in the bandwidth bar graph, discarding the top 5%, and using the maximum remaining value).  This also controls a red line in the bandwidth bar graph that marks the location of the 95th percentile bandwidth value.\n", 
"      <li> <b>{VIEW_ELEMENTS_HitsCumulativeGraph}</b>. A cumulative graph showing hits over time.\n", 
"      <li> <b>{VIEW_ELEMENTS_HitsBarGraph}</b>. A bar graph showing hits over time.\n", "      <li> <b>{VIEW_ELEMENTS_PageViewsCumulativeGraph}</b>. A cumulative graph showing page views over time.\n", 
"      <li> <b>{VIEW_ELEMENTS_PageViewsBarGraph}</b>. A bar graph showing page views over time.\n", 
"      <li> <b>{VIEW_ELEMENTS_BytesCumulativeGraph}</b>. A cumulative graph showing bandwidth over time.\n", 
"      <li> <b>{VIEW_ELEMENTS_BytesBarGraph}</b>. A bar graph showing bandwidth over time.\n", "      <li> <b>{VIEW_ELEMENTS_VisitorsCumulativeGraph}</b>. A cumulative graph showing visitors over time.\n", 
"      <li> <b>{VIEW_ELEMENTS_VisitorsBarGraph}</b>. A bar graph showing visitors over time.\n", "      <li> <b>{VIEW_ELEMENTS_HitsEquation}</b>. An equation fitted to the cumulative hits graph, overlaid on it as a dotted red line and displayed mathematically below the graphs.\n", 
"      <li> <b>{VIEW_ELEMENTS_TotalTimeColumn}</b>. A column in the table showing the total time.\n", 
"      <li> <b>{VIEW_ELEMENTS_AverageTimeColumn}</b>. A column in the table showing the average time.\n", 
"      <li> <b>{VIEW_ELEMENTS_StartTimeColumn}</b>. A column in the table showing the start time of a session.\n", 
"      <li> <b>{VIEW_ELEMENTS_DurationColumn}</b>. A column in the table showing the duration of a session.\n", 
"      <li> <b>{VIEW_ELEMENTS_EndTimeColumn}</b>. A column in the table showing the end time of a session.\n", 
"      <li> <b>{VIEW_ELEMENTS_VisitorIDColumn}</b>. A column in the table showing the visitor id for a session.\n", 
"      <li> <b>{VIEW_ELEMENTS_Weekdays}</b>. A day-of-the-week that appears in parentheses next to a date in date tables.\n", 
"      <li> <b>{VIEW_ELEMENTS_DomainDescriptions}</b>. An English description of the domain of a hostname or domain name, which appears in parentheses next to the host or domain name in hostname tables.\n", 
"      <li> <b>{VIEW_ELEMENTS_Instructions}</b>. A block of instruction above the table.\n", "      <li> <b>{VIEW_ELEMENTS_FieldLimits}</b>. A bar describing the current filters and including a link for editing them.\n", 
"      <li> <b>{VIEW_ELEMENTS_ViewSidebar}</b>. A sidebar containing links to all views; clicking a view from the menu goes to that view.\n", 
"      <li> <b>{VIEW_ELEMENTS_ViewMenu}</b>. A popup menu of all views, appearing at the top and bottom of statistics pages; choosing a view from the menu shows that view.\n", 
"      <li> <b>{VIEW_ELEMENTS_SortMenu}</b>. A menu containing all possible sort orders; choosing a different order changes the sorting of the tables and graphs.\n", 
"      <li> <b>{VIEW_ELEMENTS_ViewTitle}</b>. A bar at the top of the view, showing the name of the view.\n", 
"      <li> <b>{VIEW_ELEMENTS_ShowHideMenus}</b>. A menu which can be used to show or hide any view elements.\n", 
"      <li> <b>{VIEW_ELEMENTS_ShowHideScopeCheckbox}</b>. A checkbox beneath the Options menus which controls whether Options affects all views, or only the current view.\n", 
"      <li> <b>{VIEW_ELEMENTS_Hints}</b>. Purple questions mark icons that appear in various places in the statistics to provide the answers to frequently asked questions.\n", 
"      <li> <b>{VIEW_ELEMENTS_InfoBar}</b>. A bar of information at the bottom of the page.\n", "      <li> <b>{VIEW_ELEMENTS_AllOverviewData}</b>. The extra data in the overview view; showing this shows extra data may take a long time to compute.\n", 
"    </ul><p>\n", "<li><b>{VIEW_OPTIONS_MAX_ROWS}</b>:\n", "    This determines the maximum number of rows in a table for this subview when generating statistics online.<p>\n", 
"<li><b>{VIEW_OPTIONS_MAX_ROWS_OFFLINE}</b>:\n", "    This determines the maximum number of rows in a table for this subview for offline pages \n", 
"    (pages generated using %22Generate HTML Files%22.<p>\n", "<li><b>{VIEW_OPTIONS_MAX_DEPTH_OFFLINE}</b>:\n", 
"    This controls the number of pages which are generated in offline (Generate HTML Files) mode.\n", 
"    The top-level pages (no filters, all views) are always generated, and \n", "    are considered to be at click depth 0.  Each link on a depth 0 page \n", 
"    leads to a depth 1 page (unless it leads to another depth 0 page). \n", "    Each link on a depth 1 page leads to a depth 2 page, and so on. \n", 
"    Setting this value to 0 causes only the top-level pages to be generated; \n", "    links which would have led off the top-level pages will be disabled. \n", 
"    Setting this to 1 activates all links on the top-level pages, and generates \n", "    all level-1 pages.  Setting it to 2 generates all level-2 pages (so all links \n", 
"    on level-1 pages will be active).  In other words, a setting of <i>n</i> allows \n", "    you to start at a top-level page, and to click on <i>n</i> consecutive links \n", 
"    (any links), before the links start being disabled.  Setting this to a very high \n", "    value will generate all possible pages, but that may take an extraordinary amount \n", 
"    of time and disk space.\n", "</ol>\"\n", "\n", "# statistics_font option info\n", "OPTION_LABEL_sf             \"Statistics font\"\n", 
"OPTION_SHORT_DESCRIPTION_sf \"This describes a single font used in the statistics\"\n", "OPTION_LONG_DESCRIPTION_sf \n", 
"\"This option describes a single font used in the statistics.\n", "The first parameter is the name of the type of statistics text \n", 
"this font should be used for.  Possible names are:<p>\n", "<ul>\n", "  <li><b>{TEXT_TYPE_table_text}</b> (<code>table_text</code>): The item names in tables. \n", 
"  <li><b>{TEXT_TYPE_table_heading}</b> (<code>table_heading</code>): The headings in tables. \n", "  <li><b>{TEXT_TYPE_table_average}</b> (<code>table_average</code>): The averages rows in tables.\n", 
"  <li><b>{TEXT_TYPE_table_total}</b> (<code>table_total</code>): The totals row in tables.\n", "  <li><b>{TEXT_TYPE_instructions}</b> (<code>instructions</code>): The instructions text.\n", 
"  <li><b>{TEXT_TYPE_menu_label}</b> (<code>me u_labe </code>): The labels in front of popup menus.\n", 
"  <li><b>{TEXT_TYPE_menu_contents}</b> (<code>menu_contents</code>): The contents of popup menus.\n", 
"  <li><b>{TEXT_TYPE_pie_chart_label}</b> (<code>pie_chart_label</code>): The labels of pie charts.\n", 
"  <li><b>{TEXT_TYPE_filters_label}</b> (<code>filters_label</code>): The label of the filters section.\n", 
"  <li><b>{TEXT_TYPE_filters_text}</b> (<code>filters_text</code>): Text other text in the filters section.\n", 
"  <li><b>{TEXT_TYPE_subview_name}</b> (<code>subview_name</code>): The name of a subview.\n", "  <li><b>{TEXT_TYPE_row_number}</b> (<code>row_number</code>): The row numbers.\n", 
"  <li><b>{TEXT_TYPE_toolbar}</b> (<code>toolbar</code>): The toolbars.\n", "  <li><b>{TEXT_TYPE_infobar}</b> (<code>infobar</code>): The information bar (copyright, etc.).\n", 
"  <li><b>{TEXT_TYPE_label}</b> (<code>label</code>): Generic labels.\n", "  <li><b>{TEXT_TYPE_value}</b> (<code>value</code>): Generic values.\n", 
"  <li><b>{TEXT_TYPE_text}</b> (<code>text</code>): Generic text. \n", "  <li><b>{TEXT_TYPE_overview_text}</b> (<code>overview_text</code>): The text of the overview page.\n", 
"  <li><b>{TEXT_TYPE_overview_view_link}</b> (<code>overview_view_link</code>): The links in the overview page. \n", 
"  <li><b>{TEXT_TYPE_notes}</b> (<code>notes</code>): Notes on the statistics pages.\n", "  <li><b>{TEXT_TYPE_path_text}</b> (<code>path_text</code>): The text in path descriptions.\n", 
"  <li><b>{TEXT_TYPE_calendar_day}</b> (<code>calendar_day</code>): Days in the Calendar view.\n", "  <li><b>{TEXT_TYPE_calendar_month}</b> (<code>calendar_month</code>): Months in the Calendar view.\n", 
"  <li><b>{TEXT_TYPE_calendar_year}</b> (<code>calendar_year</code>): Years in the Calendar view.\n", 
"  <li><b>{TEXT_TYPE_title_bar}</b> (<code>title_bar</code>): The text in title bars.\n", "</ul><p>\n", 
"\"\n", "\n", "##\n", "## TABLE OPTIONS CATEGORY\n", "##\n", "\n", "# table_bar_height option info\n", 
"OPTION_LABEL_tbh              \"Table bar height\"\n", "OPTION_SHORT_DESCRIPTION_tbh  \"The height of a table graph bar\"\n", 
"OPTION_LONG_DESCRIPTION_tbh\n", "\"This controls the height in pixels of bars in a table graph.\"\n", 
"\n", "# max_table_item_length option info\n", "OPTION_LABEL_mtil              \"Maximum length of a single line of a table item\"\n", 
"OPTION_SHORT_DESCRIPTION_mtil  \"The maximum length, in characters, of one line of a table item\"\n", 
"OPTION_LONG_DESCRIPTION_mtil\n", "\"This controls the maximum length, in characters, of a text item in a table.\n", 
"Items longer than this length will be broken into multiple lines; see \n", "[mtir].\"\n", "\n", "# max_table_item_rows option info\n", 
"OPTION_LABEL_mtir              \"Maximum lines for a single table item\"\n", "OPTION_SHORT_DESCRIPTION_mtir  \"The maximum number of lines used by the text of a single table item\"\n", 
"OPTION_LONG_DESCRIPTION_mtir\n", "\"This controls the maximum number of lines of text that \n", "a single item in a table may use.  Items shorter than [mtil] will use a single line; \n", 
"items longer than that will be split into multiple lines, up to the value of this \n", "option.  Items which cannot fit in this number of lines will be truncated.\" \n", 
"\n", "# sample_time_units option info\n", "OPTION_LABEL_stu              \"Sample time units\"\n", 
"OPTION_SHORT_DESCRIPTION_stu  \"The number of consecutive time units to combine to make a single sample\"\n", 
"OPTION_LONG_DESCRIPTION_stu\n", "\"This controls the size of a sample for 95% calculations.\n", "The length of a sample is this number times the size of the smallest unit that is tracked \n", 
"by the date/time field of the database. \n", "For instance, if the date/time field is set to track information to the minute level \n", 
"(suppress bottom set to 5 for the date/time field), and this value is 5, then samples will be\n", "five minutes long.\"\n", 
"\n", "# expand_paths_greater_than option info\n", "OPTION_LABEL_epgt              \"Expand paths greater than this\"\n", 
"OPTION_SHORT_DESCRIPTION_epgt  \"The number of sessions though a path that causes the path to be expanded with %22expand all%22 or in offline (static) statistics\"\n", 
"OPTION_LONG_DESCRIPTION_epgt\n", "\"This is the number of sessions through a particular path that are\n", 
"required for that path to be expanded in the %22paths%22 view\n", "when %22expand all%22 is clicked in statistics, or in offline (%22Generate HTML Files%22) statistics.  The paths view will\n", 
"appear with all path segments (arrows) larger than this value expanded; all paths smaller than\n", 
"this value will be collapsed.  If you set this value too small, your paths page may be\n", "extremely large.\"\n", 
"\n", "# calendar_month_columns option info\n", "OPTION_LABEL_cmc              \"Calendar month columns\"\n", 
"OPTION_SHORT_DESCRIPTION_cmc  \"Number of months per row in a calendar\"\n", "OPTION_LONG_DESCRIPTION_cmc\n", 
"\"This controls the number of months per row in the calendar view.\n", "For instance, a setting of 12 will make each year 12 months wide (and one month tall). \n", 
"A setting of 4 will make each year four months wide and three months tall, etc.\"\n", "\n", "# first_day_of_week option info\n", 
"OPTION_LABEL_fdow              \"First day of week\"\n", "OPTION_SHORT_DESCRIPTION_fdow  \"The first day of the week (1=Sunday, 2=Monday, ...)\"\n", 
"OPTION_LONG_DESCRIPTION_fdow\n", "\"This controls the day of the week that is considered the first day of the week. \n", 
"The first day of the week will be the first column in calendar months \n", "and it will be the first row in weekday tables. \n", 
"Use 1 for Sunday, 2 for Monday, 3 for Tuesday, 4 for Wednesday, 5 for Thursday, 6 for Friday, and 7 for Saturday.\"\n", 
"\n", "# max_table_bar_length option info\n", "OPTION_LABEL_mtbl              \"Maximum length of table bar\"\n", 
"OPTION_SHORT_DESCRIPTION_mtbl  \"Maximum length of a table graph bar\"\n", "OPTION_LONG_DESCRIPTION_mtbl\n", 
"\"This controls the maximum length of a bar in a table graph.\n", "Bars in tables will be at most\n", 
"this number of pixels in length.\"\n", "\n", "# compact_tables option info\n", "OPTION_LABEL_ct              \"Make tables as compact as possible\"\n", 
"OPTION_SHORT_DESCRIPTION_ct  \"True if tables should be made as compact as possible\"\n", "OPTION_LONG_DESCRIPTION_ct\n", 
"\"This controls whether the statistics tables should be as compact as possible.\n", "When this is checked (true), statistics tables will be squeezed together as much\n", 
"as possible, saving screen space.  When it is not checked, they will be more\n", "spread out.\"\n", 
"\n", "# use_tables_for_table_bars option info\n", "OPTION_LABEL_utftb              \"Use HTML tables to generate table bars\"\n", 
"OPTION_SHORT_DESCRIPTION_utftb  \"True if table bars should be generated with HTML tables\"\n", "OPTION_LONG_DESCRIPTION_utftb\n", 
"\"This controls whether table bars are generated using HTML tables, \n", "or using GIF images.  When this is true (checked), table bars are \n", 
"generated using HTML tables, resulting in fast-loading table bars. \n", "When this is false (unchecked), table bars are generated using images, \n", 
"resulting in slower-loading bars.  GIF-based bars are much more customizable, \n", "using [table_bar_height], [bar_top_color], [bar_middle_color], [bar_bottom_color], \n", 
"[bar_unit_image], [left_bar_cap_image], [right_bar_cap_image]. \n", "HTML-table-based bars are less customizable, using [table_bar_height] and [html_table_bar_color].\"\n", 
"\n", "# stretch_bar_unit option info\n", "OPTION_LABEL_sbu             \"True if the bar unit image should be stretched to create the middle of the bar\"\n", 
"OPTION_SHORT_DESCRIPTION_sbu  \"Stretch bar unit image to form bar middle\"\n", "OPTION_LONG_DESCRIPTION_sbu\n", 
"\"This controls how the middle part of table bars is generated \n", "(the part between the caps). \n", 
"When this is true, the middle is generated by taking the bar \n", "unit image (see [bar_unit_image]) and stretching it horizontally using \n", 
"an HTML %22width=%22 tag.  When this is false, the middle is generated \n", "by constructing a series of unstretched bar pieces, and combining them \n", 
"to form the middle.  Stretching the image allows a single image to be used \n", "for all bar middles, significantly reducing the time to load a statistics page. \n", 
"However, stretching images is a violation of the HTML specification, and \n", "may not be supported by some web browsers.\"\n", 
"\n", "# hidden_views_url option info\n", "OPTION_LABEL_hvu              \"Hidden views URL\"\n", "OPTION_SHORT_DESCRIPTION_hvu  \"The URL to link view buttons to when the views are not visible\"\n", 
"OPTION_LONG_DESCRIPTION_hvu\n", "\"This controls the page that view buttons link to when the associated view is hidden. \n", 
"If this option is empty, the view button itself will also be hidden. \n", "Otherwise, this view button will be dimmed, and clicking the button will take you \n", 
"to the URL specified by this option.\"\n", "\n", "# generate_path_reference_icons option info\n", "OPTION_LABEL_gpri              \"Generate page reference icons\"\n", 
"OPTION_SHORT_DESCRIPTION_gpri  \"True if path table row items should include icons linking to pages referred to by that item\"\n", 
"OPTION_LONG_DESCRIPTION_gpri\n", "\"This controls whether page reference icons should appear in tables.\n", 
"Page reference icons are blue U-shaped arrows which appear to the right of the field icons\n", "in the xref icons column of page tables.  Each page reference icon links to a statistics page where the hit page\n", 
"is reinterpreted as a referrer, listing all pages which the reinterpreted\n", "page is a referrer for.  In other words, the statistics page shows all pages which\n", 
"were hit by users immediately after the page next to the icon.  These\n", "statistics pages can be considered a probability graph, showing the probability\n", 
"that a user would visit a particular page after a particular other page.<p>\n", "These icons can be generated only if the database contains both\n", 
"page and URL fields.<p>\n", "The page is reinterpreted as a URL by appending it\n", "to the value of [server_root], so that value must be defined, and internal referrers\n", 
"in the log data must begin with the value of [server_root].\n", "If the referrers are not of this form, it may be necessary to\n", 
"use filters to massage them into the proper format before these icons will appear.\"\n", "\n", "# bar_bottom_color option info\n", 
"OPTION_LABEL_bbc              \"Color of bottom of table graph bar\"\n", "OPTION_SHORT_DESCRIPTION_bbc  \"The color of the bottom of a horizontal table graph bar\"\n", 
"OPTION_LONG_DESCRIPTION_bbc\n", "\"This controls the color of the bottom edge of table graph bars.\n", 
"The color of a table graph bar will vary gradually from\n", "this color at the bottom to\n", "[bar_middle_color] at the middle to\n", 
"[bar_top_color] at the top.\n", "Note that [bar_unit_image] overrides this option.\n", "{COLOR_COMPONENTS_INFO}.\"\n", 
"\n", "# bar_middle_color option info\n", "OPTION_LABEL_bmc              \"Color of middle of table graph bar\"\n", 
"OPTION_SHORT_DESCRIPTION_bmc  \"The color of the middle of a horizontal table graph bar\"\n", "OPTION_LONG_DESCRIPTION_bmc\n", 
"\"This controls the color of the vertical middle of table graph bars.\n", "The color of a table graph bar will vary gradually from\n", 
"[bar_bottom_color] at the bottom to\n", "this color at the middle to\n", "[bar_top_color] at the top.\n", 
"Note that [bar_unit_image] overrides this option.\n", "{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# bar_top_color option info\n", 
"OPTION_LABEL_btc              \"Color of top of table graph bar\"\n", "OPTION_SHORT_DESCRIPTION_btc  \"The color of the top of a horizontal table graph bar\"\n", 
"OPTION_LONG_DESCRIPTION_btc\n", "\"This controls the color of the top edge of table graph bars.\n", 
"The color of a table graph bar will vary gradually from\n", "[bar_bottom_color] at the bottom to\n", 
"[bar_middle_color] at the middle to\n", "this color at the top.\n", "Note that [bar_unit_image] overrides this option.\n", 
"{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# statistics_page_background_color option info\n", "OPTION_LABEL_spbc              \"Background color of a statistics page\"\n", 
"OPTION_SHORT_DESCRIPTION_spbc  \"The color of the background of a statistics page\"\n", "OPTION_LONG_DESCRIPTION_spbc\n", 
"\"This controls the color of the background of statistics pages.\n", "{COLOR_COMPONENTS_INFO}.\"\n", 
"\n", "# view_sidebar_background_color option info\n", "OPTION_LABEL_vsbc              \"Background color of the view sidebar\"\n", 
"OPTION_SHORT_DESCRIPTION_vsbc  \"The color of the background of the view sidebar buttons on a statistics page\"\n", 
"OPTION_LONG_DESCRIPTION_vsbc\n", "\"This controls the color of the background of the View sidebar, \n", 
"the list of buttons that appears at the left of statistics pages.\n", "{COLOR_COMPONENTS_INFO}.\"\n", 
"\n", "# html_table_bar_color option info\n", "OPTION_LABEL_tbc              \"Color of hits information\"\n", 
"OPTION_SHORT_DESCRIPTION_tbc  \"The color of the information which represents hits\"\n", "OPTION_LONG_DESCRIPTION_tbc\n", 
"\"This controls the color which is used to represents hits.\n", "This color is used (lightened or darkened) to color \n", 
"the bars in the tables, and to shade the table cells. \n", "{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# page_views_table_bar_color option info\n", 
"OPTION_LABEL_pvtbc              \"Color of page views information\"\n", "OPTION_SHORT_DESCRIPTION_pvtbc  \"The color of the information which represents page views\"\n", 
"OPTION_LONG_DESCRIPTION_pvtbc\n", "\"This controls the color which is used to represents page views.\n", 
"This color is used (lightened or darkened) to color \n", "the bars in the tables, and to shade the table cells. \n", 
"{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# bandwidth_table_bar_color option info\n", "OPTION_LABEL_btbc              \"Color of bandwidth (bytes transferred) information\"\n", 
"OPTION_SHORT_DESCRIPTION_btbc  \"The color of the information which represents bandwidth\"\n", "OPTION_LONG_DESCRIPTION_btbc\n", 
"\"This controls the color which is used to represent bandwidth (bytes transferred).\n", "This color is used (lightened or darkened) to color \n", 
"the bars in the tables, and to shade the table cells. \n", "{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# visitors_table_bar_color option info\n", 
"OPTION_LABEL_vtbc              \"Color of visitors information\"\n", "OPTION_SHORT_DESCRIPTION_vtbc  \"The color of the information which represents visitors\"\n", 
"OPTION_LONG_DESCRIPTION_vtbc\n", "\"This controls the color which is used to represent visitors (unique hosts).\n", 
"This color is used (lightened or darkened) to color \n", "the bars in the tables, and to shade the table cells. \n", 
"{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# sessions_information option info\n", "OPTION_LABEL_sic              \"Color of sessions information\"\n", 
"OPTION_SHORT_DESCRIPTION_sic  \"The color of the information which represents sessions\"\n", "OPTION_LONG_DESCRIPTION_sic\n", 
"\"This controls the color which is used to represent sessions.\n", "This color is used (lightened or darkened) to color \n", 
"the bars in the tables, and to shade the table cells. \n", "{COLOR_COMPONENTS_INFO}.\"\n", "\n", "# bar_unit_image option info\n", 
"OPTION_LABEL_bui              \"GIF to tile to make bars\"\n", "OPTION_SHORT_DESCRIPTION_bui  \"The name of the image to use for horizontal table graph bars\"\n", 
"OPTION_LONG_DESCRIPTION_bui\n", "\"This is the name of a GIF file which will be tiled horizontally\n", 
"to generate table graph bars.  The file specified will be copied to the server {DIRECTORY_WORD},\n", 
"and the copy will be referred to from the generated\n", "HTML code.\"\n", "\n", "# right_bar_cap_image option info\n", 
"OPTION_LABEL_rbci              \"GIF to cap right of bars\"\n", "OPTION_SHORT_DESCRIPTION_rbci  \"The name of the image to put to the right of table graph bars\"\n", 
"OPTION_LONG_DESCRIPTION_rbci\n", "\"This specifies a GIF file which will be used to generate a\n", 
"%22cap%22 at the right end of each table graph bar.  The file\n", "specified here will be copied to the server {DIRECTORY_WORD},\n", 
"and the copy will be referred to by the generated HTML page.\"\n", "\n", "# left_bar_cap_image option info\n", 
"OPTION_LABEL_lbci              \"GIF to cap left of bar\"\n", "OPTION_SHORT_DESCRIPTION_lbci  \"The name of the image to put to the left of table graph bars\"\n", 
"OPTION_LONG_DESCRIPTION_lbci\n", "\"This specifies a GIF file which will be used to generate a\n", 
"%22cap%22 at the left end of each table graph bar.  The file\n", "specified here will be copied to the server {DIRECTORY_WORD},\n", 
"and the copy will be referred to by the generated HTML page.\"\n", "\n", "\n", "##\n", "## ANNOTATION OPTIONS CATEGORY\n", 
"##\n", "\n", "\n", "# active_category option info\n", "OPTION_LABEL_ac              \"Active Category\"\n", 
"OPTION_SHORT_DESCRIPTION_ac  \"This is an internal option used to specify which category is active\"\n", 
"OPTION_LONG_DESCRIPTION_ac\n", "\"This is an internal option used to specify which category is active; it should not be changed.\"\n", 
"\n", "# active_statistics_view option info\n", "OPTION_LABEL_asv              \"Statistics view\"\n", 
"OPTION_SHORT_DESCRIPTION_asv  \"This option specifies which statistics view is currently showing\"\n", 
"OPTION_LONG_DESCRIPTION_asv\n", "\"This option specifies which statistics view is currently shown in the statistics. \n", 
"It is used internally by {PRODUCT_NAME} as you move from view to view, but it can also be \n", "set in the configuration options interface to control which view {PRODUCT_NAME} shows when \n", 
"you first view the statistics.  \n", "Its value can be either the full name of the view, as it appears in \n", 
"the view menu, or an integer corresponding to the view index \n", "(1 for the first view in the menu, 2 for the second, etc.).\"\n", 
"\n", "# show_full_instructions option info\n", "OPTION_LABEL_sfi              \"Show Full Instructions\"\n", 
"OPTION_SHORT_DESCRIPTION_sfi  \"True if instructions should include a %22General Information%22 section\"\n", 
"OPTION_LONG_DESCRIPTION_sfi\n", "\"This controls whether the instructions on statistics pages include \n", 
"a %22General Information%22 section.  The General Information provides useful information \n", "for beginning users, but takes up a lot of screen space.\"\n", 
"\n", "# show_hide_menus_affect_all_views info\n", "OPTION_LABEL_shmaav              \"Options menu affects all views\"\n", 
"OPTION_SHORT_DESCRIPTION_shmaav  \"True if the Options menu in the statistics affects all the views, not just the current one\"\n", 
"OPTION_LONG_DESCRIPTION_shmaav\n", "\"This controls whether the Options menu in the statistics \n", 
"affect alls views, or just the current one.  \n", "When this option is checked (true), choosing an item from the Options menu \n", 
"in the statistics will show or hide that view element in <i>every</i> subview/view. \n", "When this option is unchecked (false), choosing an item will show or hide the element \n", 
"only in the current subview/view.\"\n", "\n", "# show_statistics_credit_in_information_banner option info\n", 
"OPTION_LABEL_ssciib              \"Show {PRODUCT_NAME} credit in information banner\"\n", "OPTION_SHORT_DESCRIPTION_ssciib  \"True if a brief statement crediting {PRODUCT_NAME} with the creation of the statistics should appear in the information banner\"\n", 
"OPTION_LONG_DESCRIPTION_ssciib\n", "\"This controls whether the information banner contains a credit for {PRODUCT_NAME}. \n", 
"When this option is checked (true), the information banner contains a brief statement \n", "that {PRODUCT_NAME} created the statistics.  When this option is unchecked (false), the statement is omitted.\" \n", 
"\n", "# interview_page option info\n", "OPTION_LABEL_ip              \"Interview Page\"\n", "OPTION_SHORT_DESCRIPTION_ip  \"Which HTML page of the interviews, if any, to show\"\n", 
"OPTION_LONG_DESCRIPTION_ip\n", "\"This option is used internally to sequence interviews; there is little reason to use it.\n", 
"When this is non-empty, it specifies which interview is being conducted.\n", "Interviews are the HTML page\n", 
"sequences which appear in CGI mode to prompt the user for configuration information.\n", "See [i].\"\n", 
"\n", "# interview option info\n", "OPTION_LABEL_i              \"Interview\"\n", "OPTION_SHORT_DESCRIPTION_i   \"Which interview, if any, is being conducted\"\n", 
"OPTION_LONG_DESCRIPTION_i\n", "\"This option is used internally to sequence interviews; there is little reason to use it.\n", 
"When this is non-empty, it causes a page of an interview to appear\n", "Interviews are the HTML page\n", 
"sequences which appear in CGI mode to prompt the user for configuration information.\n", "See [ip].\"\n", 
"\n", "\n", "##\n", "## MISCELLANEOUS OPTIONS CATEGORY\n", "##\n", "\n", "# configuration_mode option info\n", 
"OPTION_LABEL_cm              \"Configuration Mode\"\n", "OPTION_SHORT_DESCRIPTION_cm  \"The mode to run the configuration in\"\n", 
"OPTION_LONG_DESCRIPTION_cm\n", "\"This specifies the mode to run the current configuration in.\n", 
"The HTML interface takes care of setting this option for you as necessary, \n", "but you will need to set it manually when using the command line interface. \n", 
"Possible modes are: \n", "<ul>\n", "  <li><b>create_database</b> (or cd): This recreates the database from the log data, erasing any data already \n", 
"      in the database.<p>\n", "  <li><b>update_database</b> (or ud): This adds the log data to the database, while also leaving any existing data \n", 
"      in the database.<p>\n", "  <li><b>expire_database</b> (or ed): This expires all data from the database which\n", 
"      is older than the value specified [expire_database_data].<p>\n", "  <li><b>view_statistics</b> (or vs): This lets you browse the statistics \n", 
"      for the configuration, reading the statistics from the disk database if there is one, \n", "      or from the log data if there is not.  This mode is not useful from the command line, \n", 
"      but it is used by the HTML interface to display the online statistics.<p>\n", "  <li><b>generate_html_files</b> (or ghf): This generates HTML statistics pages, \n", 
"      and the associated images, into the {DIRECTORY_WORD} specified by [generate_html_to_directory]. \n", 
"      The files and images are linked properly, so the HTML can be browsed directly from \n", "      the resulting {DIRECTORY_WORD}.  This allows statistics to be browsed %22off-line,%22 without \n", 
"      having to run {PRODUCT_NAME} to generate each page.<p>\n", "  <li><b>send_view_by_email</b> (or svbe): This sends a statistics view using HTML email. \n", 
"      The view is sent to [vea] with return address [ra] using [ssh]. \n", "      The view to send is specified by [vtsbe].<p>\n", 
"  <li><b>export_view_table</b> (or evt): This exports a view table as CSV text. \n", "      The view to export is specified by [asv], and is written to the standard output stream, \n", 
"      so this is useful only in command-line mode.<p>\n", "  <li><b>convert_61_database</b> (or c61d): This converts a {PRODUCT_NAME} 6.0/6.1-format database to \n", 
"      a database which can be read by the current version.  The older database must be renamed \n", 
"      to <i>configname</i>-6.1 (for example, if the configuration name is myconfig, the database \n", 
"      in LogAnalysisInfo/Databases/myconfig must be renamed to LogAnalysisInfo/Databases/myconfig-6.1) \n", 
"      before converting.  The converted database will be written to the normal database directory; \n", 
"      the 6.0/6.1 database will not be modified.<p>\n", "</ul><p>\n", "\"\n", "\n", "# language_module_pathname option info\n", 
"OPTION_LABEL_lmp              \"Language Module\"\n", "OPTION_SHORT_DESCRIPTION_lmp  \"The language module to use to generate language-specific text\"\n", 
"OPTION_LONG_DESCRIPTION_lmp\n", "\"This option specifies the language module to use.\n", "Language modules contain rules for translating from {PRODUCT_NAME}'s internal\n", 
"text variables to what actually appears in generated HTML pages and other output.\n", "Language modules are contained in the Languages sub{DIRECTORY_WORD} of the \n", 
"LogAnalysisInfo {DIRECTORY_WORD}, and consist of five text files:\n", "<ol>\n", "  <li> <i>Language</i>-Stats-v<i>V</i>: The text of statistics pages<p>\n", 
"  <li> <i>Language</i>-Options-v<V>n</i>: The text of the option names and descriptions.<p>\n", "  <li> <i>Language</i>-Docs-v<i>V</i>: The text of the documentation pages.<p>\n", 
"  <li> <i>Language</i>-Admin-v<i>V</i>: The text of the administrative pages (Main Menu, interviews, etc.).<p>\n", 
"  <li> <i>Language</i>-Messages-v<i>V</i>: The text of error messages and other messages.<p>\n", "</ol>\n", 
"This option specifies the value of <i>Language</i> above; for instance if this option is \n", "%22English,%22 and the version number is 6.3.10,\n", 
"then {PRODUCT_NAME} will look for a file called English-Stats-v6.3.10 in the Languages sub{DIRECTORY_WORD},\n", 
"and similarly for the other four files.\n", "If the file does not exist, and the language is English, {PRODUCT_NAME} will create the file using\n", 
"the latest version of the built-in English language module.\n", "If the Language is not English, {PRODUCT_NAME} will look for the appropriate file with the current version \n", 
"number, and will use that file if it exists; otherwise, it will scan downward for any file with \n", 
"the correct language but a lower version number.  If it finds such a file,\n", "it will create and load the built-in \n", 
"latest version English module, and then load the correct-language file on top of the English one;\n", 
"this has the effect of using the specified language module in all cases it can handle, and\n", "using the English module for newer cases that the older language module cannot handle.<p>\n", 
"The module is split into five pieces to allow for partial implementations. \n", "For instance, by implementing only the small Stats module, you can provide support for \n", 
"a particular language for statistics browsing, without having to spend the considerable time required \n", 
"to fully translate the entire {PRODUCT_NAME} interface.  It is also possible to partially implement \n", 
"individual pieces; for instance, you can implement only those parts of the Options module which \n", 
"are linked directly from statistics pages by creating a <i>Language</i>-Options-v1 file; \n", "all options not defined in that file will be taken from the latest-version English file.\n", 

#ifdef SAWMILL
 "<p>\n", "A list of volunteer-contributed language modules can be found on \n", "<a href=%22http://www.sawmill.net/languages.html%22>the {PRODUCT_NAME} web site</a>\n", 

#endif
 "<p>\"\n", "\n", "# place_view_menu_at_top option info\n", "OPTION_LABEL_pvmat              \"Place View menu at top of page\"\n", 
"OPTION_SHORT_DESCRIPTION_pvmat  \"True if the View menu should appear at the top of the page, rather than the bottom\"\n", 
"OPTION_LONG_DESCRIPTION_pvmat\n", "\"This controls where the View menu (the pulldown menu which lets you choose \n", 
"which view you want of the data) appears on a statistics page. \n", "When this is true (checked), the menu appears at the top of the page. \n", 
"When this is false (unchecked), it appears at the bottom of the page.\"\n", "\n", "# entry_name option info\n", 
"OPTION_LABEL_en              \"Log entry name\"\n", "OPTION_SHORT_DESCRIPTION_en  \"The word to use to describe a log entry\"\n", 
"OPTION_LONG_DESCRIPTION_en\n", "\"This option specifies the word used to refer\n", "to a single log entry.  Usually you should leave this at its default value \n", 
"(%22default%22), and it will choose an appropriate name for log entries \n", "(usually %22hit%22).  But if your log is a custom log where %22hit%22 is \n", 
"not an appropriate name for a log entry, you can change this to something else. \n", "For instance, you might change this to %22order%22 if your log tracks orders. \n", 
"This will appear in various places\n", "in statistics pages.\"\n", "\n", "# number_thousands_divider option info\n", 
"OPTION_LABEL_ntd              \"Number thousands divider\"\n", "OPTION_SHORT_DESCRIPTION_ntd  \"A divider to separate thousands in displayed numbers\"\n", 
"OPTION_LONG_DESCRIPTION_ntd\n", "\"This option specifies the value to separate thousands in displayed number.\n", 
"For instance, if this option is empty, a number may be displayed as 123456789.\n", "If the value of this option is a comma (,), the number will be 123,456,789.\n", 
"If it's a period (.), the number will be 123,456,789.  If it's a space, the number\n", "will be 123 456 789.  This can be used to localize number divisions.\"\n", 
"\n", "# filter option info\n", "OPTION_LABEL_f              \"Statistics filters\"\n", "OPTION_SHORT_DESCRIPTION_f  \"The filters to use when showing statistics\"\n", 
"OPTION_LONG_DESCRIPTION_f\n", "\"This specifies the filters to use when showing a statistics view.\n", 
"This command is useful only from the command line--if you are running {PRODUCT_NAME} from a web browser,\n", 
"this is handled for you.  \n", "The parameter is either the value %22nofilters%22 if there are no filters on any field, \n", 
"or it is a comma-separated list of filter descriptions. \n", "Other than the recentdays, yesterday, lastmonth, singlefilter, matches, and regexp options,\n", 
"which can be in any position in the list, \n", "filters apply to the field corresponding to their list position; e.g. \n", 
"the fifth item in the list is the filter for the fifth database field. \n", "If there are fewer items in the list than database fields, the rest of the fields in the list will not be filtered. \n", 
"Each item in the list may be one of the following:<p> \n", "<ol>\n", "  <li> A single item from the database, described using an asterisk (*) followed by \n", 
"       the item number (e.g. *123).<p>\n", "  <li> A single item from the database, described using the item name (e.g. /dir1/page.html).<p> \n", 
"  <li> A list of items, each in the above format, if there are multiple filters on the field. \n", 
"       Items in the list should be separated by semicolons (;).<p>\n", "  <li> The value %22nofilter%22 if there are no filters on that field.<p>\n", 
"  <li> The value %22recentdays:<i>n</i>%22, \n", "       which means that the filters should be set to show only the <i>n</i> \n", 
"       most recent days from today.  This can be put anywhere in the list, but only applies to the date/time field.<p>\n", 
"  <li> The value %22yesterday%22, \n", "       which means that the filters should be set to show only yesterday's data\n", 
"       (midnight through midnight of the day before today) \n", "       This can be put anywhere in the list, but only applies to the date/time field.<p>\n", 
"  <li> The value %22daterange:<i>start</i>-<i>end</i>%22, \n", "       which means that the filters should be set to show only data from the specified date/time range.\n", 
"       See the date format note below for information about the format of <i>start</i> and <i>end</i>.<p>\n", 
"       This can be put anywhere in the list, but only applies to the date/time field.<p>\n", "  <li> The value %22singlefilter:<i>field</i>:<i>item</i>%22. \n", 
"       <i>field</i> is the field name, and <i>item</i> is a single item name. \n", "       This can occur at any place in the list, and will affect only <i>field</i>.<p>\n", 
"  <li> The value %22matches:<i>field</i>:<i>pattern</i>%22. \n", "       <i>field</i> is the field name, and <i>pattern</i> is a wildcard pattern (possible \n", 
"       including * or ?).  This filter restricts the data to only those values from <i>field</i> \n", 
"       whose names match <i>pattern</i>.\n", "       This can occur at any place in the list, and will affect only <i>field</i>.<p>\n", 
"  <li> The value %22regexp:<i>field</i>:<i>pattern</i>%22. \n", "       <i>field</i> is the field name, and <i>pattern</i> is a regular expression (see [docs-regexp]). \n", 
"       This filter restricts the data to only those values from <i>field</i> \n", "       whose names match the regular expression <i>pattern</i>.\n", 
"       This can occur at any place in the list, and will affect only <i>field</i>.<p>\n", "  <li> The value %22incremental%22, which has a special meaning-- filter sets containing \n", 
"       %22incremental%22 will be <i>added</i> to the existing filter, rather than overriding it. \n", 
"       This is useful in cases like a 404s view, where the 404 filter on the server response field \n", 
"       needs to override the default nofilter on the server response field, without removing any other filters.<p>\n", 
"</ol>\n", "Note: the format for a date/time item is %22dd/mmm/yyyy hh:mm:ss%22; you must use that \n", 
"exact format.  If you want to refer to a unit larger than a second, use underbars (_) in \n", "every field smaller than the unit you're interested in; e.g. a day would be %2212/Jan/2001 __:__:__%22<p>\n", 
"\"\n", "\n", "# session_information_filter option info\n", "OPTION_LABEL_sif              \"Session filters\"\n", 
"OPTION_SHORT_DESCRIPTION_sif  \"This controls the set of session filters, which limit which sessions are displayed in the statistics\"\n", 
"OPTION_LONG_DESCRIPTION_sif\n", "\"This specifies the session filters, which can be used to filter out sessions from the statistics in real time, \n", 
"to show only those sessions you're interested in.\n", "These filters only affect what is \n", "displayed on session-based views \n", 
"(session overview, paths through the site, entry pages, exit pages, time per page). \n", "They do not affect any other views.<p>\n", 
"Possible values include:<p>\n", "<ol>\n", "  <li> The value %22nofilters%22 means that all sessions are displayed.<p>\n", 
"  <li> The value %22contains:<i>page</i>%22 means that only sessions containing the page named <i>page</i> \n", 
"       should be displayed.  Page is the name of a page (e.g. /dir1/buy.html, or /dir1/(default) for \n", 
"       the default index page in the /dir1/ {DIRECTORY_WORD}) which must be one of the pages clicked in a session \n", 
"       for that session to appear in the session views.  If <i>page</i> isn't in a session, the session \n", 
"       is discarded when displaying session views. \n", "       This can be used to filter out all sessions except those involving a particular critical \n", 
"       page (for instance, and ordering page), to allow you to focus on activity that brought \n", 
"       people to that page.<p>\n", "  <li> The value %22visitorid:<i>visitor id</i>%22 means that only sessions from the visitor <i>visitor id</i> \n", 
"       should be displayed.  If a particular session isn't from <i>visitor id</i>, the session \n", 
"       is discarded when displaying session views.<p>\n", "</ol>\n", "\"\n", "\n", "# get_hits option info\n", 
"OPTION_LABEL_gh              \"Get number of hits\"\n", "OPTION_SHORT_DESCRIPTION_gh  \"Get the number of hits for the specified filters\"\n", 
"OPTION_LONG_DESCRIPTION_gh\n", "\"When this is true, {PRODUCT_NAME} prints the number of hits, bandwidth, etc. \n", 
"for the specified filters (see [f]), using the standard output stream. \n", "This is useful only if you are running {PRODUCT_NAME} from the command line, \n", 
"and need to query a database directly (rather than through the normal process of \n", "browsing the statistics in a web browser).  This is an advanced option--most \n", 
"users will have no need of it.<p>\"\n", "\n", "# page_paths_page info\n", "OPTION_LABEL_ppp              \"Page for %22paths through a page%22\"\n", 
"OPTION_SHORT_DESCRIPTION_ppp  \"The page to focus on in the %22paths through a page%22 view\"\n", "OPTION_LONG_DESCRIPTION_ppp\n", 
"\"This option is used internally, and should generally not be modified.\n", "It is the name of the page that is currently focused on, in the %22paths through a page%22 view.<p>\"\n", 
"\n", "# print_subitems option info\n", "OPTION_LABEL_ps              \"Print subitems\"\n", "OPTION_SHORT_DESCRIPTION_ps  \"Print the subitem hierarchy for a particular database field type\"\n", 
"OPTION_LONG_DESCRIPTION_ps\n", "\"This prints the subitem hierarchy for a particular database field type.\n", 
"This is only useful from the command line, and is primarily used for debugging.\n", "Example: <code>print_subitems true host</code>\"\n", 
"\n", "# log_block_size option info\n", "OPTION_LABEL_lbs              \"Log reading block size\"\n", 
"OPTION_SHORT_DESCRIPTION_lbs  \"Size in bytes of the blocks which are read from the log\"\n", "OPTION_LONG_DESCRIPTION_lbs\n", 
"\"This controls the size in bytes of the blocks which are read from the log data.\n", "{PRODUCT_NAME} reads the log data in chunks, processing each chunk completely before\n", 
"continuing to the next.  Larger settings will reduce the number of disk accesses, potentially\n", "speeding processing time, but will also require the specified number of bytes of memory.\"\n", 
"\n", "# generate_bookmark option info\n", "OPTION_LABEL_gb              \"Generate bookmark\"\n", "OPTION_SHORT_DESCRIPTION_gb  \"Used by CGI interface to generate bookmarks\"\n", 
"OPTION_LONG_DESCRIPTION_gb\n", "\"This option is used by the CGI interface to generate bookmarks.\n", 
"It should not be modified.\"\n", "\n", "# internal_scratch_option option info\n", "OPTION_LABEL_iso              \"Internal Scratch Option\"\n", 
"OPTION_SHORT_DESCRIPTION_iso  \"Used internally for temporary storage\"\n", "OPTION_LONG_DESCRIPTION_iso\n", 
"\"This option is used internally for temporary storage.  It does not ever\n", "need to be changed.\"\n", 
"\n", "# expire_database_data option info\n", "OPTION_LABEL_edd              \"Expire database data after (days)\"\n", 
"OPTION_SHORT_DESCRIPTION_edd  \"The number of days old to let database data become before it is expired from the database\"\n", 
"OPTION_LONG_DESCRIPTION_edd\n", "\"This controls how old database information must be before an Expire operation \n", 
"will remove it from the database.  When this option is empty, Expire Database will do nothing. \n", 
"When it is not empty, it represents the maximum age, in days, of database data. \n", "(Alternately, you can set an absolute expiration cutoff by setting this value to \n", 
"a time like %2212/Jan/2001 00:00:00%22). \n", "During an Expire Database operation, data older than this value will be removed from \n", 
"the database.  The age of an item is determined by the value of the date/time database field. \n", 
"This allows the database to be a rolling total of some fixed recent period, \n", "with new data added regularly, and old data removed to save space.\n", 
"For expiration to work, all fields must be cross-referenced to the date/time field; see [docs-xref].\n", 
"See also [cm].\"\n", "\n", "# expanded_edit_limits_items option info\n", "OPTION_LABEL_eeli              \"Expanded Edit Filters items\"\n", 
"OPTION_SHORT_DESCRIPTION_eeli  \"This is used by the CGI interface to edit filters\"\n", "OPTION_LONG_DESCRIPTION_eeli\n", 
"\"This is used by the CGI interface to edit filters.\n", "This option should not generally be changed manually.\"\n", 
"\n", "# expanded_session_paths option info\n", "OPTION_LABEL_esp              \"Expanded session paths\"\n", 
"OPTION_SHORT_DESCRIPTION_esp  \"This is used by the CGI interface to browse the session paths\"\n", 
"OPTION_LONG_DESCRIPTION_esp\n", "\"This is used by the CGI interface to browse the session paths.\n", 
"This option should not generally be changed manually.\"\n", "\n", "# master_process_id option info\n", 
"OPTION_LABEL_mpi              \"Master process id\"\n", "OPTION_SHORT_DESCRIPTION_mpi  \"The process id of the master process\"\n", 
"OPTION_LONG_DESCRIPTION_mpi\n", "\"This is used internally by {PRODUCT_NAME} to maintain the process id of the \n", 
"master process.  The master process starts a subordinate instance of \n", "{PRODUCT_NAME} to do all the work, and restarts it if it terminates.  This \n", 
"is used by the subordinate process to determine if the master is running; \n", "if the master is no longer running, then the subordinate process terminates.\n", 
"This option is passed on the command line to the subordinate process.\"\n", "\n", "\n", "##\n", "## OPTIMIZATION OPTIONS CATEGORY\n", 
"##\n", "\n", "\n", "# optimize option info\n", "OPTION_LABEL_o              \"Optimize statistics page shown\"\n", 
"OPTION_SHORT_DESCRIPTION_o  \"True if {PRODUCT_NAME} should optimize which statistics page is shown\"\n", 
"OPTION_LONG_DESCRIPTION_o\n", "\"This specifies whether the page displayed should be optimized for fast navigation.\n", 
"When this is checked (true), {PRODUCT_NAME} will check, each time it considers\n", "generating a page, whether that page has exactly one item on it\n", 
"(i.e. whether the page has only one item in its table).  If there\n", "is only one item on the page, and if that item has its own page associated with it,\n", 
"{PRODUCT_NAME} will display the page for the subitem instead (and will add an note in the\n", "page title that optimization has occurred).  {PRODUCT_NAME} will do this as many times as\n", 
"necessary, until it reaches the bottom, or a page with more than one item on it.<p>\n", "Optimization can reduce the number of clicks requires to get some kinds of data, since it\n", 
"eliminates the single-item pages, but it takes longer to generate each page.\n", "See also [optimize_items].\"\n", 
"\n", "# optimize_items option info\n", "OPTION_LABEL_oi              \"Optimize table and pie chart items\"\n", 
"OPTION_SHORT_DESCRIPTION_oi  \"True if table and pie chart items should be optimized\"\n", "OPTION_LONG_DESCRIPTION_oi\n", 
"\"This specifies whether or not items in tables and pie charts should be optimized for fast navigation.\n", 
"When this is checked (true), {PRODUCT_NAME} will check, each time it considers\n", "putting an item in a table or pie chart, whether that item has exactly one subitem\n", 
"(i.e. whether the page for that item will have only one item in its table).  If there\n", "is only one subitem, it will move that subitem up a level, to appear directly in the\n", 
"original table.  It will do this as many times as necessary, until it reaches the bottom\n", "or an item with more than one subitem.<p>\n", 
"Optimizing items can make browsing quicker, since it\n", "eliminates trips through single-item pages, but it takes longer to generate each page.\n", 
"This optimization in particular is quite expensive--{PRODUCT_NAME} needs to perform a large\n", "number of database accesses for each item added to the current page.\n", 
"With large, disk-based databases (i.e. databases which do not fit in memory),\n", "this option should be left off, or performance will be extremely slow.\n", 
"See also [optimize].\"\n", "\n", "# share_bar_box_images option info\n", "OPTION_LABEL_sbbi              \"Share bar and box images\"\n", 
"OPTION_SHORT_DESCRIPTION_sbbi  \"True if this configuration should share box and bar images\"\n", "OPTION_LONG_DESCRIPTION_sbbi\n", 
"\"This specifies whether this configuration should use\n", "shared box images (used in pie chart legends)\n", 
"and bar images (used in tables).  When this is checked (true),\n", "These images will be accessed from a single location which is\n", 
"shared by all configurations.  This means that once one configuration\n", "has created the images, the rest will be able to use them, and will\n", 
"not have to create them again.  This can significantly speed browsing.\n", "On the other hand, this will only work if the configurations use the same\n", 
"color scheme for their pie charts, and the same appearance for their bars.\n", "If they use different schemes, and attempt to share images, they may get\n", 
"pieces of each others' color schemes on their statistics pages.\"\n", "\n", "\n", "##\n", "## SECURITY OPTIONS CATEGORY\n", 
"##\n", "\n", "# config_view_statistics_password option info\n", "OPTION_LABEL_cvsp              \"Password to view statistics (empty for none)\"\n", 
"OPTION_SHORT_DESCRIPTION_cvsp  \"The password required to view the statistics for this configuration\"\n", 
"OPTION_LONG_DESCRIPTION_cvsp\n", "\"This specifies the password required to view the statistics for this configuration through the web mode.\n", 
"If this option is empty, no password is required.\n", "If this option is not empty, its value is the password which {PRODUCT_NAME} will prompt\n", 
"CGI users for when they attempt to use the %22View Statistics for:%22\n", "options on [docs-adminmenu] with this configuration.\n", 
"See also [require_password].\"\n", "\n", "# command_line_password option info\n", "OPTION_LABEL_clp              \"The configuration browsing password, passed on the command line\"\n", 
"OPTION_SHORT_DESCRIPTION_clp  \"The password required to view the statistics for this configuration, passed on the command line\"\n", 
"OPTION_LONG_DESCRIPTION_clp\n", "\"This option lets you use a direct URL to your statistics even if they are password-protected. \n", 
"Just include this option in the URL (clp+password) and {PRODUCT_NAME} will treat it as if you had entered \n", 
"the password in the prompt field, and will bypass the prompt field and take you to the statistics.\"\n", 
"\n", "# require_password option info\n", "OPTION_LABEL_rp              \"Require administrator password to use this configuration\"\n", 
"OPTION_SHORT_DESCRIPTION_rp  \"Whether to require the administrator password to use this configuration from a web browser\"\n", 
"OPTION_LONG_DESCRIPTION_rp\n", "\"This specifies whether the {PRODUCT_NAME} administrator password is required to use this configuration from a web browser.\n", 
"If this option is checked (true), a web browser user will be required to enter the {PRODUCT_NAME} administrator password before they\n", 
"may use this configuration.  If this option is unchecked (false), no password is required, except as specified by \n", 
"[cvsp].\"\n", "\n", "# hide_in_user_menu option info\n", "OPTION_LABEL_hium              \"Do not show this configuration in the User Menu\"\n", 
"OPTION_SHORT_DESCRIPTION_hium  \"True if this configuration should <i>not</i> appear in the User Menu\"\n", 
"OPTION_LONG_DESCRIPTION_hium\n", "\"This controls whether this configuration appears in the menu of configurations \n", 
"in the User Menu (see [docs-adminmenu]).  When this is true (checked), the configuration\n", "is hidden, and does not appear in the User Menu. \n", 
"When this is false (unchecked), this configuration appears in the User Menu.\"\n", "\n", "# show_only_remote_user_configurations option info\n", 
"OPTION_LABEL_soruc              \"Show only the configuration matching REMOTE_USER\"\n", "OPTION_SHORT_DESCRIPTION_soruc  \"Whether to show only the configurations whose names start with the value of REMOTE_USER\"\n", 
"OPTION_LONG_DESCRIPTION_soruc\n", "\"When this is true (checked), the Main Menu will show only the configuration,\n", 
"if any, whose names start with the value of REMOTE_USER followed by a dash (-). \n", "For instance, if REMOTE_USER is %22tom,%22 the Main Menu will show configurations\n", 
"named %22tom-access,%22 %22tom-referrer,%22 or %22tom-stats,%22 but will not show %22bob-access,%22\n", 
"%22tom access,%22 or %22tom.%22\n", "When this is false (unchecked), or if REMOTE_USER if empty (undefined),\n", 
"or if REMOTE_USER is equal to the value of [aru], then\n", "all configurations will appear in the Main Menu.\n", 
"REMOTE_USER\n", "is a web server CGI variable which contains the username of the user who logged in\n", 
"through an authentication screen (e.g. htaccess or realms authentication). \n", "This option provides a simple mechanism for\n", 
"hiding users' configurations from each other, provided {PRODUCT_NAME} is run in a section\n", "of the site protected by username/password authentication.\n", 
"For instance, you can run {PRODUCT_NAME} in CGI mode, protect the {PRODUCT_NAME} directory \n", "using authentication, turn on this option, and send the CGI URL to your users, \n", 
"so they will be able to log in to {PRODUCT_NAME} with web server authentication,\n", "and will only be able to see their own configurations.\n", 
"This option is only useful in CGI mode, and should not be turned on in web server mode \n", "(if it is turned on, it will make all configurations invisible), unless you are <i>also</i> \n", 
"running in CGI mode.\n", "\"\n", "\n", "# administrative_remote_user option info\n", "OPTION_LABEL_aru              \"Administrative REMOTE_USER\"\n", 
"OPTION_SHORT_DESCRIPTION_aru  \"The REMOTE_USER which is allowed to see all configurations\"\n", "OPTION_LONG_DESCRIPTION_aru\n", 
"\"This specifies the value of REMOTE_USER\n", "which will cause all configurations to appear in the main menu, even\n", 
"when [soruc] is true.  By logging in as this REMOTE_USER,\n", "you can perform administrative duties involving multiple users' configurations.\"\n", 
"\n", "# show_docs_links_in_stats option info\n", "OPTION_LABEL_sdlis              \"Show documentation links in statistics pages\"\n", 
"OPTION_SHORT_DESCRIPTION_sdlis  \"Whether to include links to the online documentation in statistics pages\"\n", 
"OPTION_LONG_DESCRIPTION_sdlis\n", "\"This specifies whether links to the online documentation should appear \n", 
"in statistics pages, where appropriate.  If this option is true (checked) \n", "links to the documentation will appear.  If this option is false (unchecked) \n", 
"documentation links will not appear.  This option is useful if you wish to \n", "hide the online documentation from your statistics-browsing users.\"\n", 
"\n", 0 };

