#!/usr/bin/perl
#
# This perl script prints the contents of the log files for all domains in $domains.
# It generates $logsdir using each domain name, and then prints all files in $logsdir.
# To customize this, you will need to edit the "my $domains" line, the

use strict;

# The location of the domains file; one domain name per line.
my $domains = "t:\\tmp\\domains.txt";

# Read the domain names
open(DOMAINS, $domains) || die("Can't open $domains");
while (<DOMAINS>) {

    chomp();
    my $domain = $_;

    # Compute the logs directory for this domain
    my $logsdir = "c:\\inetpub\\wwwroot\\resadmin\\${domain}com\\$domain.com\\logs\\iislogdir";

    # Get the filenames of the files in $logsdir
    opendir(LOGSDIR, $logsdir) || die("Can't read $logsdir");
    my @logfiles = readdir(LOGSDIR);

    # Process all files in $logsdir
    foreach my $logfile (@logfiles) {

	# Don't proces files starting with a dot.
	if (!($logfile =~ /^\./)) {

	    # Print the content of this file
	    my $logpathname = "$logsdir\\$logfile";
	    open(LOGFILE, $logpathname) || die("Can't open $logpathname");
	    while (<LOGFILE>) {
		print;
	    }
	    close(LOGFILE);

	} # if not dot

    } # for each logfile

    closedir(LOGSDIR);

} # while domains
