// js document

function get_weekday(year, month, day) {
	var year = year;
	var month = month;
	var day = day;
	var date = new Date(year, month, day);
	return date.getDay();
}

function get_days_in_month(year, month) { // get the number of days for a month
	// set required month to day 1, 00:00
	var the_month = new Date(year, month, 1, 0); // new Date(year, month 0-11, day, hour) format spec
	var next_month;
	// set next month to day 1, 06:00, the 6 hours compensate summertime shift
	if (month <= 10) { // month is 0-10, smaller/equal November
		next_month = new Date(year, (month + 1), 1, 6); // first day of next month, 06:00
	}
	else { // month is 11,  = December
		next_month = new Date((year + 1), 0, 1, 6); // first month and day of next year, 06:00
	}
	var days_in_month = next_month.getTime() - the_month.getTime();
	days_in_month = Math.floor(days_in_month / (1000 * 60 * 60 * 24));
	//alert('year:' + year + '\n month: ' + month + '\n days in month: ' + days_in_month);
	return days_in_month;
}

var z = 0;
function build_calendar() {
	// build_calendar does not use a loop because when using a loop
	// the calendar gets only displayed after each calendar month build passed the loop.
	// I.e., for a 36 month calendar in IE6 there would be a delay of ~ 6 seconds, measured from
	// the time of onload until the calendar gets displayed.

	calendar_month = _calendar_months[z];

	build_weekday_labels(calendar_month);
	build_calendar_days(calendar_month);

	z++;
	if (z < _calendar_months.length) {
		setTimeout('build_calendar()', 2);
	}
}

function build_weekday_labels(calendar_month) {
	var calendar_grid = document.getElementById(calendar_month);
	var span_elements = calendar_grid.getElementsByTagName('span');

	for (var i = 0, j = _first_weekday; i < 7; i++, j++) {
	
		var weekday = (j <= 6) ? j : j - 7;

		var span_element = span_elements[i];
		var old_weekday_label = span_element.firstChild;
		var new_weekday_label = document.createTextNode(_weekday_label[weekday]);
		span_element.replaceChild(new_weekday_label, old_weekday_label);

		// set color of marked day
		if (weekday == _marked_weekday) {
			span_element.style.color = 'red';
		}

		// populate _weekdays_order array for later use when creating the calendar
		
		_weekdays_sequence[i] = weekday;
	}
	// alert(_weekdays_sequence);
}

function build_calendar_days(calendar_month) {

	var calendar_grid = document.getElementById(calendar_month);
	var span_elements = calendar_grid.getElementsByTagName('span');
	
	// alert('Number of span elements:' + span_elements.length);

	// get number of days in month
	var year_month = calendar_month.split('_');
	var year = parseInt(year_month[0]);
	var month = parseInt(year_month[1]);

	var days_in_month = get_days_in_month(year, month);	
	// alert('Days in month: ' + days_in_month);

	// get weekday of first day in month
	var first_day_in_month = new Date(year, month, 1);
	var weekday_of_first_day_in_month = first_day_in_month.getDay();
	// alert('First weekday: ' + weekday_of_first_day_in_month);


	// get the weekday offset
	var weekday_offset;

	for (var i = 0; i < _weekdays_sequence.length; i++) {
		if (weekday_of_first_day_in_month == _weekdays_sequence[i]) {
			weekday_offset = _weekdays_offset[i];
		}
	}
	// alert(weekday_offset);

	// create the calendar days

	var span_num = 8;
	var day = weekday_offset;
	
	while (span_num < span_elements.length) {

		var show_week_text = false;
		var week_has_day_with_link = false;
		var a_day_in_week;		

		for (var i = 0; i < 8; i++) {

			var span_ref = span_elements[span_num];
			var child_ref = span_ref.firstChild;

			
			if (i < 7) { // create days text/link in week row
				
				if ((day > 0) && (day <= days_in_month)) {

					show_week_text = true;

					var log_day = calendar_month + '_' + day;
					var log_data_exist = (_log_days[log_day]) ? true : false;
					// var log_data_exist = check_for_log_data(year, month, day);
					var day_text = document.createTextNode(day);
					
					if (log_data_exist) {

						week_has_day_with_link = true;
						a_day_in_week = day;

						var a_element = document.createElement('a');
						a_element.appendChild(day_text);
						span_ref.replaceChild(a_element, child_ref);
						
						a_element.id = 'd_' + year + '_' + month + '_' + day;
						a_element.href = 'javascript:;';
						a_element.onclick = set_date_time_filter;
						span_ref.className = 'c-day';

					}
					else {
						span_ref.replaceChild(day_text, child_ref);
						span_ref.className = 'c-day-off';
					}
				}
				else {
					// important - if the cell is empty assign a class, this ensures
					// that all calendar months tables have the same height which is
					// required to float correctly!
					
					span_ref.className = 'c-day-off';
				}
			day++;
			}
			else { // create week text/link in week srow

				if (show_week_text) {
					
					var week_text = document.createTextNode('week');

					if (week_has_day_with_link) { // create week as link
						
						var a_element = document.createElement('a');
						a_element.appendChild(week_text);
						span_ref.replaceChild(a_element, child_ref);
						
						a_element.id = 'w_' + year + '_' + month + '_' + a_day_in_week;
						a_element.href = 'javascript:;';
						a_element.onclick = set_date_time_filter;
						span_ref.className = 'c-week';
					}
					else {
						span_ref.replaceChild(week_text, child_ref);
						span_ref.className = 'c-week-off';
					}
				}
			}
			span_num++;	
		}
	}
}

function set_date_time_filter() {
	var dat = this.id;

	dat = dat.split('_');
	switch (dat[0]) {
		case 'a' : // all
			// alert(dat);
			break;

		case 'y' : // year
			var year = dat[1];
			var date_time = '__/___/' + year + ' __:__:__';
			opener.parent.main_frame.set_filter_date_time(date_time);
			break;

		case 'm' : // month
			var year = Number(dat[1]); // convert string to number!
			var month = Number(dat[2]); // convert string to number!
			var days_in_month = get_days_in_month(year, month);
			var date_time = '__/' + _month_filter_format[month] + '/' + year + ' __:__:__';
			opener.parent.main_frame.set_filter_date_time(date_time);
			break;

		case 'w' : // week
			var date_time_range = get_date_time_range_of_week(dat[1], dat[2], dat[3]);
			opener.parent.main_frame.set_filter_date_time_range(date_time_range);
			break;		

		case 'd' : // day
			var year = dat[1];
			var month = dat[2];
			var day = dat[3];
			if (day <= 9) {
				day = '0' + day;
			}
			var date_time = day + '/' + _month_filter_format[month] + '/' + year + ' __:__:__';
			// alert('date_time1: #' + date_time + '#');
			opener.parent.main_frame.set_filter_date_time(date_time);
			// alert(date_time);
			break;

		default: 
			// alert('error in one of the calendar id\'s');
	}
	
	window.close();

	return false;
}

function show_all() {

	opener.parent.main_frame.clear_date_time_filter();
	window.close();
}


function get_date_time_range_of_week(year, month, day) {
	var date = new Date(year, month, day, 12, 0);
	var date_ms = date.getTime(); // the date in milliseconds
	var weekday = date.getDay();

	// alert(_weekdays_sequence);

	// get the position of the current day in the active _weekdays_sequence array.
	var position_in_weekday_sequence;

	for (var i = 0; i < _weekdays_sequence.length; i++) {

		if (weekday == _weekdays_sequence[i]) {
			position_in_weekday_sequence = i;
		}
	}

	var days_before = position_in_weekday_sequence;
	var days_after = 6 - position_in_weekday_sequence;

	var week_start_date = new Date();
	week_start_date.setTime(date_ms - (days_before * (1000 * 60 * 60 * 24)));

	var week_end_date = new Date();
	week_end_date.setTime(date_ms + (days_after * (1000 * 60 * 60 * 24)));

	var start_year = week_start_date.getFullYear();
	var start_month = week_start_date.getMonth();
	var start_day = week_start_date.getDate();
	if (start_day < 10) {
		start_day = '0' + start_day;
	}

	var end_year = week_end_date.getFullYear();
	var end_month = week_end_date.getMonth();
	var end_day = week_end_date.getDate();
	if (end_day < 10) {
		end_day = '0' + end_day;
	}

	var date_time_range =  start_day + '/' + _month_filter_format[start_month] + '/' + start_year + ' 00:00:00-';
	date_time_range += end_day + '/' + _month_filter_format[end_month] + '/' + end_year + ' 00:00:00';
	return date_time_range;
		
	// alert('week start date: ' + week_start_date + '\nweek end date: ' + week_end_date);
}

