// js document

var _wizard_path = new Array(); // defines the taken wizard path, on back the last entry will be removed

var _log_format_list_is_auto; // defines what log format list is active (autodetected = true, all = false)
var _log_format_selected; // the selected log format in the log format wizard!
var _log_format_selected_type; // the type of the selected log format in the log format wizard!

var _log_format_db = new Array(); // array of objects with all log formats, indexed with log format node name
var _log_format_db_loaded = false;

var _log_format_all_list_populated = false;

var _show_log_format_all_beta_info = false;
var _show_syslog_all_beta_info = false;
var _show_syslog_required_all_beta_info = false;

// query string of log source, also used for show matching files!
var _log_source; // used to generate _qs_log_source and in process_form(), contains name value pairs of log source
var _qs_log_source;


// log_source / log_format autodetection
var _autodetcting_log_format_start_time;
var _log_format_progress_timer;
var _log_format_autodetecting_id;
var _log_format_autodetection_task_id;

var _detected_log_format_db; // array of autodetected log formats
var _num_detected_standalone_formats = 0;
var _num_detected_syslog_formats = 0;
var _num_detected_syslog_required_formats = 0;


// variables to assemble the query string qs when creating a new profile
// log format variables are set at the time of selection
var _final_log_format_is_standalone; // true if standalone
var _final_log_format; // the final standalone format
var _final_syslog; // the final syslog format
var _final_syslog_required; // the final syslog required format
var _final_log_format_string; // log format string, the variable is set when log format is apache_custom or blue_coat_custom


// log format options
var _log_format_options_date_time = false;
var _log_format_options_host = false;
var _numerical_fields_db;


// final database option default values
var _database_type = 'SDB'; // don't remove default SDB!
var _mysql_database_name = '';
var _mysql_server_hostname = '';
var _mysql_server_username = '';
var _mysql_server_password = '';


function Log_format(name, label, type) {
	this.name = name;
	this.label = label;
	this.type = type;
}

// **********
// log source
// **********

function set_log_source_display() {
	
	var log_source_type_element = document.getElementById('log_source_type');
	var i = (log_source_type_element.selectedIndex == -1) ? 0 : log_source_type_element.selectedIndex;
	var active_log_source_type = log_source_type_element.options[i].value;
		
	var log_source_types = ['local', 'ftp', 'http', 'command'];
	var table_rows = new Array();
	table_rows['local'] = ['local_pathname_field_sample_row', 'local_pathname_row', 'local_process_subdir_row', 'local_pattern_is_reg_expr_row', 'local_matching_files_button_row'];
	table_rows['ftp'] = ['ftp_hostname_field_sample_row', 'ftp_hostname_row', 'ftp_username_row', 'ftp_password_row', 'ftp_pathname_field_sample_row', 'ftp_pathname_row', 'ftp_pattern_is_reg_expr_row', 'ftp_use_passive_row', 'ftp_matching_files_button_row'];
	table_rows['http'] = ['http_hostname_field_sample_row', 'http_hostname_row', 'http_pathname_field_sample_row', 'http_pathname_row', 'http_matching_files_button_row'];
	table_rows['command'] = ['command_field_sample_row', 'command_row'];
	
	// hide all log source rows
	
	for (var i = 0; i < log_source_types.length; i++) {
	
		var log_source_type = log_source_types[i];
	
		for (var j = 0; j < table_rows[log_source_type].length; j++) {
			
			// var row_element = document.getElementById(table_rows[log_source_type][j]);
			
			document.getElementById(table_rows[log_source_type][j]).style.display = 'none';
		}
	}
	
	// show log source rows
	
	for (var i = 0; i < table_rows[active_log_source_type].length; i++) {
		
		var row_element_id = table_rows[active_log_source_type][i];
		var show_row = true;
		
		if (_licensing_features == 'lite' && (
			row_element_id == 'local_process_subdir_row' ||
			row_element_id == 'local_pattern_is_reg_expr_row' ||
			row_element_id == 'ftp_pattern_is_reg_expr_row')) {
					
			show_row = false;
		}
		
		if (show_row) {
			
			document.getElementById(row_element_id).style.display = '';
		}
	}
}

function validate_log_source() {
	
	// Note, this function also creates the _log_source array!
	
	// If the log source data are valid the _log_source array saves the log source data which are used to
	// a.) generate the _qs_log_source which is used to get the log format and the show matching files component
	// b.) to generate the hfe log source data in process_form when form data are submitted via POST
	
	var form_is_valid = false;
	
	var log_source_type_element = document.getElementById('log_source_type');
	var i = (log_source_type_element.selectedIndex == -1) ? 0 : log_source_type_element.selectedIndex;
	var log_source_type =  log_source_type_element.options[i].value;
	
	_log_source = new Array();
	
	_log_source[_log_source.length] = {name:'type',value:log_source_type};

	switch (log_source_type) {

		case 'local' :
		
			//var local_pathname = strip_whitespace(document.getElementById('local_pathname').value);
			//var local_process_subdir = document.getElementById('local_process_subdir').checked;
			//var local_pattern_is_reg_expr = document.getElementById('local_pattern_is_reg_expr').checked;
			
			var local_pathname = get_value('local_pathname');
			
			// local_pathname = convert_name_to_integer_string(local_pathname);
			
			local_pathname = local_pathname.replace(/\u0024/g, '__HexEsc__24');
			local_pathname = local_pathname.replace(/\u005C/g, '__HexEsc__5C');

			var local_process_subdir = get_value('local_process_subdir');
			var local_pattern_is_reg_expr = get_value('local_pattern_is_reg_expr');
			
			if (value_is_not_empty_msg(local_pathname, _local_pathname_is_empty_message)) {
				
				_log_source[_log_source.length] = {name:'pathname',value:local_pathname};
				_log_source[_log_source.length] = {name:'process_subdirectories',value:local_process_subdir};
				_log_source[_log_source.length] = {name:'pattern_is_regular_expression',value:local_pattern_is_reg_expr};
				
				generate_log_source_query_string(log_source_type);
				
				return true;
			}
			else {
				
				return false;
			}
			
			break;
		
		case 'ftp' :
		
			var ftp_hostname = get_value('ftp_hostname');
			var ftp_username = get_value('ftp_username');
			var ftp_password = get_value('ftp_password');
			var ftp_pathname = get_value('ftp_pathname');
			var ftp_pattern_is_reg_expr = get_value('ftp_pattern_is_reg_expr');
			var ftp_use_passive = get_value('ftp_use_passive');
			
			// Note, the ftp_username and ftp_password are optional, don't validate!
			
			if (value_is_not_empty_msg(ftp_hostname, _ftp_hostname_is_empty_message)) {
				if (value_is_not_empty_msg(ftp_pathname, _ftp_pathname_is_empty_message)) {
					form_is_valid = true;
				}
			}

			if (form_is_valid) {
				
				_log_source[_log_source.length] = {name:'username',value:ftp_username};
				_log_source[_log_source.length] = {name:'password',value:ftp_password};
				_log_source[_log_source.length] = {name:'hostname',value:ftp_hostname};
				_log_source[_log_source.length] = {name:'pathname',value:ftp_pathname};
				_log_source[_log_source.length] = {name:'pattern_is_regular_expression',value:ftp_pattern_is_reg_expr};
				_log_source[_log_source.length] = {name:'use_passive',value:ftp_use_passive};
				
				generate_log_source_query_string(log_source_type);
				
				return true;
			}
			else {
				
				return false;
			}
			
			break;

		case 'http' :
		
			var http_hostname = get_value('http_hostname');
			var http_pathname = get_value('http_pathname');
			
			if (value_is_not_empty_msg(http_hostname, _http_hostname_is_empty_message)) {
				if (value_is_not_empty_msg(http_pathname, _http_pathname_is_empty_message)) {
					form_is_valid = true;
				}
			}
			
			if (form_is_valid) {
				
				_log_source[_log_source.length] = {name:'hostname',value:http_hostname};
				_log_source[_log_source.length] = {name:'pathname',value:http_pathname};
				
				generate_log_source_query_string(log_source_type);
				
				return true;
			}
			else {
				
				return false;
			}
			
			break;

		case 'command':
		
			var command = get_value('command');
						
			if (value_is_not_empty_msg(command, _command_is_empty_message)) {
				
				/*
				qs += volatile_path + '.command+' + encode_name(command);
				_qs_log_source = qs;
				
				*/
				
				_log_source[_log_source.length] = {name:'command',value:command};
				
				generate_log_source_query_string(log_source_type);

				return true;
			}
			else {
				
				return false;
			}
			
			break;
	}
}

function generate_log_source_query_string(log_source_type) {
	
	// Creates the _qs_log_source string used in GET for server response call
	// Only used for show matching log source files!
	
	// Note, if log_source_type is local we don't need to encode it because the pathname
	// already exists as integer_string
	
	_qs_log_source = '';
	
	for (var i = 0; i < _log_source.length; i++) {
		
		if (typeof(_log_source[i].value) == 'boolean' || _log_source[i].value != '') {
			
			// alert('name: ' + _log_source[i].name + '\nvalue: ' + _log_source[i].value);
			
			var qs_value = _log_source[i].value;
			
			if (log_source_type != 'local') {
				
				// encode the value
				
				qs_value = encode_qs_value(qs_value);
			}
		
			_qs_log_source += '+volatile.new_profile.log_source.0.' + _log_source[i].name;
			_qs_log_source += '+' + qs_value;
		}
	}

	// alert(_qs_log_source);
}

function generate_log_source_post_string() { // NEW
	
	var dat = '';
		
	for (var i = 0; i < _log_source.length; i++) {
		
		if (typeof(_log_source[i].value) == 'boolean' || _log_source[i].value != '') {
			
			// alert('name: ' + _log_source[i].name + '\nvalue: ' + _log_source[i].value);
			
			if (dat != '') {
				
				dat += '&';
			}
		
			dat += 'volatile.new_profile.log_source.0.' + _log_source[i].name;
			dat += '=' + encodeURIComponent(_log_source[i].value);
		}
	}
	
	// alert(dat);
	
	return dat;
}

function server_response_invalid_log_source(error_msg) {
	
	var msg = _msg_invalid_log_source_with_server_response_info + '\n' + error_msg;
	
	stop_log_format_progress_elapsed_time();
	
	show_log_format_progress(false);

	// Fix up Windows backslashes in pathnames
	msg = msg.replace(/(\\\\)/g, "BACKSLASH");
	msg = msg.replace(/BACKSLASH/g, "\\");
	alert(msg);
}

// *********************************
// log_source / detecting log format
// *********************************


function get_detect_log_format_result() {
	
	var url = '?dp+templates.admin.new_profile_wizard.detect_log_format_result';
	url += '+volatile.autodetecting_id+' + _log_format_autodetecting_id;
	url += '+volatile.task_id+' + _log_format_autodetection_task_id;
	
	return call_to_server(url);
	
	// xmlhttp_post(url, 'volatile.autodetecting_id=' + _log_format_autodetecting_id + '&volatile.task_id=' + _log_format_autodetection_task_id);
}

function server_response_log_source(dat) {
	
	_log_format_autodetecting_id = dat.autodetecting_id;
	_log_format_autodetection_task_id = dat.task_id;

	// alert('server_response_log_source \nautodetecting_id: ' + autodetecting_id + '\ntask_id: ' + task_id);
	
	get_detect_log_format_result();
}

function server_response_autodetection_in_progess(dat) {
	
	// alert('server_response_autodetection_in_progess');
	
	// Display progress info
	
	set_child_text('log_format_progress_suboperation_description_label', dat.suboperation_description);
	set_child_text('log_format_progress_log_bytes_downloaded', dat.log_bytes_downloaded);
	
	// get_detect_log_format_result
	
	setTimeout('get_detect_log_format_result()', 300);
}

function server_response_log_source_task_id_error(error_msg) {
	
	alert(error_msg);
}

function server_response_detected_log_formats(dat) {
	
	// argument dat is an array of 0 to n log format objects (name, label and type)
	
	// alert('number of detected log formats: '  + dat.length);
	
	_detected_log_format_db = new Array();
	
	_num_detected_standalone_formats = 0;
	_num_detected_syslog_formats = 0;
	_num_detected_syslog_required_formats = 0;
	
	if (dat.length > 0) {
		
		// check the number of detected log format types
		
		for (var i = 0; i < dat.length; i++) {
			
			var log_format_type = dat[i].type;
			
			if (log_format_type == 'syslog') {
				
				_num_detected_syslog_formats++;
			}
			else if (log_format_type == 'syslog_required') {
				
				_num_detected_syslog_required_formats++;
			}
			else {
				
				_num_detected_standalone_formats++;
			}
		}
		
		// alert('Number of detected log format types:\nstandalone: ' + _num_detected_standalone_formats + '\nsyslog: ' + _num_detected_syslog_formats + '\nsyslog_required: ' + _num_detected_syslog_required_formats);
		
		
		if (_licensing_features != 'lite') {
			
			_detected_log_format_db = dat.slice(0);
		}
		else {
			
			// Lite version only, pre-clean the detected log formats array
			
			// if only syslogs --> nothing detected
			// if only syslog_required --> nothing detected
			// if standalone plus syslogs but no syslog_required --> delete the syslogs and keep the standalone formats
			// if standalone plus syslog_required but no syslogs --> delete the syslog_required and keep the standalone formats
			
			var syslog_mismatch = false;
			
			if ((_num_detected_syslog_formats == 0 && _num_detected_syslog_required_formats > 0) ||
				(_num_detected_syslog_required_formats == 0 && _num_detected_syslog_formats > 0)) {
				
				syslog_mismatch = true;
			}
			
			if (!syslog_mismatch) {
				
				_detected_log_format_db = dat.slice(0);
				
			}
			else {
				
				// syslog or syslog_required are no valid matches, remove them!
				
				_num_detected_syslog_formats = 0;
				_num_detected_syslog_required_formats = 0;
				
				if (_num_detected_standalone_formats > 0) {
					
					// consider only the standalone format(s)
					
					for (var i = 0; i < dat.length; i++) {
						
						var log_format_type = dat[i].type;
						
						if (log_format_type != 'syslog' && log_format_type != 'syslog_required') {
							
							_detected_log_format_db[_detected_log_format_db.length] = {name:dat[i].name, label:dat[i].label, type:dat[i].type};
						}				
					}
				}
				else {
					
					_detected_log_format_db = []; // that is an error, like nothing has been detected
				}
			}
		}
		
		/*
		var debug_text = 'Number of final detected log format types:\nstandalone: ' + _num_detected_standalone_formats + '\nsyslog: ' + _num_detected_syslog_formats + '\nsyslog_required: ' + _num_detected_syslog_required_formats;
		
		for (var i = 0; i < _detected_log_format_db.length; i++) {
			
			debug_text += '\n' + i + ' - ' + _detected_log_format_db[i].name + ' - ' + _detected_log_format_db[i].label + ' - ' + _detected_log_format_db[i].type;
		}
		
		alert(debug_text);
		*/
	}
	
	
	if (_detected_log_format_db.length > 0) {
		
		// Sort the detected formats
	
		if (_detected_log_format_db.length > 1) {
		
			_detected_log_format_db.sort(compare_labels);
		}
		
		// Make _detected_log_format_db array accessable by name
		for (var i = 0; i < _detected_log_format_db.length; i++) {
			
			_detected_log_format_db[_detected_log_format_db[i].name] = _detected_log_format_db[i];
		}

		// Check for direct match (if 1 x standalone OR 1 x syslog plus 1 x syslog_required)
		// Note, if only a single syslog or a single syslog_required has been detected then treat it also as direct match!
		
		var match_as_string = _num_detected_standalone_formats.toString() + _num_detected_syslog_formats.toString() + _num_detected_syslog_required_formats.toString();
		
		// alert('match_as_string: ' + match_as_string);
		
		if (match_as_string == '100' || match_as_string == '011' || match_as_string == '010' || match_as_string == '001') {
			
			// DIRECT MATCH
			
			// alert('log_format direct match!');
			
			set_log_format_direct_match_page();
			goto_wizard('log_format_direct_match_page');
		}
		else {
			
			// MULTIPLE MATCH, several log formats have been detected
			// alert('log_format multiple match!');
			
			set_log_format_multiple_match_page();
			goto_wizard('log_format_multiple_match_page');
		}
		
	}
	else {
		
		// show log_format_no_match_page
		// alert('log_format no match!');
		
		goto_wizard('log_format_no_match_page');
	}
}

// **********
// log format
// **********

function set_log_format_direct_match_page() {
	
	if (_num_detected_syslog_formats == 1 && _num_detected_syslog_required_formats == 1) {
		
		display_off('log_format_direct_match_standalone_section');
		display_on('log_format_direct_match_syslog_section');
		
		for (var i = 0; i < _detected_log_format_db.length; i++) {
			
			var type = _detected_log_format_db[i].type;
			
			if (type == 'syslog') {
				
				var syslog_label = _detected_log_format_db[i].label;
			}
			else {
				
				var syslog_required_label = _detected_log_format_db[i].label;
			}
		}

		set_child_text('log_format_direct_match_syslog_text', syslog_label);
		set_child_text('log_format_direct_match_syslog_required_text', syslog_required_label);
	}
	else {
		
		// IMPORTANT, this case usually handles a single STANDALONE format
		// but it also handles the case if there is only ONE SYLOG or ONE SYSLOG_REQUIRED format!
	
		// If only a sylog or syslog_required format has been detected,
		// show it as a standalone format, the missing of one log format pair
		// will be indicated on the next wizard page.
		
		display_off('log_format_direct_match_syslog_section');
		display_on('log_format_direct_match_standalone_section');
		
		var log_format_label = _detected_log_format_db[0].label;
		
		// alert('log_format_label: ' + log_format_label);
		
		set_child_text('log_format_direct_match_standalone_text', log_format_label);
	}
	
	// if not Lite then make detected radio button default checked
	
	if (_licensing_features != 'lite') {
		
		document.getElementById('log_format_direct_match_use_detected_btn').checked = true;
		
		// handle beta info
		
		var show_beta_info = false;
		
		for (var i = 0; i < _detected_log_format_db.length; i++) {
		
			var name = _detected_log_format_db[i].name;
			
			if (is_beta_log_format(name)) {
				
				show_beta_info = true;
			}
		}
		
		handle_log_format_beta_info(show_beta_info, 'log_format_direct_match_beta_info_section');
	}
}

function set_log_format_multiple_match_page() {
	
	// populate detected log format list
	
	var the_list = document.getElementById('log_format_multiple_match_list');
	var show_beta_info = false;
	
	the_list.options.length = 0;
	
	for (var i = 0; i < _detected_log_format_db.length; i++) {
		
		var name = _detected_log_format_db[i].name;
		var label =	_detected_log_format_db[i].label;
		the_list.options[i] = new Option(label, name, false, false);
		
		if (is_beta_log_format(name)) {
			
			show_beta_info = true;
		}
	}
	
	if (_licensing_features != 'lite') {
		
		document.getElementById('log_format_multiple_match_use_detected_btn').checked = true;
		
		handle_log_format_beta_info(show_beta_info, 'log_format_multiple_match_beta_info_section');
	}
	
	// if detected log format list contains syslog and syslog_required formats
	// then show a More Information link
	
	display_off('log_format_multiple_match_instruction');
	display_off('log_format_multiple_match_syslog_instruction');
	
	// we need top reset the info box, simulate a show/hide operation
	// so that the label becomes "Show Information"
	display_on('log_format_multiple_match_syslog_info_box');
	show_hide_info_section('log_format_multiple_match_syslog_info_box');
		
	if (_num_detected_syslog_formats > 0 && _num_detected_syslog_required_formats > 0) {
		
		display_on('log_format_multiple_match_syslog_instruction');
	}
	else {
	
		display_on('log_format_multiple_match_instruction');
	}
}

function set_and_goto_log_format_all_page() {
	
	if (_log_format_db_loaded) {
		
		// if the log format list has not yet been populated do it now
		
		var log_format_all_list = document.getElementById('log_format_all_list');
		
		if (log_format_all_list.options.length == 0) {
			
			for (var i = 0; i < _log_format_db.length; i++) {
				
				var value = _log_format_db[i].name;
				var label =	_log_format_db[i].label;
				log_format_all_list.options[i] = new Option(label, value, false, false);
				
				if (is_beta_log_format(value)) {
						
					_show_log_format_all_beta_info = true;
				}
			}
		}
		
		handle_log_format_beta_info(_show_log_format_all_beta_info, 'log_format_all_beta_info_section');
		
		goto_wizard('log_format_all_page');
	}
	else {
		
		// load the log formats first
		get_log_format_db(); // response will repeat next_wizard()!
	}
}

// ******
// syslog
// ******

function set_syslog_no_match_page() {
	
	// Pro Enterprise only
	// show text info that Sawmill detected a syslog_required but not syslog format
	
	set_child_text('syslog_no_match_syslog_required_label', _detected_log_format_db[_final_syslog_required].label);
}

function set_syslog_direct_match_page() {
	
	// get the syslog label
	
	for (var i = 0; i < _detected_log_format_db.length; i++) {
		
		if (_detected_log_format_db[i].type == 'syslog') {
			
			var syslog_label = _detected_log_format_db[i].label;
			var syslog_name = _detected_log_format_db[i].name;
		}
	}
	
	set_child_text('syslog_direct_match_syslog_required_label', _detected_log_format_db[_final_syslog_required].label);
	set_child_text('syslog_direct_match_syslog_label', syslog_label);
	
	if (_licensing_features != 'lite') {
	
		handle_log_format_beta_info(is_beta_log_format(syslog_name), 'syslog_direct_match_beta_info_section');
	}
}

function set_syslog_multiple_match_page() {
	
	var show_beta_info = false;
	
	// set syslog_required label for which the syslog format must be selected
	
	set_child_text('syslog_multiple_match_syslog_required_label', _detected_log_format_db[_final_syslog_required].label);
	
	// populate detected syslog list
	
	var the_list = document.getElementById('syslog_multiple_match_list');
	
	the_list.options.length = 0;
	
	for (var i = 0; i < _detected_log_format_db.length; i++) {
		
		var type = _detected_log_format_db[i].type;
			
		if (type == 'syslog') {

			var value = _detected_log_format_db[i].name;
			var label =	_detected_log_format_db[i].label;
			the_list.options[the_list.options.length] = new Option(label, value, false, false);
			
			if (is_beta_log_format(value)) {
			
				show_beta_info = true;
			}
		}
	}
	
	if (_licensing_features != 'lite') {
		
		document.getElementById('syslog_multiple_match_use_detected_btn').checked = true;
		
		handle_log_format_beta_info(show_beta_info, 'syslog_multiple_match_beta_info_section');
	}
}

function set_and_goto_syslog_all_page() {
	
	if (_log_format_db_loaded) {
		
		// if the syslog all list has not yet been populated do it now
		
		var syslog_all_list = document.getElementById('syslog_all_list');
		
		if (syslog_all_list.options.length == 0) {
			
			for (var i = 0; i < _log_format_db.length; i++) {
				
				var type = _log_format_db[i].type;
				
				if (type == 'syslog') {

					var value = _log_format_db[i].name;
					var label =	_log_format_db[i].label;
					syslog_all_list.options[syslog_all_list.options.length] = new Option(label, value, false, false);
					
					if (is_beta_log_format(value)) {
						
						_show_syslog_all_beta_info = true;
					}					
				}
			}
		}
		
		// set the active syslog_required label above the syslog list
		set_child_text('syslog_all_syslog_required_label', _log_format_db[_final_syslog_required].label);
		
		handle_log_format_beta_info(_show_syslog_all_beta_info, 'syslog_all_beta_info_section');

		goto_wizard('syslog_all_page');
	}
	else {
		
		// load the log formats first
		get_log_format_db(); // response will repeat next_wizard()!
	}
}

// ***************
// syslog_required
// ***************

function set_syslog_required_no_match_page() {
	
	// Pro Enterprise only
	// show text info that Sawmill detected a syslog but not syslog_required format
	
	set_child_text('syslog_required_no_match_syslog_label', _detected_log_format_db[_final_syslog].label);
}

function set_syslog_required_direct_match_page() {
	
	// get the syslog_required label
	
	for (var i = 0; i < _detected_log_format_db.length; i++) {
		
		if (_detected_log_format_db[i].type == 'syslog_required') {
			
			var syslog_required_label = _detected_log_format_db[i].label;
			var syslog_required_name = _detected_log_format_db[i].name;
		}
	}
	
	set_child_text('syslog_required_direct_match_syslog_label', _detected_log_format_db[_final_syslog].label);
	set_child_text('syslog_required_direct_match_syslog_required_label', syslog_required_label);
	
	if (_licensing_features != 'lite') {
	
		handle_log_format_beta_info(is_beta_log_format(syslog_required_name), 'syslog_required_direct_match_beta_info_section');
	}
}

function set_syslog_required_multiple_match_page() {
	
	var show_beta_info = false;
	
	// set syslog label for which the syslog_required format must be selected
	
	set_child_text('syslog_required_multiple_match_syslog_label', _detected_log_format_db[_final_syslog].label);
	
	// populate detected syslog_required list
	
	var the_list = document.getElementById('syslog_required_multiple_match_list');
	
	the_list.options.length = 0;
	
	for (var i = 0; i < _detected_log_format_db.length; i++) {
		
		var type = _detected_log_format_db[i].type;
			
		if (type == 'syslog_required') {

			var value = _detected_log_format_db[i].name;
			var label =	_detected_log_format_db[i].label;
			the_list.options[the_list.options.length] = new Option(label, value, false, false);
			
			if (is_beta_log_format(value)) {
			
				show_beta_info = true;
			}
		}
	}
	
	if (_licensing_features != 'lite') {
		
		document.getElementById('syslog_required_multiple_match_use_detected_btn').checked = true;
		
		handle_log_format_beta_info(show_beta_info, 'syslog_required_multiple_match_beta_info_section');
	}
}

function set_and_goto_syslog_required_all_page() {
	
	if (_log_format_db_loaded) {
		
		// if the syslog all list has not yet been populated do it now
		
		var syslog_required_all_list = document.getElementById('syslog_required_all_list');
		
		if (syslog_required_all_list.options.length == 0) {
			
			for (var i = 0; i < _log_format_db.length; i++) {
				
				var type = _log_format_db[i].type;
				
				if (type == 'syslog_required') {

					var value = _log_format_db[i].name;
					var label =	_log_format_db[i].label;
					syslog_required_all_list.options[syslog_required_all_list.options.length] = new Option(label, value, false, false);
					
					if (is_beta_log_format(value)) {
						
						_show_syslog_required_all_beta_info = true;
					}			
				}
			}
		}
		
		// set the active syslog label above the syslog_required list
		set_child_text('syslog_required_all_syslog_label', _log_format_db[_final_syslog].label);
		
		handle_log_format_beta_info(_show_syslog_required_all_beta_info, 'syslog_required_all_beta_info_section');
		
		goto_wizard('syslog_required_all_page');
	}
	else {
		
		// load the log formats first
		get_log_format_db(); // response will repeat next_wizard()!
	}
}


// ******************
// log format options
// ******************

function set_and_goto_log_format_options_page() {
	
	show_mini_progress(_checking_for_log_format_options_info);
	
	var the_format = _final_log_format_is_standalone ? _final_log_format : _final_syslog_required;
	
	var url = '?dp+templates.admin.new_profile_wizard.get_log_format_options';
	url += '+volatile.log_format+' + the_format;
	
	/*
	var debug_text = 'set_and_goto_log_format_options_page\n';
	debug_text += '\n_final_log_format_is_standalone: ' + _final_log_format_is_standalone;
	debug_text += '\n_final_log_format: ' + _final_log_format;
	debug_text += '\n_final_syslog: ' + _final_syslog;
	debug_text += '\n_final_syslog_required: ' + _final_syslog_required;
	debug_text += '\nformat send to get log format options: ' + the_format;
	
	alert(debug_text);
	*/
	
	return call_to_server(url);
}

function server_response_log_format_options_not_supported(not_supported_message) {

	if (not_supported_message == '') {
		not_supported_message = '-';
	}
	
	set_child_text('log_format_not_supported_message_container', not_supported_message);
	
	goto_wizard('log_format_options_not_supported_page');
}

function server_response_log_format_options(dat) {
	
	_numerical_fields_db = new Array();
	
	_log_format_options_date_time = dat[0][0];
	_log_format_options_host = dat[0][1];
	
	_numerical_fields_db = dat[1].slice();
	
	/*
	var debug_text = ' log format options response';
	debug_text += '\n_log_format_options_date_time: ' + _log_format_options_date_time;
	debug_text += '\n_log_format_options_host: ' + _log_format_options_host;
	debug_text += '\n\nnumerical fields:';
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
		
		debug_text += '\n' + _numerical_fields_db[i].name + '-' + _numerical_fields_db[i].checked;
	}
	
	alert(debug_text);
	*/
	
	if (_licensing_features == 'lite') {
		
		// if Lite then set all numerical fields to checked
		// and go to profile_name_page
		
		for (var i = 0; i < _numerical_fields_db.length; i++) {
		
			_numerical_fields_db[i].checked = true;
		}
		
		goto_wizard('profile_name_page');
	}
	else {
		
		if (_numerical_fields_db.length == 1) {
			
			// if there is only one numerical field, then automatically
			// check it and continue to the next wizard.
			
			_numerical_fields_db[0].checked = true;
			
			if (_licensing_features == 'pro') {
				
				goto_wizard('profile_name_page');
				
			}
			else {
				
				// enterprise only
				
				goto_wizard('database_options_page');
			}
		}
		else {
			
			// prepare the numerical fields and show the log_format options page
			
			// make the array accesable by name
			
			for (var i = 0; i < _numerical_fields_db.length; i++) {
		
				_numerical_fields_db[_numerical_fields_db[i].name] = _numerical_fields_db[i];
			}
			
			build_log_format_options_page();
			
			goto_wizard('log_format_options_page');
		}
	}
}

function build_log_format_options_page() {
	
	// builds the checkboxes for numerical fields
	
	var table_element = document.getElementById('log_format_options_numerical_field_container');
	
	// clean up existing table
	var c = table_element.firstChild;

	if (c != null) {
		table_element.removeChild(c);
	}
	
	var tbody = document.createElement('tbody');
	table_element.appendChild(tbody);
	
	
	// build the checkbox rows
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
		
		var field_name = _numerical_fields_db[i].name;
		var field_id = 'numerical_field:' + field_name;
		
		var tr = document.createElement('tr');
	
		// build checkbox cell
	
		var td = document.createElement('td');
		td.style.padding = '0px';
		
		var checkbox = document.createElement('input');
		checkbox.type = 'checkbox';
		checkbox.id = field_id;
		checkbox.onclick = update_numerical_field_state;
		
		td.appendChild(checkbox);
		tr.appendChild(td);
		
		// build label cell
		
		var td = document.createElement('td');
		td.style.paddingTop = '4px';
		td.style.paddingBottom = '4px';
		td.style.paddingLeft = '6px';
		var label = document.createElement('label');
		label.htmlFor = field_id;
		var label_text = document.createTextNode(_numerical_fields_db[i].label);
		
		label.appendChild(label_text);
		td.appendChild(label);
		tr.appendChild(td);

		tbody.appendChild(tr);
	}
	
	// set checkbox state
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
	
		var element = document.getElementById('numerical_field:' + _numerical_fields_db[i].name);
		element.checked = _numerical_fields_db[i].checked;
	}
}

function update_numerical_field_state() {
	
	// update the _numerical_fields_db object
	
	var element_id = this.id;
	var dat = element_id.split(':');
	var field_name = dat[1];
	
	_numerical_fields_db[field_name].checked = this.checked;
}

function set_all_numerical_fields(checked_state) {
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {

		var element = document.getElementById('numerical_field:' + _numerical_fields_db[i].name);
		
		element.checked = checked_state;
		_numerical_fields_db[i].checked = checked_state;
	}
}

// ****************
// database options
// ****************

function switch_database_type(element) {
	
	if (element.id == 'db_type_mysql') {
		
		document.getElementById('mysql_options').style.display = 'block';
		document.getElementById('mysql_hostname').focus();
		document.getElementById('mysql_hostname').select();
	}
	else {
		
		document.getElementById('mysql_options').style.display = 'none';
	}
}

function validate_mysql_fields() {
	
	// We set global variables which are used for further form processing!
	// Note, allow mysql_server_password and database name to be empty!
	
	// If the database name is empty we will use the profile name!

	_mysql_server_hostname = strip_whitespace(document.getElementById('mysql_hostname').value);
	_mysql_server_username =  strip_whitespace(document.getElementById('mysql_username').value);
	_mysql_server_password = strip_whitespace(document.getElementById('mysql_password').value); // do not validate!
	_mysql_database_name = strip_whitespace(document.getElementById('mysql_database_name').value);

	if (value_is_not_empty_msg(_mysql_server_hostname, _msg_no_mysql_hostname_defined)) {
		if (value_is_not_empty_msg(_mysql_server_username, _msg_no_mysql_username_defined)) {
			// if (value_is_not_empty_msg(_mysql_database_name, _msg_no_mysql_database_name_defined)) {
				if (validate_mysql_database_name_msg(_mysql_database_name, _msg_invalid_mysql_database_name)) {
					return true;
				}
			// }
		}
	}

	return false;
}

function check_database_options() {
	
	show_mini_progress('Checking database options, please wait.');

	var url = '?dp+templates.admin.new_profile_wizard.check_database_options';

	var dat = 'volatile.mysql_server_hostname=' + encodeURIComponent(_mysql_server_hostname);
	dat += '&volatile.mysql_server_username=' + encodeURIComponent(_mysql_server_username);
	dat += '&volatile.mysql_server_password=' + encodeURIComponent(_mysql_server_password);
	// dat += '&volatile.mysql_database_name=' + encodeURIComponent(_mysql_database_name);
  
	xmlhttp_post(url, dat);
}

function server_response_check_database_options(dat) {
	
	var is_valid = dat[0];
	
	if (is_valid) {
		
		goto_wizard('profile_name_page');
	}
	else {

		var msg = _msg_mysql_server_not_found;
		var server_msg = dat[1];
		
		if (server_msg != null) {
			
			msg += '\n' + server_msg;
		}
		
		// hide mini progress
		display_off('mini_progress_section');
		set_wizard_buttons();
		
		show_wizard_page('database_options_page');
		
		alert(msg);
	}
}

// ************
// profile_name
// ************

function validate_profile_name(profile_name) {
	
	// check for unique profile name
	profile_name = profile_name.toString();

	for (i = 0; i < _profiles.length; i++) {
		
		var existing_profile_name = _profiles[i].name.toString();
				
		if (profile_name == existing_profile_name) {
			
			return false;
		}
	}
	
	return true;
}

// ***********
// wizard flow
// ***********

function next_wizard() {
	
	var active_wizard_page = _wizard_path[_wizard_path.length - 1];

	switch (active_wizard_page) {

		case 'log_source_page' :
		
			if (validate_log_source()) {
			
				var url = '?dp+templates.admin.new_profile_wizard.check_log_source';
				
				// url += _qs_log_source;
				// url += '+volatile.log_format_list_exists+' + _log_format_db_loaded;
				
				// disable log source window and show message 'detecting log format'
			
				show_log_format_progress(true);
				
				// alert(_qs_log_source);
				// return call_to_server(url);
								
				xmlhttp_post(url, generate_log_source_post_string());
			}
			else {
				return false;
			}		
			break;
			
			
		case 'log_format_no_match_page' :
		
			set_and_goto_log_format_all_page();

			break;
			
		case 'log_format_direct_match_page' :
		
			var use_direct_match = true;
			
			if (_licensing_features != 'lite' &&
				document.getElementById('log_format_direct_match_use_manual_btn').checked) {
			
				use_direct_match = false;
			}
			
			if (use_direct_match) {
				
				// set the active log format for form processing and to receive the log format options
				
				// Note, we handle detected log formats, so apache_custom and blue_coat_custom formats are not possible
				// and we don't need to handle a log_format_string page!
				
				// Note, it is possible that the direct match page displays a single syslog or
				// a single syslog_required format, in this case we have to show a syslog or syslog_required no mathc page!
				
				if (_num_detected_standalone_formats == 1) {
					
					_final_log_format_is_standalone = true;
					
					_final_log_format = _detected_log_format_db[0].name;
					
					set_and_goto_log_format_options_page();
					
				}
				else {
					
					_final_log_format_is_standalone = false;
					
					if (_num_detected_syslog_formats == 1 && _num_detected_syslog_required_formats == 1) {
					
						for (var i = 0; i < _detected_log_format_db.length; i++) {
							
							if (_detected_log_format_db[i].type == 'syslog') {
								
								_final_syslog = _detected_log_format_db[i].name;
							}
							else {
								
								_final_syslog_required = _detected_log_format_db[i].name;
							}
						}
						
						set_and_goto_log_format_options_page();
					}
					else {
						
						// the syslog or syslog_required format is missing, only one of them has been detected
						
						if (_detected_log_format_db[0].type == 'syslog') {
							
							// syslog_required is missing
							
							_final_syslog = _detected_log_format_db[0].name;
							
							set_syslog_required_no_match_page();
							
							goto_wizard('syslog_required_no_match_page');
						}
						else {
							
							// syslog is missing
							
							_final_syslog_required = _detected_log_format_db[0].name;
							
							set_syslog_no_match_page();
							
							goto_wizard('syslog_no_match_page');
						}
					}
				}
			}
			else {
				
				// Pro/Enterprise only, show all log formats page
				
				set_and_goto_log_format_all_page();
			}
		
			break;
			
			
		case 'log_format_multiple_match_page' :
		
			var use_detected_from_list = true;
			
			if (_licensing_features != 'lite' &&
				document.getElementById('log_format_multiple_match_use_manual_btn').checked) {
		
				use_detected_from_list = false;
			}
		
			if (use_detected_from_list) {
				
				var log_format_multiple_match_list = document.getElementById('log_format_multiple_match_list');
				var log_format_multiple_match_list_index = log_format_multiple_match_list.selectedIndex;
				
				if (log_format_multiple_match_list_index >= 0) {
					
					var selected_log_format = log_format_multiple_match_list.options[log_format_multiple_match_list_index].value;
					var selected_log_format_type = _detected_log_format_db[selected_log_format].type;
				
					// alert('selected_log_format: ' + selected_log_format + '\nselected_log_format_type: ' + selected_log_format_type);

					// Note, we handle detected log formats, so apache_custom and blue_coat_custom formats are not possible
					// and we don't need to handle a log_format_string page!
					
					if (selected_log_format_type == 'syslog') {
						
						_final_log_format_is_standalone = false;
						_final_syslog = selected_log_format;
						
						if (_num_detected_syslog_required_formats == 0) {
							
							// This case is not possible in Lite, as there is no syslog_required format detected any
							// syslog format would have been removed from the _detected_log_format_db
							
							// The Pro/Enterprise user can continue the wizard but gets a warning!
							
							set_syslog_required_no_match_page();
							
							goto_wizard('syslog_required_no_match_page');
						}
						else if (_num_detected_syslog_required_formats == 1) {
							
							set_syslog_required_direct_match_page();
							
							goto_wizard('syslog_required_direct_match_page');
						}
						else {
							
							set_syslog_required_multiple_match_page();
							
							goto_wizard('syslog_required_multiple_match_page');
						}
					}
					else if (selected_log_format_type == 'syslog_required') {
						
						_final_log_format_is_standalone = false;
						_final_syslog_required = selected_log_format;
						
						if (_num_detected_syslog_formats == 0) {
							
							// This case is not possible in Lite, as there is no syslog_required format detected any
							// syslog format would have been removed from the _detected_log_format_db
							
							// The Pro/Enterprise user can continue the wizard but gets a warning!
							
							set_syslog_no_match_page();
							
							goto_wizard('syslog_no_match_page');
						}
						else if (_num_detected_syslog_formats == 1) {
							
							set_syslog_direct_match_page();
							
							goto_wizard('syslog_direct_match_page');
						}
						else {
							
							set_syslog_multiple_match_page();
							
							goto_wizard('syslog_multiple_match_page');
						}
					}
					else {
						
						// this is a standalone format
						
						// Note, apache_custom and blue_coat_custom formats are only possible in this case!
						// These two formats are never auto detected!
						
						_final_log_format_is_standalone = true;
						_final_log_format = selected_log_format;
							
						set_and_goto_log_format_options_page();
					}
				}
				else {
					
					alert(_msg_no_log_format_selected);
				}
			}
			else {
				
				// Pro/Enterprise only, show all log formats page
				
				set_and_goto_log_format_all_page();
			}
		
			break;
		
		
		case 'log_format_all_page' :
		
			// Pro/Enterprise only
		
			var log_format_all_list = document.getElementById('log_format_all_list');
			var log_format_all_list_index = log_format_all_list.selectedIndex;
			
			if (log_format_all_list_index >= 0) {
				
				var selected_log_format = log_format_all_list.options[log_format_all_list_index].value;
				var selected_log_format_type = _log_format_db[selected_log_format].type;
				
				// alert('selected_log_format: ' + selected_log_format + '\nselected_log_format_type: ' + selected_log_format_type);
				
				if (selected_log_format_type == 'syslog') {
					
					_final_log_format_is_standalone = false;
					_final_syslog = selected_log_format;
					
					set_and_goto_syslog_required_all_page();
				}
				else if (selected_log_format_type == 'syslog_required') {
					
					_final_log_format_is_standalone = false;
					_final_syslog_required = selected_log_format;
					
					set_and_goto_syslog_all_page();
				}
				else {
					
					// this is a standalone format
					
					// Note, apache_custom and blue_coat_custom formats are only possible in this case!
					// These two formats are never auto detected!
					
					_final_log_format_is_standalone = true;
					_final_log_format = selected_log_format;
					
					if ((selected_log_format == 'apache_custom') || (selected_log_format == 'blue_coat_custom')) {
						
						// set the log format label for the log_format_string page
						set_child_text('log_format_string_info', _log_format_db[_final_log_format].label)
						
						goto_wizard('log_format_string_page');
					}
					else {
						
						set_and_goto_log_format_options_page();
					}
				}
			}
			else {
			
				alert(_msg_no_log_format_selected);
			}

			break;
			
			
		case 'syslog_no_match_page' :
	
			set_and_goto_syslog_all_page();
		
			break;
			
			
		case 'syslog_direct_match_page' :
		
			var use_direct_match = true;
			
			if (_licensing_features != 'lite' &&
				document.getElementById('syslog_direct_match_use_manual_btn').checked) {
			
				use_direct_match = false;
			}
			
			if (use_direct_match) {
				
				// only one syslog exists, set it as the final syslog_required format
				
				for (var i = 0; i < _detected_log_format_db.length; i++) {
					
					if (_detected_log_format_db[i].type == 'syslog') {
						
						_final_syslog = _detected_log_format_db[i].name;
						break;
					}
				}
				
				set_and_goto_log_format_options_page();
			}
			else {
		
				set_and_goto_syslog_all_page();
			}
		
			break;
			
		case 'syslog_multiple_match_page' :
		
			var use_detected_from_list = true;
			
			if (_licensing_features != 'lite' &&
				document.getElementById('syslog_multiple_match_use_manual_btn').checked) {
		
				use_detected_from_list = false;
			}
		
			if (use_detected_from_list) {
				
				var syslog_multiple_match_list = document.getElementById('syslog_multiple_match_list');
				var syslog_multiple_match_list_index = syslog_multiple_match_list.selectedIndex;
				
				if (syslog_multiple_match_list_index >= 0) {
					
					_final_syslog = syslog_multiple_match_list.options[syslog_multiple_match_list_index].value;
					
					set_and_goto_log_format_options_page();
				}
				else {
					
					alert(_msg_no_sylog_selected);
				}
			}
			else {
				
				set_and_goto_syslog_all_page();
			}

			break;
			
		
		case 'syslog_all_page' :
		
			// Pro/Enterprise only
		
			var syslog_all_list = document.getElementById('syslog_all_list');
			var syslog_all_list_index = syslog_all_list.selectedIndex;
			
			if (syslog_all_list_index >= 0) {
				
				_final_syslog = syslog_all_list.options[syslog_all_list_index].value;
				
				set_and_goto_log_format_options_page();
			}
			else {
				
				alert(_msg_no_sylog_selected);
			}
		
			break;
			

		case 'syslog_required_no_match_page' :
		
			set_and_goto_syslog_required_all_page();

			break;
			
			
		case 'syslog_required_direct_match_page' :
		
			var use_direct_match = true;
			
			if (_licensing_features != 'lite' &&
				document.getElementById('syslog_required_direct_match_use_manual_btn').checked) {
			
				use_direct_match = false;
			}
			
			if (use_direct_match) {
				
				// only one syslog_required exists, set it as the final syslog_required format
				
				for (var i = 0; i < _detected_log_format_db.length; i++) {
					
					if (_detected_log_format_db[i].type == 'syslog_required') {
						
						_final_syslog_required = _detected_log_format_db[i].name;
						break;
					}
				}
				
				set_and_goto_log_format_options_page();
			}
			else {
		
				set_and_goto_syslog_required_all_page();
			}
		
			break;
			
		case 'syslog_required_multiple_match_page' :
		
			var use_detected_from_list = true;
			
			if (_licensing_features != 'lite' &&
				document.getElementById('syslog_required_multiple_match_use_manual_btn').checked) {
		
				use_detected_from_list = false;
			}
		
			if (use_detected_from_list) {
				
				var syslog_required_multiple_match_list = document.getElementById('syslog_required_multiple_match_list');
				var syslog_required_multiple_match_list_index = syslog_required_multiple_match_list.selectedIndex;
				
				if (syslog_required_multiple_match_list_index >= 0) {
					
					_final_syslog_required = syslog_required_multiple_match_list.options[syslog_required_multiple_match_list_index].value;
					
					set_and_goto_log_format_options_page();
				}
				else {
					
					alert(_msg_no_sylog_required_selected);
				}
			}
			else {
				
				set_and_goto_syslog_required_all_page();
			}
		
			break;
			
		
		case 'syslog_required_all_page' :
		
			// Pro/Enterprise only
		
			var syslog_required_all_list = document.getElementById('syslog_required_all_list');
			var syslog_required_all_list_index = syslog_required_all_list.selectedIndex;
			
			if (syslog_required_all_list_index >= 0) {
				
				_final_syslog_required = syslog_required_all_list.options[syslog_required_all_list_index].value;
				
				set_and_goto_log_format_options_page();
			}
			else {
				
				alert(_msg_no_sylog_required_selected);
			}
		
			break;


		case 'log_format_string_page' :
		
			var log_format_string_value = get_value('log_format_string_value');
			var url = '?dp+templates.admin.new_profile_wizard.get_log_format_options';
			
			// alert('log_format_string_value: ' + log_format_string_value);

			if (value_is_not_empty(log_format_string_value)) {
				
				// set value for form processing
				_final_log_format_string = log_format_string_value.replace(/\u0022/g, '\\"');
				
				set_and_goto_log_format_options_page();
			}
			else {
				alert(_msg_no_log_format_string_defined);
			}			
			break;
			
		case 'log_format_options_page' :
		
			var numerical_field_checked = false;
		
			for (var i = 0; i < _numerical_fields_db.length; i++) {
				
				if (_numerical_fields_db[i].checked == true) {
					
					numerical_field_checked = true;
					break;
				}
			}
			
			if (numerical_field_checked) {
				
				if (_licensing_features == 'enterprise') {
					
					goto_wizard('database_options_page');
				}
				else {
					
					goto_wizard('profile_name_page');
				}
			}
			else {
				
				alert(_msg_log_format_options_numerical_field_nothing_checked);
			}
			
			break;

		case 'database_options_page' :
		
			if (document.getElementById('db_type_internal').checked) {
				
				// use SDB
	
				_database_type = 'SDB';
				
				// reset MySQL values (because values are always send!)
	
				_mysql_server_hostname = '';
				_mysql_server_username = '';
				_mysql_server_password = '';
				_mysql_database_name = '';

				goto_wizard('profile_name_page');
			}
			else {
				
				// use MySQL
				
				if (validate_mysql_fields()) {

					_database_type = 'MYSQL';
					
					check_database_options(); // server response handles further actions
				}
			}
			
			break;

		case 'profile_name_page' :
		
			finish_wizard();
		
			break;
	}
}

function goto_wizard(page_name) { // hide active wizard amd show next wizard as in argument
		
	var wizard_position = _wizard_path.length; // position to which the next wizard will be set

	if (wizard_position != 0) {
		hide_wizard_page(_wizard_path[wizard_position - 1]); // hide the active wizard
	}
	
	// hide mini progress section
	if (document.getElementById('mini_progress_section').style.display == 'block') {
		
		display_off('mini_progress_section');
	}

	show_wizard_page(page_name);
	_wizard_path[_wizard_path.length] = page_name;

	set_wizard_buttons();
	
	// set wizard number
	// set_child_text('wizard_number', _wizard_path.length);
}

function show_wizard_page(page_name) { // shows the wizard
	
	var wizard_page = document.getElementById(page_name);
	
	// set the wizard number
	// var wizard_number = _wizard_path.length > 0 ? _wizard_path.length : 1; 
	// set_child_text('wizard_number', wizard_number);
	
	// set the wizard label
	set_child_text('wizard_label', _wizard_labels[page_name]);
	
	// alert('page_name: ' + page_name + '\nwizard_page: ' + wizard_page + '\nwizard_page_label: ' + wizard_page_label);
	
	document.getElementById('wizard_label').style.visibility = 'visible';
	wizard_page.style.display = 'block';
	
	// wizard_page_label.style.display = 'block';
	
	if (page_name == 'profile_name_page') {
		
		document.getElementById('profile_name').focus();
		document.getElementById('profile_name').select();
	}
}

function hide_wizard_page(page_name) {
	
	var wizard_page = document.getElementById(page_name);
	
	wizard_page.style.display = 'none';
	document.getElementById('wizard_label').style.visibility = 'hidden';
	
	if (page_name == 'log_source_page') {
		
		document.getElementById('log_format_progress_section').style.display = 'none';
	}
}

function back_wizard() {
	
	// get the current wizard position
	
	var wizard_to_hide = _wizard_path[_wizard_path.length - 1]
	var wizard_to_show = _wizard_path[_wizard_path.length - 2]
	// var array_length_before = _wizard_path.length;

	
	_wizard_path.pop(); //removes the wizard_to_hide from the _wizard_path array

	hide_wizard_page(wizard_to_hide);
	set_wizard_buttons();
	
	// set wizard number
	// set_child_text('wizard_number', _wizard_path.length);
	
	show_wizard_page(wizard_to_show);
}

function disable_wizard_buttons() {
	
	document.getElementById('back_btn').disabled = true;
	document.getElementById('next_btn').disabled = true;
}

function set_wizard_buttons() {
	
	var back_btn = document.getElementById('back_btn');
	var next_btn = document.getElementById('next_btn');

	var active_wizard_page = _wizard_path[_wizard_path.length - 1];

	if (active_wizard_page == 'log_source_page') { // set to first
		
		back_btn.disabled = true;
		next_btn.disabled = false;
		
	}
	else if (active_wizard_page == 'profile_name_page') { //set to last
		
		back_btn.disabled = false;
		next_btn.disabled = false;
		
		next_btn.value = _finish_button_label;
	}
	else if (active_wizard_page == 'log_format_options_not_supported_page') {
		
		back_btn.disabled = false;
		next_btn.disabled = true;
	}
	else { // set to between
		
		back_btn.disabled = false;
		next_btn.disabled = false;
		next_btn.value = _next_button_label;
		
		if (_licensing_features == 'lite' && active_wizard_page == 'log_format_no_match_page') {
		
			next_btn.disabled = true;
		}
		else {
		
			next_btn.disabled = false;
		}
	}
}

// *************
// finsih wizard
// *************

function finish_wizard_via_enter_key(event) {
	
	var key_code = (event.which) ? event.which : event.keyCode;
	
	// alert(key_code);

	if (key_code == 13 || key_code == 3) {
		finish_wizard();
	}
}

function finish_wizard() {
	
	var profile_name = strip_whitespace(document.getElementById('profile_name').value);
	
	if (profile_name != '') {
		
		if (validate_profile_name(profile_name)) {
			
			show_mini_progress(_saving_new_profile_info);
			
			var url = '?dp+templates.admin.new_profile_wizard.finish_wizard';
			
			var dat = process_form(profile_name); // returns the form data
			
			// post data via xmlthhp
			
			xmlhttp_post(url, dat);
		}
		else {
			
			var msg = _msg_profile_name_already_exist;
			msg = msg.replace(/__PARAM__1__/, '"' + profile_name + '"');
			alert(msg);
			return false;
		}
	}
	else {
		
		alert(_msg_no_profile_name_defined);
		return false;
	}		
}

function server_response_finish_wizard(dat) {
	
	// alert('response received, dat is: ' + dat);
	
	var show_reports_upon_finish = dat.show_reports_upon_finish;
	var profile_node_name = dat.profile_node_name;
	
	display_off('mini_progress_section');
	display_on('profile_saved_info_section');
	
	// alert('profile_node_name:' + profile_node_name);
	
	// Change the Cancel button to Close due a Firefox bug where the New Profile Wizard doesn't close
	var cancel_btn = document.getElementById('cancel_btn');
	cancel_btn.value = _close_button_label;
	
	if (show_reports_upon_finish) {
				
		opener.show_reports(profile_node_name);
	}
	else {
		
		opener.window.location.reload(true);
	}

	window.close();
}


// ============
// process_form
// ============

function process_form(profile_name) {
	
	var dat = '';
	
	// send _autodetecting_id
	
	dat += 'volatile.new_profile.autodetecting_id=' + _log_format_autodetecting_id + '&';
	
	// log source
	
	for (var i = 0; i < _log_source.length; i++) {
		
		// alert(_log_source[i].path);
		
		// new_hfe('volatile.new_profile.log_source.0.' + _log_source[i].name, _log_source[i].value);
		
		dat += 'volatile.new_profile.log_source.0.' + _log_source[i].name + '=' + encodeURIComponent(_log_source[i].value) + '&';
	}
	
	// log format
	
	if (_final_log_format_is_standalone) {
		
		dat += 'volatile.new_profile.log_format_type=standalone&';
		dat += 'volatile.new_profile.log_format=' + _final_log_format + '&';
		
		// if the log format is apache_custom or blue_coat_custom add the _log_formt_string
		
		if (_final_log_format == 'apache_custom' || _final_log_format == 'blue_coat_custom') {

			dat += 'volatile.new_profile.log_format_string=' + encodeURIComponent(_final_log_format_string) + '&';
		}
	}
	else {
		
		dat += 'volatile.new_profile.log_format_type=syslog&';
		dat += 'volatile.new_profile.syslog_format=' + _final_syslog + '&';
		dat += 'volatile.new_profile.syslog_required_format=' + _final_syslog_required + '&';
	}
	
	// log format options - generic (Not anymore available in wizard, set default value!)
	
	if (_log_format_options_date_time) {
		
		dat += 'volatile.new_profile.track_date_time=day&';
	}
	
	if (_log_format_options_host) {
		
		dat += 'volatile.new_profile.track_host=individually&';		
	}
	
	// log format options - numerical fields
	
	for (var i = 0; i < _numerical_fields_db.length; i++) {
		
		if (_numerical_fields_db[i].checked) {
			
			dat += 'volatile.new_profile.numerical_fields.' + _numerical_fields_db[i].name + '=true&';
		}
	}
		
	dat += 'volatile.new_profile.database_type=' + _database_type + '&';
	dat += 'volatile.new_profile.mysql_server.hostname=' + encodeURIComponent(_mysql_server_hostname) + '&';
	dat += 'volatile.new_profile.mysql_server.username=' + encodeURIComponent(_mysql_server_username) + '&';
	dat += 'volatile.new_profile.mysql_server.password=' + encodeURIComponent(_mysql_server_password) + '&';
	dat += 'volatile.new_profile.mysql_database_name=' + encodeURIComponent(_mysql_database_name) + '&';

	// profile name
	
	dat += 'volatile.new_profile.profile_name=' + encodeURIComponent(profile_name) + '&';
	
	dat += 'volatile.show_reports_upon_finish=' + document.getElementById('show_reports_upon_finish').checked;
	
	// alert(dat);
	
	return dat;
}

// ===================
// log source progress
// ===================

function show_log_format_progress(show_log_format_progress) {
	
	// hides the log source wizard and shows log format progress
	
	var log_format_progress_section = document.getElementById('log_format_progress_section');
	
	if (show_log_format_progress) {
		
		disable_wizard_buttons();
		hide_wizard_page('log_source_page');
		
		adjust_log_format_progress();
				
		log_format_progress_section.style.display = 'block';
		
		var start_date = new Date();
		_autodetcting_log_format_start_time = start_date.getTime();
		
		// alert(_autodetcting_log_format_start_time);
		
		_log_format_progress_timer = setInterval('set_log_format_progress_elapsed_time()', 1000);
		
	}
	else {
		
		// return to log source view
		
		set_wizard_buttons();
		log_format_progress_section.style.display = 'none';
		show_wizard_page('log_source_page');
	}
}

function adjust_log_format_progress() {
		
	var log_format_progress_log_bytes_downloaded_row = document.getElementById('log_format_progress_log_bytes_downloaded_row');
	var log_format_progress_download_info_row = document.getElementById('log_format_progress_download_info_row');

	// check the log source type
	
	var log_source_type;
	
	for (var i = 0; i < _log_source.length; i++) {
		
		if (_log_source[i].name == 'type') {
			
			log_source_type = _log_source[i].value;
		}
	}
	
	// alert('log_source_type: ' + log_source_type);
	
	set_child_text('log_format_progress_suboperation_description_label', '-');
	set_child_text('log_format_progress_elapsed_time', '00:00:00');
	
	if (log_source_type == 'ftp' || log_source_type == 'http') {
	
		set_child_text('log_format_progress_log_bytes_downloaded', '-');
		log_format_progress_download_info_row.style.display = '';
		log_format_progress_log_bytes_downloaded_row.style.display = '';
	}
	else {
		
		log_format_progress_download_info_row.style.display = 'none';
		log_format_progress_log_bytes_downloaded_row.style.display = 'none';
	}	
}

function set_log_format_progress_elapsed_time() {
	
	var current_date = new Date();
	var current_time = current_date.getTime();
	
	var elapsed_time = Math.round((current_time - _autodetcting_log_format_start_time) / 1000);
	
	var remainder = 0;
	var hours = 0;
	var minutes = 0;
	var seconds = 0;
	
	if (elapsed_time >= 3600) {
		
		remainder = elapsed_time % 3600;
		hours = (elapsed_time - remainder) / 3600;
		
		elapsed_time = remainder;
	}
	
	if (elapsed_time >= 60) {
		
		remainder = elapsed_time % 60;
		minutes = (elapsed_time - remainder) / 60;
		
		elapsed_time = remainder;
	}
	
	seconds = elapsed_time;
	
	hours = (hours > 9) ? hours : '0' + hours;
	minutes = (minutes > 9) ? minutes : '0' + minutes;
	seconds = (seconds > 9) ? seconds : '0' + seconds;
	
	var elapsed_time_text = hours + ':' + minutes + ':' + seconds;
	
	set_child_text('log_format_progress_elapsed_time', elapsed_time_text);
}

function stop_log_format_progress_elapsed_time() {

	clearInterval(_log_format_progress_timer);
}

// ====================
// log format utilities
// ====================


function get_log_format_db() {
	
	show_mini_progress('Loading log format list, please wait!');
	
	var url = '?dp+templates.admin.new_profile_wizard.get_log_format_db';
	
	// xmlhttp_post(url, ''); can't use xmlhttp due a problem in Mozilla, response array data (nodeValue) are cut!
		
	return call_to_server('?dp+templates.admin.new_profile_wizard.get_log_format_db');
	
}

function server_response_get_log_format_db(dat) {
	
	// alert('log format list loaded');
	
	// alert(dat);
	// alert(log_format_dat.length);
	
	_log_format_db = new Array();
	var log_format_dat = dat.slice(0);
	
	for (var i = 0; i < log_format_dat.length; i++) {
		_log_format_db[i] = new Log_format(log_format_dat[i][0], log_format_dat[i][1], log_format_dat[i][2]);
		_log_format_db[_log_format_db[i].name] = _log_format_db[i];
	}

	//sort the array
	_log_format_db.sort(compare_labels);

	// alert(_log_format_db);
	// alert(_log_format_db[124].name + "\n" +_log_format_db[124].label + "\n" + _log_format_db[124].type);
	
	_log_format_db_loaded = true;
	
	// simply repeat next_wizard();
	
	next_wizard();
}


function is_beta_log_format(log_format_name) {
	
	if (log_format_name.substring(0, 5) == 'beta_') {
		
		return true;
	}
	
	return false;
}


function handle_log_format_beta_info(show_beta_info, element_id) {
	
	if (show_beta_info) {
			
		display_on(element_id);
	}
	else {
		
		display_off(element_id);
	}
}

// ==============
// help utilities
// ==============

function show_hide_info_section(element_id) {
	
	// alert(element_id);
	
	var info_box_element = document.getElementById(element_id);
	var link_element_id = element_id + ':link';
	var link_element = document.getElementById(link_element_id);
	
	if (info_box_element.style.display == 'none') {
		
		info_box_element.style.display = 'block';
		if (link_element != null) {
			set_child_text(link_element_id, _hide_infomation_label);
		}
	}
	else {
		
		info_box_element.style.display = 'none';
		if (link_element != null) {
			set_child_text(link_element_id, _more_information_label);
		}
	}
}

// =========
// utilities
// =========


function set_to_detected_btn_switch(element_id) {
	
	// automatically checks a radio button 'use detected' if a detected list item becomes selected
	// Note, in Lite the radio buttons do not exist!
	
	var the_radio_button = document.getElementById(element_id);
	
	if (the_radio_button != null && !the_radio_button.checked) {
	
		the_radio_button.checked = true;
	}
}

function deselect_list(element_id) {
	
	// deselects any item in the specified list
	the_list = document.getElementById(element_id);
	the_list.selectedIndex = -1;
}

function show_mini_progress(progress_text) {
	
	disable_wizard_buttons();
	
	// hide active wizard page
	hide_wizard_page(_wizard_path[_wizard_path.length - 1]);
		
	set_child_text('progress_info_text', progress_text);
	display_on('mini_progress_section');
}

function set_child_text(element_id, text) {
	
	var element = document.getElementById(element_id);
	element.replaceChild(document.createTextNode(text), element.firstChild);
}

function compare_labels(a, b) {
	// sorts the log format arrays by label
	var a_label = a.label.toLowerCase();
	var b_label = b.label.toLowerCase();
	
	if (a_label < b_label) {
		return -1;
	}
	else if (a_label > b_label) {
		return 1;
	}
	else {
		return 0;
	}
}

function get_value(element_id) {

	var element = document.getElementById(element_id);
	var type = element.type;
	var value = '';
	
	if (type == 'text' || type == 'textarea' || type == 'password') {
	
		value = strip_whitespace(element.value);
	}
	else {
	
		value = element.checked;
	}
	return value;
}

function encode_qs_value(the_value) {
	
	//only required when using GET on query strings
	
	if (the_value != true && the_value != false) {
	
		the_value = the_value.replace(/\\/g, '\\\\');
		the_value = encodeURIComponent(the_value);
	}
	
	return the_value;
}
