// js document
	
function init_onload() {

	user_system();

	// set the sysform url
	var sys_form = document.getElementById('sys_form');
	var url = '?dp+templates.statistics.global_filter.filter_form_processing'
	sys_form.action = url;

	set_show_hide_filter_fields_btn();

	// create a _filter_fields hash table
	generate_filter_fields_hash_table();
	
	// create the filter items table for each database field  
	for (var i = 0; i < _filter_fields.length; i++) {
    
    	var field_name = _filter_fields[i].name;
        
		if (_filter_field_items[field_name].length >= 1) {
						
			build_filter_items(field_name);
		}
	}
	
	// handle the advanced filter display
	handle_advanced_filter_display();

	move_filter_item_form();
}

function generate_filter_fields_hash_table() {

	// creates a hash table of the _filter_fields array so that object values can be looked up
	// and set by the database field name. I.e. _filter_fields['page'].disabled = true;
	
	for (i = 0; i < _filter_fields.length; i++) {
	
		// alert(_filter_fields[i].name + '\n' + _filter_fields[_filter_fields[i].name]);
		
		_filter_fields[_filter_fields[i].name] = _filter_fields[i];
	}
}

function build_filter_items(field_name) {

	var filter_items_container = document.getElementById(field_name + '_filter_items_container');

	// if filter items already exits remove them first
	var c = filter_items_container.firstChild;

	if (c != null) {
		filter_items_container.removeChild(c);
	}
	
	// build the table
	var table_elem = document.createElement('table');
	var tbody_elem = document.createElement('tbody');
	table_elem.className = 'filter-items';
	table_elem.appendChild(tbody_elem);

	// sort the array
	_filter_field_items[field_name].sort(sort_by_item_value);
	
	
	for (var i = 0; i < _filter_field_items[field_name].length; i++) {
  
		var filter_item_is_disabled = _filter_field_items[field_name][i].disabled;
		var filter_item_value = _filter_field_items[field_name][i].value;
		
		var row_elem = document.createElement('tr');
		
		// create the checkbox cell
		var input_id = 'cb:' + field_name + ':' + i;
		var td_elem_for_checkbox = document.createElement('td');
		var input_elem = document.createElement('input');
		input_elem.id = input_id;
		input_elem.type = 'checkbox';
		
		if (!filter_item_is_disabled) {
			input_elem.defaultChecked = true;
		}
			
		input_elem.value = field_name + '_WITH_ARRAY_POS_' + i; // value is used to refer to the array of this filter item
		input_elem.onclick = set_filter_item;
		
		td_elem_for_checkbox.appendChild(input_elem);
		row_elem.appendChild(td_elem_for_checkbox);
		
	
		// create the filter label cell
		var td_elem_for_label = document.createElement('td');
		var label_elem = document.createElement('label');
		var label_text = document.createTextNode(filter_item_value);
		label_elem.htmlFor = input_id
		
		label_elem.appendChild(label_text);
		td_elem_for_label.appendChild(label_elem);
		row_elem.appendChild(td_elem_for_label);

		// create the edit and delete button cell and links
		var td_elem_for_links = document.createElement('td');
		td_elem_for_links.style.paddingLeft = '18px';		

		// create the edit link
		var a_elem_for_edit = document.createElement('a');
		var edit_text = document.createTextNode(_edit_label);
		a_elem_for_edit.appendChild(edit_text);
		a_elem_for_edit.id = 'edit:' + field_name + ':' + i;
		a_elem_for_edit.href = 'javascript:;';
		a_elem_for_edit.onclick = edit_filter_item;
	
		td_elem_for_links.appendChild(a_elem_for_edit);

		// create edit | delete separator text
		var separator_text = document.createTextNode(' | ');
		td_elem_for_links.appendChild(separator_text);

		// create the delete link
		var a_elem_for_delete = document.createElement('a');
		var delete_text = document.createTextNode(_delete_label);
		a_elem_for_delete.appendChild(delete_text);
		a_elem_for_delete.id = 'del:' + field_name + ':' + i;
		a_elem_for_delete.href = 'javascript:;';
		a_elem_for_delete.onclick = delete_filter_item;
	
		td_elem_for_links.appendChild(a_elem_for_delete);

		row_elem.appendChild(td_elem_for_links);

		tbody_elem.appendChild(row_elem);
	}
  
	filter_items_container.appendChild(table_elem);
}

function sort_by_item_value(a, b) { // required to sort the filter fields array

	var item_a = a.value.toLowerCase();
	var item_b = b.value.toLowerCase();
	
	if (item_a < item_b) { return -1}
	if (item_a > item_b) { return 1}
	return 0;
}

function set_filter_field(element) {
	var element_id = element.id;
	var dat = element_id.split(':');
	var field_name = dat[1];
	var disabled = (element.checked) ? false : true;

	_filter_fields[field_name].disabled = disabled;

	mark_field_section(field_name);
}

function set_filter_field_negation(element) {
	var element_id = element.id;
	var dat = element_id.split(':');
	var field_name = dat[1];

	_filter_fields[field_name].negated = element.value;

	mark_field_section(field_name);
}

function set_filter_item() {
	var element_id = this.id
	var dat = element_id.split(':');
	var field_name = dat[1]; // filter fields index
	var index_position = dat[2]; // filter item index
	var disabled = (this.checked) ? false : true;

	_filter_field_items[field_name][index_position].disabled = disabled;

	// alert(_filter_field_items[field_name][index_position].disabled);
	
	mark_field_section(field_name);
}

function edit_filter_item() {
	var element_id = this.id
	var dat = element_id.split(':');
	var field_name = dat[1]; // filter fields index
	var index_position = dat[2]; // filter item index
	
	open_filter_item_form('edit', field_name, index_position);
}

function delete_filter_item() {
	var element_id = this.id
	var dat = element_id.split(':');
	var field_name = dat[1]; // filter fields index
	var index_position = dat[2]; // filter item index

	var msg = _confirm_delete_message;
	msg = msg.replace(/__PARAM1__/,  _filter_field_items[field_name][index_position].value);

	if (confirm(msg)) {
		// delete filter item from array
		_filter_field_items[field_name].splice(index_position, 1);
		
		// rebuild the filter items
		build_filter_items(field_name);
		set_filter_field_state(field_name);
	}
	
	mark_field_section(field_name);
}

function open_filter_item_form(form_type, field_name, index_position) {
	
	var filters_form = document.getElementById('filters_form');
	var filter_item_form = document.getElementById('filter_item_form');
	var filter_item_form_label = document.getElementById('filter_item_form_label');
	var type_is_name = document.getElementById('type_is_name');
	var type_is_wildcard = document.getElementById('type_is_wildcard');
	var type_is_regexp = document.getElementById('type_is_regexp');
	var filter_item = document.getElementById('filter_item');

	var db_field_options = document.getElementById('db_field_options');
	var session_start_info = document.getElementById('session_start_info');
	var session_contains_info = document.getElementById('session_contains_info');

	var new_filter_item_form_label_text = _new_filter_item_form_label;
	var edit_filter_item_form_label_text = _edit_filter_item_form_label;

	var old_form_label = filter_item_form_label.firstChild;
	var new_form_label;

	_active_form_type = form_type;
	_active_field_name = field_name;

	if (_filter_fields[field_name].type == 'db_field') {
		db_field_options.style.display = 'block';
		session_start_info.style.display = 'none';
		session_contains_info.style.display = 'none';
	}
	else {
		if (field_name == 'session_start') {
			db_field_options.style.display = 'none';
			session_start_info.style.display = 'block';
			session_contains_info.style.display = 'none';
		}
		else {
			db_field_options.style.display = 'none';
			session_start_info.style.display = 'none';
			session_contains_info.style.display = 'block';
		}
	}
	
	if (form_type == "new") {
		type_is_name.checked = true;
		filter_item.value = '';
		new_form_label = new_filter_item_form_label_text.replace(/__PARAM1__/,  _filter_fields[field_name].label);
	}
	else {
		_active_filter_item_index_position = index_position;
		var filter_item_type = _filter_field_items[field_name][index_position].type;

		if (filter_item_type == 'wildcard') {
			type_is_wildcard.checked = true;
		}
		else if (filter_item_type == 'regexp') {
			type_is_regexp.checked = true;
		}
		else {
			type_is_name.checked = true;
		}

		filter_item.value = _filter_field_items[field_name][index_position].value;
		new_form_label = edit_filter_item_form_label_text.replace(/__PARAM1__/,  _filter_fields[field_name].label);
	}

	new_form_label = document.createTextNode(new_form_label);
	filter_item_form_label.replaceChild(new_form_label, old_form_label);
	
	filters_form.style.visibility = 'hidden';
	filter_item_form.style.visibility = 'visible';

	filter_item.focus();
}

function move_filter_item_form() {

	// the filter item form is moved also if it is not visible
	// this solves a Netscape problem - Netscape is not able
	// to position the form correctly at the time when the form is opened
	// but it does it correctly this way

	var filter_item_form = document.getElementById('filter_item_form');
	// var advanced_filter_form_section = document.getElementById('advanced_filter_form_section');
	var scroll_top_position = scroll_top();

	filter_item_form.style.top = scroll_top_position + 80 + 'px';
	// advanced_filter_form_section.style.top = scroll_top_position + 80 + 'px';
}

function close_filter_item_form() {

	var filters_form = document.getElementById('filters_form');
	var filter_item_form = document.getElementById('filter_item_form');
	// var filter_section = document.getElementById(_active_field_name);

	filter_item_form.style.visibility = 'hidden';
	filters_form.style.visibility = 'visible';

	mark_field_section(_active_field_name);
}

function mark_field_section(field_name) {
	// marks an active filter section, i.e. thicker border
	var field_section_marked = document.getElementById(field_name);	

	// restore style of marked filter sections
	for (var i = 0; i < _filter_fields.length; i++) {
		var field_name = _filter_fields[i].name;
		var field_section = document.getElementById(field_name);

		if (field_section != field_section_marked) {	
			field_section.className = 'filter-field';
		}
	}

	// style the active filter section
	field_section_marked.className = 'filter-field-marked';

}

function process_filter_item_form() {

	var filters_form = document.getElementById('filters_form');
	var filter_item_form = document.getElementById('filter_item_form');
	var type_is_wildcard = document.getElementById('type_is_wildcard').checked;
	var type_is_regexp = document.getElementById('type_is_regexp').checked;
	var filter_item_type;
	var filter_item = document.getElementById('filter_item');
	var filter_item_value = filter_item.value;

	var is_empty_msg = 'Please define a filter item value';
	var filter_item_is_duplicate_msg = _filter_item_is_duplicate_message;
	var filter_item_is_duplicate;
	var index;
	
	if (value_is_not_empty_msg(filter_item_value, is_empty_msg)) {

		// evaluate the filter item type
		if (_filter_fields[_active_field_name].type == 'db_field') {

			if (type_is_wildcard) {
				filter_item_type = 'wildcard';
			}
			else if (type_is_regexp) {
				filter_item_type = 'regexp';
			}
			else {
				filter_item_type = 'name';
			}
		}
		else { // field is of type session
			if (_active_field_name == 'session_start') {
				filter_item_type = 'session_start';
			}
			else {
				filter_item_type = 'session_contains';
			}
		}
		
		if (_active_form_type == 'new') {

			filter_item_is_duplicate = check_for_duplicate_filter_item(filter_item_value);
	
			if (!filter_item_is_duplicate) {
			
				if ((filter_item_type != 'regexp') || validate_filter_item_regexp(filter_item_value)) {

					// add new filter item to filter fields array
					
					index = _filter_field_items[_active_field_name].length;
		
					_filter_field_items[_active_field_name][index] = {disabled:false, type:filter_item_type, value:filter_item_value};
	
					close_filter_item_form();
					build_filter_items(_active_field_name);
					set_filter_field_state(_active_field_name);
				}
			}
			else {
				alert(filter_item_is_duplicate_msg);
			}
		}

		else { // _active_form_type == 'edit'

			// if the filter item value did not change
			if (filter_item_value == _filter_field_items[_active_field_name][_active_filter_item_index_position].value) {
				filter_item_is_duplicate = false;
			}
			else {
				filter_item_is_duplicate = check_for_duplicate_filter_item(filter_item_value);
			}

			if (!filter_item_is_duplicate) {
			
				if ((filter_item_type != 'regexp') || validate_filter_item_regexp(filter_item_value)) {

					// modify existing filter item in filter fields array
					
					index = _active_filter_item_index_position;
		
					_filter_field_items[_active_field_name][index].type = filter_item_type;
					_filter_field_items[_active_field_name][index].value = filter_item_value;
	
					close_filter_item_form();
					build_filter_items(_active_field_name);
					set_filter_field_state(_active_field_name);
				}
			}
			else {
				alert(filter_item_is_duplicate_msg);
			}		
		}
	}
}

function check_for_duplicate_filter_item(filter_item_value) {

	for (var i = 0; i < _filter_field_items[_active_field_name].length; i++) {
		
		var existing_filter_item_value = _filter_field_items[_active_field_name][i].value;

		if (filter_item_value == existing_filter_item_value) {	
			return true;
		}
	}
	return false;
}

function validate_filter_item_regexp(filter_item_value) {

	try {
		var i = new RegExp(filter_item_value);
		return true;
	}
	catch(e) {
		alert(_filter_item_is_invalid_regexp_message);
		return false;
	}
}

function set_filter_field_state(field_name) {

	// when adding, deleting or editing filter items then
	// if no filter items then disable filter field controls
	// else enable filter field controls

	var filter_field_control = document.getElementById('filter_field:' + field_name);
	var is_control = document.getElementById('is:' + field_name);
	var is_not_control = document.getElementById('is_not:' + field_name);
	var filter_field_has_filter_items = (_filter_field_items[field_name].length >= 1) ? true : false;
	
	// alert('filter_field_has_filter_items:' + filter_field_has_filter_items);

	if (filter_field_has_filter_items) {
		_filter_fields[field_name].disabled = false;
		filter_field_control.checked = true;
		filter_field_control.disabled = false;
		is_control.disabled = false;
		is_not_control.disabled = false;
	}
	else {
		// _filter_field_items[field_name].disabled = true;
		_filter_fields[field_name].disabled = true;
		filter_field_control.checked = false;
		filter_field_control.disabled = true;
		is_control.disabled = true;
		is_not_control.disabled = true;
	}	
}

function process_filter_item_form_via_enter_key(event) {

	var key_code = (event.which) ? event.which : event.keyCode;

	if (key_code == 13 || key_code == 3) {
		process_filter_item_form();
	}
}

/*
/ Advanced filter
*/

function handle_advanced_filter_display() {
	
	var add_advanced_filter_button = document.getElementById('add_advanced_filter_button');
	var advanced_filter_display_section = document.getElementById('advanced_filter_display_section');

	if (_advanced_filter.expression != '') {
		
		add_advanced_filter_button.style.display = 'none';
		build_advanced_filter();
		advanced_filter_display_section.style.display = 'block';
	}
	else {
		advanced_filter_display_section.style.display = 'none';
		add_advanced_filter_button.style.display = 'block';
	}
}
	
function build_advanced_filter() {
	
	var advanced_filter_switch = document.getElementById('advanced_filter_switch');
	var advanced_filter_container = document.getElementById('advanced_filter_container');
	
	// clear any existing child nodes
	
	var c = advanced_filter_container.firstChild;

	if (c != null) {
		advanced_filter_container.removeChild(c);
	}
	
	// build the filter

	var pre_margin_top = '0px';
	
	var div_element = document.createElement('div');
	
	if (_advanced_filter.comment != '') {
		
		var comment_text = document.createTextNode(_advanced_filter.comment);
		
		div_element.appendChild(comment_text);
		
		pre_margin_top = '6px';
	}
	
	var pre_element = document.createElement('pre');
	var expression_text = document.createTextNode(_advanced_filter.expression);
	
	pre_element.style.fontSize = '11px';
	pre_element.style.marginTop = pre_margin_top;
	pre_element.style.marginBottom = '7px';
	pre_element.style.marginLeft = '0px';
	pre_element.style.marginRight = '0px';
	
	pre_element.appendChild(expression_text);
	div_element.appendChild(pre_element);
	
	advanced_filter_container.appendChild(div_element);
	
	// set the checkbox
	
	// var checked_state =  ? 
	
	advanced_filter_switch.checked = !_advanced_filter.disabled;
}

function open_advanced_filter_form(is_new) {
	
	var filters_form = document.getElementById('filters_form');
	var advanced_filter_form_section = document.getElementById('advanced_filter_form_section');
	
	var add_advanced_filter_label = document.getElementById('add_advanced_filter_label');
	var edit_advanced_filter_label = document.getElementById('edit_advanced_filter_label');
	
	var advanced_filter_comment_field = document.getElementById('advanced_filter_comment_field');
	var advanced_filter_expression_field = document.getElementById('advanced_filter_expression_field');
	
	if (is_new) {
		advanced_filter_comment_field.value = '';
		advanced_filter_expression_field.value ='';
		edit_advanced_filter_label.style.display = 'none';
		add_advanced_filter_label.style.display = 'block';
	}
	else {
		// edit existing filter
		advanced_filter_comment_field.value = _advanced_filter.comment;
		advanced_filter_expression_field.value = _advanced_filter.expression;
		add_advanced_filter_label.style.display = 'none';
		edit_advanced_filter_label.style.display = 'block';
	}
	
	filters_form.style.visibility = 'hidden';
	advanced_filter_form_section.style.display = 'block';
	
	location.hash = 'top_of_page';

	// filter_item.focus();
}

function close_advanced_filter_form() {
	
	var filters_form = document.getElementById('filters_form');
	var advanced_filter_form_section = document.getElementById('advanced_filter_form_section');
	
	advanced_filter_form_section.style.display = 'none';
	filters_form.style.visibility = 'visible';
	
	location.hash = 'bottom_of_page';
}

function delete_advanced_filter() {
	
	if (confirm(_confirm_delete_advanced_filter_message)) {
	
		_advanced_filter.comment = '';
		_advanced_filter.expression = '';
		handle_advanced_filter_display();
	}
}

function process_advanced_filter_form() {
	
	var comment = strip_whitespace(document.getElementById('advanced_filter_comment_field').value);
	var expression = strip_whitespace(document.getElementById('advanced_filter_expression_field').value);
	
	if (value_is_not_empty_msg(expression, _missing_advanced_filter_expression_message)) {
		
		_advanced_filter.disabled = false;
		_advanced_filter.comment = comment;
		_advanced_filter.expression = expression;
		handle_advanced_filter_display();
		close_advanced_filter_form();
	}
}

function set_advanced_filter(element) {
	
	_advanced_filter.disabled = !element.checked;
	
	// alert('_advanced_filter.disabled: ' + _advanced_filter.disabled);
}

/*
/ Filter form processing
*/

function process_form() {
	
	// check if any filter item is enabled
	
	var global_filter_is_active = false;
	
	for (var i = 0; i < _filter_fields.length; i++) {
	
		// This function checks if a filter item is active, if active then it will set global_filter_is_active to true.
		
		// It further checks all active filter fields, if there is a checked filter field where all filter items are disabled
		// then the filter field must also become disabled!
	
	
		var field_name = _filter_fields[i].name;
	
		var field_is_active = _filter_fields[i].disabled ? false : true;
		
		if (field_is_active) {
		
			// alert (_filter_fields[i].name);
		
			var field_has_filter_items = (_filter_field_items[field_name].length >= 1) ? true : false;
			var active_field_has_active_filter_item = false;
			
			if (field_has_filter_items) {
			
				for (var j = 0; j < _filter_field_items[field_name].length; j++) {
	
					var filter_item_is_active = _filter_field_items[field_name][j].disabled ? false : true;
					
					if (filter_item_is_active) {
					
						active_field_has_active_filter_item = true;
						global_filter_is_active = true;
						break;
					}
				}
			}
			
			// if no filter item is active then disable the filter field!
			
			if (!active_field_has_active_filter_item) {
			
				_filter_fields[i].disabled = true;
			}
		}
	}
	
	// check if the advanced filter is active
	
	if (!_advanced_filter.disabled && _advanced_filter.expression != '') {
		
		global_filter_is_active = true;
	}
	
	new_hfe('volatile.global_filter.global_filter_is_active', global_filter_is_active);
	new_hfe('volatile.global_filter.display_empty_filter_fields', _display_empty_filter_fields);

	for (var i = 0; i < _filter_fields.length; i++) {

		var field_name = _filter_fields[i].name;
		var field_has_filter_items = (_filter_field_items[field_name].length >= 1) ? true : false;

		if (field_has_filter_items) {

			var volatile_node = 'volatile.global_filter.fields.' + field_name;

			new_hfe(volatile_node + '.type', _filter_fields[i].type);
			new_hfe(volatile_node + '.label', _filter_fields[i].label);
			new_hfe(volatile_node + '.disabled', _filter_fields[i].disabled);
			new_hfe(volatile_node + '.negated', _filter_fields[i].negated);
			
			for (var j = 0; j < _filter_field_items[field_name].length; j++) {

				volatile_node = 'volatile.global_filter.fields.' + field_name;
				volatile_node += '.filter_items.' + j;

				var filter_item_value;
				filter_item_value = _filter_field_items[field_name][j].value;
				filter_item_value = encode_filter_string(filter_item_value);

				new_hfe(volatile_node + '.disabled', _filter_field_items[field_name][j].disabled);
				new_hfe(volatile_node + '.type', _filter_field_items[field_name][j].type);
				new_hfe(volatile_node + '.item_value', filter_item_value);
			}
		}
	}
	
	// process the advanced filter
	
	if (_advanced_filter.expression != '') {
		
		new_hfe('volatile.global_filter.advanced.disabled', _advanced_filter.disabled);
		new_hfe('volatile.global_filter.advanced.comment', _advanced_filter.comment);
		new_hfe('volatile.global_filter.advanced.expression', _advanced_filter.expression);
	}
}

function new_hfe(name, value) { // new hidden form element
	var sys_form = document.getElementById('sys_form');
	new_element = document.createElement('input');
	new_element.type = 'hidden';
	new_element.name = name;
	new_element.value = value;
	sys_form.appendChild(new_element);
}

function show_hide_filter_fields() {

	_display_empty_filter_fields = (_display_empty_filter_fields == true) ? false : true;

	set_show_hide_filter_fields_btn();

	var field_name;
	var field_has_filter_items;
	var field_section;

	if (_display_empty_filter_fields) {
		// show all filter fields
		for (var i = 0; i < _filter_fields.length; i++) {
			field_name = _filter_fields[i].name;
			field_section = document.getElementById(field_name);

			if (field_section.style.display == 'none') {
				field_section.style.display = 'block';
			}
		}	
	}
	else {
		// hide empty filter fields
		for (var i = 0; i < _filter_fields.length; i++) {
			field_name = _filter_fields[i].name;
			field_has_filter_items = (_filter_field_items[field_name].length >= 1) ? true : false;
	
			if (!field_has_filter_items) {
				field_section = document.getElementById(field_name);
				field_section.style.display = 'none';
			}
		}
	}
}

function set_show_hide_filter_fields_btn() {

	var show_hide_btn = document.getElementById('show_hide_filter_fields_btn')
	var show_label = _show_empty_filter_fields_button_label;
	var hide_label = _hide_empty_filter_fields_button_label;

	var new_label = (_display_empty_filter_fields == true) ? hide_label : show_label;

	old_label = show_hide_btn.firstChild;
	new_label = document.createTextNode(new_label);
	show_hide_btn.replaceChild(new_label, old_label);
}

function encode_filter_string(value) {

	// alert(value);

	// value = value.replace(/\'/g, '_SQUOTE_');
	// value = convert_dollar_to_hex(value);

	// alert(value);

	return value;
}
