// js document

function generate_log_fields_hash_table() {
	
	for (i = 0; i < _log_fields.length; i++) {
		_log_fields[_log_fields[i].name] = _log_fields[i];
	}
}

function generate_expression_ids_pattern() {

	_expression_ids_pattern = '';
	
	for (var i = 0; i < _expression_ids.length; i++) {
	
		_expression_ids_pattern += _expression_ids[i];
	}
}

function get_item_index(element_id) {

	// returns the item index of an element_id
	// the item_index is always at the last position of a composite id
	// i.e. if_expression:delete:2, the number 2 specifies the item_index
	
	var dat = element_id.split(':');
	var item_index = parseInt(dat[dat.length - 1]);
	return item_index;
}

function generate_expression_ids(expression_items_length) {

	// generates two arrays with the correct letter sequence
	
	// _expression_ids = ['A', 'B']; expressions ids as available from language module
	// _expression_ids_by_index[0] = 'A'; _expression_ids_by_index[1] = 'B'; _expression_ids_by_index[2] = 'AA';
	// _expression_ids_by_char['A'] = 0; _expression_ids_by_char['B'] = 1; _expression_ids_by_char['AA'] = 2;
	
	// _expression_ids_by_char is required to validate a custom Boolean sequence

	// if the number of expression items exceeds the number of available expression item ids (characters)
	// then duplicate the id foreach iteration

	_expression_ids_by_index.length = 0;
	_expression_ids_by_char.length = 0;
	
	var count = 0;
	var repeat = 1;
	var done = false;
	
	while (!done) {
	
		for (var i = 0; i < _expression_ids.length; i++) {
		
			if(count < expression_items_length) {
			
					var id_char = '';
			
					for (var k = 1; k <= repeat; k++) {
					
						id_char += _expression_ids[i];
					}
			
				_expression_ids_by_index[count] =  id_char;
				_expression_ids_by_char[id_char] =  count;
			}
			else {
				done = true;
				break;
			}
			count++;
		}
		repeat++;
	}
	
	// alert('_expression_ids_by_index: ' + _expression_ids_by_index);
	// alert('_expression_ids_by_char: ' + _expression_ids_by_char);
}


// ===============================
// handle expression form sections
// ===============================

function show_expression_pane(show) {

	var expression_type_section = document.getElementById('expression_type_section');
	var if_expression_section = document.getElementById('if_expression_section');
	var then_expression_section = document.getElementById('then_expression_section');
	var else_expression_section = document.getElementById('else_expression_section');
	var do_expression_section = document.getElementById('do_expression_section');
	
	if (show) {
		expression_type_section.style.display = 'block';
		set_expression_type();
	}
	else {
		expression_type_section.style.display = 'none';
		if_expression_section.style.display = 'none';
		then_expression_section.style.display = 'none';
		else_expression_section.style.display = 'none';
		do_expression_section.style.display = 'none';
	}
}

function set_expression_type() {

	var expression_type_list = document.getElementById('expression_type_list');
	var if_expression_section = document.getElementById('if_expression_section');
	var boolean_operator_section = document.getElementById('boolean_operator_section');
	var then_expression_section = document.getElementById('then_expression_section');
	var else_expression_section = document.getElementById('else_expression_section');
	var do_expression_section = document.getElementById('do_expression_section');
	var advanced_expression_section = document.getElementById('advanced_expression_section');
	var expression_type = expression_type_list.options[expression_type_list.selectedIndex].value;
	
	expression_type_list.blur(); // does not function in IE!
	
	// hide all sections
	
	if_expression_section.style.display = 'none';
	boolean_operator_section.style.display = 'none';
	then_expression_section.style.display = 'none';
	else_expression_section.style.display = 'none';
	do_expression_section.style.display = 'none';
	advanced_expression_section.style.display = 'none';
	
	update_sort_expression_items_buttons();
	
	switch (expression_type) {

		case 'conditional' :
		
			build_expression_items('if');
			build_expression_items('then');
			build_expression_items('else');
			if_expression_section.style.display = 'block';
			show_boolean_operator(true);
			then_expression_section.style.display = 'block';
			show_else_expression(document.getElementById('show_else_expression_btn').checked);
			break;
			
		case 'action' :
		
			build_expression_items('do');
			do_expression_section.style.display = 'block';
			break;
	
		case 'advanced' :
		
			advanced_expression_section.style.display = 'block';
			break;
	}
}

// ================
// boolean operator
// ================

function show_boolean_operator(show) {

	var boolean_operator_section = document.getElementById('boolean_operator_section');
	
	if (show) {
		if (_if_expressions.length > 1) {
			update_boolean_operator_display();
			boolean_operator_section.style.display = 'block';
		}
		else {
			boolean_operator_section.style.display = 'none';
		}
	}
	else {
		boolean_operator_section.style.display = 'none';
	}
}

function update_boolean_operator_display() {

	var custom_boolean_operator_section = document.getElementById('custom_boolean_operator_section');
	
	if (_boolean_operator == 'custom') {
		custom_boolean_operator_section.style.display = 'block';
	}
	else {
		custom_boolean_operator_section.style.display = 'none';
	}
}

function reset_boolean_operator() {

	// invoked upon deleting an expression item
	// if there are 0 or 1 expression items and "custom" is checked
	// then reset to default "or" operator
	
	var boolean_custom_btn = document.getElementById('boolean_custom_btn');
	
	if (_if_expressions.length <= 1 && boolean_custom_btn.checked) {
	
		var boolean_or_btn = document.getElementById('boolean_or_btn');
		
		boolean_or_btn.checked = true;
		_boolean_operator = 'or';
		update_boolean_operator_display();
	}
}

// ====================================
// update sort expression items buttons
// ====================================

function update_sort_expression_items_buttons() {

	set_sort_expression_items_button('if', _if_expressions.length);
	set_sort_expression_items_button('then', _then_expressions.length);
	set_sort_expression_items_button('else', _else_expressions.length);
	set_sort_expression_items_button('do', _do_expressions.length);
}

function set_sort_expression_items_button(sub_expression_type, number_of_expressions) {

	var span_element = document.getElementById('sort_expression_items_button_container:' + sub_expression_type);
	
	// delete any child elements
	var c = span_element.firstChild;
	if (c != null) {
		span_element.removeChild(c);
	}
	
	var text = (sub_expression_type == 'if') ? _sort_conditions_label : _sort_actions_label;
	
	var strong_element = document.createElement('strong');
	var text_node = document.createTextNode(text);
	strong_element.appendChild(text_node);

	if (number_of_expressions > 1) {
	
		// enable button
		var a_element = document.createElement('a');
		a_element.id = 'sort_expression_items_button:' + sub_expression_type;
		a_element.href = 'javascript:;';
		a_element.onclick = sort_expression_items;
		
		a_element.appendChild(strong_element);
		span_element.appendChild(a_element);
	}
	else {
	
		// disable button
		strong_element.style.color = '#BDBDBD';
		span_element.appendChild(strong_element);
	}
}

// =========================
// show/hide else expression
// =========================

function show_else_expression(show) {
	
	// invoked via checkbox
	
	var else_expression_section = document.getElementById('else_expression_section');
	
	if (show) {
		else_expression_section.style.display = 'block';
	}
	else {
		else_expression_section.style.display = 'none';
	}
}

// ===========================================
// build if, then, else or do expression items 
// ===========================================

function build_expression_items(sub_expression_type) {
	
	// builds the subexpression tables in main form
	// sub_expression_type specifies an "if", "then", "else" or "do" expression section

	var expressions;
	
	if (sub_expression_type == 'if') {
		expressions = _if_expressions;
	}
	else if (sub_expression_type == 'then') {
		expressions = _then_expressions;
	}
	else if (sub_expression_type == 'else') {
		expressions = _else_expressions;
	}
	else {
		expressions = _do_expressions;
	}

	var container = document.getElementById(sub_expression_type + '_expression_container');
	
	// if expression items already exits remove them first
	var c = container.firstChild;

	if (c != null) {
		container.removeChild(c);
	}
	
	// alert('sub_expression_type: ' + sub_expression_type + '\nnumber of expressions: ' + expressions.length);
	
	// alert('container: ' + container);
	// alert('items array length: ' + expressions.length);
	
	// ===============
	// build the table
	// ===============
	
	var table_element = document.createElement('table');
	table_element.cellSpacing = 0;
	var tbody_element = document.createElement('tbody');
	table_element.className = 'lf-expression-items';
	table_element.appendChild(tbody_element);
	
	if (expressions.length > 0) {
	
		generate_expression_ids(expressions.length);
		
		// var expression_id_count = 0;
		// var expression_id_repeat = 0;
		
		for (var i = 0; i < expressions.length; i++) {
		
			// --------
			// item row
			// --------
	  
			var row_element = document.createElement('tr');
			
			// ===================================================
			// create the expression identifier (A, B, C, ..) cell
			// ===================================================
						
			var td_element_for_id = document.createElement('td');
			td_element_for_id.style.paddingTop = '4px';
			td_element_for_id.style.paddingBottom = '4px';
			td_element_for_id.style.paddingLeft = '6px';
			td_element_for_id.style.verticalAlign = 'baseline';
			var expression_id_text = document.createTextNode(_expression_ids_by_index[i] + '.');
			td_element_for_id.appendChild(expression_id_text);
			row_element.appendChild(td_element_for_id);
			
			
			// ===============================
			// create the expression text cell
			// ===============================
			
			// row_element.appendChild(build_expression_text_cell(sub_expression_type, i));
			
			var td_element_for_text = document.createElement('td');
			td_element_for_text.style.padding = '4px';
			td_element_for_text.style.whiteSpace = 'normal';
			td_element_for_text.style.verticalAlign = 'baseline';

			var expression_text = document.createTextNode(build_expression_text(sub_expression_type, i, _expression_ids_by_index[i]));
					
			td_element_for_text.appendChild(expression_text);
			row_element.appendChild(td_element_for_text);
			
			// ================================================
			// create the edit and delete button cell and links
			// ================================================
			
			var td_element_for_links = document.createElement('td');
			td_element_for_links.style.paddingLeft = '18px';
			td_element_for_links.style.paddingTop = '4px';
			td_element_for_links.style.paddingBottom = '4px';
			td_element_for_links.style.paddingRight = '6px';
			td_element_for_links.style.verticalAlign = 'baseline';
			
			// --------------------
			// create the edit link
			// --------------------
			
			var a_elem_for_edit = document.createElement('a');
			var edit_text = document.createTextNode(_edit_label);
			a_elem_for_edit.appendChild(edit_text);
			a_elem_for_edit.id = 'edit:' + sub_expression_type + ':' + i;
			a_elem_for_edit.href = 'javascript:;';
			a_elem_for_edit.onclick = edit_expression_item;
					
			td_element_for_links.appendChild(a_elem_for_edit);
	
			// -----------------------------------
			// create edit | delete separator text
			// -----------------------------------
			
			var separator_text = document.createTextNode(' | ');
			td_element_for_links.appendChild(separator_text);
	
			// ----------------------
			// create the delete link
			// ----------------------
			
			var a_elem_for_delete = document.createElement('a');
			var delete_text = document.createTextNode(_delete_label);
			a_elem_for_delete.appendChild(delete_text);
			a_elem_for_delete.id = 'delete:' + sub_expression_type + ':' + i;
			a_elem_for_delete.href = 'javascript:;';
			a_elem_for_delete.onclick = delete_expression_item;

			td_element_for_links.appendChild(a_elem_for_delete);
			
			row_element.appendChild(td_element_for_links);
			
			tbody_element.appendChild(row_element);
			
		} // for each item
		
	} // if _expressions.length > 0
	
	else {
		// show info of how to add an item
		
		var info_text;
		
		if (sub_expression_type == 'if') {
		
			info_text = _add_condition_info;
		}
		else {
			info_text = _add_action_info;
		}
		
		var row_element = document.createElement('tr');
		var td_element_info = document.createElement('td');
		td_element_info.style.padding = '8px';
		var info_text_node = document.createTextNode(info_text);
		
		td_element_info.appendChild(info_text_node);
		row_element.appendChild(td_element_info);
		tbody_element.appendChild(row_element);
	}
	
	container.appendChild(table_element);
}

// ---------------------
// build expression text
// ---------------------

function build_expression_text(sub_expression_type, i, expression_id) {

	// builds the text for the expression data cell
	// this text is also used in sort expressions select element
	// and is therefore saved in the sub expression array as text property

	// i defines the item index
	
	var text;
	
	if (sub_expression_type == 'if') {
	
		var log_field = _if_expressions[i].field;
		var log_field_label = _log_fields[log_field].label + ' ';
		
		var operator = _if_expressions[i].operator;
		var operator_label = _operator_labels[operator] + ' ';
		
		var literal = _if_expressions[i].literal;
		
		if (operator != '<now') {
		
			text = log_field_label + ' ' + operator_label + ' "' + literal + '"';
		}
		else {
			
			text = log_field_label + ' ' +  _exp_operator_lt_now_text.replace(/__PARAM__1__/, literal);
		}
		
		// save text in _if_expressions array
		
		_if_expressions[i].text = expression_id + '. ' + text;
		
	}
	else {
	
		switch (sub_expression_type) {
					
			case 'then' :
				
				text = build_action_expression_item_text(_then_expressions[i]);
				_then_expressions[i].text = expression_id + '. ' + text;
				break;
			
			case 'else' :
			
				text = build_action_expression_item_text(_else_expressions[i]);
				_else_expressions[i].text = expression_id + '. ' + text;
				break;
				
			case 'do' :
			
				text = build_action_expression_item_text(_do_expressions[i]);
				_do_expressions[i].text = expression_id + '. ' + text;
				break;
		}
	}
	
	return text;
}

function build_action_expression_item_text(expression) {

	var text = '';
	var action_type = expression.type;
	var action_label = _action_labels[action_type];
	
	switch (action_type) {

		case 'accept' :
		
			text = _exp_text_accept;
			break;
		
		case 'concatenate' :

			var concatenate_details = expression.concatenate;
			var sub_text = '';
		
			for (var i = 0; i < concatenate_details.length; i++) {
		
				var is_log_field = concatenate_details[i].is_log_field;
				var literal = concatenate_details[i].literal;
				
				if (is_log_field) {
				
					sub_text += _log_fields[literal].label;
				
				}
				else {
					sub_text += '"' + literal + '"';
				}
				
				if (i < concatenate_details.length - 1) {
					
					sub_text += ' + ';
				}
			}
			sub_text = '[ ' + sub_text + ' ]';
			text = _exp_text_concatenate;
			text = text.replace(/__PARAM__1__/, sub_text);
			text = text.replace(/__PARAM__2__/, _log_fields[expression.log_field].label);
			break;
			
		case 'convert_to_lowercase' :
		
			text = _exp_text_convert_to_lowercase;
			text = text.replace(/__PARAM__1__/, _log_fields[expression.log_field].label);
			break;
			
		case 'convert_to_uppercase' :
		
			text = _exp_text_convert_to_uppercase;
			text = text.replace(/__PARAM__1__/, _log_fields[expression.log_field].label);
			break;

		case 'copy' :
		
			text = _exp_text_copy;
			text = text.replace(/__PARAM__1__/, _log_fields[expression.log_field].label);
			text = text.replace(/__PARAM__2__/, _log_fields[expression.target_log_field].label);
			break;
		
		case 'match_regexp_copy' :
		
			text = _exp_text_match_regexp_copy;
			text = text.replace(/__PARAM__1__/, _log_fields[expression.log_field].label);
			text = text.replace(/__PARAM__2__/, expression.literal);
			
			var match_regexp_copy_log_fields = expression.copy;
			
			for (var i = 0; i < match_regexp_copy_log_fields.length; i++) {
			
				var target_log_field = match_regexp_copy_log_fields[i].log_field;
				var target_log_field_label = _log_fields[target_log_field].label;
				var sub_text = _exp_text_match_regexp_copy_2;
				sub_text = sub_text.replace(/__PARAM__3__/, '\$' + (i + 1));
				sub_text = sub_text.replace(/__PARAM__4__/, target_log_field_label);
				
				text += ' ' + sub_text;
				
				if (i != (match_regexp_copy_log_fields.length - 1)) {
				
					text += ',';
				}
			}
			break;

		case 'find_and_replace' :
		
			var log_field = _log_fields[expression.log_field].label;
			var literal = expression.literal;
			var literal_2 = expression.literal_2;
			var replace_type = expression.replace_type;
			var sub_text;
			
			if (replace_type == 'all') {
				sub_text = _exp_text_find_and_replace_all;
			}
			else if (replace_type == 'first') {
				sub_text = _exp_text_find_and_replace_first;
			}
			else {
				sub_text = _exp_text_find_and_replace_last;
			}
			
			text = _exp_text_find_and_replace;
			text = text.replace(/__PARAM__1__/, log_field);
			text = text.replace(/__PARAM__2__/, literal);
			
			sub_text = sub_text.replace(/__PARAM__3__/, literal_2);
			
			text += ' ' + sub_text;
			
			break;
			
		case 'reject' :
		
			text = _exp_text_reject;
			break;
			
		case 'set' :
		
			text = _exp_text_set;
			text = text.replace(/__PARAM__1__/, _log_fields[expression.log_field].label);
			text = text.replace(/__PARAM__2__/, expression.literal);
			break;
	}
	
	return text;
}


// ====================
// edit expression item
// ====================

function edit_expression_item() {

	var element_id = this.id;
	dat = element_id.split(':');
	var sub_expression_type = dat[1];
	var item_index = parseInt(dat[2]);
	
	if (sub_expression_type == 'if') {
	
		open_if_expression_item_form(true, item_index);
	}
	else {
	
		open_action_expression_item_form(sub_expression_type, true, item_index);
	}

	return false;
}

// ======================
// delete expression item
// ======================

function delete_expression_item() {

	var element_id = this.id;
	dat = element_id.split(':');
	var sub_expression_type = dat[1];
	var item_index = parseInt(dat[2]);
	
	var msg = (sub_expression_type == 'if') ? _msg_confirm_delete_condition : _msg_confirm_delete_action;
	
	if (confirm(msg)) {
	
		switch (sub_expression_type) {

			case 'if' :
				_if_expressions.splice(item_index, 1);
				set_sort_expression_items_button('if', _if_expressions.length);
				reset_boolean_operator();
				break;
				
			case 'then' :
				_then_expressions.splice(item_index, 1);
				set_sort_expression_items_button('then', _then_expressions.length);
				break;
			
			case 'else' :
				_else_expressions.splice(item_index, 1);
				set_sort_expression_items_button('else', _else_expressions.length);
				break;
				
			case 'do' :
				_do_expressions.splice(item_index, 1);
				set_sort_expression_items_button('do', _do_expressions.length);
				break;
		}
		
		build_expression_items(sub_expression_type);
		
		if (sub_expression_type == 'if') {
		
			show_boolean_operator(true);
		}
	}
	
	return false;
}

// =====================
// sort expression items
// =====================

function sort_expression_items() {
	
	var element_id = this.id;
	var dat = element_id.split(':');
		
	_active_sub_expression_type = dat[1];
		
	var sort_expression_items_form = document.getElementById('sort_expression_items_form');
	var sort_expression_items_list = document.getElementById('sort_expression_items_list');
	var expressions;
	
	var subform_label = (_active_sub_expression_type == 'if') ? _sort_conditions_label : _sort_actions_label;
	
	switch (_active_sub_expression_type) {

		case 'if' :
			expressions = _if_expressions;
			break;
			
		case 'then' :
			expressions = _then_expressions;
			break;
		
		case 'else' :
			expressions = _else_expressions;
			break;
			
		case 'do' :
			expressions = _do_expressions;
			break;
	}
	
	sort_expression_items_list.options.length = 0;
	
	for (var i = 0; i < expressions.length; i++) {
	
		// strip off long lines because Mozilla expands the select element width to full text length!
	
		var text = expressions[i].text;
		
		if (text.length > 70) {
		
			text = text.substr(0,70) + ' ...';
		}
		
		sort_expression_items_list.options[i] = new Option(text, i, false, false);
	}
	
	sort_expression_items_form.style.display = 'block';
	open_subform(subform_label, process_sort_expression_items);
}


function move_expression_item_via_keys(event) {

	var key_code = (event.which) ? event.which : event.keyCode;
	
	// alert(key_code);

	if (key_code == 45) {
		move_expression_item('down');
	}
	
	if (key_code == 43) {
		move_expression_item('up');
	}
}


function move_expression_item(direction) {

	var sort_expression_items_list = document.getElementById('sort_expression_items_list');
	var selected_index = sort_expression_items_list.selectedIndex;
	
	if (selected_index != -1) {
	
		var target_index = (direction == 'up') ? selected_index - 1 : selected_index + 1;
	
		if ((target_index >= 0) && (target_index <= sort_expression_items_list.length - 1)) {
		
			// deselect item
			sort_expression_items_list.options[selected_index].selected = false;
			
			// replace items
			var selected_value = sort_expression_items_list.options[selected_index].value;
			var selected_text = sort_expression_items_list.options[selected_index].text;
			var target_value = sort_expression_items_list.options[target_index].value;
			var target_text = sort_expression_items_list.options[target_index].text;
		
			sort_expression_items_list.options[selected_index].value = target_value;
			sort_expression_items_list.options[selected_index].text = target_text;
			sort_expression_items_list.options[target_index].value = selected_value;
			sort_expression_items_list.options[target_index].text = selected_text;
			
			// select moved item
			sort_expression_items_list.options[target_index].selected = true;
		}
	}
	else {
		alert(_msg_no_list_item_selected);
	}
}

function process_sort_expression_items() {

	var sort_expression_items_list = document.getElementById('sort_expression_items_list');
	var expressions;
	var new_expressions_array;
	
	// create a temp expression array where objects are written in the order as in the sort list.
	// then replace the origiginal array with the temp array
	
	switch (_active_sub_expression_type) {

		case 'if' :
			_if_expressions = write_sorted_array(_if_expressions);
			break;
			
		case 'then' :
			_then_expressions = write_sorted_array(_then_expressions);
			break;
		
		case 'else' :
			_else_expressions = write_sorted_array(_else_expressions);
			break;
			
		case 'do' :
			_do_expressions = write_sorted_array(_do_expressions);
			break;
	}
	
	close_subform();
}

function write_sorted_array(ori_expressions) {

	var sort_expression_items_list = document.getElementById('sort_expression_items_list');
	var sorted_array = new Array();
	
	for (var i = 0; i < sort_expression_items_list.length; i++) {
	
		list_value = sort_expression_items_list.options[i].value;
		
		// alert(ori_expressions[list_value].field);
		
		sorted_array[i] = ori_expressions[list_value];
	}
	
	ori_expressions.length = 0;

	return sorted_array;
}


// ================
// subform handling
// ================

function open_subform(subform_label, function_name) {

	parent.top_frame.enable_top_frame(false);
	parent.top_frame.set_subform_label(subform_label);
	
	show_expression_pane(false);

	// display subform container and set ok button on subform

	var subform_ok_button = document.getElementById('subform_ok_button');
	var subform_container = document.getElementById('subform_container');
	
	subform_ok_button.onclick = function_name;
	subform_container.style.display = 'block';
}

function close_subform() {

	// close any displayed subform
	
	var subform_container = document.getElementById('subform_container');

	var subform_ids = ['if_expression_item_form', 'action_expression_item_form', 'sort_expression_items_form'];
	
	for (var i = 0; i < subform_ids.length; i++) {
	
		var subform = document.getElementById(subform_ids[i]);
	
		if (subform.style.display == 'block') {
			subform.style.display = 'none';
		}
	}

	subform_container.style.display = 'none';
	parent.top_frame.enable_top_frame(true);
	show_expression_pane(true);
}

// =======================
// if expression item form
// =======================

function new_if_expression_item() {

	item_index = (_if_expressions == null) ? 0 : _if_expressions.length;

	open_if_expression_item_form(false, item_index);
}

function open_if_expression_item_form(edit_existing_item, item_index) {

	var if_expression_item_form = document.getElementById('if_expression_item_form');
	var if_expression_log_field_list = document.getElementById('if_expression_log_field_list');
	var if_expression_literal_field = document.getElementById('if_expression_literal_field');
	var active_log_field;
	var active_operator;
	var subform_label;
	
	// set active item index of new item
	_active_expression_item_index = item_index;
	
	// parent.top_frame.enable_top_frame(false);
	// show_expression_pane(false);
	
	if (edit_existing_item) {
	
		active_log_field = _if_expressions[item_index].field;
		active_operator = _if_expressions[item_index].operator;
		if_expression_literal_field.value = _if_expressions[item_index].literal;
		subform_label = _edit_condition_subform_label;
	}
	else {
		active_log_field = _log_fields[0].name;
		active_operator = (_log_fields[0].type == 'string') ? _string_operators[0] : _numerical_operators[0];
		if_expression_literal_field.value = '';
		subform_label = _new_condition_subform_label;
	}
	
	// select active log field
	
		
	for (var i = 0; i < if_expression_log_field_list.length; i++) {
	
		var log_field = if_expression_log_field_list.options[i].value;
		var is_selected = (log_field == active_log_field) ? true : false;
		
		if_expression_log_field_list.options[i].selected = is_selected;
	}
	
	var active_log_field_type = _log_fields[active_log_field].type;
	var active_log_field_type_2 = _log_fields[active_log_field].type_2;
	
	build_if_expression_operator_list(active_operator, active_log_field_type, active_log_field_type_2);
	
	if_expression_item_form.style.display = 'block';
	
	open_subform(subform_label, process_if_expression_item_form);
}

function build_if_expression_operator_list(active_operator, active_log_field_type, active_log_field_type_2) {

	var operator_list = document.getElementById('if_expression_operator_list');
		
	operator_list.options.length = 0;
	
	var operators;
	
	if (active_log_field_type_2 != 'date_time') {
	
		if (active_log_field_type == 'string') {
		
			operators = _string_operators;
			_active_operator_list = 'string';
		}
		else {
		
			operators = _numerical_operators;
			_active_operator_list = 'numerical';
		}
	}
	else {
		operators = _date_time_operators;
		_active_operator_list = 'date_time';
	}
	
	for (var i = 0; i < operators.length; i++) {
	
		var operator = operators[i];
		
		// alert('Active operator: ' + active_operator + '\nOperator added to list: ' + operator + '\nis selected: ' + is_selected);
	
		operator_list.options[i] = new Option (_operator_labels[operator], operator, false, false);
	}
	
	// Note, we run a second loop through the options to select the active_operator.
	// When doing the obvious way by selecting an option within the new Option
	// in the above loop then IE selects the wrong option!
	
	for (var i = 0; i < operator_list.length; i++) {
	
		var operator = operator_list.options[i].value;
		
		if (operator == active_operator) {
		
			operator_list.options[i].selected = true;
		}
	}
}

function update_if_expression_operator_list(dat) {

	// invoked when changing a log field in the if_expression_item_form
	
	// if the log_field_type changes from string to numerical or to date_time
	// or vice versa then rebuild the operator list
	
	var active_log_field = dat.value;
	var active_log_field_type = _log_fields[active_log_field].type;
	var active_log_field_type_2 = _log_fields[active_log_field].type_2;
		
	if (active_log_field_type_2 != 'date_time') {
	
		if (active_log_field_type == 'string') {
		
			if (_active_operator_list != 'string') {
			
				build_if_expression_operator_list(_string_operators[0], active_log_field_type, active_log_field_type_2);
			}
		}
		else {
		
			if (_active_operator_list != 'numerical') {
			
				build_if_expression_operator_list(_numerical_operators[0], active_log_field_type, active_log_field_type_2);
			}
		}
	}
	else {
	
		if (_active_operator_list != 'date_time') {
		
			build_if_expression_operator_list(_date_time_operators[0], active_log_field_type, active_log_field_type_2);
		}
	}
}

function process_if_expression_item_form() {

	// Note, in some cases empty values and white spaces are allowed!

	var form_is_valid = false;

	var log_field_list = document.getElementById('if_expression_log_field_list');
	var operator_list = document.getElementById('if_expression_operator_list');
	var literal = document.getElementById('if_expression_literal_field').value;
	var log_field = log_field_list.options[log_field_list.selectedIndex].value;
	var operator = operator_list.options[operator_list.selectedIndex].value;
	
	var log_field_type = _log_fields[log_field].type;
	
	// check values depending on type of log field, string, int or float
	
	// if this is a new item add it to the end of the _if_expressions array
	// else replace the existing array
	// this is automatically done as the index array position
	// has been defined in _active_expression_item_index
	
	if (value_is_not_empty_msg(literal, _generic_is_empty_message)) {
	
		if ((operator == 'matches_regular_expression') || (operator == '!matches_regular_expression')) {
		
			if (validate_regexp(literal)) {
				form_is_valid = true;
			}
		}
		else if (operator.indexOf('epoc') != -1) {
		
			if(validate_date_time(literal)) {
				form_is_valid = true;
			}
		}
		else if (operator == '<now') {
		
			if (validate_number_of_days(literal)) {
				form_is_valid = true;
			}
		}
		else if (log_field_type == 'int') {
		
			if (validate_integer(literal)) {
				form_is_valid = true;
			}
		}
		else if (log_field_type == 'float') {
		
			if (validate_float(literal)) {
				form_is_valid = true;
			}
		}
		else {
		
			form_is_valid = true;
		}
	}
	
	if (form_is_valid) {
	
		_if_expressions[_active_expression_item_index] = {field:log_field, operator:operator, literal:literal};
	
		close_subform();
	}
}

// ===========================
// action expression item form
// ===========================

function new_action_expression_item(sub_expression_type) {

	var item_index;

	switch (sub_expression_type) {
			
		case 'then' :
			item_index = (_then_expressions == null) ? 0 : _then_expressions.length;
			break;
		
		case 'else' :
			item_index = (_else_expressions == null) ? 0 : _else_expressions.length;
			break;
			
		case 'do' :
			item_index = (_do_expressions == null) ? 0 : _do_expressions.length;
			break;
	}

	open_action_expression_item_form(sub_expression_type, false, item_index);
}

function open_action_expression_item_form(sub_expression_type, edit_existing_item, item_index) {

	var action_expression_item_form = document.getElementById('action_expression_item_form');
	var action_list = document.getElementById('action_list');
	var active_action;
	var subform_label;
	
	// set active sub expression type and array index of expression item
	_active_sub_expression_type = sub_expression_type;
	_active_expression_item_index = item_index;
	
	parent.top_frame.enable_top_frame(false);
	show_expression_pane(false);
	
	// reset the form to default values
	reset_action_expression_item_form();
	
	if (edit_existing_item) {
	
		subform_label = _edit_action_subform_label;
		
		switch (sub_expression_type) {
			
			case 'then' :
				active_action = preset_action_subform(_then_expressions[item_index]);
				break;
			
			case 'else' :
				active_action = preset_action_subform(_else_expressions[item_index]);
				break;
				
			case 'do' :
				active_action = preset_action_subform(_do_expressions[item_index]);
				break;
		}
	}
	else {
	
		subform_label = _new_action_subform_label;
		active_action = action_list.options[0].value;
	}
	
	// select active action
	
	for (var i = 0; i < action_list.length; i++) {
	
		var action = action_list.options[i].value;
		var is_selected = (action == active_action) ? true : false;
		action_list.options[i].selected = is_selected;
	}
	
	display_action_subform();
	
	action_expression_item_form.style.display = 'block';
	
	open_subform(subform_label, process_action_expression_item_form);
}

function reset_action_expression_item_form() {

	var action_expression_item_form = document.getElementById('action_expression_item_form');
	action_expression_item_form.reset();
	
	// reset the concatenate action subform
	
	for (var i = 1; i <= 4; i++) {
	
		var concatenate_type_list = document.getElementById('concatenate_type_list:' + i);
		var concatenate_value = document.getElementById('concatenate_value:' + i);
		var concatenate_log_field_list = document.getElementById('concatenate_log_field_list:' + i);
		
		concatenate_log_field_list.style.display = 'none';
		concatenate_value.style.display = 'block';
		
		if (i > 2) {
		
			concatenate_type_list.disabled = true;
			concatenate_value.disabled = true;
			concatenate_log_field_list.disabled = true;
		}
	}
	
	var concatenate_switch_4 = document.getElementById('concatenate_switch:4');
	concatenate_switch_4.disabled = true;
	
	// reset the match_regexp_copy action subform
	
	for (var i = 2; i <= 4; i++) {
	
		var match_regexp_copy_switch= document.getElementById('match_regexp_copy_switch:' + i);
		var match_regexp_copy_log_field_list = document.getElementById('match_regexp_copy_log_field_list:' + i);

		match_regexp_copy_log_field_list.disabled = true;
		
		if (i > 2) {
		
			match_regexp_copy_switch.disabled = true;
		}
	}
}

function preset_action_subform(expression) {

	// sets existing action expression item values when editing an expression item
	
	var action_type = expression.type;

	switch (action_type) {
				
		case 'concatenate' :
		
			var expression_details = expression.concatenate;
			var log_field = expression.log_field;
			
			for (var i = 0, j = 1; i < expression_details.length; i++, j++) {
			
				var is_log_field = expression_details[i].is_log_field;
				var literal = expression_details[i].literal;
				
				var concatenate_type_list = document.getElementById('concatenate_type_list:' + j);
				var concatenate_value = document.getElementById('concatenate_value:' + j);
				var concatenate_log_field_list = document.getElementById('concatenate_log_field_list:' + j);
				
				if (j > 2) {
				
					var concatenate_switch = document.getElementById('concatenate_switch:' + j);
					concatenate_switch.checked = true;
					concatenate_type_list.disabled = false;
					concatenate_value.disabled = false;
					concatenate_log_field_list.disabled = false;
					
					if (j == 3) {
					
						// then enable concatenate switch 4
						var concatenate_switch_4 = document.getElementById('concatenate_switch:4');
						concatenate_switch_4.disabled = false;
					}
				}
				
				if (is_log_field) {
				
					select_list_item('concatenate_type_list:' + j, 'log_field');
					concatenate_value.style.display = 'none';
					concatenate_log_field_list.style.display = 'block';
					select_list_item('concatenate_log_field_list:' + j, literal);
				}
				else {
					write_input_text('concatenate_value:' + j, literal);
				}
			}
			
			select_list_item('concatenate_log_field_list', log_field);
						
			break;
			
		case 'convert_to_lowercase' :
			
			select_list_item('convert_to_lowercase_log_field_list', expression.log_field);
			break;
			
		case 'convert_to_uppercase' :
			
			select_list_item('convert_to_uppercase_log_field_list', expression.log_field);
			break;

		case 'copy' :
		
			select_list_item('copy_log_field_list', expression.log_field);
			select_list_item('copy_target_log_field_list', expression.target_log_field);
			break;
		
		case 'match_regexp_copy' :
		
			select_list_item('match_regexp_copy_log_field_list', expression.log_field);
			write_input_text('match_regexp_copy_field', expression.literal);
		
			var match_regexp_copy_log_fields = expression.copy;
			
			for (var i = 1; i <= match_regexp_copy_log_fields.length; i++) {
			
				var match_regexp_copy_switch = document.getElementById('match_regexp_copy_switch:' + i);
				var match_regexp_copy_log_field_list = document.getElementById('match_regexp_copy_log_field_list:' + i);
				
				// don't alter the first match_regexp_copy_switch, it is always checked and disabled, its hidden!
				
				if (i > 1) {
		
					match_regexp_copy_switch.disabled = false;
					match_regexp_copy_switch.checked = true;
					match_regexp_copy_log_field_list.disabled = false;
				}
				
				select_list_item('match_regexp_copy_log_field_list:' + i, match_regexp_copy_log_fields[i-1].log_field);
			}
			
			if (match_regexp_copy_log_fields.length < 4) {
			
				// enable match_regexp_copy_switch of next row
				var j = match_regexp_copy_log_fields.length + 1;
				var match_regexp_copy_switch = document.getElementById('match_regexp_copy_switch:' + j);
				match_regexp_copy_switch.disabled = false;
			}
			break;

		case 'find_and_replace' :
		
			select_list_item('find_and_replace_log_field_list', expression.log_field);
			write_input_text('find_and_replace_literal_field', expression.literal);
			write_input_text('find_and_replace_literal_2_field', expression.literal_2);
			var replace_type = document.getElementById('find_and_replace_type:' + expression.replace_type);
			replace_type.checked = true;
			break;
			
		case 'set' :
		
			select_list_item('set_log_field_list', expression.log_field);
			write_input_text('set_literal_field', expression.literal);
			break;
	}

	return action_type;
}


function display_action_subform() {

	var action_list = document.getElementById('action_list');
	var selected_action = action_list.options[action_list.selectedIndex].value;
	var selected_action_subform = document.getElementById('action_subform:' + selected_action);
	
	
	// hide any displayed action subform
	
	for (var i = 0; i < _actions.length; i++) {
	
		var subform = document.getElementById('action_subform:' + _actions[i]);
		
		if (subform.style.display == 'block') {
		
			subform.style.display = 'none';
		}
	}
	
	// display selected action subform
	
	selected_action_subform.style.display = 'block';
}

function process_action_expression_item_form() {

	var action_list = document.getElementById('action_list');
	var selected_action = action_list.options[action_list.selectedIndex].value;
	var new_value = new Object();
	
	switch (selected_action) {
		
		case 'accept' :
			
			new_value = {type:'accept'};
			set_action_expression_item_value(new_value);
			break;
		
		case 'concatenate' :
		
			if (!validate_and_process_concatenate()) {
				return false;
			}
			break;
			
		case 'convert_to_lowercase' :

			var log_field = get_selected_list_item('convert_to_lowercase_log_field_list');
			new_value =  {type:'convert_to_lowercase', log_field:log_field};
			set_action_expression_item_value(new_value);
			break;
			
		case 'convert_to_uppercase' :
		
			var log_field = get_selected_list_item('convert_to_uppercase_log_field_list');
			new_value =  {type:'convert_to_uppercase', log_field:log_field};
			set_action_expression_item_value(new_value);
			break;

		case 'copy' :
		
			if (!validate_and_process_copy()) {
				return false;
			}
			break;
		
		case 'match_regexp_copy' :
		
			if (!validate_and_process_match_regexp_copy()) {
				return false;
			}
			break;

		case 'find_and_replace' :
		
			if (!validate_and_process_find_and_replace()) {
				return false;
			}
			break;
			
		case 'reject' :
		
			new_value = {type:'reject'};
			set_action_expression_item_value(new_value);
			break;
			
		case 'set' :
		
			if (!validate_and_process_set()) {
				return false;
			}
			break;
	}
	
	close_subform();
}

function validate_and_process_concatenate() {

	var concatenate_switch_3 = document.getElementById('concatenate_switch:3').checked;
	var concatenate_switch_4 = document.getElementById('concatenate_switch:4').checked;
	
	var number_of_items = 2;
	
	if (concatenate_switch_3) {
		number_of_items++;
		if (concatenate_switch_4) {
			number_of_items++;
		}
	}
	
	concatenate_object = new Object();
	concatenate_details = new Array();
	
	
	// concatenate obeject structure
	// _then_expressions[0] = {type:'concatenate', concatenate:[{is_log_field:false, literal: "xxx"}, {is_log_field:true,literal:'page'}], log_field:'page_2'};
	
	
	for (var i = 1; i <= number_of_items; i++) {
	
		var type_list = document.getElementById('concatenate_type_list:' + i);
		var selected_type = type_list.options[type_list.selectedIndex].value;
		
		if (selected_type == 'value') {
		
			var value = document.getElementById('concatenate_value:' + i).value;
			var msg = _concatenate_is_empty_message;
			msg = msg.replace(/__PARAM__1__/, _number_word[i]);
			
			if (value_is_not_empty_msg(value, msg)) {
						
				concatenate_details[i - 1] = {is_log_field:false, literal:value};
			}
			else {
				return false;
				break;
			}
		}
		else {
			// selected type is log field
			
			var log_field_list = document.getElementById('concatenate_log_field_list:' + i);
			var log_field = log_field_list.options[log_field_list.selectedIndex].value;
			
			concatenate_details[i - 1] = {is_log_field:true, literal:log_field};
		}
	}
	
	var log_field = get_selected_list_item('concatenate_log_field_list');
	
	concatenate_object = {type:'concatenate', concatenate:concatenate_details, log_field:log_field};
	
	set_action_expression_item_value(concatenate_object);
	
	return true;
}

function validate_and_process_copy() {

	var log_field = get_selected_list_item('copy_log_field_list');
	var target_log_field = get_selected_list_item('copy_target_log_field_list');
	
	if (log_field != target_log_field) {
	
		var source_type = _log_fields[log_field].type;
		var target_type = _log_fields[target_log_field].type;
				
		if ((source_type == 'string') && ((target_type == 'int') || (target_type == 'float'))) {
			
			alert(_msg_cannot_copy_string_to_numeric);
			return false;
		}
		else if ((source_type == 'float') && (target_type == 'int')) {
		
			alert(_msg_cannot_copy_float_to_int);
			return false;
		}
		else {
			
			var new_value =  {type:'copy', log_field:log_field, target_log_field:target_log_field};
			set_action_expression_item_value(new_value);
			return true;
		}
	}
	else {
	
		alert(_msg_cannot_copy_to_same_log_field);
		return false;
	}
}

function validate_and_process_match_regexp_copy() {

	var log_field = get_selected_list_item('match_regexp_copy_log_field_list');
	var literal = strip_whitespace(document.getElementById('match_regexp_copy_field').value);
	
	if (value_is_not_empty_msg(literal, _regexp_is_empty_message)) {
	
		if (validate_regexp(literal)) {
	
			var match_regexp_copy_object = new Object();
			var match_regexp_copy_log_fields = new Array();
			var duplicate_log_fields = false;
			
			for (var i = 1; i <= 4; i++) {
			
				var match_regexp_copy_switch = document.getElementById('match_regexp_copy_switch:' + i);
				var match_regexp_copy_log_field_list = document.getElementById('match_regexp_copy_log_field_list:' + i);
				var match_regexp_copy_log_field = match_regexp_copy_log_field_list.options[match_regexp_copy_log_field_list.selectedIndex].value;
				
				if (match_regexp_copy_switch.checked) {
				
					// verify that there are no duplicate log fields
				
					for (var k = 0; k < match_regexp_copy_log_fields.length; k++) {
					
						var existing_log_field = match_regexp_copy_log_fields[k].log_field;
					
						if (match_regexp_copy_log_field == existing_log_field) {
							
							duplicate_log_fields = true;
						}
					}
				
					match_regexp_copy_log_fields[i - 1] = {log_field:match_regexp_copy_log_field};
				}
			}
			
			if (!duplicate_log_fields) {
			
				// check for number of braces in regexp
				
				var braces_ok = false;
				
				var opening_braces = literal.match(/\(/g);
				var closing_braces = literal.match(/\)/g);
						
				// alert ('number_of_opening_braces: ' + opening_braces.length + 'number_of_closing_braces: ' + closing_braces.length);
						
				var number_of_opening_braces = (opening_braces != null) ? opening_braces.length : 0;
				var number_of_closing_braces = (closing_braces != null) ? closing_braces.length : 0;

				var number_of_braces = number_of_opening_braces;
				
				if (number_of_braces > number_of_closing_braces) {
				
					// then take the samller number of braces
					number_of_braces = number_of_closing_braces;
				}
				
				if (number_of_braces >= match_regexp_copy_log_fields.length) {
					
					braces_ok = true;
				}
				
				if (braces_ok) {
			
					match_regexp_copy_object = {type:'match_regexp_copy', log_field:log_field, literal:literal, copy:match_regexp_copy_log_fields};
					
					set_action_expression_item_value(match_regexp_copy_object);
				
					return true;
				}
				else {
				
					alert(_invalid_number_of_braces_in_match_regexp_copy);
				}
			}
			else {
			
				alert(_duplicate_log_fields_in_match_regexp_copy);
			}
		}
	}
	return false;
}

function validate_and_process_find_and_replace() {

	var log_field = get_selected_list_item('find_and_replace_log_field_list');
	var literal = document.getElementById('find_and_replace_literal_field').value;
	var literal_2 = document.getElementById('find_and_replace_literal_2_field').value;
	var replace_type;
	
	if (document.getElementById('find_and_replace_type:all').checked) {
		replace_type = 'all';
	}
	else if (document.getElementById('find_and_replace_type:first').checked) {
		replace_type = 'first';
	}
	else {
		replace_type = 'last';
	}
	
	if (value_is_not_empty_msg(literal, _generic_is_empty_message)) {
	
		// Note, literal_2 can be empty, which means to omitt any match!
	
		if (literal_2 == null) {literal_2 = '';}
		
		var new_value = {type:'find_and_replace', log_field:log_field, literal:literal, literal_2:literal_2, replace_type:replace_type};
	
		set_action_expression_item_value(new_value);

		return true;
	}
	
	return false;
}

function validate_and_process_set() {

	// allow value to be empty!

	var form_is_valid = false;

	var log_field = get_selected_list_item('set_log_field_list');
	var literal = document.getElementById('set_literal_field').value;
	var log_field_type = _log_fields[log_field].type;
	
	var value_is_empty = (literal == '') ? true : false;
	
	
	if (literal == null) {
		literal = '';
		form_is_valid = true;
	}
	else {
	
		if (log_field_type == 'int') {
			if (validate_integer(literal)) {
				form_is_valid = true;
			}
		}
		else if (log_field_type == 'float') {
			if (validate_float(literal)) {
				form_is_valid = true;
			}
		}
		else {
		
			form_is_valid = true;
		}
	}
	
	if (form_is_valid) {
	
		var new_value =  {type:'set', log_field:log_field, literal:literal};
		set_action_expression_item_value(new_value);
		return true;
	}
	
	return false;
}

function set_action_expression_item_value(new_value) {

	// _if_expressions[_active_expression_item_index] = {field:log_field, operator:operator, literal:literal};
	
	switch (_active_sub_expression_type) {
		
		case 'then' :
			_then_expressions[_active_expression_item_index] = new_value;
			// alert('number of _then_expressions: ' + _then_expressions.length);
			break;
		
		case 'else' :
			_else_expressions[_active_expression_item_index] = new_value;
			// alert('number of _else_expressions: ' + _else_expressions.length);
			break;
			
		case 'do' :
			_do_expressions[_active_expression_item_index] = new_value;
			// alert('number of _do_expressions: ' + _do_expressions.length);
			break;
	}
}

function write_input_text(element_id, text) {

	var text_field = document.getElementById(element_id);
	text_field.value = text;
}

function select_list_item(element_id, value_to_select) {

	var the_list = document.getElementById(element_id);
	
	for (var i = 0; i < the_list.length; i++) {
	
		var list_value = the_list[i].value;
		var is_selected = (list_value == value_to_select) ? true : false;
	
		the_list[i].selected = is_selected;
	}
}

function get_selected_list_item(element_id) {

	var the_list = document.getElementById(element_id);
	
	return the_list.options[the_list.selectedIndex].value;
}


// ========================
// action subforms handling
// ========================

// ===========
// concatenate
// ===========

function set_concatenate_type(id) {

	var concatenate_type_list = document.getElementById('concatenate_type_list:' + id);
	var selected_type = concatenate_type_list.options[concatenate_type_list.selectedIndex].value;

	var value_field = document.getElementById('concatenate_value:' + id);
	var log_field_list = document.getElementById('concatenate_log_field_list:' + id);
	
	if (selected_type == 'value') {
	
		log_field_list.style.display = 'none';
		value_field.style.display = 'block';
	}
	else {
		value_field.style.display = 'none';
		log_field_list.style.display = 'block';
	}
}

function toggle_concatenate_segment(element,id) {

	var is_checked = element.checked;
	
	switch_concatenate_segment(is_checked, id);
	
	// handle the 4th concatenate switch, it will be only available if concatenate switch 3 is checked
	
	if (id == 3) {
	
		var concatenate_switch_4 = document.getElementById('concatenate_switch:4');

		if (is_checked) {
		
			// enable switch 4
			
			concatenate_switch_4.disabled = false;
		}
		else {
		
			// disable switch 4
			
			if (concatenate_switch_4.checked) {
			
				concatenate_switch_4.checked = false;
				switch_concatenate_segment(false, 4);
			}
			
			concatenate_switch_4.disabled = true;
		}
	}
}

function switch_concatenate_segment(is_checked, id) {

	var concatenate_type_list = document.getElementById('concatenate_type_list:' + id);
	var value_field = document.getElementById('concatenate_value:' + id);
	var log_field_list = document.getElementById('concatenate_log_field_list:' + id);
	
	concatenate_type_list.disabled = !is_checked;
	value_field.disabled = !is_checked;
	log_field_list.disabled = !is_checked;
}

function switch_match_regexp_copy(element, id) {
	
	var is_checked = element.checked;
	var log_field_list = document.getElementById('match_regexp_copy_log_field_list:' + id);
	
	if (is_checked) {
	
		log_field_list.disabled = false;
		
		if (id < 4) {
		
			// enable the checkbox for the next item
			
			var next_checkbox = document.getElementById('match_regexp_copy_switch:' + (id + 1));
		
			next_checkbox.disabled = false;
		}
		
	}
	else {

		log_field_list.disabled = true;
		
		// disable and reset any following checkboxes and lists
		
		if (id < 4) {
		
			for (var i = (id + 1); i <= 4; i++) {
			
				var check_box = document.getElementById('match_regexp_copy_switch:' + i);
				var log_field_list = document.getElementById('match_regexp_copy_log_field_list:' + i);
				
				check_box.checked = false;
				check_box.disabled = true;
				log_field_list.disabled = true;
			}
		}
	}
}

// ================================
// expression validation uitilities
// ================================

function validate_date_time(literal) {

	var match_result = literal.match(/^[0-3]{1}[0-9]{1}\/{1}(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec){1}\/{1}[0-9]{4}\s{1}[0-2]{1}[0-9]{1}\:{1}[0-5]{1}[0-9]{1}\:{1}[0-5]{1}[0-9]{1}$/);
	
	if ((literal.length == 20) && (match_result != null)) {
		return true;
	}
	alert(_invalid_date_time_message);
	return false;
}

function validate_float(literal) {

	if (value_is_number(literal)) {
		return true;
	}
	alert(_invalid_number_message);
	return false;
}

function validate_integer(literal) {

	if (value_is_integer(literal)) {
		return true;
	}
	alert(_invalid_integer_message);
	return false;
}

function validate_number_of_days(literal) {

	if (value_is_integer(literal) && literal > 0) {
	
		return true;
	}
	alert(_invalid_number_of_days_message);
	return false;
}

function validate_regexp(literal) {

	try {
		var i = new RegExp(literal);
		return true;
	}
	catch(e) {
		alert(_invalid_regexp_message);
		return false;
	}
}

// ================
// sort log filters
// ================

function update_log_filter_label_in_sort_list(label) {

	// initiated from top frame upon editing the log filter label

	var sort_log_filters_list = document.getElementById('sort_log_filters_list');

	for (var i = 0; i < sort_log_filters_list.length; i++) {
	
		if (sort_log_filters_list.options[i].value == _lf_name) {
		
			// strip label length
			
			if (label.length > 70) {
		
				label = label.substr(0,70) + ' ...';
			}

			sort_log_filters_list.options[i].text = label;
		}	
	}
}

function move_log_filter_via_keys(event) {

	var key_code = (event.which) ? event.which : event.keyCode;
	
	// alert(key_code);

	if (key_code == 45) {
		move_log_filter('down');
	}
	
	if (key_code == 43) {
		move_log_filter('up');
	}
}

function move_log_filter(direction) {

	var sort_log_filters_list = document.getElementById('sort_log_filters_list');
	var selected_index = sort_log_filters_list.selectedIndex;
	
	if (selected_index != -1) {
	
		var target_index = (direction == 'up') ? selected_index - 1 : selected_index + 1;
	
		if ((target_index >= 0) && (target_index <= sort_log_filters_list.length - 1)) {
		
			// deselect item
			sort_log_filters_list.options[selected_index].selected = false;
			
			// replace items
			var selected_value = sort_log_filters_list.options[selected_index].value;
			var selected_text = sort_log_filters_list.options[selected_index].text;
			var target_value = sort_log_filters_list.options[target_index].value;
			var target_text = sort_log_filters_list.options[target_index].text;
		
			sort_log_filters_list.options[selected_index].value = target_value;
			sort_log_filters_list.options[selected_index].text = target_text;
			sort_log_filters_list.options[target_index].value = selected_value;
			sort_log_filters_list.options[target_index].text = selected_text;
			
			// select moved item
			sort_log_filters_list.options[target_index].selected = true;
		}
	}
	else {
		alert(_msg_no_list_item_selected);
	}
}

// ============
// process form
// ============

function process_form() {

	var expression_type = get_selected_list_item('expression_type_list');
	var expression_is_valid = false;
	
	// ====================
	// validate expressions
	// ====================
	
	switch (expression_type) {

		case 'conditional' :
		
			if (_if_expressions.length > 0) {
				if (_then_expressions.length > 0) {
					if (validate_boolean_operator()) {
					
						expression_is_valid = true;
					}
				}
				else {
					alert(_no_then_expression_message);
				}
			}
			else {
				alert(_no_if_expression_message);
			}
			break;
			
		case 'action' :
		
			if (_do_expressions.length > 0) {
				expression_is_valid = true;
			}
			else {
				alert(_no_action_message);
			}
			
			break;
	
		case 'advanced' :
		
			var lf_expression = strip_whitespace(document.getElementById('lf_expression').value);
			lf_expression = lf_expression.replace(/[\$]/g, '_DOL_');

			if (validate_lf_expression(lf_expression)) {
				expression_is_valid = true;
			}
			break;
	}

	if (expression_is_valid) {
	
		var lf_label = strip_whitespace(parent.top_frame.document.getElementById('lf_label').value);
		lf_label = lf_label.replace(/[\$]/g, '_DOL_As_Text_');

		if (validate_lf_label(lf_label)) {
		
			var lf_disabled = parent.top_frame.document.getElementById('lf_on_off').checked ? false : true;
	
			var lf_comment = strip_whitespace(document.getElementById('lf_comment').value);
			lf_comment = lf_comment.replace(/[\$]/g, '_DOL_As_Text_');
			lf_comment = lf_comment.replace(/\n/g, '__HexEsc__0A'); // Newline
			lf_comment = lf_comment.replace(/\r/g, ''); // Carriage return
						
			var volatile_path = 'volatile.form_processing';
			
			new_hfe(volatile_path + '.form_type', _form_type);
			new_hfe(volatile_path + '.lf_disabled', lf_disabled);
			new_hfe(volatile_path + '.lf_name', _lf_name);
			new_hfe(volatile_path + '.lf_label', lf_label);
			new_hfe(volatile_path + '.lf_comment', lf_comment);
			
			build_log_filter_positions_hfe();
			// new_hfe(volatile_path + '.lf_position', _lf_index);
			
			new_hfe(volatile_path + '.expression_type', expression_type);

			switch (expression_type) {
		
				case 'conditional' :
				
					build_if_expressions_hfe();
					build_action_expressions_hfe('then');
					
					if ((document.getElementById('show_else_expression_btn').checked) &&
						(_else_expressions.length > 0)) {
						build_action_expressions_hfe('else');
					}
					break;
					
				case 'action' :
					
					build_action_expressions_hfe('do');
					break;
			
				case 'advanced' :
				
					new_hfe('volatile.form_processing.lf_expression', lf_expression);
					break;
			}
			
			return true;
		}
	}
	
	return false;
}

function validate_lf_label(lf_label) {

	if (value_is_not_empty(lf_label)) {
		return true;
	}

	alert(_no_log_filter_name_msg);
	return false;
}

function validate_lf_expression(lf_expression) {

	if (value_is_not_empty(lf_expression)) {
		return true;
	}

	alert(_no_expression_msg);
	return false;
}

function validate_boolean_operator() {

	if (document.getElementById('boolean_custom_btn').checked) {
	
		var boolean_operator_sequence = strip_whitespace(document.getElementById('custom_boolean_operator_field').value);
		
		if (!validate_boolean_operator_sequence(boolean_operator_sequence)) {
		
			return false;
		}
	}
	
	return true;
}

function validate_boolean_operator_sequence(boolean_operator_sequence) {

	if (value_is_not_empty_msg(boolean_operator_sequence, _no_boolean_operator_sequence_message)) {
	
		var number_of_items = _if_expressions.length;
		
		generate_expression_ids(number_of_items);
		
		var sequence_string_ok = true;
		var clean_sequence_string_ok = true;
		var id_match_1_ok = true;
		var id_match_2_ok = true;
		
		var number_of_or_operators = 0;
		var number_of_and_operators = 0;
		
		// ----------------------------------------
		// validate Boolean operator seqence string
		// ----------------------------------------
		
		var sequence_split = boolean_operator_sequence.split(' ');
		
		// NOTE, if a substring only contains a brace then remove it, i.e. if the sequence is written as
		// ( A and B ) or ( C and D ) would result in boolean_operator_sequence_split = [(, A, and, B, ), or ...
		
		var clean_sequence_split = new Array();
		
		var character_pattern = new RegExp('([' + _expression_ids_pattern + ']|' + _or_word + '|' + _and_word + ')', 'g');
		
		var invalid_character_pattern = new RegExp('[^\s\(\)]', 'g'); // match anything than ' ', '(', ')'
		
		// alert('character_pattern: ' + character_pattern);
		
		for (var i = 0; i < sequence_split.length; i++) {
		
			var split_item = sequence_split[i];
			
			var character_match_result = split_item.match(character_pattern);
			
			// alert('split_item: ' + split_item + '\ncharacter_match_result: ' + character_match_result);
			
			
			if (character_match_result != null) {
			
				// item contains valid id character or "or" or "and" word
				clean_sequence_split[clean_sequence_split.length] = split_item;
			}
			else {
			
				// check if item contains spaces and braces only, if it contains anything
				// else then the the sequence is not valid
				
				var invalid_character_match_result = split_item.match(invalid_character_pattern);
			
				if (invalid_character_match_result != null) {
				
					invalid_boolean_operator_sequence_msg(split_item);
					sequence_string_ok = false;
					break;
				}
			}
		}
		
		// alert('clean_sequence_split: ' + clean_sequence_split);
		
		if (sequence_string_ok) {
		
			// -------------------------------------------------
			// Clean the clean_sequence_split form any remaining
			// braces and spaces around valid characters
			// -------------------------------------------------
						
			for (var i = 0; i < clean_sequence_split.length; i++) {
			
				clean_sequence_split[i] = clean_sequence_split[i].replace(/\(/g, '');
				clean_sequence_split[i] = clean_sequence_split[i].replace(/\)/g, '');
				clean_sequence_split[i] = clean_sequence_split[i].replace(/\s/g, '');
			}
	
			// alert('clean_sequence_split: ' + clean_sequence_split);
			
			// Make sure that the last entry is not a "or" or "and" operator
			// This can be checked by the array length, which must be an even number
			
			if (clean_sequence_split.length == ((number_of_items * 2) - 1)) {
			
				// ----------------------------------------------------------
				// check characters and sequence in clean_sequence_split,
				// save character ids in new expression_ids_in_sequence array
				// ----------------------------------------------------------
				
				var expression_ids_in_sequence = new Array();
				
				for (var i = 0; i < clean_sequence_split.length; i++) {
				
					// cleaned up sequence is [A, or, B, and, C, or, ...
					// each even number must be an id, each odd number a operator
					
					var item = clean_sequence_split[i];
					
					if ((i % 2) == 0) {
					
						// alert('item: ' + item + '\n_expression_ids_by_char: ' + _expression_ids_by_char[item]);
					
						if (_expression_ids_by_char[item] == null) {
						
							invalid_boolean_operator_sequence_msg(item);
							clean_sequence_string_ok = false;
							break;
						}
						
						// write item to expression_ids_in_sequence to compare array with original ids
						
						expression_ids_in_sequence[expression_ids_in_sequence.length] = item;
					}
					else {
					
						if (item == _or_word) {
						
							number_of_or_operators++;
						}
						else if (item == _and_word) {
						
							number_of_and_operators++;
						}
						else {
						
							invalid_boolean_operator_sequence_msg(item);
							clean_sequence_string_ok = false;
							break;
						}
					}
				}
			}
			else {
				alert(_invalid_boolean_operator_sequence_ids_message);
				clean_sequence_string_ok = false;
			}
			
			if (clean_sequence_string_ok) {
			
				// ---------------------------------------------
				// check if custom boolean operator sequence ids
				// matches the character ids as in if expression
				// ---------------------------------------------

				// sort expression_ids_in_sequence
				
				expression_ids_in_sequence = sort_boolean_expression_ids_in_sequence(expression_ids_in_sequence);
				
				// alert('Sorted validated expression ids: ' + expression_ids_in_sequence);
				
				for (var i = 0; i < expression_ids_in_sequence.length; i++) {
				
					if (expression_ids_in_sequence[i] != _expression_ids_by_index[i]) {
					
						alert('The id "' + expression_ids_in_sequence[i] + '" does not exist in the if expression.');
						id_match_1_ok = false;
						break;
					}
				}
				
				if (id_match_1_ok) {
				
					// as above but vice versa
				
					for (var i = 0; i < _expression_ids_by_index.length; i++) {
				
						if (_expression_ids_by_index[i] != expression_ids_in_sequence[i]) {
						
							alert('The id "' + _expression_ids_by_index[i] + '" does not exist in the custom boolean operator sequence.');
							id_match_2_ok = false;
							break;
						}
					}
					
					if (id_match_2_ok) {
					
						// ---------------
						// validate braces
						// ---------------
						
						var number_of_braces_ok = false;
						var braces_order_ok = false;
						
						// alert('number_of_or_operators: ' + number_of_or_operators + '\nnumber_of_and_operators: ' + number_of_and_operators);
	
						var opening_braces = boolean_operator_sequence.match(/\(/g);
						var closing_braces = boolean_operator_sequence.match(/\)/g);
						
						// alert ('number_of_opening_braces: ' + opening_braces.length + 'number_of_closing_braces: ' + closing_braces.length);
						
						var number_of_opening_braces = (opening_braces != null) ? opening_braces.length : 0;
						var number_of_closing_braces = (closing_braces != null) ? closing_braces.length : 0;
					
						if (number_of_opening_braces == number_of_closing_braces) {
						
							number_of_braces_ok = true;
						}
						else {
						
							alert(_invalid_braces_number_in_boolean_operator_sequence_message);
						}
						
						if (number_of_braces_ok) {
						
							// Note, braces are optional, even with mixed boolean operators!
							// I.e.: "A or B and C or D" is valid.

							
							if (number_of_opening_braces > 0) {
							
								// ---------------------
								// validate braces order
								// ---------------------
							
								var braces_match_result = boolean_operator_sequence.match(/[\(\)]/g);

								// alert('braces_match_result: ' + braces_match_result);
								
								var braces_string = braces_match_result.join();
								braces_string = braces_string.replace(/,/g, '');
								
								// alert('braces_string: ' + braces_string);
								
								var valide_braces_pair = true;
								
								while (valide_braces_pair) {
								
									// each iteration removes one braces pair
									// braces are valid if result is an empty string
								
									var brace_pairs_match_result = braces_string.match(/(\(\)){1}/); // match 1 braces pair ()
								
									if (brace_pairs_match_result != null) {
									
										braces_string = braces_string.replace(/(\(\)){1}/, '');
									}
									else {
									
										valide_braces_pair = false;
									}
								}
								
								// alert('braces_string: ' + braces_string);
								
								if (braces_string == '') {
									
										braces_order_ok = true;
								}
								else {
										alert(_invalid_braces_order_in_boolean_operator_sequence_message);
								}
							}
							else {
							
								braces_order_ok = true;
							}
							
							if (braces_order_ok) {
							
								process_boolean_operator_sequence(sequence_split);
								return true;
							
							} // if braces_order_ok
						
						} // if number_of_braces_ok
						
					} // if id_match_2_ok
				
				} // if id_match_1_ok
								
			} // if clean_sequence_string_ok
		
		} // if sequence_string_ok
		
	} // if value is not empty

	return false;
}

function invalid_boolean_operator_sequence_msg(item) {

	var msg = _invalid_boolean_operator_sequence_message;
	msg = msg.replace(/__PARAM__1__/, item);
	alert(msg);
}

function sort_boolean_expression_ids_in_sequence(expression_ids_in_sequence) {

	// sort() wont work because result would be A, AA, AAA, B, BB, BBB instead of A, B, AA, BB, AAA, BBB, etc.
	
	var new_sequence = new Array;
	
	expression_ids_in_sequence.sort();
	
	var max_length_of_item = 0;
	
	for (var i = 0; i < expression_ids_in_sequence.length; i++) {
	
		if (expression_ids_in_sequence[i].length > max_length_of_item) {
			max_length_of_item = expression_ids_in_sequence[i].length;
		}
	}
	
	for (var k = 1; k <= max_length_of_item; k++) {
		
		for (var i = 0; i < expression_ids_in_sequence.length; i++) {
	
			if (expression_ids_in_sequence[i].length == k) {
			
				new_sequence[new_sequence.length] = expression_ids_in_sequence[i];
			}
		}
	}

	// alert('new_sequence: ' + new_sequence);

	return new_sequence;
}

function process_boolean_operator_sequence(sequence_split) {

	var final_sequence = '';
	
	for (var i = 0; i < sequence_split.length; i++) {

		var item_value = sequence_split[i];
		var character_pattern = new RegExp('[' + _expression_ids_pattern + ']', 'g');
		var character_match_result = item_value.match(character_pattern);
		
		// alert('item_value before: ' + item_value);
	
		if (character_match_result != null) {
		
			// this must be an id
		
			if (character_match_result.length > 1) {
			
				character_match_result = character_match_result.join();
				character_match_result = character_match_result.replace(/,/g, '');
			}
			
			var id = _expression_ids_by_char[character_match_result];
			id = '__IntEsc__' + id + '__';
			
			// alert('character_match_result: ' + character_match_result + '\nid: ' + id);
			
			var id_replace_pattern = new RegExp(character_match_result);
			
			item_value = item_value.replace(id_replace_pattern, id);
				
		}
		
		// alert('item_value after: ' + item_value);
		
		final_sequence += item_value;
	}
	
	// clean up final sequence
	
	final_sequence = final_sequence.replace(/\s/g, '');
	
	var or_pattern = new RegExp(_or_word , 'g');
	var and_pattern = new RegExp(_and_word , 'g');
	
	final_sequence = final_sequence.replace(or_pattern, ' or ');
	final_sequence = final_sequence.replace(and_pattern, ' and ');

	// alert('final boolean operator sequence: ' + final_sequence);

	_modified_boolean_operator_sequence = final_sequence;
}

function build_log_filter_positions_hfe() {

	var sort_list = document.getElementById('sort_log_filters_list');
	
	for (var i = 0; i < sort_list.length; i++) {
	
		// log filter position is equal i
	
		var log_filter_name = sort_list.options[i].value;
	
		new_hfe('volatile.form_processing.log_filter_positions.' + log_filter_name, i);
	}
}

function build_if_expressions_hfe() {

	var boolean_operator;
	var boolean_operator_sequence = '';
	
	if (document.getElementById('boolean_custom_btn').checked) {
	
		boolean_operator = 'custom';
	}
	else if (document.getElementById('boolean_and_btn').checked) {
	
		boolean_operator = 'and';
	}
	else {
	
		boolean_operator = 'or';
	}
	
	if (boolean_operator == 'custom') {
	
		boolean_operator_sequence = _modified_boolean_operator_sequence;
	}
	
	new_hfe('volatile.form_processing.boolean_operator', boolean_operator);
	new_hfe('volatile.form_processing.boolean_operator_sequence', boolean_operator_sequence);
	
	for (var i = 0; i < _if_expressions.length; i++) {
	
		var volatile_path = 'volatile.form_processing.if_expressions.' + i;
		
		new_hfe(volatile_path + '.log_field', _if_expressions[i].field);
		new_hfe(volatile_path + '.operator', _if_expressions[i].operator);
		new_hfe(volatile_path + '.literal', _if_expressions[i].literal);
	}
}

function build_action_expressions_hfe(sub_expression_type) {

	var expressions;
		
	switch (sub_expression_type) {
		
		case 'then' :
			expressions = _then_expressions;
			break;
			
		case 'else' :
			expressions = _else_expressions;
			break;
			
		case 'do' :
			expressions = _do_expressions;
			break;
	}
	
	for (var i = 0; i < expressions.length; i++) {
	
		var action_type = expressions[i].type;
		
		var volatile_path = 'volatile.form_processing.' + sub_expression_type + '_expressions.' + i;
		
		new_hfe(volatile_path + '.type', action_type);
	
		switch (action_type) {
			
			case 'concatenate' :
			
				new_hfe(volatile_path + '.log_field', expressions[i].log_field);
			
				var concatenate_details = expressions[i].concatenate;
				
				for (var k = 0; k < concatenate_details.length; k++) {
				
					var is_log_field = concatenate_details[k].is_log_field;
					var literal = concatenate_details[k].literal;
				
					new_hfe(volatile_path + '.concatenate.' + k + '.is_log_field', is_log_field);
					new_hfe(volatile_path + '.concatenate.' + k + '.literal', literal);
				}
				break;
				
			case 'convert_to_lowercase' :
			
				new_hfe(volatile_path + '.log_field', expressions[i].log_field);
				break;
				
			case 'convert_to_uppercase' :
			
				new_hfe(volatile_path + '.log_field', expressions[i].log_field);
				break;
	
			case 'copy' :
				
				new_hfe(volatile_path + '.log_field', expressions[i].log_field);
				new_hfe(volatile_path + '.target_log_field', expressions[i].target_log_field);
				break;
			
			case 'match_regexp_copy' :
			
				new_hfe(volatile_path + '.log_field', expressions[i].log_field);
				new_hfe(volatile_path + '.literal', expressions[i].literal);
							
				var match_regexp_copy_log_fields = expressions[i].copy;
				
				for (var k = 0; k < match_regexp_copy_log_fields.length; k++) {
				
					var log_field = match_regexp_copy_log_fields[k].log_field;
				
					new_hfe(volatile_path + '.copy.' + k + '.log_field', log_field);
				}
				break;
	
			case 'find_and_replace' :
				
				new_hfe(volatile_path + '.log_field', expressions[i].log_field);
				new_hfe(volatile_path + '.literal', expressions[i].literal);
				new_hfe(volatile_path + '.literal_2', expressions[i].literal_2);
				new_hfe(volatile_path + '.replace_type', expressions[i].replace_type);
				break;
				
			case 'set' :
				
				new_hfe(volatile_path + '.log_field', expressions[i].log_field);
				new_hfe(volatile_path + '.literal', expressions[i].literal);
				break;
		}
	}
}

function new_hfe(name, value) { // new hidden form element

	var sys_form = parent.top_frame.document.getElementById('sys_form');
	new_element = parent.top_frame.document.createElement('input');
	new_element.type = 'hidden';
	new_element.name = name;
	new_element.value = value;
	sys_form.appendChild(new_element);
}
