// js document

var _progress_meter_position = 0;
var _number_of_steps;
var _progress_is_complete = false;
var _complete_progress_is_active = false;

/*
This part has been moved to build_progress_page.cfv
to handle the progress debug window.

var _progress_debug_window_opened = false; has been moved to build_progress_page.cfv!

window.onload = init_events;

function init_events() {

	// set progress bar to 0
	var element = document.getElementById('progress_meter');
	element.style.width = 0 + 'px';
	
	// if task_operation is "report_with_db_progress" we
	// need to hide the left reports menu!
	
	if (_task_operation == 'report_with_db_progress') {
		
		parent.hide_report_menu();
	}

	get_task_state();
}
*/

function get_task_state() {

	var url = '?dp+templates.shared.task_progress.get_progress_state';
	url += '+p+' + _profile_name;
	url += '+volatile.task_operation+' + _task_operation;
	url += '+volatile.task_id+' + _task_id;
	
	if (_task_operation == 'report') {
	
		url += '+volatile.report_id+' + _report_id;
	}

	return call_to_server(url);
	// location.replace(url);
	
}

function server_response_task_state(dat) { // update the progress bar and all values
	/* task state array structure
	dat = [
		[suboperation_description, progress_meter_position],
		[steps state ...],	active | done | todo
		[steps time_elapsed ...],
		[steps time_remaining ...],
		[steps percent_complete ...],
		[detail values ...]
		[detail labels ...]
		]
	*/

	// alert('server_response_ok');

	var current_step_label = dat[0][0];
	var suboperation_description = dat[0][1];
	// _progress_meter_position = parseInt(dat[0][2]);
	_progress_meter_position = dat[0][2];
	var time_elapsed_total = dat[0][3];
	var progress_debug_window_active = dat[0][4];
	var progress_debug_node_name = dat[0][5];
	var task_is_active = dat[0][6];
	var steps_state = dat[1];
	_number_of_steps = dat[1].length;
	var steps_time_elapsed = dat[2];
	var steps_time_remaining = dat[3];
	var steps_percent_complete = dat[4];
	var detail_values = dat[5];
	var detail_labels = dat[6];
	
	// alert(task_is_active);
	
	// set minor task label
	set_progress_value('minor_task_label', suboperation_description);
	
	// In case that the progress step node is missing this code block
	// opens a progress debug window which shows the progress node
	// Note, the debug window will be shown only once per progress session
	
	/* Debug has been disabled
	if (progress_debug_window_active && !_progress_debug_window_opened) {
		
		open_debug_window(_profile_name, progress_debug_node_name);
		_progress_debug_window_opened = true;
	}
	*/
	
	// set progress meter
	set_progress_meter();

	// =====================================================
	// set current step title if there is more than one step
	// =====================================================
	
	// alert('number of steps: ' + _number_of_steps);
	
	if (_number_of_steps > 1) {
	
		set_progress_value('current_step_label', current_step_label);

		// set steps state images
		
		for (var i = 0; i < steps_state.length; i++) {
		
			var todo_img = document.getElementById('todo_img_' + i);
			var active_img = document.getElementById('active_img_' + i);
			var done_img = document.getElementById('done_img_' + i);
			
			if ((todo_img != null) && (active_img != null) && (done_img != null)) {
			
				if (steps_state[i] == 'active') {
				
					if (active_img.style.display != 'block') {
					
						todo_img.style.display = 'none';
						active_img.style.display = 'block';
					}
				}
				else if (steps_state[i] == 'done') {
				
					if (done_img.style.display != 'block') {
					
						if (todo_img.style.display == 'block') {
							todo_img.style.display = 'none';
						}
						else if (active_img.style.display == 'block') {
							active_img.style.display = 'none'
						}
						
						done_img.style.display = 'block';
					}
				}
			}
		}

		// set steps perecent complete
		for (var i = 0; i < steps_percent_complete.length; i++) {
		
			var percent_complete_id = 'percent_complete_' + i;
			set_progress_value(percent_complete_id, steps_percent_complete[i] + '%');
		}

		// set steps total elapsed time	
		if (steps_state.length > 1) {
		
			set_progress_value('time_elapsed_total', time_elapsed_total);
		}
	}

	// set steps elapsed time
	for (var i=0; i < steps_time_elapsed.length; i++) {
	
		var time_elapsed_id = 'time_elapsed_' + i;
		set_progress_value(time_elapsed_id, steps_time_elapsed[i]);
	}

	// set steps remaining time 
	for (var i=0; i < steps_time_remaining.length; i++) {
	
		var time_remaining_id = 'time_remaining_' + i;
		set_progress_value(time_remaining_id, steps_time_remaining[i]);
	}

	// ==========================================
	// create processing detail labels and values
	// ==========================================

	clear_details_container();

	if (detail_labels.length >= 1) {

		for (var i = 0; i < detail_labels.length; i++) {
			build_details_row(detail_labels[i], detail_values[i]);
		}

		// show details header if not yet shown
		var details_header = document.getElementById('details_header');
		if (details_header.style.display != 'block') {
			details_header.style.display = 'block';
		}
	}

	// set the get_task_state() interval depending on the number of steps
	// IE has a problem with a high number of steps and needs a greater interval
	
	var time_out_interval = 1200;
	
	if (_number_of_steps > 10) {
	
		// Increment the time_out_interval 20 milliseconds for each step
		
		time_out_interval += _number_of_steps * 20;
	}
	
	
	// ----------------
	// set final action
	// ----------------
	
	if (verify_task_activity(task_is_active)) {
	
		setTimeout('get_task_state()', time_out_interval);
	}
	else {
		
		show_task_error();
	}
}

function verify_task_activity(task_is_active) {
	
	// get_progress_state.cfv returns task_is_active, if it is false
	// we increase the _number_of_failed_tasks.
	// If task_is_active failed several times we show the task error page.
	// We don't show the task error page earlier to avoid any overlapping
	// in case that progress just completes and the task completes as well.
	
	if (!task_is_active) {
		
		_number_of_failed_tasks++;
	}
	
	// alert('task_is_active: ' + task_is_active + '\n_number_of_failed_tasks: ' + _number_of_failed_tasks);
	
	if (_number_of_failed_tasks > 5) {

		return false;
	}
	
	return true;
}

function clear_details_container() {

	var tbody = document.getElementById('details_container');

	while (tbody.lastChild != null) {
		var i = tbody.lastChild;
		tbody.removeChild(i);
	}
}

function build_details_row(label, value) {

	var tbody = document.getElementById('details_container');
	var tr = document.createElement('tr');

	var td_a = document.createElement('td');
	var text_a = document.createTextNode(label);
	td_a.appendChild(text_a);

	var td_b = document.createElement('td');
	var text_b = document.createTextNode(value);
	td_b.appendChild(text_b);
	td_b.className = 'r';
	
	tr.appendChild(td_a);
	tr.appendChild(td_b);

	tbody.appendChild(tr);
}

function set_progress_meter() {

	var progress_meter = document.getElementById('progress_meter');
	var bar_length_new = _progress_meter_position * 3 // progress meter position is 1-100, bar length = 300px
	progress_meter.style.width = bar_length_new + 'px';
	set_progress_value('progress_bar_value', _progress_meter_position + '%');
}

function set_progress_value(element_id, value) {

	var element = document.getElementById(element_id);
	
	// check for element existence due the possibility that
	// the volatile.progress.step node is missing
	
	if (element != null) {
	
		var new_value = document.createTextNode(value);
		element.replaceChild(new_value, element.firstChild);
	}
}

function complete_progress() {

	_complete_progress_is_active = true;

	if (_progress_meter_position < 100) {
		//_progress_meter_position++;
		//_progress_meter_position = (_progress_meter_position > 100) ? 100 : _progress_meter_position;
		_progress_meter_position = 100;
		set_progress_meter();
		setTimeout('complete_progress()', 4);
	}
	else {
		
		for (var i=0; i < _number_of_steps; i++) {

			if (_number_of_steps > 1) {
				// set steps state images
				var done_img = document.getElementById('done_img_' + i);
				
				if ((done_img != null) && (done_img.style.display != 'block')) {
				
					var todo_img = document.getElementById('todo_img_' + i);
					var active_img = document.getElementById('active_img_' + i);
				
					if (todo_img.style.display == 'block') {
						todo_img.style.display = 'none';
					}
					else if (active_img.style.display == 'block') {
						active_img.style.display = 'none';
					}
					
					done_img.style.display = 'block';
				}
	
				// set steps perecent complete
				var percent_complete_id = 'percent_complete_' + i;
				set_progress_value(percent_complete_id, '100.00%');
			}
			// set remaining time
			var time_remaining_id = 'time_remaining_' + i;
			set_progress_value(time_remaining_id, '00:00:00');
		}

		setTimeout('complete_progress_final()', 1000);
	}
}

function complete_progress_final() {
	_progress_is_complete = true;
}

function server_response_task_complete() {

	// alert('task complete via sys_form');
	
	if (!_complete_progress_is_active) {
		complete_progress();
	}
	
	if (_progress_is_complete) {
		
		// If this is a Rebuild or Update database from reports view then activate
		// switch_reports_config() to startover with the reports startup
				
		if ((_task_operation == 'update_database' ||
			_task_operation == 'rebuild_database') &&
			parent.top_frame._display_reports) {

			parent.top_frame.switch_reports_config(true);
		}
		else {
			
			var sys_form = document.getElementById('sys_form');
			sys_form.submit();
		}
	}
	else {
		setTimeout('server_response_task_complete()', 100);
	}
}

function show_task_error() {
	
	// The task is not anymore active or does not anymore exist, show error message
	
	var url = '?dp+templates.shared.error_handling.error';
	url += '+p+' + _profile_name;
	url += '+volatile.error_progress_task+true';

	location.replace(url);
}

function toggle_processing_details() {
	
	var details_title = document.getElementById('details_title');
	var show_details = document.getElementById('show_details');
	var hide_details = document.getElementById('hide_details');
	var details = document.getElementById('details');
	

	if (details.style.display == 'none') {
		show_details.style.display = 'none';
		hide_details.style.display = 'block';
		details_title.style.display = 'block';
		details.style.display = 'block';
	}
	else {
		hide_details.style.display = 'none';
		details.style.display = 'none';
		details_title.style.display = 'none';
		show_details.style.display = 'block';
	}
}

function refresh_progress() {
	
	// change url of sysform in current progress page!
	
	var progress_container = document.getElementById('progress_container');
	var loading_document_info = document.getElementById('loading_document_info');
	
	var sys_form = document.getElementById('sys_form');
	var url = '?dp+templates.shared.task_progress.refresh_progress'
	url += '+p+' + _profile_name;
	sys_form.action = url;
	
	progress_container.style.display = 'none';
	loading_document_info.style.display = 'block';
	
	sys_form.submit();
}

function cancel_task() {

	if (confirm(_confirm_cancel_task_msg)) {

		var url = '?dp+templates.shared.task_progress.cancel_task';
		url += '+p+' + _profile_name;
		url += '+volatile.task_id+' + _task_id;
		url += '+volatile.major_task_label+' + _major_task_label;
		
		// alert(url);
		
		location.replace(url);
	}
	
	return false;
}