// js document

function switch_reports_config(display_reports) {

	_display_reports = display_reports;

	var left_frame_url;
	var main_frame_url;

	update_reports_config_switch_and_toolbar();

	if (_display_reports) {

		left_frame_url = '?dp+templates.statistics.left_navigation';
		main_frame_url = '?dp+templates.statistics.prime_setup';
		
		parent.document.title = parent._reports_document_title;
	}
	else {

		left_frame_url = '?dp+templates.config.left_navigation';
		main_frame_url = '?dp+templates.config.profile_summary.profile_summary';
		
		parent.document.title = parent._config_document_title;
		
	}

	left_frame_url += '+p+' + _profile_name;

	main_frame_url += '+p+' + _profile_name;
	
	// alert('main_frame_url:\n' + main_frame_url);

	parent.left_frame.location.href = left_frame_url;
	parent.main_frame.location.href = main_frame_url;

	return false;
}

function update_reports_config_switch_and_toolbar() {

	var reports_led = document.getElementById('reports_led');
	var config_led = document.getElementById('config_led');
	var reports_toolbar = document.getElementById('reports_toolbar');
	var reports_toolbar_right = document.getElementById('reports_toolbar_right');
	var config_toolbar = document.getElementById('config_toolbar');

	var on_color = '#77BF73';
	var off_color = '#979797';

	// before setting the led color check if the led exists

	if (reports_led != null) {

		if (_display_reports) {

			config_led.style.backgroundColor = off_color;
			reports_led.style.backgroundColor = on_color;

			reports_toolbar.style.display = 'none';
			config_toolbar.style.display = 'none';
			
			if (reports_toolbar_right != null) {
			
				reports_toolbar_right.style.display = 'none';
			}
			
		}
		else {

			reports_led.style.backgroundColor = off_color;
			config_led.style.backgroundColor = on_color;

			reports_toolbar.style.display = 'none';
			reports_toolbar_right.style.display = 'none';
			config_toolbar.style.display = 'block';
		}
	}
}


function set_date_time_button_state() {

	// if date_time exists enable calendar and date_range button
	// else disable the calendar and date range buttom
	
	var calendar_btn = document.getElementById('calendar_btn');
	var calendar_disabled_btn = document.getElementById('calendar_disabled_btn');
	var date_range_btn = document.getElementById('date_range_btn');
	var date_range_disabled_btn = document.getElementById('date_range_disabled_btn');
	
	// var date_range_btn = document.getElementById('date_range_btn');

	var date_time_exists = parent.main_frame._date_time_exists;
	
	calendar_btn.style.display = 'none';
	calendar_disabled_btn.style.display = 'none';
	date_range_btn.style.display = 'none';
	date_range_disabled_btn.style.display = 'none';
	
	if (date_time_exists) {
	
		calendar_btn.style.display = 'block';
		date_range_btn.style.display = 'block';
	}
	else {
	
		calendar_disabled_btn.style.display = 'block';
		date_range_disabled_btn.style.display = 'block';
	}

}

function open_date_range_picker() {

	var width = 440;
    var height = 300;
	var window_name = 'date_range_picker';
	var url = '?dp+templates.statistics.date_range_picker.date_range_picker';
	url += '+p+' + _profile_name;

	open_window(url, window_name, width, height);
}

function open_calendar() {

	var width = 760;
    var height = 440;
	var window_name = 'calendar';
	var url = '?dp+templates.statistics.calendar.calendar';
	url += '+p+' + _profile_name;

	open_window(url, window_name, width, height);
}

function open_global_filter_editor() {

	var width = 700;
    var height = 400;
	var window_name = 'filter_editor';
	var url = '?dp+templates.statistics.global_filter.filter_editor';
	url += '+p+' + _profile_name;
	url += '+volatile.global_filter_is_active+' + _global_filter_is_active;

	open_window(url, window_name, width, height);
}

function set_global_filter(element) {

	var filter_on_off_img = document.getElementById('filter_on_off_img');

	// Note, the image is changed in another function via setTimeout, this
	// dealy is required so that IE which displays the image correctly.

	if (_global_filter_is_active) {
		_global_filter_is_active = false;
		setTimeout('set_global_filter_on_off_image()', 5);
	}
	else {
		_global_filter_is_active = true;
		setTimeout('set_global_filter_on_off_image()', 5);
	}
}

function set_global_filter_on_off_image() {

	var filter_on_off_img = document.getElementById('filter_on_off_img');
	
	if (_global_filter_is_active) {
		filter_on_off_img.src = _img_ref['tb_global_filter_on'].src;
	}
	else {
		filter_on_off_img.src = _img_ref['tb_global_filter_off'].src;
	}
}

function open_window(url, window_name, width, height) {
	
	// disable_opener_window();
	// var content = document.getElementById('content');
	// content.onclick = set_focus_on_form_window;
	
	var left = parseInt((screen.availWidth/2) - (width/2));
    var top = parseInt((screen.availHeight/2) - (height/2));
	_window = window.open(url,window_name,'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',status=yes,scrollbars=yes,resizable=yes');
	_window.focus();
	
	// _window_closed_poll = setInterval('check_if_form_window_closed()', 200);
}

function switch_zoom_tab(zoom_tab) {

	if (zoom_tab) {
		parent.left_frame._zoom_is_active = true;
	}
	else {
		parent.left_frame._zoom_is_active = false;
	}
}

function update_or_rebuild_database(element, database_action) {

	// hide report and reports toolbar buttons
	
	document.getElementById('reports_toolbar').style.display = 'none';
	parent.hide_report();
	
	var url = '?dp+templates.config.';
	
	if (database_action == 'update') {
	
		url += 'update_database.update_database';
	}
	else {
	
		url += 'rebuild_database.rebuild_database';
	}
	
	url += '+p+' + _profile_name;
	
	element.href = url;
	element.target = 'main_frame';
}


function open_print_report() {

	var width = 800;
    var height = 500;
	var window_name = 'print_report';
	var url = '?dp+templates.statistics.print_report.print_report';
	url += '+volatile.report_id+' + parent.main_frame._report_id;
	url += '+p+' + _profile_name;
		
	var left = parseInt((screen.availWidth/2) - (width/2));
    var top = parseInt((screen.availHeight/2) - (height/2));

	_window = window.open(url,window_name,'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',menubar=yes,status=yes,scrollbars=yes,resizable=yes');
	_window.focus();
}